/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.UnknownContentCode;

public class UnknownContentCodeEnumFactory
implements EnumFactory<UnknownContentCode> {
    @Override
    public UnknownContentCode fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("no".equals(codeString)) {
            return UnknownContentCode.NO;
        }
        if ("extensions".equals(codeString)) {
            return UnknownContentCode.EXTENSIONS;
        }
        if ("elements".equals(codeString)) {
            return UnknownContentCode.ELEMENTS;
        }
        if ("both".equals(codeString)) {
            return UnknownContentCode.BOTH;
        }
        throw new IllegalArgumentException("Unknown UnknownContentCode code '" + codeString + "'");
    }

    @Override
    public String toCode(UnknownContentCode code) {
        if (code == UnknownContentCode.NULL) {
            return null;
        }
        if (code == UnknownContentCode.NO) {
            return "no";
        }
        if (code == UnknownContentCode.EXTENSIONS) {
            return "extensions";
        }
        if (code == UnknownContentCode.ELEMENTS) {
            return "elements";
        }
        if (code == UnknownContentCode.BOTH) {
            return "both";
        }
        return "?";
    }

    @Override
    public String toSystem(UnknownContentCode code) {
        return code.getSystem();
    }
}

