/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum TaskStatus {
    DRAFT,
    REQUESTED,
    RECEIVED,
    ACCEPTED,
    REJECTED,
    READY,
    INPROGRESS,
    ONHOLD,
    FAILED,
    COMPLETED,
    NULL;


    public static TaskStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("draft".equals(codeString)) {
            return DRAFT;
        }
        if ("requested".equals(codeString)) {
            return REQUESTED;
        }
        if ("received".equals(codeString)) {
            return RECEIVED;
        }
        if ("accepted".equals(codeString)) {
            return ACCEPTED;
        }
        if ("rejected".equals(codeString)) {
            return REJECTED;
        }
        if ("ready".equals(codeString)) {
            return READY;
        }
        if ("in-progress".equals(codeString)) {
            return INPROGRESS;
        }
        if ("on-hold".equals(codeString)) {
            return ONHOLD;
        }
        if ("failed".equals(codeString)) {
            return FAILED;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        throw new FHIRException("Unknown TaskStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DRAFT: {
                return "draft";
            }
            case REQUESTED: {
                return "requested";
            }
            case RECEIVED: {
                return "received";
            }
            case ACCEPTED: {
                return "accepted";
            }
            case REJECTED: {
                return "rejected";
            }
            case READY: {
                return "ready";
            }
            case INPROGRESS: {
                return "in-progress";
            }
            case ONHOLD: {
                return "on-hold";
            }
            case FAILED: {
                return "failed";
            }
            case COMPLETED: {
                return "completed";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/task-status";
    }

    public String getDefinition() {
        switch (this) {
            case DRAFT: {
                return "The task is not yet ready to be acted upon.";
            }
            case REQUESTED: {
                return "The task is ready to be acted upon";
            }
            case RECEIVED: {
                return "A potential performer has claimed ownership of the task and is evaluating whether to perform it";
            }
            case ACCEPTED: {
                return "The potential performer has agreed to execute the task but has not yet started work";
            }
            case REJECTED: {
                return "The potential performer who claimed ownership of the task has decided not to execute it prior to performing any action.";
            }
            case READY: {
                return "Task is ready to be performed, but no action has yet been taken.  Used in place of requested/received/accepted/rejected when request assignment and acceptance is a given.";
            }
            case INPROGRESS: {
                return "Task has been started but is not yet complete.";
            }
            case ONHOLD: {
                return "Task has been started but work has been paused";
            }
            case FAILED: {
                return "The task was attempted but could not be completed due to some error.";
            }
            case COMPLETED: {
                return "The task has been completed (more or less) as requested.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DRAFT: {
                return "Draft";
            }
            case REQUESTED: {
                return "Requested";
            }
            case RECEIVED: {
                return "Received";
            }
            case ACCEPTED: {
                return "Accepted";
            }
            case REJECTED: {
                return "Rejected";
            }
            case READY: {
                return "Ready";
            }
            case INPROGRESS: {
                return "In Progress";
            }
            case ONHOLD: {
                return "On Hold";
            }
            case FAILED: {
                return "Failed";
            }
            case COMPLETED: {
                return "Completed";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

