/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.TaskPerformerType;

public class TaskPerformerTypeEnumFactory
implements EnumFactory<TaskPerformerType> {
    @Override
    public TaskPerformerType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("requester".equals(codeString)) {
            return TaskPerformerType.REQUESTER;
        }
        if ("dispatcher".equals(codeString)) {
            return TaskPerformerType.DISPATCHER;
        }
        if ("scheduler".equals(codeString)) {
            return TaskPerformerType.SCHEDULER;
        }
        if ("performer".equals(codeString)) {
            return TaskPerformerType.PERFORMER;
        }
        if ("monitor".equals(codeString)) {
            return TaskPerformerType.MONITOR;
        }
        if ("manager".equals(codeString)) {
            return TaskPerformerType.MANAGER;
        }
        if ("acquirer".equals(codeString)) {
            return TaskPerformerType.ACQUIRER;
        }
        if ("reviewer".equals(codeString)) {
            return TaskPerformerType.REVIEWER;
        }
        throw new IllegalArgumentException("Unknown TaskPerformerType code '" + codeString + "'");
    }

    @Override
    public String toCode(TaskPerformerType code) {
        if (code == TaskPerformerType.NULL) {
            return null;
        }
        if (code == TaskPerformerType.REQUESTER) {
            return "requester";
        }
        if (code == TaskPerformerType.DISPATCHER) {
            return "dispatcher";
        }
        if (code == TaskPerformerType.SCHEDULER) {
            return "scheduler";
        }
        if (code == TaskPerformerType.PERFORMER) {
            return "performer";
        }
        if (code == TaskPerformerType.MONITOR) {
            return "monitor";
        }
        if (code == TaskPerformerType.MANAGER) {
            return "manager";
        }
        if (code == TaskPerformerType.ACQUIRER) {
            return "acquirer";
        }
        if (code == TaskPerformerType.REVIEWER) {
            return "reviewer";
        }
        return "?";
    }

    @Override
    public String toSystem(TaskPerformerType code) {
        return code.getSystem();
    }
}

