/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum SupplyrequestStatus {
    REQUESTED,
    COMPLETED,
    FAILED,
    CANCELLED,
    NULL;


    public static SupplyrequestStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("requested".equals(codeString)) {
            return REQUESTED;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("failed".equals(codeString)) {
            return FAILED;
        }
        if ("cancelled".equals(codeString)) {
            return CANCELLED;
        }
        throw new FHIRException("Unknown SupplyrequestStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case REQUESTED: {
                return "requested";
            }
            case COMPLETED: {
                return "completed";
            }
            case FAILED: {
                return "failed";
            }
            case CANCELLED: {
                return "cancelled";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/supplyrequest-status";
    }

    public String getDefinition() {
        switch (this) {
            case REQUESTED: {
                return "Supply has been requested, but not dispensed.";
            }
            case COMPLETED: {
                return "Supply has been received by the requestor.";
            }
            case FAILED: {
                return "The supply will not be completed because the supplier was unable or unwilling to supply the item.";
            }
            case CANCELLED: {
                return "The orderer of the supply cancelled the request.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case REQUESTED: {
                return "Requested";
            }
            case COMPLETED: {
                return "Received";
            }
            case FAILED: {
                return "Failed";
            }
            case CANCELLED: {
                return "Cancelled";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

