/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ServicePharmacy {
    SMOKECESS,
    FLUSHOT,
    NULL;


    public static ServicePharmacy fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("smokecess".equals(codeString)) {
            return SMOKECESS;
        }
        if ("flushot".equals(codeString)) {
            return FLUSHOT;
        }
        throw new FHIRException("Unknown ServicePharmacy code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SMOKECESS: {
                return "smokecess";
            }
            case FLUSHOT: {
                return "flushot";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/ex-pharmaservice";
    }

    public String getDefinition() {
        switch (this) {
            case SMOKECESS: {
                return "Smoking cessation";
            }
            case FLUSHOT: {
                return "Flu Shot";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SMOKECESS: {
                return "Smoking cessation";
            }
            case FLUSHOT: {
                return "Flu Shot";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

