/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.SelectionBehavior;

public class SelectionBehaviorEnumFactory
implements EnumFactory<SelectionBehavior> {
    @Override
    public SelectionBehavior fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("any".equals(codeString)) {
            return SelectionBehavior.ANY;
        }
        if ("all".equals(codeString)) {
            return SelectionBehavior.ALL;
        }
        if ("all-or-none".equals(codeString)) {
            return SelectionBehavior.ALLORNONE;
        }
        if ("exactly-one".equals(codeString)) {
            return SelectionBehavior.EXACTLYONE;
        }
        if ("at-most-one".equals(codeString)) {
            return SelectionBehavior.ATMOSTONE;
        }
        if ("one-or-more".equals(codeString)) {
            return SelectionBehavior.ONEORMORE;
        }
        throw new IllegalArgumentException("Unknown SelectionBehavior code '" + codeString + "'");
    }

    @Override
    public String toCode(SelectionBehavior code) {
        if (code == SelectionBehavior.NULL) {
            return null;
        }
        if (code == SelectionBehavior.ANY) {
            return "any";
        }
        if (code == SelectionBehavior.ALL) {
            return "all";
        }
        if (code == SelectionBehavior.ALLORNONE) {
            return "all-or-none";
        }
        if (code == SelectionBehavior.EXACTLYONE) {
            return "exactly-one";
        }
        if (code == SelectionBehavior.ATMOSTONE) {
            return "at-most-one";
        }
        if (code == SelectionBehavior.ONEORMORE) {
            return "one-or-more";
        }
        return "?";
    }

    @Override
    public String toSystem(SelectionBehavior code) {
        return code.getSystem();
    }
}

