/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.RequiredBehavior;

public class RequiredBehaviorEnumFactory
implements EnumFactory<RequiredBehavior> {
    @Override
    public RequiredBehavior fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("must".equals(codeString)) {
            return RequiredBehavior.MUST;
        }
        if ("could".equals(codeString)) {
            return RequiredBehavior.COULD;
        }
        if ("must-unless-documented".equals(codeString)) {
            return RequiredBehavior.MUSTUNLESSDOCUMENTED;
        }
        throw new IllegalArgumentException("Unknown RequiredBehavior code '" + codeString + "'");
    }

    @Override
    public String toCode(RequiredBehavior code) {
        if (code == RequiredBehavior.NULL) {
            return null;
        }
        if (code == RequiredBehavior.MUST) {
            return "must";
        }
        if (code == RequiredBehavior.COULD) {
            return "could";
        }
        if (code == RequiredBehavior.MUSTUNLESSDOCUMENTED) {
            return "must-unless-documented";
        }
        return "?";
    }

    @Override
    public String toSystem(RequiredBehavior code) {
        return code.getSystem();
    }
}

