/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ProcedureProgressStatusCodes {
    A,
    B,
    C,
    D,
    E,
    F,
    NULL;


    public static ProcedureProgressStatusCodes fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("a".equals(codeString)) {
            return A;
        }
        if ("b".equals(codeString)) {
            return B;
        }
        if ("c".equals(codeString)) {
            return C;
        }
        if ("d".equals(codeString)) {
            return D;
        }
        if ("e".equals(codeString)) {
            return E;
        }
        if ("f".equals(codeString)) {
            return F;
        }
        throw new FHIRException("Unknown ProcedureProgressStatusCodes code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case A: {
                return "a";
            }
            case B: {
                return "b";
            }
            case C: {
                return "c";
            }
            case D: {
                return "d";
            }
            case E: {
                return "e";
            }
            case F: {
                return "f";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/procedure-progress-status-code";
    }

    public String getDefinition() {
        switch (this) {
            case A: {
                return "A patient is in the Operating Room.";
            }
            case B: {
                return "The patient is prepared for a procedure.";
            }
            case C: {
                return "The patient is under anesthesia.";
            }
            case D: {
                return "";
            }
            case E: {
                return "";
            }
            case F: {
                return "The patient is in the recovery room.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case A: {
                return "In Operating Room";
            }
            case B: {
                return "Prepared";
            }
            case C: {
                return "Anesthesia induced";
            }
            case D: {
                return "Opened (skin)";
            }
            case E: {
                return "Closed (skin)";
            }
            case F: {
                return "In Recovery Room";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

