/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum NehtaNehtaStainType {
    NOTTESTED,
    NORMALSTAINING,
    LOSSOFSTAINING,
    NULL;


    public static NehtaNehtaStainType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("not_tested".equals(codeString)) {
            return NOTTESTED;
        }
        if ("normal_staining".equals(codeString)) {
            return NORMALSTAINING;
        }
        if ("loss_of_staining".equals(codeString)) {
            return LOSSOFSTAINING;
        }
        throw new FHIRException("Unknown NehtaNehtaStainType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case NOTTESTED: {
                return "not_tested";
            }
            case NORMALSTAINING: {
                return "normal_staining";
            }
            case LOSSOFSTAINING: {
                return "loss_of_staining";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/nehta-stain-type";
    }

    public String getDefinition() {
        switch (this) {
            case NOTTESTED: {
                return "The mismathch repair enzyne was not tested";
            }
            case NORMALSTAINING: {
                return "The mismatch repair enzyme had normal staining";
            }
            case LOSSOFSTAINING: {
                return "The gene mutation was not tested";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case NOTTESTED: {
                return "Not tested";
            }
            case NORMALSTAINING: {
                return "Normal Staining";
            }
            case LOSSOFSTAINING: {
                return "Not tested";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

