/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ModuleMetadataType {
    MODULE,
    LIBRARY,
    DECISIONSUPPORTRULE,
    DOCUMENTATIONTEMPLATE,
    ORDERSET,
    NULL;


    public static ModuleMetadataType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("module".equals(codeString)) {
            return MODULE;
        }
        if ("library".equals(codeString)) {
            return LIBRARY;
        }
        if ("decision-support-rule".equals(codeString)) {
            return DECISIONSUPPORTRULE;
        }
        if ("documentation-template".equals(codeString)) {
            return DOCUMENTATIONTEMPLATE;
        }
        if ("order-set".equals(codeString)) {
            return ORDERSET;
        }
        throw new FHIRException("Unknown ModuleMetadataType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case MODULE: {
                return "module";
            }
            case LIBRARY: {
                return "library";
            }
            case DECISIONSUPPORTRULE: {
                return "decision-support-rule";
            }
            case DOCUMENTATIONTEMPLATE: {
                return "documentation-template";
            }
            case ORDERSET: {
                return "order-set";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/module-metadata-type";
    }

    public String getDefinition() {
        switch (this) {
            case MODULE: {
                return "The resource is a description of a knowledge module";
            }
            case LIBRARY: {
                return "The resource is a shareable library of formalized knowledge";
            }
            case DECISIONSUPPORTRULE: {
                return "An Event-Condition-Action Rule Artifact";
            }
            case DOCUMENTATIONTEMPLATE: {
                return "A Documentation Template Artifact";
            }
            case ORDERSET: {
                return "An Order Set Artifact";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case MODULE: {
                return "Module";
            }
            case LIBRARY: {
                return "Library";
            }
            case DECISIONSUPPORTRULE: {
                return "Decision Support Rule";
            }
            case DOCUMENTATIONTEMPLATE: {
                return "Documentation Template";
            }
            case ORDERSET: {
                return "Order Set";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

