/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.MessageSignificanceCategory;

public class MessageSignificanceCategoryEnumFactory
implements EnumFactory<MessageSignificanceCategory> {
    @Override
    public MessageSignificanceCategory fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("Consequence".equals(codeString)) {
            return MessageSignificanceCategory.CONSEQUENCE;
        }
        if ("Currency".equals(codeString)) {
            return MessageSignificanceCategory.CURRENCY;
        }
        if ("Notification".equals(codeString)) {
            return MessageSignificanceCategory.NOTIFICATION;
        }
        throw new IllegalArgumentException("Unknown MessageSignificanceCategory code '" + codeString + "'");
    }

    @Override
    public String toCode(MessageSignificanceCategory code) {
        if (code == MessageSignificanceCategory.NULL) {
            return null;
        }
        if (code == MessageSignificanceCategory.CONSEQUENCE) {
            return "Consequence";
        }
        if (code == MessageSignificanceCategory.CURRENCY) {
            return "Currency";
        }
        if (code == MessageSignificanceCategory.NOTIFICATION) {
            return "Notification";
        }
        return "?";
    }

    @Override
    public String toSystem(MessageSignificanceCategory code) {
        return code.getSystem();
    }
}

