/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ConformanceResourceStatus {
    DRAFT,
    ACTIVE,
    RETIRED,
    NULL;


    public static ConformanceResourceStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("draft".equals(codeString)) {
            return DRAFT;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("retired".equals(codeString)) {
            return RETIRED;
        }
        throw new FHIRException("Unknown ConformanceResourceStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DRAFT: {
                return "draft";
            }
            case ACTIVE: {
                return "active";
            }
            case RETIRED: {
                return "retired";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/conformance-resource-status";
    }

    public String getDefinition() {
        switch (this) {
            case DRAFT: {
                return "This resource is still under development.";
            }
            case ACTIVE: {
                return "This resource is ready for normal use.";
            }
            case RETIRED: {
                return "This resource has been withdrawn or superseded and should no longer be used.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DRAFT: {
                return "Draft";
            }
            case ACTIVE: {
                return "Active";
            }
            case RETIRED: {
                return "Retired";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

