/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.BenefitType;

public class BenefitTypeEnumFactory
implements EnumFactory<BenefitType> {
    @Override
    public BenefitType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("deductable".equals(codeString)) {
            return BenefitType.DEDUCTABLE;
        }
        if ("visit".equals(codeString)) {
            return BenefitType.VISIT;
        }
        if ("copay".equals(codeString)) {
            return BenefitType.COPAY;
        }
        if ("vision-exam".equals(codeString)) {
            return BenefitType.VISIONEXAM;
        }
        if ("vision-glasses".equals(codeString)) {
            return BenefitType.VISIONGLASSES;
        }
        if ("vision-contacts".equals(codeString)) {
            return BenefitType.VISIONCONTACTS;
        }
        if ("medical-primarycare".equals(codeString)) {
            return BenefitType.MEDICALPRIMARYCARE;
        }
        if ("pharmacy-dispense".equals(codeString)) {
            return BenefitType.PHARMACYDISPENSE;
        }
        throw new IllegalArgumentException("Unknown BenefitType code '" + codeString + "'");
    }

    @Override
    public String toCode(BenefitType code) {
        if (code == BenefitType.NULL) {
            return null;
        }
        if (code == BenefitType.DEDUCTABLE) {
            return "deductable";
        }
        if (code == BenefitType.VISIT) {
            return "visit";
        }
        if (code == BenefitType.COPAY) {
            return "copay";
        }
        if (code == BenefitType.VISIONEXAM) {
            return "vision-exam";
        }
        if (code == BenefitType.VISIONGLASSES) {
            return "vision-glasses";
        }
        if (code == BenefitType.VISIONCONTACTS) {
            return "vision-contacts";
        }
        if (code == BenefitType.MEDICALPRIMARYCARE) {
            return "medical-primarycare";
        }
        if (code == BenefitType.PHARMACYDISPENSE) {
            return "pharmacy-dispense";
        }
        return "?";
    }

    @Override
    public String toSystem(BenefitType code) {
        return code.getSystem();
    }
}

