/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AllergyIntoleranceCategory {
    FOOD,
    MEDICATION,
    ENVIRONMENT,
    OTHER,
    NULL;


    public static AllergyIntoleranceCategory fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("food".equals(codeString)) {
            return FOOD;
        }
        if ("medication".equals(codeString)) {
            return MEDICATION;
        }
        if ("environment".equals(codeString)) {
            return ENVIRONMENT;
        }
        if ("other".equals(codeString)) {
            return OTHER;
        }
        throw new FHIRException("Unknown AllergyIntoleranceCategory code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case FOOD: {
                return "food";
            }
            case MEDICATION: {
                return "medication";
            }
            case ENVIRONMENT: {
                return "environment";
            }
            case OTHER: {
                return "other";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/allergy-intolerance-category";
    }

    public String getDefinition() {
        switch (this) {
            case FOOD: {
                return "Any substance consumed to provide nutritional support for the body.";
            }
            case MEDICATION: {
                return "Substances administered to achieve a physiological effect.";
            }
            case ENVIRONMENT: {
                return "Substances that are encountered in the environment.";
            }
            case OTHER: {
                return "Other substances that are not covered by any other category.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case FOOD: {
                return "Food";
            }
            case MEDICATION: {
                return "Medication";
            }
            case ENVIRONMENT: {
                return "Environment";
            }
            case OTHER: {
                return "Other";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

