/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Annotation;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Location;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Device", profile="http://hl7.org/fhir/Profile/Device")
public class Device
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Instance identifier", formalDefinition="Unique instance identifiers assigned to a device by manufacturers other organizations or owners.")
    protected List<Identifier> identifier;
    @Child(name="udiCarrier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Unique Device Identifier (UDI) Barcode string", formalDefinition="[Unique device identifier (UDI)](device.html#5.11.3.2.2) barcode or rfid string assigned to device label or package.")
    protected Identifier udiCarrier;
    @Child(name="status", type={CodeType.class}, order=2, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="available | not-available | entered-in-error", formalDefinition="Status of the Device availability.")
    protected Enumeration<DeviceStatus> status;
    @Child(name="type", type={CodeableConcept.class}, order=3, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="What kind of device this is", formalDefinition="Code or identifier to identify a kind of device.")
    protected CodeableConcept type;
    @Child(name="lotNumber", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Lot number of manufacture", formalDefinition="Lot number assigned by the manufacturer.")
    protected StringType lotNumber;
    @Child(name="manufacturer", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Name of device manufacturer", formalDefinition="A name of the manufacturer.")
    protected StringType manufacturer;
    @Child(name="manufactureDate", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Date when the device was made", formalDefinition="The date and time when the device was manufactured.")
    protected DateTimeType manufactureDate;
    @Child(name="expirationDate", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Date and time of expiry of this device (if applicable)", formalDefinition="The date and time beyond which this device is no longer valid or should not be used (if applicable).")
    protected DateTimeType expirationDate;
    @Child(name="model", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Model id assigned by the manufacturer", formalDefinition="The \"model\" is an identifier assigned by the manufacturer to identify the product by its type. This number is shared by the all devices sold as the same type.")
    protected StringType model;
    @Child(name="version", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Version number (i.e. software)", formalDefinition="The version of the device, if the device has multiple releases under the same model, or if the device is software or carries firmware.")
    protected StringType version;
    @Child(name="patient", type={Patient.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Patient to whom Device is affixed", formalDefinition="Patient information, If the device is affixed to a person.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="owner", type={Organization.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Organization responsible for device", formalDefinition="An organization that is responsible for the provision and ongoing maintenance of the device.")
    protected Reference owner;
    protected Organization ownerTarget;
    @Child(name="contact", type={ContactPoint.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Details for human/organization for support", formalDefinition="Contact details for an organization or a particular human that is responsible for the device.")
    protected List<ContactPoint> contact;
    @Child(name="location", type={Location.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Where the resource is found", formalDefinition="The place where the device can be found.")
    protected Reference location;
    protected Location locationTarget;
    @Child(name="url", type={UriType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Network address to contact device", formalDefinition="A network address on which the device may be contacted directly.")
    protected UriType url;
    @Child(name="note", type={Annotation.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Device notes and comments", formalDefinition="Descriptive information, usage information or implantation information that is not captured in an existing element.")
    protected List<Annotation> note;
    private static final long serialVersionUID = -710362206L;
    @SearchParamDefinition(name="organization", path="Device.owner", description="The organization responsible for the device", type="reference")
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("Device:organization").toLocked();
    @SearchParamDefinition(name="model", path="Device.model", description="The model of the device", type="string")
    public static final String SP_MODEL = "model";
    public static final StringClientParam MODEL = new StringClientParam("model");
    @SearchParamDefinition(name="patient", path="Device.patient", description="Patient information, if the resource is affixed to a person", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Device:patient").toLocked();
    @SearchParamDefinition(name="udicarrier", path="Device.udiCarrier", description="Barcode string (udi)", type="token")
    public static final String SP_UDICARRIER = "udicarrier";
    public static final TokenClientParam UDICARRIER = new TokenClientParam("udicarrier");
    @SearchParamDefinition(name="location", path="Device.location", description="A location, where the resource is found", type="reference")
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("Device:location").toLocked();
    @SearchParamDefinition(name="manufacturer", path="Device.manufacturer", description="The manufacturer of the device", type="string")
    public static final String SP_MANUFACTURER = "manufacturer";
    public static final StringClientParam MANUFACTURER = new StringClientParam("manufacturer");
    @SearchParamDefinition(name="type", path="Device.type", description="The type of the device", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="identifier", path="Device.identifier", description="Instance id from manufacturer, owner, and others", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="url", path="Device.url", description="Network address to contact device", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");

    public Device() {
    }

    public Device(CodeableConcept type) {
        this.type = type;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Device addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getUdiCarrier() {
        if (this.udiCarrier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.udiCarrier");
            }
            if (Configuration.doAutoCreate()) {
                this.udiCarrier = new Identifier();
            }
        }
        return this.udiCarrier;
    }

    public boolean hasUdiCarrier() {
        return this.udiCarrier != null && !this.udiCarrier.isEmpty();
    }

    public Device setUdiCarrier(Identifier value) {
        this.udiCarrier = value;
        return this;
    }

    public Enumeration<DeviceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<DeviceStatus>(new DeviceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Device setStatusElement(Enumeration<DeviceStatus> value) {
        this.status = value;
        return this;
    }

    public DeviceStatus getStatus() {
        return this.status == null ? null : (DeviceStatus)((Object)this.status.getValue());
    }

    public Device setStatus(DeviceStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<DeviceStatus>(new DeviceStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Device setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public StringType getLotNumberElement() {
        if (this.lotNumber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.lotNumber");
            }
            if (Configuration.doAutoCreate()) {
                this.lotNumber = new StringType();
            }
        }
        return this.lotNumber;
    }

    public boolean hasLotNumberElement() {
        return this.lotNumber != null && !this.lotNumber.isEmpty();
    }

    public boolean hasLotNumber() {
        return this.lotNumber != null && !this.lotNumber.isEmpty();
    }

    public Device setLotNumberElement(StringType value) {
        this.lotNumber = value;
        return this;
    }

    public String getLotNumber() {
        return this.lotNumber == null ? null : (String)this.lotNumber.getValue();
    }

    public Device setLotNumber(String value) {
        if (Utilities.noString((String)value)) {
            this.lotNumber = null;
        } else {
            if (this.lotNumber == null) {
                this.lotNumber = new StringType();
            }
            this.lotNumber.setValue(value);
        }
        return this;
    }

    public StringType getManufacturerElement() {
        if (this.manufacturer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.manufacturer");
            }
            if (Configuration.doAutoCreate()) {
                this.manufacturer = new StringType();
            }
        }
        return this.manufacturer;
    }

    public boolean hasManufacturerElement() {
        return this.manufacturer != null && !this.manufacturer.isEmpty();
    }

    public boolean hasManufacturer() {
        return this.manufacturer != null && !this.manufacturer.isEmpty();
    }

    public Device setManufacturerElement(StringType value) {
        this.manufacturer = value;
        return this;
    }

    public String getManufacturer() {
        return this.manufacturer == null ? null : (String)this.manufacturer.getValue();
    }

    public Device setManufacturer(String value) {
        if (Utilities.noString((String)value)) {
            this.manufacturer = null;
        } else {
            if (this.manufacturer == null) {
                this.manufacturer = new StringType();
            }
            this.manufacturer.setValue(value);
        }
        return this;
    }

    public DateTimeType getManufactureDateElement() {
        if (this.manufactureDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.manufactureDate");
            }
            if (Configuration.doAutoCreate()) {
                this.manufactureDate = new DateTimeType();
            }
        }
        return this.manufactureDate;
    }

    public boolean hasManufactureDateElement() {
        return this.manufactureDate != null && !this.manufactureDate.isEmpty();
    }

    public boolean hasManufactureDate() {
        return this.manufactureDate != null && !this.manufactureDate.isEmpty();
    }

    public Device setManufactureDateElement(DateTimeType value) {
        this.manufactureDate = value;
        return this;
    }

    public Date getManufactureDate() {
        return this.manufactureDate == null ? null : (Date)this.manufactureDate.getValue();
    }

    public Device setManufactureDate(Date value) {
        if (value == null) {
            this.manufactureDate = null;
        } else {
            if (this.manufactureDate == null) {
                this.manufactureDate = new DateTimeType();
            }
            this.manufactureDate.setValue(value);
        }
        return this;
    }

    public DateTimeType getExpirationDateElement() {
        if (this.expirationDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.expirationDate");
            }
            if (Configuration.doAutoCreate()) {
                this.expirationDate = new DateTimeType();
            }
        }
        return this.expirationDate;
    }

    public boolean hasExpirationDateElement() {
        return this.expirationDate != null && !this.expirationDate.isEmpty();
    }

    public boolean hasExpirationDate() {
        return this.expirationDate != null && !this.expirationDate.isEmpty();
    }

    public Device setExpirationDateElement(DateTimeType value) {
        this.expirationDate = value;
        return this;
    }

    public Date getExpirationDate() {
        return this.expirationDate == null ? null : (Date)this.expirationDate.getValue();
    }

    public Device setExpirationDate(Date value) {
        if (value == null) {
            this.expirationDate = null;
        } else {
            if (this.expirationDate == null) {
                this.expirationDate = new DateTimeType();
            }
            this.expirationDate.setValue(value);
        }
        return this;
    }

    public StringType getModelElement() {
        if (this.model == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.model");
            }
            if (Configuration.doAutoCreate()) {
                this.model = new StringType();
            }
        }
        return this.model;
    }

    public boolean hasModelElement() {
        return this.model != null && !this.model.isEmpty();
    }

    public boolean hasModel() {
        return this.model != null && !this.model.isEmpty();
    }

    public Device setModelElement(StringType value) {
        this.model = value;
        return this;
    }

    public String getModel() {
        return this.model == null ? null : (String)this.model.getValue();
    }

    public Device setModel(String value) {
        if (Utilities.noString((String)value)) {
            this.model = null;
        } else {
            if (this.model == null) {
                this.model = new StringType();
            }
            this.model.setValue(value);
        }
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public Device setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public Device setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public Device setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public Device setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Reference getOwner() {
        if (this.owner == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.owner");
            }
            if (Configuration.doAutoCreate()) {
                this.owner = new Reference();
            }
        }
        return this.owner;
    }

    public boolean hasOwner() {
        return this.owner != null && !this.owner.isEmpty();
    }

    public Device setOwner(Reference value) {
        this.owner = value;
        return this;
    }

    public Organization getOwnerTarget() {
        if (this.ownerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.owner");
            }
            if (Configuration.doAutoCreate()) {
                this.ownerTarget = new Organization();
            }
        }
        return this.ownerTarget;
    }

    public Device setOwnerTarget(Organization value) {
        this.ownerTarget = value;
        return this;
    }

    public List<ContactPoint> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        return this.contact;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactPoint item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addContact() {
        ContactPoint t = new ContactPoint();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        this.contact.add(t);
        return t;
    }

    public Device addContact(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        this.contact.add(t);
        return this;
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public Device setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public Location getLocationTarget() {
        if (this.locationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.location");
            }
            if (Configuration.doAutoCreate()) {
                this.locationTarget = new Location();
            }
        }
        return this.locationTarget;
    }

    public Device setLocationTarget(Location value) {
        this.locationTarget = value;
        return this;
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public Device setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public Device setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Device addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Unique instance identifiers assigned to a device by manufacturers other organizations or owners.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("udiCarrier", "Identifier", "[Unique device identifier (UDI)](device.html#5.11.3.2.2) barcode or rfid string assigned to device label or package.", 0, Integer.MAX_VALUE, this.udiCarrier));
        childrenList.add(new Property("status", "code", "Status of the Device availability.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_TYPE, "CodeableConcept", "Code or identifier to identify a kind of device.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property("lotNumber", "string", "Lot number assigned by the manufacturer.", 0, Integer.MAX_VALUE, this.lotNumber));
        childrenList.add(new Property(SP_MANUFACTURER, "string", "A name of the manufacturer.", 0, Integer.MAX_VALUE, this.manufacturer));
        childrenList.add(new Property("manufactureDate", "dateTime", "The date and time when the device was manufactured.", 0, Integer.MAX_VALUE, this.manufactureDate));
        childrenList.add(new Property("expirationDate", "dateTime", "The date and time beyond which this device is no longer valid or should not be used (if applicable).", 0, Integer.MAX_VALUE, this.expirationDate));
        childrenList.add(new Property(SP_MODEL, "string", "The \"model\" is an identifier assigned by the manufacturer to identify the product by its type. This number is shared by the all devices sold as the same type.", 0, Integer.MAX_VALUE, this.model));
        childrenList.add(new Property("version", "string", "The version of the device, if the device has multiple releases under the same model, or if the device is software or carries firmware.", 0, Integer.MAX_VALUE, this.version));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "Patient information, If the device is affixed to a person.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property("owner", "Reference(Organization)", "An organization that is responsible for the provision and ongoing maintenance of the device.", 0, Integer.MAX_VALUE, this.owner));
        childrenList.add(new Property("contact", "ContactPoint", "Contact details for an organization or a particular human that is responsible for the device.", 0, Integer.MAX_VALUE, this.contact));
        childrenList.add(new Property(SP_LOCATION, "Reference(Location)", "The place where the device can be found.", 0, Integer.MAX_VALUE, this.location));
        childrenList.add(new Property(SP_URL, "uri", "A network address on which the device may be contacted directly.", 0, Integer.MAX_VALUE, this.url));
        childrenList.add(new Property("note", "Annotation", "Descriptive information, usage information or implantation information that is not captured in an existing element.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1343558178: {
                Base[] baseArray;
                if (this.udiCarrier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.udiCarrier;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.type;
                }
                return baseArray;
            }
            case 462547450: {
                Base[] baseArray;
                if (this.lotNumber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.lotNumber;
                }
                return baseArray;
            }
            case -1969347631: {
                Base[] baseArray;
                if (this.manufacturer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.manufacturer;
                }
                return baseArray;
            }
            case 416714767: {
                Base[] baseArray;
                if (this.manufactureDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.manufactureDate;
                }
                return baseArray;
            }
            case -668811523: {
                Base[] baseArray;
                if (this.expirationDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.expirationDate;
                }
                return baseArray;
            }
            case 104069929: {
                Base[] baseArray;
                if (this.model == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.model;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.version;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.patient;
                }
                return baseArray;
            }
            case 106164915: {
                Base[] baseArray;
                if (this.owner == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.owner;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.location;
                }
                return baseArray;
            }
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.url;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case -1343558178: {
                this.udiCarrier = this.castToIdentifier(value);
                break;
            }
            case -892481550: {
                this.status = new DeviceStatusEnumFactory().fromType(value);
                break;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                break;
            }
            case 462547450: {
                this.lotNumber = this.castToString(value);
                break;
            }
            case -1969347631: {
                this.manufacturer = this.castToString(value);
                break;
            }
            case 416714767: {
                this.manufactureDate = this.castToDateTime(value);
                break;
            }
            case -668811523: {
                this.expirationDate = this.castToDateTime(value);
                break;
            }
            case 104069929: {
                this.model = this.castToString(value);
                break;
            }
            case 351608024: {
                this.version = this.castToString(value);
                break;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                break;
            }
            case 106164915: {
                this.owner = this.castToReference(value);
                break;
            }
            case 951526432: {
                this.getContact().add(this.castToContactPoint(value));
                break;
            }
            case 1901043637: {
                this.location = this.castToReference(value);
                break;
            }
            case 116079: {
                this.url = this.castToUri(value);
                break;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("udiCarrier")) {
            this.udiCarrier = this.castToIdentifier(value);
        } else if (name.equals("status")) {
            this.status = new DeviceStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("lotNumber")) {
            this.lotNumber = this.castToString(value);
        } else if (name.equals(SP_MANUFACTURER)) {
            this.manufacturer = this.castToString(value);
        } else if (name.equals("manufactureDate")) {
            this.manufactureDate = this.castToDateTime(value);
        } else if (name.equals("expirationDate")) {
            this.expirationDate = this.castToDateTime(value);
        } else if (name.equals(SP_MODEL)) {
            this.model = this.castToString(value);
        } else if (name.equals("version")) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("owner")) {
            this.owner = this.castToReference(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactPoint(value));
        } else if (name.equals(SP_LOCATION)) {
            this.location = this.castToReference(value);
        } else if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1343558178: {
                return this.getUdiCarrier();
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case 3575610: {
                return this.getType();
            }
            case 462547450: {
                throw new FHIRException("Cannot make property lotNumber as it is not a complex type");
            }
            case -1969347631: {
                throw new FHIRException("Cannot make property manufacturer as it is not a complex type");
            }
            case 416714767: {
                throw new FHIRException("Cannot make property manufactureDate as it is not a complex type");
            }
            case -668811523: {
                throw new FHIRException("Cannot make property expirationDate as it is not a complex type");
            }
            case 104069929: {
                throw new FHIRException("Cannot make property model as it is not a complex type");
            }
            case 351608024: {
                throw new FHIRException("Cannot make property version as it is not a complex type");
            }
            case -791418107: {
                return this.getPatient();
            }
            case 106164915: {
                return this.getOwner();
            }
            case 951526432: {
                return this.addContact();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case 116079: {
                throw new FHIRException("Cannot make property url as it is not a complex type");
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("udiCarrier")) {
            this.udiCarrier = new Identifier();
            return this.udiCarrier;
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a singleton property Device.status");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("lotNumber")) {
            throw new FHIRException("Cannot call addChild on a singleton property Device.lotNumber");
        }
        if (name.equals(SP_MANUFACTURER)) {
            throw new FHIRException("Cannot call addChild on a singleton property Device.manufacturer");
        }
        if (name.equals("manufactureDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property Device.manufactureDate");
        }
        if (name.equals("expirationDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property Device.expirationDate");
        }
        if (name.equals(SP_MODEL)) {
            throw new FHIRException("Cannot call addChild on a singleton property Device.model");
        }
        if (name.equals("version")) {
            throw new FHIRException("Cannot call addChild on a singleton property Device.version");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("owner")) {
            this.owner = new Reference();
            return this.owner;
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_LOCATION)) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a singleton property Device.url");
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Device";
    }

    @Override
    public Device copy() {
        Device dst = new Device();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.udiCarrier = this.udiCarrier == null ? null : this.udiCarrier.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.lotNumber = this.lotNumber == null ? null : this.lotNumber.copy();
        dst.manufacturer = this.manufacturer == null ? null : this.manufacturer.copy();
        dst.manufactureDate = this.manufactureDate == null ? null : this.manufactureDate.copy();
        dst.expirationDate = this.expirationDate == null ? null : this.expirationDate.copy();
        dst.model = this.model == null ? null : this.model.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        Reference reference = dst.owner = this.owner == null ? null : this.owner.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.contact) {
                dst.contact.add(contactPoint.copy());
            }
        }
        dst.location = this.location == null ? null : this.location.copy();
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        return dst;
    }

    protected Device typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Device)) {
            return false;
        }
        Device o = (Device)other;
        return Device.compareDeep(this.identifier, o.identifier, true) && Device.compareDeep(this.udiCarrier, o.udiCarrier, true) && Device.compareDeep(this.status, o.status, true) && Device.compareDeep(this.type, o.type, true) && Device.compareDeep(this.lotNumber, o.lotNumber, true) && Device.compareDeep(this.manufacturer, o.manufacturer, true) && Device.compareDeep(this.manufactureDate, o.manufactureDate, true) && Device.compareDeep(this.expirationDate, o.expirationDate, true) && Device.compareDeep(this.model, o.model, true) && Device.compareDeep(this.version, o.version, true) && Device.compareDeep(this.patient, o.patient, true) && Device.compareDeep(this.owner, o.owner, true) && Device.compareDeep(this.contact, o.contact, true) && Device.compareDeep(this.location, o.location, true) && Device.compareDeep(this.url, o.url, true) && Device.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Device)) {
            return false;
        }
        Device o = (Device)other;
        return Device.compareValues(this.status, o.status, true) && Device.compareValues(this.lotNumber, o.lotNumber, true) && Device.compareValues(this.manufacturer, o.manufacturer, true) && Device.compareValues(this.manufactureDate, o.manufactureDate, true) && Device.compareValues(this.expirationDate, o.expirationDate, true) && Device.compareValues(this.model, o.model, true) && Device.compareValues(this.version, o.version, true) && Device.compareValues(this.url, o.url, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.udiCarrier != null && !this.udiCarrier.isEmpty() || this.status != null && !this.status.isEmpty() || this.type != null && !this.type.isEmpty() || this.lotNumber != null && !this.lotNumber.isEmpty() || this.manufacturer != null && !this.manufacturer.isEmpty() || this.manufactureDate != null && !this.manufactureDate.isEmpty() || this.expirationDate != null && !this.expirationDate.isEmpty() || this.model != null && !this.model.isEmpty() || this.version != null && !this.version.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.owner != null && !this.owner.isEmpty() || this.contact != null && !this.contact.isEmpty() || this.location != null && !this.location.isEmpty() || this.url != null && !this.url.isEmpty() || this.note != null && !this.note.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Device;
    }

    public static class DeviceStatusEnumFactory
    implements EnumFactory<DeviceStatus> {
        @Override
        public DeviceStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("available".equals(codeString)) {
                return DeviceStatus.AVAILABLE;
            }
            if ("not-available".equals(codeString)) {
                return DeviceStatus.NOTAVAILABLE;
            }
            if ("entered-in-error".equals(codeString)) {
                return DeviceStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown DeviceStatus code '" + codeString + "'");
        }

        public Enumeration<DeviceStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("available".equals(codeString)) {
                return new Enumeration<DeviceStatus>(this, DeviceStatus.AVAILABLE);
            }
            if ("not-available".equals(codeString)) {
                return new Enumeration<DeviceStatus>(this, DeviceStatus.NOTAVAILABLE);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<DeviceStatus>(this, DeviceStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown DeviceStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(DeviceStatus code) {
            if (code == DeviceStatus.NULL) {
                return null;
            }
            if (code == DeviceStatus.AVAILABLE) {
                return "available";
            }
            if (code == DeviceStatus.NOTAVAILABLE) {
                return "not-available";
            }
            if (code == DeviceStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(DeviceStatus code) {
            return code.getSystem();
        }
    }

    public static enum DeviceStatus {
        AVAILABLE,
        NOTAVAILABLE,
        ENTEREDINERROR,
        NULL;


        public static DeviceStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("available".equals(codeString)) {
                return AVAILABLE;
            }
            if ("not-available".equals(codeString)) {
                return NOTAVAILABLE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            throw new FHIRException("Unknown DeviceStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case AVAILABLE: {
                    return "available";
                }
                case NOTAVAILABLE: {
                    return "not-available";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case AVAILABLE: {
                    return "http://hl7.org/fhir/devicestatus";
                }
                case NOTAVAILABLE: {
                    return "http://hl7.org/fhir/devicestatus";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/devicestatus";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case AVAILABLE: {
                    return "The Device is available for use.";
                }
                case NOTAVAILABLE: {
                    return "The Device is no longer available for use (e.g. lost, expired, damaged).";
                }
                case ENTEREDINERROR: {
                    return "The Device was entered in error and voided.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case AVAILABLE: {
                    return "Available";
                }
                case NOTAVAILABLE: {
                    return "Not Available";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

