/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.Element;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.StructureDefinition;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseDatatypeElement;
import org.hl7.fhir.instance.model.api.ICompositeType;

@DatatypeDef(name="DataRequirement")
public class DataRequirement
extends Type
implements ICompositeType {
    @Child(name="type", type={CodeType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The type of the required data", formalDefinition="The type of the required data, specified as the type name of a resource. For profiles, this value is set to the type of the base resource of the profile.")
    protected CodeType type;
    @Child(name="profile", type={StructureDefinition.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The profile of the required data", formalDefinition="The profile of the required data, specified as the uri of the profile definition.")
    protected Reference profile;
    protected StructureDefinition profileTarget;
    @Child(name="mustSupport", type={StringType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Indicates that specific structure elements are referenced by the knowledge module", formalDefinition="Indicates that specific elements of the type are referenced by the knowledge module and must be supported by the consumer in order to obtain an effective evaluation. This does not mean that a value is required for this element, only that the consuming system must understand the element and be able to provide values for it if they are available.")
    protected List<StringType> mustSupport;
    @Child(name="codeFilter", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Code filters for the data", formalDefinition="Code filters specify additional constraints on the data, specifying the value set of interest for a particular element of the data.")
    protected List<DataRequirementCodeFilterComponent> codeFilter;
    @Child(name="dateFilter", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Date filters for the data", formalDefinition="Date filters specify additional constraints on the data in terms of the applicable date range for specific elements.")
    protected List<DataRequirementDateFilterComponent> dateFilter;
    private static final long serialVersionUID = 1768899744L;

    public DataRequirement() {
    }

    public DataRequirement(CodeType type) {
        this.type = type;
    }

    public CodeType getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DataRequirement.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeType();
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public DataRequirement setTypeElement(CodeType value) {
        this.type = value;
        return this;
    }

    public String getType() {
        return this.type == null ? null : (String)this.type.getValue();
    }

    public DataRequirement setType(String value) {
        if (this.type == null) {
            this.type = new CodeType();
        }
        this.type.setValue(value);
        return this;
    }

    public Reference getProfile() {
        if (this.profile == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DataRequirement.profile");
            }
            if (Configuration.doAutoCreate()) {
                this.profile = new Reference();
            }
        }
        return this.profile;
    }

    public boolean hasProfile() {
        return this.profile != null && !this.profile.isEmpty();
    }

    public DataRequirement setProfile(Reference value) {
        this.profile = value;
        return this;
    }

    public StructureDefinition getProfileTarget() {
        if (this.profileTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DataRequirement.profile");
            }
            if (Configuration.doAutoCreate()) {
                this.profileTarget = new StructureDefinition();
            }
        }
        return this.profileTarget;
    }

    public DataRequirement setProfileTarget(StructureDefinition value) {
        this.profileTarget = value;
        return this;
    }

    public List<StringType> getMustSupport() {
        if (this.mustSupport == null) {
            this.mustSupport = new ArrayList<StringType>();
        }
        return this.mustSupport;
    }

    public boolean hasMustSupport() {
        if (this.mustSupport == null) {
            return false;
        }
        for (StringType item : this.mustSupport) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addMustSupportElement() {
        StringType t = new StringType();
        if (this.mustSupport == null) {
            this.mustSupport = new ArrayList<StringType>();
        }
        this.mustSupport.add(t);
        return t;
    }

    public DataRequirement addMustSupport(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.mustSupport == null) {
            this.mustSupport = new ArrayList<StringType>();
        }
        this.mustSupport.add(t);
        return this;
    }

    public boolean hasMustSupport(String value) {
        if (this.mustSupport == null) {
            return false;
        }
        for (StringType v : this.mustSupport) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<DataRequirementCodeFilterComponent> getCodeFilter() {
        if (this.codeFilter == null) {
            this.codeFilter = new ArrayList<DataRequirementCodeFilterComponent>();
        }
        return this.codeFilter;
    }

    public boolean hasCodeFilter() {
        if (this.codeFilter == null) {
            return false;
        }
        for (DataRequirementCodeFilterComponent item : this.codeFilter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DataRequirementCodeFilterComponent addCodeFilter() {
        DataRequirementCodeFilterComponent t = new DataRequirementCodeFilterComponent();
        if (this.codeFilter == null) {
            this.codeFilter = new ArrayList<DataRequirementCodeFilterComponent>();
        }
        this.codeFilter.add(t);
        return t;
    }

    public DataRequirement addCodeFilter(DataRequirementCodeFilterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.codeFilter == null) {
            this.codeFilter = new ArrayList<DataRequirementCodeFilterComponent>();
        }
        this.codeFilter.add(t);
        return this;
    }

    public List<DataRequirementDateFilterComponent> getDateFilter() {
        if (this.dateFilter == null) {
            this.dateFilter = new ArrayList<DataRequirementDateFilterComponent>();
        }
        return this.dateFilter;
    }

    public boolean hasDateFilter() {
        if (this.dateFilter == null) {
            return false;
        }
        for (DataRequirementDateFilterComponent item : this.dateFilter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DataRequirementDateFilterComponent addDateFilter() {
        DataRequirementDateFilterComponent t = new DataRequirementDateFilterComponent();
        if (this.dateFilter == null) {
            this.dateFilter = new ArrayList<DataRequirementDateFilterComponent>();
        }
        this.dateFilter.add(t);
        return t;
    }

    public DataRequirement addDateFilter(DataRequirementDateFilterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.dateFilter == null) {
            this.dateFilter = new ArrayList<DataRequirementDateFilterComponent>();
        }
        this.dateFilter.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("type", "code", "The type of the required data, specified as the type name of a resource. For profiles, this value is set to the type of the base resource of the profile.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property("profile", "Reference(StructureDefinition)", "The profile of the required data, specified as the uri of the profile definition.", 0, Integer.MAX_VALUE, this.profile));
        childrenList.add(new Property("mustSupport", "string", "Indicates that specific elements of the type are referenced by the knowledge module and must be supported by the consumer in order to obtain an effective evaluation. This does not mean that a value is required for this element, only that the consuming system must understand the element and be able to provide values for it if they are available.", 0, Integer.MAX_VALUE, this.mustSupport));
        childrenList.add(new Property("codeFilter", "", "Code filters specify additional constraints on the data, specifying the value set of interest for a particular element of the data.", 0, Integer.MAX_VALUE, this.codeFilter));
        childrenList.add(new Property("dateFilter", "", "Date filters specify additional constraints on the data in terms of the applicable date range for specific elements.", 0, Integer.MAX_VALUE, this.dateFilter));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.type;
                }
                return baseArray;
            }
            case -309425751: {
                Base[] baseArray;
                if (this.profile == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.profile;
                }
                return baseArray;
            }
            case -1402857082: {
                return this.mustSupport == null ? new Base[]{} : this.mustSupport.toArray(new Base[this.mustSupport.size()]);
            }
            case -1303674939: {
                return this.codeFilter == null ? new Base[]{} : this.codeFilter.toArray(new Base[this.codeFilter.size()]);
            }
            case 149531846: {
                return this.dateFilter == null ? new Base[]{} : this.dateFilter.toArray(new Base[this.dateFilter.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3575610: {
                this.type = this.castToCode(value);
                break;
            }
            case -309425751: {
                this.profile = this.castToReference(value);
                break;
            }
            case -1402857082: {
                this.getMustSupport().add(this.castToString(value));
                break;
            }
            case -1303674939: {
                this.getCodeFilter().add((DataRequirementCodeFilterComponent)value);
                break;
            }
            case 149531846: {
                this.getDateFilter().add((DataRequirementDateFilterComponent)value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("type")) {
            this.type = this.castToCode(value);
        } else if (name.equals("profile")) {
            this.profile = this.castToReference(value);
        } else if (name.equals("mustSupport")) {
            this.getMustSupport().add(this.castToString(value));
        } else if (name.equals("codeFilter")) {
            this.getCodeFilter().add((DataRequirementCodeFilterComponent)value);
        } else if (name.equals("dateFilter")) {
            this.getDateFilter().add((DataRequirementDateFilterComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                throw new FHIRException("Cannot make property type as it is not a complex type");
            }
            case -309425751: {
                return this.getProfile();
            }
            case -1402857082: {
                throw new FHIRException("Cannot make property mustSupport as it is not a complex type");
            }
            case -1303674939: {
                return this.addCodeFilter();
            }
            case 149531846: {
                return this.addDateFilter();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a singleton property DataRequirement.type");
        }
        if (name.equals("profile")) {
            this.profile = new Reference();
            return this.profile;
        }
        if (name.equals("mustSupport")) {
            throw new FHIRException("Cannot call addChild on a singleton property DataRequirement.mustSupport");
        }
        if (name.equals("codeFilter")) {
            return this.addCodeFilter();
        }
        if (name.equals("dateFilter")) {
            return this.addDateFilter();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DataRequirement";
    }

    @Override
    public DataRequirement copy() {
        DataRequirement dst = new DataRequirement();
        this.copyValues(dst);
        dst.type = this.type == null ? null : this.type.copy();
        Reference reference = dst.profile = this.profile == null ? null : this.profile.copy();
        if (this.mustSupport != null) {
            dst.mustSupport = new ArrayList<StringType>();
            for (StringType stringType : this.mustSupport) {
                dst.mustSupport.add(stringType.copy());
            }
        }
        if (this.codeFilter != null) {
            dst.codeFilter = new ArrayList<DataRequirementCodeFilterComponent>();
            for (DataRequirementCodeFilterComponent dataRequirementCodeFilterComponent : this.codeFilter) {
                dst.codeFilter.add(dataRequirementCodeFilterComponent.copy());
            }
        }
        if (this.dateFilter != null) {
            dst.dateFilter = new ArrayList<DataRequirementDateFilterComponent>();
            for (DataRequirementDateFilterComponent dataRequirementDateFilterComponent : this.dateFilter) {
                dst.dateFilter.add(dataRequirementDateFilterComponent.copy());
            }
        }
        return dst;
    }

    @Override
    protected DataRequirement typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof DataRequirement)) {
            return false;
        }
        DataRequirement o = (DataRequirement)other;
        return DataRequirement.compareDeep(this.type, o.type, true) && DataRequirement.compareDeep(this.profile, o.profile, true) && DataRequirement.compareDeep(this.mustSupport, o.mustSupport, true) && DataRequirement.compareDeep(this.codeFilter, o.codeFilter, true) && DataRequirement.compareDeep(this.dateFilter, o.dateFilter, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof DataRequirement)) {
            return false;
        }
        DataRequirement o = (DataRequirement)other;
        return DataRequirement.compareValues(this.type, o.type, true) && DataRequirement.compareValues(this.mustSupport, o.mustSupport, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.profile != null && !this.profile.isEmpty() || this.mustSupport != null && !this.mustSupport.isEmpty() || this.codeFilter != null && !this.codeFilter.isEmpty() || this.dateFilter != null && !this.dateFilter.isEmpty());
    }

    @Block
    public static class DataRequirementDateFilterComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="path", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The date-valued attribute of the filter", formalDefinition="The date-valued attribute of the filter. The specified path must be resolvable from the type of the required data. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements. Note that the index must be an integer constant. The path must resolve to an element of type dateTime, Period, Schedule, or Timing.")
        protected StringType path;
        @Child(name="value", type={DateTimeType.class, Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The value of the filter, as a Period or dateTime value", formalDefinition="The value of the filter. If period is specified, the filter will return only those data items that fall within the bounds determined by the Period, inclusive of the period boundaries. If dateTime is specified, the filter will return only those data items that are equal to the specified dateTime.")
        protected Type value;
        private static final long serialVersionUID = 1791957163L;

        public DataRequirementDateFilterComponent() {
        }

        public DataRequirementDateFilterComponent(StringType path) {
            this.path = path;
        }

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DataRequirementDateFilterComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public DataRequirementDateFilterComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public DataRequirementDateFilterComponent setPath(String value) {
            if (this.path == null) {
                this.path = new StringType();
            }
            this.path.setValue(value);
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this.value instanceof DateTimeType;
        }

        public Period getValuePeriod() throws FHIRException {
            if (!(this.value instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Period)this.value;
        }

        public boolean hasValuePeriod() {
            return this.value instanceof Period;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public DataRequirementDateFilterComponent setValue(Type value) {
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("path", "string", "The date-valued attribute of the filter. The specified path must be resolvable from the type of the required data. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements. Note that the index must be an integer constant. The path must resolve to an element of type dateTime, Period, Schedule, or Timing.", 0, Integer.MAX_VALUE, this.path));
            childrenList.add(new Property("value[x]", "dateTime|Period", "The value of the filter. If period is specified, the filter will return only those data items that fall within the bounds determined by the Period, inclusive of the period boundaries. If dateTime is specified, the filter will return only those data items that are equal to the specified dateTime.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.path;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    this.path = this.castToString(value);
                    break;
                }
                case 111972721: {
                    this.value = (Type)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("path")) {
                this.path = this.castToString(value);
            } else if (name.equals("value[x]")) {
                this.value = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    throw new FHIRException("Cannot make property path as it is not a complex type");
                }
                case -1410166417: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a singleton property DataRequirement.path");
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valuePeriod")) {
                this.value = new Period();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public DataRequirementDateFilterComponent copy() {
            DataRequirementDateFilterComponent dst = new DataRequirementDateFilterComponent();
            this.copyValues(dst);
            dst.path = this.path == null ? null : this.path.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DataRequirementDateFilterComponent)) {
                return false;
            }
            DataRequirementDateFilterComponent o = (DataRequirementDateFilterComponent)other;
            return DataRequirementDateFilterComponent.compareDeep(this.path, o.path, true) && DataRequirementDateFilterComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DataRequirementDateFilterComponent)) {
                return false;
            }
            DataRequirementDateFilterComponent o = (DataRequirementDateFilterComponent)other;
            return DataRequirementDateFilterComponent.compareValues(this.path, o.path, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.path != null && !this.path.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "DataRequirement.dateFilter";
        }
    }

    @Block
    public static class DataRequirementCodeFilterComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="path", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The code-valued attribute of the filter", formalDefinition="The code-valued attribute of the filter. The specified path must be resolvable from the type of the required data. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements. Note that the index must be an integer constant. The path must resolve to an element of type code, Coding, or CodeableConcept.")
        protected StringType path;
        @Child(name="valueSet", type={StringType.class, ValueSet.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Valueset for the filter", formalDefinition="The valueset for the code filter. The valueSet and value elements are exclusive. If valueSet is specified, the filter will return only those data items for which the value of the code-valued element specified in the path is a member of the specified valueset.")
        protected Type valueSet;
        @Child(name="valueCode", type={CodeType.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Code value of the filter", formalDefinition="The codes for the code filter. Only one of valueSet, valueCode, valueConding, or valueCodeableConcept may be specified. If values are given, the filter will return only those data items for which the code-valued attribute specified by the path has a value that is one of the specified codes.")
        protected List<CodeType> valueCode;
        @Child(name="valueCoding", type={Coding.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Coding value of the filter", formalDefinition="The Codings for the code filter. Only one of valueSet, valueCode, valueConding, or valueCodeableConcept may be specified. If values are given, the filter will return only those data items for which the code-valued attribute specified by the path has a value that is one of the specified Codings.")
        protected List<Coding> valueCoding;
        @Child(name="valueCodeableConcept", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="CodeableConcept value of the filter", formalDefinition="The CodeableConcepts for the code filter. Only one of valueSet, valueCode, valueConding, or valueCodeableConcept may be specified. If values are given, the filter will return only those data items for which the code-valued attribute specified by the path has a value that is one of the specified CodeableConcepts.")
        protected List<CodeableConcept> valueCodeableConcept;
        private static final long serialVersionUID = -888422840L;

        public DataRequirementCodeFilterComponent() {
        }

        public DataRequirementCodeFilterComponent(StringType path) {
            this.path = path;
        }

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DataRequirementCodeFilterComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public DataRequirementCodeFilterComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public DataRequirementCodeFilterComponent setPath(String value) {
            if (this.path == null) {
                this.path = new StringType();
            }
            this.path.setValue(value);
            return this;
        }

        public Type getValueSet() {
            return this.valueSet;
        }

        public StringType getValueSetStringType() throws FHIRException {
            if (!(this.valueSet instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.valueSet.getClass().getName() + " was encountered");
            }
            return (StringType)this.valueSet;
        }

        public boolean hasValueSetStringType() {
            return this.valueSet instanceof StringType;
        }

        public Reference getValueSetReference() throws FHIRException {
            if (!(this.valueSet instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.valueSet.getClass().getName() + " was encountered");
            }
            return (Reference)this.valueSet;
        }

        public boolean hasValueSetReference() {
            return this.valueSet instanceof Reference;
        }

        public boolean hasValueSet() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public DataRequirementCodeFilterComponent setValueSet(Type value) {
            this.valueSet = value;
            return this;
        }

        public List<CodeType> getValueCode() {
            if (this.valueCode == null) {
                this.valueCode = new ArrayList<CodeType>();
            }
            return this.valueCode;
        }

        public boolean hasValueCode() {
            if (this.valueCode == null) {
                return false;
            }
            for (CodeType item : this.valueCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeType addValueCodeElement() {
            CodeType t = new CodeType();
            if (this.valueCode == null) {
                this.valueCode = new ArrayList<CodeType>();
            }
            this.valueCode.add(t);
            return t;
        }

        public DataRequirementCodeFilterComponent addValueCode(String value) {
            CodeType t = new CodeType();
            t.setValue(value);
            if (this.valueCode == null) {
                this.valueCode = new ArrayList<CodeType>();
            }
            this.valueCode.add(t);
            return this;
        }

        public boolean hasValueCode(String value) {
            if (this.valueCode == null) {
                return false;
            }
            for (CodeType v : this.valueCode) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<Coding> getValueCoding() {
            if (this.valueCoding == null) {
                this.valueCoding = new ArrayList<Coding>();
            }
            return this.valueCoding;
        }

        public boolean hasValueCoding() {
            if (this.valueCoding == null) {
                return false;
            }
            for (Coding item : this.valueCoding) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addValueCoding() {
            Coding t = new Coding();
            if (this.valueCoding == null) {
                this.valueCoding = new ArrayList<Coding>();
            }
            this.valueCoding.add(t);
            return t;
        }

        public DataRequirementCodeFilterComponent addValueCoding(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.valueCoding == null) {
                this.valueCoding = new ArrayList<Coding>();
            }
            this.valueCoding.add(t);
            return this;
        }

        public List<CodeableConcept> getValueCodeableConcept() {
            if (this.valueCodeableConcept == null) {
                this.valueCodeableConcept = new ArrayList<CodeableConcept>();
            }
            return this.valueCodeableConcept;
        }

        public boolean hasValueCodeableConcept() {
            if (this.valueCodeableConcept == null) {
                return false;
            }
            for (CodeableConcept item : this.valueCodeableConcept) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addValueCodeableConcept() {
            CodeableConcept t = new CodeableConcept();
            if (this.valueCodeableConcept == null) {
                this.valueCodeableConcept = new ArrayList<CodeableConcept>();
            }
            this.valueCodeableConcept.add(t);
            return t;
        }

        public DataRequirementCodeFilterComponent addValueCodeableConcept(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.valueCodeableConcept == null) {
                this.valueCodeableConcept = new ArrayList<CodeableConcept>();
            }
            this.valueCodeableConcept.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("path", "string", "The code-valued attribute of the filter. The specified path must be resolvable from the type of the required data. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements. Note that the index must be an integer constant. The path must resolve to an element of type code, Coding, or CodeableConcept.", 0, Integer.MAX_VALUE, this.path));
            childrenList.add(new Property("valueSet[x]", "string|Reference(ValueSet)", "The valueset for the code filter. The valueSet and value elements are exclusive. If valueSet is specified, the filter will return only those data items for which the value of the code-valued element specified in the path is a member of the specified valueset.", 0, Integer.MAX_VALUE, this.valueSet));
            childrenList.add(new Property("valueCode", "code", "The codes for the code filter. Only one of valueSet, valueCode, valueConding, or valueCodeableConcept may be specified. If values are given, the filter will return only those data items for which the code-valued attribute specified by the path has a value that is one of the specified codes.", 0, Integer.MAX_VALUE, this.valueCode));
            childrenList.add(new Property("valueCoding", "Coding", "The Codings for the code filter. Only one of valueSet, valueCode, valueConding, or valueCodeableConcept may be specified. If values are given, the filter will return only those data items for which the code-valued attribute specified by the path has a value that is one of the specified Codings.", 0, Integer.MAX_VALUE, this.valueCoding));
            childrenList.add(new Property("valueCodeableConcept", "CodeableConcept", "The CodeableConcepts for the code filter. Only one of valueSet, valueCode, valueConding, or valueCodeableConcept may be specified. If values are given, the filter will return only those data items for which the code-valued attribute specified by the path has a value that is one of the specified CodeableConcepts.", 0, Integer.MAX_VALUE, this.valueCodeableConcept));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.path;
                    }
                    return baseArray;
                }
                case -1410174671: {
                    Base[] baseArray;
                    if (this.valueSet == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.valueSet;
                    }
                    return baseArray;
                }
                case -766209282: {
                    return this.valueCode == null ? new Base[]{} : this.valueCode.toArray(new Base[this.valueCode.size()]);
                }
                case -1887705029: {
                    return this.valueCoding == null ? new Base[]{} : this.valueCoding.toArray(new Base[this.valueCoding.size()]);
                }
                case 924902896: {
                    return this.valueCodeableConcept == null ? new Base[]{} : this.valueCodeableConcept.toArray(new Base[this.valueCodeableConcept.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    this.path = this.castToString(value);
                    break;
                }
                case -1410174671: {
                    this.valueSet = (Type)value;
                    break;
                }
                case -766209282: {
                    this.getValueCode().add(this.castToCode(value));
                    break;
                }
                case -1887705029: {
                    this.getValueCoding().add(this.castToCoding(value));
                    break;
                }
                case 924902896: {
                    this.getValueCodeableConcept().add(this.castToCodeableConcept(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("path")) {
                this.path = this.castToString(value);
            } else if (name.equals("valueSet[x]")) {
                this.valueSet = (Type)value;
            } else if (name.equals("valueCode")) {
                this.getValueCode().add(this.castToCode(value));
            } else if (name.equals("valueCoding")) {
                this.getValueCoding().add(this.castToCoding(value));
            } else if (name.equals("valueCodeableConcept")) {
                this.getValueCodeableConcept().add(this.castToCodeableConcept(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    throw new FHIRException("Cannot make property path as it is not a complex type");
                }
                case -1438410321: {
                    return this.getValueSet();
                }
                case -766209282: {
                    throw new FHIRException("Cannot make property valueCode as it is not a complex type");
                }
                case -1887705029: {
                    return this.addValueCoding();
                }
                case 924902896: {
                    return this.addValueCodeableConcept();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a singleton property DataRequirement.path");
            }
            if (name.equals("valueSetString")) {
                this.valueSet = new StringType();
                return this.valueSet;
            }
            if (name.equals("valueSetReference")) {
                this.valueSet = new Reference();
                return this.valueSet;
            }
            if (name.equals("valueCode")) {
                throw new FHIRException("Cannot call addChild on a singleton property DataRequirement.valueCode");
            }
            if (name.equals("valueCoding")) {
                return this.addValueCoding();
            }
            if (name.equals("valueCodeableConcept")) {
                return this.addValueCodeableConcept();
            }
            return super.addChild(name);
        }

        @Override
        public DataRequirementCodeFilterComponent copy() {
            DataRequirementCodeFilterComponent dst = new DataRequirementCodeFilterComponent();
            this.copyValues(dst);
            dst.path = this.path == null ? null : this.path.copy();
            Type type = dst.valueSet = this.valueSet == null ? null : this.valueSet.copy();
            if (this.valueCode != null) {
                dst.valueCode = new ArrayList<CodeType>();
                for (CodeType codeType : this.valueCode) {
                    dst.valueCode.add(codeType.copy());
                }
            }
            if (this.valueCoding != null) {
                dst.valueCoding = new ArrayList<Coding>();
                for (Coding coding : this.valueCoding) {
                    dst.valueCoding.add(coding.copy());
                }
            }
            if (this.valueCodeableConcept != null) {
                dst.valueCodeableConcept = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.valueCodeableConcept) {
                    dst.valueCodeableConcept.add(codeableConcept.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DataRequirementCodeFilterComponent)) {
                return false;
            }
            DataRequirementCodeFilterComponent o = (DataRequirementCodeFilterComponent)other;
            return DataRequirementCodeFilterComponent.compareDeep(this.path, o.path, true) && DataRequirementCodeFilterComponent.compareDeep(this.valueSet, o.valueSet, true) && DataRequirementCodeFilterComponent.compareDeep(this.valueCode, o.valueCode, true) && DataRequirementCodeFilterComponent.compareDeep(this.valueCoding, o.valueCoding, true) && DataRequirementCodeFilterComponent.compareDeep(this.valueCodeableConcept, o.valueCodeableConcept, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DataRequirementCodeFilterComponent)) {
                return false;
            }
            DataRequirementCodeFilterComponent o = (DataRequirementCodeFilterComponent)other;
            return DataRequirementCodeFilterComponent.compareValues(this.path, o.path, true) && DataRequirementCodeFilterComponent.compareValues(this.valueCode, o.valueCode, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.path != null && !this.path.isEmpty() || this.valueSet != null && !this.valueSet.isEmpty() || this.valueCode != null && !this.valueCode.isEmpty() || this.valueCoding != null && !this.valueCoding.isEmpty() || this.valueCodeableConcept != null && !this.valueCodeableConcept.isEmpty());
        }

        @Override
        public String fhirType() {
            return "DataRequirement.codeFilter";
        }
    }
}

