/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.formats;

import org.hl7.fhir.dstu2016may.formats.RdfGenerator;
import org.hl7.fhir.dstu2016may.formats.RdfParserBase;
import org.hl7.fhir.dstu2016may.model.Account;
import org.hl7.fhir.dstu2016may.model.ActionDefinition;
import org.hl7.fhir.dstu2016may.model.Address;
import org.hl7.fhir.dstu2016may.model.AllergyIntolerance;
import org.hl7.fhir.dstu2016may.model.Annotation;
import org.hl7.fhir.dstu2016may.model.Appointment;
import org.hl7.fhir.dstu2016may.model.AppointmentResponse;
import org.hl7.fhir.dstu2016may.model.Attachment;
import org.hl7.fhir.dstu2016may.model.AuditEvent;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base64BinaryType;
import org.hl7.fhir.dstu2016may.model.Basic;
import org.hl7.fhir.dstu2016may.model.Binary;
import org.hl7.fhir.dstu2016may.model.BodySite;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.Bundle;
import org.hl7.fhir.dstu2016may.model.CarePlan;
import org.hl7.fhir.dstu2016may.model.CareTeam;
import org.hl7.fhir.dstu2016may.model.Claim;
import org.hl7.fhir.dstu2016may.model.ClaimResponse;
import org.hl7.fhir.dstu2016may.model.ClinicalImpression;
import org.hl7.fhir.dstu2016may.model.CodeSystem;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Communication;
import org.hl7.fhir.dstu2016may.model.CommunicationRequest;
import org.hl7.fhir.dstu2016may.model.CompartmentDefinition;
import org.hl7.fhir.dstu2016may.model.Composition;
import org.hl7.fhir.dstu2016may.model.ConceptMap;
import org.hl7.fhir.dstu2016may.model.Condition;
import org.hl7.fhir.dstu2016may.model.Conformance;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.Contract;
import org.hl7.fhir.dstu2016may.model.Coverage;
import org.hl7.fhir.dstu2016may.model.DataElement;
import org.hl7.fhir.dstu2016may.model.DataRequirement;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DateType;
import org.hl7.fhir.dstu2016may.model.DecimalType;
import org.hl7.fhir.dstu2016may.model.DecisionSupportRule;
import org.hl7.fhir.dstu2016may.model.DecisionSupportServiceModule;
import org.hl7.fhir.dstu2016may.model.DetectedIssue;
import org.hl7.fhir.dstu2016may.model.Device;
import org.hl7.fhir.dstu2016may.model.DeviceComponent;
import org.hl7.fhir.dstu2016may.model.DeviceMetric;
import org.hl7.fhir.dstu2016may.model.DeviceUseRequest;
import org.hl7.fhir.dstu2016may.model.DeviceUseStatement;
import org.hl7.fhir.dstu2016may.model.DiagnosticOrder;
import org.hl7.fhir.dstu2016may.model.DiagnosticReport;
import org.hl7.fhir.dstu2016may.model.DocumentManifest;
import org.hl7.fhir.dstu2016may.model.DocumentReference;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Element;
import org.hl7.fhir.dstu2016may.model.ElementDefinition;
import org.hl7.fhir.dstu2016may.model.EligibilityRequest;
import org.hl7.fhir.dstu2016may.model.EligibilityResponse;
import org.hl7.fhir.dstu2016may.model.Encounter;
import org.hl7.fhir.dstu2016may.model.EnrollmentRequest;
import org.hl7.fhir.dstu2016may.model.EnrollmentResponse;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.EpisodeOfCare;
import org.hl7.fhir.dstu2016may.model.ExpansionProfile;
import org.hl7.fhir.dstu2016may.model.ExplanationOfBenefit;
import org.hl7.fhir.dstu2016may.model.Extension;
import org.hl7.fhir.dstu2016may.model.FamilyMemberHistory;
import org.hl7.fhir.dstu2016may.model.Flag;
import org.hl7.fhir.dstu2016may.model.Goal;
import org.hl7.fhir.dstu2016may.model.Group;
import org.hl7.fhir.dstu2016may.model.GuidanceResponse;
import org.hl7.fhir.dstu2016may.model.HealthcareService;
import org.hl7.fhir.dstu2016may.model.HumanName;
import org.hl7.fhir.dstu2016may.model.IdType;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.ImagingExcerpt;
import org.hl7.fhir.dstu2016may.model.ImagingObjectSelection;
import org.hl7.fhir.dstu2016may.model.ImagingStudy;
import org.hl7.fhir.dstu2016may.model.Immunization;
import org.hl7.fhir.dstu2016may.model.ImmunizationRecommendation;
import org.hl7.fhir.dstu2016may.model.ImplementationGuide;
import org.hl7.fhir.dstu2016may.model.InstantType;
import org.hl7.fhir.dstu2016may.model.IntegerType;
import org.hl7.fhir.dstu2016may.model.Library;
import org.hl7.fhir.dstu2016may.model.Linkage;
import org.hl7.fhir.dstu2016may.model.ListResource;
import org.hl7.fhir.dstu2016may.model.Location;
import org.hl7.fhir.dstu2016may.model.MarkdownType;
import org.hl7.fhir.dstu2016may.model.Measure;
import org.hl7.fhir.dstu2016may.model.MeasureReport;
import org.hl7.fhir.dstu2016may.model.Media;
import org.hl7.fhir.dstu2016may.model.Medication;
import org.hl7.fhir.dstu2016may.model.MedicationAdministration;
import org.hl7.fhir.dstu2016may.model.MedicationDispense;
import org.hl7.fhir.dstu2016may.model.MedicationOrder;
import org.hl7.fhir.dstu2016may.model.MedicationStatement;
import org.hl7.fhir.dstu2016may.model.MessageHeader;
import org.hl7.fhir.dstu2016may.model.Meta;
import org.hl7.fhir.dstu2016may.model.ModuleDefinition;
import org.hl7.fhir.dstu2016may.model.ModuleMetadata;
import org.hl7.fhir.dstu2016may.model.NamingSystem;
import org.hl7.fhir.dstu2016may.model.Narrative;
import org.hl7.fhir.dstu2016may.model.NutritionOrder;
import org.hl7.fhir.dstu2016may.model.Observation;
import org.hl7.fhir.dstu2016may.model.OidType;
import org.hl7.fhir.dstu2016may.model.OperationDefinition;
import org.hl7.fhir.dstu2016may.model.OperationOutcome;
import org.hl7.fhir.dstu2016may.model.Order;
import org.hl7.fhir.dstu2016may.model.OrderResponse;
import org.hl7.fhir.dstu2016may.model.OrderSet;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.ParameterDefinition;
import org.hl7.fhir.dstu2016may.model.Parameters;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.PaymentNotice;
import org.hl7.fhir.dstu2016may.model.PaymentReconciliation;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.Person;
import org.hl7.fhir.dstu2016may.model.PositiveIntType;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PractitionerRole;
import org.hl7.fhir.dstu2016may.model.Procedure;
import org.hl7.fhir.dstu2016may.model.ProcedureRequest;
import org.hl7.fhir.dstu2016may.model.ProcessRequest;
import org.hl7.fhir.dstu2016may.model.ProcessResponse;
import org.hl7.fhir.dstu2016may.model.Protocol;
import org.hl7.fhir.dstu2016may.model.Provenance;
import org.hl7.fhir.dstu2016may.model.Quantity;
import org.hl7.fhir.dstu2016may.model.Questionnaire;
import org.hl7.fhir.dstu2016may.model.QuestionnaireResponse;
import org.hl7.fhir.dstu2016may.model.Range;
import org.hl7.fhir.dstu2016may.model.Ratio;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ReferralRequest;
import org.hl7.fhir.dstu2016may.model.RelatedPerson;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.RiskAssessment;
import org.hl7.fhir.dstu2016may.model.SampledData;
import org.hl7.fhir.dstu2016may.model.Schedule;
import org.hl7.fhir.dstu2016may.model.SearchParameter;
import org.hl7.fhir.dstu2016may.model.Sequence;
import org.hl7.fhir.dstu2016may.model.Signature;
import org.hl7.fhir.dstu2016may.model.Slot;
import org.hl7.fhir.dstu2016may.model.Specimen;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.StructureDefinition;
import org.hl7.fhir.dstu2016may.model.StructureMap;
import org.hl7.fhir.dstu2016may.model.Subscription;
import org.hl7.fhir.dstu2016may.model.Substance;
import org.hl7.fhir.dstu2016may.model.SupplyDelivery;
import org.hl7.fhir.dstu2016may.model.SupplyRequest;
import org.hl7.fhir.dstu2016may.model.Task;
import org.hl7.fhir.dstu2016may.model.TestScript;
import org.hl7.fhir.dstu2016may.model.TimeType;
import org.hl7.fhir.dstu2016may.model.Timing;
import org.hl7.fhir.dstu2016may.model.TriggerDefinition;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.UnsignedIntType;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.dstu2016may.model.UuidType;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.dstu2016may.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

public class RdfParser
extends RdfParserBase {
    public RdfParser() {
    }

    public RdfParser(boolean allowUnknownContent) {
        this.setAllowUnknownContent(allowUnknownContent);
    }

    protected void composeElement(RdfGenerator.Complex t, String parentType, String name, Element element, int index) {
        if (element == null) {
            return;
        }
        if (index > -1) {
            t.predicate("fhir:index", Integer.toString(index));
        }
        if (element.hasIdElement()) {
            this.composeId(t, "Element", "id", element.getIdElement(), -1);
        }
        for (int i = 0; i < element.getExtension().size(); ++i) {
            this.composeExtension(t, "Element", "extension", element.getExtension().get(i), i);
        }
    }

    protected void composeBackboneElement(RdfGenerator.Complex t, String tType, String name, BackboneElement element, int index) {
        this.composeElement(t, tType, name, element, index);
        for (int i = 0; i < element.getModifierExtension().size(); ++i) {
            this.composeExtension(t, "Element", "modifierExtension", element.getModifierExtension().get(i), i);
        }
    }

    private void composeEnum(RdfGenerator.Complex parent, String parentType, String name, Enumeration<? extends Enum> value, int index) {
        if (value == null) {
            return;
        }
        RdfGenerator.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
        this.decorateCode(t, value);
    }

    protected void composeMarkdown(RdfGenerator.Complex parent, String parentType, String name, MarkdownType value, int index) {
        if (value == null) {
            return;
        }
        RdfGenerator.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeInteger(RdfGenerator.Complex parent, String parentType, String name, IntegerType value, int index) {
        if (value == null) {
            return;
        }
        RdfGenerator.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeDateTime(RdfGenerator.Complex parent, String parentType, String name, DateTimeType value, int index) {
        if (value == null) {
            return;
        }
        RdfGenerator.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeUnsignedInt(RdfGenerator.Complex parent, String parentType, String name, UnsignedIntType value, int index) {
        if (value == null) {
            return;
        }
        RdfGenerator.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeCode(RdfGenerator.Complex parent, String parentType, String name, CodeType value, int index) {
        if (value == null) {
            return;
        }
        RdfGenerator.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
        this.decorateCode(t, value);
    }

    protected void composeDate(RdfGenerator.Complex parent, String parentType, String name, DateType value, int index) {
        if (value == null) {
            return;
        }
        RdfGenerator.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeDecimal(RdfGenerator.Complex parent, String parentType, String name, DecimalType value, int index) {
        if (value == null) {
            return;
        }
        RdfGenerator.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeUri(RdfGenerator.Complex parent, String parentType, String name, UriType value, int index) {
        if (value == null) {
            return;
        }
        RdfGenerator.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeId(RdfGenerator.Complex parent, String parentType, String name, IdType value, int index) {
        if (value == null) {
            return;
        }
        RdfGenerator.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeBase64Binary(RdfGenerator.Complex parent, String parentType, String name, Base64BinaryType value, int index) {
        if (value == null) {
            return;
        }
        RdfGenerator.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeTime(RdfGenerator.Complex parent, String parentType, String name, TimeType value, int index) {
        if (value == null) {
            return;
        }
        RdfGenerator.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeOid(RdfGenerator.Complex parent, String parentType, String name, OidType value, int index) {
        if (value == null) {
            return;
        }
        RdfGenerator.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composePositiveInt(RdfGenerator.Complex parent, String parentType, String name, PositiveIntType value, int index) {
        if (value == null) {
            return;
        }
        RdfGenerator.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeString(RdfGenerator.Complex parent, String parentType, String name, StringType value, int index) {
        if (value == null) {
            return;
        }
        RdfGenerator.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeBoolean(RdfGenerator.Complex parent, String parentType, String name, BooleanType value, int index) {
        if (value == null) {
            return;
        }
        RdfGenerator.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeUuid(RdfGenerator.Complex parent, String parentType, String name, UuidType value, int index) {
        if (value == null) {
            return;
        }
        RdfGenerator.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeInstant(RdfGenerator.Complex parent, String parentType, String name, InstantType value, int index) {
        if (value == null) {
            return;
        }
        RdfGenerator.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeExtension(RdfGenerator.Complex parent, String parentType, String name, Extension element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Extension", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "Extension", "url", element.getUrlElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "Extension", "value", element.getValue(), -1);
        }
    }

    protected void composeNarrative(RdfGenerator.Complex parent, String parentType, String name, Narrative element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Narrative", name, element, index);
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Narrative", "status", element.getStatusElement(), -1);
        }
        if (element.hasDiv()) {
            this.composeXhtml(t, "Narrative", "div", element.getDiv(), -1);
        }
    }

    protected void composePeriod(RdfGenerator.Complex parent, String parentType, String name, Period element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Period", name, element, index);
        if (element.hasStartElement()) {
            this.composeDateTime(t, "Period", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeDateTime(t, "Period", "end", element.getEndElement(), -1);
        }
    }

    protected void composeCoding(RdfGenerator.Complex parent, String parentType, String name, Coding element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Coding", name, element, index);
        this.decorateCoding(t, element);
        if (element.hasSystemElement()) {
            this.composeUri(t, "Coding", "system", element.getSystemElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Coding", "version", element.getVersionElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "Coding", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "Coding", "display", element.getDisplayElement(), -1);
        }
        if (element.hasUserSelectedElement()) {
            this.composeBoolean(t, "Coding", "userSelected", element.getUserSelectedElement(), -1);
        }
    }

    protected void composeRange(RdfGenerator.Complex parent, String parentType, String name, Range element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Range", name, element, index);
        if (element.hasLow()) {
            this.composeQuantity(t, "Range", "low", element.getLow(), -1);
        }
        if (element.hasHigh()) {
            this.composeQuantity(t, "Range", "high", element.getHigh(), -1);
        }
    }

    protected void composeQuantity(RdfGenerator.Complex parent, String parentType, String name, Quantity element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Quantity", name, element, index);
        if (element.hasValueElement()) {
            this.composeDecimal(t, "Quantity", "value", element.getValueElement(), -1);
        }
        if (element.hasComparatorElement()) {
            this.composeEnum(t, "Quantity", "comparator", element.getComparatorElement(), -1);
        }
        if (element.hasUnitElement()) {
            this.composeString(t, "Quantity", "unit", element.getUnitElement(), -1);
        }
        if (element.hasSystemElement()) {
            this.composeUri(t, "Quantity", "system", element.getSystemElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "Quantity", "code", element.getCodeElement(), -1);
        }
    }

    protected void composeAttachment(RdfGenerator.Complex parent, String parentType, String name, Attachment element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Attachment", name, element, index);
        if (element.hasContentTypeElement()) {
            this.composeCode(t, "Attachment", "contentType", element.getContentTypeElement(), -1);
        }
        if (element.hasLanguageElement()) {
            this.composeCode(t, "Attachment", "language", element.getLanguageElement(), -1);
        }
        if (element.hasDataElement()) {
            this.composeBase64Binary(t, "Attachment", "data", element.getDataElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "Attachment", "url", element.getUrlElement(), -1);
        }
        if (element.hasSizeElement()) {
            this.composeUnsignedInt(t, "Attachment", "size", element.getSizeElement(), -1);
        }
        if (element.hasHashElement()) {
            this.composeBase64Binary(t, "Attachment", "hash", element.getHashElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Attachment", "title", element.getTitleElement(), -1);
        }
        if (element.hasCreationElement()) {
            this.composeDateTime(t, "Attachment", "creation", element.getCreationElement(), -1);
        }
    }

    protected void composeRatio(RdfGenerator.Complex parent, String parentType, String name, Ratio element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Ratio", name, element, index);
        if (element.hasNumerator()) {
            this.composeQuantity(t, "Ratio", "numerator", element.getNumerator(), -1);
        }
        if (element.hasDenominator()) {
            this.composeQuantity(t, "Ratio", "denominator", element.getDenominator(), -1);
        }
    }

    protected void composeAnnotation(RdfGenerator.Complex parent, String parentType, String name, Annotation element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Annotation", name, element, index);
        if (element.hasAuthor()) {
            this.composeType(t, "Annotation", "author", element.getAuthor(), -1);
        }
        if (element.hasTimeElement()) {
            this.composeDateTime(t, "Annotation", "time", element.getTimeElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "Annotation", "text", element.getTextElement(), -1);
        }
    }

    protected void composeSampledData(RdfGenerator.Complex parent, String parentType, String name, SampledData element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "SampledData", name, element, index);
        if (element.hasOrigin()) {
            this.composeQuantity(t, "SampledData", "origin", element.getOrigin(), -1);
        }
        if (element.hasPeriodElement()) {
            this.composeDecimal(t, "SampledData", "period", element.getPeriodElement(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "SampledData", "factor", element.getFactorElement(), -1);
        }
        if (element.hasLowerLimitElement()) {
            this.composeDecimal(t, "SampledData", "lowerLimit", element.getLowerLimitElement(), -1);
        }
        if (element.hasUpperLimitElement()) {
            this.composeDecimal(t, "SampledData", "upperLimit", element.getUpperLimitElement(), -1);
        }
        if (element.hasDimensionsElement()) {
            this.composePositiveInt(t, "SampledData", "dimensions", element.getDimensionsElement(), -1);
        }
        if (element.hasDataElement()) {
            this.composeString(t, "SampledData", "data", element.getDataElement(), -1);
        }
    }

    protected void composeReference(RdfGenerator.Complex parent, String parentType, String name, Reference element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Reference", name, element, index);
        if (element.hasReferenceElement()) {
            this.composeString(t, "Reference", "reference", element.getReferenceElement_(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "Reference", "display", element.getDisplayElement(), -1);
        }
    }

    protected void composeCodeableConcept(RdfGenerator.Complex parent, String parentType, String name, CodeableConcept element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "CodeableConcept", name, element, index);
        this.decorateCodeableConcept(t, element);
        for (int i = 0; i < element.getCoding().size(); ++i) {
            this.composeCoding(t, "CodeableConcept", "coding", element.getCoding().get(i), i);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "CodeableConcept", "text", element.getTextElement(), -1);
        }
    }

    protected void composeIdentifier(RdfGenerator.Complex parent, String parentType, String name, Identifier element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Identifier", name, element, index);
        if (element.hasUseElement()) {
            this.composeEnum(t, "Identifier", "use", element.getUseElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Identifier", "type", element.getType(), -1);
        }
        if (element.hasSystemElement()) {
            this.composeUri(t, "Identifier", "system", element.getSystemElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "Identifier", "value", element.getValueElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Identifier", "period", element.getPeriod(), -1);
        }
        if (element.hasAssigner()) {
            this.composeReference(t, "Identifier", "assigner", element.getAssigner(), -1);
        }
    }

    protected void composeSignature(RdfGenerator.Complex parent, String parentType, String name, Signature element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Signature", name, element, index);
        for (int i = 0; i < element.getType().size(); ++i) {
            this.composeCoding(t, "Signature", "type", element.getType().get(i), i);
        }
        if (element.hasWhenElement()) {
            this.composeInstant(t, "Signature", "when", element.getWhenElement(), -1);
        }
        if (element.hasWho()) {
            this.composeType(t, "Signature", "who", element.getWho(), -1);
        }
        if (element.hasContentTypeElement()) {
            this.composeCode(t, "Signature", "contentType", element.getContentTypeElement(), -1);
        }
        if (element.hasBlobElement()) {
            this.composeBase64Binary(t, "Signature", "blob", element.getBlobElement(), -1);
        }
    }

    protected void composeTriggerDefinition(RdfGenerator.Complex parent, String parentType, String name, TriggerDefinition element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "TriggerDefinition", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "TriggerDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasEventNameElement()) {
            this.composeString(t, "TriggerDefinition", "eventName", element.getEventNameElement(), -1);
        }
        if (element.hasEventTiming()) {
            this.composeType(t, "TriggerDefinition", "eventTiming", element.getEventTiming(), -1);
        }
        if (element.hasEventData()) {
            this.composeDataRequirement(t, "TriggerDefinition", "eventData", element.getEventData(), -1);
        }
    }

    protected void composeElementDefinition(RdfGenerator.Complex parent, String parentType, String name, ElementDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "ElementDefinition", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "ElementDefinition", "path", element.getPathElement(), -1);
        }
        for (i = 0; i < element.getRepresentation().size(); ++i) {
            this.composeEnum(t, "ElementDefinition", "representation", element.getRepresentation().get(i), i);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ElementDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasLabelElement()) {
            this.composeString(t, "ElementDefinition", "label", element.getLabelElement(), -1);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCoding(t, "ElementDefinition", "code", element.getCode().get(i), i);
        }
        if (element.hasSlicing()) {
            this.composeElementDefinitionElementDefinitionSlicingComponent(t, "ElementDefinition", "slicing", element.getSlicing(), -1);
        }
        if (element.hasShortElement()) {
            this.composeString(t, "ElementDefinition", "short", element.getShortElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeMarkdown(t, "ElementDefinition", "definition", element.getDefinitionElement(), -1);
        }
        if (element.hasCommentsElement()) {
            this.composeMarkdown(t, "ElementDefinition", "comments", element.getCommentsElement(), -1);
        }
        if (element.hasRequirementsElement()) {
            this.composeMarkdown(t, "ElementDefinition", "requirements", element.getRequirementsElement(), -1);
        }
        for (i = 0; i < element.getAlias().size(); ++i) {
            this.composeString(t, "ElementDefinition", "alias", element.getAlias().get(i), i);
        }
        if (element.hasMinElement()) {
            this.composeInteger(t, "ElementDefinition", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "ElementDefinition", "max", element.getMaxElement(), -1);
        }
        if (element.hasBase()) {
            this.composeElementDefinitionElementDefinitionBaseComponent(t, "ElementDefinition", "base", element.getBase(), -1);
        }
        if (element.hasContentReferenceElement()) {
            this.composeUri(t, "ElementDefinition", "contentReference", element.getContentReferenceElement(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeElementDefinitionTypeRefComponent(t, "ElementDefinition", "type", element.getType().get(i), i);
        }
        if (element.hasDefaultValue()) {
            this.composeType(t, "ElementDefinition", "defaultValue", element.getDefaultValue(), -1);
        }
        if (element.hasMeaningWhenMissingElement()) {
            this.composeMarkdown(t, "ElementDefinition", "meaningWhenMissing", element.getMeaningWhenMissingElement(), -1);
        }
        if (element.hasFixed()) {
            this.composeType(t, "ElementDefinition", "fixed", element.getFixed(), -1);
        }
        if (element.hasPattern()) {
            this.composeType(t, "ElementDefinition", "pattern", element.getPattern(), -1);
        }
        if (element.hasExample()) {
            this.composeType(t, "ElementDefinition", "example", element.getExample(), -1);
        }
        if (element.hasMinValue()) {
            this.composeType(t, "ElementDefinition", "minValue", element.getMinValue(), -1);
        }
        if (element.hasMaxValue()) {
            this.composeType(t, "ElementDefinition", "maxValue", element.getMaxValue(), -1);
        }
        if (element.hasMaxLengthElement()) {
            this.composeInteger(t, "ElementDefinition", "maxLength", element.getMaxLengthElement(), -1);
        }
        for (i = 0; i < element.getCondition().size(); ++i) {
            this.composeId(t, "ElementDefinition", "condition", element.getCondition().get(i), i);
        }
        for (i = 0; i < element.getConstraint().size(); ++i) {
            this.composeElementDefinitionElementDefinitionConstraintComponent(t, "ElementDefinition", "constraint", element.getConstraint().get(i), i);
        }
        if (element.hasMustSupportElement()) {
            this.composeBoolean(t, "ElementDefinition", "mustSupport", element.getMustSupportElement(), -1);
        }
        if (element.hasIsModifierElement()) {
            this.composeBoolean(t, "ElementDefinition", "isModifier", element.getIsModifierElement(), -1);
        }
        if (element.hasIsSummaryElement()) {
            this.composeBoolean(t, "ElementDefinition", "isSummary", element.getIsSummaryElement(), -1);
        }
        if (element.hasBinding()) {
            this.composeElementDefinitionElementDefinitionBindingComponent(t, "ElementDefinition", "binding", element.getBinding(), -1);
        }
        for (i = 0; i < element.getMapping().size(); ++i) {
            this.composeElementDefinitionElementDefinitionMappingComponent(t, "ElementDefinition", "mapping", element.getMapping().get(i), i);
        }
    }

    protected void composeElementDefinitionElementDefinitionSlicingComponent(RdfGenerator.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionSlicingComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "slicing", name, element, index);
        for (int i = 0; i < element.getDiscriminator().size(); ++i) {
            this.composeString(t, "ElementDefinition", "discriminator", element.getDiscriminator().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ElementDefinition", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasOrderedElement()) {
            this.composeBoolean(t, "ElementDefinition", "ordered", element.getOrderedElement(), -1);
        }
        if (element.hasRulesElement()) {
            this.composeEnum(t, "ElementDefinition", "rules", element.getRulesElement(), -1);
        }
    }

    protected void composeElementDefinitionElementDefinitionBaseComponent(RdfGenerator.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionBaseComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "base", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "ElementDefinition", "path", element.getPathElement(), -1);
        }
        if (element.hasMinElement()) {
            this.composeInteger(t, "ElementDefinition", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "ElementDefinition", "max", element.getMaxElement(), -1);
        }
    }

    protected void composeElementDefinitionTypeRefComponent(RdfGenerator.Complex parent, String parentType, String name, ElementDefinition.TypeRefComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "type", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "ElementDefinition", "code", element.getCodeElement(), -1);
        }
        for (i = 0; i < element.getProfile().size(); ++i) {
            this.composeUri(t, "ElementDefinition", "profile", element.getProfile().get(i), i);
        }
        for (i = 0; i < element.getAggregation().size(); ++i) {
            this.composeEnum(t, "ElementDefinition", "aggregation", element.getAggregation().get(i), i);
        }
        if (element.hasVersioningElement()) {
            this.composeEnum(t, "ElementDefinition", "versioning", element.getVersioningElement(), -1);
        }
    }

    protected void composeElementDefinitionElementDefinitionConstraintComponent(RdfGenerator.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionConstraintComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "constraint", name, element, index);
        if (element.hasKeyElement()) {
            this.composeId(t, "ElementDefinition", "key", element.getKeyElement(), -1);
        }
        if (element.hasRequirementsElement()) {
            this.composeString(t, "ElementDefinition", "requirements", element.getRequirementsElement(), -1);
        }
        if (element.hasSeverityElement()) {
            this.composeEnum(t, "ElementDefinition", "severity", element.getSeverityElement(), -1);
        }
        if (element.hasHumanElement()) {
            this.composeString(t, "ElementDefinition", "human", element.getHumanElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "ElementDefinition", "expression", element.getExpressionElement(), -1);
        }
        if (element.hasXpathElement()) {
            this.composeString(t, "ElementDefinition", "xpath", element.getXpathElement(), -1);
        }
    }

    protected void composeElementDefinitionElementDefinitionBindingComponent(RdfGenerator.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionBindingComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "binding", name, element, index);
        if (element.hasStrengthElement()) {
            this.composeEnum(t, "ElementDefinition", "strength", element.getStrengthElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ElementDefinition", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasValueSet()) {
            this.composeType(t, "ElementDefinition", "valueSet", element.getValueSet(), -1);
        }
    }

    protected void composeElementDefinitionElementDefinitionMappingComponent(RdfGenerator.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionMappingComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "mapping", name, element, index);
        if (element.hasIdentityElement()) {
            this.composeId(t, "ElementDefinition", "identity", element.getIdentityElement(), -1);
        }
        if (element.hasLanguageElement()) {
            this.composeCode(t, "ElementDefinition", "language", element.getLanguageElement(), -1);
        }
        if (element.hasMapElement()) {
            this.composeString(t, "ElementDefinition", "map", element.getMapElement(), -1);
        }
    }

    protected void composeTiming(RdfGenerator.Complex parent, String parentType, String name, Timing element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Timing", name, element, index);
        for (int i = 0; i < element.getEvent().size(); ++i) {
            this.composeDateTime(t, "Timing", "event", element.getEvent().get(i), i);
        }
        if (element.hasRepeat()) {
            this.composeTimingTimingRepeatComponent(t, "Timing", "repeat", element.getRepeat(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Timing", "code", element.getCode(), -1);
        }
    }

    protected void composeTimingTimingRepeatComponent(RdfGenerator.Complex parent, String parentType, String name, Timing.TimingRepeatComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "repeat", name, element, index);
        if (element.hasBounds()) {
            this.composeType(t, "Timing", "bounds", element.getBounds(), -1);
        }
        if (element.hasCountElement()) {
            this.composeInteger(t, "Timing", "count", element.getCountElement(), -1);
        }
        if (element.hasCountMaxElement()) {
            this.composeInteger(t, "Timing", "countMax", element.getCountMaxElement(), -1);
        }
        if (element.hasDurationElement()) {
            this.composeDecimal(t, "Timing", "duration", element.getDurationElement(), -1);
        }
        if (element.hasDurationMaxElement()) {
            this.composeDecimal(t, "Timing", "durationMax", element.getDurationMaxElement(), -1);
        }
        if (element.hasDurationUnitElement()) {
            this.composeEnum(t, "Timing", "durationUnit", element.getDurationUnitElement(), -1);
        }
        if (element.hasFrequencyElement()) {
            this.composeInteger(t, "Timing", "frequency", element.getFrequencyElement(), -1);
        }
        if (element.hasFrequencyMaxElement()) {
            this.composeInteger(t, "Timing", "frequencyMax", element.getFrequencyMaxElement(), -1);
        }
        if (element.hasPeriodElement()) {
            this.composeDecimal(t, "Timing", "period", element.getPeriodElement(), -1);
        }
        if (element.hasPeriodMaxElement()) {
            this.composeDecimal(t, "Timing", "periodMax", element.getPeriodMaxElement(), -1);
        }
        if (element.hasPeriodUnitElement()) {
            this.composeEnum(t, "Timing", "periodUnit", element.getPeriodUnitElement(), -1);
        }
        if (element.hasWhenElement()) {
            this.composeEnum(t, "Timing", "when", element.getWhenElement(), -1);
        }
        if (element.hasOffsetElement()) {
            this.composeUnsignedInt(t, "Timing", "offset", element.getOffsetElement(), -1);
        }
    }

    protected void composeModuleMetadata(RdfGenerator.Complex parent, String parentType, String name, ModuleMetadata element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "ModuleMetadata", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ModuleMetadata", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ModuleMetadata", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ModuleMetadata", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ModuleMetadata", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ModuleMetadata", "title", element.getTitleElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ModuleMetadata", "type", element.getTypeElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ModuleMetadata", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ModuleMetadata", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ModuleMetadata", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasPurposeElement()) {
            this.composeString(t, "ModuleMetadata", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "ModuleMetadata", "usage", element.getUsageElement(), -1);
        }
        if (element.hasPublicationDateElement()) {
            this.composeDate(t, "ModuleMetadata", "publicationDate", element.getPublicationDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "ModuleMetadata", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "ModuleMetadata", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i = 0; i < element.getCoverage().size(); ++i) {
            this.composeModuleMetadataModuleMetadataCoverageComponent(t, "ModuleMetadata", "coverage", element.getCoverage().get(i), i);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeCodeableConcept(t, "ModuleMetadata", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getContributor().size(); ++i) {
            this.composeModuleMetadataModuleMetadataContributorComponent(t, "ModuleMetadata", "contributor", element.getContributor().get(i), i);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ModuleMetadata", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeModuleMetadataModuleMetadataContactComponent(t, "ModuleMetadata", "contact", element.getContact().get(i), i);
        }
        if (element.hasCopyrightElement()) {
            this.composeString(t, "ModuleMetadata", "copyright", element.getCopyrightElement(), -1);
        }
        for (i = 0; i < element.getRelatedResource().size(); ++i) {
            this.composeModuleMetadataModuleMetadataRelatedResourceComponent(t, "ModuleMetadata", "relatedResource", element.getRelatedResource().get(i), i);
        }
    }

    protected void composeModuleMetadataModuleMetadataCoverageComponent(RdfGenerator.Complex parent, String parentType, String name, ModuleMetadata.ModuleMetadataCoverageComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "coverage", name, element, index);
        if (element.hasFocus()) {
            this.composeCoding(t, "ModuleMetadata", "focus", element.getFocus(), -1);
        }
        if (element.hasValue()) {
            this.composeCodeableConcept(t, "ModuleMetadata", "value", element.getValue(), -1);
        }
    }

    protected void composeModuleMetadataModuleMetadataContributorComponent(RdfGenerator.Complex parent, String parentType, String name, ModuleMetadata.ModuleMetadataContributorComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "contributor", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ModuleMetadata", "type", element.getTypeElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ModuleMetadata", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getContact().size(); ++i) {
            this.composeModuleMetadataModuleMetadataContributorContactComponent(t, "ModuleMetadata", "contact", element.getContact().get(i), i);
        }
    }

    protected void composeModuleMetadataModuleMetadataContributorContactComponent(RdfGenerator.Complex parent, String parentType, String name, ModuleMetadata.ModuleMetadataContributorContactComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "contact", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ModuleMetadata", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "ModuleMetadata", "telecom", element.getTelecom().get(i), i);
        }
    }

    protected void composeModuleMetadataModuleMetadataContactComponent(RdfGenerator.Complex parent, String parentType, String name, ModuleMetadata.ModuleMetadataContactComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "contact", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ModuleMetadata", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "ModuleMetadata", "telecom", element.getTelecom().get(i), i);
        }
    }

    protected void composeModuleMetadataModuleMetadataRelatedResourceComponent(RdfGenerator.Complex parent, String parentType, String name, ModuleMetadata.ModuleMetadataRelatedResourceComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "relatedResource", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ModuleMetadata", "type", element.getTypeElement(), -1);
        }
        if (element.hasDocument()) {
            this.composeAttachment(t, "ModuleMetadata", "document", element.getDocument(), -1);
        }
        if (element.hasResource()) {
            this.composeReference(t, "ModuleMetadata", "resource", element.getResource(), -1);
        }
    }

    protected void composeActionDefinition(RdfGenerator.Complex parent, String parentType, String name, ActionDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "ActionDefinition", name, element, index);
        if (element.hasActionIdentifier()) {
            this.composeIdentifier(t, "ActionDefinition", "actionIdentifier", element.getActionIdentifier(), -1);
        }
        if (element.hasLabelElement()) {
            this.composeString(t, "ActionDefinition", "label", element.getLabelElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ActionDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ActionDefinition", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasTextEquivalentElement()) {
            this.composeString(t, "ActionDefinition", "textEquivalent", element.getTextEquivalentElement(), -1);
        }
        for (i = 0; i < element.getConcept().size(); ++i) {
            this.composeCodeableConcept(t, "ActionDefinition", "concept", element.getConcept().get(i), i);
        }
        for (i = 0; i < element.getSupportingEvidence().size(); ++i) {
            this.composeAttachment(t, "ActionDefinition", "supportingEvidence", element.getSupportingEvidence().get(i), i);
        }
        for (i = 0; i < element.getDocumentation().size(); ++i) {
            this.composeAttachment(t, "ActionDefinition", "documentation", element.getDocumentation().get(i), i);
        }
        if (element.hasRelatedAction()) {
            this.composeActionDefinitionActionDefinitionRelatedActionComponent(t, "ActionDefinition", "relatedAction", element.getRelatedAction(), -1);
        }
        for (i = 0; i < element.getParticipantType().size(); ++i) {
            this.composeEnum(t, "ActionDefinition", "participantType", element.getParticipantType().get(i), i);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ActionDefinition", "type", element.getTypeElement(), -1);
        }
        for (i = 0; i < element.getBehavior().size(); ++i) {
            this.composeActionDefinitionActionDefinitionBehaviorComponent(t, "ActionDefinition", "behavior", element.getBehavior().get(i), i);
        }
        if (element.hasResource()) {
            this.composeReference(t, "ActionDefinition", "resource", element.getResource(), -1);
        }
        for (i = 0; i < element.getCustomization().size(); ++i) {
            this.composeActionDefinitionActionDefinitionCustomizationComponent(t, "ActionDefinition", "customization", element.getCustomization().get(i), i);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composeActionDefinition(t, "ActionDefinition", "action", element.getAction().get(i), i);
        }
    }

    protected void composeActionDefinitionActionDefinitionRelatedActionComponent(RdfGenerator.Complex parent, String parentType, String name, ActionDefinition.ActionDefinitionRelatedActionComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "relatedAction", name, element, index);
        if (element.hasActionIdentifier()) {
            this.composeIdentifier(t, "ActionDefinition", "actionIdentifier", element.getActionIdentifier(), -1);
        }
        if (element.hasRelationshipElement()) {
            this.composeEnum(t, "ActionDefinition", "relationship", element.getRelationshipElement(), -1);
        }
        if (element.hasOffset()) {
            this.composeType(t, "ActionDefinition", "offset", element.getOffset(), -1);
        }
        if (element.hasAnchorElement()) {
            this.composeEnum(t, "ActionDefinition", "anchor", element.getAnchorElement(), -1);
        }
    }

    protected void composeActionDefinitionActionDefinitionBehaviorComponent(RdfGenerator.Complex parent, String parentType, String name, ActionDefinition.ActionDefinitionBehaviorComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "behavior", name, element, index);
        if (element.hasType()) {
            this.composeCoding(t, "ActionDefinition", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeCoding(t, "ActionDefinition", "value", element.getValue(), -1);
        }
    }

    protected void composeActionDefinitionActionDefinitionCustomizationComponent(RdfGenerator.Complex parent, String parentType, String name, ActionDefinition.ActionDefinitionCustomizationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "customization", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "ActionDefinition", "path", element.getPathElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "ActionDefinition", "expression", element.getExpressionElement(), -1);
        }
    }

    protected void composeAddress(RdfGenerator.Complex parent, String parentType, String name, Address element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Address", name, element, index);
        if (element.hasUseElement()) {
            this.composeEnum(t, "Address", "use", element.getUseElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Address", "type", element.getTypeElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "Address", "text", element.getTextElement(), -1);
        }
        for (int i = 0; i < element.getLine().size(); ++i) {
            this.composeString(t, "Address", "line", element.getLine().get(i), i);
        }
        if (element.hasCityElement()) {
            this.composeString(t, "Address", "city", element.getCityElement(), -1);
        }
        if (element.hasDistrictElement()) {
            this.composeString(t, "Address", "district", element.getDistrictElement(), -1);
        }
        if (element.hasStateElement()) {
            this.composeString(t, "Address", "state", element.getStateElement(), -1);
        }
        if (element.hasPostalCodeElement()) {
            this.composeString(t, "Address", "postalCode", element.getPostalCodeElement(), -1);
        }
        if (element.hasCountryElement()) {
            this.composeString(t, "Address", "country", element.getCountryElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Address", "period", element.getPeriod(), -1);
        }
    }

    protected void composeHumanName(RdfGenerator.Complex parent, String parentType, String name, HumanName element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "HumanName", name, element, index);
        if (element.hasUseElement()) {
            this.composeEnum(t, "HumanName", "use", element.getUseElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "HumanName", "text", element.getTextElement(), -1);
        }
        for (i = 0; i < element.getFamily().size(); ++i) {
            this.composeString(t, "HumanName", "family", element.getFamily().get(i), i);
        }
        for (i = 0; i < element.getGiven().size(); ++i) {
            this.composeString(t, "HumanName", "given", element.getGiven().get(i), i);
        }
        for (i = 0; i < element.getPrefix().size(); ++i) {
            this.composeString(t, "HumanName", "prefix", element.getPrefix().get(i), i);
        }
        for (i = 0; i < element.getSuffix().size(); ++i) {
            this.composeString(t, "HumanName", "suffix", element.getSuffix().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "HumanName", "period", element.getPeriod(), -1);
        }
    }

    protected void composeDataRequirement(RdfGenerator.Complex parent, String parentType, String name, DataRequirement element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "DataRequirement", name, element, index);
        if (element.hasTypeElement()) {
            this.composeCode(t, "DataRequirement", "type", element.getTypeElement(), -1);
        }
        if (element.hasProfile()) {
            this.composeReference(t, "DataRequirement", "profile", element.getProfile(), -1);
        }
        for (i = 0; i < element.getMustSupport().size(); ++i) {
            this.composeString(t, "DataRequirement", "mustSupport", element.getMustSupport().get(i), i);
        }
        for (i = 0; i < element.getCodeFilter().size(); ++i) {
            this.composeDataRequirementDataRequirementCodeFilterComponent(t, "DataRequirement", "codeFilter", element.getCodeFilter().get(i), i);
        }
        for (i = 0; i < element.getDateFilter().size(); ++i) {
            this.composeDataRequirementDataRequirementDateFilterComponent(t, "DataRequirement", "dateFilter", element.getDateFilter().get(i), i);
        }
    }

    protected void composeDataRequirementDataRequirementCodeFilterComponent(RdfGenerator.Complex parent, String parentType, String name, DataRequirement.DataRequirementCodeFilterComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "codeFilter", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "DataRequirement", "path", element.getPathElement(), -1);
        }
        if (element.hasValueSet()) {
            this.composeType(t, "DataRequirement", "valueSet", element.getValueSet(), -1);
        }
        for (i = 0; i < element.getValueCode().size(); ++i) {
            this.composeCode(t, "DataRequirement", "valueCode", element.getValueCode().get(i), i);
        }
        for (i = 0; i < element.getValueCoding().size(); ++i) {
            this.composeCoding(t, "DataRequirement", "valueCoding", element.getValueCoding().get(i), i);
        }
        for (i = 0; i < element.getValueCodeableConcept().size(); ++i) {
            this.composeCodeableConcept(t, "DataRequirement", "valueCodeableConcept", element.getValueCodeableConcept().get(i), i);
        }
    }

    protected void composeDataRequirementDataRequirementDateFilterComponent(RdfGenerator.Complex parent, String parentType, String name, DataRequirement.DataRequirementDateFilterComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "dateFilter", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "DataRequirement", "path", element.getPathElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "DataRequirement", "value", element.getValue(), -1);
        }
    }

    protected void composeMeta(RdfGenerator.Complex parent, String parentType, String name, Meta element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "Meta", name, element, index);
        if (element.hasVersionIdElement()) {
            this.composeId(t, "Meta", "versionId", element.getVersionIdElement(), -1);
        }
        if (element.hasLastUpdatedElement()) {
            this.composeInstant(t, "Meta", "lastUpdated", element.getLastUpdatedElement(), -1);
        }
        for (i = 0; i < element.getProfile().size(); ++i) {
            this.composeUri(t, "Meta", "profile", element.getProfile().get(i), i);
        }
        for (i = 0; i < element.getSecurity().size(); ++i) {
            this.composeCoding(t, "Meta", "security", element.getSecurity().get(i), i);
        }
        for (i = 0; i < element.getTag().size(); ++i) {
            this.composeCoding(t, "Meta", "tag", element.getTag().get(i), i);
        }
    }

    protected void composeParameterDefinition(RdfGenerator.Complex parent, String parentType, String name, ParameterDefinition element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "ParameterDefinition", name, element, index);
        if (element.hasNameElement()) {
            this.composeCode(t, "ParameterDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasUseElement()) {
            this.composeCode(t, "ParameterDefinition", "use", element.getUseElement(), -1);
        }
        if (element.hasMinElement()) {
            this.composeInteger(t, "ParameterDefinition", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "ParameterDefinition", "max", element.getMaxElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "ParameterDefinition", "documentation", element.getDocumentationElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeCode(t, "ParameterDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasProfile()) {
            this.composeReference(t, "ParameterDefinition", "profile", element.getProfile(), -1);
        }
    }

    protected void composeContactPoint(RdfGenerator.Complex parent, String parentType, String name, ContactPoint element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "ContactPoint", name, element, index);
        if (element.hasSystemElement()) {
            this.composeEnum(t, "ContactPoint", "system", element.getSystemElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "ContactPoint", "value", element.getValueElement(), -1);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "ContactPoint", "use", element.getUseElement(), -1);
        }
        if (element.hasRankElement()) {
            this.composePositiveInt(t, "ContactPoint", "rank", element.getRankElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "ContactPoint", "period", element.getPeriod(), -1);
        }
    }

    protected void composeParameters(RdfGenerator.Complex parent, String parentType, String name, Parameters element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeResource(t, "Parameters", name, element, index);
        for (int i = 0; i < element.getParameter().size(); ++i) {
            this.composeParametersParametersParameterComponent(t, "Parameters", "parameter", element.getParameter().get(i), i);
        }
    }

    protected void composeParametersParametersParameterComponent(RdfGenerator.Complex parent, String parentType, String name, Parameters.ParametersParameterComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "parameter", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "Parameters", "name", element.getNameElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "Parameters", "value", element.getValue(), -1);
        }
        if (element.hasResource()) {
            this.composeResource(t, "Parameters", "resource", element.getResource(), -1);
        }
        for (int i = 0; i < element.getPart().size(); ++i) {
            this.composeParametersParametersParameterComponent(t, "Parameters", "part", element.getPart().get(i), i);
        }
    }

    protected void composeResource(RdfGenerator.Complex t, String parentType, String name, Resource element, int index) {
        if (element.hasIdElement()) {
            this.composeId(t, "Resource", "id", element.getIdElement(), -1);
        }
        if (element.hasMeta()) {
            this.composeMeta(t, "Resource", "meta", element.getMeta(), -1);
        }
        if (element.hasImplicitRulesElement()) {
            this.composeUri(t, "Resource", "implicitRules", element.getImplicitRulesElement(), -1);
        }
        if (element.hasLanguageElement()) {
            this.composeCode(t, "Resource", "language", element.getLanguageElement(), -1);
        }
    }

    protected void composeDomainResource(RdfGenerator.Complex t, String parentType, String name, DomainResource element, int index) {
        int i;
        this.composeResource(t, parentType, name, element, index);
        if (element.hasText()) {
            this.composeNarrative(t, "DomainResource", "text", element.getText(), -1);
        }
        for (i = 0; i < element.getContained().size(); ++i) {
            this.composeResource(t, "DomainResource", "contained", element.getContained().get(i), i);
        }
        for (i = 0; i < element.getExtension().size(); ++i) {
            this.composeExtension(t, "DomainResource", "extension", element.getExtension().get(i), i);
        }
        for (i = 0; i < element.getModifierExtension().size(); ++i) {
            this.composeExtension(t, "DomainResource", "modifierExtension", element.getModifierExtension().get(i), i);
        }
    }

    protected void composeAccount(RdfGenerator.Complex parent, String parentType, String name, Account element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Account", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Account", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Account", "name", element.getNameElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Account", "type", element.getType(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Account", "status", element.getStatusElement(), -1);
        }
        if (element.hasActivePeriod()) {
            this.composePeriod(t, "Account", "activePeriod", element.getActivePeriod(), -1);
        }
        if (element.hasCurrency()) {
            this.composeCoding(t, "Account", "currency", element.getCurrency(), -1);
        }
        if (element.hasBalance()) {
            this.composeQuantity(t, "Account", "balance", element.getBalance(), -1);
        }
        if (element.hasCoveragePeriod()) {
            this.composePeriod(t, "Account", "coveragePeriod", element.getCoveragePeriod(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Account", "subject", element.getSubject(), -1);
        }
        if (element.hasOwner()) {
            this.composeReference(t, "Account", "owner", element.getOwner(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Account", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeAllergyIntolerance(RdfGenerator.Complex parent, String parentType, String name, AllergyIntolerance element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "AllergyIntolerance", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "AllergyIntolerance", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "AllergyIntolerance", "status", element.getStatusElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "AllergyIntolerance", "type", element.getTypeElement(), -1);
        }
        if (element.hasCategoryElement()) {
            this.composeEnum(t, "AllergyIntolerance", "category", element.getCategoryElement(), -1);
        }
        if (element.hasCriticalityElement()) {
            this.composeEnum(t, "AllergyIntolerance", "criticality", element.getCriticalityElement(), -1);
        }
        if (element.hasSubstance()) {
            this.composeCodeableConcept(t, "AllergyIntolerance", "substance", element.getSubstance(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "AllergyIntolerance", "patient", element.getPatient(), -1);
        }
        if (element.hasRecordedDateElement()) {
            this.composeDateTime(t, "AllergyIntolerance", "recordedDate", element.getRecordedDateElement(), -1);
        }
        if (element.hasRecorder()) {
            this.composeReference(t, "AllergyIntolerance", "recorder", element.getRecorder(), -1);
        }
        if (element.hasReporter()) {
            this.composeReference(t, "AllergyIntolerance", "reporter", element.getReporter(), -1);
        }
        if (element.hasOnsetElement()) {
            this.composeDateTime(t, "AllergyIntolerance", "onset", element.getOnsetElement(), -1);
        }
        if (element.hasLastOccurenceElement()) {
            this.composeDateTime(t, "AllergyIntolerance", "lastOccurence", element.getLastOccurenceElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "AllergyIntolerance", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getReaction().size(); ++i) {
            this.composeAllergyIntoleranceAllergyIntoleranceReactionComponent(t, "AllergyIntolerance", "reaction", element.getReaction().get(i), i);
        }
    }

    protected void composeAllergyIntoleranceAllergyIntoleranceReactionComponent(RdfGenerator.Complex parent, String parentType, String name, AllergyIntolerance.AllergyIntoleranceReactionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "reaction", name, element, index);
        if (element.hasSubstance()) {
            this.composeCodeableConcept(t, "AllergyIntolerance", "substance", element.getSubstance(), -1);
        }
        if (element.hasCertaintyElement()) {
            this.composeEnum(t, "AllergyIntolerance", "certainty", element.getCertaintyElement(), -1);
        }
        for (i = 0; i < element.getManifestation().size(); ++i) {
            this.composeCodeableConcept(t, "AllergyIntolerance", "manifestation", element.getManifestation().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "AllergyIntolerance", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasOnsetElement()) {
            this.composeDateTime(t, "AllergyIntolerance", "onset", element.getOnsetElement(), -1);
        }
        if (element.hasSeverityElement()) {
            this.composeEnum(t, "AllergyIntolerance", "severity", element.getSeverityElement(), -1);
        }
        if (element.hasExposureRoute()) {
            this.composeCodeableConcept(t, "AllergyIntolerance", "exposureRoute", element.getExposureRoute(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "AllergyIntolerance", "note", element.getNote().get(i), i);
        }
    }

    protected void composeAppointment(RdfGenerator.Complex parent, String parentType, String name, Appointment element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Appointment", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Appointment", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Appointment", "status", element.getStatusElement(), -1);
        }
        if (element.hasServiceCategory()) {
            this.composeCodeableConcept(t, "Appointment", "serviceCategory", element.getServiceCategory(), -1);
        }
        for (i = 0; i < element.getServiceType().size(); ++i) {
            this.composeCodeableConcept(t, "Appointment", "serviceType", element.getServiceType().get(i), i);
        }
        for (i = 0; i < element.getSpecialty().size(); ++i) {
            this.composeCodeableConcept(t, "Appointment", "specialty", element.getSpecialty().get(i), i);
        }
        if (element.hasAppointmentType()) {
            this.composeCodeableConcept(t, "Appointment", "appointmentType", element.getAppointmentType(), -1);
        }
        if (element.hasReason()) {
            this.composeCodeableConcept(t, "Appointment", "reason", element.getReason(), -1);
        }
        if (element.hasPriorityElement()) {
            this.composeUnsignedInt(t, "Appointment", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Appointment", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasStartElement()) {
            this.composeInstant(t, "Appointment", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInstant(t, "Appointment", "end", element.getEndElement(), -1);
        }
        if (element.hasMinutesDurationElement()) {
            this.composePositiveInt(t, "Appointment", "minutesDuration", element.getMinutesDurationElement(), -1);
        }
        for (i = 0; i < element.getSlot().size(); ++i) {
            this.composeReference(t, "Appointment", "slot", element.getSlot().get(i), i);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "Appointment", "created", element.getCreatedElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "Appointment", "comment", element.getCommentElement(), -1);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composeAppointmentAppointmentParticipantComponent(t, "Appointment", "participant", element.getParticipant().get(i), i);
        }
    }

    protected void composeAppointmentAppointmentParticipantComponent(RdfGenerator.Complex parent, String parentType, String name, Appointment.AppointmentParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        for (int i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "Appointment", "type", element.getType().get(i), i);
        }
        if (element.hasActor()) {
            this.composeReference(t, "Appointment", "actor", element.getActor(), -1);
        }
        if (element.hasRequiredElement()) {
            this.composeEnum(t, "Appointment", "required", element.getRequiredElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Appointment", "status", element.getStatusElement(), -1);
        }
    }

    protected void composeAppointmentResponse(RdfGenerator.Complex parent, String parentType, String name, AppointmentResponse element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "AppointmentResponse", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "AppointmentResponse", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasAppointment()) {
            this.composeReference(t, "AppointmentResponse", "appointment", element.getAppointment(), -1);
        }
        if (element.hasStartElement()) {
            this.composeInstant(t, "AppointmentResponse", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInstant(t, "AppointmentResponse", "end", element.getEndElement(), -1);
        }
        for (i = 0; i < element.getParticipantType().size(); ++i) {
            this.composeCodeableConcept(t, "AppointmentResponse", "participantType", element.getParticipantType().get(i), i);
        }
        if (element.hasActor()) {
            this.composeReference(t, "AppointmentResponse", "actor", element.getActor(), -1);
        }
        if (element.hasParticipantStatusElement()) {
            this.composeCode(t, "AppointmentResponse", "participantStatus", element.getParticipantStatusElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "AppointmentResponse", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeAuditEvent(RdfGenerator.Complex parent, String parentType, String name, AuditEvent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "AuditEvent", name, element, index);
        if (element.hasType()) {
            this.composeCoding(t, "AuditEvent", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getSubtype().size(); ++i) {
            this.composeCoding(t, "AuditEvent", "subtype", element.getSubtype().get(i), i);
        }
        if (element.hasActionElement()) {
            this.composeEnum(t, "AuditEvent", "action", element.getActionElement(), -1);
        }
        if (element.hasRecordedElement()) {
            this.composeInstant(t, "AuditEvent", "recorded", element.getRecordedElement(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "AuditEvent", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasOutcomeDescElement()) {
            this.composeString(t, "AuditEvent", "outcomeDesc", element.getOutcomeDescElement(), -1);
        }
        for (i = 0; i < element.getPurposeOfEvent().size(); ++i) {
            this.composeCoding(t, "AuditEvent", "purposeOfEvent", element.getPurposeOfEvent().get(i), i);
        }
        for (i = 0; i < element.getAgent().size(); ++i) {
            this.composeAuditEventAuditEventAgentComponent(t, "AuditEvent", "agent", element.getAgent().get(i), i);
        }
        if (element.hasSource()) {
            this.composeAuditEventAuditEventSourceComponent(t, "AuditEvent", "source", element.getSource(), -1);
        }
        for (i = 0; i < element.getEntity().size(); ++i) {
            this.composeAuditEventAuditEventEntityComponent(t, "AuditEvent", "entity", element.getEntity().get(i), i);
        }
    }

    protected void composeAuditEventAuditEventAgentComponent(RdfGenerator.Complex parent, String parentType, String name, AuditEvent.AuditEventAgentComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "agent", name, element, index);
        for (i = 0; i < element.getRole().size(); ++i) {
            this.composeCodeableConcept(t, "AuditEvent", "role", element.getRole().get(i), i);
        }
        if (element.hasReference()) {
            this.composeReference(t, "AuditEvent", "reference", element.getReference(), -1);
        }
        if (element.hasUserId()) {
            this.composeIdentifier(t, "AuditEvent", "userId", element.getUserId(), -1);
        }
        if (element.hasAltIdElement()) {
            this.composeString(t, "AuditEvent", "altId", element.getAltIdElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "AuditEvent", "name", element.getNameElement(), -1);
        }
        if (element.hasRequestorElement()) {
            this.composeBoolean(t, "AuditEvent", "requestor", element.getRequestorElement(), -1);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "AuditEvent", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getPolicy().size(); ++i) {
            this.composeUri(t, "AuditEvent", "policy", element.getPolicy().get(i), i);
        }
        if (element.hasMedia()) {
            this.composeCoding(t, "AuditEvent", "media", element.getMedia(), -1);
        }
        if (element.hasNetwork()) {
            this.composeAuditEventAuditEventAgentNetworkComponent(t, "AuditEvent", "network", element.getNetwork(), -1);
        }
        for (i = 0; i < element.getPurposeOfUse().size(); ++i) {
            this.composeCoding(t, "AuditEvent", "purposeOfUse", element.getPurposeOfUse().get(i), i);
        }
    }

    protected void composeAuditEventAuditEventAgentNetworkComponent(RdfGenerator.Complex parent, String parentType, String name, AuditEvent.AuditEventAgentNetworkComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "network", name, element, index);
        if (element.hasAddressElement()) {
            this.composeString(t, "AuditEvent", "address", element.getAddressElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "AuditEvent", "type", element.getTypeElement(), -1);
        }
    }

    protected void composeAuditEventAuditEventSourceComponent(RdfGenerator.Complex parent, String parentType, String name, AuditEvent.AuditEventSourceComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "source", name, element, index);
        if (element.hasSiteElement()) {
            this.composeString(t, "AuditEvent", "site", element.getSiteElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "AuditEvent", "identifier", element.getIdentifier(), -1);
        }
        for (int i = 0; i < element.getType().size(); ++i) {
            this.composeCoding(t, "AuditEvent", "type", element.getType().get(i), i);
        }
    }

    protected void composeAuditEventAuditEventEntityComponent(RdfGenerator.Complex parent, String parentType, String name, AuditEvent.AuditEventEntityComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "entity", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "AuditEvent", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasReference()) {
            this.composeReference(t, "AuditEvent", "reference", element.getReference(), -1);
        }
        if (element.hasType()) {
            this.composeCoding(t, "AuditEvent", "type", element.getType(), -1);
        }
        if (element.hasRole()) {
            this.composeCoding(t, "AuditEvent", "role", element.getRole(), -1);
        }
        if (element.hasLifecycle()) {
            this.composeCoding(t, "AuditEvent", "lifecycle", element.getLifecycle(), -1);
        }
        for (i = 0; i < element.getSecurityLabel().size(); ++i) {
            this.composeCoding(t, "AuditEvent", "securityLabel", element.getSecurityLabel().get(i), i);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "AuditEvent", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "AuditEvent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasQueryElement()) {
            this.composeBase64Binary(t, "AuditEvent", "query", element.getQueryElement(), -1);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeAuditEventAuditEventEntityDetailComponent(t, "AuditEvent", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeAuditEventAuditEventEntityDetailComponent(RdfGenerator.Complex parent, String parentType, String name, AuditEvent.AuditEventEntityDetailComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasTypeElement()) {
            this.composeString(t, "AuditEvent", "type", element.getTypeElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeBase64Binary(t, "AuditEvent", "value", element.getValueElement(), -1);
        }
    }

    protected void composeBasic(RdfGenerator.Complex parent, String parentType, String name, Basic element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Basic", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Basic", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Basic", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Basic", "subject", element.getSubject(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDate(t, "Basic", "created", element.getCreatedElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "Basic", "author", element.getAuthor(), -1);
        }
    }

    protected void composeBinary(RdfGenerator.Complex parent, String parentType, String name, Binary element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeResource(t, "Binary", name, element, index);
        if (element.hasContentTypeElement()) {
            this.composeCode(t, "Binary", "contentType", element.getContentTypeElement(), -1);
        }
        if (element.hasContentElement()) {
            this.composeBase64Binary(t, "Binary", "content", element.getContentElement(), -1);
        }
    }

    protected void composeBodySite(RdfGenerator.Complex parent, String parentType, String name, BodySite element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "BodySite", name, element, index);
        if (element.hasPatient()) {
            this.composeReference(t, "BodySite", "patient", element.getPatient(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "BodySite", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "BodySite", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCodeableConcept(t, "BodySite", "modifier", element.getModifier().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "BodySite", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getImage().size(); ++i) {
            this.composeAttachment(t, "BodySite", "image", element.getImage().get(i), i);
        }
    }

    protected void composeBundle(RdfGenerator.Complex parent, String parentType, String name, Bundle element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeResource(t, "Bundle", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Bundle", "type", element.getTypeElement(), -1);
        }
        if (element.hasTotalElement()) {
            this.composeUnsignedInt(t, "Bundle", "total", element.getTotalElement(), -1);
        }
        for (i = 0; i < element.getLink().size(); ++i) {
            this.composeBundleBundleLinkComponent(t, "Bundle", "link", element.getLink().get(i), i);
        }
        for (i = 0; i < element.getEntry().size(); ++i) {
            this.composeBundleBundleEntryComponent(t, "Bundle", "entry", element.getEntry().get(i), i);
        }
        if (element.hasSignature()) {
            this.composeSignature(t, "Bundle", "signature", element.getSignature(), -1);
        }
    }

    protected void composeBundleBundleLinkComponent(RdfGenerator.Complex parent, String parentType, String name, Bundle.BundleLinkComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "link", name, element, index);
        if (element.hasRelationElement()) {
            this.composeString(t, "Bundle", "relation", element.getRelationElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "Bundle", "url", element.getUrlElement(), -1);
        }
    }

    protected void composeBundleBundleEntryComponent(RdfGenerator.Complex parent, String parentType, String name, Bundle.BundleEntryComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "entry", name, element, index);
        for (int i = 0; i < element.getLink().size(); ++i) {
            this.composeBundleBundleLinkComponent(t, "Bundle", "link", element.getLink().get(i), i);
        }
        if (element.hasFullUrlElement()) {
            this.composeUri(t, "Bundle", "fullUrl", element.getFullUrlElement(), -1);
        }
        if (element.hasResource()) {
            this.composeResource(t, "Bundle", "resource", element.getResource(), -1);
        }
        if (element.hasSearch()) {
            this.composeBundleBundleEntrySearchComponent(t, "Bundle", "search", element.getSearch(), -1);
        }
        if (element.hasRequest()) {
            this.composeBundleBundleEntryRequestComponent(t, "Bundle", "request", element.getRequest(), -1);
        }
        if (element.hasResponse()) {
            this.composeBundleBundleEntryResponseComponent(t, "Bundle", "response", element.getResponse(), -1);
        }
    }

    protected void composeBundleBundleEntrySearchComponent(RdfGenerator.Complex parent, String parentType, String name, Bundle.BundleEntrySearchComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "search", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "Bundle", "mode", element.getModeElement(), -1);
        }
        if (element.hasScoreElement()) {
            this.composeDecimal(t, "Bundle", "score", element.getScoreElement(), -1);
        }
    }

    protected void composeBundleBundleEntryRequestComponent(RdfGenerator.Complex parent, String parentType, String name, Bundle.BundleEntryRequestComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "request", name, element, index);
        if (element.hasMethodElement()) {
            this.composeEnum(t, "Bundle", "method", element.getMethodElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "Bundle", "url", element.getUrlElement(), -1);
        }
        if (element.hasIfNoneMatchElement()) {
            this.composeString(t, "Bundle", "ifNoneMatch", element.getIfNoneMatchElement(), -1);
        }
        if (element.hasIfModifiedSinceElement()) {
            this.composeInstant(t, "Bundle", "ifModifiedSince", element.getIfModifiedSinceElement(), -1);
        }
        if (element.hasIfMatchElement()) {
            this.composeString(t, "Bundle", "ifMatch", element.getIfMatchElement(), -1);
        }
        if (element.hasIfNoneExistElement()) {
            this.composeString(t, "Bundle", "ifNoneExist", element.getIfNoneExistElement(), -1);
        }
    }

    protected void composeBundleBundleEntryResponseComponent(RdfGenerator.Complex parent, String parentType, String name, Bundle.BundleEntryResponseComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "response", name, element, index);
        if (element.hasStatusElement()) {
            this.composeString(t, "Bundle", "status", element.getStatusElement(), -1);
        }
        if (element.hasLocationElement()) {
            this.composeUri(t, "Bundle", "location", element.getLocationElement(), -1);
        }
        if (element.hasEtagElement()) {
            this.composeString(t, "Bundle", "etag", element.getEtagElement(), -1);
        }
        if (element.hasLastModifiedElement()) {
            this.composeInstant(t, "Bundle", "lastModified", element.getLastModifiedElement(), -1);
        }
    }

    protected void composeCarePlan(RdfGenerator.Complex parent, String parentType, String name, CarePlan element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CarePlan", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CarePlan", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "CarePlan", "subject", element.getSubject(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CarePlan", "status", element.getStatusElement(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "CarePlan", "context", element.getContext(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "CarePlan", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeReference(t, "CarePlan", "author", element.getAuthor().get(i), i);
        }
        if (element.hasModifiedElement()) {
            this.composeDateTime(t, "CarePlan", "modified", element.getModifiedElement(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "CarePlan", "category", element.getCategory().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CarePlan", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getAddresses().size(); ++i) {
            this.composeReference(t, "CarePlan", "addresses", element.getAddresses().get(i), i);
        }
        for (i = 0; i < element.getSupport().size(); ++i) {
            this.composeReference(t, "CarePlan", "support", element.getSupport().get(i), i);
        }
        for (i = 0; i < element.getRelatedPlan().size(); ++i) {
            this.composeCarePlanCarePlanRelatedPlanComponent(t, "CarePlan", "relatedPlan", element.getRelatedPlan().get(i), i);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composeCarePlanCarePlanParticipantComponent(t, "CarePlan", "participant", element.getParticipant().get(i), i);
        }
        for (i = 0; i < element.getGoal().size(); ++i) {
            this.composeReference(t, "CarePlan", "goal", element.getGoal().get(i), i);
        }
        for (i = 0; i < element.getActivity().size(); ++i) {
            this.composeCarePlanCarePlanActivityComponent(t, "CarePlan", "activity", element.getActivity().get(i), i);
        }
        if (element.hasNote()) {
            this.composeAnnotation(t, "CarePlan", "note", element.getNote(), -1);
        }
    }

    protected void composeCarePlanCarePlanRelatedPlanComponent(RdfGenerator.Complex parent, String parentType, String name, CarePlan.CarePlanRelatedPlanComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "relatedPlan", name, element, index);
        if (element.hasCodeElement()) {
            this.composeEnum(t, "CarePlan", "code", element.getCodeElement(), -1);
        }
        if (element.hasPlan()) {
            this.composeReference(t, "CarePlan", "plan", element.getPlan(), -1);
        }
    }

    protected void composeCarePlanCarePlanParticipantComponent(RdfGenerator.Complex parent, String parentType, String name, CarePlan.CarePlanParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "CarePlan", "role", element.getRole(), -1);
        }
        if (element.hasMember()) {
            this.composeReference(t, "CarePlan", "member", element.getMember(), -1);
        }
    }

    protected void composeCarePlanCarePlanActivityComponent(RdfGenerator.Complex parent, String parentType, String name, CarePlan.CarePlanActivityComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "activity", name, element, index);
        for (i = 0; i < element.getActionResulting().size(); ++i) {
            this.composeReference(t, "CarePlan", "actionResulting", element.getActionResulting().get(i), i);
        }
        for (i = 0; i < element.getProgress().size(); ++i) {
            this.composeAnnotation(t, "CarePlan", "progress", element.getProgress().get(i), i);
        }
        if (element.hasReference()) {
            this.composeReference(t, "CarePlan", "reference", element.getReference(), -1);
        }
        if (element.hasDetail()) {
            this.composeCarePlanCarePlanActivityDetailComponent(t, "CarePlan", "detail", element.getDetail(), -1);
        }
    }

    protected void composeCarePlanCarePlanActivityDetailComponent(RdfGenerator.Complex parent, String parentType, String name, CarePlan.CarePlanActivityDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "CarePlan", "category", element.getCategory(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "CarePlan", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "CarePlan", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "CarePlan", "reasonReference", element.getReasonReference().get(i), i);
        }
        for (i = 0; i < element.getGoal().size(); ++i) {
            this.composeReference(t, "CarePlan", "goal", element.getGoal().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CarePlan", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "CarePlan", "statusReason", element.getStatusReason(), -1);
        }
        if (element.hasProhibitedElement()) {
            this.composeBoolean(t, "CarePlan", "prohibited", element.getProhibitedElement(), -1);
        }
        if (element.hasScheduled()) {
            this.composeType(t, "CarePlan", "scheduled", element.getScheduled(), -1);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "CarePlan", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeReference(t, "CarePlan", "performer", element.getPerformer().get(i), i);
        }
        if (element.hasProduct()) {
            this.composeType(t, "CarePlan", "product", element.getProduct(), -1);
        }
        if (element.hasDailyAmount()) {
            this.composeQuantity(t, "CarePlan", "dailyAmount", element.getDailyAmount(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "CarePlan", "quantity", element.getQuantity(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CarePlan", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeCareTeam(RdfGenerator.Complex parent, String parentType, String name, CareTeam element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CareTeam", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CareTeam", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "CareTeam", "status", element.getStatus(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "CareTeam", "type", element.getType().get(i), i);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "CareTeam", "name", element.getNameElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "CareTeam", "subject", element.getSubject(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "CareTeam", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composeCareTeamCareTeamParticipantComponent(t, "CareTeam", "participant", element.getParticipant().get(i), i);
        }
        if (element.hasManagingOrganization()) {
            this.composeReference(t, "CareTeam", "managingOrganization", element.getManagingOrganization(), -1);
        }
    }

    protected void composeCareTeamCareTeamParticipantComponent(RdfGenerator.Complex parent, String parentType, String name, CareTeam.CareTeamParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "CareTeam", "role", element.getRole(), -1);
        }
        if (element.hasMember()) {
            this.composeReference(t, "CareTeam", "member", element.getMember(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "CareTeam", "period", element.getPeriod(), -1);
        }
    }

    protected void composeClaim(RdfGenerator.Complex parent, String parentType, String name, Claim element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Claim", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Claim", "type", element.getTypeElement(), -1);
        }
        for (i = 0; i < element.getSubType().size(); ++i) {
            this.composeCoding(t, "Claim", "subType", element.getSubType().get(i), i);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Claim", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasRuleset()) {
            this.composeCoding(t, "Claim", "ruleset", element.getRuleset(), -1);
        }
        if (element.hasOriginalRuleset()) {
            this.composeCoding(t, "Claim", "originalRuleset", element.getOriginalRuleset(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "Claim", "created", element.getCreatedElement(), -1);
        }
        if (element.hasBillablePeriod()) {
            this.composePeriod(t, "Claim", "billablePeriod", element.getBillablePeriod(), -1);
        }
        if (element.hasTarget()) {
            this.composeType(t, "Claim", "target", element.getTarget(), -1);
        }
        if (element.hasProvider()) {
            this.composeType(t, "Claim", "provider", element.getProvider(), -1);
        }
        if (element.hasOrganization()) {
            this.composeType(t, "Claim", "organization", element.getOrganization(), -1);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "Claim", "use", element.getUseElement(), -1);
        }
        if (element.hasPriority()) {
            this.composeCoding(t, "Claim", "priority", element.getPriority(), -1);
        }
        if (element.hasFundsReserve()) {
            this.composeCoding(t, "Claim", "fundsReserve", element.getFundsReserve(), -1);
        }
        if (element.hasEnterer()) {
            this.composeType(t, "Claim", "enterer", element.getEnterer(), -1);
        }
        if (element.hasFacility()) {
            this.composeType(t, "Claim", "facility", element.getFacility(), -1);
        }
        for (i = 0; i < element.getRelated().size(); ++i) {
            this.composeClaimRelatedClaimsComponent(t, "Claim", "related", element.getRelated().get(i), i);
        }
        if (element.hasPrescription()) {
            this.composeType(t, "Claim", "prescription", element.getPrescription(), -1);
        }
        if (element.hasOriginalPrescription()) {
            this.composeType(t, "Claim", "originalPrescription", element.getOriginalPrescription(), -1);
        }
        if (element.hasPayee()) {
            this.composeClaimPayeeComponent(t, "Claim", "payee", element.getPayee(), -1);
        }
        if (element.hasReferral()) {
            this.composeType(t, "Claim", "referral", element.getReferral(), -1);
        }
        for (i = 0; i < element.getOccurrenceCode().size(); ++i) {
            this.composeCoding(t, "Claim", "occurrenceCode", element.getOccurrenceCode().get(i), i);
        }
        for (i = 0; i < element.getOccurenceSpanCode().size(); ++i) {
            this.composeCoding(t, "Claim", "occurenceSpanCode", element.getOccurenceSpanCode().get(i), i);
        }
        for (i = 0; i < element.getValueCode().size(); ++i) {
            this.composeCoding(t, "Claim", "valueCode", element.getValueCode().get(i), i);
        }
        for (i = 0; i < element.getDiagnosis().size(); ++i) {
            this.composeClaimDiagnosisComponent(t, "Claim", "diagnosis", element.getDiagnosis().get(i), i);
        }
        for (i = 0; i < element.getProcedure().size(); ++i) {
            this.composeClaimProcedureComponent(t, "Claim", "procedure", element.getProcedure().get(i), i);
        }
        for (i = 0; i < element.getSpecialCondition().size(); ++i) {
            this.composeCoding(t, "Claim", "specialCondition", element.getSpecialCondition().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeType(t, "Claim", "patient", element.getPatient(), -1);
        }
        for (i = 0; i < element.getCoverage().size(); ++i) {
            this.composeClaimCoverageComponent(t, "Claim", "coverage", element.getCoverage().get(i), i);
        }
        if (element.hasAccidentDateElement()) {
            this.composeDate(t, "Claim", "accidentDate", element.getAccidentDateElement(), -1);
        }
        if (element.hasAccidentType()) {
            this.composeCoding(t, "Claim", "accidentType", element.getAccidentType(), -1);
        }
        if (element.hasAccidentLocation()) {
            this.composeType(t, "Claim", "accidentLocation", element.getAccidentLocation(), -1);
        }
        for (i = 0; i < element.getInterventionException().size(); ++i) {
            this.composeCoding(t, "Claim", "interventionException", element.getInterventionException().get(i), i);
        }
        for (i = 0; i < element.getOnset().size(); ++i) {
            this.composeClaimOnsetComponent(t, "Claim", "onset", element.getOnset().get(i), i);
        }
        if (element.hasEmploymentImpacted()) {
            this.composePeriod(t, "Claim", "employmentImpacted", element.getEmploymentImpacted(), -1);
        }
        if (element.hasHospitalization()) {
            this.composePeriod(t, "Claim", "hospitalization", element.getHospitalization(), -1);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeClaimItemsComponent(t, "Claim", "item", element.getItem().get(i), i);
        }
        if (element.hasTotal()) {
            this.composeQuantity(t, "Claim", "total", element.getTotal(), -1);
        }
        for (i = 0; i < element.getAdditionalMaterial().size(); ++i) {
            this.composeCoding(t, "Claim", "additionalMaterial", element.getAdditionalMaterial().get(i), i);
        }
        for (i = 0; i < element.getMissingTeeth().size(); ++i) {
            this.composeClaimMissingTeethComponent(t, "Claim", "missingTeeth", element.getMissingTeeth().get(i), i);
        }
    }

    protected void composeClaimRelatedClaimsComponent(RdfGenerator.Complex parent, String parentType, String name, Claim.RelatedClaimsComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "related", name, element, index);
        if (element.hasClaim()) {
            this.composeType(t, "Claim", "claim", element.getClaim(), -1);
        }
        if (element.hasRelationship()) {
            this.composeCoding(t, "Claim", "relationship", element.getRelationship(), -1);
        }
        if (element.hasReference()) {
            this.composeIdentifier(t, "Claim", "reference", element.getReference(), -1);
        }
    }

    protected void composeClaimPayeeComponent(RdfGenerator.Complex parent, String parentType, String name, Claim.PayeeComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "payee", name, element, index);
        if (element.hasType()) {
            this.composeCoding(t, "Claim", "type", element.getType(), -1);
        }
        if (element.hasParty()) {
            this.composeType(t, "Claim", "party", element.getParty(), -1);
        }
    }

    protected void composeClaimDiagnosisComponent(RdfGenerator.Complex parent, String parentType, String name, Claim.DiagnosisComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "diagnosis", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "Claim", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasDiagnosis()) {
            this.composeCoding(t, "Claim", "diagnosis", element.getDiagnosis(), -1);
        }
    }

    protected void composeClaimProcedureComponent(RdfGenerator.Complex parent, String parentType, String name, Claim.ProcedureComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "procedure", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "Claim", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Claim", "date", element.getDateElement(), -1);
        }
        if (element.hasProcedure()) {
            this.composeType(t, "Claim", "procedure", element.getProcedure(), -1);
        }
    }

    protected void composeClaimCoverageComponent(RdfGenerator.Complex parent, String parentType, String name, Claim.CoverageComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "coverage", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "Claim", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasFocalElement()) {
            this.composeBoolean(t, "Claim", "focal", element.getFocalElement(), -1);
        }
        if (element.hasCoverage()) {
            this.composeType(t, "Claim", "coverage", element.getCoverage(), -1);
        }
        if (element.hasBusinessArrangementElement()) {
            this.composeString(t, "Claim", "businessArrangement", element.getBusinessArrangementElement(), -1);
        }
        for (int i = 0; i < element.getPreAuthRef().size(); ++i) {
            this.composeString(t, "Claim", "preAuthRef", element.getPreAuthRef().get(i), i);
        }
        if (element.hasClaimResponse()) {
            this.composeReference(t, "Claim", "claimResponse", element.getClaimResponse(), -1);
        }
        if (element.hasOriginalRuleset()) {
            this.composeCoding(t, "Claim", "originalRuleset", element.getOriginalRuleset(), -1);
        }
    }

    protected void composeClaimOnsetComponent(RdfGenerator.Complex parent, String parentType, String name, Claim.OnsetComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "onset", name, element, index);
        if (element.hasTime()) {
            this.composeType(t, "Claim", "time", element.getTime(), -1);
        }
        if (element.hasType()) {
            this.composeCoding(t, "Claim", "type", element.getType(), -1);
        }
    }

    protected void composeClaimItemsComponent(RdfGenerator.Complex parent, String parentType, String name, Claim.ItemsComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "Claim", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasType()) {
            this.composeCoding(t, "Claim", "type", element.getType(), -1);
        }
        if (element.hasProvider()) {
            this.composeType(t, "Claim", "provider", element.getProvider(), -1);
        }
        if (element.hasSupervisor()) {
            this.composeType(t, "Claim", "supervisor", element.getSupervisor(), -1);
        }
        if (element.hasProviderQualification()) {
            this.composeCoding(t, "Claim", "providerQualification", element.getProviderQualification(), -1);
        }
        for (i = 0; i < element.getDiagnosisLinkId().size(); ++i) {
            this.composePositiveInt(t, "Claim", "diagnosisLinkId", element.getDiagnosisLinkId().get(i), i);
        }
        if (element.hasService()) {
            this.composeCoding(t, "Claim", "service", element.getService(), -1);
        }
        for (i = 0; i < element.getServiceModifier().size(); ++i) {
            this.composeCoding(t, "Claim", "serviceModifier", element.getServiceModifier().get(i), i);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCoding(t, "Claim", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCoding(t, "Claim", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasServiced()) {
            this.composeType(t, "Claim", "serviced", element.getServiced(), -1);
        }
        if (element.hasPlace()) {
            this.composeCoding(t, "Claim", "place", element.getPlace(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "Claim", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeQuantity(t, "Claim", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "Claim", "factor", element.getFactorElement(), -1);
        }
        if (element.hasPointsElement()) {
            this.composeDecimal(t, "Claim", "points", element.getPointsElement(), -1);
        }
        if (element.hasNet()) {
            this.composeQuantity(t, "Claim", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "Claim", "udi", element.getUdi().get(i), i);
        }
        if (element.hasBodySite()) {
            this.composeCoding(t, "Claim", "bodySite", element.getBodySite(), -1);
        }
        for (i = 0; i < element.getSubSite().size(); ++i) {
            this.composeCoding(t, "Claim", "subSite", element.getSubSite().get(i), i);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeClaimDetailComponent(t, "Claim", "detail", element.getDetail().get(i), i);
        }
        if (element.hasProsthesis()) {
            this.composeClaimProsthesisComponent(t, "Claim", "prosthesis", element.getProsthesis(), -1);
        }
    }

    protected void composeClaimDetailComponent(RdfGenerator.Complex parent, String parentType, String name, Claim.DetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "Claim", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasType()) {
            this.composeCoding(t, "Claim", "type", element.getType(), -1);
        }
        if (element.hasService()) {
            this.composeCoding(t, "Claim", "service", element.getService(), -1);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCoding(t, "Claim", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "Claim", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeQuantity(t, "Claim", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "Claim", "factor", element.getFactorElement(), -1);
        }
        if (element.hasPointsElement()) {
            this.composeDecimal(t, "Claim", "points", element.getPointsElement(), -1);
        }
        if (element.hasNet()) {
            this.composeQuantity(t, "Claim", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "Claim", "udi", element.getUdi().get(i), i);
        }
        for (i = 0; i < element.getSubDetail().size(); ++i) {
            this.composeClaimSubDetailComponent(t, "Claim", "subDetail", element.getSubDetail().get(i), i);
        }
    }

    protected void composeClaimSubDetailComponent(RdfGenerator.Complex parent, String parentType, String name, Claim.SubDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "subDetail", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "Claim", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasType()) {
            this.composeCoding(t, "Claim", "type", element.getType(), -1);
        }
        if (element.hasService()) {
            this.composeCoding(t, "Claim", "service", element.getService(), -1);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCoding(t, "Claim", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "Claim", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeQuantity(t, "Claim", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "Claim", "factor", element.getFactorElement(), -1);
        }
        if (element.hasPointsElement()) {
            this.composeDecimal(t, "Claim", "points", element.getPointsElement(), -1);
        }
        if (element.hasNet()) {
            this.composeQuantity(t, "Claim", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "Claim", "udi", element.getUdi().get(i), i);
        }
    }

    protected void composeClaimProsthesisComponent(RdfGenerator.Complex parent, String parentType, String name, Claim.ProsthesisComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "prosthesis", name, element, index);
        if (element.hasInitialElement()) {
            this.composeBoolean(t, "Claim", "initial", element.getInitialElement(), -1);
        }
        if (element.hasPriorDateElement()) {
            this.composeDate(t, "Claim", "priorDate", element.getPriorDateElement(), -1);
        }
        if (element.hasPriorMaterial()) {
            this.composeCoding(t, "Claim", "priorMaterial", element.getPriorMaterial(), -1);
        }
    }

    protected void composeClaimMissingTeethComponent(RdfGenerator.Complex parent, String parentType, String name, Claim.MissingTeethComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "missingTeeth", name, element, index);
        if (element.hasTooth()) {
            this.composeCoding(t, "Claim", "tooth", element.getTooth(), -1);
        }
        if (element.hasReason()) {
            this.composeCoding(t, "Claim", "reason", element.getReason(), -1);
        }
        if (element.hasExtractionDateElement()) {
            this.composeDate(t, "Claim", "extractionDate", element.getExtractionDateElement(), -1);
        }
    }

    protected void composeClaimResponse(RdfGenerator.Complex parent, String parentType, String name, ClaimResponse element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ClaimResponse", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ClaimResponse", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasRequest()) {
            this.composeType(t, "ClaimResponse", "request", element.getRequest(), -1);
        }
        if (element.hasRuleset()) {
            this.composeCoding(t, "ClaimResponse", "ruleset", element.getRuleset(), -1);
        }
        if (element.hasOriginalRuleset()) {
            this.composeCoding(t, "ClaimResponse", "originalRuleset", element.getOriginalRuleset(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "ClaimResponse", "created", element.getCreatedElement(), -1);
        }
        if (element.hasOrganization()) {
            this.composeType(t, "ClaimResponse", "organization", element.getOrganization(), -1);
        }
        if (element.hasRequestProvider()) {
            this.composeType(t, "ClaimResponse", "requestProvider", element.getRequestProvider(), -1);
        }
        if (element.hasRequestOrganization()) {
            this.composeType(t, "ClaimResponse", "requestOrganization", element.getRequestOrganization(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "ClaimResponse", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "ClaimResponse", "disposition", element.getDispositionElement(), -1);
        }
        if (element.hasPayeeType()) {
            this.composeCoding(t, "ClaimResponse", "payeeType", element.getPayeeType(), -1);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeClaimResponseItemsComponent(t, "ClaimResponse", "item", element.getItem().get(i), i);
        }
        for (i = 0; i < element.getAddItem().size(); ++i) {
            this.composeClaimResponseAddedItemComponent(t, "ClaimResponse", "addItem", element.getAddItem().get(i), i);
        }
        for (i = 0; i < element.getError().size(); ++i) {
            this.composeClaimResponseErrorsComponent(t, "ClaimResponse", "error", element.getError().get(i), i);
        }
        if (element.hasTotalCost()) {
            this.composeQuantity(t, "ClaimResponse", "totalCost", element.getTotalCost(), -1);
        }
        if (element.hasUnallocDeductable()) {
            this.composeQuantity(t, "ClaimResponse", "unallocDeductable", element.getUnallocDeductable(), -1);
        }
        if (element.hasTotalBenefit()) {
            this.composeQuantity(t, "ClaimResponse", "totalBenefit", element.getTotalBenefit(), -1);
        }
        if (element.hasPaymentAdjustment()) {
            this.composeQuantity(t, "ClaimResponse", "paymentAdjustment", element.getPaymentAdjustment(), -1);
        }
        if (element.hasPaymentAdjustmentReason()) {
            this.composeCoding(t, "ClaimResponse", "paymentAdjustmentReason", element.getPaymentAdjustmentReason(), -1);
        }
        if (element.hasPaymentDateElement()) {
            this.composeDate(t, "ClaimResponse", "paymentDate", element.getPaymentDateElement(), -1);
        }
        if (element.hasPaymentAmount()) {
            this.composeQuantity(t, "ClaimResponse", "paymentAmount", element.getPaymentAmount(), -1);
        }
        if (element.hasPaymentRef()) {
            this.composeIdentifier(t, "ClaimResponse", "paymentRef", element.getPaymentRef(), -1);
        }
        if (element.hasReserved()) {
            this.composeCoding(t, "ClaimResponse", "reserved", element.getReserved(), -1);
        }
        if (element.hasForm()) {
            this.composeCoding(t, "ClaimResponse", "form", element.getForm(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeClaimResponseNotesComponent(t, "ClaimResponse", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getCoverage().size(); ++i) {
            this.composeClaimResponseCoverageComponent(t, "ClaimResponse", "coverage", element.getCoverage().get(i), i);
        }
    }

    protected void composeClaimResponseItemsComponent(RdfGenerator.Complex parent, String parentType, String name, ClaimResponse.ItemsComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasSequenceLinkIdElement()) {
            this.composePositiveInt(t, "ClaimResponse", "sequenceLinkId", element.getSequenceLinkIdElement(), -1);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "ClaimResponse", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeClaimResponseItemAdjudicationComponent(t, "ClaimResponse", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeClaimResponseItemDetailComponent(t, "ClaimResponse", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeClaimResponseItemAdjudicationComponent(RdfGenerator.Complex parent, String parentType, String name, ClaimResponse.ItemAdjudicationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "adjudication", name, element, index);
        if (element.hasCategory()) {
            this.composeCoding(t, "ClaimResponse", "category", element.getCategory(), -1);
        }
        if (element.hasReason()) {
            this.composeCoding(t, "ClaimResponse", "reason", element.getReason(), -1);
        }
        if (element.hasAmount()) {
            this.composeQuantity(t, "ClaimResponse", "amount", element.getAmount(), -1);
        }
        if (element.hasValueElement()) {
            this.composeDecimal(t, "ClaimResponse", "value", element.getValueElement(), -1);
        }
    }

    protected void composeClaimResponseItemDetailComponent(RdfGenerator.Complex parent, String parentType, String name, ClaimResponse.ItemDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasSequenceLinkIdElement()) {
            this.composePositiveInt(t, "ClaimResponse", "sequenceLinkId", element.getSequenceLinkIdElement(), -1);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeClaimResponseDetailAdjudicationComponent(t, "ClaimResponse", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getSubDetail().size(); ++i) {
            this.composeClaimResponseSubDetailComponent(t, "ClaimResponse", "subDetail", element.getSubDetail().get(i), i);
        }
    }

    protected void composeClaimResponseDetailAdjudicationComponent(RdfGenerator.Complex parent, String parentType, String name, ClaimResponse.DetailAdjudicationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "adjudication", name, element, index);
        if (element.hasCategory()) {
            this.composeCoding(t, "ClaimResponse", "category", element.getCategory(), -1);
        }
        if (element.hasReason()) {
            this.composeCoding(t, "ClaimResponse", "reason", element.getReason(), -1);
        }
        if (element.hasAmount()) {
            this.composeQuantity(t, "ClaimResponse", "amount", element.getAmount(), -1);
        }
        if (element.hasValueElement()) {
            this.composeDecimal(t, "ClaimResponse", "value", element.getValueElement(), -1);
        }
    }

    protected void composeClaimResponseSubDetailComponent(RdfGenerator.Complex parent, String parentType, String name, ClaimResponse.SubDetailComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "subDetail", name, element, index);
        if (element.hasSequenceLinkIdElement()) {
            this.composePositiveInt(t, "ClaimResponse", "sequenceLinkId", element.getSequenceLinkIdElement(), -1);
        }
        for (int i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeClaimResponseSubdetailAdjudicationComponent(t, "ClaimResponse", "adjudication", element.getAdjudication().get(i), i);
        }
    }

    protected void composeClaimResponseSubdetailAdjudicationComponent(RdfGenerator.Complex parent, String parentType, String name, ClaimResponse.SubdetailAdjudicationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "adjudication", name, element, index);
        if (element.hasCategory()) {
            this.composeCoding(t, "ClaimResponse", "category", element.getCategory(), -1);
        }
        if (element.hasReason()) {
            this.composeCoding(t, "ClaimResponse", "reason", element.getReason(), -1);
        }
        if (element.hasAmount()) {
            this.composeQuantity(t, "ClaimResponse", "amount", element.getAmount(), -1);
        }
        if (element.hasValueElement()) {
            this.composeDecimal(t, "ClaimResponse", "value", element.getValueElement(), -1);
        }
    }

    protected void composeClaimResponseAddedItemComponent(RdfGenerator.Complex parent, String parentType, String name, ClaimResponse.AddedItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "addItem", name, element, index);
        for (i = 0; i < element.getSequenceLinkId().size(); ++i) {
            this.composePositiveInt(t, "ClaimResponse", "sequenceLinkId", element.getSequenceLinkId().get(i), i);
        }
        if (element.hasService()) {
            this.composeCoding(t, "ClaimResponse", "service", element.getService(), -1);
        }
        if (element.hasFee()) {
            this.composeQuantity(t, "ClaimResponse", "fee", element.getFee(), -1);
        }
        for (i = 0; i < element.getNoteNumberLinkId().size(); ++i) {
            this.composePositiveInt(t, "ClaimResponse", "noteNumberLinkId", element.getNoteNumberLinkId().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeClaimResponseAddedItemAdjudicationComponent(t, "ClaimResponse", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeClaimResponseAddedItemsDetailComponent(t, "ClaimResponse", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeClaimResponseAddedItemAdjudicationComponent(RdfGenerator.Complex parent, String parentType, String name, ClaimResponse.AddedItemAdjudicationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "adjudication", name, element, index);
        if (element.hasCategory()) {
            this.composeCoding(t, "ClaimResponse", "category", element.getCategory(), -1);
        }
        if (element.hasReason()) {
            this.composeCoding(t, "ClaimResponse", "reason", element.getReason(), -1);
        }
        if (element.hasAmount()) {
            this.composeQuantity(t, "ClaimResponse", "amount", element.getAmount(), -1);
        }
        if (element.hasValueElement()) {
            this.composeDecimal(t, "ClaimResponse", "value", element.getValueElement(), -1);
        }
    }

    protected void composeClaimResponseAddedItemsDetailComponent(RdfGenerator.Complex parent, String parentType, String name, ClaimResponse.AddedItemsDetailComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasService()) {
            this.composeCoding(t, "ClaimResponse", "service", element.getService(), -1);
        }
        if (element.hasFee()) {
            this.composeQuantity(t, "ClaimResponse", "fee", element.getFee(), -1);
        }
        for (int i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeClaimResponseAddedItemDetailAdjudicationComponent(t, "ClaimResponse", "adjudication", element.getAdjudication().get(i), i);
        }
    }

    protected void composeClaimResponseAddedItemDetailAdjudicationComponent(RdfGenerator.Complex parent, String parentType, String name, ClaimResponse.AddedItemDetailAdjudicationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "adjudication", name, element, index);
        if (element.hasCategory()) {
            this.composeCoding(t, "ClaimResponse", "category", element.getCategory(), -1);
        }
        if (element.hasReason()) {
            this.composeCoding(t, "ClaimResponse", "reason", element.getReason(), -1);
        }
        if (element.hasAmount()) {
            this.composeQuantity(t, "ClaimResponse", "amount", element.getAmount(), -1);
        }
        if (element.hasValueElement()) {
            this.composeDecimal(t, "ClaimResponse", "value", element.getValueElement(), -1);
        }
    }

    protected void composeClaimResponseErrorsComponent(RdfGenerator.Complex parent, String parentType, String name, ClaimResponse.ErrorsComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "error", name, element, index);
        if (element.hasSequenceLinkIdElement()) {
            this.composePositiveInt(t, "ClaimResponse", "sequenceLinkId", element.getSequenceLinkIdElement(), -1);
        }
        if (element.hasDetailSequenceLinkIdElement()) {
            this.composePositiveInt(t, "ClaimResponse", "detailSequenceLinkId", element.getDetailSequenceLinkIdElement(), -1);
        }
        if (element.hasSubdetailSequenceLinkIdElement()) {
            this.composePositiveInt(t, "ClaimResponse", "subdetailSequenceLinkId", element.getSubdetailSequenceLinkIdElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCoding(t, "ClaimResponse", "code", element.getCode(), -1);
        }
    }

    protected void composeClaimResponseNotesComponent(RdfGenerator.Complex parent, String parentType, String name, ClaimResponse.NotesComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "note", name, element, index);
        if (element.hasNumberElement()) {
            this.composePositiveInt(t, "ClaimResponse", "number", element.getNumberElement(), -1);
        }
        if (element.hasType()) {
            this.composeCoding(t, "ClaimResponse", "type", element.getType(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "ClaimResponse", "text", element.getTextElement(), -1);
        }
    }

    protected void composeClaimResponseCoverageComponent(RdfGenerator.Complex parent, String parentType, String name, ClaimResponse.CoverageComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "coverage", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ClaimResponse", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasFocalElement()) {
            this.composeBoolean(t, "ClaimResponse", "focal", element.getFocalElement(), -1);
        }
        if (element.hasCoverage()) {
            this.composeType(t, "ClaimResponse", "coverage", element.getCoverage(), -1);
        }
        if (element.hasBusinessArrangementElement()) {
            this.composeString(t, "ClaimResponse", "businessArrangement", element.getBusinessArrangementElement(), -1);
        }
        for (int i = 0; i < element.getPreAuthRef().size(); ++i) {
            this.composeString(t, "ClaimResponse", "preAuthRef", element.getPreAuthRef().get(i), i);
        }
        if (element.hasClaimResponse()) {
            this.composeReference(t, "ClaimResponse", "claimResponse", element.getClaimResponse(), -1);
        }
    }

    protected void composeClinicalImpression(RdfGenerator.Complex parent, String parentType, String name, ClinicalImpression element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ClinicalImpression", name, element, index);
        if (element.hasPatient()) {
            this.composeReference(t, "ClinicalImpression", "patient", element.getPatient(), -1);
        }
        if (element.hasAssessor()) {
            this.composeReference(t, "ClinicalImpression", "assessor", element.getAssessor(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ClinicalImpression", "status", element.getStatusElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ClinicalImpression", "date", element.getDateElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ClinicalImpression", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasPrevious()) {
            this.composeReference(t, "ClinicalImpression", "previous", element.getPrevious(), -1);
        }
        for (i = 0; i < element.getProblem().size(); ++i) {
            this.composeReference(t, "ClinicalImpression", "problem", element.getProblem().get(i), i);
        }
        if (element.hasTrigger()) {
            this.composeType(t, "ClinicalImpression", "trigger", element.getTrigger(), -1);
        }
        for (i = 0; i < element.getInvestigations().size(); ++i) {
            this.composeClinicalImpressionClinicalImpressionInvestigationsComponent(t, "ClinicalImpression", "investigations", element.getInvestigations().get(i), i);
        }
        if (element.hasProtocolElement()) {
            this.composeUri(t, "ClinicalImpression", "protocol", element.getProtocolElement(), -1);
        }
        if (element.hasSummaryElement()) {
            this.composeString(t, "ClinicalImpression", "summary", element.getSummaryElement(), -1);
        }
        for (i = 0; i < element.getFinding().size(); ++i) {
            this.composeClinicalImpressionClinicalImpressionFindingComponent(t, "ClinicalImpression", "finding", element.getFinding().get(i), i);
        }
        for (i = 0; i < element.getResolved().size(); ++i) {
            this.composeCodeableConcept(t, "ClinicalImpression", "resolved", element.getResolved().get(i), i);
        }
        for (i = 0; i < element.getRuledOut().size(); ++i) {
            this.composeClinicalImpressionClinicalImpressionRuledOutComponent(t, "ClinicalImpression", "ruledOut", element.getRuledOut().get(i), i);
        }
        if (element.hasPrognosisElement()) {
            this.composeString(t, "ClinicalImpression", "prognosis", element.getPrognosisElement(), -1);
        }
        for (i = 0; i < element.getPlan().size(); ++i) {
            this.composeReference(t, "ClinicalImpression", "plan", element.getPlan().get(i), i);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composeReference(t, "ClinicalImpression", "action", element.getAction().get(i), i);
        }
    }

    protected void composeClinicalImpressionClinicalImpressionInvestigationsComponent(RdfGenerator.Complex parent, String parentType, String name, ClinicalImpression.ClinicalImpressionInvestigationsComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "investigations", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ClinicalImpression", "code", element.getCode(), -1);
        }
        for (int i = 0; i < element.getItem().size(); ++i) {
            this.composeReference(t, "ClinicalImpression", "item", element.getItem().get(i), i);
        }
    }

    protected void composeClinicalImpressionClinicalImpressionFindingComponent(RdfGenerator.Complex parent, String parentType, String name, ClinicalImpression.ClinicalImpressionFindingComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "finding", name, element, index);
        if (element.hasItem()) {
            this.composeCodeableConcept(t, "ClinicalImpression", "item", element.getItem(), -1);
        }
        if (element.hasCauseElement()) {
            this.composeString(t, "ClinicalImpression", "cause", element.getCauseElement(), -1);
        }
    }

    protected void composeClinicalImpressionClinicalImpressionRuledOutComponent(RdfGenerator.Complex parent, String parentType, String name, ClinicalImpression.ClinicalImpressionRuledOutComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "ruledOut", name, element, index);
        if (element.hasItem()) {
            this.composeCodeableConcept(t, "ClinicalImpression", "item", element.getItem(), -1);
        }
        if (element.hasReasonElement()) {
            this.composeString(t, "ClinicalImpression", "reason", element.getReasonElement(), -1);
        }
    }

    protected void composeCodeSystem(RdfGenerator.Complex parent, String parentType, String name, CodeSystem element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CodeSystem", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "CodeSystem", "url", element.getUrlElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "CodeSystem", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "CodeSystem", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "CodeSystem", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CodeSystem", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "CodeSystem", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "CodeSystem", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeCodeSystemCodeSystemContactComponent(t, "CodeSystem", "contact", element.getContact().get(i), i);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "CodeSystem", "date", element.getDateElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CodeSystem", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeCodeableConcept(t, "CodeSystem", "useContext", element.getUseContext().get(i), i);
        }
        if (element.hasRequirementsElement()) {
            this.composeString(t, "CodeSystem", "requirements", element.getRequirementsElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeString(t, "CodeSystem", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasCaseSensitiveElement()) {
            this.composeBoolean(t, "CodeSystem", "caseSensitive", element.getCaseSensitiveElement(), -1);
        }
        if (element.hasValueSetElement()) {
            this.composeUri(t, "CodeSystem", "valueSet", element.getValueSetElement(), -1);
        }
        if (element.hasCompositionalElement()) {
            this.composeBoolean(t, "CodeSystem", "compositional", element.getCompositionalElement(), -1);
        }
        if (element.hasVersionNeededElement()) {
            this.composeBoolean(t, "CodeSystem", "versionNeeded", element.getVersionNeededElement(), -1);
        }
        if (element.hasContentElement()) {
            this.composeEnum(t, "CodeSystem", "content", element.getContentElement(), -1);
        }
        if (element.hasCountElement()) {
            this.composeUnsignedInt(t, "CodeSystem", "count", element.getCountElement(), -1);
        }
        for (i = 0; i < element.getFilter().size(); ++i) {
            this.composeCodeSystemCodeSystemFilterComponent(t, "CodeSystem", "filter", element.getFilter().get(i), i);
        }
        for (i = 0; i < element.getProperty().size(); ++i) {
            this.composeCodeSystemCodeSystemPropertyComponent(t, "CodeSystem", "property", element.getProperty().get(i), i);
        }
        for (i = 0; i < element.getConcept().size(); ++i) {
            this.composeCodeSystemConceptDefinitionComponent(t, "CodeSystem", "concept", element.getConcept().get(i), i);
        }
    }

    protected void composeCodeSystemCodeSystemContactComponent(RdfGenerator.Complex parent, String parentType, String name, CodeSystem.CodeSystemContactComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "CodeSystem", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "CodeSystem", "telecom", element.getTelecom().get(i), i);
        }
    }

    protected void composeCodeSystemCodeSystemFilterComponent(RdfGenerator.Complex parent, String parentType, String name, CodeSystem.CodeSystemFilterComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "filter", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "CodeSystem", "code", element.getCodeElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CodeSystem", "description", element.getDescriptionElement(), -1);
        }
        for (int i = 0; i < element.getOperator().size(); ++i) {
            this.composeCode(t, "CodeSystem", "operator", element.getOperator().get(i), i);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "CodeSystem", "value", element.getValueElement(), -1);
        }
    }

    protected void composeCodeSystemCodeSystemPropertyComponent(RdfGenerator.Complex parent, String parentType, String name, CodeSystem.CodeSystemPropertyComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "CodeSystem", "code", element.getCodeElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CodeSystem", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "CodeSystem", "type", element.getTypeElement(), -1);
        }
    }

    protected void composeCodeSystemConceptDefinitionComponent(RdfGenerator.Complex parent, String parentType, String name, CodeSystem.ConceptDefinitionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "concept", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "CodeSystem", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "CodeSystem", "display", element.getDisplayElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeString(t, "CodeSystem", "definition", element.getDefinitionElement(), -1);
        }
        for (i = 0; i < element.getDesignation().size(); ++i) {
            this.composeCodeSystemConceptDefinitionDesignationComponent(t, "CodeSystem", "designation", element.getDesignation().get(i), i);
        }
        for (i = 0; i < element.getProperty().size(); ++i) {
            this.composeCodeSystemConceptDefinitionPropertyComponent(t, "CodeSystem", "property", element.getProperty().get(i), i);
        }
        for (i = 0; i < element.getConcept().size(); ++i) {
            this.composeCodeSystemConceptDefinitionComponent(t, "CodeSystem", "concept", element.getConcept().get(i), i);
        }
    }

    protected void composeCodeSystemConceptDefinitionDesignationComponent(RdfGenerator.Complex parent, String parentType, String name, CodeSystem.ConceptDefinitionDesignationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "designation", name, element, index);
        if (element.hasLanguageElement()) {
            this.composeCode(t, "CodeSystem", "language", element.getLanguageElement(), -1);
        }
        if (element.hasUse()) {
            this.composeCoding(t, "CodeSystem", "use", element.getUse(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "CodeSystem", "value", element.getValueElement(), -1);
        }
    }

    protected void composeCodeSystemConceptDefinitionPropertyComponent(RdfGenerator.Complex parent, String parentType, String name, CodeSystem.ConceptDefinitionPropertyComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "CodeSystem", "code", element.getCodeElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "CodeSystem", "value", element.getValue(), -1);
        }
    }

    protected void composeCommunication(RdfGenerator.Complex parent, String parentType, String name, Communication element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Communication", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Communication", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "Communication", "category", element.getCategory(), -1);
        }
        if (element.hasSender()) {
            this.composeReference(t, "Communication", "sender", element.getSender(), -1);
        }
        for (i = 0; i < element.getRecipient().size(); ++i) {
            this.composeReference(t, "Communication", "recipient", element.getRecipient().get(i), i);
        }
        for (i = 0; i < element.getPayload().size(); ++i) {
            this.composeCommunicationCommunicationPayloadComponent(t, "Communication", "payload", element.getPayload().get(i), i);
        }
        for (i = 0; i < element.getMedium().size(); ++i) {
            this.composeCodeableConcept(t, "Communication", "medium", element.getMedium().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Communication", "status", element.getStatusElement(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Communication", "encounter", element.getEncounter(), -1);
        }
        if (element.hasSentElement()) {
            this.composeDateTime(t, "Communication", "sent", element.getSentElement(), -1);
        }
        if (element.hasReceivedElement()) {
            this.composeDateTime(t, "Communication", "received", element.getReceivedElement(), -1);
        }
        for (i = 0; i < element.getReason().size(); ++i) {
            this.composeCodeableConcept(t, "Communication", "reason", element.getReason().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Communication", "subject", element.getSubject(), -1);
        }
        if (element.hasRequestDetail()) {
            this.composeReference(t, "Communication", "requestDetail", element.getRequestDetail(), -1);
        }
    }

    protected void composeCommunicationCommunicationPayloadComponent(RdfGenerator.Complex parent, String parentType, String name, Communication.CommunicationPayloadComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "payload", name, element, index);
        if (element.hasContent()) {
            this.composeType(t, "Communication", "content", element.getContent(), -1);
        }
    }

    protected void composeCommunicationRequest(RdfGenerator.Complex parent, String parentType, String name, CommunicationRequest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CommunicationRequest", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "CommunicationRequest", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "CommunicationRequest", "category", element.getCategory(), -1);
        }
        if (element.hasSender()) {
            this.composeReference(t, "CommunicationRequest", "sender", element.getSender(), -1);
        }
        for (i = 0; i < element.getRecipient().size(); ++i) {
            this.composeReference(t, "CommunicationRequest", "recipient", element.getRecipient().get(i), i);
        }
        for (i = 0; i < element.getPayload().size(); ++i) {
            this.composeCommunicationRequestCommunicationRequestPayloadComponent(t, "CommunicationRequest", "payload", element.getPayload().get(i), i);
        }
        for (i = 0; i < element.getMedium().size(); ++i) {
            this.composeCodeableConcept(t, "CommunicationRequest", "medium", element.getMedium().get(i), i);
        }
        if (element.hasRequester()) {
            this.composeReference(t, "CommunicationRequest", "requester", element.getRequester(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CommunicationRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "CommunicationRequest", "encounter", element.getEncounter(), -1);
        }
        if (element.hasScheduled()) {
            this.composeType(t, "CommunicationRequest", "scheduled", element.getScheduled(), -1);
        }
        for (i = 0; i < element.getReason().size(); ++i) {
            this.composeCodeableConcept(t, "CommunicationRequest", "reason", element.getReason().get(i), i);
        }
        if (element.hasRequestedOnElement()) {
            this.composeDateTime(t, "CommunicationRequest", "requestedOn", element.getRequestedOnElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "CommunicationRequest", "subject", element.getSubject(), -1);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "CommunicationRequest", "priority", element.getPriority(), -1);
        }
    }

    protected void composeCommunicationRequestCommunicationRequestPayloadComponent(RdfGenerator.Complex parent, String parentType, String name, CommunicationRequest.CommunicationRequestPayloadComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "payload", name, element, index);
        if (element.hasContent()) {
            this.composeType(t, "CommunicationRequest", "content", element.getContent(), -1);
        }
    }

    protected void composeCompartmentDefinition(RdfGenerator.Complex parent, String parentType, String name, CompartmentDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CompartmentDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "CompartmentDefinition", "url", element.getUrlElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "CompartmentDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CompartmentDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "CompartmentDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "CompartmentDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeCompartmentDefinitionCompartmentDefinitionContactComponent(t, "CompartmentDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "CompartmentDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CompartmentDefinition", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasRequirementsElement()) {
            this.composeString(t, "CompartmentDefinition", "requirements", element.getRequirementsElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeEnum(t, "CompartmentDefinition", "code", element.getCodeElement(), -1);
        }
        if (element.hasSearchElement()) {
            this.composeBoolean(t, "CompartmentDefinition", "search", element.getSearchElement(), -1);
        }
        for (i = 0; i < element.getResource().size(); ++i) {
            this.composeCompartmentDefinitionCompartmentDefinitionResourceComponent(t, "CompartmentDefinition", "resource", element.getResource().get(i), i);
        }
    }

    protected void composeCompartmentDefinitionCompartmentDefinitionContactComponent(RdfGenerator.Complex parent, String parentType, String name, CompartmentDefinition.CompartmentDefinitionContactComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "CompartmentDefinition", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "CompartmentDefinition", "telecom", element.getTelecom().get(i), i);
        }
    }

    protected void composeCompartmentDefinitionCompartmentDefinitionResourceComponent(RdfGenerator.Complex parent, String parentType, String name, CompartmentDefinition.CompartmentDefinitionResourceComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "resource", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "CompartmentDefinition", "code", element.getCodeElement(), -1);
        }
        for (int i = 0; i < element.getParam().size(); ++i) {
            this.composeString(t, "CompartmentDefinition", "param", element.getParam().get(i), i);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "CompartmentDefinition", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeComposition(RdfGenerator.Complex parent, String parentType, String name, Composition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Composition", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Composition", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Composition", "date", element.getDateElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Composition", "type", element.getType(), -1);
        }
        if (element.hasClass_()) {
            this.composeCodeableConcept(t, "Composition", "class", element.getClass_(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Composition", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Composition", "status", element.getStatusElement(), -1);
        }
        if (element.hasConfidentialityElement()) {
            this.composeCode(t, "Composition", "confidentiality", element.getConfidentialityElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Composition", "subject", element.getSubject(), -1);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeReference(t, "Composition", "author", element.getAuthor().get(i), i);
        }
        for (i = 0; i < element.getAttester().size(); ++i) {
            this.composeCompositionCompositionAttesterComponent(t, "Composition", "attester", element.getAttester().get(i), i);
        }
        if (element.hasCustodian()) {
            this.composeReference(t, "Composition", "custodian", element.getCustodian(), -1);
        }
        for (i = 0; i < element.getEvent().size(); ++i) {
            this.composeCompositionCompositionEventComponent(t, "Composition", "event", element.getEvent().get(i), i);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Composition", "encounter", element.getEncounter(), -1);
        }
        for (i = 0; i < element.getSection().size(); ++i) {
            this.composeCompositionSectionComponent(t, "Composition", "section", element.getSection().get(i), i);
        }
    }

    protected void composeCompositionCompositionAttesterComponent(RdfGenerator.Complex parent, String parentType, String name, Composition.CompositionAttesterComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "attester", name, element, index);
        for (int i = 0; i < element.getMode().size(); ++i) {
            this.composeEnum(t, "Composition", "mode", element.getMode().get(i), i);
        }
        if (element.hasTimeElement()) {
            this.composeDateTime(t, "Composition", "time", element.getTimeElement(), -1);
        }
        if (element.hasParty()) {
            this.composeReference(t, "Composition", "party", element.getParty(), -1);
        }
    }

    protected void composeCompositionCompositionEventComponent(RdfGenerator.Complex parent, String parentType, String name, Composition.CompositionEventComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "event", name, element, index);
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCodeableConcept(t, "Composition", "code", element.getCode().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Composition", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeReference(t, "Composition", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeCompositionSectionComponent(RdfGenerator.Complex parent, String parentType, String name, Composition.SectionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "section", name, element, index);
        if (element.hasTitleElement()) {
            this.composeString(t, "Composition", "title", element.getTitleElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Composition", "code", element.getCode(), -1);
        }
        if (element.hasText()) {
            this.composeNarrative(t, "Composition", "text", element.getText(), -1);
        }
        if (element.hasModeElement()) {
            this.composeCode(t, "Composition", "mode", element.getModeElement(), -1);
        }
        if (element.hasOrderedBy()) {
            this.composeCodeableConcept(t, "Composition", "orderedBy", element.getOrderedBy(), -1);
        }
        for (i = 0; i < element.getEntry().size(); ++i) {
            this.composeReference(t, "Composition", "entry", element.getEntry().get(i), i);
        }
        if (element.hasEmptyReason()) {
            this.composeCodeableConcept(t, "Composition", "emptyReason", element.getEmptyReason(), -1);
        }
        for (i = 0; i < element.getSection().size(); ++i) {
            this.composeCompositionSectionComponent(t, "Composition", "section", element.getSection().get(i), i);
        }
    }

    protected void composeConceptMap(RdfGenerator.Complex parent, String parentType, String name, ConceptMap element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ConceptMap", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ConceptMap", "url", element.getUrlElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "ConceptMap", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ConceptMap", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ConceptMap", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ConceptMap", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ConceptMap", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ConceptMap", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeConceptMapConceptMapContactComponent(t, "ConceptMap", "contact", element.getContact().get(i), i);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ConceptMap", "date", element.getDateElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ConceptMap", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeCodeableConcept(t, "ConceptMap", "useContext", element.getUseContext().get(i), i);
        }
        if (element.hasRequirementsElement()) {
            this.composeString(t, "ConceptMap", "requirements", element.getRequirementsElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeString(t, "ConceptMap", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasSource()) {
            this.composeType(t, "ConceptMap", "source", element.getSource(), -1);
        }
        if (element.hasTarget()) {
            this.composeType(t, "ConceptMap", "target", element.getTarget(), -1);
        }
        for (i = 0; i < element.getElement().size(); ++i) {
            this.composeConceptMapSourceElementComponent(t, "ConceptMap", "element", element.getElement().get(i), i);
        }
    }

    protected void composeConceptMapConceptMapContactComponent(RdfGenerator.Complex parent, String parentType, String name, ConceptMap.ConceptMapContactComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ConceptMap", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "ConceptMap", "telecom", element.getTelecom().get(i), i);
        }
    }

    protected void composeConceptMapSourceElementComponent(RdfGenerator.Complex parent, String parentType, String name, ConceptMap.SourceElementComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "element", name, element, index);
        if (element.hasSystemElement()) {
            this.composeUri(t, "ConceptMap", "system", element.getSystemElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ConceptMap", "version", element.getVersionElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "ConceptMap", "code", element.getCodeElement(), -1);
        }
        for (int i = 0; i < element.getTarget().size(); ++i) {
            this.composeConceptMapTargetElementComponent(t, "ConceptMap", "target", element.getTarget().get(i), i);
        }
    }

    protected void composeConceptMapTargetElementComponent(RdfGenerator.Complex parent, String parentType, String name, ConceptMap.TargetElementComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "target", name, element, index);
        if (element.hasSystemElement()) {
            this.composeUri(t, "ConceptMap", "system", element.getSystemElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ConceptMap", "version", element.getVersionElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "ConceptMap", "code", element.getCodeElement(), -1);
        }
        if (element.hasEquivalenceElement()) {
            this.composeEnum(t, "ConceptMap", "equivalence", element.getEquivalenceElement(), -1);
        }
        if (element.hasCommentsElement()) {
            this.composeString(t, "ConceptMap", "comments", element.getCommentsElement(), -1);
        }
        for (i = 0; i < element.getDependsOn().size(); ++i) {
            this.composeConceptMapOtherElementComponent(t, "ConceptMap", "dependsOn", element.getDependsOn().get(i), i);
        }
        for (i = 0; i < element.getProduct().size(); ++i) {
            this.composeConceptMapOtherElementComponent(t, "ConceptMap", "product", element.getProduct().get(i), i);
        }
    }

    protected void composeConceptMapOtherElementComponent(RdfGenerator.Complex parent, String parentType, String name, ConceptMap.OtherElementComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dependsOn", name, element, index);
        if (element.hasElementElement()) {
            this.composeUri(t, "ConceptMap", "element", element.getElementElement(), -1);
        }
        if (element.hasSystemElement()) {
            this.composeUri(t, "ConceptMap", "system", element.getSystemElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeString(t, "ConceptMap", "code", element.getCodeElement(), -1);
        }
    }

    protected void composeCondition(RdfGenerator.Complex parent, String parentType, String name, Condition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Condition", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Condition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "Condition", "patient", element.getPatient(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Condition", "encounter", element.getEncounter(), -1);
        }
        if (element.hasAsserter()) {
            this.composeReference(t, "Condition", "asserter", element.getAsserter(), -1);
        }
        if (element.hasDateRecordedElement()) {
            this.composeDate(t, "Condition", "dateRecorded", element.getDateRecordedElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Condition", "code", element.getCode(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "Condition", "category", element.getCategory(), -1);
        }
        if (element.hasClinicalStatusElement()) {
            this.composeCode(t, "Condition", "clinicalStatus", element.getClinicalStatusElement(), -1);
        }
        if (element.hasVerificationStatusElement()) {
            this.composeEnum(t, "Condition", "verificationStatus", element.getVerificationStatusElement(), -1);
        }
        if (element.hasSeverity()) {
            this.composeCodeableConcept(t, "Condition", "severity", element.getSeverity(), -1);
        }
        if (element.hasOnset()) {
            this.composeType(t, "Condition", "onset", element.getOnset(), -1);
        }
        if (element.hasAbatement()) {
            this.composeType(t, "Condition", "abatement", element.getAbatement(), -1);
        }
        if (element.hasStage()) {
            this.composeConditionConditionStageComponent(t, "Condition", "stage", element.getStage(), -1);
        }
        for (i = 0; i < element.getEvidence().size(); ++i) {
            this.composeConditionConditionEvidenceComponent(t, "Condition", "evidence", element.getEvidence().get(i), i);
        }
        for (i = 0; i < element.getBodySite().size(); ++i) {
            this.composeCodeableConcept(t, "Condition", "bodySite", element.getBodySite().get(i), i);
        }
        if (element.hasNotesElement()) {
            this.composeString(t, "Condition", "notes", element.getNotesElement(), -1);
        }
    }

    protected void composeConditionConditionStageComponent(RdfGenerator.Complex parent, String parentType, String name, Condition.ConditionStageComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "stage", name, element, index);
        if (element.hasSummary()) {
            this.composeCodeableConcept(t, "Condition", "summary", element.getSummary(), -1);
        }
        for (int i = 0; i < element.getAssessment().size(); ++i) {
            this.composeReference(t, "Condition", "assessment", element.getAssessment().get(i), i);
        }
    }

    protected void composeConditionConditionEvidenceComponent(RdfGenerator.Complex parent, String parentType, String name, Condition.ConditionEvidenceComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "evidence", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Condition", "code", element.getCode(), -1);
        }
        for (int i = 0; i < element.getDetail().size(); ++i) {
            this.composeReference(t, "Condition", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeConformance(RdfGenerator.Complex parent, String parentType, String name, Conformance element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Conformance", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "Conformance", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Conformance", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Conformance", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Conformance", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "Conformance", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Conformance", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "Conformance", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeConformanceConformanceContactComponent(t, "Conformance", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Conformance", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeCodeableConcept(t, "Conformance", "useContext", element.getUseContext().get(i), i);
        }
        if (element.hasRequirementsElement()) {
            this.composeString(t, "Conformance", "requirements", element.getRequirementsElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeString(t, "Conformance", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasKindElement()) {
            this.composeEnum(t, "Conformance", "kind", element.getKindElement(), -1);
        }
        if (element.hasSoftware()) {
            this.composeConformanceConformanceSoftwareComponent(t, "Conformance", "software", element.getSoftware(), -1);
        }
        if (element.hasImplementation()) {
            this.composeConformanceConformanceImplementationComponent(t, "Conformance", "implementation", element.getImplementation(), -1);
        }
        if (element.hasFhirVersionElement()) {
            this.composeId(t, "Conformance", "fhirVersion", element.getFhirVersionElement(), -1);
        }
        if (element.hasAcceptUnknownElement()) {
            this.composeEnum(t, "Conformance", "acceptUnknown", element.getAcceptUnknownElement(), -1);
        }
        for (i = 0; i < element.getFormat().size(); ++i) {
            this.composeCode(t, "Conformance", "format", element.getFormat().get(i), i);
        }
        for (i = 0; i < element.getProfile().size(); ++i) {
            this.composeReference(t, "Conformance", "profile", element.getProfile().get(i), i);
        }
        for (i = 0; i < element.getRest().size(); ++i) {
            this.composeConformanceConformanceRestComponent(t, "Conformance", "rest", element.getRest().get(i), i);
        }
        for (i = 0; i < element.getMessaging().size(); ++i) {
            this.composeConformanceConformanceMessagingComponent(t, "Conformance", "messaging", element.getMessaging().get(i), i);
        }
        for (i = 0; i < element.getDocument().size(); ++i) {
            this.composeConformanceConformanceDocumentComponent(t, "Conformance", "document", element.getDocument().get(i), i);
        }
    }

    protected void composeConformanceConformanceContactComponent(RdfGenerator.Complex parent, String parentType, String name, Conformance.ConformanceContactComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "Conformance", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Conformance", "telecom", element.getTelecom().get(i), i);
        }
    }

    protected void composeConformanceConformanceSoftwareComponent(RdfGenerator.Complex parent, String parentType, String name, Conformance.ConformanceSoftwareComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "software", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "Conformance", "name", element.getNameElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Conformance", "version", element.getVersionElement(), -1);
        }
        if (element.hasReleaseDateElement()) {
            this.composeDateTime(t, "Conformance", "releaseDate", element.getReleaseDateElement(), -1);
        }
    }

    protected void composeConformanceConformanceImplementationComponent(RdfGenerator.Complex parent, String parentType, String name, Conformance.ConformanceImplementationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "implementation", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Conformance", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "Conformance", "url", element.getUrlElement(), -1);
        }
    }

    protected void composeConformanceConformanceRestComponent(RdfGenerator.Complex parent, String parentType, String name, Conformance.ConformanceRestComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "rest", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "Conformance", "mode", element.getModeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "Conformance", "documentation", element.getDocumentationElement(), -1);
        }
        if (element.hasSecurity()) {
            this.composeConformanceConformanceRestSecurityComponent(t, "Conformance", "security", element.getSecurity(), -1);
        }
        for (i = 0; i < element.getResource().size(); ++i) {
            this.composeConformanceConformanceRestResourceComponent(t, "Conformance", "resource", element.getResource().get(i), i);
        }
        for (i = 0; i < element.getInteraction().size(); ++i) {
            this.composeConformanceSystemInteractionComponent(t, "Conformance", "interaction", element.getInteraction().get(i), i);
        }
        if (element.hasTransactionModeElement()) {
            this.composeEnum(t, "Conformance", "transactionMode", element.getTransactionModeElement(), -1);
        }
        for (i = 0; i < element.getSearchParam().size(); ++i) {
            this.composeConformanceConformanceRestResourceSearchParamComponent(t, "Conformance", "searchParam", element.getSearchParam().get(i), i);
        }
        for (i = 0; i < element.getOperation().size(); ++i) {
            this.composeConformanceConformanceRestOperationComponent(t, "Conformance", "operation", element.getOperation().get(i), i);
        }
        for (i = 0; i < element.getCompartment().size(); ++i) {
            this.composeUri(t, "Conformance", "compartment", element.getCompartment().get(i), i);
        }
    }

    protected void composeConformanceConformanceRestSecurityComponent(RdfGenerator.Complex parent, String parentType, String name, Conformance.ConformanceRestSecurityComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "security", name, element, index);
        if (element.hasCorsElement()) {
            this.composeBoolean(t, "Conformance", "cors", element.getCorsElement(), -1);
        }
        for (i = 0; i < element.getService().size(); ++i) {
            this.composeCodeableConcept(t, "Conformance", "service", element.getService().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Conformance", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getCertificate().size(); ++i) {
            this.composeConformanceConformanceRestSecurityCertificateComponent(t, "Conformance", "certificate", element.getCertificate().get(i), i);
        }
    }

    protected void composeConformanceConformanceRestSecurityCertificateComponent(RdfGenerator.Complex parent, String parentType, String name, Conformance.ConformanceRestSecurityCertificateComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "certificate", name, element, index);
        if (element.hasTypeElement()) {
            this.composeCode(t, "Conformance", "type", element.getTypeElement(), -1);
        }
        if (element.hasBlobElement()) {
            this.composeBase64Binary(t, "Conformance", "blob", element.getBlobElement(), -1);
        }
    }

    protected void composeConformanceConformanceRestResourceComponent(RdfGenerator.Complex parent, String parentType, String name, Conformance.ConformanceRestResourceComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "resource", name, element, index);
        if (element.hasTypeElement()) {
            this.composeCode(t, "Conformance", "type", element.getTypeElement(), -1);
        }
        if (element.hasProfile()) {
            this.composeReference(t, "Conformance", "profile", element.getProfile(), -1);
        }
        for (i = 0; i < element.getInteraction().size(); ++i) {
            this.composeConformanceResourceInteractionComponent(t, "Conformance", "interaction", element.getInteraction().get(i), i);
        }
        if (element.hasVersioningElement()) {
            this.composeEnum(t, "Conformance", "versioning", element.getVersioningElement(), -1);
        }
        if (element.hasReadHistoryElement()) {
            this.composeBoolean(t, "Conformance", "readHistory", element.getReadHistoryElement(), -1);
        }
        if (element.hasUpdateCreateElement()) {
            this.composeBoolean(t, "Conformance", "updateCreate", element.getUpdateCreateElement(), -1);
        }
        if (element.hasConditionalCreateElement()) {
            this.composeBoolean(t, "Conformance", "conditionalCreate", element.getConditionalCreateElement(), -1);
        }
        if (element.hasConditionalUpdateElement()) {
            this.composeBoolean(t, "Conformance", "conditionalUpdate", element.getConditionalUpdateElement(), -1);
        }
        if (element.hasConditionalDeleteElement()) {
            this.composeEnum(t, "Conformance", "conditionalDelete", element.getConditionalDeleteElement(), -1);
        }
        for (i = 0; i < element.getSearchInclude().size(); ++i) {
            this.composeString(t, "Conformance", "searchInclude", element.getSearchInclude().get(i), i);
        }
        for (i = 0; i < element.getSearchRevInclude().size(); ++i) {
            this.composeString(t, "Conformance", "searchRevInclude", element.getSearchRevInclude().get(i), i);
        }
        for (i = 0; i < element.getSearchParam().size(); ++i) {
            this.composeConformanceConformanceRestResourceSearchParamComponent(t, "Conformance", "searchParam", element.getSearchParam().get(i), i);
        }
    }

    protected void composeConformanceResourceInteractionComponent(RdfGenerator.Complex parent, String parentType, String name, Conformance.ResourceInteractionComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "interaction", name, element, index);
        if (element.hasCodeElement()) {
            this.composeEnum(t, "Conformance", "code", element.getCodeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "Conformance", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeConformanceConformanceRestResourceSearchParamComponent(RdfGenerator.Complex parent, String parentType, String name, Conformance.ConformanceRestResourceSearchParamComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "searchParam", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "Conformance", "name", element.getNameElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeUri(t, "Conformance", "definition", element.getDefinitionElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Conformance", "type", element.getTypeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "Conformance", "documentation", element.getDocumentationElement(), -1);
        }
        for (i = 0; i < element.getTarget().size(); ++i) {
            this.composeCode(t, "Conformance", "target", element.getTarget().get(i), i);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeEnum(t, "Conformance", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getChain().size(); ++i) {
            this.composeString(t, "Conformance", "chain", element.getChain().get(i), i);
        }
    }

    protected void composeConformanceSystemInteractionComponent(RdfGenerator.Complex parent, String parentType, String name, Conformance.SystemInteractionComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "interaction", name, element, index);
        if (element.hasCodeElement()) {
            this.composeEnum(t, "Conformance", "code", element.getCodeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "Conformance", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeConformanceConformanceRestOperationComponent(RdfGenerator.Complex parent, String parentType, String name, Conformance.ConformanceRestOperationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "operation", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "Conformance", "name", element.getNameElement(), -1);
        }
        if (element.hasDefinition()) {
            this.composeReference(t, "Conformance", "definition", element.getDefinition(), -1);
        }
    }

    protected void composeConformanceConformanceMessagingComponent(RdfGenerator.Complex parent, String parentType, String name, Conformance.ConformanceMessagingComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "messaging", name, element, index);
        for (i = 0; i < element.getEndpoint().size(); ++i) {
            this.composeConformanceConformanceMessagingEndpointComponent(t, "Conformance", "endpoint", element.getEndpoint().get(i), i);
        }
        if (element.hasReliableCacheElement()) {
            this.composeUnsignedInt(t, "Conformance", "reliableCache", element.getReliableCacheElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "Conformance", "documentation", element.getDocumentationElement(), -1);
        }
        for (i = 0; i < element.getEvent().size(); ++i) {
            this.composeConformanceConformanceMessagingEventComponent(t, "Conformance", "event", element.getEvent().get(i), i);
        }
    }

    protected void composeConformanceConformanceMessagingEndpointComponent(RdfGenerator.Complex parent, String parentType, String name, Conformance.ConformanceMessagingEndpointComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "endpoint", name, element, index);
        if (element.hasProtocol()) {
            this.composeCoding(t, "Conformance", "protocol", element.getProtocol(), -1);
        }
        if (element.hasAddressElement()) {
            this.composeUri(t, "Conformance", "address", element.getAddressElement(), -1);
        }
    }

    protected void composeConformanceConformanceMessagingEventComponent(RdfGenerator.Complex parent, String parentType, String name, Conformance.ConformanceMessagingEventComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "event", name, element, index);
        if (element.hasCode()) {
            this.composeCoding(t, "Conformance", "code", element.getCode(), -1);
        }
        if (element.hasCategoryElement()) {
            this.composeEnum(t, "Conformance", "category", element.getCategoryElement(), -1);
        }
        if (element.hasModeElement()) {
            this.composeEnum(t, "Conformance", "mode", element.getModeElement(), -1);
        }
        if (element.hasFocusElement()) {
            this.composeCode(t, "Conformance", "focus", element.getFocusElement(), -1);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "Conformance", "request", element.getRequest(), -1);
        }
        if (element.hasResponse()) {
            this.composeReference(t, "Conformance", "response", element.getResponse(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "Conformance", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeConformanceConformanceDocumentComponent(RdfGenerator.Complex parent, String parentType, String name, Conformance.ConformanceDocumentComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "document", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "Conformance", "mode", element.getModeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "Conformance", "documentation", element.getDocumentationElement(), -1);
        }
        if (element.hasProfile()) {
            this.composeReference(t, "Conformance", "profile", element.getProfile(), -1);
        }
    }

    protected void composeContract(RdfGenerator.Complex parent, String parentType, String name, Contract element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Contract", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Contract", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasIssuedElement()) {
            this.composeDateTime(t, "Contract", "issued", element.getIssuedElement(), -1);
        }
        if (element.hasApplies()) {
            this.composePeriod(t, "Contract", "applies", element.getApplies(), -1);
        }
        for (i = 0; i < element.getSubject().size(); ++i) {
            this.composeReference(t, "Contract", "subject", element.getSubject().get(i), i);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeReference(t, "Contract", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getAuthority().size(); ++i) {
            this.composeReference(t, "Contract", "authority", element.getAuthority().get(i), i);
        }
        for (i = 0; i < element.getDomain().size(); ++i) {
            this.composeReference(t, "Contract", "domain", element.getDomain().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Contract", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getSubType().size(); ++i) {
            this.composeCodeableConcept(t, "Contract", "subType", element.getSubType().get(i), i);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composeCodeableConcept(t, "Contract", "action", element.getAction().get(i), i);
        }
        for (i = 0; i < element.getActionReason().size(); ++i) {
            this.composeCodeableConcept(t, "Contract", "actionReason", element.getActionReason().get(i), i);
        }
        for (i = 0; i < element.getAgent().size(); ++i) {
            this.composeContractAgentComponent(t, "Contract", "agent", element.getAgent().get(i), i);
        }
        for (i = 0; i < element.getSigner().size(); ++i) {
            this.composeContractSignatoryComponent(t, "Contract", "signer", element.getSigner().get(i), i);
        }
        for (i = 0; i < element.getValuedItem().size(); ++i) {
            this.composeContractValuedItemComponent(t, "Contract", "valuedItem", element.getValuedItem().get(i), i);
        }
        for (i = 0; i < element.getTerm().size(); ++i) {
            this.composeContractTermComponent(t, "Contract", "term", element.getTerm().get(i), i);
        }
        if (element.hasBinding()) {
            this.composeType(t, "Contract", "binding", element.getBinding(), -1);
        }
        for (i = 0; i < element.getFriendly().size(); ++i) {
            this.composeContractFriendlyLanguageComponent(t, "Contract", "friendly", element.getFriendly().get(i), i);
        }
        for (i = 0; i < element.getLegal().size(); ++i) {
            this.composeContractLegalLanguageComponent(t, "Contract", "legal", element.getLegal().get(i), i);
        }
        for (i = 0; i < element.getRule().size(); ++i) {
            this.composeContractComputableLanguageComponent(t, "Contract", "rule", element.getRule().get(i), i);
        }
    }

    protected void composeContractAgentComponent(RdfGenerator.Complex parent, String parentType, String name, Contract.AgentComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "agent", name, element, index);
        if (element.hasActor()) {
            this.composeReference(t, "Contract", "actor", element.getActor(), -1);
        }
        for (int i = 0; i < element.getRole().size(); ++i) {
            this.composeCodeableConcept(t, "Contract", "role", element.getRole().get(i), i);
        }
    }

    protected void composeContractSignatoryComponent(RdfGenerator.Complex parent, String parentType, String name, Contract.SignatoryComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "signer", name, element, index);
        if (element.hasType()) {
            this.composeCoding(t, "Contract", "type", element.getType(), -1);
        }
        if (element.hasParty()) {
            this.composeReference(t, "Contract", "party", element.getParty(), -1);
        }
        for (int i = 0; i < element.getSignature().size(); ++i) {
            this.composeSignature(t, "Contract", "signature", element.getSignature().get(i), i);
        }
    }

    protected void composeContractValuedItemComponent(RdfGenerator.Complex parent, String parentType, String name, Contract.ValuedItemComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "valuedItem", name, element, index);
        if (element.hasEntity()) {
            this.composeType(t, "Contract", "entity", element.getEntity(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Contract", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasEffectiveTimeElement()) {
            this.composeDateTime(t, "Contract", "effectiveTime", element.getEffectiveTimeElement(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "Contract", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeQuantity(t, "Contract", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "Contract", "factor", element.getFactorElement(), -1);
        }
        if (element.hasPointsElement()) {
            this.composeDecimal(t, "Contract", "points", element.getPointsElement(), -1);
        }
        if (element.hasNet()) {
            this.composeQuantity(t, "Contract", "net", element.getNet(), -1);
        }
    }

    protected void composeContractTermComponent(RdfGenerator.Complex parent, String parentType, String name, Contract.TermComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "term", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Contract", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasIssuedElement()) {
            this.composeDateTime(t, "Contract", "issued", element.getIssuedElement(), -1);
        }
        if (element.hasApplies()) {
            this.composePeriod(t, "Contract", "applies", element.getApplies(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Contract", "type", element.getType(), -1);
        }
        if (element.hasSubType()) {
            this.composeCodeableConcept(t, "Contract", "subType", element.getSubType(), -1);
        }
        for (i = 0; i < element.getTopic().size(); ++i) {
            this.composeReference(t, "Contract", "topic", element.getTopic().get(i), i);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composeCodeableConcept(t, "Contract", "action", element.getAction().get(i), i);
        }
        for (i = 0; i < element.getActionReason().size(); ++i) {
            this.composeCodeableConcept(t, "Contract", "actionReason", element.getActionReason().get(i), i);
        }
        for (i = 0; i < element.getAgent().size(); ++i) {
            this.composeContractTermAgentComponent(t, "Contract", "agent", element.getAgent().get(i), i);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "Contract", "text", element.getTextElement(), -1);
        }
        for (i = 0; i < element.getValuedItem().size(); ++i) {
            this.composeContractTermValuedItemComponent(t, "Contract", "valuedItem", element.getValuedItem().get(i), i);
        }
        for (i = 0; i < element.getGroup().size(); ++i) {
            this.composeContractTermComponent(t, "Contract", "group", element.getGroup().get(i), i);
        }
    }

    protected void composeContractTermAgentComponent(RdfGenerator.Complex parent, String parentType, String name, Contract.TermAgentComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "agent", name, element, index);
        if (element.hasActor()) {
            this.composeReference(t, "Contract", "actor", element.getActor(), -1);
        }
        for (int i = 0; i < element.getRole().size(); ++i) {
            this.composeCodeableConcept(t, "Contract", "role", element.getRole().get(i), i);
        }
    }

    protected void composeContractTermValuedItemComponent(RdfGenerator.Complex parent, String parentType, String name, Contract.TermValuedItemComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "valuedItem", name, element, index);
        if (element.hasEntity()) {
            this.composeType(t, "Contract", "entity", element.getEntity(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Contract", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasEffectiveTimeElement()) {
            this.composeDateTime(t, "Contract", "effectiveTime", element.getEffectiveTimeElement(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "Contract", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeQuantity(t, "Contract", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "Contract", "factor", element.getFactorElement(), -1);
        }
        if (element.hasPointsElement()) {
            this.composeDecimal(t, "Contract", "points", element.getPointsElement(), -1);
        }
        if (element.hasNet()) {
            this.composeQuantity(t, "Contract", "net", element.getNet(), -1);
        }
    }

    protected void composeContractFriendlyLanguageComponent(RdfGenerator.Complex parent, String parentType, String name, Contract.FriendlyLanguageComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "friendly", name, element, index);
        if (element.hasContent()) {
            this.composeType(t, "Contract", "content", element.getContent(), -1);
        }
    }

    protected void composeContractLegalLanguageComponent(RdfGenerator.Complex parent, String parentType, String name, Contract.LegalLanguageComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "legal", name, element, index);
        if (element.hasContent()) {
            this.composeType(t, "Contract", "content", element.getContent(), -1);
        }
    }

    protected void composeContractComputableLanguageComponent(RdfGenerator.Complex parent, String parentType, String name, Contract.ComputableLanguageComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "rule", name, element, index);
        if (element.hasContent()) {
            this.composeType(t, "Contract", "content", element.getContent(), -1);
        }
    }

    protected void composeCoverage(RdfGenerator.Complex parent, String parentType, String name, Coverage element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Coverage", name, element, index);
        if (element.hasIssuer()) {
            this.composeType(t, "Coverage", "issuer", element.getIssuer(), -1);
        }
        if (element.hasBinElement()) {
            this.composeString(t, "Coverage", "bin", element.getBinElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Coverage", "period", element.getPeriod(), -1);
        }
        if (element.hasType()) {
            this.composeCoding(t, "Coverage", "type", element.getType(), -1);
        }
        if (element.hasPlanholder()) {
            this.composeType(t, "Coverage", "planholder", element.getPlanholder(), -1);
        }
        if (element.hasBeneficiary()) {
            this.composeType(t, "Coverage", "beneficiary", element.getBeneficiary(), -1);
        }
        if (element.hasRelationship()) {
            this.composeCoding(t, "Coverage", "relationship", element.getRelationship(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Coverage", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasGroupElement()) {
            this.composeString(t, "Coverage", "group", element.getGroupElement(), -1);
        }
        if (element.hasPlanElement()) {
            this.composeString(t, "Coverage", "plan", element.getPlanElement(), -1);
        }
        if (element.hasSubPlanElement()) {
            this.composeString(t, "Coverage", "subPlan", element.getSubPlanElement(), -1);
        }
        if (element.hasDependentElement()) {
            this.composePositiveInt(t, "Coverage", "dependent", element.getDependentElement(), -1);
        }
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "Coverage", "sequence", element.getSequenceElement(), -1);
        }
        for (i = 0; i < element.getException().size(); ++i) {
            this.composeCoding(t, "Coverage", "exception", element.getException().get(i), i);
        }
        if (element.hasSchoolElement()) {
            this.composeString(t, "Coverage", "school", element.getSchoolElement(), -1);
        }
        if (element.hasNetworkElement()) {
            this.composeString(t, "Coverage", "network", element.getNetworkElement(), -1);
        }
        for (i = 0; i < element.getContract().size(); ++i) {
            this.composeReference(t, "Coverage", "contract", element.getContract().get(i), i);
        }
    }

    protected void composeDataElement(RdfGenerator.Complex parent, String parentType, String name, DataElement element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DataElement", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "DataElement", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DataElement", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "DataElement", "version", element.getVersionElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DataElement", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "DataElement", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "DataElement", "publisher", element.getPublisherElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "DataElement", "date", element.getDateElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "DataElement", "name", element.getNameElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeDataElementDataElementContactComponent(t, "DataElement", "contact", element.getContact().get(i), i);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeCodeableConcept(t, "DataElement", "useContext", element.getUseContext().get(i), i);
        }
        if (element.hasCopyrightElement()) {
            this.composeString(t, "DataElement", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasStringencyElement()) {
            this.composeEnum(t, "DataElement", "stringency", element.getStringencyElement(), -1);
        }
        for (i = 0; i < element.getMapping().size(); ++i) {
            this.composeDataElementDataElementMappingComponent(t, "DataElement", "mapping", element.getMapping().get(i), i);
        }
        for (i = 0; i < element.getElement().size(); ++i) {
            this.composeElementDefinition(t, "DataElement", "element", element.getElement().get(i), i);
        }
    }

    protected void composeDataElementDataElementContactComponent(RdfGenerator.Complex parent, String parentType, String name, DataElement.DataElementContactComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "DataElement", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "DataElement", "telecom", element.getTelecom().get(i), i);
        }
    }

    protected void composeDataElementDataElementMappingComponent(RdfGenerator.Complex parent, String parentType, String name, DataElement.DataElementMappingComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "mapping", name, element, index);
        if (element.hasIdentityElement()) {
            this.composeId(t, "DataElement", "identity", element.getIdentityElement(), -1);
        }
        if (element.hasUriElement()) {
            this.composeUri(t, "DataElement", "uri", element.getUriElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "DataElement", "name", element.getNameElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "DataElement", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeDecisionSupportRule(RdfGenerator.Complex parent, String parentType, String name, DecisionSupportRule element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DecisionSupportRule", name, element, index);
        if (element.hasModuleMetadata()) {
            this.composeModuleMetadata(t, "DecisionSupportRule", "moduleMetadata", element.getModuleMetadata(), -1);
        }
        for (i = 0; i < element.getLibrary().size(); ++i) {
            this.composeReference(t, "DecisionSupportRule", "library", element.getLibrary().get(i), i);
        }
        for (i = 0; i < element.getTrigger().size(); ++i) {
            this.composeTriggerDefinition(t, "DecisionSupportRule", "trigger", element.getTrigger().get(i), i);
        }
        if (element.hasConditionElement()) {
            this.composeString(t, "DecisionSupportRule", "condition", element.getConditionElement(), -1);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composeActionDefinition(t, "DecisionSupportRule", "action", element.getAction().get(i), i);
        }
    }

    protected void composeDecisionSupportServiceModule(RdfGenerator.Complex parent, String parentType, String name, DecisionSupportServiceModule element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DecisionSupportServiceModule", name, element, index);
        if (element.hasModuleMetadata()) {
            this.composeModuleMetadata(t, "DecisionSupportServiceModule", "moduleMetadata", element.getModuleMetadata(), -1);
        }
        for (i = 0; i < element.getTrigger().size(); ++i) {
            this.composeTriggerDefinition(t, "DecisionSupportServiceModule", "trigger", element.getTrigger().get(i), i);
        }
        for (i = 0; i < element.getParameter().size(); ++i) {
            this.composeParameterDefinition(t, "DecisionSupportServiceModule", "parameter", element.getParameter().get(i), i);
        }
        for (i = 0; i < element.getDataRequirement().size(); ++i) {
            this.composeDataRequirement(t, "DecisionSupportServiceModule", "dataRequirement", element.getDataRequirement().get(i), i);
        }
    }

    protected void composeDetectedIssue(RdfGenerator.Complex parent, String parentType, String name, DetectedIssue element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DetectedIssue", name, element, index);
        if (element.hasPatient()) {
            this.composeReference(t, "DetectedIssue", "patient", element.getPatient(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "DetectedIssue", "category", element.getCategory(), -1);
        }
        if (element.hasSeverityElement()) {
            this.composeEnum(t, "DetectedIssue", "severity", element.getSeverityElement(), -1);
        }
        for (i = 0; i < element.getImplicated().size(); ++i) {
            this.composeReference(t, "DetectedIssue", "implicated", element.getImplicated().get(i), i);
        }
        if (element.hasDetailElement()) {
            this.composeString(t, "DetectedIssue", "detail", element.getDetailElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "DetectedIssue", "date", element.getDateElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "DetectedIssue", "author", element.getAuthor(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "DetectedIssue", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasReferenceElement()) {
            this.composeUri(t, "DetectedIssue", "reference", element.getReferenceElement(), -1);
        }
        for (i = 0; i < element.getMitigation().size(); ++i) {
            this.composeDetectedIssueDetectedIssueMitigationComponent(t, "DetectedIssue", "mitigation", element.getMitigation().get(i), i);
        }
    }

    protected void composeDetectedIssueDetectedIssueMitigationComponent(RdfGenerator.Complex parent, String parentType, String name, DetectedIssue.DetectedIssueMitigationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "mitigation", name, element, index);
        if (element.hasAction()) {
            this.composeCodeableConcept(t, "DetectedIssue", "action", element.getAction(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "DetectedIssue", "date", element.getDateElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "DetectedIssue", "author", element.getAuthor(), -1);
        }
    }

    protected void composeDevice(RdfGenerator.Complex parent, String parentType, String name, Device element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Device", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Device", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasUdiCarrier()) {
            this.composeIdentifier(t, "Device", "udiCarrier", element.getUdiCarrier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Device", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Device", "type", element.getType(), -1);
        }
        if (element.hasLotNumberElement()) {
            this.composeString(t, "Device", "lotNumber", element.getLotNumberElement(), -1);
        }
        if (element.hasManufacturerElement()) {
            this.composeString(t, "Device", "manufacturer", element.getManufacturerElement(), -1);
        }
        if (element.hasManufactureDateElement()) {
            this.composeDateTime(t, "Device", "manufactureDate", element.getManufactureDateElement(), -1);
        }
        if (element.hasExpirationDateElement()) {
            this.composeDateTime(t, "Device", "expirationDate", element.getExpirationDateElement(), -1);
        }
        if (element.hasModelElement()) {
            this.composeString(t, "Device", "model", element.getModelElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Device", "version", element.getVersionElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "Device", "patient", element.getPatient(), -1);
        }
        if (element.hasOwner()) {
            this.composeReference(t, "Device", "owner", element.getOwner(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactPoint(t, "Device", "contact", element.getContact().get(i), i);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "Device", "location", element.getLocation(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "Device", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Device", "note", element.getNote().get(i), i);
        }
    }

    protected void composeDeviceComponent(RdfGenerator.Complex parent, String parentType, String name, DeviceComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DeviceComponent", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DeviceComponent", "type", element.getType(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "DeviceComponent", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasLastSystemChangeElement()) {
            this.composeInstant(t, "DeviceComponent", "lastSystemChange", element.getLastSystemChangeElement(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "DeviceComponent", "source", element.getSource(), -1);
        }
        if (element.hasParent()) {
            this.composeReference(t, "DeviceComponent", "parent", element.getParent(), -1);
        }
        for (i = 0; i < element.getOperationalStatus().size(); ++i) {
            this.composeCodeableConcept(t, "DeviceComponent", "operationalStatus", element.getOperationalStatus().get(i), i);
        }
        if (element.hasParameterGroup()) {
            this.composeCodeableConcept(t, "DeviceComponent", "parameterGroup", element.getParameterGroup(), -1);
        }
        if (element.hasMeasurementPrincipleElement()) {
            this.composeEnum(t, "DeviceComponent", "measurementPrinciple", element.getMeasurementPrincipleElement(), -1);
        }
        for (i = 0; i < element.getProductionSpecification().size(); ++i) {
            this.composeDeviceComponentDeviceComponentProductionSpecificationComponent(t, "DeviceComponent", "productionSpecification", element.getProductionSpecification().get(i), i);
        }
        if (element.hasLanguageCode()) {
            this.composeCodeableConcept(t, "DeviceComponent", "languageCode", element.getLanguageCode(), -1);
        }
    }

    protected void composeDeviceComponentDeviceComponentProductionSpecificationComponent(RdfGenerator.Complex parent, String parentType, String name, DeviceComponent.DeviceComponentProductionSpecificationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "productionSpecification", name, element, index);
        if (element.hasSpecType()) {
            this.composeCodeableConcept(t, "DeviceComponent", "specType", element.getSpecType(), -1);
        }
        if (element.hasComponentId()) {
            this.composeIdentifier(t, "DeviceComponent", "componentId", element.getComponentId(), -1);
        }
        if (element.hasProductionSpecElement()) {
            this.composeString(t, "DeviceComponent", "productionSpec", element.getProductionSpecElement(), -1);
        }
    }

    protected void composeDeviceMetric(RdfGenerator.Complex parent, String parentType, String name, DeviceMetric element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DeviceMetric", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DeviceMetric", "type", element.getType(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "DeviceMetric", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasUnit()) {
            this.composeCodeableConcept(t, "DeviceMetric", "unit", element.getUnit(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "DeviceMetric", "source", element.getSource(), -1);
        }
        if (element.hasParent()) {
            this.composeReference(t, "DeviceMetric", "parent", element.getParent(), -1);
        }
        if (element.hasOperationalStatusElement()) {
            this.composeEnum(t, "DeviceMetric", "operationalStatus", element.getOperationalStatusElement(), -1);
        }
        if (element.hasColorElement()) {
            this.composeEnum(t, "DeviceMetric", "color", element.getColorElement(), -1);
        }
        if (element.hasCategoryElement()) {
            this.composeEnum(t, "DeviceMetric", "category", element.getCategoryElement(), -1);
        }
        if (element.hasMeasurementPeriod()) {
            this.composeTiming(t, "DeviceMetric", "measurementPeriod", element.getMeasurementPeriod(), -1);
        }
        for (int i = 0; i < element.getCalibration().size(); ++i) {
            this.composeDeviceMetricDeviceMetricCalibrationComponent(t, "DeviceMetric", "calibration", element.getCalibration().get(i), i);
        }
    }

    protected void composeDeviceMetricDeviceMetricCalibrationComponent(RdfGenerator.Complex parent, String parentType, String name, DeviceMetric.DeviceMetricCalibrationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "calibration", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "DeviceMetric", "type", element.getTypeElement(), -1);
        }
        if (element.hasStateElement()) {
            this.composeEnum(t, "DeviceMetric", "state", element.getStateElement(), -1);
        }
        if (element.hasTimeElement()) {
            this.composeInstant(t, "DeviceMetric", "time", element.getTimeElement(), -1);
        }
    }

    protected void composeDeviceUseRequest(RdfGenerator.Complex parent, String parentType, String name, DeviceUseRequest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DeviceUseRequest", name, element, index);
        if (element.hasBodySite()) {
            this.composeType(t, "DeviceUseRequest", "bodySite", element.getBodySite(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DeviceUseRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasDevice()) {
            this.composeReference(t, "DeviceUseRequest", "device", element.getDevice(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "DeviceUseRequest", "encounter", element.getEncounter(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DeviceUseRequest", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getIndication().size(); ++i) {
            this.composeCodeableConcept(t, "DeviceUseRequest", "indication", element.getIndication().get(i), i);
        }
        for (i = 0; i < element.getNotes().size(); ++i) {
            this.composeString(t, "DeviceUseRequest", "notes", element.getNotes().get(i), i);
        }
        for (i = 0; i < element.getPrnReason().size(); ++i) {
            this.composeCodeableConcept(t, "DeviceUseRequest", "prnReason", element.getPrnReason().get(i), i);
        }
        if (element.hasOrderedOnElement()) {
            this.composeDateTime(t, "DeviceUseRequest", "orderedOn", element.getOrderedOnElement(), -1);
        }
        if (element.hasRecordedOnElement()) {
            this.composeDateTime(t, "DeviceUseRequest", "recordedOn", element.getRecordedOnElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DeviceUseRequest", "subject", element.getSubject(), -1);
        }
        if (element.hasTiming()) {
            this.composeType(t, "DeviceUseRequest", "timing", element.getTiming(), -1);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "DeviceUseRequest", "priority", element.getPriorityElement(), -1);
        }
    }

    protected void composeDeviceUseStatement(RdfGenerator.Complex parent, String parentType, String name, DeviceUseStatement element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DeviceUseStatement", name, element, index);
        if (element.hasBodySite()) {
            this.composeType(t, "DeviceUseStatement", "bodySite", element.getBodySite(), -1);
        }
        if (element.hasWhenUsed()) {
            this.composePeriod(t, "DeviceUseStatement", "whenUsed", element.getWhenUsed(), -1);
        }
        if (element.hasDevice()) {
            this.composeReference(t, "DeviceUseStatement", "device", element.getDevice(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DeviceUseStatement", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getIndication().size(); ++i) {
            this.composeCodeableConcept(t, "DeviceUseStatement", "indication", element.getIndication().get(i), i);
        }
        for (i = 0; i < element.getNotes().size(); ++i) {
            this.composeString(t, "DeviceUseStatement", "notes", element.getNotes().get(i), i);
        }
        if (element.hasRecordedOnElement()) {
            this.composeDateTime(t, "DeviceUseStatement", "recordedOn", element.getRecordedOnElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DeviceUseStatement", "subject", element.getSubject(), -1);
        }
        if (element.hasTiming()) {
            this.composeType(t, "DeviceUseStatement", "timing", element.getTiming(), -1);
        }
    }

    protected void composeDiagnosticOrder(RdfGenerator.Complex parent, String parentType, String name, DiagnosticOrder element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DiagnosticOrder", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DiagnosticOrder", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DiagnosticOrder", "status", element.getStatusElement(), -1);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "DiagnosticOrder", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DiagnosticOrder", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "DiagnosticOrder", "encounter", element.getEncounter(), -1);
        }
        if (element.hasOrderer()) {
            this.composeReference(t, "DiagnosticOrder", "orderer", element.getOrderer(), -1);
        }
        for (i = 0; i < element.getReason().size(); ++i) {
            this.composeCodeableConcept(t, "DiagnosticOrder", "reason", element.getReason().get(i), i);
        }
        for (i = 0; i < element.getSupportingInformation().size(); ++i) {
            this.composeReference(t, "DiagnosticOrder", "supportingInformation", element.getSupportingInformation().get(i), i);
        }
        for (i = 0; i < element.getSpecimen().size(); ++i) {
            this.composeReference(t, "DiagnosticOrder", "specimen", element.getSpecimen().get(i), i);
        }
        for (i = 0; i < element.getEvent().size(); ++i) {
            this.composeDiagnosticOrderDiagnosticOrderEventComponent(t, "DiagnosticOrder", "event", element.getEvent().get(i), i);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeDiagnosticOrderDiagnosticOrderItemComponent(t, "DiagnosticOrder", "item", element.getItem().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "DiagnosticOrder", "note", element.getNote().get(i), i);
        }
    }

    protected void composeDiagnosticOrderDiagnosticOrderEventComponent(RdfGenerator.Complex parent, String parentType, String name, DiagnosticOrder.DiagnosticOrderEventComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "event", name, element, index);
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DiagnosticOrder", "status", element.getStatusElement(), -1);
        }
        if (element.hasDescription()) {
            this.composeCodeableConcept(t, "DiagnosticOrder", "description", element.getDescription(), -1);
        }
        if (element.hasDateTimeElement()) {
            this.composeDateTime(t, "DiagnosticOrder", "dateTime", element.getDateTimeElement(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "DiagnosticOrder", "actor", element.getActor(), -1);
        }
    }

    protected void composeDiagnosticOrderDiagnosticOrderItemComponent(RdfGenerator.Complex parent, String parentType, String name, DiagnosticOrder.DiagnosticOrderItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "DiagnosticOrder", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getSpecimen().size(); ++i) {
            this.composeReference(t, "DiagnosticOrder", "specimen", element.getSpecimen().get(i), i);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "DiagnosticOrder", "bodySite", element.getBodySite(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DiagnosticOrder", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getEvent().size(); ++i) {
            this.composeDiagnosticOrderDiagnosticOrderEventComponent(t, "DiagnosticOrder", "event", element.getEvent().get(i), i);
        }
    }

    protected void composeDiagnosticReport(RdfGenerator.Complex parent, String parentType, String name, DiagnosticReport element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DiagnosticReport", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DiagnosticReport", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DiagnosticReport", "status", element.getStatusElement(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "DiagnosticReport", "category", element.getCategory(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "DiagnosticReport", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DiagnosticReport", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "DiagnosticReport", "encounter", element.getEncounter(), -1);
        }
        if (element.hasEffective()) {
            this.composeType(t, "DiagnosticReport", "effective", element.getEffective(), -1);
        }
        if (element.hasIssuedElement()) {
            this.composeInstant(t, "DiagnosticReport", "issued", element.getIssuedElement(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "DiagnosticReport", "performer", element.getPerformer(), -1);
        }
        for (i = 0; i < element.getRequest().size(); ++i) {
            this.composeReference(t, "DiagnosticReport", "request", element.getRequest().get(i), i);
        }
        for (i = 0; i < element.getSpecimen().size(); ++i) {
            this.composeReference(t, "DiagnosticReport", "specimen", element.getSpecimen().get(i), i);
        }
        for (i = 0; i < element.getResult().size(); ++i) {
            this.composeReference(t, "DiagnosticReport", "result", element.getResult().get(i), i);
        }
        for (i = 0; i < element.getImagingStudy().size(); ++i) {
            this.composeReference(t, "DiagnosticReport", "imagingStudy", element.getImagingStudy().get(i), i);
        }
        for (i = 0; i < element.getImage().size(); ++i) {
            this.composeDiagnosticReportDiagnosticReportImageComponent(t, "DiagnosticReport", "image", element.getImage().get(i), i);
        }
        if (element.hasConclusionElement()) {
            this.composeString(t, "DiagnosticReport", "conclusion", element.getConclusionElement(), -1);
        }
        for (i = 0; i < element.getCodedDiagnosis().size(); ++i) {
            this.composeCodeableConcept(t, "DiagnosticReport", "codedDiagnosis", element.getCodedDiagnosis().get(i), i);
        }
        for (i = 0; i < element.getPresentedForm().size(); ++i) {
            this.composeAttachment(t, "DiagnosticReport", "presentedForm", element.getPresentedForm().get(i), i);
        }
    }

    protected void composeDiagnosticReportDiagnosticReportImageComponent(RdfGenerator.Complex parent, String parentType, String name, DiagnosticReport.DiagnosticReportImageComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "image", name, element, index);
        if (element.hasCommentElement()) {
            this.composeString(t, "DiagnosticReport", "comment", element.getCommentElement(), -1);
        }
        if (element.hasLink()) {
            this.composeReference(t, "DiagnosticReport", "link", element.getLink(), -1);
        }
    }

    protected void composeDocumentManifest(RdfGenerator.Complex parent, String parentType, String name, DocumentManifest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DocumentManifest", name, element, index);
        if (element.hasMasterIdentifier()) {
            this.composeIdentifier(t, "DocumentManifest", "masterIdentifier", element.getMasterIdentifier(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DocumentManifest", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DocumentManifest", "subject", element.getSubject(), -1);
        }
        for (i = 0; i < element.getRecipient().size(); ++i) {
            this.composeReference(t, "DocumentManifest", "recipient", element.getRecipient().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DocumentManifest", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeReference(t, "DocumentManifest", "author", element.getAuthor().get(i), i);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "DocumentManifest", "created", element.getCreatedElement(), -1);
        }
        if (element.hasSourceElement()) {
            this.composeUri(t, "DocumentManifest", "source", element.getSourceElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DocumentManifest", "status", element.getStatusElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "DocumentManifest", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getContent().size(); ++i) {
            this.composeDocumentManifestDocumentManifestContentComponent(t, "DocumentManifest", "content", element.getContent().get(i), i);
        }
        for (i = 0; i < element.getRelated().size(); ++i) {
            this.composeDocumentManifestDocumentManifestRelatedComponent(t, "DocumentManifest", "related", element.getRelated().get(i), i);
        }
    }

    protected void composeDocumentManifestDocumentManifestContentComponent(RdfGenerator.Complex parent, String parentType, String name, DocumentManifest.DocumentManifestContentComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "content", name, element, index);
        if (element.hasP()) {
            this.composeType(t, "DocumentManifest", "p", element.getP(), -1);
        }
    }

    protected void composeDocumentManifestDocumentManifestRelatedComponent(RdfGenerator.Complex parent, String parentType, String name, DocumentManifest.DocumentManifestRelatedComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "related", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "DocumentManifest", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasRef()) {
            this.composeReference(t, "DocumentManifest", "ref", element.getRef(), -1);
        }
    }

    protected void composeDocumentReference(RdfGenerator.Complex parent, String parentType, String name, DocumentReference element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DocumentReference", name, element, index);
        if (element.hasMasterIdentifier()) {
            this.composeIdentifier(t, "DocumentReference", "masterIdentifier", element.getMasterIdentifier(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "DocumentReference", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DocumentReference", "subject", element.getSubject(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DocumentReference", "type", element.getType(), -1);
        }
        if (element.hasClass_()) {
            this.composeCodeableConcept(t, "DocumentReference", "class", element.getClass_(), -1);
        }
        for (i = 0; i < element.getAuthor().size(); ++i) {
            this.composeReference(t, "DocumentReference", "author", element.getAuthor().get(i), i);
        }
        if (element.hasCustodian()) {
            this.composeReference(t, "DocumentReference", "custodian", element.getCustodian(), -1);
        }
        if (element.hasAuthenticator()) {
            this.composeReference(t, "DocumentReference", "authenticator", element.getAuthenticator(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "DocumentReference", "created", element.getCreatedElement(), -1);
        }
        if (element.hasIndexedElement()) {
            this.composeInstant(t, "DocumentReference", "indexed", element.getIndexedElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DocumentReference", "status", element.getStatusElement(), -1);
        }
        if (element.hasDocStatus()) {
            this.composeCodeableConcept(t, "DocumentReference", "docStatus", element.getDocStatus(), -1);
        }
        for (i = 0; i < element.getRelatesTo().size(); ++i) {
            this.composeDocumentReferenceDocumentReferenceRelatesToComponent(t, "DocumentReference", "relatesTo", element.getRelatesTo().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "DocumentReference", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getSecurityLabel().size(); ++i) {
            this.composeCodeableConcept(t, "DocumentReference", "securityLabel", element.getSecurityLabel().get(i), i);
        }
        for (i = 0; i < element.getContent().size(); ++i) {
            this.composeDocumentReferenceDocumentReferenceContentComponent(t, "DocumentReference", "content", element.getContent().get(i), i);
        }
        if (element.hasContext()) {
            this.composeDocumentReferenceDocumentReferenceContextComponent(t, "DocumentReference", "context", element.getContext(), -1);
        }
    }

    protected void composeDocumentReferenceDocumentReferenceRelatesToComponent(RdfGenerator.Complex parent, String parentType, String name, DocumentReference.DocumentReferenceRelatesToComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "relatesTo", name, element, index);
        if (element.hasCodeElement()) {
            this.composeEnum(t, "DocumentReference", "code", element.getCodeElement(), -1);
        }
        if (element.hasTarget()) {
            this.composeReference(t, "DocumentReference", "target", element.getTarget(), -1);
        }
    }

    protected void composeDocumentReferenceDocumentReferenceContentComponent(RdfGenerator.Complex parent, String parentType, String name, DocumentReference.DocumentReferenceContentComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "content", name, element, index);
        if (element.hasAttachment()) {
            this.composeAttachment(t, "DocumentReference", "attachment", element.getAttachment(), -1);
        }
        for (int i = 0; i < element.getFormat().size(); ++i) {
            this.composeCoding(t, "DocumentReference", "format", element.getFormat().get(i), i);
        }
    }

    protected void composeDocumentReferenceDocumentReferenceContextComponent(RdfGenerator.Complex parent, String parentType, String name, DocumentReference.DocumentReferenceContextComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "context", name, element, index);
        if (element.hasEncounter()) {
            this.composeReference(t, "DocumentReference", "encounter", element.getEncounter(), -1);
        }
        for (i = 0; i < element.getEvent().size(); ++i) {
            this.composeCodeableConcept(t, "DocumentReference", "event", element.getEvent().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "DocumentReference", "period", element.getPeriod(), -1);
        }
        if (element.hasFacilityType()) {
            this.composeCodeableConcept(t, "DocumentReference", "facilityType", element.getFacilityType(), -1);
        }
        if (element.hasPracticeSetting()) {
            this.composeCodeableConcept(t, "DocumentReference", "practiceSetting", element.getPracticeSetting(), -1);
        }
        if (element.hasSourcePatientInfo()) {
            this.composeReference(t, "DocumentReference", "sourcePatientInfo", element.getSourcePatientInfo(), -1);
        }
        for (i = 0; i < element.getRelated().size(); ++i) {
            this.composeDocumentReferenceDocumentReferenceContextRelatedComponent(t, "DocumentReference", "related", element.getRelated().get(i), i);
        }
    }

    protected void composeDocumentReferenceDocumentReferenceContextRelatedComponent(RdfGenerator.Complex parent, String parentType, String name, DocumentReference.DocumentReferenceContextRelatedComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "related", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "DocumentReference", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasRef()) {
            this.composeReference(t, "DocumentReference", "ref", element.getRef(), -1);
        }
    }

    protected void composeEligibilityRequest(RdfGenerator.Complex parent, String parentType, String name, EligibilityRequest element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "EligibilityRequest", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "EligibilityRequest", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasRuleset()) {
            this.composeCoding(t, "EligibilityRequest", "ruleset", element.getRuleset(), -1);
        }
        if (element.hasOriginalRuleset()) {
            this.composeCoding(t, "EligibilityRequest", "originalRuleset", element.getOriginalRuleset(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "EligibilityRequest", "created", element.getCreatedElement(), -1);
        }
        if (element.hasTarget()) {
            this.composeType(t, "EligibilityRequest", "target", element.getTarget(), -1);
        }
        if (element.hasProvider()) {
            this.composeType(t, "EligibilityRequest", "provider", element.getProvider(), -1);
        }
        if (element.hasOrganization()) {
            this.composeType(t, "EligibilityRequest", "organization", element.getOrganization(), -1);
        }
        if (element.hasPriority()) {
            this.composeCoding(t, "EligibilityRequest", "priority", element.getPriority(), -1);
        }
        if (element.hasEnterer()) {
            this.composeType(t, "EligibilityRequest", "enterer", element.getEnterer(), -1);
        }
        if (element.hasFacility()) {
            this.composeType(t, "EligibilityRequest", "facility", element.getFacility(), -1);
        }
        if (element.hasPatient()) {
            this.composeType(t, "EligibilityRequest", "patient", element.getPatient(), -1);
        }
        if (element.hasCoverage()) {
            this.composeType(t, "EligibilityRequest", "coverage", element.getCoverage(), -1);
        }
        if (element.hasBusinessArrangementElement()) {
            this.composeString(t, "EligibilityRequest", "businessArrangement", element.getBusinessArrangementElement(), -1);
        }
        if (element.hasServiced()) {
            this.composeType(t, "EligibilityRequest", "serviced", element.getServiced(), -1);
        }
        if (element.hasBenefitCategory()) {
            this.composeCoding(t, "EligibilityRequest", "benefitCategory", element.getBenefitCategory(), -1);
        }
        if (element.hasBenefitSubCategory()) {
            this.composeCoding(t, "EligibilityRequest", "benefitSubCategory", element.getBenefitSubCategory(), -1);
        }
    }

    protected void composeEligibilityResponse(RdfGenerator.Complex parent, String parentType, String name, EligibilityResponse element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "EligibilityResponse", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "EligibilityResponse", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasRequest()) {
            this.composeType(t, "EligibilityResponse", "request", element.getRequest(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "EligibilityResponse", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "EligibilityResponse", "disposition", element.getDispositionElement(), -1);
        }
        if (element.hasRuleset()) {
            this.composeCoding(t, "EligibilityResponse", "ruleset", element.getRuleset(), -1);
        }
        if (element.hasOriginalRuleset()) {
            this.composeCoding(t, "EligibilityResponse", "originalRuleset", element.getOriginalRuleset(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "EligibilityResponse", "created", element.getCreatedElement(), -1);
        }
        if (element.hasOrganization()) {
            this.composeType(t, "EligibilityResponse", "organization", element.getOrganization(), -1);
        }
        if (element.hasRequestProvider()) {
            this.composeType(t, "EligibilityResponse", "requestProvider", element.getRequestProvider(), -1);
        }
        if (element.hasRequestOrganization()) {
            this.composeType(t, "EligibilityResponse", "requestOrganization", element.getRequestOrganization(), -1);
        }
        if (element.hasInforceElement()) {
            this.composeBoolean(t, "EligibilityResponse", "inforce", element.getInforceElement(), -1);
        }
        if (element.hasContract()) {
            this.composeReference(t, "EligibilityResponse", "contract", element.getContract(), -1);
        }
        if (element.hasForm()) {
            this.composeCoding(t, "EligibilityResponse", "form", element.getForm(), -1);
        }
        for (i = 0; i < element.getBenefitBalance().size(); ++i) {
            this.composeEligibilityResponseBenefitsComponent(t, "EligibilityResponse", "benefitBalance", element.getBenefitBalance().get(i), i);
        }
        for (i = 0; i < element.getError().size(); ++i) {
            this.composeEligibilityResponseErrorsComponent(t, "EligibilityResponse", "error", element.getError().get(i), i);
        }
    }

    protected void composeEligibilityResponseBenefitsComponent(RdfGenerator.Complex parent, String parentType, String name, EligibilityResponse.BenefitsComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "benefitBalance", name, element, index);
        if (element.hasCategory()) {
            this.composeCoding(t, "EligibilityResponse", "category", element.getCategory(), -1);
        }
        if (element.hasSubCategory()) {
            this.composeCoding(t, "EligibilityResponse", "subCategory", element.getSubCategory(), -1);
        }
        if (element.hasNetwork()) {
            this.composeCoding(t, "EligibilityResponse", "network", element.getNetwork(), -1);
        }
        if (element.hasUnit()) {
            this.composeCoding(t, "EligibilityResponse", "unit", element.getUnit(), -1);
        }
        if (element.hasTerm()) {
            this.composeCoding(t, "EligibilityResponse", "term", element.getTerm(), -1);
        }
        for (int i = 0; i < element.getFinancial().size(); ++i) {
            this.composeEligibilityResponseBenefitComponent(t, "EligibilityResponse", "financial", element.getFinancial().get(i), i);
        }
    }

    protected void composeEligibilityResponseBenefitComponent(RdfGenerator.Complex parent, String parentType, String name, EligibilityResponse.BenefitComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "financial", name, element, index);
        if (element.hasType()) {
            this.composeCoding(t, "EligibilityResponse", "type", element.getType(), -1);
        }
        if (element.hasBenefit()) {
            this.composeType(t, "EligibilityResponse", "benefit", element.getBenefit(), -1);
        }
        if (element.hasBenefitUsed()) {
            this.composeType(t, "EligibilityResponse", "benefitUsed", element.getBenefitUsed(), -1);
        }
    }

    protected void composeEligibilityResponseErrorsComponent(RdfGenerator.Complex parent, String parentType, String name, EligibilityResponse.ErrorsComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "error", name, element, index);
        if (element.hasCode()) {
            this.composeCoding(t, "EligibilityResponse", "code", element.getCode(), -1);
        }
    }

    protected void composeEncounter(RdfGenerator.Complex parent, String parentType, String name, Encounter element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Encounter", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Encounter", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Encounter", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getStatusHistory().size(); ++i) {
            this.composeEncounterEncounterStatusHistoryComponent(t, "Encounter", "statusHistory", element.getStatusHistory().get(i), i);
        }
        if (element.hasClass_Element()) {
            this.composeEnum(t, "Encounter", "class", element.getClass_Element(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "Encounter", "type", element.getType().get(i), i);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "Encounter", "priority", element.getPriority(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "Encounter", "patient", element.getPatient(), -1);
        }
        for (i = 0; i < element.getEpisodeOfCare().size(); ++i) {
            this.composeReference(t, "Encounter", "episodeOfCare", element.getEpisodeOfCare().get(i), i);
        }
        for (i = 0; i < element.getIncomingReferral().size(); ++i) {
            this.composeReference(t, "Encounter", "incomingReferral", element.getIncomingReferral().get(i), i);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composeEncounterEncounterParticipantComponent(t, "Encounter", "participant", element.getParticipant().get(i), i);
        }
        if (element.hasAppointment()) {
            this.composeReference(t, "Encounter", "appointment", element.getAppointment(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Encounter", "period", element.getPeriod(), -1);
        }
        if (element.hasLength()) {
            this.composeQuantity(t, "Encounter", "length", element.getLength(), -1);
        }
        for (i = 0; i < element.getReason().size(); ++i) {
            this.composeCodeableConcept(t, "Encounter", "reason", element.getReason().get(i), i);
        }
        for (i = 0; i < element.getIndication().size(); ++i) {
            this.composeReference(t, "Encounter", "indication", element.getIndication().get(i), i);
        }
        if (element.hasHospitalization()) {
            this.composeEncounterEncounterHospitalizationComponent(t, "Encounter", "hospitalization", element.getHospitalization(), -1);
        }
        for (i = 0; i < element.getLocation().size(); ++i) {
            this.composeEncounterEncounterLocationComponent(t, "Encounter", "location", element.getLocation().get(i), i);
        }
        if (element.hasServiceProvider()) {
            this.composeReference(t, "Encounter", "serviceProvider", element.getServiceProvider(), -1);
        }
        if (element.hasPartOf()) {
            this.composeReference(t, "Encounter", "partOf", element.getPartOf(), -1);
        }
    }

    protected void composeEncounterEncounterStatusHistoryComponent(RdfGenerator.Complex parent, String parentType, String name, Encounter.EncounterStatusHistoryComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "statusHistory", name, element, index);
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Encounter", "status", element.getStatusElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Encounter", "period", element.getPeriod(), -1);
        }
    }

    protected void composeEncounterEncounterParticipantComponent(RdfGenerator.Complex parent, String parentType, String name, Encounter.EncounterParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        for (int i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "Encounter", "type", element.getType().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Encounter", "period", element.getPeriod(), -1);
        }
        if (element.hasIndividual()) {
            this.composeReference(t, "Encounter", "individual", element.getIndividual(), -1);
        }
    }

    protected void composeEncounterEncounterHospitalizationComponent(RdfGenerator.Complex parent, String parentType, String name, Encounter.EncounterHospitalizationComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "hospitalization", name, element, index);
        if (element.hasPreAdmissionIdentifier()) {
            this.composeIdentifier(t, "Encounter", "preAdmissionIdentifier", element.getPreAdmissionIdentifier(), -1);
        }
        if (element.hasOrigin()) {
            this.composeReference(t, "Encounter", "origin", element.getOrigin(), -1);
        }
        if (element.hasAdmitSource()) {
            this.composeCodeableConcept(t, "Encounter", "admitSource", element.getAdmitSource(), -1);
        }
        for (i = 0; i < element.getAdmittingDiagnosis().size(); ++i) {
            this.composeReference(t, "Encounter", "admittingDiagnosis", element.getAdmittingDiagnosis().get(i), i);
        }
        if (element.hasReAdmission()) {
            this.composeCodeableConcept(t, "Encounter", "reAdmission", element.getReAdmission(), -1);
        }
        for (i = 0; i < element.getDietPreference().size(); ++i) {
            this.composeCodeableConcept(t, "Encounter", "dietPreference", element.getDietPreference().get(i), i);
        }
        for (i = 0; i < element.getSpecialCourtesy().size(); ++i) {
            this.composeCodeableConcept(t, "Encounter", "specialCourtesy", element.getSpecialCourtesy().get(i), i);
        }
        for (i = 0; i < element.getSpecialArrangement().size(); ++i) {
            this.composeCodeableConcept(t, "Encounter", "specialArrangement", element.getSpecialArrangement().get(i), i);
        }
        if (element.hasDestination()) {
            this.composeReference(t, "Encounter", "destination", element.getDestination(), -1);
        }
        if (element.hasDischargeDisposition()) {
            this.composeCodeableConcept(t, "Encounter", "dischargeDisposition", element.getDischargeDisposition(), -1);
        }
        for (i = 0; i < element.getDischargeDiagnosis().size(); ++i) {
            this.composeReference(t, "Encounter", "dischargeDiagnosis", element.getDischargeDiagnosis().get(i), i);
        }
    }

    protected void composeEncounterEncounterLocationComponent(RdfGenerator.Complex parent, String parentType, String name, Encounter.EncounterLocationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "location", name, element, index);
        if (element.hasLocation()) {
            this.composeReference(t, "Encounter", "location", element.getLocation(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Encounter", "status", element.getStatusElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Encounter", "period", element.getPeriod(), -1);
        }
    }

    protected void composeEnrollmentRequest(RdfGenerator.Complex parent, String parentType, String name, EnrollmentRequest element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "EnrollmentRequest", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "EnrollmentRequest", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasRuleset()) {
            this.composeCoding(t, "EnrollmentRequest", "ruleset", element.getRuleset(), -1);
        }
        if (element.hasOriginalRuleset()) {
            this.composeCoding(t, "EnrollmentRequest", "originalRuleset", element.getOriginalRuleset(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "EnrollmentRequest", "created", element.getCreatedElement(), -1);
        }
        if (element.hasTarget()) {
            this.composeReference(t, "EnrollmentRequest", "target", element.getTarget(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "EnrollmentRequest", "provider", element.getProvider(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "EnrollmentRequest", "organization", element.getOrganization(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "EnrollmentRequest", "subject", element.getSubject(), -1);
        }
        if (element.hasCoverage()) {
            this.composeReference(t, "EnrollmentRequest", "coverage", element.getCoverage(), -1);
        }
        if (element.hasRelationship()) {
            this.composeCoding(t, "EnrollmentRequest", "relationship", element.getRelationship(), -1);
        }
    }

    protected void composeEnrollmentResponse(RdfGenerator.Complex parent, String parentType, String name, EnrollmentResponse element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "EnrollmentResponse", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "EnrollmentResponse", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "EnrollmentResponse", "request", element.getRequest(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "EnrollmentResponse", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "EnrollmentResponse", "disposition", element.getDispositionElement(), -1);
        }
        if (element.hasRuleset()) {
            this.composeCoding(t, "EnrollmentResponse", "ruleset", element.getRuleset(), -1);
        }
        if (element.hasOriginalRuleset()) {
            this.composeCoding(t, "EnrollmentResponse", "originalRuleset", element.getOriginalRuleset(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "EnrollmentResponse", "created", element.getCreatedElement(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "EnrollmentResponse", "organization", element.getOrganization(), -1);
        }
        if (element.hasRequestProvider()) {
            this.composeReference(t, "EnrollmentResponse", "requestProvider", element.getRequestProvider(), -1);
        }
        if (element.hasRequestOrganization()) {
            this.composeReference(t, "EnrollmentResponse", "requestOrganization", element.getRequestOrganization(), -1);
        }
    }

    protected void composeEpisodeOfCare(RdfGenerator.Complex parent, String parentType, String name, EpisodeOfCare element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "EpisodeOfCare", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "EpisodeOfCare", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EpisodeOfCare", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getStatusHistory().size(); ++i) {
            this.composeEpisodeOfCareEpisodeOfCareStatusHistoryComponent(t, "EpisodeOfCare", "statusHistory", element.getStatusHistory().get(i), i);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "EpisodeOfCare", "type", element.getType().get(i), i);
        }
        for (i = 0; i < element.getCondition().size(); ++i) {
            this.composeReference(t, "EpisodeOfCare", "condition", element.getCondition().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "EpisodeOfCare", "patient", element.getPatient(), -1);
        }
        if (element.hasManagingOrganization()) {
            this.composeReference(t, "EpisodeOfCare", "managingOrganization", element.getManagingOrganization(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "EpisodeOfCare", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getReferralRequest().size(); ++i) {
            this.composeReference(t, "EpisodeOfCare", "referralRequest", element.getReferralRequest().get(i), i);
        }
        if (element.hasCareManager()) {
            this.composeReference(t, "EpisodeOfCare", "careManager", element.getCareManager(), -1);
        }
        for (i = 0; i < element.getTeam().size(); ++i) {
            this.composeReference(t, "EpisodeOfCare", "team", element.getTeam().get(i), i);
        }
    }

    protected void composeEpisodeOfCareEpisodeOfCareStatusHistoryComponent(RdfGenerator.Complex parent, String parentType, String name, EpisodeOfCare.EpisodeOfCareStatusHistoryComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "statusHistory", name, element, index);
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EpisodeOfCare", "status", element.getStatusElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "EpisodeOfCare", "period", element.getPeriod(), -1);
        }
    }

    protected void composeExpansionProfile(RdfGenerator.Complex parent, String parentType, String name, ExpansionProfile element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ExpansionProfile", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ExpansionProfile", "url", element.getUrlElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "ExpansionProfile", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ExpansionProfile", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ExpansionProfile", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ExpansionProfile", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ExpansionProfile", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ExpansionProfile", "publisher", element.getPublisherElement(), -1);
        }
        for (int i = 0; i < element.getContact().size(); ++i) {
            this.composeExpansionProfileExpansionProfileContactComponent(t, "ExpansionProfile", "contact", element.getContact().get(i), i);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ExpansionProfile", "date", element.getDateElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ExpansionProfile", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasCodeSystem()) {
            this.composeExpansionProfileExpansionProfileCodeSystemComponent(t, "ExpansionProfile", "codeSystem", element.getCodeSystem(), -1);
        }
        if (element.hasIncludeDesignationsElement()) {
            this.composeBoolean(t, "ExpansionProfile", "includeDesignations", element.getIncludeDesignationsElement(), -1);
        }
        if (element.hasDesignation()) {
            this.composeExpansionProfileExpansionProfileDesignationComponent(t, "ExpansionProfile", "designation", element.getDesignation(), -1);
        }
        if (element.hasIncludeDefinitionElement()) {
            this.composeBoolean(t, "ExpansionProfile", "includeDefinition", element.getIncludeDefinitionElement(), -1);
        }
        if (element.hasIncludeInactiveElement()) {
            this.composeBoolean(t, "ExpansionProfile", "includeInactive", element.getIncludeInactiveElement(), -1);
        }
        if (element.hasExcludeNestedElement()) {
            this.composeBoolean(t, "ExpansionProfile", "excludeNested", element.getExcludeNestedElement(), -1);
        }
        if (element.hasExcludeNotForUIElement()) {
            this.composeBoolean(t, "ExpansionProfile", "excludeNotForUI", element.getExcludeNotForUIElement(), -1);
        }
        if (element.hasExcludePostCoordinatedElement()) {
            this.composeBoolean(t, "ExpansionProfile", "excludePostCoordinated", element.getExcludePostCoordinatedElement(), -1);
        }
        if (element.hasDisplayLanguageElement()) {
            this.composeCode(t, "ExpansionProfile", "displayLanguage", element.getDisplayLanguageElement(), -1);
        }
        if (element.hasLimitedExpansionElement()) {
            this.composeBoolean(t, "ExpansionProfile", "limitedExpansion", element.getLimitedExpansionElement(), -1);
        }
    }

    protected void composeExpansionProfileExpansionProfileContactComponent(RdfGenerator.Complex parent, String parentType, String name, ExpansionProfile.ExpansionProfileContactComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ExpansionProfile", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "ExpansionProfile", "telecom", element.getTelecom().get(i), i);
        }
    }

    protected void composeExpansionProfileExpansionProfileCodeSystemComponent(RdfGenerator.Complex parent, String parentType, String name, ExpansionProfile.ExpansionProfileCodeSystemComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "codeSystem", name, element, index);
        if (element.hasInclude()) {
            this.composeExpansionProfileCodeSystemIncludeComponent(t, "ExpansionProfile", "include", element.getInclude(), -1);
        }
        if (element.hasExclude()) {
            this.composeExpansionProfileCodeSystemExcludeComponent(t, "ExpansionProfile", "exclude", element.getExclude(), -1);
        }
    }

    protected void composeExpansionProfileCodeSystemIncludeComponent(RdfGenerator.Complex parent, String parentType, String name, ExpansionProfile.CodeSystemIncludeComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "include", name, element, index);
        for (int i = 0; i < element.getCodeSystem().size(); ++i) {
            this.composeExpansionProfileCodeSystemIncludeCodeSystemComponent(t, "ExpansionProfile", "codeSystem", element.getCodeSystem().get(i), i);
        }
    }

    protected void composeExpansionProfileCodeSystemIncludeCodeSystemComponent(RdfGenerator.Complex parent, String parentType, String name, ExpansionProfile.CodeSystemIncludeCodeSystemComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "codeSystem", name, element, index);
        if (element.hasSystemElement()) {
            this.composeUri(t, "ExpansionProfile", "system", element.getSystemElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ExpansionProfile", "version", element.getVersionElement(), -1);
        }
    }

    protected void composeExpansionProfileCodeSystemExcludeComponent(RdfGenerator.Complex parent, String parentType, String name, ExpansionProfile.CodeSystemExcludeComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "exclude", name, element, index);
        for (int i = 0; i < element.getCodeSystem().size(); ++i) {
            this.composeExpansionProfileCodeSystemExcludeCodeSystemComponent(t, "ExpansionProfile", "codeSystem", element.getCodeSystem().get(i), i);
        }
    }

    protected void composeExpansionProfileCodeSystemExcludeCodeSystemComponent(RdfGenerator.Complex parent, String parentType, String name, ExpansionProfile.CodeSystemExcludeCodeSystemComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "codeSystem", name, element, index);
        if (element.hasSystemElement()) {
            this.composeUri(t, "ExpansionProfile", "system", element.getSystemElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ExpansionProfile", "version", element.getVersionElement(), -1);
        }
    }

    protected void composeExpansionProfileExpansionProfileDesignationComponent(RdfGenerator.Complex parent, String parentType, String name, ExpansionProfile.ExpansionProfileDesignationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "designation", name, element, index);
        if (element.hasInclude()) {
            this.composeExpansionProfileDesignationIncludeComponent(t, "ExpansionProfile", "include", element.getInclude(), -1);
        }
        if (element.hasExclude()) {
            this.composeExpansionProfileDesignationExcludeComponent(t, "ExpansionProfile", "exclude", element.getExclude(), -1);
        }
    }

    protected void composeExpansionProfileDesignationIncludeComponent(RdfGenerator.Complex parent, String parentType, String name, ExpansionProfile.DesignationIncludeComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "include", name, element, index);
        for (int i = 0; i < element.getDesignation().size(); ++i) {
            this.composeExpansionProfileDesignationIncludeDesignationComponent(t, "ExpansionProfile", "designation", element.getDesignation().get(i), i);
        }
    }

    protected void composeExpansionProfileDesignationIncludeDesignationComponent(RdfGenerator.Complex parent, String parentType, String name, ExpansionProfile.DesignationIncludeDesignationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "designation", name, element, index);
        if (element.hasLanguageElement()) {
            this.composeCode(t, "ExpansionProfile", "language", element.getLanguageElement(), -1);
        }
        if (element.hasUse()) {
            this.composeCoding(t, "ExpansionProfile", "use", element.getUse(), -1);
        }
    }

    protected void composeExpansionProfileDesignationExcludeComponent(RdfGenerator.Complex parent, String parentType, String name, ExpansionProfile.DesignationExcludeComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "exclude", name, element, index);
        for (int i = 0; i < element.getDesignation().size(); ++i) {
            this.composeExpansionProfileDesignationExcludeDesignationComponent(t, "ExpansionProfile", "designation", element.getDesignation().get(i), i);
        }
    }

    protected void composeExpansionProfileDesignationExcludeDesignationComponent(RdfGenerator.Complex parent, String parentType, String name, ExpansionProfile.DesignationExcludeDesignationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "designation", name, element, index);
        if (element.hasLanguageElement()) {
            this.composeCode(t, "ExpansionProfile", "language", element.getLanguageElement(), -1);
        }
        if (element.hasUse()) {
            this.composeCoding(t, "ExpansionProfile", "use", element.getUse(), -1);
        }
    }

    protected void composeExplanationOfBenefit(RdfGenerator.Complex parent, String parentType, String name, ExplanationOfBenefit element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ExplanationOfBenefit", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ExplanationOfBenefit", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasClaim()) {
            this.composeType(t, "ExplanationOfBenefit", "claim", element.getClaim(), -1);
        }
        if (element.hasClaimResponse()) {
            this.composeType(t, "ExplanationOfBenefit", "claimResponse", element.getClaimResponse(), -1);
        }
        for (i = 0; i < element.getSubType().size(); ++i) {
            this.composeCoding(t, "ExplanationOfBenefit", "subType", element.getSubType().get(i), i);
        }
        if (element.hasRuleset()) {
            this.composeCoding(t, "ExplanationOfBenefit", "ruleset", element.getRuleset(), -1);
        }
        if (element.hasOriginalRuleset()) {
            this.composeCoding(t, "ExplanationOfBenefit", "originalRuleset", element.getOriginalRuleset(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "ExplanationOfBenefit", "created", element.getCreatedElement(), -1);
        }
        if (element.hasBillablePeriod()) {
            this.composePeriod(t, "ExplanationOfBenefit", "billablePeriod", element.getBillablePeriod(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "ExplanationOfBenefit", "disposition", element.getDispositionElement(), -1);
        }
        if (element.hasProvider()) {
            this.composeType(t, "ExplanationOfBenefit", "provider", element.getProvider(), -1);
        }
        if (element.hasOrganization()) {
            this.composeType(t, "ExplanationOfBenefit", "organization", element.getOrganization(), -1);
        }
        if (element.hasFacility()) {
            this.composeType(t, "ExplanationOfBenefit", "facility", element.getFacility(), -1);
        }
        for (i = 0; i < element.getRelated().size(); ++i) {
            this.composeExplanationOfBenefitRelatedClaimsComponent(t, "ExplanationOfBenefit", "related", element.getRelated().get(i), i);
        }
        if (element.hasPrescription()) {
            this.composeType(t, "ExplanationOfBenefit", "prescription", element.getPrescription(), -1);
        }
        if (element.hasOriginalPrescription()) {
            this.composeType(t, "ExplanationOfBenefit", "originalPrescription", element.getOriginalPrescription(), -1);
        }
        if (element.hasPayee()) {
            this.composeExplanationOfBenefitPayeeComponent(t, "ExplanationOfBenefit", "payee", element.getPayee(), -1);
        }
        if (element.hasReferral()) {
            this.composeType(t, "ExplanationOfBenefit", "referral", element.getReferral(), -1);
        }
        for (i = 0; i < element.getOccurrenceCode().size(); ++i) {
            this.composeCoding(t, "ExplanationOfBenefit", "occurrenceCode", element.getOccurrenceCode().get(i), i);
        }
        for (i = 0; i < element.getOccurenceSpanCode().size(); ++i) {
            this.composeCoding(t, "ExplanationOfBenefit", "occurenceSpanCode", element.getOccurenceSpanCode().get(i), i);
        }
        for (i = 0; i < element.getValueCode().size(); ++i) {
            this.composeCoding(t, "ExplanationOfBenefit", "valueCode", element.getValueCode().get(i), i);
        }
        for (i = 0; i < element.getDiagnosis().size(); ++i) {
            this.composeExplanationOfBenefitDiagnosisComponent(t, "ExplanationOfBenefit", "diagnosis", element.getDiagnosis().get(i), i);
        }
        for (i = 0; i < element.getProcedure().size(); ++i) {
            this.composeExplanationOfBenefitProcedureComponent(t, "ExplanationOfBenefit", "procedure", element.getProcedure().get(i), i);
        }
        for (i = 0; i < element.getSpecialCondition().size(); ++i) {
            this.composeCoding(t, "ExplanationOfBenefit", "specialCondition", element.getSpecialCondition().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeType(t, "ExplanationOfBenefit", "patient", element.getPatient(), -1);
        }
        if (element.hasPrecedenceElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "precedence", element.getPrecedenceElement(), -1);
        }
        if (element.hasCoverage()) {
            this.composeExplanationOfBenefitCoverageComponent(t, "ExplanationOfBenefit", "coverage", element.getCoverage(), -1);
        }
        if (element.hasAccidentDateElement()) {
            this.composeDate(t, "ExplanationOfBenefit", "accidentDate", element.getAccidentDateElement(), -1);
        }
        if (element.hasAccidentType()) {
            this.composeCoding(t, "ExplanationOfBenefit", "accidentType", element.getAccidentType(), -1);
        }
        if (element.hasAccidentLocation()) {
            this.composeType(t, "ExplanationOfBenefit", "accidentLocation", element.getAccidentLocation(), -1);
        }
        for (i = 0; i < element.getInterventionException().size(); ++i) {
            this.composeCoding(t, "ExplanationOfBenefit", "interventionException", element.getInterventionException().get(i), i);
        }
        for (i = 0; i < element.getOnset().size(); ++i) {
            this.composeExplanationOfBenefitOnsetComponent(t, "ExplanationOfBenefit", "onset", element.getOnset().get(i), i);
        }
        if (element.hasEmploymentImpacted()) {
            this.composePeriod(t, "ExplanationOfBenefit", "employmentImpacted", element.getEmploymentImpacted(), -1);
        }
        if (element.hasHospitalization()) {
            this.composePeriod(t, "ExplanationOfBenefit", "hospitalization", element.getHospitalization(), -1);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeExplanationOfBenefitItemsComponent(t, "ExplanationOfBenefit", "item", element.getItem().get(i), i);
        }
        for (i = 0; i < element.getAddItem().size(); ++i) {
            this.composeExplanationOfBenefitAddedItemComponent(t, "ExplanationOfBenefit", "addItem", element.getAddItem().get(i), i);
        }
        for (i = 0; i < element.getMissingTeeth().size(); ++i) {
            this.composeExplanationOfBenefitMissingTeethComponent(t, "ExplanationOfBenefit", "missingTeeth", element.getMissingTeeth().get(i), i);
        }
        if (element.hasTotalCost()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "totalCost", element.getTotalCost(), -1);
        }
        if (element.hasUnallocDeductable()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "unallocDeductable", element.getUnallocDeductable(), -1);
        }
        if (element.hasTotalBenefit()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "totalBenefit", element.getTotalBenefit(), -1);
        }
        if (element.hasPaymentAdjustment()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "paymentAdjustment", element.getPaymentAdjustment(), -1);
        }
        if (element.hasPaymentAdjustmentReason()) {
            this.composeCoding(t, "ExplanationOfBenefit", "paymentAdjustmentReason", element.getPaymentAdjustmentReason(), -1);
        }
        if (element.hasPaymentDateElement()) {
            this.composeDate(t, "ExplanationOfBenefit", "paymentDate", element.getPaymentDateElement(), -1);
        }
        if (element.hasPaymentAmount()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "paymentAmount", element.getPaymentAmount(), -1);
        }
        if (element.hasPaymentRef()) {
            this.composeIdentifier(t, "ExplanationOfBenefit", "paymentRef", element.getPaymentRef(), -1);
        }
        if (element.hasReserved()) {
            this.composeCoding(t, "ExplanationOfBenefit", "reserved", element.getReserved(), -1);
        }
        if (element.hasForm()) {
            this.composeCoding(t, "ExplanationOfBenefit", "form", element.getForm(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeExplanationOfBenefitNotesComponent(t, "ExplanationOfBenefit", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getBenefitBalance().size(); ++i) {
            this.composeExplanationOfBenefitBenefitBalanceComponent(t, "ExplanationOfBenefit", "benefitBalance", element.getBenefitBalance().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitRelatedClaimsComponent(RdfGenerator.Complex parent, String parentType, String name, ExplanationOfBenefit.RelatedClaimsComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "related", name, element, index);
        if (element.hasClaim()) {
            this.composeType(t, "ExplanationOfBenefit", "claim", element.getClaim(), -1);
        }
        if (element.hasRelationship()) {
            this.composeCoding(t, "ExplanationOfBenefit", "relationship", element.getRelationship(), -1);
        }
        if (element.hasReference()) {
            this.composeIdentifier(t, "ExplanationOfBenefit", "reference", element.getReference(), -1);
        }
    }

    protected void composeExplanationOfBenefitPayeeComponent(RdfGenerator.Complex parent, String parentType, String name, ExplanationOfBenefit.PayeeComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "payee", name, element, index);
        if (element.hasType()) {
            this.composeCoding(t, "ExplanationOfBenefit", "type", element.getType(), -1);
        }
        if (element.hasParty()) {
            this.composeType(t, "ExplanationOfBenefit", "party", element.getParty(), -1);
        }
    }

    protected void composeExplanationOfBenefitDiagnosisComponent(RdfGenerator.Complex parent, String parentType, String name, ExplanationOfBenefit.DiagnosisComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "diagnosis", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasDiagnosis()) {
            this.composeCoding(t, "ExplanationOfBenefit", "diagnosis", element.getDiagnosis(), -1);
        }
    }

    protected void composeExplanationOfBenefitProcedureComponent(RdfGenerator.Complex parent, String parentType, String name, ExplanationOfBenefit.ProcedureComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "procedure", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ExplanationOfBenefit", "date", element.getDateElement(), -1);
        }
        if (element.hasProcedure()) {
            this.composeType(t, "ExplanationOfBenefit", "procedure", element.getProcedure(), -1);
        }
    }

    protected void composeExplanationOfBenefitCoverageComponent(RdfGenerator.Complex parent, String parentType, String name, ExplanationOfBenefit.CoverageComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "coverage", name, element, index);
        if (element.hasCoverage()) {
            this.composeType(t, "ExplanationOfBenefit", "coverage", element.getCoverage(), -1);
        }
        for (int i = 0; i < element.getPreAuthRef().size(); ++i) {
            this.composeString(t, "ExplanationOfBenefit", "preAuthRef", element.getPreAuthRef().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitOnsetComponent(RdfGenerator.Complex parent, String parentType, String name, ExplanationOfBenefit.OnsetComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "onset", name, element, index);
        if (element.hasTime()) {
            this.composeType(t, "ExplanationOfBenefit", "time", element.getTime(), -1);
        }
        if (element.hasType()) {
            this.composeCoding(t, "ExplanationOfBenefit", "type", element.getType(), -1);
        }
    }

    protected void composeExplanationOfBenefitItemsComponent(RdfGenerator.Complex parent, String parentType, String name, ExplanationOfBenefit.ItemsComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasType()) {
            this.composeCoding(t, "ExplanationOfBenefit", "type", element.getType(), -1);
        }
        if (element.hasProvider()) {
            this.composeType(t, "ExplanationOfBenefit", "provider", element.getProvider(), -1);
        }
        if (element.hasSupervisor()) {
            this.composeType(t, "ExplanationOfBenefit", "supervisor", element.getSupervisor(), -1);
        }
        if (element.hasProviderQualification()) {
            this.composeCoding(t, "ExplanationOfBenefit", "providerQualification", element.getProviderQualification(), -1);
        }
        for (i = 0; i < element.getDiagnosisLinkId().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "diagnosisLinkId", element.getDiagnosisLinkId().get(i), i);
        }
        if (element.hasService()) {
            this.composeCoding(t, "ExplanationOfBenefit", "service", element.getService(), -1);
        }
        for (i = 0; i < element.getServiceModifier().size(); ++i) {
            this.composeCoding(t, "ExplanationOfBenefit", "serviceModifier", element.getServiceModifier().get(i), i);
        }
        for (i = 0; i < element.getModifier().size(); ++i) {
            this.composeCoding(t, "ExplanationOfBenefit", "modifier", element.getModifier().get(i), i);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCoding(t, "ExplanationOfBenefit", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasServiced()) {
            this.composeType(t, "ExplanationOfBenefit", "serviced", element.getServiced(), -1);
        }
        if (element.hasPlace()) {
            this.composeCoding(t, "ExplanationOfBenefit", "place", element.getPlace(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "ExplanationOfBenefit", "factor", element.getFactorElement(), -1);
        }
        if (element.hasPointsElement()) {
            this.composeDecimal(t, "ExplanationOfBenefit", "points", element.getPointsElement(), -1);
        }
        if (element.hasNet()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "ExplanationOfBenefit", "udi", element.getUdi().get(i), i);
        }
        if (element.hasBodySite()) {
            this.composeCoding(t, "ExplanationOfBenefit", "bodySite", element.getBodySite(), -1);
        }
        for (i = 0; i < element.getSubSite().size(); ++i) {
            this.composeCoding(t, "ExplanationOfBenefit", "subSite", element.getSubSite().get(i), i);
        }
        for (i = 0; i < element.getNoteNumber().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "noteNumber", element.getNoteNumber().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeExplanationOfBenefitItemAdjudicationComponent(t, "ExplanationOfBenefit", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeExplanationOfBenefitDetailComponent(t, "ExplanationOfBenefit", "detail", element.getDetail().get(i), i);
        }
        if (element.hasProsthesis()) {
            this.composeExplanationOfBenefitProsthesisComponent(t, "ExplanationOfBenefit", "prosthesis", element.getProsthesis(), -1);
        }
    }

    protected void composeExplanationOfBenefitItemAdjudicationComponent(RdfGenerator.Complex parent, String parentType, String name, ExplanationOfBenefit.ItemAdjudicationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "adjudication", name, element, index);
        if (element.hasCategory()) {
            this.composeCoding(t, "ExplanationOfBenefit", "category", element.getCategory(), -1);
        }
        if (element.hasReason()) {
            this.composeCoding(t, "ExplanationOfBenefit", "reason", element.getReason(), -1);
        }
        if (element.hasAmount()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "amount", element.getAmount(), -1);
        }
        if (element.hasValueElement()) {
            this.composeDecimal(t, "ExplanationOfBenefit", "value", element.getValueElement(), -1);
        }
    }

    protected void composeExplanationOfBenefitDetailComponent(RdfGenerator.Complex parent, String parentType, String name, ExplanationOfBenefit.DetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasType()) {
            this.composeCoding(t, "ExplanationOfBenefit", "type", element.getType(), -1);
        }
        if (element.hasService()) {
            this.composeCoding(t, "ExplanationOfBenefit", "service", element.getService(), -1);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCoding(t, "ExplanationOfBenefit", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "ExplanationOfBenefit", "factor", element.getFactorElement(), -1);
        }
        if (element.hasPointsElement()) {
            this.composeDecimal(t, "ExplanationOfBenefit", "points", element.getPointsElement(), -1);
        }
        if (element.hasNet()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "ExplanationOfBenefit", "udi", element.getUdi().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeExplanationOfBenefitDetailAdjudicationComponent(t, "ExplanationOfBenefit", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getSubDetail().size(); ++i) {
            this.composeExplanationOfBenefitSubDetailComponent(t, "ExplanationOfBenefit", "subDetail", element.getSubDetail().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitDetailAdjudicationComponent(RdfGenerator.Complex parent, String parentType, String name, ExplanationOfBenefit.DetailAdjudicationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "adjudication", name, element, index);
        if (element.hasCategory()) {
            this.composeCoding(t, "ExplanationOfBenefit", "category", element.getCategory(), -1);
        }
        if (element.hasReason()) {
            this.composeCoding(t, "ExplanationOfBenefit", "reason", element.getReason(), -1);
        }
        if (element.hasAmount()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "amount", element.getAmount(), -1);
        }
        if (element.hasValueElement()) {
            this.composeDecimal(t, "ExplanationOfBenefit", "value", element.getValueElement(), -1);
        }
    }

    protected void composeExplanationOfBenefitSubDetailComponent(RdfGenerator.Complex parent, String parentType, String name, ExplanationOfBenefit.SubDetailComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "subDetail", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasType()) {
            this.composeCoding(t, "ExplanationOfBenefit", "type", element.getType(), -1);
        }
        if (element.hasService()) {
            this.composeCoding(t, "ExplanationOfBenefit", "service", element.getService(), -1);
        }
        for (i = 0; i < element.getProgramCode().size(); ++i) {
            this.composeCoding(t, "ExplanationOfBenefit", "programCode", element.getProgramCode().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "ExplanationOfBenefit", "factor", element.getFactorElement(), -1);
        }
        if (element.hasPointsElement()) {
            this.composeDecimal(t, "ExplanationOfBenefit", "points", element.getPointsElement(), -1);
        }
        if (element.hasNet()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "net", element.getNet(), -1);
        }
        for (i = 0; i < element.getUdi().size(); ++i) {
            this.composeReference(t, "ExplanationOfBenefit", "udi", element.getUdi().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeExplanationOfBenefitSubDetailAdjudicationComponent(t, "ExplanationOfBenefit", "adjudication", element.getAdjudication().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitSubDetailAdjudicationComponent(RdfGenerator.Complex parent, String parentType, String name, ExplanationOfBenefit.SubDetailAdjudicationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "adjudication", name, element, index);
        if (element.hasCategory()) {
            this.composeCoding(t, "ExplanationOfBenefit", "category", element.getCategory(), -1);
        }
        if (element.hasReason()) {
            this.composeCoding(t, "ExplanationOfBenefit", "reason", element.getReason(), -1);
        }
        if (element.hasAmount()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "amount", element.getAmount(), -1);
        }
        if (element.hasValueElement()) {
            this.composeDecimal(t, "ExplanationOfBenefit", "value", element.getValueElement(), -1);
        }
    }

    protected void composeExplanationOfBenefitProsthesisComponent(RdfGenerator.Complex parent, String parentType, String name, ExplanationOfBenefit.ProsthesisComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "prosthesis", name, element, index);
        if (element.hasInitialElement()) {
            this.composeBoolean(t, "ExplanationOfBenefit", "initial", element.getInitialElement(), -1);
        }
        if (element.hasPriorDateElement()) {
            this.composeDate(t, "ExplanationOfBenefit", "priorDate", element.getPriorDateElement(), -1);
        }
        if (element.hasPriorMaterial()) {
            this.composeCoding(t, "ExplanationOfBenefit", "priorMaterial", element.getPriorMaterial(), -1);
        }
    }

    protected void composeExplanationOfBenefitAddedItemComponent(RdfGenerator.Complex parent, String parentType, String name, ExplanationOfBenefit.AddedItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "addItem", name, element, index);
        for (i = 0; i < element.getSequenceLinkId().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "sequenceLinkId", element.getSequenceLinkId().get(i), i);
        }
        if (element.hasService()) {
            this.composeCoding(t, "ExplanationOfBenefit", "service", element.getService(), -1);
        }
        if (element.hasFee()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "fee", element.getFee(), -1);
        }
        for (i = 0; i < element.getNoteNumberLinkId().size(); ++i) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "noteNumberLinkId", element.getNoteNumberLinkId().get(i), i);
        }
        for (i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeExplanationOfBenefitAddedItemAdjudicationComponent(t, "ExplanationOfBenefit", "adjudication", element.getAdjudication().get(i), i);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeExplanationOfBenefitAddedItemsDetailComponent(t, "ExplanationOfBenefit", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitAddedItemAdjudicationComponent(RdfGenerator.Complex parent, String parentType, String name, ExplanationOfBenefit.AddedItemAdjudicationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "adjudication", name, element, index);
        if (element.hasCategory()) {
            this.composeCoding(t, "ExplanationOfBenefit", "category", element.getCategory(), -1);
        }
        if (element.hasReason()) {
            this.composeCoding(t, "ExplanationOfBenefit", "reason", element.getReason(), -1);
        }
        if (element.hasAmount()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "amount", element.getAmount(), -1);
        }
        if (element.hasValueElement()) {
            this.composeDecimal(t, "ExplanationOfBenefit", "value", element.getValueElement(), -1);
        }
    }

    protected void composeExplanationOfBenefitAddedItemsDetailComponent(RdfGenerator.Complex parent, String parentType, String name, ExplanationOfBenefit.AddedItemsDetailComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasService()) {
            this.composeCoding(t, "ExplanationOfBenefit", "service", element.getService(), -1);
        }
        if (element.hasFee()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "fee", element.getFee(), -1);
        }
        for (int i = 0; i < element.getAdjudication().size(); ++i) {
            this.composeExplanationOfBenefitAddedItemDetailAdjudicationComponent(t, "ExplanationOfBenefit", "adjudication", element.getAdjudication().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitAddedItemDetailAdjudicationComponent(RdfGenerator.Complex parent, String parentType, String name, ExplanationOfBenefit.AddedItemDetailAdjudicationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "adjudication", name, element, index);
        if (element.hasCategory()) {
            this.composeCoding(t, "ExplanationOfBenefit", "category", element.getCategory(), -1);
        }
        if (element.hasReason()) {
            this.composeCoding(t, "ExplanationOfBenefit", "reason", element.getReason(), -1);
        }
        if (element.hasAmount()) {
            this.composeQuantity(t, "ExplanationOfBenefit", "amount", element.getAmount(), -1);
        }
        if (element.hasValueElement()) {
            this.composeDecimal(t, "ExplanationOfBenefit", "value", element.getValueElement(), -1);
        }
    }

    protected void composeExplanationOfBenefitMissingTeethComponent(RdfGenerator.Complex parent, String parentType, String name, ExplanationOfBenefit.MissingTeethComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "missingTeeth", name, element, index);
        if (element.hasTooth()) {
            this.composeCoding(t, "ExplanationOfBenefit", "tooth", element.getTooth(), -1);
        }
        if (element.hasReason()) {
            this.composeCoding(t, "ExplanationOfBenefit", "reason", element.getReason(), -1);
        }
        if (element.hasExtractionDateElement()) {
            this.composeDate(t, "ExplanationOfBenefit", "extractionDate", element.getExtractionDateElement(), -1);
        }
    }

    protected void composeExplanationOfBenefitNotesComponent(RdfGenerator.Complex parent, String parentType, String name, ExplanationOfBenefit.NotesComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "note", name, element, index);
        if (element.hasNumberElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "number", element.getNumberElement(), -1);
        }
        if (element.hasType()) {
            this.composeCoding(t, "ExplanationOfBenefit", "type", element.getType(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "ExplanationOfBenefit", "text", element.getTextElement(), -1);
        }
    }

    protected void composeExplanationOfBenefitBenefitBalanceComponent(RdfGenerator.Complex parent, String parentType, String name, ExplanationOfBenefit.BenefitBalanceComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "benefitBalance", name, element, index);
        if (element.hasCategory()) {
            this.composeCoding(t, "ExplanationOfBenefit", "category", element.getCategory(), -1);
        }
        if (element.hasSubCategory()) {
            this.composeCoding(t, "ExplanationOfBenefit", "subCategory", element.getSubCategory(), -1);
        }
        if (element.hasNetwork()) {
            this.composeCoding(t, "ExplanationOfBenefit", "network", element.getNetwork(), -1);
        }
        if (element.hasUnit()) {
            this.composeCoding(t, "ExplanationOfBenefit", "unit", element.getUnit(), -1);
        }
        if (element.hasTerm()) {
            this.composeCoding(t, "ExplanationOfBenefit", "term", element.getTerm(), -1);
        }
        for (int i = 0; i < element.getFinancial().size(); ++i) {
            this.composeExplanationOfBenefitBenefitComponent(t, "ExplanationOfBenefit", "financial", element.getFinancial().get(i), i);
        }
    }

    protected void composeExplanationOfBenefitBenefitComponent(RdfGenerator.Complex parent, String parentType, String name, ExplanationOfBenefit.BenefitComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "financial", name, element, index);
        if (element.hasType()) {
            this.composeCoding(t, "ExplanationOfBenefit", "type", element.getType(), -1);
        }
        if (element.hasBenefit()) {
            this.composeType(t, "ExplanationOfBenefit", "benefit", element.getBenefit(), -1);
        }
        if (element.hasBenefitUsed()) {
            this.composeType(t, "ExplanationOfBenefit", "benefitUsed", element.getBenefitUsed(), -1);
        }
    }

    protected void composeFamilyMemberHistory(RdfGenerator.Complex parent, String parentType, String name, FamilyMemberHistory element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "FamilyMemberHistory", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "FamilyMemberHistory", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "FamilyMemberHistory", "patient", element.getPatient(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "FamilyMemberHistory", "date", element.getDateElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "FamilyMemberHistory", "status", element.getStatusElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "FamilyMemberHistory", "name", element.getNameElement(), -1);
        }
        if (element.hasRelationship()) {
            this.composeCodeableConcept(t, "FamilyMemberHistory", "relationship", element.getRelationship(), -1);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "FamilyMemberHistory", "gender", element.getGenderElement(), -1);
        }
        if (element.hasBorn()) {
            this.composeType(t, "FamilyMemberHistory", "born", element.getBorn(), -1);
        }
        if (element.hasAge()) {
            this.composeType(t, "FamilyMemberHistory", "age", element.getAge(), -1);
        }
        if (element.hasDeceased()) {
            this.composeType(t, "FamilyMemberHistory", "deceased", element.getDeceased(), -1);
        }
        if (element.hasNote()) {
            this.composeAnnotation(t, "FamilyMemberHistory", "note", element.getNote(), -1);
        }
        for (i = 0; i < element.getCondition().size(); ++i) {
            this.composeFamilyMemberHistoryFamilyMemberHistoryConditionComponent(t, "FamilyMemberHistory", "condition", element.getCondition().get(i), i);
        }
    }

    protected void composeFamilyMemberHistoryFamilyMemberHistoryConditionComponent(RdfGenerator.Complex parent, String parentType, String name, FamilyMemberHistory.FamilyMemberHistoryConditionComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "condition", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "FamilyMemberHistory", "code", element.getCode(), -1);
        }
        if (element.hasOutcome()) {
            this.composeCodeableConcept(t, "FamilyMemberHistory", "outcome", element.getOutcome(), -1);
        }
        if (element.hasOnset()) {
            this.composeType(t, "FamilyMemberHistory", "onset", element.getOnset(), -1);
        }
        if (element.hasNote()) {
            this.composeAnnotation(t, "FamilyMemberHistory", "note", element.getNote(), -1);
        }
    }

    protected void composeFlag(RdfGenerator.Complex parent, String parentType, String name, Flag element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Flag", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Flag", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "Flag", "category", element.getCategory(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Flag", "status", element.getStatusElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Flag", "period", element.getPeriod(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Flag", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Flag", "encounter", element.getEncounter(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "Flag", "author", element.getAuthor(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Flag", "code", element.getCode(), -1);
        }
    }

    protected void composeGoal(RdfGenerator.Complex parent, String parentType, String name, Goal element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Goal", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Goal", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Goal", "subject", element.getSubject(), -1);
        }
        if (element.hasStart()) {
            this.composeType(t, "Goal", "start", element.getStart(), -1);
        }
        if (element.hasTarget()) {
            this.composeType(t, "Goal", "target", element.getTarget(), -1);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Goal", "category", element.getCategory().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Goal", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Goal", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusDateElement()) {
            this.composeDate(t, "Goal", "statusDate", element.getStatusDateElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "Goal", "statusReason", element.getStatusReason(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "Goal", "author", element.getAuthor(), -1);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "Goal", "priority", element.getPriority(), -1);
        }
        for (i = 0; i < element.getAddresses().size(); ++i) {
            this.composeReference(t, "Goal", "addresses", element.getAddresses().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Goal", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getOutcome().size(); ++i) {
            this.composeGoalGoalOutcomeComponent(t, "Goal", "outcome", element.getOutcome().get(i), i);
        }
    }

    protected void composeGoalGoalOutcomeComponent(RdfGenerator.Complex parent, String parentType, String name, Goal.GoalOutcomeComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "outcome", name, element, index);
        if (element.hasResult()) {
            this.composeType(t, "Goal", "result", element.getResult(), -1);
        }
    }

    protected void composeGroup(RdfGenerator.Complex parent, String parentType, String name, Group element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Group", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Group", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Group", "type", element.getTypeElement(), -1);
        }
        if (element.hasActualElement()) {
            this.composeBoolean(t, "Group", "actual", element.getActualElement(), -1);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Group", "active", element.getActiveElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Group", "code", element.getCode(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Group", "name", element.getNameElement(), -1);
        }
        if (element.hasQuantityElement()) {
            this.composeUnsignedInt(t, "Group", "quantity", element.getQuantityElement(), -1);
        }
        for (i = 0; i < element.getCharacteristic().size(); ++i) {
            this.composeGroupGroupCharacteristicComponent(t, "Group", "characteristic", element.getCharacteristic().get(i), i);
        }
        for (i = 0; i < element.getMember().size(); ++i) {
            this.composeGroupGroupMemberComponent(t, "Group", "member", element.getMember().get(i), i);
        }
    }

    protected void composeGroupGroupCharacteristicComponent(RdfGenerator.Complex parent, String parentType, String name, Group.GroupCharacteristicComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "characteristic", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Group", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "Group", "value", element.getValue(), -1);
        }
        if (element.hasExcludeElement()) {
            this.composeBoolean(t, "Group", "exclude", element.getExcludeElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Group", "period", element.getPeriod(), -1);
        }
    }

    protected void composeGroupGroupMemberComponent(RdfGenerator.Complex parent, String parentType, String name, Group.GroupMemberComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "member", name, element, index);
        if (element.hasEntity()) {
            this.composeReference(t, "Group", "entity", element.getEntity(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Group", "period", element.getPeriod(), -1);
        }
        if (element.hasInactiveElement()) {
            this.composeBoolean(t, "Group", "inactive", element.getInactiveElement(), -1);
        }
    }

    protected void composeGuidanceResponse(RdfGenerator.Complex parent, String parentType, String name, GuidanceResponse element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "GuidanceResponse", name, element, index);
        if (element.hasRequestIdElement()) {
            this.composeString(t, "GuidanceResponse", "requestId", element.getRequestIdElement(), -1);
        }
        if (element.hasModule()) {
            this.composeReference(t, "GuidanceResponse", "module", element.getModule(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "GuidanceResponse", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getEvaluationMessage().size(); ++i) {
            this.composeReference(t, "GuidanceResponse", "evaluationMessage", element.getEvaluationMessage().get(i), i);
        }
        if (element.hasOutputParameters()) {
            this.composeReference(t, "GuidanceResponse", "outputParameters", element.getOutputParameters(), -1);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composeGuidanceResponseGuidanceResponseActionComponent(t, "GuidanceResponse", "action", element.getAction().get(i), i);
        }
        for (i = 0; i < element.getDataRequirement().size(); ++i) {
            this.composeDataRequirement(t, "GuidanceResponse", "dataRequirement", element.getDataRequirement().get(i), i);
        }
    }

    protected void composeGuidanceResponseGuidanceResponseActionComponent(RdfGenerator.Complex parent, String parentType, String name, GuidanceResponse.GuidanceResponseActionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "action", name, element, index);
        if (element.hasActionIdentifier()) {
            this.composeIdentifier(t, "GuidanceResponse", "actionIdentifier", element.getActionIdentifier(), -1);
        }
        if (element.hasLabelElement()) {
            this.composeString(t, "GuidanceResponse", "label", element.getLabelElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "GuidanceResponse", "title", element.getTitleElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "GuidanceResponse", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasTextEquivalentElement()) {
            this.composeString(t, "GuidanceResponse", "textEquivalent", element.getTextEquivalentElement(), -1);
        }
        for (i = 0; i < element.getConcept().size(); ++i) {
            this.composeCodeableConcept(t, "GuidanceResponse", "concept", element.getConcept().get(i), i);
        }
        for (i = 0; i < element.getSupportingEvidence().size(); ++i) {
            this.composeAttachment(t, "GuidanceResponse", "supportingEvidence", element.getSupportingEvidence().get(i), i);
        }
        if (element.hasRelatedAction()) {
            this.composeGuidanceResponseGuidanceResponseActionRelatedActionComponent(t, "GuidanceResponse", "relatedAction", element.getRelatedAction(), -1);
        }
        for (i = 0; i < element.getDocumentation().size(); ++i) {
            this.composeAttachment(t, "GuidanceResponse", "documentation", element.getDocumentation().get(i), i);
        }
        for (i = 0; i < element.getParticipant().size(); ++i) {
            this.composeReference(t, "GuidanceResponse", "participant", element.getParticipant().get(i), i);
        }
        if (element.hasTypeElement()) {
            this.composeCode(t, "GuidanceResponse", "type", element.getTypeElement(), -1);
        }
        for (i = 0; i < element.getBehavior().size(); ++i) {
            this.composeGuidanceResponseGuidanceResponseActionBehaviorComponent(t, "GuidanceResponse", "behavior", element.getBehavior().get(i), i);
        }
        if (element.hasResource()) {
            this.composeReference(t, "GuidanceResponse", "resource", element.getResource(), -1);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composeGuidanceResponseGuidanceResponseActionComponent(t, "GuidanceResponse", "action", element.getAction().get(i), i);
        }
    }

    protected void composeGuidanceResponseGuidanceResponseActionRelatedActionComponent(RdfGenerator.Complex parent, String parentType, String name, GuidanceResponse.GuidanceResponseActionRelatedActionComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "relatedAction", name, element, index);
        if (element.hasActionIdentifier()) {
            this.composeIdentifier(t, "GuidanceResponse", "actionIdentifier", element.getActionIdentifier(), -1);
        }
        if (element.hasRelationshipElement()) {
            this.composeCode(t, "GuidanceResponse", "relationship", element.getRelationshipElement(), -1);
        }
        if (element.hasOffset()) {
            this.composeType(t, "GuidanceResponse", "offset", element.getOffset(), -1);
        }
        if (element.hasAnchorElement()) {
            this.composeCode(t, "GuidanceResponse", "anchor", element.getAnchorElement(), -1);
        }
    }

    protected void composeGuidanceResponseGuidanceResponseActionBehaviorComponent(RdfGenerator.Complex parent, String parentType, String name, GuidanceResponse.GuidanceResponseActionBehaviorComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "behavior", name, element, index);
        if (element.hasType()) {
            this.composeCoding(t, "GuidanceResponse", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeCoding(t, "GuidanceResponse", "value", element.getValue(), -1);
        }
    }

    protected void composeHealthcareService(RdfGenerator.Complex parent, String parentType, String name, HealthcareService element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "HealthcareService", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "HealthcareService", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasProvidedBy()) {
            this.composeReference(t, "HealthcareService", "providedBy", element.getProvidedBy(), -1);
        }
        if (element.hasServiceCategory()) {
            this.composeCodeableConcept(t, "HealthcareService", "serviceCategory", element.getServiceCategory(), -1);
        }
        for (i = 0; i < element.getServiceType().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "serviceType", element.getServiceType().get(i), i);
        }
        for (i = 0; i < element.getSpecialty().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "specialty", element.getSpecialty().get(i), i);
        }
        for (i = 0; i < element.getLocation().size(); ++i) {
            this.composeReference(t, "HealthcareService", "location", element.getLocation().get(i), i);
        }
        if (element.hasServiceNameElement()) {
            this.composeString(t, "HealthcareService", "serviceName", element.getServiceNameElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "HealthcareService", "comment", element.getCommentElement(), -1);
        }
        if (element.hasExtraDetailsElement()) {
            this.composeString(t, "HealthcareService", "extraDetails", element.getExtraDetailsElement(), -1);
        }
        if (element.hasPhoto()) {
            this.composeAttachment(t, "HealthcareService", "photo", element.getPhoto(), -1);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "HealthcareService", "telecom", element.getTelecom().get(i), i);
        }
        for (i = 0; i < element.getCoverageArea().size(); ++i) {
            this.composeReference(t, "HealthcareService", "coverageArea", element.getCoverageArea().get(i), i);
        }
        for (i = 0; i < element.getServiceProvisionCode().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "serviceProvisionCode", element.getServiceProvisionCode().get(i), i);
        }
        if (element.hasEligibility()) {
            this.composeCodeableConcept(t, "HealthcareService", "eligibility", element.getEligibility(), -1);
        }
        if (element.hasEligibilityNoteElement()) {
            this.composeString(t, "HealthcareService", "eligibilityNote", element.getEligibilityNoteElement(), -1);
        }
        for (i = 0; i < element.getProgramName().size(); ++i) {
            this.composeString(t, "HealthcareService", "programName", element.getProgramName().get(i), i);
        }
        for (i = 0; i < element.getCharacteristic().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "characteristic", element.getCharacteristic().get(i), i);
        }
        for (i = 0; i < element.getReferralMethod().size(); ++i) {
            this.composeCodeableConcept(t, "HealthcareService", "referralMethod", element.getReferralMethod().get(i), i);
        }
        if (element.hasPublicKeyElement()) {
            this.composeString(t, "HealthcareService", "publicKey", element.getPublicKeyElement(), -1);
        }
        if (element.hasAppointmentRequiredElement()) {
            this.composeBoolean(t, "HealthcareService", "appointmentRequired", element.getAppointmentRequiredElement(), -1);
        }
        for (i = 0; i < element.getAvailableTime().size(); ++i) {
            this.composeHealthcareServiceHealthcareServiceAvailableTimeComponent(t, "HealthcareService", "availableTime", element.getAvailableTime().get(i), i);
        }
        for (i = 0; i < element.getNotAvailable().size(); ++i) {
            this.composeHealthcareServiceHealthcareServiceNotAvailableComponent(t, "HealthcareService", "notAvailable", element.getNotAvailable().get(i), i);
        }
        if (element.hasAvailabilityExceptionsElement()) {
            this.composeString(t, "HealthcareService", "availabilityExceptions", element.getAvailabilityExceptionsElement(), -1);
        }
    }

    protected void composeHealthcareServiceHealthcareServiceAvailableTimeComponent(RdfGenerator.Complex parent, String parentType, String name, HealthcareService.HealthcareServiceAvailableTimeComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "availableTime", name, element, index);
        for (int i = 0; i < element.getDaysOfWeek().size(); ++i) {
            this.composeEnum(t, "HealthcareService", "daysOfWeek", element.getDaysOfWeek().get(i), i);
        }
        if (element.hasAllDayElement()) {
            this.composeBoolean(t, "HealthcareService", "allDay", element.getAllDayElement(), -1);
        }
        if (element.hasAvailableStartTimeElement()) {
            this.composeTime(t, "HealthcareService", "availableStartTime", element.getAvailableStartTimeElement(), -1);
        }
        if (element.hasAvailableEndTimeElement()) {
            this.composeTime(t, "HealthcareService", "availableEndTime", element.getAvailableEndTimeElement(), -1);
        }
    }

    protected void composeHealthcareServiceHealthcareServiceNotAvailableComponent(RdfGenerator.Complex parent, String parentType, String name, HealthcareService.HealthcareServiceNotAvailableComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "notAvailable", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "HealthcareService", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasDuring()) {
            this.composePeriod(t, "HealthcareService", "during", element.getDuring(), -1);
        }
    }

    protected void composeImagingExcerpt(RdfGenerator.Complex parent, String parentType, String name, ImagingExcerpt element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ImagingExcerpt", name, element, index);
        if (element.hasUidElement()) {
            this.composeOid(t, "ImagingExcerpt", "uid", element.getUidElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "ImagingExcerpt", "patient", element.getPatient(), -1);
        }
        if (element.hasAuthoringTimeElement()) {
            this.composeDateTime(t, "ImagingExcerpt", "authoringTime", element.getAuthoringTimeElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "ImagingExcerpt", "author", element.getAuthor(), -1);
        }
        if (element.hasTitle()) {
            this.composeCodeableConcept(t, "ImagingExcerpt", "title", element.getTitle(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImagingExcerpt", "description", element.getDescriptionElement(), -1);
        }
        for (int i = 0; i < element.getStudy().size(); ++i) {
            this.composeImagingExcerptStudyComponent(t, "ImagingExcerpt", "study", element.getStudy().get(i), i);
        }
    }

    protected void composeImagingExcerptStudyComponent(RdfGenerator.Complex parent, String parentType, String name, ImagingExcerpt.StudyComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "study", name, element, index);
        if (element.hasUidElement()) {
            this.composeOid(t, "ImagingExcerpt", "uid", element.getUidElement(), -1);
        }
        if (element.hasImagingStudy()) {
            this.composeReference(t, "ImagingExcerpt", "imagingStudy", element.getImagingStudy(), -1);
        }
        for (i = 0; i < element.getDicom().size(); ++i) {
            this.composeImagingExcerptStudyDicomComponent(t, "ImagingExcerpt", "dicom", element.getDicom().get(i), i);
        }
        for (i = 0; i < element.getViewable().size(); ++i) {
            this.composeImagingExcerptStudyViewableComponent(t, "ImagingExcerpt", "viewable", element.getViewable().get(i), i);
        }
        for (i = 0; i < element.getSeries().size(); ++i) {
            this.composeImagingExcerptSeriesComponent(t, "ImagingExcerpt", "series", element.getSeries().get(i), i);
        }
    }

    protected void composeImagingExcerptStudyDicomComponent(RdfGenerator.Complex parent, String parentType, String name, ImagingExcerpt.StudyDicomComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dicom", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ImagingExcerpt", "type", element.getTypeElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "ImagingExcerpt", "url", element.getUrlElement(), -1);
        }
    }

    protected void composeImagingExcerptStudyViewableComponent(RdfGenerator.Complex parent, String parentType, String name, ImagingExcerpt.StudyViewableComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "viewable", name, element, index);
        if (element.hasContentTypeElement()) {
            this.composeCode(t, "ImagingExcerpt", "contentType", element.getContentTypeElement(), -1);
        }
        if (element.hasHeightElement()) {
            this.composePositiveInt(t, "ImagingExcerpt", "height", element.getHeightElement(), -1);
        }
        if (element.hasWidthElement()) {
            this.composePositiveInt(t, "ImagingExcerpt", "width", element.getWidthElement(), -1);
        }
        if (element.hasFramesElement()) {
            this.composePositiveInt(t, "ImagingExcerpt", "frames", element.getFramesElement(), -1);
        }
        if (element.hasDurationElement()) {
            this.composeUnsignedInt(t, "ImagingExcerpt", "duration", element.getDurationElement(), -1);
        }
        if (element.hasSizeElement()) {
            this.composeUnsignedInt(t, "ImagingExcerpt", "size", element.getSizeElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ImagingExcerpt", "title", element.getTitleElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "ImagingExcerpt", "url", element.getUrlElement(), -1);
        }
    }

    protected void composeImagingExcerptSeriesComponent(RdfGenerator.Complex parent, String parentType, String name, ImagingExcerpt.SeriesComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "series", name, element, index);
        if (element.hasUidElement()) {
            this.composeOid(t, "ImagingExcerpt", "uid", element.getUidElement(), -1);
        }
        for (i = 0; i < element.getDicom().size(); ++i) {
            this.composeImagingExcerptSeriesDicomComponent(t, "ImagingExcerpt", "dicom", element.getDicom().get(i), i);
        }
        for (i = 0; i < element.getInstance().size(); ++i) {
            this.composeImagingExcerptInstanceComponent(t, "ImagingExcerpt", "instance", element.getInstance().get(i), i);
        }
    }

    protected void composeImagingExcerptSeriesDicomComponent(RdfGenerator.Complex parent, String parentType, String name, ImagingExcerpt.SeriesDicomComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dicom", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ImagingExcerpt", "type", element.getTypeElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "ImagingExcerpt", "url", element.getUrlElement(), -1);
        }
    }

    protected void composeImagingExcerptInstanceComponent(RdfGenerator.Complex parent, String parentType, String name, ImagingExcerpt.InstanceComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "instance", name, element, index);
        if (element.hasSopClassElement()) {
            this.composeOid(t, "ImagingExcerpt", "sopClass", element.getSopClassElement(), -1);
        }
        if (element.hasUidElement()) {
            this.composeOid(t, "ImagingExcerpt", "uid", element.getUidElement(), -1);
        }
        for (i = 0; i < element.getDicom().size(); ++i) {
            this.composeImagingExcerptInstanceDicomComponent(t, "ImagingExcerpt", "dicom", element.getDicom().get(i), i);
        }
        for (i = 0; i < element.getFrameNumbers().size(); ++i) {
            this.composeUnsignedInt(t, "ImagingExcerpt", "frameNumbers", element.getFrameNumbers().get(i), i);
        }
    }

    protected void composeImagingExcerptInstanceDicomComponent(RdfGenerator.Complex parent, String parentType, String name, ImagingExcerpt.InstanceDicomComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dicom", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ImagingExcerpt", "type", element.getTypeElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "ImagingExcerpt", "url", element.getUrlElement(), -1);
        }
    }

    protected void composeImagingObjectSelection(RdfGenerator.Complex parent, String parentType, String name, ImagingObjectSelection element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ImagingObjectSelection", name, element, index);
        if (element.hasUidElement()) {
            this.composeOid(t, "ImagingObjectSelection", "uid", element.getUidElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "ImagingObjectSelection", "patient", element.getPatient(), -1);
        }
        if (element.hasAuthoringTimeElement()) {
            this.composeDateTime(t, "ImagingObjectSelection", "authoringTime", element.getAuthoringTimeElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "ImagingObjectSelection", "author", element.getAuthor(), -1);
        }
        if (element.hasTitle()) {
            this.composeCodeableConcept(t, "ImagingObjectSelection", "title", element.getTitle(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImagingObjectSelection", "description", element.getDescriptionElement(), -1);
        }
        for (int i = 0; i < element.getStudy().size(); ++i) {
            this.composeImagingObjectSelectionStudyComponent(t, "ImagingObjectSelection", "study", element.getStudy().get(i), i);
        }
    }

    protected void composeImagingObjectSelectionStudyComponent(RdfGenerator.Complex parent, String parentType, String name, ImagingObjectSelection.StudyComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "study", name, element, index);
        if (element.hasUidElement()) {
            this.composeOid(t, "ImagingObjectSelection", "uid", element.getUidElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "ImagingObjectSelection", "url", element.getUrlElement(), -1);
        }
        if (element.hasImagingStudy()) {
            this.composeReference(t, "ImagingObjectSelection", "imagingStudy", element.getImagingStudy(), -1);
        }
        for (int i = 0; i < element.getSeries().size(); ++i) {
            this.composeImagingObjectSelectionSeriesComponent(t, "ImagingObjectSelection", "series", element.getSeries().get(i), i);
        }
    }

    protected void composeImagingObjectSelectionSeriesComponent(RdfGenerator.Complex parent, String parentType, String name, ImagingObjectSelection.SeriesComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "series", name, element, index);
        if (element.hasUidElement()) {
            this.composeOid(t, "ImagingObjectSelection", "uid", element.getUidElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "ImagingObjectSelection", "url", element.getUrlElement(), -1);
        }
        for (int i = 0; i < element.getInstance().size(); ++i) {
            this.composeImagingObjectSelectionInstanceComponent(t, "ImagingObjectSelection", "instance", element.getInstance().get(i), i);
        }
    }

    protected void composeImagingObjectSelectionInstanceComponent(RdfGenerator.Complex parent, String parentType, String name, ImagingObjectSelection.InstanceComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "instance", name, element, index);
        if (element.hasSopClassElement()) {
            this.composeOid(t, "ImagingObjectSelection", "sopClass", element.getSopClassElement(), -1);
        }
        if (element.hasUidElement()) {
            this.composeOid(t, "ImagingObjectSelection", "uid", element.getUidElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "ImagingObjectSelection", "url", element.getUrlElement(), -1);
        }
        for (int i = 0; i < element.getFrame().size(); ++i) {
            this.composeImagingObjectSelectionFramesComponent(t, "ImagingObjectSelection", "frame", element.getFrame().get(i), i);
        }
    }

    protected void composeImagingObjectSelectionFramesComponent(RdfGenerator.Complex parent, String parentType, String name, ImagingObjectSelection.FramesComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "frame", name, element, index);
        for (int i = 0; i < element.getNumber().size(); ++i) {
            this.composeUnsignedInt(t, "ImagingObjectSelection", "number", element.getNumber().get(i), i);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "ImagingObjectSelection", "url", element.getUrlElement(), -1);
        }
    }

    protected void composeImagingStudy(RdfGenerator.Complex parent, String parentType, String name, ImagingStudy element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ImagingStudy", name, element, index);
        if (element.hasUidElement()) {
            this.composeOid(t, "ImagingStudy", "uid", element.getUidElement(), -1);
        }
        if (element.hasAccession()) {
            this.composeIdentifier(t, "ImagingStudy", "accession", element.getAccession(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ImagingStudy", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasAvailabilityElement()) {
            this.composeEnum(t, "ImagingStudy", "availability", element.getAvailabilityElement(), -1);
        }
        for (i = 0; i < element.getModalityList().size(); ++i) {
            this.composeCoding(t, "ImagingStudy", "modalityList", element.getModalityList().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "ImagingStudy", "patient", element.getPatient(), -1);
        }
        if (element.hasStartedElement()) {
            this.composeDateTime(t, "ImagingStudy", "started", element.getStartedElement(), -1);
        }
        for (i = 0; i < element.getOrder().size(); ++i) {
            this.composeReference(t, "ImagingStudy", "order", element.getOrder().get(i), i);
        }
        if (element.hasReferrer()) {
            this.composeReference(t, "ImagingStudy", "referrer", element.getReferrer(), -1);
        }
        if (element.hasInterpreter()) {
            this.composeReference(t, "ImagingStudy", "interpreter", element.getInterpreter(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "ImagingStudy", "url", element.getUrlElement(), -1);
        }
        if (element.hasNumberOfSeriesElement()) {
            this.composeUnsignedInt(t, "ImagingStudy", "numberOfSeries", element.getNumberOfSeriesElement(), -1);
        }
        if (element.hasNumberOfInstancesElement()) {
            this.composeUnsignedInt(t, "ImagingStudy", "numberOfInstances", element.getNumberOfInstancesElement(), -1);
        }
        for (i = 0; i < element.getProcedure().size(); ++i) {
            this.composeReference(t, "ImagingStudy", "procedure", element.getProcedure().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImagingStudy", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getSeries().size(); ++i) {
            this.composeImagingStudyImagingStudySeriesComponent(t, "ImagingStudy", "series", element.getSeries().get(i), i);
        }
    }

    protected void composeImagingStudyImagingStudySeriesComponent(RdfGenerator.Complex parent, String parentType, String name, ImagingStudy.ImagingStudySeriesComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "series", name, element, index);
        if (element.hasUidElement()) {
            this.composeOid(t, "ImagingStudy", "uid", element.getUidElement(), -1);
        }
        if (element.hasNumberElement()) {
            this.composeUnsignedInt(t, "ImagingStudy", "number", element.getNumberElement(), -1);
        }
        if (element.hasModality()) {
            this.composeCoding(t, "ImagingStudy", "modality", element.getModality(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImagingStudy", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasNumberOfInstancesElement()) {
            this.composeUnsignedInt(t, "ImagingStudy", "numberOfInstances", element.getNumberOfInstancesElement(), -1);
        }
        if (element.hasAvailabilityElement()) {
            this.composeEnum(t, "ImagingStudy", "availability", element.getAvailabilityElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "ImagingStudy", "url", element.getUrlElement(), -1);
        }
        if (element.hasBodySite()) {
            this.composeCoding(t, "ImagingStudy", "bodySite", element.getBodySite(), -1);
        }
        if (element.hasLaterality()) {
            this.composeCoding(t, "ImagingStudy", "laterality", element.getLaterality(), -1);
        }
        if (element.hasStartedElement()) {
            this.composeDateTime(t, "ImagingStudy", "started", element.getStartedElement(), -1);
        }
        for (int i = 0; i < element.getInstance().size(); ++i) {
            this.composeImagingStudyImagingStudySeriesInstanceComponent(t, "ImagingStudy", "instance", element.getInstance().get(i), i);
        }
    }

    protected void composeImagingStudyImagingStudySeriesInstanceComponent(RdfGenerator.Complex parent, String parentType, String name, ImagingStudy.ImagingStudySeriesInstanceComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "instance", name, element, index);
        if (element.hasUidElement()) {
            this.composeOid(t, "ImagingStudy", "uid", element.getUidElement(), -1);
        }
        if (element.hasNumberElement()) {
            this.composeUnsignedInt(t, "ImagingStudy", "number", element.getNumberElement(), -1);
        }
        if (element.hasSopClassElement()) {
            this.composeOid(t, "ImagingStudy", "sopClass", element.getSopClassElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeString(t, "ImagingStudy", "type", element.getTypeElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ImagingStudy", "title", element.getTitleElement(), -1);
        }
        for (int i = 0; i < element.getContent().size(); ++i) {
            this.composeAttachment(t, "ImagingStudy", "content", element.getContent().get(i), i);
        }
    }

    protected void composeImmunization(RdfGenerator.Complex parent, String parentType, String name, Immunization element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Immunization", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Immunization", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeCode(t, "Immunization", "status", element.getStatusElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Immunization", "date", element.getDateElement(), -1);
        }
        if (element.hasVaccineCode()) {
            this.composeCodeableConcept(t, "Immunization", "vaccineCode", element.getVaccineCode(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "Immunization", "patient", element.getPatient(), -1);
        }
        if (element.hasWasNotGivenElement()) {
            this.composeBoolean(t, "Immunization", "wasNotGiven", element.getWasNotGivenElement(), -1);
        }
        if (element.hasReportedElement()) {
            this.composeBoolean(t, "Immunization", "reported", element.getReportedElement(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "Immunization", "performer", element.getPerformer(), -1);
        }
        if (element.hasRequester()) {
            this.composeReference(t, "Immunization", "requester", element.getRequester(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Immunization", "encounter", element.getEncounter(), -1);
        }
        if (element.hasManufacturer()) {
            this.composeReference(t, "Immunization", "manufacturer", element.getManufacturer(), -1);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "Immunization", "location", element.getLocation(), -1);
        }
        if (element.hasLotNumberElement()) {
            this.composeString(t, "Immunization", "lotNumber", element.getLotNumberElement(), -1);
        }
        if (element.hasExpirationDateElement()) {
            this.composeDate(t, "Immunization", "expirationDate", element.getExpirationDateElement(), -1);
        }
        if (element.hasSite()) {
            this.composeCodeableConcept(t, "Immunization", "site", element.getSite(), -1);
        }
        if (element.hasRoute()) {
            this.composeCodeableConcept(t, "Immunization", "route", element.getRoute(), -1);
        }
        if (element.hasDoseQuantity()) {
            this.composeQuantity(t, "Immunization", "doseQuantity", element.getDoseQuantity(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "Immunization", "note", element.getNote().get(i), i);
        }
        if (element.hasExplanation()) {
            this.composeImmunizationImmunizationExplanationComponent(t, "Immunization", "explanation", element.getExplanation(), -1);
        }
        for (i = 0; i < element.getReaction().size(); ++i) {
            this.composeImmunizationImmunizationReactionComponent(t, "Immunization", "reaction", element.getReaction().get(i), i);
        }
        for (i = 0; i < element.getVaccinationProtocol().size(); ++i) {
            this.composeImmunizationImmunizationVaccinationProtocolComponent(t, "Immunization", "vaccinationProtocol", element.getVaccinationProtocol().get(i), i);
        }
    }

    protected void composeImmunizationImmunizationExplanationComponent(RdfGenerator.Complex parent, String parentType, String name, Immunization.ImmunizationExplanationComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "explanation", name, element, index);
        for (i = 0; i < element.getReason().size(); ++i) {
            this.composeCodeableConcept(t, "Immunization", "reason", element.getReason().get(i), i);
        }
        for (i = 0; i < element.getReasonNotGiven().size(); ++i) {
            this.composeCodeableConcept(t, "Immunization", "reasonNotGiven", element.getReasonNotGiven().get(i), i);
        }
    }

    protected void composeImmunizationImmunizationReactionComponent(RdfGenerator.Complex parent, String parentType, String name, Immunization.ImmunizationReactionComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "reaction", name, element, index);
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Immunization", "date", element.getDateElement(), -1);
        }
        if (element.hasDetail()) {
            this.composeReference(t, "Immunization", "detail", element.getDetail(), -1);
        }
        if (element.hasReportedElement()) {
            this.composeBoolean(t, "Immunization", "reported", element.getReportedElement(), -1);
        }
    }

    protected void composeImmunizationImmunizationVaccinationProtocolComponent(RdfGenerator.Complex parent, String parentType, String name, Immunization.ImmunizationVaccinationProtocolComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "vaccinationProtocol", name, element, index);
        if (element.hasDoseSequenceElement()) {
            this.composePositiveInt(t, "Immunization", "doseSequence", element.getDoseSequenceElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Immunization", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasAuthority()) {
            this.composeReference(t, "Immunization", "authority", element.getAuthority(), -1);
        }
        if (element.hasSeriesElement()) {
            this.composeString(t, "Immunization", "series", element.getSeriesElement(), -1);
        }
        if (element.hasSeriesDosesElement()) {
            this.composePositiveInt(t, "Immunization", "seriesDoses", element.getSeriesDosesElement(), -1);
        }
        for (int i = 0; i < element.getTargetDisease().size(); ++i) {
            this.composeCodeableConcept(t, "Immunization", "targetDisease", element.getTargetDisease().get(i), i);
        }
        if (element.hasDoseStatus()) {
            this.composeCodeableConcept(t, "Immunization", "doseStatus", element.getDoseStatus(), -1);
        }
        if (element.hasDoseStatusReason()) {
            this.composeCodeableConcept(t, "Immunization", "doseStatusReason", element.getDoseStatusReason(), -1);
        }
    }

    protected void composeImmunizationRecommendation(RdfGenerator.Complex parent, String parentType, String name, ImmunizationRecommendation element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ImmunizationRecommendation", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ImmunizationRecommendation", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "ImmunizationRecommendation", "patient", element.getPatient(), -1);
        }
        for (i = 0; i < element.getRecommendation().size(); ++i) {
            this.composeImmunizationRecommendationImmunizationRecommendationRecommendationComponent(t, "ImmunizationRecommendation", "recommendation", element.getRecommendation().get(i), i);
        }
    }

    protected void composeImmunizationRecommendationImmunizationRecommendationRecommendationComponent(RdfGenerator.Complex parent, String parentType, String name, ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "recommendation", name, element, index);
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ImmunizationRecommendation", "date", element.getDateElement(), -1);
        }
        if (element.hasVaccineCode()) {
            this.composeCodeableConcept(t, "ImmunizationRecommendation", "vaccineCode", element.getVaccineCode(), -1);
        }
        if (element.hasDoseNumberElement()) {
            this.composePositiveInt(t, "ImmunizationRecommendation", "doseNumber", element.getDoseNumberElement(), -1);
        }
        if (element.hasForecastStatus()) {
            this.composeCodeableConcept(t, "ImmunizationRecommendation", "forecastStatus", element.getForecastStatus(), -1);
        }
        for (i = 0; i < element.getDateCriterion().size(); ++i) {
            this.composeImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(t, "ImmunizationRecommendation", "dateCriterion", element.getDateCriterion().get(i), i);
        }
        if (element.hasProtocol()) {
            this.composeImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(t, "ImmunizationRecommendation", "protocol", element.getProtocol(), -1);
        }
        for (i = 0; i < element.getSupportingImmunization().size(); ++i) {
            this.composeReference(t, "ImmunizationRecommendation", "supportingImmunization", element.getSupportingImmunization().get(i), i);
        }
        for (i = 0; i < element.getSupportingPatientInformation().size(); ++i) {
            this.composeReference(t, "ImmunizationRecommendation", "supportingPatientInformation", element.getSupportingPatientInformation().get(i), i);
        }
    }

    protected void composeImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(RdfGenerator.Complex parent, String parentType, String name, ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dateCriterion", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ImmunizationRecommendation", "code", element.getCode(), -1);
        }
        if (element.hasValueElement()) {
            this.composeDateTime(t, "ImmunizationRecommendation", "value", element.getValueElement(), -1);
        }
    }

    protected void composeImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(RdfGenerator.Complex parent, String parentType, String name, ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "protocol", name, element, index);
        if (element.hasDoseSequenceElement()) {
            this.composeInteger(t, "ImmunizationRecommendation", "doseSequence", element.getDoseSequenceElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImmunizationRecommendation", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasAuthority()) {
            this.composeReference(t, "ImmunizationRecommendation", "authority", element.getAuthority(), -1);
        }
        if (element.hasSeriesElement()) {
            this.composeString(t, "ImmunizationRecommendation", "series", element.getSeriesElement(), -1);
        }
    }

    protected void composeImplementationGuide(RdfGenerator.Complex parent, String parentType, String name, ImplementationGuide element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ImplementationGuide", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ImplementationGuide", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ImplementationGuide", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ImplementationGuide", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ImplementationGuide", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ImplementationGuide", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ImplementationGuide", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeImplementationGuideImplementationGuideContactComponent(t, "ImplementationGuide", "contact", element.getContact().get(i), i);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ImplementationGuide", "date", element.getDateElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImplementationGuide", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeCodeableConcept(t, "ImplementationGuide", "useContext", element.getUseContext().get(i), i);
        }
        if (element.hasCopyrightElement()) {
            this.composeString(t, "ImplementationGuide", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasFhirVersionElement()) {
            this.composeId(t, "ImplementationGuide", "fhirVersion", element.getFhirVersionElement(), -1);
        }
        for (i = 0; i < element.getDependency().size(); ++i) {
            this.composeImplementationGuideImplementationGuideDependencyComponent(t, "ImplementationGuide", "dependency", element.getDependency().get(i), i);
        }
        for (i = 0; i < element.getPackage().size(); ++i) {
            this.composeImplementationGuideImplementationGuidePackageComponent(t, "ImplementationGuide", "package", element.getPackage().get(i), i);
        }
        for (i = 0; i < element.getGlobal().size(); ++i) {
            this.composeImplementationGuideImplementationGuideGlobalComponent(t, "ImplementationGuide", "global", element.getGlobal().get(i), i);
        }
        for (i = 0; i < element.getBinary().size(); ++i) {
            this.composeUri(t, "ImplementationGuide", "binary", element.getBinary().get(i), i);
        }
        if (element.hasPage()) {
            this.composeImplementationGuideImplementationGuidePageComponent(t, "ImplementationGuide", "page", element.getPage(), -1);
        }
    }

    protected void composeImplementationGuideImplementationGuideContactComponent(RdfGenerator.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideContactComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ImplementationGuide", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "ImplementationGuide", "telecom", element.getTelecom().get(i), i);
        }
    }

    protected void composeImplementationGuideImplementationGuideDependencyComponent(RdfGenerator.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDependencyComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dependency", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ImplementationGuide", "type", element.getTypeElement(), -1);
        }
        if (element.hasUriElement()) {
            this.composeUri(t, "ImplementationGuide", "uri", element.getUriElement(), -1);
        }
    }

    protected void composeImplementationGuideImplementationGuidePackageComponent(RdfGenerator.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuidePackageComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "package", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ImplementationGuide", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImplementationGuide", "description", element.getDescriptionElement(), -1);
        }
        for (int i = 0; i < element.getResource().size(); ++i) {
            this.composeImplementationGuideImplementationGuidePackageResourceComponent(t, "ImplementationGuide", "resource", element.getResource().get(i), i);
        }
    }

    protected void composeImplementationGuideImplementationGuidePackageResourceComponent(RdfGenerator.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuidePackageResourceComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "resource", name, element, index);
        if (element.hasExampleElement()) {
            this.composeBoolean(t, "ImplementationGuide", "example", element.getExampleElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ImplementationGuide", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImplementationGuide", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasAcronymElement()) {
            this.composeString(t, "ImplementationGuide", "acronym", element.getAcronymElement(), -1);
        }
        if (element.hasSource()) {
            this.composeType(t, "ImplementationGuide", "source", element.getSource(), -1);
        }
        if (element.hasExampleFor()) {
            this.composeReference(t, "ImplementationGuide", "exampleFor", element.getExampleFor(), -1);
        }
    }

    protected void composeImplementationGuideImplementationGuideGlobalComponent(RdfGenerator.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideGlobalComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "global", name, element, index);
        if (element.hasTypeElement()) {
            this.composeCode(t, "ImplementationGuide", "type", element.getTypeElement(), -1);
        }
        if (element.hasProfile()) {
            this.composeReference(t, "ImplementationGuide", "profile", element.getProfile(), -1);
        }
    }

    protected void composeImplementationGuideImplementationGuidePageComponent(RdfGenerator.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuidePageComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "page", name, element, index);
        if (element.hasSourceElement()) {
            this.composeUri(t, "ImplementationGuide", "source", element.getSourceElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ImplementationGuide", "name", element.getNameElement(), -1);
        }
        if (element.hasKindElement()) {
            this.composeEnum(t, "ImplementationGuide", "kind", element.getKindElement(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCode(t, "ImplementationGuide", "type", element.getType().get(i), i);
        }
        for (i = 0; i < element.getPackage().size(); ++i) {
            this.composeString(t, "ImplementationGuide", "package", element.getPackage().get(i), i);
        }
        if (element.hasFormatElement()) {
            this.composeCode(t, "ImplementationGuide", "format", element.getFormatElement(), -1);
        }
        for (i = 0; i < element.getPage().size(); ++i) {
            this.composeImplementationGuideImplementationGuidePageComponent(t, "ImplementationGuide", "page", element.getPage().get(i), i);
        }
    }

    protected void composeLibrary(RdfGenerator.Complex parent, String parentType, String name, Library element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Library", name, element, index);
        if (element.hasModuleMetadata()) {
            this.composeModuleMetadata(t, "Library", "moduleMetadata", element.getModuleMetadata(), -1);
        }
        for (i = 0; i < element.getModel().size(); ++i) {
            this.composeLibraryLibraryModelComponent(t, "Library", "model", element.getModel().get(i), i);
        }
        for (i = 0; i < element.getLibrary().size(); ++i) {
            this.composeLibraryLibraryLibraryComponent(t, "Library", "library", element.getLibrary().get(i), i);
        }
        for (i = 0; i < element.getCodeSystem().size(); ++i) {
            this.composeLibraryLibraryCodeSystemComponent(t, "Library", "codeSystem", element.getCodeSystem().get(i), i);
        }
        for (i = 0; i < element.getValueSet().size(); ++i) {
            this.composeLibraryLibraryValueSetComponent(t, "Library", "valueSet", element.getValueSet().get(i), i);
        }
        for (i = 0; i < element.getParameter().size(); ++i) {
            this.composeParameterDefinition(t, "Library", "parameter", element.getParameter().get(i), i);
        }
        for (i = 0; i < element.getDataRequirement().size(); ++i) {
            this.composeDataRequirement(t, "Library", "dataRequirement", element.getDataRequirement().get(i), i);
        }
        if (element.hasDocument()) {
            this.composeAttachment(t, "Library", "document", element.getDocument(), -1);
        }
    }

    protected void composeLibraryLibraryModelComponent(RdfGenerator.Complex parent, String parentType, String name, Library.LibraryModelComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "model", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "Library", "name", element.getNameElement(), -1);
        }
        if (element.hasIdentifierElement()) {
            this.composeString(t, "Library", "identifier", element.getIdentifierElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Library", "version", element.getVersionElement(), -1);
        }
    }

    protected void composeLibraryLibraryLibraryComponent(RdfGenerator.Complex parent, String parentType, String name, Library.LibraryLibraryComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "library", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "Library", "name", element.getNameElement(), -1);
        }
        if (element.hasIdentifierElement()) {
            this.composeString(t, "Library", "identifier", element.getIdentifierElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Library", "version", element.getVersionElement(), -1);
        }
        if (element.hasDocument()) {
            this.composeType(t, "Library", "document", element.getDocument(), -1);
        }
    }

    protected void composeLibraryLibraryCodeSystemComponent(RdfGenerator.Complex parent, String parentType, String name, Library.LibraryCodeSystemComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "codeSystem", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "Library", "name", element.getNameElement(), -1);
        }
        if (element.hasIdentifierElement()) {
            this.composeString(t, "Library", "identifier", element.getIdentifierElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Library", "version", element.getVersionElement(), -1);
        }
    }

    protected void composeLibraryLibraryValueSetComponent(RdfGenerator.Complex parent, String parentType, String name, Library.LibraryValueSetComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "valueSet", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "Library", "name", element.getNameElement(), -1);
        }
        if (element.hasIdentifierElement()) {
            this.composeString(t, "Library", "identifier", element.getIdentifierElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Library", "version", element.getVersionElement(), -1);
        }
        for (int i = 0; i < element.getCodeSystem().size(); ++i) {
            this.composeString(t, "Library", "codeSystem", element.getCodeSystem().get(i), i);
        }
    }

    protected void composeLinkage(RdfGenerator.Complex parent, String parentType, String name, Linkage element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Linkage", name, element, index);
        if (element.hasAuthor()) {
            this.composeReference(t, "Linkage", "author", element.getAuthor(), -1);
        }
        for (int i = 0; i < element.getItem().size(); ++i) {
            this.composeLinkageLinkageItemComponent(t, "Linkage", "item", element.getItem().get(i), i);
        }
    }

    protected void composeLinkageLinkageItemComponent(RdfGenerator.Complex parent, String parentType, String name, Linkage.LinkageItemComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Linkage", "type", element.getTypeElement(), -1);
        }
        if (element.hasResource()) {
            this.composeReference(t, "Linkage", "resource", element.getResource(), -1);
        }
    }

    protected void composeListResource(RdfGenerator.Complex parent, String parentType, String name, ListResource element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "List", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "List", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "List", "status", element.getStatusElement(), -1);
        }
        if (element.hasModeElement()) {
            this.composeEnum(t, "List", "mode", element.getModeElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "List", "title", element.getTitleElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "List", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "List", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "List", "encounter", element.getEncounter(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "List", "date", element.getDateElement(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "List", "source", element.getSource(), -1);
        }
        if (element.hasOrderedBy()) {
            this.composeCodeableConcept(t, "List", "orderedBy", element.getOrderedBy(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "List", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getEntry().size(); ++i) {
            this.composeListResourceListEntryComponent(t, "List", "entry", element.getEntry().get(i), i);
        }
        if (element.hasEmptyReason()) {
            this.composeCodeableConcept(t, "List", "emptyReason", element.getEmptyReason(), -1);
        }
    }

    protected void composeListResourceListEntryComponent(RdfGenerator.Complex parent, String parentType, String name, ListResource.ListEntryComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "entry", name, element, index);
        if (element.hasFlag()) {
            this.composeCodeableConcept(t, "List", "flag", element.getFlag(), -1);
        }
        if (element.hasDeletedElement()) {
            this.composeBoolean(t, "List", "deleted", element.getDeletedElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "List", "date", element.getDateElement(), -1);
        }
        if (element.hasItem()) {
            this.composeReference(t, "List", "item", element.getItem(), -1);
        }
    }

    protected void composeLocation(RdfGenerator.Complex parent, String parentType, String name, Location element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Location", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Location", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Location", "status", element.getStatusElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Location", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Location", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasModeElement()) {
            this.composeEnum(t, "Location", "mode", element.getModeElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Location", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Location", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasAddress()) {
            this.composeAddress(t, "Location", "address", element.getAddress(), -1);
        }
        if (element.hasPhysicalType()) {
            this.composeCodeableConcept(t, "Location", "physicalType", element.getPhysicalType(), -1);
        }
        if (element.hasPosition()) {
            this.composeLocationLocationPositionComponent(t, "Location", "position", element.getPosition(), -1);
        }
        if (element.hasManagingOrganization()) {
            this.composeReference(t, "Location", "managingOrganization", element.getManagingOrganization(), -1);
        }
        if (element.hasPartOf()) {
            this.composeReference(t, "Location", "partOf", element.getPartOf(), -1);
        }
    }

    protected void composeLocationLocationPositionComponent(RdfGenerator.Complex parent, String parentType, String name, Location.LocationPositionComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "position", name, element, index);
        if (element.hasLongitudeElement()) {
            this.composeDecimal(t, "Location", "longitude", element.getLongitudeElement(), -1);
        }
        if (element.hasLatitudeElement()) {
            this.composeDecimal(t, "Location", "latitude", element.getLatitudeElement(), -1);
        }
        if (element.hasAltitudeElement()) {
            this.composeDecimal(t, "Location", "altitude", element.getAltitudeElement(), -1);
        }
    }

    protected void composeMeasure(RdfGenerator.Complex parent, String parentType, String name, Measure element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Measure", name, element, index);
        if (element.hasModuleMetadata()) {
            this.composeModuleMetadata(t, "Measure", "moduleMetadata", element.getModuleMetadata(), -1);
        }
        for (i = 0; i < element.getLibrary().size(); ++i) {
            this.composeReference(t, "Measure", "library", element.getLibrary().get(i), i);
        }
        if (element.hasDisclaimerElement()) {
            this.composeMarkdown(t, "Measure", "disclaimer", element.getDisclaimerElement(), -1);
        }
        if (element.hasScoringElement()) {
            this.composeEnum(t, "Measure", "scoring", element.getScoringElement(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeEnum(t, "Measure", "type", element.getType().get(i), i);
        }
        if (element.hasRiskAdjustmentElement()) {
            this.composeString(t, "Measure", "riskAdjustment", element.getRiskAdjustmentElement(), -1);
        }
        if (element.hasRateAggregationElement()) {
            this.composeString(t, "Measure", "rateAggregation", element.getRateAggregationElement(), -1);
        }
        if (element.hasRationaleElement()) {
            this.composeMarkdown(t, "Measure", "rationale", element.getRationaleElement(), -1);
        }
        if (element.hasClinicalRecommendationStatementElement()) {
            this.composeMarkdown(t, "Measure", "clinicalRecommendationStatement", element.getClinicalRecommendationStatementElement(), -1);
        }
        if (element.hasImprovementNotationElement()) {
            this.composeString(t, "Measure", "improvementNotation", element.getImprovementNotationElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeMarkdown(t, "Measure", "definition", element.getDefinitionElement(), -1);
        }
        if (element.hasGuidanceElement()) {
            this.composeMarkdown(t, "Measure", "guidance", element.getGuidanceElement(), -1);
        }
        if (element.hasSetElement()) {
            this.composeString(t, "Measure", "set", element.getSetElement(), -1);
        }
        for (i = 0; i < element.getGroup().size(); ++i) {
            this.composeMeasureMeasureGroupComponent(t, "Measure", "group", element.getGroup().get(i), i);
        }
        for (i = 0; i < element.getSupplementalData().size(); ++i) {
            this.composeMeasureMeasureSupplementalDataComponent(t, "Measure", "supplementalData", element.getSupplementalData().get(i), i);
        }
    }

    protected void composeMeasureMeasureGroupComponent(RdfGenerator.Complex parent, String parentType, String name, Measure.MeasureGroupComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "group", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Measure", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Measure", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Measure", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getPopulation().size(); ++i) {
            this.composeMeasureMeasureGroupPopulationComponent(t, "Measure", "population", element.getPopulation().get(i), i);
        }
        for (i = 0; i < element.getStratifier().size(); ++i) {
            this.composeMeasureMeasureGroupStratifierComponent(t, "Measure", "stratifier", element.getStratifier().get(i), i);
        }
    }

    protected void composeMeasureMeasureGroupPopulationComponent(RdfGenerator.Complex parent, String parentType, String name, Measure.MeasureGroupPopulationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "population", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Measure", "type", element.getTypeElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Measure", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Measure", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Measure", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasCriteriaElement()) {
            this.composeString(t, "Measure", "criteria", element.getCriteriaElement(), -1);
        }
    }

    protected void composeMeasureMeasureGroupStratifierComponent(RdfGenerator.Complex parent, String parentType, String name, Measure.MeasureGroupStratifierComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "stratifier", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Measure", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasCriteriaElement()) {
            this.composeString(t, "Measure", "criteria", element.getCriteriaElement(), -1);
        }
        if (element.hasPathElement()) {
            this.composeString(t, "Measure", "path", element.getPathElement(), -1);
        }
    }

    protected void composeMeasureMeasureSupplementalDataComponent(RdfGenerator.Complex parent, String parentType, String name, Measure.MeasureSupplementalDataComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "supplementalData", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Measure", "identifier", element.getIdentifier(), -1);
        }
        for (int i = 0; i < element.getUsage().size(); ++i) {
            this.composeEnum(t, "Measure", "usage", element.getUsage().get(i), i);
        }
        if (element.hasCriteriaElement()) {
            this.composeString(t, "Measure", "criteria", element.getCriteriaElement(), -1);
        }
        if (element.hasPathElement()) {
            this.composeString(t, "Measure", "path", element.getPathElement(), -1);
        }
    }

    protected void composeMeasureReport(RdfGenerator.Complex parent, String parentType, String name, MeasureReport element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MeasureReport", name, element, index);
        if (element.hasMeasure()) {
            this.composeReference(t, "MeasureReport", "measure", element.getMeasure(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "MeasureReport", "type", element.getTypeElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "MeasureReport", "patient", element.getPatient(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "MeasureReport", "period", element.getPeriod(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MeasureReport", "status", element.getStatusElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "MeasureReport", "date", element.getDateElement(), -1);
        }
        if (element.hasReportingOrganization()) {
            this.composeReference(t, "MeasureReport", "reportingOrganization", element.getReportingOrganization(), -1);
        }
        for (int i = 0; i < element.getGroup().size(); ++i) {
            this.composeMeasureReportMeasureReportGroupComponent(t, "MeasureReport", "group", element.getGroup().get(i), i);
        }
        if (element.hasEvaluatedResources()) {
            this.composeReference(t, "MeasureReport", "evaluatedResources", element.getEvaluatedResources(), -1);
        }
    }

    protected void composeMeasureReportMeasureReportGroupComponent(RdfGenerator.Complex parent, String parentType, String name, MeasureReport.MeasureReportGroupComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "group", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "MeasureReport", "identifier", element.getIdentifier(), -1);
        }
        for (i = 0; i < element.getPopulation().size(); ++i) {
            this.composeMeasureReportMeasureReportGroupPopulationComponent(t, "MeasureReport", "population", element.getPopulation().get(i), i);
        }
        if (element.hasMeasureScoreElement()) {
            this.composeDecimal(t, "MeasureReport", "measureScore", element.getMeasureScoreElement(), -1);
        }
        for (i = 0; i < element.getStratifier().size(); ++i) {
            this.composeMeasureReportMeasureReportGroupStratifierComponent(t, "MeasureReport", "stratifier", element.getStratifier().get(i), i);
        }
        for (i = 0; i < element.getSupplementalData().size(); ++i) {
            this.composeMeasureReportMeasureReportGroupSupplementalDataComponent(t, "MeasureReport", "supplementalData", element.getSupplementalData().get(i), i);
        }
    }

    protected void composeMeasureReportMeasureReportGroupPopulationComponent(RdfGenerator.Complex parent, String parentType, String name, MeasureReport.MeasureReportGroupPopulationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "population", name, element, index);
        if (element.hasTypeElement()) {
            this.composeCode(t, "MeasureReport", "type", element.getTypeElement(), -1);
        }
        if (element.hasCountElement()) {
            this.composeInteger(t, "MeasureReport", "count", element.getCountElement(), -1);
        }
        if (element.hasPatients()) {
            this.composeReference(t, "MeasureReport", "patients", element.getPatients(), -1);
        }
    }

    protected void composeMeasureReportMeasureReportGroupStratifierComponent(RdfGenerator.Complex parent, String parentType, String name, MeasureReport.MeasureReportGroupStratifierComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "stratifier", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "MeasureReport", "identifier", element.getIdentifier(), -1);
        }
        for (int i = 0; i < element.getGroup().size(); ++i) {
            this.composeMeasureReportMeasureReportGroupStratifierGroupComponent(t, "MeasureReport", "group", element.getGroup().get(i), i);
        }
    }

    protected void composeMeasureReportMeasureReportGroupStratifierGroupComponent(RdfGenerator.Complex parent, String parentType, String name, MeasureReport.MeasureReportGroupStratifierGroupComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "group", name, element, index);
        if (element.hasValueElement()) {
            this.composeString(t, "MeasureReport", "value", element.getValueElement(), -1);
        }
        for (int i = 0; i < element.getPopulation().size(); ++i) {
            this.composeMeasureReportMeasureReportGroupStratifierGroupPopulationComponent(t, "MeasureReport", "population", element.getPopulation().get(i), i);
        }
        if (element.hasMeasureScoreElement()) {
            this.composeDecimal(t, "MeasureReport", "measureScore", element.getMeasureScoreElement(), -1);
        }
    }

    protected void composeMeasureReportMeasureReportGroupStratifierGroupPopulationComponent(RdfGenerator.Complex parent, String parentType, String name, MeasureReport.MeasureReportGroupStratifierGroupPopulationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "population", name, element, index);
        if (element.hasTypeElement()) {
            this.composeCode(t, "MeasureReport", "type", element.getTypeElement(), -1);
        }
        if (element.hasCountElement()) {
            this.composeInteger(t, "MeasureReport", "count", element.getCountElement(), -1);
        }
        if (element.hasPatients()) {
            this.composeReference(t, "MeasureReport", "patients", element.getPatients(), -1);
        }
    }

    protected void composeMeasureReportMeasureReportGroupSupplementalDataComponent(RdfGenerator.Complex parent, String parentType, String name, MeasureReport.MeasureReportGroupSupplementalDataComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "supplementalData", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "MeasureReport", "identifier", element.getIdentifier(), -1);
        }
        for (int i = 0; i < element.getGroup().size(); ++i) {
            this.composeMeasureReportMeasureReportGroupSupplementalDataGroupComponent(t, "MeasureReport", "group", element.getGroup().get(i), i);
        }
    }

    protected void composeMeasureReportMeasureReportGroupSupplementalDataGroupComponent(RdfGenerator.Complex parent, String parentType, String name, MeasureReport.MeasureReportGroupSupplementalDataGroupComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "group", name, element, index);
        if (element.hasValueElement()) {
            this.composeString(t, "MeasureReport", "value", element.getValueElement(), -1);
        }
        if (element.hasCountElement()) {
            this.composeInteger(t, "MeasureReport", "count", element.getCountElement(), -1);
        }
        if (element.hasPatients()) {
            this.composeReference(t, "MeasureReport", "patients", element.getPatients(), -1);
        }
    }

    protected void composeMedia(RdfGenerator.Complex parent, String parentType, String name, Media element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Media", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Media", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Media", "type", element.getTypeElement(), -1);
        }
        if (element.hasSubtype()) {
            this.composeCodeableConcept(t, "Media", "subtype", element.getSubtype(), -1);
        }
        if (element.hasView()) {
            this.composeCodeableConcept(t, "Media", "view", element.getView(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Media", "subject", element.getSubject(), -1);
        }
        if (element.hasOperator()) {
            this.composeReference(t, "Media", "operator", element.getOperator(), -1);
        }
        if (element.hasDeviceNameElement()) {
            this.composeString(t, "Media", "deviceName", element.getDeviceNameElement(), -1);
        }
        if (element.hasHeightElement()) {
            this.composePositiveInt(t, "Media", "height", element.getHeightElement(), -1);
        }
        if (element.hasWidthElement()) {
            this.composePositiveInt(t, "Media", "width", element.getWidthElement(), -1);
        }
        if (element.hasFramesElement()) {
            this.composePositiveInt(t, "Media", "frames", element.getFramesElement(), -1);
        }
        if (element.hasDurationElement()) {
            this.composeUnsignedInt(t, "Media", "duration", element.getDurationElement(), -1);
        }
        if (element.hasContent()) {
            this.composeAttachment(t, "Media", "content", element.getContent(), -1);
        }
    }

    protected void composeMedication(RdfGenerator.Complex parent, String parentType, String name, Medication element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Medication", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Medication", "code", element.getCode(), -1);
        }
        if (element.hasIsBrandElement()) {
            this.composeBoolean(t, "Medication", "isBrand", element.getIsBrandElement(), -1);
        }
        if (element.hasManufacturer()) {
            this.composeReference(t, "Medication", "manufacturer", element.getManufacturer(), -1);
        }
        if (element.hasProduct()) {
            this.composeMedicationMedicationProductComponent(t, "Medication", "product", element.getProduct(), -1);
        }
        if (element.hasPackage()) {
            this.composeMedicationMedicationPackageComponent(t, "Medication", "package", element.getPackage(), -1);
        }
    }

    protected void composeMedicationMedicationProductComponent(RdfGenerator.Complex parent, String parentType, String name, Medication.MedicationProductComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "product", name, element, index);
        if (element.hasForm()) {
            this.composeCodeableConcept(t, "Medication", "form", element.getForm(), -1);
        }
        for (i = 0; i < element.getIngredient().size(); ++i) {
            this.composeMedicationMedicationProductIngredientComponent(t, "Medication", "ingredient", element.getIngredient().get(i), i);
        }
        for (i = 0; i < element.getBatch().size(); ++i) {
            this.composeMedicationMedicationProductBatchComponent(t, "Medication", "batch", element.getBatch().get(i), i);
        }
    }

    protected void composeMedicationMedicationProductIngredientComponent(RdfGenerator.Complex parent, String parentType, String name, Medication.MedicationProductIngredientComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "ingredient", name, element, index);
        if (element.hasItem()) {
            this.composeType(t, "Medication", "item", element.getItem(), -1);
        }
        if (element.hasAmount()) {
            this.composeRatio(t, "Medication", "amount", element.getAmount(), -1);
        }
    }

    protected void composeMedicationMedicationProductBatchComponent(RdfGenerator.Complex parent, String parentType, String name, Medication.MedicationProductBatchComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "batch", name, element, index);
        if (element.hasLotNumberElement()) {
            this.composeString(t, "Medication", "lotNumber", element.getLotNumberElement(), -1);
        }
        if (element.hasExpirationDateElement()) {
            this.composeDateTime(t, "Medication", "expirationDate", element.getExpirationDateElement(), -1);
        }
    }

    protected void composeMedicationMedicationPackageComponent(RdfGenerator.Complex parent, String parentType, String name, Medication.MedicationPackageComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "package", name, element, index);
        if (element.hasContainer()) {
            this.composeCodeableConcept(t, "Medication", "container", element.getContainer(), -1);
        }
        for (int i = 0; i < element.getContent().size(); ++i) {
            this.composeMedicationMedicationPackageContentComponent(t, "Medication", "content", element.getContent().get(i), i);
        }
    }

    protected void composeMedicationMedicationPackageContentComponent(RdfGenerator.Complex parent, String parentType, String name, Medication.MedicationPackageContentComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "content", name, element, index);
        if (element.hasItem()) {
            this.composeType(t, "Medication", "item", element.getItem(), -1);
        }
        if (element.hasAmount()) {
            this.composeQuantity(t, "Medication", "amount", element.getAmount(), -1);
        }
    }

    protected void composeMedicationAdministration(RdfGenerator.Complex parent, String parentType, String name, MedicationAdministration element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicationAdministration", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicationAdministration", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MedicationAdministration", "status", element.getStatusElement(), -1);
        }
        if (element.hasMedication()) {
            this.composeType(t, "MedicationAdministration", "medication", element.getMedication(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "MedicationAdministration", "patient", element.getPatient(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "MedicationAdministration", "encounter", element.getEncounter(), -1);
        }
        if (element.hasEffectiveTime()) {
            this.composeType(t, "MedicationAdministration", "effectiveTime", element.getEffectiveTime(), -1);
        }
        if (element.hasPractitioner()) {
            this.composeReference(t, "MedicationAdministration", "practitioner", element.getPractitioner(), -1);
        }
        if (element.hasPrescription()) {
            this.composeReference(t, "MedicationAdministration", "prescription", element.getPrescription(), -1);
        }
        if (element.hasWasNotGivenElement()) {
            this.composeBoolean(t, "MedicationAdministration", "wasNotGiven", element.getWasNotGivenElement(), -1);
        }
        for (i = 0; i < element.getReasonNotGiven().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationAdministration", "reasonNotGiven", element.getReasonNotGiven().get(i), i);
        }
        for (i = 0; i < element.getReasonGiven().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationAdministration", "reasonGiven", element.getReasonGiven().get(i), i);
        }
        for (i = 0; i < element.getDevice().size(); ++i) {
            this.composeReference(t, "MedicationAdministration", "device", element.getDevice().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "MedicationAdministration", "note", element.getNote().get(i), i);
        }
        if (element.hasDosage()) {
            this.composeMedicationAdministrationMedicationAdministrationDosageComponent(t, "MedicationAdministration", "dosage", element.getDosage(), -1);
        }
    }

    protected void composeMedicationAdministrationMedicationAdministrationDosageComponent(RdfGenerator.Complex parent, String parentType, String name, MedicationAdministration.MedicationAdministrationDosageComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dosage", name, element, index);
        if (element.hasTextElement()) {
            this.composeString(t, "MedicationAdministration", "text", element.getTextElement(), -1);
        }
        if (element.hasSite()) {
            this.composeType(t, "MedicationAdministration", "site", element.getSite(), -1);
        }
        if (element.hasRoute()) {
            this.composeCodeableConcept(t, "MedicationAdministration", "route", element.getRoute(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "MedicationAdministration", "method", element.getMethod(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MedicationAdministration", "quantity", element.getQuantity(), -1);
        }
        if (element.hasRate()) {
            this.composeType(t, "MedicationAdministration", "rate", element.getRate(), -1);
        }
    }

    protected void composeMedicationDispense(RdfGenerator.Complex parent, String parentType, String name, MedicationDispense element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicationDispense", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "MedicationDispense", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MedicationDispense", "status", element.getStatusElement(), -1);
        }
        if (element.hasMedication()) {
            this.composeType(t, "MedicationDispense", "medication", element.getMedication(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "MedicationDispense", "patient", element.getPatient(), -1);
        }
        if (element.hasDispenser()) {
            this.composeReference(t, "MedicationDispense", "dispenser", element.getDispenser(), -1);
        }
        for (i = 0; i < element.getAuthorizingPrescription().size(); ++i) {
            this.composeReference(t, "MedicationDispense", "authorizingPrescription", element.getAuthorizingPrescription().get(i), i);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationDispense", "type", element.getType(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MedicationDispense", "quantity", element.getQuantity(), -1);
        }
        if (element.hasDaysSupply()) {
            this.composeQuantity(t, "MedicationDispense", "daysSupply", element.getDaysSupply(), -1);
        }
        if (element.hasWhenPreparedElement()) {
            this.composeDateTime(t, "MedicationDispense", "whenPrepared", element.getWhenPreparedElement(), -1);
        }
        if (element.hasWhenHandedOverElement()) {
            this.composeDateTime(t, "MedicationDispense", "whenHandedOver", element.getWhenHandedOverElement(), -1);
        }
        if (element.hasDestination()) {
            this.composeReference(t, "MedicationDispense", "destination", element.getDestination(), -1);
        }
        for (i = 0; i < element.getReceiver().size(); ++i) {
            this.composeReference(t, "MedicationDispense", "receiver", element.getReceiver().get(i), i);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "MedicationDispense", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getDosageInstruction().size(); ++i) {
            this.composeMedicationDispenseMedicationDispenseDosageInstructionComponent(t, "MedicationDispense", "dosageInstruction", element.getDosageInstruction().get(i), i);
        }
        if (element.hasSubstitution()) {
            this.composeMedicationDispenseMedicationDispenseSubstitutionComponent(t, "MedicationDispense", "substitution", element.getSubstitution(), -1);
        }
    }

    protected void composeMedicationDispenseMedicationDispenseDosageInstructionComponent(RdfGenerator.Complex parent, String parentType, String name, MedicationDispense.MedicationDispenseDosageInstructionComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dosageInstruction", name, element, index);
        if (element.hasTextElement()) {
            this.composeString(t, "MedicationDispense", "text", element.getTextElement(), -1);
        }
        if (element.hasAdditionalInstructions()) {
            this.composeCodeableConcept(t, "MedicationDispense", "additionalInstructions", element.getAdditionalInstructions(), -1);
        }
        if (element.hasTiming()) {
            this.composeTiming(t, "MedicationDispense", "timing", element.getTiming(), -1);
        }
        if (element.hasAsNeeded()) {
            this.composeType(t, "MedicationDispense", "asNeeded", element.getAsNeeded(), -1);
        }
        if (element.hasSite()) {
            this.composeType(t, "MedicationDispense", "site", element.getSite(), -1);
        }
        if (element.hasRoute()) {
            this.composeCodeableConcept(t, "MedicationDispense", "route", element.getRoute(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "MedicationDispense", "method", element.getMethod(), -1);
        }
        if (element.hasDose()) {
            this.composeType(t, "MedicationDispense", "dose", element.getDose(), -1);
        }
        if (element.hasRate()) {
            this.composeType(t, "MedicationDispense", "rate", element.getRate(), -1);
        }
        if (element.hasMaxDosePerPeriod()) {
            this.composeRatio(t, "MedicationDispense", "maxDosePerPeriod", element.getMaxDosePerPeriod(), -1);
        }
    }

    protected void composeMedicationDispenseMedicationDispenseSubstitutionComponent(RdfGenerator.Complex parent, String parentType, String name, MedicationDispense.MedicationDispenseSubstitutionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "substitution", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationDispense", "type", element.getType(), -1);
        }
        for (i = 0; i < element.getReason().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationDispense", "reason", element.getReason().get(i), i);
        }
        for (i = 0; i < element.getResponsibleParty().size(); ++i) {
            this.composeReference(t, "MedicationDispense", "responsibleParty", element.getResponsibleParty().get(i), i);
        }
    }

    protected void composeMedicationOrder(RdfGenerator.Complex parent, String parentType, String name, MedicationOrder element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicationOrder", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicationOrder", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MedicationOrder", "status", element.getStatusElement(), -1);
        }
        if (element.hasMedication()) {
            this.composeType(t, "MedicationOrder", "medication", element.getMedication(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "MedicationOrder", "patient", element.getPatient(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "MedicationOrder", "encounter", element.getEncounter(), -1);
        }
        if (element.hasDateWrittenElement()) {
            this.composeDateTime(t, "MedicationOrder", "dateWritten", element.getDateWrittenElement(), -1);
        }
        if (element.hasPrescriber()) {
            this.composeReference(t, "MedicationOrder", "prescriber", element.getPrescriber(), -1);
        }
        for (i = 0; i < element.getReasonCode().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationOrder", "reasonCode", element.getReasonCode().get(i), i);
        }
        for (i = 0; i < element.getReasonReference().size(); ++i) {
            this.composeReference(t, "MedicationOrder", "reasonReference", element.getReasonReference().get(i), i);
        }
        if (element.hasDateEndedElement()) {
            this.composeDateTime(t, "MedicationOrder", "dateEnded", element.getDateEndedElement(), -1);
        }
        if (element.hasReasonEnded()) {
            this.composeCodeableConcept(t, "MedicationOrder", "reasonEnded", element.getReasonEnded(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "MedicationOrder", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getDosageInstruction().size(); ++i) {
            this.composeMedicationOrderMedicationOrderDosageInstructionComponent(t, "MedicationOrder", "dosageInstruction", element.getDosageInstruction().get(i), i);
        }
        if (element.hasDispenseRequest()) {
            this.composeMedicationOrderMedicationOrderDispenseRequestComponent(t, "MedicationOrder", "dispenseRequest", element.getDispenseRequest(), -1);
        }
        if (element.hasSubstitution()) {
            this.composeMedicationOrderMedicationOrderSubstitutionComponent(t, "MedicationOrder", "substitution", element.getSubstitution(), -1);
        }
        if (element.hasPriorPrescription()) {
            this.composeReference(t, "MedicationOrder", "priorPrescription", element.getPriorPrescription(), -1);
        }
    }

    protected void composeMedicationOrderMedicationOrderDosageInstructionComponent(RdfGenerator.Complex parent, String parentType, String name, MedicationOrder.MedicationOrderDosageInstructionComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dosageInstruction", name, element, index);
        if (element.hasTextElement()) {
            this.composeString(t, "MedicationOrder", "text", element.getTextElement(), -1);
        }
        if (element.hasAdditionalInstructions()) {
            this.composeCodeableConcept(t, "MedicationOrder", "additionalInstructions", element.getAdditionalInstructions(), -1);
        }
        if (element.hasTiming()) {
            this.composeTiming(t, "MedicationOrder", "timing", element.getTiming(), -1);
        }
        if (element.hasAsNeeded()) {
            this.composeType(t, "MedicationOrder", "asNeeded", element.getAsNeeded(), -1);
        }
        if (element.hasSite()) {
            this.composeType(t, "MedicationOrder", "site", element.getSite(), -1);
        }
        if (element.hasRoute()) {
            this.composeCodeableConcept(t, "MedicationOrder", "route", element.getRoute(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "MedicationOrder", "method", element.getMethod(), -1);
        }
        if (element.hasDose()) {
            this.composeType(t, "MedicationOrder", "dose", element.getDose(), -1);
        }
        if (element.hasRate()) {
            this.composeType(t, "MedicationOrder", "rate", element.getRate(), -1);
        }
        if (element.hasMaxDosePerPeriod()) {
            this.composeRatio(t, "MedicationOrder", "maxDosePerPeriod", element.getMaxDosePerPeriod(), -1);
        }
    }

    protected void composeMedicationOrderMedicationOrderDispenseRequestComponent(RdfGenerator.Complex parent, String parentType, String name, MedicationOrder.MedicationOrderDispenseRequestComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dispenseRequest", name, element, index);
        if (element.hasMedication()) {
            this.composeType(t, "MedicationOrder", "medication", element.getMedication(), -1);
        }
        if (element.hasValidityPeriod()) {
            this.composePeriod(t, "MedicationOrder", "validityPeriod", element.getValidityPeriod(), -1);
        }
        if (element.hasNumberOfRepeatsAllowedElement()) {
            this.composePositiveInt(t, "MedicationOrder", "numberOfRepeatsAllowed", element.getNumberOfRepeatsAllowedElement(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MedicationOrder", "quantity", element.getQuantity(), -1);
        }
        if (element.hasExpectedSupplyDuration()) {
            this.composeQuantity(t, "MedicationOrder", "expectedSupplyDuration", element.getExpectedSupplyDuration(), -1);
        }
    }

    protected void composeMedicationOrderMedicationOrderSubstitutionComponent(RdfGenerator.Complex parent, String parentType, String name, MedicationOrder.MedicationOrderSubstitutionComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "substitution", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationOrder", "type", element.getType(), -1);
        }
        if (element.hasReason()) {
            this.composeCodeableConcept(t, "MedicationOrder", "reason", element.getReason(), -1);
        }
    }

    protected void composeMedicationStatement(RdfGenerator.Complex parent, String parentType, String name, MedicationStatement element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicationStatement", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "MedicationStatement", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MedicationStatement", "status", element.getStatusElement(), -1);
        }
        if (element.hasMedication()) {
            this.composeType(t, "MedicationStatement", "medication", element.getMedication(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "MedicationStatement", "patient", element.getPatient(), -1);
        }
        if (element.hasEffective()) {
            this.composeType(t, "MedicationStatement", "effective", element.getEffective(), -1);
        }
        if (element.hasInformationSource()) {
            this.composeReference(t, "MedicationStatement", "informationSource", element.getInformationSource(), -1);
        }
        for (i = 0; i < element.getSupportingInformation().size(); ++i) {
            this.composeReference(t, "MedicationStatement", "supportingInformation", element.getSupportingInformation().get(i), i);
        }
        if (element.hasDateAssertedElement()) {
            this.composeDateTime(t, "MedicationStatement", "dateAsserted", element.getDateAssertedElement(), -1);
        }
        if (element.hasWasNotTakenElement()) {
            this.composeBoolean(t, "MedicationStatement", "wasNotTaken", element.getWasNotTakenElement(), -1);
        }
        for (i = 0; i < element.getReasonNotTaken().size(); ++i) {
            this.composeCodeableConcept(t, "MedicationStatement", "reasonNotTaken", element.getReasonNotTaken().get(i), i);
        }
        if (element.hasReasonForUse()) {
            this.composeType(t, "MedicationStatement", "reasonForUse", element.getReasonForUse(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composeAnnotation(t, "MedicationStatement", "note", element.getNote().get(i), i);
        }
        for (i = 0; i < element.getDosage().size(); ++i) {
            this.composeMedicationStatementMedicationStatementDosageComponent(t, "MedicationStatement", "dosage", element.getDosage().get(i), i);
        }
    }

    protected void composeMedicationStatementMedicationStatementDosageComponent(RdfGenerator.Complex parent, String parentType, String name, MedicationStatement.MedicationStatementDosageComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dosage", name, element, index);
        if (element.hasTextElement()) {
            this.composeString(t, "MedicationStatement", "text", element.getTextElement(), -1);
        }
        if (element.hasTiming()) {
            this.composeTiming(t, "MedicationStatement", "timing", element.getTiming(), -1);
        }
        if (element.hasAsNeeded()) {
            this.composeType(t, "MedicationStatement", "asNeeded", element.getAsNeeded(), -1);
        }
        if (element.hasSite()) {
            this.composeType(t, "MedicationStatement", "site", element.getSite(), -1);
        }
        if (element.hasRoute()) {
            this.composeCodeableConcept(t, "MedicationStatement", "route", element.getRoute(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "MedicationStatement", "method", element.getMethod(), -1);
        }
        if (element.hasQuantity()) {
            this.composeType(t, "MedicationStatement", "quantity", element.getQuantity(), -1);
        }
        if (element.hasRate()) {
            this.composeType(t, "MedicationStatement", "rate", element.getRate(), -1);
        }
        if (element.hasMaxDosePerPeriod()) {
            this.composeRatio(t, "MedicationStatement", "maxDosePerPeriod", element.getMaxDosePerPeriod(), -1);
        }
    }

    protected void composeMessageHeader(RdfGenerator.Complex parent, String parentType, String name, MessageHeader element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MessageHeader", name, element, index);
        if (element.hasTimestampElement()) {
            this.composeInstant(t, "MessageHeader", "timestamp", element.getTimestampElement(), -1);
        }
        if (element.hasEvent()) {
            this.composeCoding(t, "MessageHeader", "event", element.getEvent(), -1);
        }
        if (element.hasResponse()) {
            this.composeMessageHeaderMessageHeaderResponseComponent(t, "MessageHeader", "response", element.getResponse(), -1);
        }
        if (element.hasSource()) {
            this.composeMessageHeaderMessageSourceComponent(t, "MessageHeader", "source", element.getSource(), -1);
        }
        for (i = 0; i < element.getDestination().size(); ++i) {
            this.composeMessageHeaderMessageDestinationComponent(t, "MessageHeader", "destination", element.getDestination().get(i), i);
        }
        if (element.hasEnterer()) {
            this.composeReference(t, "MessageHeader", "enterer", element.getEnterer(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "MessageHeader", "author", element.getAuthor(), -1);
        }
        if (element.hasReceiver()) {
            this.composeReference(t, "MessageHeader", "receiver", element.getReceiver(), -1);
        }
        if (element.hasResponsible()) {
            this.composeReference(t, "MessageHeader", "responsible", element.getResponsible(), -1);
        }
        if (element.hasReason()) {
            this.composeCodeableConcept(t, "MessageHeader", "reason", element.getReason(), -1);
        }
        for (i = 0; i < element.getData().size(); ++i) {
            this.composeReference(t, "MessageHeader", "data", element.getData().get(i), i);
        }
    }

    protected void composeMessageHeaderMessageHeaderResponseComponent(RdfGenerator.Complex parent, String parentType, String name, MessageHeader.MessageHeaderResponseComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "response", name, element, index);
        if (element.hasIdentifierElement()) {
            this.composeId(t, "MessageHeader", "identifier", element.getIdentifierElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeEnum(t, "MessageHeader", "code", element.getCodeElement(), -1);
        }
        if (element.hasDetails()) {
            this.composeReference(t, "MessageHeader", "details", element.getDetails(), -1);
        }
    }

    protected void composeMessageHeaderMessageSourceComponent(RdfGenerator.Complex parent, String parentType, String name, MessageHeader.MessageSourceComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "source", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "MessageHeader", "name", element.getNameElement(), -1);
        }
        if (element.hasSoftwareElement()) {
            this.composeString(t, "MessageHeader", "software", element.getSoftwareElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "MessageHeader", "version", element.getVersionElement(), -1);
        }
        if (element.hasContact()) {
            this.composeContactPoint(t, "MessageHeader", "contact", element.getContact(), -1);
        }
        if (element.hasEndpointElement()) {
            this.composeUri(t, "MessageHeader", "endpoint", element.getEndpointElement(), -1);
        }
    }

    protected void composeMessageHeaderMessageDestinationComponent(RdfGenerator.Complex parent, String parentType, String name, MessageHeader.MessageDestinationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "destination", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "MessageHeader", "name", element.getNameElement(), -1);
        }
        if (element.hasTarget()) {
            this.composeReference(t, "MessageHeader", "target", element.getTarget(), -1);
        }
        if (element.hasEndpointElement()) {
            this.composeUri(t, "MessageHeader", "endpoint", element.getEndpointElement(), -1);
        }
    }

    protected void composeModuleDefinition(RdfGenerator.Complex parent, String parentType, String name, ModuleDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ModuleDefinition", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ModuleDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ModuleDefinition", "version", element.getVersionElement(), -1);
        }
        for (i = 0; i < element.getModel().size(); ++i) {
            this.composeModuleDefinitionModuleDefinitionModelComponent(t, "ModuleDefinition", "model", element.getModel().get(i), i);
        }
        for (i = 0; i < element.getLibrary().size(); ++i) {
            this.composeModuleDefinitionModuleDefinitionLibraryComponent(t, "ModuleDefinition", "library", element.getLibrary().get(i), i);
        }
        for (i = 0; i < element.getCodeSystem().size(); ++i) {
            this.composeModuleDefinitionModuleDefinitionCodeSystemComponent(t, "ModuleDefinition", "codeSystem", element.getCodeSystem().get(i), i);
        }
        for (i = 0; i < element.getValueSet().size(); ++i) {
            this.composeModuleDefinitionModuleDefinitionValueSetComponent(t, "ModuleDefinition", "valueSet", element.getValueSet().get(i), i);
        }
        for (i = 0; i < element.getParameter().size(); ++i) {
            this.composeModuleDefinitionModuleDefinitionParameterComponent(t, "ModuleDefinition", "parameter", element.getParameter().get(i), i);
        }
        for (i = 0; i < element.getData().size(); ++i) {
            this.composeModuleDefinitionModuleDefinitionDataComponent(t, "ModuleDefinition", "data", element.getData().get(i), i);
        }
    }

    protected void composeModuleDefinitionModuleDefinitionModelComponent(RdfGenerator.Complex parent, String parentType, String name, ModuleDefinition.ModuleDefinitionModelComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "model", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ModuleDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasIdentifierElement()) {
            this.composeString(t, "ModuleDefinition", "identifier", element.getIdentifierElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ModuleDefinition", "version", element.getVersionElement(), -1);
        }
    }

    protected void composeModuleDefinitionModuleDefinitionLibraryComponent(RdfGenerator.Complex parent, String parentType, String name, ModuleDefinition.ModuleDefinitionLibraryComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "library", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ModuleDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasIdentifierElement()) {
            this.composeString(t, "ModuleDefinition", "identifier", element.getIdentifierElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ModuleDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasDocument()) {
            this.composeType(t, "ModuleDefinition", "document", element.getDocument(), -1);
        }
    }

    protected void composeModuleDefinitionModuleDefinitionCodeSystemComponent(RdfGenerator.Complex parent, String parentType, String name, ModuleDefinition.ModuleDefinitionCodeSystemComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "codeSystem", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ModuleDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasIdentifierElement()) {
            this.composeString(t, "ModuleDefinition", "identifier", element.getIdentifierElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ModuleDefinition", "version", element.getVersionElement(), -1);
        }
    }

    protected void composeModuleDefinitionModuleDefinitionValueSetComponent(RdfGenerator.Complex parent, String parentType, String name, ModuleDefinition.ModuleDefinitionValueSetComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "valueSet", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ModuleDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasIdentifierElement()) {
            this.composeString(t, "ModuleDefinition", "identifier", element.getIdentifierElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ModuleDefinition", "version", element.getVersionElement(), -1);
        }
        for (int i = 0; i < element.getCodeSystem().size(); ++i) {
            this.composeString(t, "ModuleDefinition", "codeSystem", element.getCodeSystem().get(i), i);
        }
    }

    protected void composeModuleDefinitionModuleDefinitionParameterComponent(RdfGenerator.Complex parent, String parentType, String name, ModuleDefinition.ModuleDefinitionParameterComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "parameter", name, element, index);
        if (element.hasNameElement()) {
            this.composeCode(t, "ModuleDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasUseElement()) {
            this.composeCode(t, "ModuleDefinition", "use", element.getUseElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "ModuleDefinition", "documentation", element.getDocumentationElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeCode(t, "ModuleDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasProfile()) {
            this.composeReference(t, "ModuleDefinition", "profile", element.getProfile(), -1);
        }
    }

    protected void composeModuleDefinitionModuleDefinitionDataComponent(RdfGenerator.Complex parent, String parentType, String name, ModuleDefinition.ModuleDefinitionDataComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "data", name, element, index);
        if (element.hasTypeElement()) {
            this.composeCode(t, "ModuleDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasProfile()) {
            this.composeReference(t, "ModuleDefinition", "profile", element.getProfile(), -1);
        }
        for (i = 0; i < element.getMustSupport().size(); ++i) {
            this.composeString(t, "ModuleDefinition", "mustSupport", element.getMustSupport().get(i), i);
        }
        for (i = 0; i < element.getCodeFilter().size(); ++i) {
            this.composeModuleDefinitionModuleDefinitionDataCodeFilterComponent(t, "ModuleDefinition", "codeFilter", element.getCodeFilter().get(i), i);
        }
        for (i = 0; i < element.getDateFilter().size(); ++i) {
            this.composeModuleDefinitionModuleDefinitionDataDateFilterComponent(t, "ModuleDefinition", "dateFilter", element.getDateFilter().get(i), i);
        }
    }

    protected void composeModuleDefinitionModuleDefinitionDataCodeFilterComponent(RdfGenerator.Complex parent, String parentType, String name, ModuleDefinition.ModuleDefinitionDataCodeFilterComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "codeFilter", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "ModuleDefinition", "path", element.getPathElement(), -1);
        }
        if (element.hasValueSet()) {
            this.composeType(t, "ModuleDefinition", "valueSet", element.getValueSet(), -1);
        }
        for (int i = 0; i < element.getCodeableConcept().size(); ++i) {
            this.composeCodeableConcept(t, "ModuleDefinition", "codeableConcept", element.getCodeableConcept().get(i), i);
        }
    }

    protected void composeModuleDefinitionModuleDefinitionDataDateFilterComponent(RdfGenerator.Complex parent, String parentType, String name, ModuleDefinition.ModuleDefinitionDataDateFilterComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dateFilter", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "ModuleDefinition", "path", element.getPathElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "ModuleDefinition", "value", element.getValue(), -1);
        }
    }

    protected void composeNamingSystem(RdfGenerator.Complex parent, String parentType, String name, NamingSystem element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "NamingSystem", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "NamingSystem", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "NamingSystem", "status", element.getStatusElement(), -1);
        }
        if (element.hasKindElement()) {
            this.composeEnum(t, "NamingSystem", "kind", element.getKindElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "NamingSystem", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "NamingSystem", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeNamingSystemNamingSystemContactComponent(t, "NamingSystem", "contact", element.getContact().get(i), i);
        }
        if (element.hasResponsibleElement()) {
            this.composeString(t, "NamingSystem", "responsible", element.getResponsibleElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "NamingSystem", "type", element.getType(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "NamingSystem", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeCodeableConcept(t, "NamingSystem", "useContext", element.getUseContext().get(i), i);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "NamingSystem", "usage", element.getUsageElement(), -1);
        }
        for (i = 0; i < element.getUniqueId().size(); ++i) {
            this.composeNamingSystemNamingSystemUniqueIdComponent(t, "NamingSystem", "uniqueId", element.getUniqueId().get(i), i);
        }
        if (element.hasReplacedBy()) {
            this.composeReference(t, "NamingSystem", "replacedBy", element.getReplacedBy(), -1);
        }
    }

    protected void composeNamingSystemNamingSystemContactComponent(RdfGenerator.Complex parent, String parentType, String name, NamingSystem.NamingSystemContactComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "NamingSystem", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "NamingSystem", "telecom", element.getTelecom().get(i), i);
        }
    }

    protected void composeNamingSystemNamingSystemUniqueIdComponent(RdfGenerator.Complex parent, String parentType, String name, NamingSystem.NamingSystemUniqueIdComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "uniqueId", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "NamingSystem", "type", element.getTypeElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "NamingSystem", "value", element.getValueElement(), -1);
        }
        if (element.hasPreferredElement()) {
            this.composeBoolean(t, "NamingSystem", "preferred", element.getPreferredElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "NamingSystem", "period", element.getPeriod(), -1);
        }
    }

    protected void composeNutritionOrder(RdfGenerator.Complex parent, String parentType, String name, NutritionOrder element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "NutritionOrder", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "NutritionOrder", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "NutritionOrder", "status", element.getStatusElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "NutritionOrder", "patient", element.getPatient(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "NutritionOrder", "encounter", element.getEncounter(), -1);
        }
        if (element.hasDateTimeElement()) {
            this.composeDateTime(t, "NutritionOrder", "dateTime", element.getDateTimeElement(), -1);
        }
        if (element.hasOrderer()) {
            this.composeReference(t, "NutritionOrder", "orderer", element.getOrderer(), -1);
        }
        for (i = 0; i < element.getAllergyIntolerance().size(); ++i) {
            this.composeReference(t, "NutritionOrder", "allergyIntolerance", element.getAllergyIntolerance().get(i), i);
        }
        for (i = 0; i < element.getFoodPreferenceModifier().size(); ++i) {
            this.composeCodeableConcept(t, "NutritionOrder", "foodPreferenceModifier", element.getFoodPreferenceModifier().get(i), i);
        }
        for (i = 0; i < element.getExcludeFoodModifier().size(); ++i) {
            this.composeCodeableConcept(t, "NutritionOrder", "excludeFoodModifier", element.getExcludeFoodModifier().get(i), i);
        }
        if (element.hasOralDiet()) {
            this.composeNutritionOrderNutritionOrderOralDietComponent(t, "NutritionOrder", "oralDiet", element.getOralDiet(), -1);
        }
        for (i = 0; i < element.getSupplement().size(); ++i) {
            this.composeNutritionOrderNutritionOrderSupplementComponent(t, "NutritionOrder", "supplement", element.getSupplement().get(i), i);
        }
        if (element.hasEnteralFormula()) {
            this.composeNutritionOrderNutritionOrderEnteralFormulaComponent(t, "NutritionOrder", "enteralFormula", element.getEnteralFormula(), -1);
        }
    }

    protected void composeNutritionOrderNutritionOrderOralDietComponent(RdfGenerator.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderOralDietComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "oralDiet", name, element, index);
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCodeableConcept(t, "NutritionOrder", "type", element.getType().get(i), i);
        }
        for (i = 0; i < element.getSchedule().size(); ++i) {
            this.composeTiming(t, "NutritionOrder", "schedule", element.getSchedule().get(i), i);
        }
        for (i = 0; i < element.getNutrient().size(); ++i) {
            this.composeNutritionOrderNutritionOrderOralDietNutrientComponent(t, "NutritionOrder", "nutrient", element.getNutrient().get(i), i);
        }
        for (i = 0; i < element.getTexture().size(); ++i) {
            this.composeNutritionOrderNutritionOrderOralDietTextureComponent(t, "NutritionOrder", "texture", element.getTexture().get(i), i);
        }
        for (i = 0; i < element.getFluidConsistencyType().size(); ++i) {
            this.composeCodeableConcept(t, "NutritionOrder", "fluidConsistencyType", element.getFluidConsistencyType().get(i), i);
        }
        if (element.hasInstructionElement()) {
            this.composeString(t, "NutritionOrder", "instruction", element.getInstructionElement(), -1);
        }
    }

    protected void composeNutritionOrderNutritionOrderOralDietNutrientComponent(RdfGenerator.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderOralDietNutrientComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "nutrient", name, element, index);
        if (element.hasModifier()) {
            this.composeCodeableConcept(t, "NutritionOrder", "modifier", element.getModifier(), -1);
        }
        if (element.hasAmount()) {
            this.composeQuantity(t, "NutritionOrder", "amount", element.getAmount(), -1);
        }
    }

    protected void composeNutritionOrderNutritionOrderOralDietTextureComponent(RdfGenerator.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderOralDietTextureComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "texture", name, element, index);
        if (element.hasModifier()) {
            this.composeCodeableConcept(t, "NutritionOrder", "modifier", element.getModifier(), -1);
        }
        if (element.hasFoodType()) {
            this.composeCodeableConcept(t, "NutritionOrder", "foodType", element.getFoodType(), -1);
        }
    }

    protected void composeNutritionOrderNutritionOrderSupplementComponent(RdfGenerator.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderSupplementComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "supplement", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "NutritionOrder", "type", element.getType(), -1);
        }
        if (element.hasProductNameElement()) {
            this.composeString(t, "NutritionOrder", "productName", element.getProductNameElement(), -1);
        }
        for (int i = 0; i < element.getSchedule().size(); ++i) {
            this.composeTiming(t, "NutritionOrder", "schedule", element.getSchedule().get(i), i);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "NutritionOrder", "quantity", element.getQuantity(), -1);
        }
        if (element.hasInstructionElement()) {
            this.composeString(t, "NutritionOrder", "instruction", element.getInstructionElement(), -1);
        }
    }

    protected void composeNutritionOrderNutritionOrderEnteralFormulaComponent(RdfGenerator.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderEnteralFormulaComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "enteralFormula", name, element, index);
        if (element.hasBaseFormulaType()) {
            this.composeCodeableConcept(t, "NutritionOrder", "baseFormulaType", element.getBaseFormulaType(), -1);
        }
        if (element.hasBaseFormulaProductNameElement()) {
            this.composeString(t, "NutritionOrder", "baseFormulaProductName", element.getBaseFormulaProductNameElement(), -1);
        }
        if (element.hasAdditiveType()) {
            this.composeCodeableConcept(t, "NutritionOrder", "additiveType", element.getAdditiveType(), -1);
        }
        if (element.hasAdditiveProductNameElement()) {
            this.composeString(t, "NutritionOrder", "additiveProductName", element.getAdditiveProductNameElement(), -1);
        }
        if (element.hasCaloricDensity()) {
            this.composeQuantity(t, "NutritionOrder", "caloricDensity", element.getCaloricDensity(), -1);
        }
        if (element.hasRouteofAdministration()) {
            this.composeCodeableConcept(t, "NutritionOrder", "routeofAdministration", element.getRouteofAdministration(), -1);
        }
        for (int i = 0; i < element.getAdministration().size(); ++i) {
            this.composeNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(t, "NutritionOrder", "administration", element.getAdministration().get(i), i);
        }
        if (element.hasMaxVolumeToDeliver()) {
            this.composeQuantity(t, "NutritionOrder", "maxVolumeToDeliver", element.getMaxVolumeToDeliver(), -1);
        }
        if (element.hasAdministrationInstructionElement()) {
            this.composeString(t, "NutritionOrder", "administrationInstruction", element.getAdministrationInstructionElement(), -1);
        }
    }

    protected void composeNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(RdfGenerator.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "administration", name, element, index);
        if (element.hasSchedule()) {
            this.composeTiming(t, "NutritionOrder", "schedule", element.getSchedule(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "NutritionOrder", "quantity", element.getQuantity(), -1);
        }
        if (element.hasRate()) {
            this.composeType(t, "NutritionOrder", "rate", element.getRate(), -1);
        }
    }

    protected void composeObservation(RdfGenerator.Complex parent, String parentType, String name, Observation element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Observation", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Observation", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Observation", "status", element.getStatusElement(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "Observation", "category", element.getCategory(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Observation", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Observation", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Observation", "encounter", element.getEncounter(), -1);
        }
        if (element.hasEffective()) {
            this.composeType(t, "Observation", "effective", element.getEffective(), -1);
        }
        if (element.hasIssuedElement()) {
            this.composeInstant(t, "Observation", "issued", element.getIssuedElement(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeReference(t, "Observation", "performer", element.getPerformer().get(i), i);
        }
        if (element.hasValue()) {
            this.composeType(t, "Observation", "value", element.getValue(), -1);
        }
        if (element.hasDataAbsentReason()) {
            this.composeCodeableConcept(t, "Observation", "dataAbsentReason", element.getDataAbsentReason(), -1);
        }
        if (element.hasInterpretation()) {
            this.composeCodeableConcept(t, "Observation", "interpretation", element.getInterpretation(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "Observation", "comment", element.getCommentElement(), -1);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "Observation", "bodySite", element.getBodySite(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "Observation", "method", element.getMethod(), -1);
        }
        if (element.hasSpecimen()) {
            this.composeReference(t, "Observation", "specimen", element.getSpecimen(), -1);
        }
        if (element.hasDevice()) {
            this.composeReference(t, "Observation", "device", element.getDevice(), -1);
        }
        for (i = 0; i < element.getReferenceRange().size(); ++i) {
            this.composeObservationObservationReferenceRangeComponent(t, "Observation", "referenceRange", element.getReferenceRange().get(i), i);
        }
        for (i = 0; i < element.getRelated().size(); ++i) {
            this.composeObservationObservationRelatedComponent(t, "Observation", "related", element.getRelated().get(i), i);
        }
        for (i = 0; i < element.getComponent().size(); ++i) {
            this.composeObservationObservationComponentComponent(t, "Observation", "component", element.getComponent().get(i), i);
        }
    }

    protected void composeObservationObservationReferenceRangeComponent(RdfGenerator.Complex parent, String parentType, String name, Observation.ObservationReferenceRangeComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "referenceRange", name, element, index);
        if (element.hasLow()) {
            this.composeQuantity(t, "Observation", "low", element.getLow(), -1);
        }
        if (element.hasHigh()) {
            this.composeQuantity(t, "Observation", "high", element.getHigh(), -1);
        }
        if (element.hasMeaning()) {
            this.composeCodeableConcept(t, "Observation", "meaning", element.getMeaning(), -1);
        }
        if (element.hasAge()) {
            this.composeRange(t, "Observation", "age", element.getAge(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "Observation", "text", element.getTextElement(), -1);
        }
    }

    protected void composeObservationObservationRelatedComponent(RdfGenerator.Complex parent, String parentType, String name, Observation.ObservationRelatedComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "related", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Observation", "type", element.getTypeElement(), -1);
        }
        if (element.hasTarget()) {
            this.composeReference(t, "Observation", "target", element.getTarget(), -1);
        }
    }

    protected void composeObservationObservationComponentComponent(RdfGenerator.Complex parent, String parentType, String name, Observation.ObservationComponentComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "component", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Observation", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "Observation", "value", element.getValue(), -1);
        }
        if (element.hasDataAbsentReason()) {
            this.composeCodeableConcept(t, "Observation", "dataAbsentReason", element.getDataAbsentReason(), -1);
        }
        for (int i = 0; i < element.getReferenceRange().size(); ++i) {
            this.composeObservationObservationReferenceRangeComponent(t, "Observation", "referenceRange", element.getReferenceRange().get(i), i);
        }
    }

    protected void composeOperationDefinition(RdfGenerator.Complex parent, String parentType, String name, OperationDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "OperationDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "OperationDefinition", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "OperationDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "OperationDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "OperationDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasKindElement()) {
            this.composeEnum(t, "OperationDefinition", "kind", element.getKindElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "OperationDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "OperationDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "OperationDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeOperationDefinitionOperationDefinitionContactComponent(t, "OperationDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "OperationDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeCodeableConcept(t, "OperationDefinition", "useContext", element.getUseContext().get(i), i);
        }
        if (element.hasRequirementsElement()) {
            this.composeString(t, "OperationDefinition", "requirements", element.getRequirementsElement(), -1);
        }
        if (element.hasIdempotentElement()) {
            this.composeBoolean(t, "OperationDefinition", "idempotent", element.getIdempotentElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "OperationDefinition", "code", element.getCodeElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "OperationDefinition", "comment", element.getCommentElement(), -1);
        }
        if (element.hasBase()) {
            this.composeReference(t, "OperationDefinition", "base", element.getBase(), -1);
        }
        if (element.hasSystemElement()) {
            this.composeBoolean(t, "OperationDefinition", "system", element.getSystemElement(), -1);
        }
        for (i = 0; i < element.getType().size(); ++i) {
            this.composeCode(t, "OperationDefinition", "type", element.getType().get(i), i);
        }
        if (element.hasInstanceElement()) {
            this.composeBoolean(t, "OperationDefinition", "instance", element.getInstanceElement(), -1);
        }
        for (i = 0; i < element.getParameter().size(); ++i) {
            this.composeOperationDefinitionOperationDefinitionParameterComponent(t, "OperationDefinition", "parameter", element.getParameter().get(i), i);
        }
    }

    protected void composeOperationDefinitionOperationDefinitionContactComponent(RdfGenerator.Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionContactComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "OperationDefinition", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "OperationDefinition", "telecom", element.getTelecom().get(i), i);
        }
    }

    protected void composeOperationDefinitionOperationDefinitionParameterComponent(RdfGenerator.Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionParameterComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "parameter", name, element, index);
        if (element.hasNameElement()) {
            this.composeCode(t, "OperationDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "OperationDefinition", "use", element.getUseElement(), -1);
        }
        if (element.hasMinElement()) {
            this.composeInteger(t, "OperationDefinition", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "OperationDefinition", "max", element.getMaxElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "OperationDefinition", "documentation", element.getDocumentationElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeCode(t, "OperationDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasSearchTypeElement()) {
            this.composeEnum(t, "OperationDefinition", "searchType", element.getSearchTypeElement(), -1);
        }
        if (element.hasProfile()) {
            this.composeReference(t, "OperationDefinition", "profile", element.getProfile(), -1);
        }
        if (element.hasBinding()) {
            this.composeOperationDefinitionOperationDefinitionParameterBindingComponent(t, "OperationDefinition", "binding", element.getBinding(), -1);
        }
        for (int i = 0; i < element.getPart().size(); ++i) {
            this.composeOperationDefinitionOperationDefinitionParameterComponent(t, "OperationDefinition", "part", element.getPart().get(i), i);
        }
    }

    protected void composeOperationDefinitionOperationDefinitionParameterBindingComponent(RdfGenerator.Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionParameterBindingComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "binding", name, element, index);
        if (element.hasStrengthElement()) {
            this.composeEnum(t, "OperationDefinition", "strength", element.getStrengthElement(), -1);
        }
        if (element.hasValueSet()) {
            this.composeType(t, "OperationDefinition", "valueSet", element.getValueSet(), -1);
        }
    }

    protected void composeOperationOutcome(RdfGenerator.Complex parent, String parentType, String name, OperationOutcome element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "OperationOutcome", name, element, index);
        for (int i = 0; i < element.getIssue().size(); ++i) {
            this.composeOperationOutcomeOperationOutcomeIssueComponent(t, "OperationOutcome", "issue", element.getIssue().get(i), i);
        }
    }

    protected void composeOperationOutcomeOperationOutcomeIssueComponent(RdfGenerator.Complex parent, String parentType, String name, OperationOutcome.OperationOutcomeIssueComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "issue", name, element, index);
        if (element.hasSeverityElement()) {
            this.composeEnum(t, "OperationOutcome", "severity", element.getSeverityElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeEnum(t, "OperationOutcome", "code", element.getCodeElement(), -1);
        }
        if (element.hasDetails()) {
            this.composeCodeableConcept(t, "OperationOutcome", "details", element.getDetails(), -1);
        }
        if (element.hasDiagnosticsElement()) {
            this.composeString(t, "OperationOutcome", "diagnostics", element.getDiagnosticsElement(), -1);
        }
        for (i = 0; i < element.getLocation().size(); ++i) {
            this.composeString(t, "OperationOutcome", "location", element.getLocation().get(i), i);
        }
        for (i = 0; i < element.getExpression().size(); ++i) {
            this.composeString(t, "OperationOutcome", "expression", element.getExpression().get(i), i);
        }
    }

    protected void composeOrder(RdfGenerator.Complex parent, String parentType, String name, Order element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Order", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Order", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Order", "date", element.getDateElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Order", "subject", element.getSubject(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "Order", "source", element.getSource(), -1);
        }
        if (element.hasTarget()) {
            this.composeReference(t, "Order", "target", element.getTarget(), -1);
        }
        if (element.hasReason()) {
            this.composeType(t, "Order", "reason", element.getReason(), -1);
        }
        if (element.hasWhen()) {
            this.composeOrderOrderWhenComponent(t, "Order", "when", element.getWhen(), -1);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composeReference(t, "Order", "detail", element.getDetail().get(i), i);
        }
    }

    protected void composeOrderOrderWhenComponent(RdfGenerator.Complex parent, String parentType, String name, Order.OrderWhenComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "when", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Order", "code", element.getCode(), -1);
        }
        if (element.hasSchedule()) {
            this.composeTiming(t, "Order", "schedule", element.getSchedule(), -1);
        }
    }

    protected void composeOrderResponse(RdfGenerator.Complex parent, String parentType, String name, OrderResponse element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "OrderResponse", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "OrderResponse", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "OrderResponse", "request", element.getRequest(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "OrderResponse", "date", element.getDateElement(), -1);
        }
        if (element.hasWho()) {
            this.composeReference(t, "OrderResponse", "who", element.getWho(), -1);
        }
        if (element.hasOrderStatusElement()) {
            this.composeEnum(t, "OrderResponse", "orderStatus", element.getOrderStatusElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "OrderResponse", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getFulfillment().size(); ++i) {
            this.composeReference(t, "OrderResponse", "fulfillment", element.getFulfillment().get(i), i);
        }
    }

    protected void composeOrderSet(RdfGenerator.Complex parent, String parentType, String name, OrderSet element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "OrderSet", name, element, index);
        if (element.hasModuleMetadata()) {
            this.composeModuleMetadata(t, "OrderSet", "moduleMetadata", element.getModuleMetadata(), -1);
        }
        for (i = 0; i < element.getLibrary().size(); ++i) {
            this.composeReference(t, "OrderSet", "library", element.getLibrary().get(i), i);
        }
        for (i = 0; i < element.getAction().size(); ++i) {
            this.composeActionDefinition(t, "OrderSet", "action", element.getAction().get(i), i);
        }
    }

    protected void composeOrganization(RdfGenerator.Complex parent, String parentType, String name, Organization element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Organization", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Organization", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Organization", "active", element.getActiveElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Organization", "type", element.getType(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Organization", "name", element.getNameElement(), -1);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Organization", "telecom", element.getTelecom().get(i), i);
        }
        for (i = 0; i < element.getAddress().size(); ++i) {
            this.composeAddress(t, "Organization", "address", element.getAddress().get(i), i);
        }
        if (element.hasPartOf()) {
            this.composeReference(t, "Organization", "partOf", element.getPartOf(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeOrganizationOrganizationContactComponent(t, "Organization", "contact", element.getContact().get(i), i);
        }
    }

    protected void composeOrganizationOrganizationContactComponent(RdfGenerator.Complex parent, String parentType, String name, Organization.OrganizationContactComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        if (element.hasPurpose()) {
            this.composeCodeableConcept(t, "Organization", "purpose", element.getPurpose(), -1);
        }
        if (element.hasName()) {
            this.composeHumanName(t, "Organization", "name", element.getName(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Organization", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasAddress()) {
            this.composeAddress(t, "Organization", "address", element.getAddress(), -1);
        }
    }

    protected void composePatient(RdfGenerator.Complex parent, String parentType, String name, Patient element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Patient", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Patient", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Patient", "active", element.getActiveElement(), -1);
        }
        for (i = 0; i < element.getName().size(); ++i) {
            this.composeHumanName(t, "Patient", "name", element.getName().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Patient", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "Patient", "gender", element.getGenderElement(), -1);
        }
        if (element.hasBirthDateElement()) {
            this.composeDate(t, "Patient", "birthDate", element.getBirthDateElement(), -1);
        }
        if (element.hasDeceased()) {
            this.composeType(t, "Patient", "deceased", element.getDeceased(), -1);
        }
        for (i = 0; i < element.getAddress().size(); ++i) {
            this.composeAddress(t, "Patient", "address", element.getAddress().get(i), i);
        }
        if (element.hasMaritalStatus()) {
            this.composeCodeableConcept(t, "Patient", "maritalStatus", element.getMaritalStatus(), -1);
        }
        if (element.hasMultipleBirth()) {
            this.composeType(t, "Patient", "multipleBirth", element.getMultipleBirth(), -1);
        }
        for (i = 0; i < element.getPhoto().size(); ++i) {
            this.composeAttachment(t, "Patient", "photo", element.getPhoto().get(i), i);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composePatientContactComponent(t, "Patient", "contact", element.getContact().get(i), i);
        }
        if (element.hasAnimal()) {
            this.composePatientAnimalComponent(t, "Patient", "animal", element.getAnimal(), -1);
        }
        for (i = 0; i < element.getCommunication().size(); ++i) {
            this.composePatientPatientCommunicationComponent(t, "Patient", "communication", element.getCommunication().get(i), i);
        }
        for (i = 0; i < element.getCareProvider().size(); ++i) {
            this.composeReference(t, "Patient", "careProvider", element.getCareProvider().get(i), i);
        }
        if (element.hasManagingOrganization()) {
            this.composeReference(t, "Patient", "managingOrganization", element.getManagingOrganization(), -1);
        }
        for (i = 0; i < element.getLink().size(); ++i) {
            this.composePatientPatientLinkComponent(t, "Patient", "link", element.getLink().get(i), i);
        }
    }

    protected void composePatientContactComponent(RdfGenerator.Complex parent, String parentType, String name, Patient.ContactComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        for (i = 0; i < element.getRelationship().size(); ++i) {
            this.composeCodeableConcept(t, "Patient", "relationship", element.getRelationship().get(i), i);
        }
        if (element.hasName()) {
            this.composeHumanName(t, "Patient", "name", element.getName(), -1);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Patient", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasAddress()) {
            this.composeAddress(t, "Patient", "address", element.getAddress(), -1);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "Patient", "gender", element.getGenderElement(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "Patient", "organization", element.getOrganization(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Patient", "period", element.getPeriod(), -1);
        }
    }

    protected void composePatientAnimalComponent(RdfGenerator.Complex parent, String parentType, String name, Patient.AnimalComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "animal", name, element, index);
        if (element.hasSpecies()) {
            this.composeCodeableConcept(t, "Patient", "species", element.getSpecies(), -1);
        }
        if (element.hasBreed()) {
            this.composeCodeableConcept(t, "Patient", "breed", element.getBreed(), -1);
        }
        if (element.hasGenderStatus()) {
            this.composeCodeableConcept(t, "Patient", "genderStatus", element.getGenderStatus(), -1);
        }
    }

    protected void composePatientPatientCommunicationComponent(RdfGenerator.Complex parent, String parentType, String name, Patient.PatientCommunicationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "communication", name, element, index);
        if (element.hasLanguage()) {
            this.composeCodeableConcept(t, "Patient", "language", element.getLanguage(), -1);
        }
        if (element.hasPreferredElement()) {
            this.composeBoolean(t, "Patient", "preferred", element.getPreferredElement(), -1);
        }
    }

    protected void composePatientPatientLinkComponent(RdfGenerator.Complex parent, String parentType, String name, Patient.PatientLinkComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "link", name, element, index);
        if (element.hasOther()) {
            this.composeReference(t, "Patient", "other", element.getOther(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Patient", "type", element.getTypeElement(), -1);
        }
    }

    protected void composePaymentNotice(RdfGenerator.Complex parent, String parentType, String name, PaymentNotice element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "PaymentNotice", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "PaymentNotice", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasRuleset()) {
            this.composeCoding(t, "PaymentNotice", "ruleset", element.getRuleset(), -1);
        }
        if (element.hasOriginalRuleset()) {
            this.composeCoding(t, "PaymentNotice", "originalRuleset", element.getOriginalRuleset(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "PaymentNotice", "created", element.getCreatedElement(), -1);
        }
        if (element.hasTarget()) {
            this.composeType(t, "PaymentNotice", "target", element.getTarget(), -1);
        }
        if (element.hasProvider()) {
            this.composeType(t, "PaymentNotice", "provider", element.getProvider(), -1);
        }
        if (element.hasOrganization()) {
            this.composeType(t, "PaymentNotice", "organization", element.getOrganization(), -1);
        }
        if (element.hasRequest()) {
            this.composeType(t, "PaymentNotice", "request", element.getRequest(), -1);
        }
        if (element.hasResponse()) {
            this.composeType(t, "PaymentNotice", "response", element.getResponse(), -1);
        }
        if (element.hasPaymentStatus()) {
            this.composeCoding(t, "PaymentNotice", "paymentStatus", element.getPaymentStatus(), -1);
        }
        if (element.hasStatusDateElement()) {
            this.composeDate(t, "PaymentNotice", "statusDate", element.getStatusDateElement(), -1);
        }
    }

    protected void composePaymentReconciliation(RdfGenerator.Complex parent, String parentType, String name, PaymentReconciliation element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "PaymentReconciliation", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "PaymentReconciliation", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasRequest()) {
            this.composeType(t, "PaymentReconciliation", "request", element.getRequest(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "PaymentReconciliation", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "PaymentReconciliation", "disposition", element.getDispositionElement(), -1);
        }
        if (element.hasRuleset()) {
            this.composeCoding(t, "PaymentReconciliation", "ruleset", element.getRuleset(), -1);
        }
        if (element.hasOriginalRuleset()) {
            this.composeCoding(t, "PaymentReconciliation", "originalRuleset", element.getOriginalRuleset(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "PaymentReconciliation", "created", element.getCreatedElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "PaymentReconciliation", "period", element.getPeriod(), -1);
        }
        if (element.hasOrganization()) {
            this.composeType(t, "PaymentReconciliation", "organization", element.getOrganization(), -1);
        }
        if (element.hasRequestProvider()) {
            this.composeType(t, "PaymentReconciliation", "requestProvider", element.getRequestProvider(), -1);
        }
        if (element.hasRequestOrganization()) {
            this.composeType(t, "PaymentReconciliation", "requestOrganization", element.getRequestOrganization(), -1);
        }
        for (i = 0; i < element.getDetail().size(); ++i) {
            this.composePaymentReconciliationDetailsComponent(t, "PaymentReconciliation", "detail", element.getDetail().get(i), i);
        }
        if (element.hasForm()) {
            this.composeCoding(t, "PaymentReconciliation", "form", element.getForm(), -1);
        }
        if (element.hasTotal()) {
            this.composeQuantity(t, "PaymentReconciliation", "total", element.getTotal(), -1);
        }
        for (i = 0; i < element.getNote().size(); ++i) {
            this.composePaymentReconciliationNotesComponent(t, "PaymentReconciliation", "note", element.getNote().get(i), i);
        }
    }

    protected void composePaymentReconciliationDetailsComponent(RdfGenerator.Complex parent, String parentType, String name, PaymentReconciliation.DetailsComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasType()) {
            this.composeCoding(t, "PaymentReconciliation", "type", element.getType(), -1);
        }
        if (element.hasRequest()) {
            this.composeType(t, "PaymentReconciliation", "request", element.getRequest(), -1);
        }
        if (element.hasResponce()) {
            this.composeType(t, "PaymentReconciliation", "responce", element.getResponce(), -1);
        }
        if (element.hasSubmitter()) {
            this.composeType(t, "PaymentReconciliation", "submitter", element.getSubmitter(), -1);
        }
        if (element.hasPayee()) {
            this.composeType(t, "PaymentReconciliation", "payee", element.getPayee(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDate(t, "PaymentReconciliation", "date", element.getDateElement(), -1);
        }
        if (element.hasAmount()) {
            this.composeQuantity(t, "PaymentReconciliation", "amount", element.getAmount(), -1);
        }
    }

    protected void composePaymentReconciliationNotesComponent(RdfGenerator.Complex parent, String parentType, String name, PaymentReconciliation.NotesComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "note", name, element, index);
        if (element.hasType()) {
            this.composeCoding(t, "PaymentReconciliation", "type", element.getType(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "PaymentReconciliation", "text", element.getTextElement(), -1);
        }
    }

    protected void composePerson(RdfGenerator.Complex parent, String parentType, String name, Person element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Person", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Person", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getName().size(); ++i) {
            this.composeHumanName(t, "Person", "name", element.getName().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Person", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "Person", "gender", element.getGenderElement(), -1);
        }
        if (element.hasBirthDateElement()) {
            this.composeDate(t, "Person", "birthDate", element.getBirthDateElement(), -1);
        }
        for (i = 0; i < element.getAddress().size(); ++i) {
            this.composeAddress(t, "Person", "address", element.getAddress().get(i), i);
        }
        if (element.hasPhoto()) {
            this.composeAttachment(t, "Person", "photo", element.getPhoto(), -1);
        }
        if (element.hasManagingOrganization()) {
            this.composeReference(t, "Person", "managingOrganization", element.getManagingOrganization(), -1);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Person", "active", element.getActiveElement(), -1);
        }
        for (i = 0; i < element.getLink().size(); ++i) {
            this.composePersonPersonLinkComponent(t, "Person", "link", element.getLink().get(i), i);
        }
    }

    protected void composePersonPersonLinkComponent(RdfGenerator.Complex parent, String parentType, String name, Person.PersonLinkComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "link", name, element, index);
        if (element.hasTarget()) {
            this.composeReference(t, "Person", "target", element.getTarget(), -1);
        }
        if (element.hasAssuranceElement()) {
            this.composeEnum(t, "Person", "assurance", element.getAssuranceElement(), -1);
        }
    }

    protected void composePractitioner(RdfGenerator.Complex parent, String parentType, String name, Practitioner element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Practitioner", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Practitioner", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Practitioner", "active", element.getActiveElement(), -1);
        }
        for (i = 0; i < element.getName().size(); ++i) {
            this.composeHumanName(t, "Practitioner", "name", element.getName().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Practitioner", "telecom", element.getTelecom().get(i), i);
        }
        for (i = 0; i < element.getAddress().size(); ++i) {
            this.composeAddress(t, "Practitioner", "address", element.getAddress().get(i), i);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "Practitioner", "gender", element.getGenderElement(), -1);
        }
        if (element.hasBirthDateElement()) {
            this.composeDate(t, "Practitioner", "birthDate", element.getBirthDateElement(), -1);
        }
        for (i = 0; i < element.getPhoto().size(); ++i) {
            this.composeAttachment(t, "Practitioner", "photo", element.getPhoto().get(i), i);
        }
        for (i = 0; i < element.getPractitionerRole().size(); ++i) {
            this.composePractitionerPractitionerPractitionerRoleComponent(t, "Practitioner", "practitionerRole", element.getPractitionerRole().get(i), i);
        }
        for (i = 0; i < element.getQualification().size(); ++i) {
            this.composePractitionerPractitionerQualificationComponent(t, "Practitioner", "qualification", element.getQualification().get(i), i);
        }
        for (i = 0; i < element.getCommunication().size(); ++i) {
            this.composeCodeableConcept(t, "Practitioner", "communication", element.getCommunication().get(i), i);
        }
    }

    protected void composePractitionerPractitionerPractitionerRoleComponent(RdfGenerator.Complex parent, String parentType, String name, Practitioner.PractitionerPractitionerRoleComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "practitionerRole", name, element, index);
        if (element.hasOrganization()) {
            this.composeReference(t, "Practitioner", "organization", element.getOrganization(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "Practitioner", "role", element.getRole(), -1);
        }
        for (i = 0; i < element.getSpecialty().size(); ++i) {
            this.composeCodeableConcept(t, "Practitioner", "specialty", element.getSpecialty().get(i), i);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Practitioner", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Practitioner", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Practitioner", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getLocation().size(); ++i) {
            this.composeReference(t, "Practitioner", "location", element.getLocation().get(i), i);
        }
        for (i = 0; i < element.getHealthcareService().size(); ++i) {
            this.composeReference(t, "Practitioner", "healthcareService", element.getHealthcareService().get(i), i);
        }
    }

    protected void composePractitionerPractitionerQualificationComponent(RdfGenerator.Complex parent, String parentType, String name, Practitioner.PractitionerQualificationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "qualification", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Practitioner", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Practitioner", "code", element.getCode(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Practitioner", "period", element.getPeriod(), -1);
        }
        if (element.hasIssuer()) {
            this.composeReference(t, "Practitioner", "issuer", element.getIssuer(), -1);
        }
    }

    protected void composePractitionerRole(RdfGenerator.Complex parent, String parentType, String name, PractitionerRole element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "PractitionerRole", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "PractitionerRole", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "PractitionerRole", "active", element.getActiveElement(), -1);
        }
        if (element.hasPractitioner()) {
            this.composeReference(t, "PractitionerRole", "practitioner", element.getPractitioner(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "PractitionerRole", "organization", element.getOrganization(), -1);
        }
        for (i = 0; i < element.getRole().size(); ++i) {
            this.composeCodeableConcept(t, "PractitionerRole", "role", element.getRole().get(i), i);
        }
        for (i = 0; i < element.getSpecialty().size(); ++i) {
            this.composeCodeableConcept(t, "PractitionerRole", "specialty", element.getSpecialty().get(i), i);
        }
        for (i = 0; i < element.getLocation().size(); ++i) {
            this.composeReference(t, "PractitionerRole", "location", element.getLocation().get(i), i);
        }
        for (i = 0; i < element.getHealthcareService().size(); ++i) {
            this.composeReference(t, "PractitionerRole", "healthcareService", element.getHealthcareService().get(i), i);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "PractitionerRole", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "PractitionerRole", "period", element.getPeriod(), -1);
        }
        for (i = 0; i < element.getAvailableTime().size(); ++i) {
            this.composePractitionerRolePractitionerRoleAvailableTimeComponent(t, "PractitionerRole", "availableTime", element.getAvailableTime().get(i), i);
        }
        for (i = 0; i < element.getNotAvailable().size(); ++i) {
            this.composePractitionerRolePractitionerRoleNotAvailableComponent(t, "PractitionerRole", "notAvailable", element.getNotAvailable().get(i), i);
        }
        if (element.hasAvailabilityExceptionsElement()) {
            this.composeString(t, "PractitionerRole", "availabilityExceptions", element.getAvailabilityExceptionsElement(), -1);
        }
    }

    protected void composePractitionerRolePractitionerRoleAvailableTimeComponent(RdfGenerator.Complex parent, String parentType, String name, PractitionerRole.PractitionerRoleAvailableTimeComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "availableTime", name, element, index);
        for (int i = 0; i < element.getDaysOfWeek().size(); ++i) {
            this.composeCode(t, "PractitionerRole", "daysOfWeek", element.getDaysOfWeek().get(i), i);
        }
        if (element.hasAllDayElement()) {
            this.composeBoolean(t, "PractitionerRole", "allDay", element.getAllDayElement(), -1);
        }
        if (element.hasAvailableStartTimeElement()) {
            this.composeTime(t, "PractitionerRole", "availableStartTime", element.getAvailableStartTimeElement(), -1);
        }
        if (element.hasAvailableEndTimeElement()) {
            this.composeTime(t, "PractitionerRole", "availableEndTime", element.getAvailableEndTimeElement(), -1);
        }
    }

    protected void composePractitionerRolePractitionerRoleNotAvailableComponent(RdfGenerator.Complex parent, String parentType, String name, PractitionerRole.PractitionerRoleNotAvailableComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "notAvailable", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "PractitionerRole", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasDuring()) {
            this.composePeriod(t, "PractitionerRole", "during", element.getDuring(), -1);
        }
    }

    protected void composeProcedure(RdfGenerator.Complex parent, String parentType, String name, Procedure element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Procedure", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Procedure", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Procedure", "subject", element.getSubject(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Procedure", "status", element.getStatusElement(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "Procedure", "category", element.getCategory(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Procedure", "code", element.getCode(), -1);
        }
        if (element.hasNotPerformedElement()) {
            this.composeBoolean(t, "Procedure", "notPerformed", element.getNotPerformedElement(), -1);
        }
        for (i = 0; i < element.getReasonNotPerformed().size(); ++i) {
            this.composeCodeableConcept(t, "Procedure", "reasonNotPerformed", element.getReasonNotPerformed().get(i), i);
        }
        for (i = 0; i < element.getBodySite().size(); ++i) {
            this.composeCodeableConcept(t, "Procedure", "bodySite", element.getBodySite().get(i), i);
        }
        if (element.hasReason()) {
            this.composeType(t, "Procedure", "reason", element.getReason(), -1);
        }
        for (i = 0; i < element.getPerformer().size(); ++i) {
            this.composeProcedureProcedurePerformerComponent(t, "Procedure", "performer", element.getPerformer().get(i), i);
        }
        if (element.hasPerformed()) {
            this.composeType(t, "Procedure", "performed", element.getPerformed(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Procedure", "encounter", element.getEncounter(), -1);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "Procedure", "location", element.getLocation(), -1);
        }
        if (element.hasOutcome()) {
            this.composeCodeableConcept(t, "Procedure", "outcome", element.getOutcome(), -1);
        }
        for (i = 0; i < element.getReport().size(); ++i) {
            this.composeReference(t, "Procedure", "report", element.getReport().get(i), i);
        }
        for (i = 0; i < element.getComplication().size(); ++i) {
            this.composeCodeableConcept(t, "Procedure", "complication", element.getComplication().get(i), i);
        }
        for (i = 0; i < element.getFollowUp().size(); ++i) {
            this.composeCodeableConcept(t, "Procedure", "followUp", element.getFollowUp().get(i), i);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "Procedure", "request", element.getRequest(), -1);
        }
        for (i = 0; i < element.getNotes().size(); ++i) {
            this.composeAnnotation(t, "Procedure", "notes", element.getNotes().get(i), i);
        }
        for (i = 0; i < element.getFocalDevice().size(); ++i) {
            this.composeProcedureProcedureFocalDeviceComponent(t, "Procedure", "focalDevice", element.getFocalDevice().get(i), i);
        }
        for (i = 0; i < element.getUsed().size(); ++i) {
            this.composeReference(t, "Procedure", "used", element.getUsed().get(i), i);
        }
    }

    protected void composeProcedureProcedurePerformerComponent(RdfGenerator.Complex parent, String parentType, String name, Procedure.ProcedurePerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasActor()) {
            this.composeReference(t, "Procedure", "actor", element.getActor(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "Procedure", "role", element.getRole(), -1);
        }
    }

    protected void composeProcedureProcedureFocalDeviceComponent(RdfGenerator.Complex parent, String parentType, String name, Procedure.ProcedureFocalDeviceComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "focalDevice", name, element, index);
        if (element.hasAction()) {
            this.composeCodeableConcept(t, "Procedure", "action", element.getAction(), -1);
        }
        if (element.hasManipulated()) {
            this.composeReference(t, "Procedure", "manipulated", element.getManipulated(), -1);
        }
    }

    protected void composeProcedureRequest(RdfGenerator.Complex parent, String parentType, String name, ProcedureRequest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ProcedureRequest", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ProcedureRequest", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "ProcedureRequest", "subject", element.getSubject(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ProcedureRequest", "code", element.getCode(), -1);
        }
        for (i = 0; i < element.getBodySite().size(); ++i) {
            this.composeCodeableConcept(t, "ProcedureRequest", "bodySite", element.getBodySite().get(i), i);
        }
        if (element.hasReason()) {
            this.composeType(t, "ProcedureRequest", "reason", element.getReason(), -1);
        }
        if (element.hasScheduled()) {
            this.composeType(t, "ProcedureRequest", "scheduled", element.getScheduled(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "ProcedureRequest", "encounter", element.getEncounter(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "ProcedureRequest", "performer", element.getPerformer(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ProcedureRequest", "status", element.getStatusElement(), -1);
        }
        for (i = 0; i < element.getNotes().size(); ++i) {
            this.composeAnnotation(t, "ProcedureRequest", "notes", element.getNotes().get(i), i);
        }
        if (element.hasAsNeeded()) {
            this.composeType(t, "ProcedureRequest", "asNeeded", element.getAsNeeded(), -1);
        }
        if (element.hasOrderedOnElement()) {
            this.composeDateTime(t, "ProcedureRequest", "orderedOn", element.getOrderedOnElement(), -1);
        }
        if (element.hasOrderer()) {
            this.composeReference(t, "ProcedureRequest", "orderer", element.getOrderer(), -1);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "ProcedureRequest", "priority", element.getPriorityElement(), -1);
        }
    }

    protected void composeProcessRequest(RdfGenerator.Complex parent, String parentType, String name, ProcessRequest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ProcessRequest", name, element, index);
        if (element.hasActionElement()) {
            this.composeEnum(t, "ProcessRequest", "action", element.getActionElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ProcessRequest", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasRuleset()) {
            this.composeCoding(t, "ProcessRequest", "ruleset", element.getRuleset(), -1);
        }
        if (element.hasOriginalRuleset()) {
            this.composeCoding(t, "ProcessRequest", "originalRuleset", element.getOriginalRuleset(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "ProcessRequest", "created", element.getCreatedElement(), -1);
        }
        if (element.hasTarget()) {
            this.composeType(t, "ProcessRequest", "target", element.getTarget(), -1);
        }
        if (element.hasProvider()) {
            this.composeType(t, "ProcessRequest", "provider", element.getProvider(), -1);
        }
        if (element.hasOrganization()) {
            this.composeType(t, "ProcessRequest", "organization", element.getOrganization(), -1);
        }
        if (element.hasRequest()) {
            this.composeType(t, "ProcessRequest", "request", element.getRequest(), -1);
        }
        if (element.hasResponse()) {
            this.composeType(t, "ProcessRequest", "response", element.getResponse(), -1);
        }
        if (element.hasNullifyElement()) {
            this.composeBoolean(t, "ProcessRequest", "nullify", element.getNullifyElement(), -1);
        }
        if (element.hasReferenceElement()) {
            this.composeString(t, "ProcessRequest", "reference", element.getReferenceElement(), -1);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeProcessRequestItemsComponent(t, "ProcessRequest", "item", element.getItem().get(i), i);
        }
        for (i = 0; i < element.getInclude().size(); ++i) {
            this.composeString(t, "ProcessRequest", "include", element.getInclude().get(i), i);
        }
        for (i = 0; i < element.getExclude().size(); ++i) {
            this.composeString(t, "ProcessRequest", "exclude", element.getExclude().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "ProcessRequest", "period", element.getPeriod(), -1);
        }
    }

    protected void composeProcessRequestItemsComponent(RdfGenerator.Complex parent, String parentType, String name, ProcessRequest.ItemsComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasSequenceLinkIdElement()) {
            this.composeInteger(t, "ProcessRequest", "sequenceLinkId", element.getSequenceLinkIdElement(), -1);
        }
    }

    protected void composeProcessResponse(RdfGenerator.Complex parent, String parentType, String name, ProcessResponse element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ProcessResponse", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ProcessResponse", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasRequest()) {
            this.composeType(t, "ProcessResponse", "request", element.getRequest(), -1);
        }
        if (element.hasOutcome()) {
            this.composeCoding(t, "ProcessResponse", "outcome", element.getOutcome(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "ProcessResponse", "disposition", element.getDispositionElement(), -1);
        }
        if (element.hasRuleset()) {
            this.composeCoding(t, "ProcessResponse", "ruleset", element.getRuleset(), -1);
        }
        if (element.hasOriginalRuleset()) {
            this.composeCoding(t, "ProcessResponse", "originalRuleset", element.getOriginalRuleset(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "ProcessResponse", "created", element.getCreatedElement(), -1);
        }
        if (element.hasOrganization()) {
            this.composeType(t, "ProcessResponse", "organization", element.getOrganization(), -1);
        }
        if (element.hasRequestProvider()) {
            this.composeType(t, "ProcessResponse", "requestProvider", element.getRequestProvider(), -1);
        }
        if (element.hasRequestOrganization()) {
            this.composeType(t, "ProcessResponse", "requestOrganization", element.getRequestOrganization(), -1);
        }
        if (element.hasForm()) {
            this.composeCoding(t, "ProcessResponse", "form", element.getForm(), -1);
        }
        for (i = 0; i < element.getNotes().size(); ++i) {
            this.composeProcessResponseProcessResponseNotesComponent(t, "ProcessResponse", "notes", element.getNotes().get(i), i);
        }
        for (i = 0; i < element.getError().size(); ++i) {
            this.composeCoding(t, "ProcessResponse", "error", element.getError().get(i), i);
        }
    }

    protected void composeProcessResponseProcessResponseNotesComponent(RdfGenerator.Complex parent, String parentType, String name, ProcessResponse.ProcessResponseNotesComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "notes", name, element, index);
        if (element.hasType()) {
            this.composeCoding(t, "ProcessResponse", "type", element.getType(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "ProcessResponse", "text", element.getTextElement(), -1);
        }
    }

    protected void composeProtocol(RdfGenerator.Complex parent, String parentType, String name, Protocol element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Protocol", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Protocol", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Protocol", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Protocol", "status", element.getStatusElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Protocol", "type", element.getTypeElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Protocol", "subject", element.getSubject(), -1);
        }
        if (element.hasGroup()) {
            this.composeReference(t, "Protocol", "group", element.getGroup(), -1);
        }
        if (element.hasPurposeElement()) {
            this.composeString(t, "Protocol", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "Protocol", "author", element.getAuthor(), -1);
        }
        for (i = 0; i < element.getStep().size(); ++i) {
            this.composeProtocolProtocolStepComponent(t, "Protocol", "step", element.getStep().get(i), i);
        }
    }

    protected void composeProtocolProtocolStepComponent(RdfGenerator.Complex parent, String parentType, String name, Protocol.ProtocolStepComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "step", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "Protocol", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Protocol", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasDuration()) {
            this.composeQuantity(t, "Protocol", "duration", element.getDuration(), -1);
        }
        if (element.hasPrecondition()) {
            this.composeProtocolProtocolStepPreconditionComponent(t, "Protocol", "precondition", element.getPrecondition(), -1);
        }
        if (element.hasExit()) {
            this.composeProtocolProtocolStepPreconditionComponent(t, "Protocol", "exit", element.getExit(), -1);
        }
        if (element.hasFirstActivityElement()) {
            this.composeUri(t, "Protocol", "firstActivity", element.getFirstActivityElement(), -1);
        }
        for (i = 0; i < element.getActivity().size(); ++i) {
            this.composeProtocolProtocolStepActivityComponent(t, "Protocol", "activity", element.getActivity().get(i), i);
        }
        for (i = 0; i < element.getNext().size(); ++i) {
            this.composeProtocolProtocolStepNextComponent(t, "Protocol", "next", element.getNext().get(i), i);
        }
    }

    protected void composeProtocolProtocolStepPreconditionComponent(RdfGenerator.Complex parent, String parentType, String name, Protocol.ProtocolStepPreconditionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "precondition", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Protocol", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasCondition()) {
            this.composeProtocolProtocolStepPreconditionConditionComponent(t, "Protocol", "condition", element.getCondition(), -1);
        }
        for (i = 0; i < element.getIntersection().size(); ++i) {
            this.composeProtocolProtocolStepPreconditionComponent(t, "Protocol", "intersection", element.getIntersection().get(i), i);
        }
        for (i = 0; i < element.getUnion().size(); ++i) {
            this.composeProtocolProtocolStepPreconditionComponent(t, "Protocol", "union", element.getUnion().get(i), i);
        }
        for (i = 0; i < element.getExclude().size(); ++i) {
            this.composeProtocolProtocolStepPreconditionComponent(t, "Protocol", "exclude", element.getExclude().get(i), i);
        }
    }

    protected void composeProtocolProtocolStepPreconditionConditionComponent(RdfGenerator.Complex parent, String parentType, String name, Protocol.ProtocolStepPreconditionConditionComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "condition", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Protocol", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "Protocol", "value", element.getValue(), -1);
        }
    }

    protected void composeProtocolProtocolStepActivityComponent(RdfGenerator.Complex parent, String parentType, String name, Protocol.ProtocolStepActivityComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "activity", name, element, index);
        for (i = 0; i < element.getAlternative().size(); ++i) {
            this.composeUri(t, "Protocol", "alternative", element.getAlternative().get(i), i);
        }
        for (i = 0; i < element.getComponent().size(); ++i) {
            this.composeProtocolProtocolStepActivityComponentComponent(t, "Protocol", "component", element.getComponent().get(i), i);
        }
        for (i = 0; i < element.getFollowing().size(); ++i) {
            this.composeUri(t, "Protocol", "following", element.getFollowing().get(i), i);
        }
        if (element.hasWait()) {
            this.composeQuantity(t, "Protocol", "wait", element.getWait(), -1);
        }
        if (element.hasDetail()) {
            this.composeProtocolProtocolStepActivityDetailComponent(t, "Protocol", "detail", element.getDetail(), -1);
        }
    }

    protected void composeProtocolProtocolStepActivityComponentComponent(RdfGenerator.Complex parent, String parentType, String name, Protocol.ProtocolStepActivityComponentComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "component", name, element, index);
        if (element.hasSequenceElement()) {
            this.composeInteger(t, "Protocol", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasActivityElement()) {
            this.composeUri(t, "Protocol", "activity", element.getActivityElement(), -1);
        }
    }

    protected void composeProtocolProtocolStepActivityDetailComponent(RdfGenerator.Complex parent, String parentType, String name, Protocol.ProtocolStepActivityDetailComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasCategoryElement()) {
            this.composeEnum(t, "Protocol", "category", element.getCategoryElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Protocol", "code", element.getCode(), -1);
        }
        if (element.hasTiming()) {
            this.composeType(t, "Protocol", "timing", element.getTiming(), -1);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "Protocol", "location", element.getLocation(), -1);
        }
        for (int i = 0; i < element.getPerformer().size(); ++i) {
            this.composeReference(t, "Protocol", "performer", element.getPerformer().get(i), i);
        }
        if (element.hasProduct()) {
            this.composeReference(t, "Protocol", "product", element.getProduct(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "Protocol", "quantity", element.getQuantity(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Protocol", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeProtocolProtocolStepNextComponent(RdfGenerator.Complex parent, String parentType, String name, Protocol.ProtocolStepNextComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "next", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Protocol", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasReferenceElement()) {
            this.composeUri(t, "Protocol", "reference", element.getReferenceElement(), -1);
        }
        if (element.hasCondition()) {
            this.composeProtocolProtocolStepPreconditionComponent(t, "Protocol", "condition", element.getCondition(), -1);
        }
    }

    protected void composeProvenance(RdfGenerator.Complex parent, String parentType, String name, Provenance element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Provenance", name, element, index);
        for (i = 0; i < element.getTarget().size(); ++i) {
            this.composeReference(t, "Provenance", "target", element.getTarget().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Provenance", "period", element.getPeriod(), -1);
        }
        if (element.hasRecordedElement()) {
            this.composeInstant(t, "Provenance", "recorded", element.getRecordedElement(), -1);
        }
        for (i = 0; i < element.getReason().size(); ++i) {
            this.composeCoding(t, "Provenance", "reason", element.getReason().get(i), i);
        }
        if (element.hasActivity()) {
            this.composeCoding(t, "Provenance", "activity", element.getActivity(), -1);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "Provenance", "location", element.getLocation(), -1);
        }
        for (i = 0; i < element.getPolicy().size(); ++i) {
            this.composeUri(t, "Provenance", "policy", element.getPolicy().get(i), i);
        }
        for (i = 0; i < element.getAgent().size(); ++i) {
            this.composeProvenanceProvenanceAgentComponent(t, "Provenance", "agent", element.getAgent().get(i), i);
        }
        for (i = 0; i < element.getEntity().size(); ++i) {
            this.composeProvenanceProvenanceEntityComponent(t, "Provenance", "entity", element.getEntity().get(i), i);
        }
        for (i = 0; i < element.getSignature().size(); ++i) {
            this.composeSignature(t, "Provenance", "signature", element.getSignature().get(i), i);
        }
    }

    protected void composeProvenanceProvenanceAgentComponent(RdfGenerator.Complex parent, String parentType, String name, Provenance.ProvenanceAgentComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "agent", name, element, index);
        if (element.hasRole()) {
            this.composeCoding(t, "Provenance", "role", element.getRole(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "Provenance", "actor", element.getActor(), -1);
        }
        if (element.hasUserId()) {
            this.composeIdentifier(t, "Provenance", "userId", element.getUserId(), -1);
        }
        for (int i = 0; i < element.getRelatedAgent().size(); ++i) {
            this.composeProvenanceProvenanceAgentRelatedAgentComponent(t, "Provenance", "relatedAgent", element.getRelatedAgent().get(i), i);
        }
    }

    protected void composeProvenanceProvenanceAgentRelatedAgentComponent(RdfGenerator.Complex parent, String parentType, String name, Provenance.ProvenanceAgentRelatedAgentComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "relatedAgent", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Provenance", "type", element.getType(), -1);
        }
        if (element.hasTargetElement()) {
            this.composeUri(t, "Provenance", "target", element.getTargetElement(), -1);
        }
    }

    protected void composeProvenanceProvenanceEntityComponent(RdfGenerator.Complex parent, String parentType, String name, Provenance.ProvenanceEntityComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "entity", name, element, index);
        if (element.hasRoleElement()) {
            this.composeEnum(t, "Provenance", "role", element.getRoleElement(), -1);
        }
        if (element.hasType()) {
            this.composeCoding(t, "Provenance", "type", element.getType(), -1);
        }
        if (element.hasReferenceElement()) {
            this.composeUri(t, "Provenance", "reference", element.getReferenceElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "Provenance", "display", element.getDisplayElement(), -1);
        }
        if (element.hasAgent()) {
            this.composeProvenanceProvenanceAgentComponent(t, "Provenance", "agent", element.getAgent(), -1);
        }
    }

    protected void composeQuestionnaire(RdfGenerator.Complex parent, String parentType, String name, Questionnaire element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Questionnaire", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "Questionnaire", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Questionnaire", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Questionnaire", "version", element.getVersionElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Questionnaire", "status", element.getStatusElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Questionnaire", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "Questionnaire", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "Questionnaire", "telecom", element.getTelecom().get(i), i);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeCodeableConcept(t, "Questionnaire", "useContext", element.getUseContext().get(i), i);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Questionnaire", "title", element.getTitleElement(), -1);
        }
        for (i = 0; i < element.getConcept().size(); ++i) {
            this.composeCoding(t, "Questionnaire", "concept", element.getConcept().get(i), i);
        }
        for (i = 0; i < element.getSubjectType().size(); ++i) {
            this.composeCode(t, "Questionnaire", "subjectType", element.getSubjectType().get(i), i);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeQuestionnaireQuestionnaireItemComponent(t, "Questionnaire", "item", element.getItem().get(i), i);
        }
    }

    protected void composeQuestionnaireQuestionnaireItemComponent(RdfGenerator.Complex parent, String parentType, String name, Questionnaire.QuestionnaireItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasLinkIdElement()) {
            this.composeString(t, "Questionnaire", "linkId", element.getLinkIdElement(), -1);
        }
        for (i = 0; i < element.getConcept().size(); ++i) {
            this.composeCoding(t, "Questionnaire", "concept", element.getConcept().get(i), i);
        }
        if (element.hasPrefixElement()) {
            this.composeString(t, "Questionnaire", "prefix", element.getPrefixElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "Questionnaire", "text", element.getTextElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Questionnaire", "type", element.getTypeElement(), -1);
        }
        for (i = 0; i < element.getEnableWhen().size(); ++i) {
            this.composeQuestionnaireQuestionnaireItemEnableWhenComponent(t, "Questionnaire", "enableWhen", element.getEnableWhen().get(i), i);
        }
        if (element.hasRequiredElement()) {
            this.composeBoolean(t, "Questionnaire", "required", element.getRequiredElement(), -1);
        }
        if (element.hasRepeatsElement()) {
            this.composeBoolean(t, "Questionnaire", "repeats", element.getRepeatsElement(), -1);
        }
        if (element.hasReadOnlyElement()) {
            this.composeBoolean(t, "Questionnaire", "readOnly", element.getReadOnlyElement(), -1);
        }
        if (element.hasMaxLengthElement()) {
            this.composeInteger(t, "Questionnaire", "maxLength", element.getMaxLengthElement(), -1);
        }
        if (element.hasOptions()) {
            this.composeReference(t, "Questionnaire", "options", element.getOptions(), -1);
        }
        for (i = 0; i < element.getOption().size(); ++i) {
            this.composeQuestionnaireQuestionnaireItemOptionComponent(t, "Questionnaire", "option", element.getOption().get(i), i);
        }
        if (element.hasInitial()) {
            this.composeType(t, "Questionnaire", "initial", element.getInitial(), -1);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeQuestionnaireQuestionnaireItemComponent(t, "Questionnaire", "item", element.getItem().get(i), i);
        }
    }

    protected void composeQuestionnaireQuestionnaireItemEnableWhenComponent(RdfGenerator.Complex parent, String parentType, String name, Questionnaire.QuestionnaireItemEnableWhenComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "enableWhen", name, element, index);
        if (element.hasQuestionElement()) {
            this.composeString(t, "Questionnaire", "question", element.getQuestionElement(), -1);
        }
        if (element.hasAnsweredElement()) {
            this.composeBoolean(t, "Questionnaire", "answered", element.getAnsweredElement(), -1);
        }
        if (element.hasAnswer()) {
            this.composeType(t, "Questionnaire", "answer", element.getAnswer(), -1);
        }
    }

    protected void composeQuestionnaireQuestionnaireItemOptionComponent(RdfGenerator.Complex parent, String parentType, String name, Questionnaire.QuestionnaireItemOptionComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "option", name, element, index);
        if (element.hasValue()) {
            this.composeType(t, "Questionnaire", "value", element.getValue(), -1);
        }
    }

    protected void composeQuestionnaireResponse(RdfGenerator.Complex parent, String parentType, String name, QuestionnaireResponse element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "QuestionnaireResponse", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "QuestionnaireResponse", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasQuestionnaire()) {
            this.composeReference(t, "QuestionnaireResponse", "questionnaire", element.getQuestionnaire(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "QuestionnaireResponse", "status", element.getStatusElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "QuestionnaireResponse", "subject", element.getSubject(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "QuestionnaireResponse", "author", element.getAuthor(), -1);
        }
        if (element.hasAuthoredElement()) {
            this.composeDateTime(t, "QuestionnaireResponse", "authored", element.getAuthoredElement(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "QuestionnaireResponse", "source", element.getSource(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "QuestionnaireResponse", "encounter", element.getEncounter(), -1);
        }
        for (int i = 0; i < element.getItem().size(); ++i) {
            this.composeQuestionnaireResponseQuestionnaireResponseItemComponent(t, "QuestionnaireResponse", "item", element.getItem().get(i), i);
        }
    }

    protected void composeQuestionnaireResponseQuestionnaireResponseItemComponent(RdfGenerator.Complex parent, String parentType, String name, QuestionnaireResponse.QuestionnaireResponseItemComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasLinkIdElement()) {
            this.composeString(t, "QuestionnaireResponse", "linkId", element.getLinkIdElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "QuestionnaireResponse", "text", element.getTextElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "QuestionnaireResponse", "subject", element.getSubject(), -1);
        }
        for (i = 0; i < element.getAnswer().size(); ++i) {
            this.composeQuestionnaireResponseQuestionnaireResponseItemAnswerComponent(t, "QuestionnaireResponse", "answer", element.getAnswer().get(i), i);
        }
        for (i = 0; i < element.getItem().size(); ++i) {
            this.composeQuestionnaireResponseQuestionnaireResponseItemComponent(t, "QuestionnaireResponse", "item", element.getItem().get(i), i);
        }
    }

    protected void composeQuestionnaireResponseQuestionnaireResponseItemAnswerComponent(RdfGenerator.Complex parent, String parentType, String name, QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "answer", name, element, index);
        if (element.hasValue()) {
            this.composeType(t, "QuestionnaireResponse", "value", element.getValue(), -1);
        }
        for (int i = 0; i < element.getItem().size(); ++i) {
            this.composeQuestionnaireResponseQuestionnaireResponseItemComponent(t, "QuestionnaireResponse", "item", element.getItem().get(i), i);
        }
    }

    protected void composeReferralRequest(RdfGenerator.Complex parent, String parentType, String name, ReferralRequest element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ReferralRequest", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "ReferralRequest", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getBasedOn().size(); ++i) {
            this.composeReference(t, "ReferralRequest", "basedOn", element.getBasedOn().get(i), i);
        }
        if (element.hasParent()) {
            this.composeIdentifier(t, "ReferralRequest", "parent", element.getParent(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ReferralRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasCategoryElement()) {
            this.composeEnum(t, "ReferralRequest", "category", element.getCategoryElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ReferralRequest", "type", element.getType(), -1);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "ReferralRequest", "priority", element.getPriority(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "ReferralRequest", "patient", element.getPatient(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "ReferralRequest", "context", element.getContext(), -1);
        }
        if (element.hasFulfillmentTime()) {
            this.composePeriod(t, "ReferralRequest", "fulfillmentTime", element.getFulfillmentTime(), -1);
        }
        if (element.hasAuthoredElement()) {
            this.composeDateTime(t, "ReferralRequest", "authored", element.getAuthoredElement(), -1);
        }
        if (element.hasRequester()) {
            this.composeReference(t, "ReferralRequest", "requester", element.getRequester(), -1);
        }
        if (element.hasSpecialty()) {
            this.composeCodeableConcept(t, "ReferralRequest", "specialty", element.getSpecialty(), -1);
        }
        for (i = 0; i < element.getRecipient().size(); ++i) {
            this.composeReference(t, "ReferralRequest", "recipient", element.getRecipient().get(i), i);
        }
        if (element.hasReason()) {
            this.composeCodeableConcept(t, "ReferralRequest", "reason", element.getReason(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ReferralRequest", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getServiceRequested().size(); ++i) {
            this.composeCodeableConcept(t, "ReferralRequest", "serviceRequested", element.getServiceRequested().get(i), i);
        }
        for (i = 0; i < element.getSupportingInformation().size(); ++i) {
            this.composeReference(t, "ReferralRequest", "supportingInformation", element.getSupportingInformation().get(i), i);
        }
    }

    protected void composeRelatedPerson(RdfGenerator.Complex parent, String parentType, String name, RelatedPerson element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "RelatedPerson", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "RelatedPerson", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "RelatedPerson", "patient", element.getPatient(), -1);
        }
        if (element.hasRelationship()) {
            this.composeCodeableConcept(t, "RelatedPerson", "relationship", element.getRelationship(), -1);
        }
        if (element.hasName()) {
            this.composeHumanName(t, "RelatedPerson", "name", element.getName(), -1);
        }
        for (i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "RelatedPerson", "telecom", element.getTelecom().get(i), i);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "RelatedPerson", "gender", element.getGenderElement(), -1);
        }
        if (element.hasBirthDateElement()) {
            this.composeDate(t, "RelatedPerson", "birthDate", element.getBirthDateElement(), -1);
        }
        for (i = 0; i < element.getAddress().size(); ++i) {
            this.composeAddress(t, "RelatedPerson", "address", element.getAddress().get(i), i);
        }
        for (i = 0; i < element.getPhoto().size(); ++i) {
            this.composeAttachment(t, "RelatedPerson", "photo", element.getPhoto().get(i), i);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "RelatedPerson", "period", element.getPeriod(), -1);
        }
    }

    protected void composeRiskAssessment(RdfGenerator.Complex parent, String parentType, String name, RiskAssessment element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "RiskAssessment", name, element, index);
        if (element.hasSubject()) {
            this.composeReference(t, "RiskAssessment", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "RiskAssessment", "date", element.getDateElement(), -1);
        }
        if (element.hasCondition()) {
            this.composeReference(t, "RiskAssessment", "condition", element.getCondition(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "RiskAssessment", "encounter", element.getEncounter(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "RiskAssessment", "performer", element.getPerformer(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "RiskAssessment", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "RiskAssessment", "method", element.getMethod(), -1);
        }
        for (i = 0; i < element.getBasis().size(); ++i) {
            this.composeReference(t, "RiskAssessment", "basis", element.getBasis().get(i), i);
        }
        for (i = 0; i < element.getPrediction().size(); ++i) {
            this.composeRiskAssessmentRiskAssessmentPredictionComponent(t, "RiskAssessment", "prediction", element.getPrediction().get(i), i);
        }
        if (element.hasMitigationElement()) {
            this.composeString(t, "RiskAssessment", "mitigation", element.getMitigationElement(), -1);
        }
    }

    protected void composeRiskAssessmentRiskAssessmentPredictionComponent(RdfGenerator.Complex parent, String parentType, String name, RiskAssessment.RiskAssessmentPredictionComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "prediction", name, element, index);
        if (element.hasOutcome()) {
            this.composeCodeableConcept(t, "RiskAssessment", "outcome", element.getOutcome(), -1);
        }
        if (element.hasProbability()) {
            this.composeType(t, "RiskAssessment", "probability", element.getProbability(), -1);
        }
        if (element.hasRelativeRiskElement()) {
            this.composeDecimal(t, "RiskAssessment", "relativeRisk", element.getRelativeRiskElement(), -1);
        }
        if (element.hasWhen()) {
            this.composeType(t, "RiskAssessment", "when", element.getWhen(), -1);
        }
        if (element.hasRationaleElement()) {
            this.composeString(t, "RiskAssessment", "rationale", element.getRationaleElement(), -1);
        }
    }

    protected void composeSchedule(RdfGenerator.Complex parent, String parentType, String name, Schedule element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Schedule", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Schedule", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasServiceCategory()) {
            this.composeCodeableConcept(t, "Schedule", "serviceCategory", element.getServiceCategory(), -1);
        }
        for (i = 0; i < element.getServiceType().size(); ++i) {
            this.composeCodeableConcept(t, "Schedule", "serviceType", element.getServiceType().get(i), i);
        }
        for (i = 0; i < element.getSpecialty().size(); ++i) {
            this.composeCodeableConcept(t, "Schedule", "specialty", element.getSpecialty().get(i), i);
        }
        if (element.hasActor()) {
            this.composeReference(t, "Schedule", "actor", element.getActor(), -1);
        }
        if (element.hasPlanningHorizon()) {
            this.composePeriod(t, "Schedule", "planningHorizon", element.getPlanningHorizon(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "Schedule", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeSearchParameter(RdfGenerator.Complex parent, String parentType, String name, SearchParameter element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "SearchParameter", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "SearchParameter", "url", element.getUrlElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "SearchParameter", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "SearchParameter", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "SearchParameter", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "SearchParameter", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "SearchParameter", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeSearchParameterSearchParameterContactComponent(t, "SearchParameter", "contact", element.getContact().get(i), i);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeCodeableConcept(t, "SearchParameter", "useContext", element.getUseContext().get(i), i);
        }
        if (element.hasRequirementsElement()) {
            this.composeString(t, "SearchParameter", "requirements", element.getRequirementsElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "SearchParameter", "code", element.getCodeElement(), -1);
        }
        if (element.hasBaseElement()) {
            this.composeCode(t, "SearchParameter", "base", element.getBaseElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "SearchParameter", "type", element.getTypeElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "SearchParameter", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "SearchParameter", "expression", element.getExpressionElement(), -1);
        }
        if (element.hasXpathElement()) {
            this.composeString(t, "SearchParameter", "xpath", element.getXpathElement(), -1);
        }
        if (element.hasXpathUsageElement()) {
            this.composeEnum(t, "SearchParameter", "xpathUsage", element.getXpathUsageElement(), -1);
        }
        for (i = 0; i < element.getTarget().size(); ++i) {
            this.composeCode(t, "SearchParameter", "target", element.getTarget().get(i), i);
        }
    }

    protected void composeSearchParameterSearchParameterContactComponent(RdfGenerator.Complex parent, String parentType, String name, SearchParameter.SearchParameterContactComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "SearchParameter", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "SearchParameter", "telecom", element.getTelecom().get(i), i);
        }
    }

    protected void composeSequence(RdfGenerator.Complex parent, String parentType, String name, Sequence element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Sequence", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Sequence", "type", element.getTypeElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "Sequence", "patient", element.getPatient(), -1);
        }
        if (element.hasSpecimen()) {
            this.composeReference(t, "Sequence", "specimen", element.getSpecimen(), -1);
        }
        if (element.hasDevice()) {
            this.composeReference(t, "Sequence", "device", element.getDevice(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "Sequence", "quantity", element.getQuantity(), -1);
        }
        if (element.hasSpecies()) {
            this.composeCodeableConcept(t, "Sequence", "species", element.getSpecies(), -1);
        }
        for (i = 0; i < element.getReferenceSeq().size(); ++i) {
            this.composeSequenceSequenceReferenceSeqComponent(t, "Sequence", "referenceSeq", element.getReferenceSeq().get(i), i);
        }
        if (element.hasVariation()) {
            this.composeSequenceSequenceVariationComponent(t, "Sequence", "variation", element.getVariation(), -1);
        }
        for (i = 0; i < element.getQuality().size(); ++i) {
            this.composeSequenceSequenceQualityComponent(t, "Sequence", "quality", element.getQuality().get(i), i);
        }
        if (element.hasAllelicState()) {
            this.composeCodeableConcept(t, "Sequence", "allelicState", element.getAllelicState(), -1);
        }
        if (element.hasAllelicFrequencyElement()) {
            this.composeDecimal(t, "Sequence", "allelicFrequency", element.getAllelicFrequencyElement(), -1);
        }
        if (element.hasCopyNumberEvent()) {
            this.composeCodeableConcept(t, "Sequence", "copyNumberEvent", element.getCopyNumberEvent(), -1);
        }
        if (element.hasReadCoverageElement()) {
            this.composeInteger(t, "Sequence", "readCoverage", element.getReadCoverageElement(), -1);
        }
        for (i = 0; i < element.getRepository().size(); ++i) {
            this.composeSequenceSequenceRepositoryComponent(t, "Sequence", "repository", element.getRepository().get(i), i);
        }
        for (i = 0; i < element.getPointer().size(); ++i) {
            this.composeReference(t, "Sequence", "pointer", element.getPointer().get(i), i);
        }
        if (element.hasObservedSeqElement()) {
            this.composeString(t, "Sequence", "observedSeq", element.getObservedSeqElement(), -1);
        }
        if (element.hasObservation()) {
            this.composeReference(t, "Sequence", "observation", element.getObservation(), -1);
        }
        if (element.hasStructureVariation()) {
            this.composeSequenceSequenceStructureVariationComponent(t, "Sequence", "structureVariation", element.getStructureVariation(), -1);
        }
    }

    protected void composeSequenceSequenceReferenceSeqComponent(RdfGenerator.Complex parent, String parentType, String name, Sequence.SequenceReferenceSeqComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "referenceSeq", name, element, index);
        if (element.hasChromosome()) {
            this.composeCodeableConcept(t, "Sequence", "chromosome", element.getChromosome(), -1);
        }
        if (element.hasGenomeBuildElement()) {
            this.composeString(t, "Sequence", "genomeBuild", element.getGenomeBuildElement(), -1);
        }
        if (element.hasReferenceSeqId()) {
            this.composeCodeableConcept(t, "Sequence", "referenceSeqId", element.getReferenceSeqId(), -1);
        }
        if (element.hasReferenceSeqPointer()) {
            this.composeReference(t, "Sequence", "referenceSeqPointer", element.getReferenceSeqPointer(), -1);
        }
        if (element.hasReferenceSeqStringElement()) {
            this.composeString(t, "Sequence", "referenceSeqString", element.getReferenceSeqStringElement(), -1);
        }
        if (element.hasWindowStartElement()) {
            this.composeInteger(t, "Sequence", "windowStart", element.getWindowStartElement(), -1);
        }
        if (element.hasWindowEndElement()) {
            this.composeInteger(t, "Sequence", "windowEnd", element.getWindowEndElement(), -1);
        }
    }

    protected void composeSequenceSequenceVariationComponent(RdfGenerator.Complex parent, String parentType, String name, Sequence.SequenceVariationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "variation", name, element, index);
        if (element.hasStartElement()) {
            this.composeInteger(t, "Sequence", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInteger(t, "Sequence", "end", element.getEndElement(), -1);
        }
        if (element.hasObservedAlleleElement()) {
            this.composeString(t, "Sequence", "observedAllele", element.getObservedAlleleElement(), -1);
        }
        if (element.hasReferenceAlleleElement()) {
            this.composeString(t, "Sequence", "referenceAllele", element.getReferenceAlleleElement(), -1);
        }
        if (element.hasCigarElement()) {
            this.composeString(t, "Sequence", "cigar", element.getCigarElement(), -1);
        }
    }

    protected void composeSequenceSequenceQualityComponent(RdfGenerator.Complex parent, String parentType, String name, Sequence.SequenceQualityComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "quality", name, element, index);
        if (element.hasStartElement()) {
            this.composeInteger(t, "Sequence", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInteger(t, "Sequence", "end", element.getEndElement(), -1);
        }
        if (element.hasScore()) {
            this.composeQuantity(t, "Sequence", "score", element.getScore(), -1);
        }
        if (element.hasMethodElement()) {
            this.composeString(t, "Sequence", "method", element.getMethodElement(), -1);
        }
    }

    protected void composeSequenceSequenceRepositoryComponent(RdfGenerator.Complex parent, String parentType, String name, Sequence.SequenceRepositoryComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "repository", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "Sequence", "url", element.getUrlElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Sequence", "name", element.getNameElement(), -1);
        }
        if (element.hasVariantIdElement()) {
            this.composeString(t, "Sequence", "variantId", element.getVariantIdElement(), -1);
        }
        if (element.hasReadIdElement()) {
            this.composeString(t, "Sequence", "readId", element.getReadIdElement(), -1);
        }
    }

    protected void composeSequenceSequenceStructureVariationComponent(RdfGenerator.Complex parent, String parentType, String name, Sequence.SequenceStructureVariationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "structureVariation", name, element, index);
        if (element.hasPrecisionOfBoundariesElement()) {
            this.composeString(t, "Sequence", "precisionOfBoundaries", element.getPrecisionOfBoundariesElement(), -1);
        }
        if (element.hasReportedaCGHRatioElement()) {
            this.composeDecimal(t, "Sequence", "reportedaCGHRatio", element.getReportedaCGHRatioElement(), -1);
        }
        if (element.hasLengthElement()) {
            this.composeInteger(t, "Sequence", "length", element.getLengthElement(), -1);
        }
        if (element.hasOuter()) {
            this.composeSequenceSequenceStructureVariationOuterComponent(t, "Sequence", "outer", element.getOuter(), -1);
        }
        if (element.hasInner()) {
            this.composeSequenceSequenceStructureVariationInnerComponent(t, "Sequence", "inner", element.getInner(), -1);
        }
    }

    protected void composeSequenceSequenceStructureVariationOuterComponent(RdfGenerator.Complex parent, String parentType, String name, Sequence.SequenceStructureVariationOuterComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "outer", name, element, index);
        if (element.hasStartElement()) {
            this.composeInteger(t, "Sequence", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInteger(t, "Sequence", "end", element.getEndElement(), -1);
        }
    }

    protected void composeSequenceSequenceStructureVariationInnerComponent(RdfGenerator.Complex parent, String parentType, String name, Sequence.SequenceStructureVariationInnerComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "inner", name, element, index);
        if (element.hasStartElement()) {
            this.composeInteger(t, "Sequence", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInteger(t, "Sequence", "end", element.getEndElement(), -1);
        }
    }

    protected void composeSlot(RdfGenerator.Complex parent, String parentType, String name, Slot element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Slot", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Slot", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasServiceCategory()) {
            this.composeCodeableConcept(t, "Slot", "serviceCategory", element.getServiceCategory(), -1);
        }
        for (i = 0; i < element.getServiceType().size(); ++i) {
            this.composeCodeableConcept(t, "Slot", "serviceType", element.getServiceType().get(i), i);
        }
        for (i = 0; i < element.getSpecialty().size(); ++i) {
            this.composeCodeableConcept(t, "Slot", "specialty", element.getSpecialty().get(i), i);
        }
        if (element.hasAppointmentType()) {
            this.composeCodeableConcept(t, "Slot", "appointmentType", element.getAppointmentType(), -1);
        }
        if (element.hasSchedule()) {
            this.composeReference(t, "Slot", "schedule", element.getSchedule(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Slot", "status", element.getStatusElement(), -1);
        }
        if (element.hasStartElement()) {
            this.composeInstant(t, "Slot", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInstant(t, "Slot", "end", element.getEndElement(), -1);
        }
        if (element.hasOverbookedElement()) {
            this.composeBoolean(t, "Slot", "overbooked", element.getOverbookedElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "Slot", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeSpecimen(RdfGenerator.Complex parent, String parentType, String name, Specimen element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Specimen", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Specimen", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasAccessionIdentifier()) {
            this.composeIdentifier(t, "Specimen", "accessionIdentifier", element.getAccessionIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Specimen", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Specimen", "type", element.getType(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Specimen", "subject", element.getSubject(), -1);
        }
        if (element.hasReceivedTimeElement()) {
            this.composeDateTime(t, "Specimen", "receivedTime", element.getReceivedTimeElement(), -1);
        }
        for (i = 0; i < element.getParent().size(); ++i) {
            this.composeReference(t, "Specimen", "parent", element.getParent().get(i), i);
        }
        if (element.hasCollection()) {
            this.composeSpecimenSpecimenCollectionComponent(t, "Specimen", "collection", element.getCollection(), -1);
        }
        for (i = 0; i < element.getTreatment().size(); ++i) {
            this.composeSpecimenSpecimenTreatmentComponent(t, "Specimen", "treatment", element.getTreatment().get(i), i);
        }
        for (i = 0; i < element.getContainer().size(); ++i) {
            this.composeSpecimenSpecimenContainerComponent(t, "Specimen", "container", element.getContainer().get(i), i);
        }
    }

    protected void composeSpecimenSpecimenCollectionComponent(RdfGenerator.Complex parent, String parentType, String name, Specimen.SpecimenCollectionComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "collection", name, element, index);
        if (element.hasCollector()) {
            this.composeReference(t, "Specimen", "collector", element.getCollector(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "Specimen", "comment", element.getCommentElement(), -1);
        }
        if (element.hasCollected()) {
            this.composeType(t, "Specimen", "collected", element.getCollected(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "Specimen", "quantity", element.getQuantity(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "Specimen", "method", element.getMethod(), -1);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "Specimen", "bodySite", element.getBodySite(), -1);
        }
    }

    protected void composeSpecimenSpecimenTreatmentComponent(RdfGenerator.Complex parent, String parentType, String name, Specimen.SpecimenTreatmentComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "treatment", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Specimen", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasProcedure()) {
            this.composeCodeableConcept(t, "Specimen", "procedure", element.getProcedure(), -1);
        }
        for (int i = 0; i < element.getAdditive().size(); ++i) {
            this.composeReference(t, "Specimen", "additive", element.getAdditive().get(i), i);
        }
    }

    protected void composeSpecimenSpecimenContainerComponent(RdfGenerator.Complex parent, String parentType, String name, Specimen.SpecimenContainerComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "container", name, element, index);
        for (int i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Specimen", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Specimen", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Specimen", "type", element.getType(), -1);
        }
        if (element.hasCapacity()) {
            this.composeQuantity(t, "Specimen", "capacity", element.getCapacity(), -1);
        }
        if (element.hasSpecimenQuantity()) {
            this.composeQuantity(t, "Specimen", "specimenQuantity", element.getSpecimenQuantity(), -1);
        }
        if (element.hasAdditive()) {
            this.composeType(t, "Specimen", "additive", element.getAdditive(), -1);
        }
    }

    protected void composeStructureDefinition(RdfGenerator.Complex parent, String parentType, String name, StructureDefinition element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "StructureDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "StructureDefinition", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "StructureDefinition", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "StructureDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "StructureDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "StructureDefinition", "display", element.getDisplayElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "StructureDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "StructureDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "StructureDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeStructureDefinitionStructureDefinitionContactComponent(t, "StructureDefinition", "contact", element.getContact().get(i), i);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "StructureDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "StructureDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeCodeableConcept(t, "StructureDefinition", "useContext", element.getUseContext().get(i), i);
        }
        if (element.hasRequirementsElement()) {
            this.composeString(t, "StructureDefinition", "requirements", element.getRequirementsElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeString(t, "StructureDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        for (i = 0; i < element.getCode().size(); ++i) {
            this.composeCoding(t, "StructureDefinition", "code", element.getCode().get(i), i);
        }
        if (element.hasFhirVersionElement()) {
            this.composeId(t, "StructureDefinition", "fhirVersion", element.getFhirVersionElement(), -1);
        }
        for (i = 0; i < element.getMapping().size(); ++i) {
            this.composeStructureDefinitionStructureDefinitionMappingComponent(t, "StructureDefinition", "mapping", element.getMapping().get(i), i);
        }
        if (element.hasKindElement()) {
            this.composeEnum(t, "StructureDefinition", "kind", element.getKindElement(), -1);
        }
        if (element.hasAbstractElement()) {
            this.composeBoolean(t, "StructureDefinition", "abstract", element.getAbstractElement(), -1);
        }
        if (element.hasContextTypeElement()) {
            this.composeEnum(t, "StructureDefinition", "contextType", element.getContextTypeElement(), -1);
        }
        for (i = 0; i < element.getContext().size(); ++i) {
            this.composeString(t, "StructureDefinition", "context", element.getContext().get(i), i);
        }
        if (element.hasBaseTypeElement()) {
            this.composeCode(t, "StructureDefinition", "baseType", element.getBaseTypeElement(), -1);
        }
        if (element.hasBaseDefinitionElement()) {
            this.composeUri(t, "StructureDefinition", "baseDefinition", element.getBaseDefinitionElement(), -1);
        }
        if (element.hasDerivationElement()) {
            this.composeEnum(t, "StructureDefinition", "derivation", element.getDerivationElement(), -1);
        }
        if (element.hasSnapshot()) {
            this.composeStructureDefinitionStructureDefinitionSnapshotComponent(t, "StructureDefinition", "snapshot", element.getSnapshot(), -1);
        }
        if (element.hasDifferential()) {
            this.composeStructureDefinitionStructureDefinitionDifferentialComponent(t, "StructureDefinition", "differential", element.getDifferential(), -1);
        }
    }

    protected void composeStructureDefinitionStructureDefinitionContactComponent(RdfGenerator.Complex parent, String parentType, String name, StructureDefinition.StructureDefinitionContactComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "StructureDefinition", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "StructureDefinition", "telecom", element.getTelecom().get(i), i);
        }
    }

    protected void composeStructureDefinitionStructureDefinitionMappingComponent(RdfGenerator.Complex parent, String parentType, String name, StructureDefinition.StructureDefinitionMappingComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "mapping", name, element, index);
        if (element.hasIdentityElement()) {
            this.composeId(t, "StructureDefinition", "identity", element.getIdentityElement(), -1);
        }
        if (element.hasUriElement()) {
            this.composeUri(t, "StructureDefinition", "uri", element.getUriElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "StructureDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasCommentsElement()) {
            this.composeString(t, "StructureDefinition", "comments", element.getCommentsElement(), -1);
        }
    }

    protected void composeStructureDefinitionStructureDefinitionSnapshotComponent(RdfGenerator.Complex parent, String parentType, String name, StructureDefinition.StructureDefinitionSnapshotComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "snapshot", name, element, index);
        for (int i = 0; i < element.getElement().size(); ++i) {
            this.composeElementDefinition(t, "StructureDefinition", "element", element.getElement().get(i), i);
        }
    }

    protected void composeStructureDefinitionStructureDefinitionDifferentialComponent(RdfGenerator.Complex parent, String parentType, String name, StructureDefinition.StructureDefinitionDifferentialComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "differential", name, element, index);
        for (int i = 0; i < element.getElement().size(); ++i) {
            this.composeElementDefinition(t, "StructureDefinition", "element", element.getElement().get(i), i);
        }
    }

    protected void composeStructureMap(RdfGenerator.Complex parent, String parentType, String name, StructureMap element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "StructureMap", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "StructureMap", "url", element.getUrlElement(), -1);
        }
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "StructureMap", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "StructureMap", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "StructureMap", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "StructureMap", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "StructureMap", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "StructureMap", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeStructureMapStructureMapContactComponent(t, "StructureMap", "contact", element.getContact().get(i), i);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "StructureMap", "date", element.getDateElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "StructureMap", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeCodeableConcept(t, "StructureMap", "useContext", element.getUseContext().get(i), i);
        }
        if (element.hasRequirementsElement()) {
            this.composeString(t, "StructureMap", "requirements", element.getRequirementsElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeString(t, "StructureMap", "copyright", element.getCopyrightElement(), -1);
        }
        for (i = 0; i < element.getStructure().size(); ++i) {
            this.composeStructureMapStructureMapStructureComponent(t, "StructureMap", "structure", element.getStructure().get(i), i);
        }
        for (i = 0; i < element.getImport().size(); ++i) {
            this.composeUri(t, "StructureMap", "import", element.getImport().get(i), i);
        }
        for (i = 0; i < element.getGroup().size(); ++i) {
            this.composeStructureMapStructureMapGroupComponent(t, "StructureMap", "group", element.getGroup().get(i), i);
        }
    }

    protected void composeStructureMapStructureMapContactComponent(RdfGenerator.Complex parent, String parentType, String name, StructureMap.StructureMapContactComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "StructureMap", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "StructureMap", "telecom", element.getTelecom().get(i), i);
        }
    }

    protected void composeStructureMapStructureMapStructureComponent(RdfGenerator.Complex parent, String parentType, String name, StructureMap.StructureMapStructureComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "structure", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "StructureMap", "url", element.getUrlElement(), -1);
        }
        if (element.hasModeElement()) {
            this.composeEnum(t, "StructureMap", "mode", element.getModeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "StructureMap", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeStructureMapStructureMapGroupComponent(RdfGenerator.Complex parent, String parentType, String name, StructureMap.StructureMapGroupComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "group", name, element, index);
        if (element.hasNameElement()) {
            this.composeId(t, "StructureMap", "name", element.getNameElement(), -1);
        }
        if (element.hasExtendsElement()) {
            this.composeId(t, "StructureMap", "extends", element.getExtendsElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "StructureMap", "documentation", element.getDocumentationElement(), -1);
        }
        for (i = 0; i < element.getInput().size(); ++i) {
            this.composeStructureMapStructureMapGroupInputComponent(t, "StructureMap", "input", element.getInput().get(i), i);
        }
        for (i = 0; i < element.getRule().size(); ++i) {
            this.composeStructureMapStructureMapGroupRuleComponent(t, "StructureMap", "rule", element.getRule().get(i), i);
        }
    }

    protected void composeStructureMapStructureMapGroupInputComponent(RdfGenerator.Complex parent, String parentType, String name, StructureMap.StructureMapGroupInputComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "input", name, element, index);
        if (element.hasNameElement()) {
            this.composeId(t, "StructureMap", "name", element.getNameElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeString(t, "StructureMap", "type", element.getTypeElement(), -1);
        }
        if (element.hasModeElement()) {
            this.composeEnum(t, "StructureMap", "mode", element.getModeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "StructureMap", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeStructureMapStructureMapGroupRuleComponent(RdfGenerator.Complex parent, String parentType, String name, StructureMap.StructureMapGroupRuleComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "rule", name, element, index);
        if (element.hasNameElement()) {
            this.composeId(t, "StructureMap", "name", element.getNameElement(), -1);
        }
        for (i = 0; i < element.getSource().size(); ++i) {
            this.composeStructureMapStructureMapGroupRuleSourceComponent(t, "StructureMap", "source", element.getSource().get(i), i);
        }
        for (i = 0; i < element.getTarget().size(); ++i) {
            this.composeStructureMapStructureMapGroupRuleTargetComponent(t, "StructureMap", "target", element.getTarget().get(i), i);
        }
        for (i = 0; i < element.getRule().size(); ++i) {
            this.composeStructureMapStructureMapGroupRuleComponent(t, "StructureMap", "rule", element.getRule().get(i), i);
        }
        for (i = 0; i < element.getDependent().size(); ++i) {
            this.composeStructureMapStructureMapGroupRuleDependentComponent(t, "StructureMap", "dependent", element.getDependent().get(i), i);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "StructureMap", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeStructureMapStructureMapGroupRuleSourceComponent(RdfGenerator.Complex parent, String parentType, String name, StructureMap.StructureMapGroupRuleSourceComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "source", name, element, index);
        if (element.hasRequiredElement()) {
            this.composeBoolean(t, "StructureMap", "required", element.getRequiredElement(), -1);
        }
        if (element.hasContextElement()) {
            this.composeId(t, "StructureMap", "context", element.getContextElement(), -1);
        }
        if (element.hasContextTypeElement()) {
            this.composeEnum(t, "StructureMap", "contextType", element.getContextTypeElement(), -1);
        }
        if (element.hasElementElement()) {
            this.composeString(t, "StructureMap", "element", element.getElementElement(), -1);
        }
        if (element.hasListModeElement()) {
            this.composeEnum(t, "StructureMap", "listMode", element.getListModeElement(), -1);
        }
        if (element.hasVariableElement()) {
            this.composeId(t, "StructureMap", "variable", element.getVariableElement(), -1);
        }
        if (element.hasConditionElement()) {
            this.composeString(t, "StructureMap", "condition", element.getConditionElement(), -1);
        }
        if (element.hasCheckElement()) {
            this.composeString(t, "StructureMap", "check", element.getCheckElement(), -1);
        }
    }

    protected void composeStructureMapStructureMapGroupRuleTargetComponent(RdfGenerator.Complex parent, String parentType, String name, StructureMap.StructureMapGroupRuleTargetComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "target", name, element, index);
        if (element.hasContextElement()) {
            this.composeId(t, "StructureMap", "context", element.getContextElement(), -1);
        }
        if (element.hasContextTypeElement()) {
            this.composeEnum(t, "StructureMap", "contextType", element.getContextTypeElement(), -1);
        }
        if (element.hasElementElement()) {
            this.composeString(t, "StructureMap", "element", element.getElementElement(), -1);
        }
        if (element.hasVariableElement()) {
            this.composeId(t, "StructureMap", "variable", element.getVariableElement(), -1);
        }
        for (i = 0; i < element.getListMode().size(); ++i) {
            this.composeEnum(t, "StructureMap", "listMode", element.getListMode().get(i), i);
        }
        if (element.hasListRuleIdElement()) {
            this.composeId(t, "StructureMap", "listRuleId", element.getListRuleIdElement(), -1);
        }
        if (element.hasTransformElement()) {
            this.composeEnum(t, "StructureMap", "transform", element.getTransformElement(), -1);
        }
        for (i = 0; i < element.getParameter().size(); ++i) {
            this.composeStructureMapStructureMapGroupRuleTargetParameterComponent(t, "StructureMap", "parameter", element.getParameter().get(i), i);
        }
    }

    protected void composeStructureMapStructureMapGroupRuleTargetParameterComponent(RdfGenerator.Complex parent, String parentType, String name, StructureMap.StructureMapGroupRuleTargetParameterComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "parameter", name, element, index);
        if (element.hasValue()) {
            this.composeType(t, "StructureMap", "value", element.getValue(), -1);
        }
    }

    protected void composeStructureMapStructureMapGroupRuleDependentComponent(RdfGenerator.Complex parent, String parentType, String name, StructureMap.StructureMapGroupRuleDependentComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dependent", name, element, index);
        if (element.hasNameElement()) {
            this.composeId(t, "StructureMap", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getVariable().size(); ++i) {
            this.composeString(t, "StructureMap", "variable", element.getVariable().get(i), i);
        }
    }

    protected void composeSubscription(RdfGenerator.Complex parent, String parentType, String name, Subscription element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Subscription", name, element, index);
        if (element.hasCriteriaElement()) {
            this.composeString(t, "Subscription", "criteria", element.getCriteriaElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeContactPoint(t, "Subscription", "contact", element.getContact().get(i), i);
        }
        if (element.hasReasonElement()) {
            this.composeString(t, "Subscription", "reason", element.getReasonElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Subscription", "status", element.getStatusElement(), -1);
        }
        if (element.hasErrorElement()) {
            this.composeString(t, "Subscription", "error", element.getErrorElement(), -1);
        }
        if (element.hasChannel()) {
            this.composeSubscriptionSubscriptionChannelComponent(t, "Subscription", "channel", element.getChannel(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInstant(t, "Subscription", "end", element.getEndElement(), -1);
        }
        for (i = 0; i < element.getTag().size(); ++i) {
            this.composeCoding(t, "Subscription", "tag", element.getTag().get(i), i);
        }
    }

    protected void composeSubscriptionSubscriptionChannelComponent(RdfGenerator.Complex parent, String parentType, String name, Subscription.SubscriptionChannelComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "channel", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Subscription", "type", element.getTypeElement(), -1);
        }
        if (element.hasEndpointElement()) {
            this.composeUri(t, "Subscription", "endpoint", element.getEndpointElement(), -1);
        }
        if (element.hasPayloadElement()) {
            this.composeString(t, "Subscription", "payload", element.getPayloadElement(), -1);
        }
        if (element.hasHeaderElement()) {
            this.composeString(t, "Subscription", "header", element.getHeaderElement(), -1);
        }
    }

    protected void composeSubstance(RdfGenerator.Complex parent, String parentType, String name, Substance element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Substance", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "Substance", "identifier", element.getIdentifier().get(i), i);
        }
        for (i = 0; i < element.getCategory().size(); ++i) {
            this.composeCodeableConcept(t, "Substance", "category", element.getCategory().get(i), i);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Substance", "code", element.getCode(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Substance", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getInstance().size(); ++i) {
            this.composeSubstanceSubstanceInstanceComponent(t, "Substance", "instance", element.getInstance().get(i), i);
        }
        for (i = 0; i < element.getIngredient().size(); ++i) {
            this.composeSubstanceSubstanceIngredientComponent(t, "Substance", "ingredient", element.getIngredient().get(i), i);
        }
    }

    protected void composeSubstanceSubstanceInstanceComponent(RdfGenerator.Complex parent, String parentType, String name, Substance.SubstanceInstanceComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "instance", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Substance", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasExpiryElement()) {
            this.composeDateTime(t, "Substance", "expiry", element.getExpiryElement(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "Substance", "quantity", element.getQuantity(), -1);
        }
    }

    protected void composeSubstanceSubstanceIngredientComponent(RdfGenerator.Complex parent, String parentType, String name, Substance.SubstanceIngredientComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "ingredient", name, element, index);
        if (element.hasQuantity()) {
            this.composeRatio(t, "Substance", "quantity", element.getQuantity(), -1);
        }
        if (element.hasSubstance()) {
            this.composeReference(t, "Substance", "substance", element.getSubstance(), -1);
        }
    }

    protected void composeSupplyDelivery(RdfGenerator.Complex parent, String parentType, String name, SupplyDelivery element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "SupplyDelivery", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "SupplyDelivery", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "SupplyDelivery", "status", element.getStatusElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "SupplyDelivery", "patient", element.getPatient(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "SupplyDelivery", "type", element.getType(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "SupplyDelivery", "quantity", element.getQuantity(), -1);
        }
        if (element.hasSuppliedItem()) {
            this.composeReference(t, "SupplyDelivery", "suppliedItem", element.getSuppliedItem(), -1);
        }
        if (element.hasSupplier()) {
            this.composeReference(t, "SupplyDelivery", "supplier", element.getSupplier(), -1);
        }
        if (element.hasWhenPrepared()) {
            this.composePeriod(t, "SupplyDelivery", "whenPrepared", element.getWhenPrepared(), -1);
        }
        if (element.hasTimeElement()) {
            this.composeDateTime(t, "SupplyDelivery", "time", element.getTimeElement(), -1);
        }
        if (element.hasDestination()) {
            this.composeReference(t, "SupplyDelivery", "destination", element.getDestination(), -1);
        }
        for (int i = 0; i < element.getReceiver().size(); ++i) {
            this.composeReference(t, "SupplyDelivery", "receiver", element.getReceiver().get(i), i);
        }
    }

    protected void composeSupplyRequest(RdfGenerator.Complex parent, String parentType, String name, SupplyRequest element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "SupplyRequest", name, element, index);
        if (element.hasPatient()) {
            this.composeReference(t, "SupplyRequest", "patient", element.getPatient(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "SupplyRequest", "source", element.getSource(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "SupplyRequest", "date", element.getDateElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "SupplyRequest", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "SupplyRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasKind()) {
            this.composeCodeableConcept(t, "SupplyRequest", "kind", element.getKind(), -1);
        }
        if (element.hasOrderedItem()) {
            this.composeReference(t, "SupplyRequest", "orderedItem", element.getOrderedItem(), -1);
        }
        for (int i = 0; i < element.getSupplier().size(); ++i) {
            this.composeReference(t, "SupplyRequest", "supplier", element.getSupplier().get(i), i);
        }
        if (element.hasReason()) {
            this.composeType(t, "SupplyRequest", "reason", element.getReason(), -1);
        }
        if (element.hasWhen()) {
            this.composeSupplyRequestSupplyRequestWhenComponent(t, "SupplyRequest", "when", element.getWhen(), -1);
        }
    }

    protected void composeSupplyRequestSupplyRequestWhenComponent(RdfGenerator.Complex parent, String parentType, String name, SupplyRequest.SupplyRequestWhenComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "when", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "SupplyRequest", "code", element.getCode(), -1);
        }
        if (element.hasSchedule()) {
            this.composeTiming(t, "SupplyRequest", "schedule", element.getSchedule(), -1);
        }
    }

    protected void composeTask(RdfGenerator.Complex parent, String parentType, String name, Task element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Task", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Task", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Task", "type", element.getType(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Task", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getPerformerType().size(); ++i) {
            this.composeCoding(t, "Task", "performerType", element.getPerformerType().get(i), i);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "Task", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Task", "status", element.getStatusElement(), -1);
        }
        if (element.hasFailureReason()) {
            this.composeCodeableConcept(t, "Task", "failureReason", element.getFailureReason(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Task", "subject", element.getSubject(), -1);
        }
        if (element.hasFor()) {
            this.composeReference(t, "Task", "for", element.getFor(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeUri(t, "Task", "definition", element.getDefinitionElement(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "Task", "created", element.getCreatedElement(), -1);
        }
        if (element.hasLastModifiedElement()) {
            this.composeDateTime(t, "Task", "lastModified", element.getLastModifiedElement(), -1);
        }
        if (element.hasCreator()) {
            this.composeReference(t, "Task", "creator", element.getCreator(), -1);
        }
        if (element.hasOwner()) {
            this.composeReference(t, "Task", "owner", element.getOwner(), -1);
        }
        if (element.hasParent()) {
            this.composeReference(t, "Task", "parent", element.getParent(), -1);
        }
        for (i = 0; i < element.getInput().size(); ++i) {
            this.composeTaskParameterComponent(t, "Task", "input", element.getInput().get(i), i);
        }
        for (i = 0; i < element.getOutput().size(); ++i) {
            this.composeTaskTaskOutputComponent(t, "Task", "output", element.getOutput().get(i), i);
        }
    }

    protected void composeTaskParameterComponent(RdfGenerator.Complex parent, String parentType, String name, Task.ParameterComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "input", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "Task", "name", element.getNameElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "Task", "value", element.getValue(), -1);
        }
    }

    protected void composeTaskTaskOutputComponent(RdfGenerator.Complex parent, String parentType, String name, Task.TaskOutputComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "output", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "Task", "name", element.getNameElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "Task", "value", element.getValue(), -1);
        }
    }

    protected void composeTestScript(RdfGenerator.Complex parent, String parentType, String name, TestScript element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "TestScript", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "TestScript", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "TestScript", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "TestScript", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "TestScript", "status", element.getStatusElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "TestScript", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "TestScript", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "TestScript", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeTestScriptTestScriptContactComponent(t, "TestScript", "contact", element.getContact().get(i), i);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "TestScript", "date", element.getDateElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "TestScript", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeCodeableConcept(t, "TestScript", "useContext", element.getUseContext().get(i), i);
        }
        if (element.hasRequirementsElement()) {
            this.composeString(t, "TestScript", "requirements", element.getRequirementsElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeString(t, "TestScript", "copyright", element.getCopyrightElement(), -1);
        }
        for (i = 0; i < element.getOrigin().size(); ++i) {
            this.composeTestScriptTestScriptOriginComponent(t, "TestScript", "origin", element.getOrigin().get(i), i);
        }
        for (i = 0; i < element.getDestination().size(); ++i) {
            this.composeTestScriptTestScriptDestinationComponent(t, "TestScript", "destination", element.getDestination().get(i), i);
        }
        if (element.hasMetadata()) {
            this.composeTestScriptTestScriptMetadataComponent(t, "TestScript", "metadata", element.getMetadata(), -1);
        }
        for (i = 0; i < element.getFixture().size(); ++i) {
            this.composeTestScriptTestScriptFixtureComponent(t, "TestScript", "fixture", element.getFixture().get(i), i);
        }
        for (i = 0; i < element.getProfile().size(); ++i) {
            this.composeReference(t, "TestScript", "profile", element.getProfile().get(i), i);
        }
        for (i = 0; i < element.getVariable().size(); ++i) {
            this.composeTestScriptTestScriptVariableComponent(t, "TestScript", "variable", element.getVariable().get(i), i);
        }
        for (i = 0; i < element.getRule().size(); ++i) {
            this.composeTestScriptTestScriptRuleComponent(t, "TestScript", "rule", element.getRule().get(i), i);
        }
        for (i = 0; i < element.getRuleset().size(); ++i) {
            this.composeTestScriptTestScriptRulesetComponent(t, "TestScript", "ruleset", element.getRuleset().get(i), i);
        }
        if (element.hasSetup()) {
            this.composeTestScriptTestScriptSetupComponent(t, "TestScript", "setup", element.getSetup(), -1);
        }
        for (i = 0; i < element.getTest().size(); ++i) {
            this.composeTestScriptTestScriptTestComponent(t, "TestScript", "test", element.getTest().get(i), i);
        }
        if (element.hasTeardown()) {
            this.composeTestScriptTestScriptTeardownComponent(t, "TestScript", "teardown", element.getTeardown(), -1);
        }
    }

    protected void composeTestScriptTestScriptContactComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.TestScriptContactComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "TestScript", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "TestScript", "telecom", element.getTelecom().get(i), i);
        }
    }

    protected void composeTestScriptTestScriptOriginComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.TestScriptOriginComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "origin", name, element, index);
        if (element.hasIndexElement()) {
            this.composeInteger(t, "TestScript", "index", element.getIndexElement(), -1);
        }
        if (element.hasProfile()) {
            this.composeCoding(t, "TestScript", "profile", element.getProfile(), -1);
        }
    }

    protected void composeTestScriptTestScriptDestinationComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.TestScriptDestinationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "destination", name, element, index);
        if (element.hasIndexElement()) {
            this.composeInteger(t, "TestScript", "index", element.getIndexElement(), -1);
        }
        if (element.hasProfile()) {
            this.composeCoding(t, "TestScript", "profile", element.getProfile(), -1);
        }
    }

    protected void composeTestScriptTestScriptMetadataComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.TestScriptMetadataComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "metadata", name, element, index);
        for (i = 0; i < element.getLink().size(); ++i) {
            this.composeTestScriptTestScriptMetadataLinkComponent(t, "TestScript", "link", element.getLink().get(i), i);
        }
        for (i = 0; i < element.getCapability().size(); ++i) {
            this.composeTestScriptTestScriptMetadataCapabilityComponent(t, "TestScript", "capability", element.getCapability().get(i), i);
        }
    }

    protected void composeTestScriptTestScriptMetadataLinkComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.TestScriptMetadataLinkComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "link", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "TestScript", "url", element.getUrlElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "TestScript", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeTestScriptTestScriptMetadataCapabilityComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.TestScriptMetadataCapabilityComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "capability", name, element, index);
        if (element.hasRequiredElement()) {
            this.composeBoolean(t, "TestScript", "required", element.getRequiredElement(), -1);
        }
        if (element.hasValidatedElement()) {
            this.composeBoolean(t, "TestScript", "validated", element.getValidatedElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "TestScript", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getOrigin().size(); ++i) {
            this.composeInteger(t, "TestScript", "origin", element.getOrigin().get(i), i);
        }
        if (element.hasDestinationElement()) {
            this.composeInteger(t, "TestScript", "destination", element.getDestinationElement(), -1);
        }
        for (i = 0; i < element.getLink().size(); ++i) {
            this.composeUri(t, "TestScript", "link", element.getLink().get(i), i);
        }
        if (element.hasConformance()) {
            this.composeReference(t, "TestScript", "conformance", element.getConformance(), -1);
        }
    }

    protected void composeTestScriptTestScriptFixtureComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.TestScriptFixtureComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "fixture", name, element, index);
        if (element.hasAutocreateElement()) {
            this.composeBoolean(t, "TestScript", "autocreate", element.getAutocreateElement(), -1);
        }
        if (element.hasAutodeleteElement()) {
            this.composeBoolean(t, "TestScript", "autodelete", element.getAutodeleteElement(), -1);
        }
        if (element.hasResource()) {
            this.composeReference(t, "TestScript", "resource", element.getResource(), -1);
        }
    }

    protected void composeTestScriptTestScriptVariableComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.TestScriptVariableComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "variable", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "TestScript", "name", element.getNameElement(), -1);
        }
        if (element.hasDefaultValueElement()) {
            this.composeString(t, "TestScript", "defaultValue", element.getDefaultValueElement(), -1);
        }
        if (element.hasHeaderFieldElement()) {
            this.composeString(t, "TestScript", "headerField", element.getHeaderFieldElement(), -1);
        }
        if (element.hasPathElement()) {
            this.composeString(t, "TestScript", "path", element.getPathElement(), -1);
        }
        if (element.hasSourceIdElement()) {
            this.composeId(t, "TestScript", "sourceId", element.getSourceIdElement(), -1);
        }
    }

    protected void composeTestScriptTestScriptRuleComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.TestScriptRuleComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "rule", name, element, index);
        if (element.hasResource()) {
            this.composeReference(t, "TestScript", "resource", element.getResource(), -1);
        }
        for (int i = 0; i < element.getParam().size(); ++i) {
            this.composeTestScriptTestScriptRuleParamComponent(t, "TestScript", "param", element.getParam().get(i), i);
        }
    }

    protected void composeTestScriptTestScriptRuleParamComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.TestScriptRuleParamComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "param", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "TestScript", "name", element.getNameElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "TestScript", "value", element.getValueElement(), -1);
        }
    }

    protected void composeTestScriptTestScriptRulesetComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.TestScriptRulesetComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "ruleset", name, element, index);
        if (element.hasResource()) {
            this.composeReference(t, "TestScript", "resource", element.getResource(), -1);
        }
        for (int i = 0; i < element.getRule().size(); ++i) {
            this.composeTestScriptTestScriptRulesetRuleComponent(t, "TestScript", "rule", element.getRule().get(i), i);
        }
    }

    protected void composeTestScriptTestScriptRulesetRuleComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.TestScriptRulesetRuleComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "rule", name, element, index);
        if (element.hasRuleIdElement()) {
            this.composeId(t, "TestScript", "ruleId", element.getRuleIdElement(), -1);
        }
        for (int i = 0; i < element.getParam().size(); ++i) {
            this.composeTestScriptTestScriptRulesetRuleParamComponent(t, "TestScript", "param", element.getParam().get(i), i);
        }
    }

    protected void composeTestScriptTestScriptRulesetRuleParamComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.TestScriptRulesetRuleParamComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "param", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "TestScript", "name", element.getNameElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "TestScript", "value", element.getValueElement(), -1);
        }
    }

    protected void composeTestScriptTestScriptSetupComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.TestScriptSetupComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "setup", name, element, index);
        if (element.hasMetadata()) {
            this.composeTestScriptTestScriptMetadataComponent(t, "TestScript", "metadata", element.getMetadata(), -1);
        }
        for (int i = 0; i < element.getAction().size(); ++i) {
            this.composeTestScriptSetupActionComponent(t, "TestScript", "action", element.getAction().get(i), i);
        }
    }

    protected void composeTestScriptSetupActionComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.SetupActionComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "action", name, element, index);
        if (element.hasOperation()) {
            this.composeTestScriptSetupActionOperationComponent(t, "TestScript", "operation", element.getOperation(), -1);
        }
        if (element.hasAssert()) {
            this.composeTestScriptSetupActionAssertComponent(t, "TestScript", "assert", element.getAssert(), -1);
        }
    }

    protected void composeTestScriptSetupActionOperationComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.SetupActionOperationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "operation", name, element, index);
        if (element.hasType()) {
            this.composeCoding(t, "TestScript", "type", element.getType(), -1);
        }
        if (element.hasResourceElement()) {
            this.composeCode(t, "TestScript", "resource", element.getResourceElement(), -1);
        }
        if (element.hasLabelElement()) {
            this.composeString(t, "TestScript", "label", element.getLabelElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "TestScript", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasAcceptElement()) {
            this.composeEnum(t, "TestScript", "accept", element.getAcceptElement(), -1);
        }
        if (element.hasContentTypeElement()) {
            this.composeEnum(t, "TestScript", "contentType", element.getContentTypeElement(), -1);
        }
        if (element.hasDestinationElement()) {
            this.composeInteger(t, "TestScript", "destination", element.getDestinationElement(), -1);
        }
        if (element.hasEncodeRequestUrlElement()) {
            this.composeBoolean(t, "TestScript", "encodeRequestUrl", element.getEncodeRequestUrlElement(), -1);
        }
        if (element.hasOriginElement()) {
            this.composeInteger(t, "TestScript", "origin", element.getOriginElement(), -1);
        }
        if (element.hasParamsElement()) {
            this.composeString(t, "TestScript", "params", element.getParamsElement(), -1);
        }
        for (int i = 0; i < element.getRequestHeader().size(); ++i) {
            this.composeTestScriptSetupActionOperationRequestHeaderComponent(t, "TestScript", "requestHeader", element.getRequestHeader().get(i), i);
        }
        if (element.hasResponseIdElement()) {
            this.composeId(t, "TestScript", "responseId", element.getResponseIdElement(), -1);
        }
        if (element.hasSourceIdElement()) {
            this.composeId(t, "TestScript", "sourceId", element.getSourceIdElement(), -1);
        }
        if (element.hasTargetIdElement()) {
            this.composeId(t, "TestScript", "targetId", element.getTargetIdElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeString(t, "TestScript", "url", element.getUrlElement(), -1);
        }
    }

    protected void composeTestScriptSetupActionOperationRequestHeaderComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.SetupActionOperationRequestHeaderComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "requestHeader", name, element, index);
        if (element.hasFieldElement()) {
            this.composeString(t, "TestScript", "field", element.getFieldElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "TestScript", "value", element.getValueElement(), -1);
        }
    }

    protected void composeTestScriptSetupActionAssertComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.SetupActionAssertComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "assert", name, element, index);
        if (element.hasLabelElement()) {
            this.composeString(t, "TestScript", "label", element.getLabelElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "TestScript", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasDirectionElement()) {
            this.composeEnum(t, "TestScript", "direction", element.getDirectionElement(), -1);
        }
        if (element.hasCompareToSourceIdElement()) {
            this.composeString(t, "TestScript", "compareToSourceId", element.getCompareToSourceIdElement(), -1);
        }
        if (element.hasCompareToSourcePathElement()) {
            this.composeString(t, "TestScript", "compareToSourcePath", element.getCompareToSourcePathElement(), -1);
        }
        if (element.hasContentTypeElement()) {
            this.composeEnum(t, "TestScript", "contentType", element.getContentTypeElement(), -1);
        }
        if (element.hasHeaderFieldElement()) {
            this.composeString(t, "TestScript", "headerField", element.getHeaderFieldElement(), -1);
        }
        if (element.hasMinimumIdElement()) {
            this.composeString(t, "TestScript", "minimumId", element.getMinimumIdElement(), -1);
        }
        if (element.hasNavigationLinksElement()) {
            this.composeBoolean(t, "TestScript", "navigationLinks", element.getNavigationLinksElement(), -1);
        }
        if (element.hasOperatorElement()) {
            this.composeEnum(t, "TestScript", "operator", element.getOperatorElement(), -1);
        }
        if (element.hasPathElement()) {
            this.composeString(t, "TestScript", "path", element.getPathElement(), -1);
        }
        if (element.hasResourceElement()) {
            this.composeCode(t, "TestScript", "resource", element.getResourceElement(), -1);
        }
        if (element.hasResponseElement()) {
            this.composeEnum(t, "TestScript", "response", element.getResponseElement(), -1);
        }
        if (element.hasResponseCodeElement()) {
            this.composeString(t, "TestScript", "responseCode", element.getResponseCodeElement(), -1);
        }
        if (element.hasRule()) {
            this.composeTestScriptSetupActionAssertRuleComponent(t, "TestScript", "rule", element.getRule(), -1);
        }
        if (element.hasRuleset()) {
            this.composeTestScriptSetupActionAssertRulesetComponent(t, "TestScript", "ruleset", element.getRuleset(), -1);
        }
        if (element.hasSourceIdElement()) {
            this.composeId(t, "TestScript", "sourceId", element.getSourceIdElement(), -1);
        }
        if (element.hasValidateProfileIdElement()) {
            this.composeId(t, "TestScript", "validateProfileId", element.getValidateProfileIdElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "TestScript", "value", element.getValueElement(), -1);
        }
        if (element.hasWarningOnlyElement()) {
            this.composeBoolean(t, "TestScript", "warningOnly", element.getWarningOnlyElement(), -1);
        }
    }

    protected void composeTestScriptSetupActionAssertRuleComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.SetupActionAssertRuleComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "rule", name, element, index);
        if (element.hasRuleIdElement()) {
            this.composeId(t, "TestScript", "ruleId", element.getRuleIdElement(), -1);
        }
        for (int i = 0; i < element.getParam().size(); ++i) {
            this.composeTestScriptSetupActionAssertRuleParamComponent(t, "TestScript", "param", element.getParam().get(i), i);
        }
    }

    protected void composeTestScriptSetupActionAssertRuleParamComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.SetupActionAssertRuleParamComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "param", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "TestScript", "name", element.getNameElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "TestScript", "value", element.getValueElement(), -1);
        }
    }

    protected void composeTestScriptSetupActionAssertRulesetComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.SetupActionAssertRulesetComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "ruleset", name, element, index);
        if (element.hasRulesetIdElement()) {
            this.composeId(t, "TestScript", "rulesetId", element.getRulesetIdElement(), -1);
        }
        for (int i = 0; i < element.getRule().size(); ++i) {
            this.composeTestScriptSetupActionAssertRulesetRuleComponent(t, "TestScript", "rule", element.getRule().get(i), i);
        }
    }

    protected void composeTestScriptSetupActionAssertRulesetRuleComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.SetupActionAssertRulesetRuleComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "rule", name, element, index);
        if (element.hasRuleIdElement()) {
            this.composeId(t, "TestScript", "ruleId", element.getRuleIdElement(), -1);
        }
        for (int i = 0; i < element.getParam().size(); ++i) {
            this.composeTestScriptSetupActionAssertRulesetRuleParamComponent(t, "TestScript", "param", element.getParam().get(i), i);
        }
    }

    protected void composeTestScriptSetupActionAssertRulesetRuleParamComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.SetupActionAssertRulesetRuleParamComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "param", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "TestScript", "name", element.getNameElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "TestScript", "value", element.getValueElement(), -1);
        }
    }

    protected void composeTestScriptTestScriptTestComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.TestScriptTestComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "test", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "TestScript", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "TestScript", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasMetadata()) {
            this.composeTestScriptTestScriptMetadataComponent(t, "TestScript", "metadata", element.getMetadata(), -1);
        }
        for (int i = 0; i < element.getAction().size(); ++i) {
            this.composeTestScriptTestActionComponent(t, "TestScript", "action", element.getAction().get(i), i);
        }
    }

    protected void composeTestScriptTestActionComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.TestActionComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "action", name, element, index);
        if (element.hasOperation()) {
            this.composeTestScriptSetupActionOperationComponent(t, "TestScript", "operation", element.getOperation(), -1);
        }
        if (element.hasAssert()) {
            this.composeTestScriptSetupActionAssertComponent(t, "TestScript", "assert", element.getAssert(), -1);
        }
    }

    protected void composeTestScriptTestScriptTeardownComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.TestScriptTeardownComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "teardown", name, element, index);
        for (int i = 0; i < element.getAction().size(); ++i) {
            this.composeTestScriptTeardownActionComponent(t, "TestScript", "action", element.getAction().get(i), i);
        }
    }

    protected void composeTestScriptTeardownActionComponent(RdfGenerator.Complex parent, String parentType, String name, TestScript.TeardownActionComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "action", name, element, index);
        if (element.hasOperation()) {
            this.composeTestScriptSetupActionOperationComponent(t, "TestScript", "operation", element.getOperation(), -1);
        }
    }

    protected void composeValueSet(RdfGenerator.Complex parent, String parentType, String name, ValueSet element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ValueSet", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ValueSet", "url", element.getUrlElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "ValueSet", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ValueSet", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ValueSet", "name", element.getNameElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ValueSet", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ValueSet", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ValueSet", "publisher", element.getPublisherElement(), -1);
        }
        for (i = 0; i < element.getContact().size(); ++i) {
            this.composeValueSetValueSetContactComponent(t, "ValueSet", "contact", element.getContact().get(i), i);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ValueSet", "date", element.getDateElement(), -1);
        }
        if (element.hasLockedDateElement()) {
            this.composeDate(t, "ValueSet", "lockedDate", element.getLockedDateElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ValueSet", "description", element.getDescriptionElement(), -1);
        }
        for (i = 0; i < element.getUseContext().size(); ++i) {
            this.composeCodeableConcept(t, "ValueSet", "useContext", element.getUseContext().get(i), i);
        }
        if (element.hasImmutableElement()) {
            this.composeBoolean(t, "ValueSet", "immutable", element.getImmutableElement(), -1);
        }
        if (element.hasRequirementsElement()) {
            this.composeString(t, "ValueSet", "requirements", element.getRequirementsElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeString(t, "ValueSet", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasExtensibleElement()) {
            this.composeBoolean(t, "ValueSet", "extensible", element.getExtensibleElement(), -1);
        }
        if (element.hasCompose()) {
            this.composeValueSetValueSetComposeComponent(t, "ValueSet", "compose", element.getCompose(), -1);
        }
        if (element.hasExpansion()) {
            this.composeValueSetValueSetExpansionComponent(t, "ValueSet", "expansion", element.getExpansion(), -1);
        }
    }

    protected void composeValueSetValueSetContactComponent(RdfGenerator.Complex parent, String parentType, String name, ValueSet.ValueSetContactComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ValueSet", "name", element.getNameElement(), -1);
        }
        for (int i = 0; i < element.getTelecom().size(); ++i) {
            this.composeContactPoint(t, "ValueSet", "telecom", element.getTelecom().get(i), i);
        }
    }

    protected void composeValueSetValueSetComposeComponent(RdfGenerator.Complex parent, String parentType, String name, ValueSet.ValueSetComposeComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "compose", name, element, index);
        for (i = 0; i < element.getImport().size(); ++i) {
            this.composeUri(t, "ValueSet", "import", element.getImport().get(i), i);
        }
        for (i = 0; i < element.getInclude().size(); ++i) {
            this.composeValueSetConceptSetComponent(t, "ValueSet", "include", element.getInclude().get(i), i);
        }
        for (i = 0; i < element.getExclude().size(); ++i) {
            this.composeValueSetConceptSetComponent(t, "ValueSet", "exclude", element.getExclude().get(i), i);
        }
    }

    protected void composeValueSetConceptSetComponent(RdfGenerator.Complex parent, String parentType, String name, ValueSet.ConceptSetComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "include", name, element, index);
        if (element.hasSystemElement()) {
            this.composeUri(t, "ValueSet", "system", element.getSystemElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ValueSet", "version", element.getVersionElement(), -1);
        }
        for (i = 0; i < element.getConcept().size(); ++i) {
            this.composeValueSetConceptReferenceComponent(t, "ValueSet", "concept", element.getConcept().get(i), i);
        }
        for (i = 0; i < element.getFilter().size(); ++i) {
            this.composeValueSetConceptSetFilterComponent(t, "ValueSet", "filter", element.getFilter().get(i), i);
        }
    }

    protected void composeValueSetConceptReferenceComponent(RdfGenerator.Complex parent, String parentType, String name, ValueSet.ConceptReferenceComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "concept", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "ValueSet", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "ValueSet", "display", element.getDisplayElement(), -1);
        }
        for (int i = 0; i < element.getDesignation().size(); ++i) {
            this.composeValueSetConceptReferenceDesignationComponent(t, "ValueSet", "designation", element.getDesignation().get(i), i);
        }
    }

    protected void composeValueSetConceptReferenceDesignationComponent(RdfGenerator.Complex parent, String parentType, String name, ValueSet.ConceptReferenceDesignationComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "designation", name, element, index);
        if (element.hasLanguageElement()) {
            this.composeCode(t, "ValueSet", "language", element.getLanguageElement(), -1);
        }
        if (element.hasUse()) {
            this.composeCoding(t, "ValueSet", "use", element.getUse(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "ValueSet", "value", element.getValueElement(), -1);
        }
    }

    protected void composeValueSetConceptSetFilterComponent(RdfGenerator.Complex parent, String parentType, String name, ValueSet.ConceptSetFilterComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "filter", name, element, index);
        if (element.hasPropertyElement()) {
            this.composeCode(t, "ValueSet", "property", element.getPropertyElement(), -1);
        }
        if (element.hasOpElement()) {
            this.composeEnum(t, "ValueSet", "op", element.getOpElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeCode(t, "ValueSet", "value", element.getValueElement(), -1);
        }
    }

    protected void composeValueSetValueSetExpansionComponent(RdfGenerator.Complex parent, String parentType, String name, ValueSet.ValueSetExpansionComponent element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "expansion", name, element, index);
        if (element.hasIdentifierElement()) {
            this.composeUri(t, "ValueSet", "identifier", element.getIdentifierElement(), -1);
        }
        if (element.hasTimestampElement()) {
            this.composeDateTime(t, "ValueSet", "timestamp", element.getTimestampElement(), -1);
        }
        if (element.hasTotalElement()) {
            this.composeInteger(t, "ValueSet", "total", element.getTotalElement(), -1);
        }
        if (element.hasOffsetElement()) {
            this.composeInteger(t, "ValueSet", "offset", element.getOffsetElement(), -1);
        }
        for (i = 0; i < element.getParameter().size(); ++i) {
            this.composeValueSetValueSetExpansionParameterComponent(t, "ValueSet", "parameter", element.getParameter().get(i), i);
        }
        for (i = 0; i < element.getContains().size(); ++i) {
            this.composeValueSetValueSetExpansionContainsComponent(t, "ValueSet", "contains", element.getContains().get(i), i);
        }
    }

    protected void composeValueSetValueSetExpansionParameterComponent(RdfGenerator.Complex parent, String parentType, String name, ValueSet.ValueSetExpansionParameterComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "parameter", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ValueSet", "name", element.getNameElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "ValueSet", "value", element.getValue(), -1);
        }
    }

    protected void composeValueSetValueSetExpansionContainsComponent(RdfGenerator.Complex parent, String parentType, String name, ValueSet.ValueSetExpansionContainsComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contains", name, element, index);
        if (element.hasSystemElement()) {
            this.composeUri(t, "ValueSet", "system", element.getSystemElement(), -1);
        }
        if (element.hasAbstractElement()) {
            this.composeBoolean(t, "ValueSet", "abstract", element.getAbstractElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ValueSet", "version", element.getVersionElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "ValueSet", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "ValueSet", "display", element.getDisplayElement(), -1);
        }
        for (int i = 0; i < element.getContains().size(); ++i) {
            this.composeValueSetValueSetExpansionContainsComponent(t, "ValueSet", "contains", element.getContains().get(i), i);
        }
    }

    protected void composeVisionPrescription(RdfGenerator.Complex parent, String parentType, String name, VisionPrescription element, int index) {
        int i;
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "VisionPrescription", name, element, index);
        for (i = 0; i < element.getIdentifier().size(); ++i) {
            this.composeIdentifier(t, "VisionPrescription", "identifier", element.getIdentifier().get(i), i);
        }
        if (element.hasDateWrittenElement()) {
            this.composeDateTime(t, "VisionPrescription", "dateWritten", element.getDateWrittenElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "VisionPrescription", "patient", element.getPatient(), -1);
        }
        if (element.hasPrescriber()) {
            this.composeReference(t, "VisionPrescription", "prescriber", element.getPrescriber(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "VisionPrescription", "encounter", element.getEncounter(), -1);
        }
        if (element.hasReason()) {
            this.composeType(t, "VisionPrescription", "reason", element.getReason(), -1);
        }
        for (i = 0; i < element.getDispense().size(); ++i) {
            this.composeVisionPrescriptionVisionPrescriptionDispenseComponent(t, "VisionPrescription", "dispense", element.getDispense().get(i), i);
        }
    }

    protected void composeVisionPrescriptionVisionPrescriptionDispenseComponent(RdfGenerator.Complex parent, String parentType, String name, VisionPrescription.VisionPrescriptionDispenseComponent element, int index) {
        if (element == null) {
            return;
        }
        RdfGenerator.Complex t = Utilities.noString((String)parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dispense", name, element, index);
        if (element.hasProduct()) {
            this.composeCoding(t, "VisionPrescription", "product", element.getProduct(), -1);
        }
        if (element.hasEyeElement()) {
            this.composeEnum(t, "VisionPrescription", "eye", element.getEyeElement(), -1);
        }
        if (element.hasSphereElement()) {
            this.composeDecimal(t, "VisionPrescription", "sphere", element.getSphereElement(), -1);
        }
        if (element.hasCylinderElement()) {
            this.composeDecimal(t, "VisionPrescription", "cylinder", element.getCylinderElement(), -1);
        }
        if (element.hasAxisElement()) {
            this.composeInteger(t, "VisionPrescription", "axis", element.getAxisElement(), -1);
        }
        if (element.hasPrismElement()) {
            this.composeDecimal(t, "VisionPrescription", "prism", element.getPrismElement(), -1);
        }
        if (element.hasBaseElement()) {
            this.composeEnum(t, "VisionPrescription", "base", element.getBaseElement(), -1);
        }
        if (element.hasAddElement()) {
            this.composeDecimal(t, "VisionPrescription", "add", element.getAddElement(), -1);
        }
        if (element.hasPowerElement()) {
            this.composeDecimal(t, "VisionPrescription", "power", element.getPowerElement(), -1);
        }
        if (element.hasBackCurveElement()) {
            this.composeDecimal(t, "VisionPrescription", "backCurve", element.getBackCurveElement(), -1);
        }
        if (element.hasDiameterElement()) {
            this.composeDecimal(t, "VisionPrescription", "diameter", element.getDiameterElement(), -1);
        }
        if (element.hasDuration()) {
            this.composeQuantity(t, "VisionPrescription", "duration", element.getDuration(), -1);
        }
        if (element.hasColorElement()) {
            this.composeString(t, "VisionPrescription", "color", element.getColorElement(), -1);
        }
        if (element.hasBrandElement()) {
            this.composeString(t, "VisionPrescription", "brand", element.getBrandElement(), -1);
        }
        if (element.hasNotesElement()) {
            this.composeString(t, "VisionPrescription", "notes", element.getNotesElement(), -1);
        }
    }

    @Override
    protected void composeResource(RdfGenerator.Complex parent, Resource resource) {
        if (resource instanceof Parameters) {
            this.composeParameters(parent, null, "Parameters", (Parameters)resource, -1);
        } else if (resource instanceof Account) {
            this.composeAccount(parent, null, "Account", (Account)resource, -1);
        } else if (resource instanceof AllergyIntolerance) {
            this.composeAllergyIntolerance(parent, null, "AllergyIntolerance", (AllergyIntolerance)resource, -1);
        } else if (resource instanceof Appointment) {
            this.composeAppointment(parent, null, "Appointment", (Appointment)resource, -1);
        } else if (resource instanceof AppointmentResponse) {
            this.composeAppointmentResponse(parent, null, "AppointmentResponse", (AppointmentResponse)resource, -1);
        } else if (resource instanceof AuditEvent) {
            this.composeAuditEvent(parent, null, "AuditEvent", (AuditEvent)resource, -1);
        } else if (resource instanceof Basic) {
            this.composeBasic(parent, null, "Basic", (Basic)resource, -1);
        } else if (resource instanceof Binary) {
            this.composeBinary(parent, null, "Binary", (Binary)resource, -1);
        } else if (resource instanceof BodySite) {
            this.composeBodySite(parent, null, "BodySite", (BodySite)resource, -1);
        } else if (resource instanceof Bundle) {
            this.composeBundle(parent, null, "Bundle", (Bundle)resource, -1);
        } else if (resource instanceof CarePlan) {
            this.composeCarePlan(parent, null, "CarePlan", (CarePlan)resource, -1);
        } else if (resource instanceof CareTeam) {
            this.composeCareTeam(parent, null, "CareTeam", (CareTeam)resource, -1);
        } else if (resource instanceof Claim) {
            this.composeClaim(parent, null, "Claim", (Claim)resource, -1);
        } else if (resource instanceof ClaimResponse) {
            this.composeClaimResponse(parent, null, "ClaimResponse", (ClaimResponse)resource, -1);
        } else if (resource instanceof ClinicalImpression) {
            this.composeClinicalImpression(parent, null, "ClinicalImpression", (ClinicalImpression)resource, -1);
        } else if (resource instanceof CodeSystem) {
            this.composeCodeSystem(parent, null, "CodeSystem", (CodeSystem)resource, -1);
        } else if (resource instanceof Communication) {
            this.composeCommunication(parent, null, "Communication", (Communication)resource, -1);
        } else if (resource instanceof CommunicationRequest) {
            this.composeCommunicationRequest(parent, null, "CommunicationRequest", (CommunicationRequest)resource, -1);
        } else if (resource instanceof CompartmentDefinition) {
            this.composeCompartmentDefinition(parent, null, "CompartmentDefinition", (CompartmentDefinition)resource, -1);
        } else if (resource instanceof Composition) {
            this.composeComposition(parent, null, "Composition", (Composition)resource, -1);
        } else if (resource instanceof ConceptMap) {
            this.composeConceptMap(parent, null, "ConceptMap", (ConceptMap)resource, -1);
        } else if (resource instanceof Condition) {
            this.composeCondition(parent, null, "Condition", (Condition)resource, -1);
        } else if (resource instanceof Conformance) {
            this.composeConformance(parent, null, "Conformance", (Conformance)resource, -1);
        } else if (resource instanceof Contract) {
            this.composeContract(parent, null, "Contract", (Contract)resource, -1);
        } else if (resource instanceof Coverage) {
            this.composeCoverage(parent, null, "Coverage", (Coverage)resource, -1);
        } else if (resource instanceof DataElement) {
            this.composeDataElement(parent, null, "DataElement", (DataElement)resource, -1);
        } else if (resource instanceof DecisionSupportRule) {
            this.composeDecisionSupportRule(parent, null, "DecisionSupportRule", (DecisionSupportRule)resource, -1);
        } else if (resource instanceof DecisionSupportServiceModule) {
            this.composeDecisionSupportServiceModule(parent, null, "DecisionSupportServiceModule", (DecisionSupportServiceModule)resource, -1);
        } else if (resource instanceof DetectedIssue) {
            this.composeDetectedIssue(parent, null, "DetectedIssue", (DetectedIssue)resource, -1);
        } else if (resource instanceof Device) {
            this.composeDevice(parent, null, "Device", (Device)resource, -1);
        } else if (resource instanceof DeviceComponent) {
            this.composeDeviceComponent(parent, null, "DeviceComponent", (DeviceComponent)resource, -1);
        } else if (resource instanceof DeviceMetric) {
            this.composeDeviceMetric(parent, null, "DeviceMetric", (DeviceMetric)resource, -1);
        } else if (resource instanceof DeviceUseRequest) {
            this.composeDeviceUseRequest(parent, null, "DeviceUseRequest", (DeviceUseRequest)resource, -1);
        } else if (resource instanceof DeviceUseStatement) {
            this.composeDeviceUseStatement(parent, null, "DeviceUseStatement", (DeviceUseStatement)resource, -1);
        } else if (resource instanceof DiagnosticOrder) {
            this.composeDiagnosticOrder(parent, null, "DiagnosticOrder", (DiagnosticOrder)resource, -1);
        } else if (resource instanceof DiagnosticReport) {
            this.composeDiagnosticReport(parent, null, "DiagnosticReport", (DiagnosticReport)resource, -1);
        } else if (resource instanceof DocumentManifest) {
            this.composeDocumentManifest(parent, null, "DocumentManifest", (DocumentManifest)resource, -1);
        } else if (resource instanceof DocumentReference) {
            this.composeDocumentReference(parent, null, "DocumentReference", (DocumentReference)resource, -1);
        } else if (resource instanceof EligibilityRequest) {
            this.composeEligibilityRequest(parent, null, "EligibilityRequest", (EligibilityRequest)resource, -1);
        } else if (resource instanceof EligibilityResponse) {
            this.composeEligibilityResponse(parent, null, "EligibilityResponse", (EligibilityResponse)resource, -1);
        } else if (resource instanceof Encounter) {
            this.composeEncounter(parent, null, "Encounter", (Encounter)resource, -1);
        } else if (resource instanceof EnrollmentRequest) {
            this.composeEnrollmentRequest(parent, null, "EnrollmentRequest", (EnrollmentRequest)resource, -1);
        } else if (resource instanceof EnrollmentResponse) {
            this.composeEnrollmentResponse(parent, null, "EnrollmentResponse", (EnrollmentResponse)resource, -1);
        } else if (resource instanceof EpisodeOfCare) {
            this.composeEpisodeOfCare(parent, null, "EpisodeOfCare", (EpisodeOfCare)resource, -1);
        } else if (resource instanceof ExpansionProfile) {
            this.composeExpansionProfile(parent, null, "ExpansionProfile", (ExpansionProfile)resource, -1);
        } else if (resource instanceof ExplanationOfBenefit) {
            this.composeExplanationOfBenefit(parent, null, "ExplanationOfBenefit", (ExplanationOfBenefit)resource, -1);
        } else if (resource instanceof FamilyMemberHistory) {
            this.composeFamilyMemberHistory(parent, null, "FamilyMemberHistory", (FamilyMemberHistory)resource, -1);
        } else if (resource instanceof Flag) {
            this.composeFlag(parent, null, "Flag", (Flag)resource, -1);
        } else if (resource instanceof Goal) {
            this.composeGoal(parent, null, "Goal", (Goal)resource, -1);
        } else if (resource instanceof Group) {
            this.composeGroup(parent, null, "Group", (Group)resource, -1);
        } else if (resource instanceof GuidanceResponse) {
            this.composeGuidanceResponse(parent, null, "GuidanceResponse", (GuidanceResponse)resource, -1);
        } else if (resource instanceof HealthcareService) {
            this.composeHealthcareService(parent, null, "HealthcareService", (HealthcareService)resource, -1);
        } else if (resource instanceof ImagingExcerpt) {
            this.composeImagingExcerpt(parent, null, "ImagingExcerpt", (ImagingExcerpt)resource, -1);
        } else if (resource instanceof ImagingObjectSelection) {
            this.composeImagingObjectSelection(parent, null, "ImagingObjectSelection", (ImagingObjectSelection)resource, -1);
        } else if (resource instanceof ImagingStudy) {
            this.composeImagingStudy(parent, null, "ImagingStudy", (ImagingStudy)resource, -1);
        } else if (resource instanceof Immunization) {
            this.composeImmunization(parent, null, "Immunization", (Immunization)resource, -1);
        } else if (resource instanceof ImmunizationRecommendation) {
            this.composeImmunizationRecommendation(parent, null, "ImmunizationRecommendation", (ImmunizationRecommendation)resource, -1);
        } else if (resource instanceof ImplementationGuide) {
            this.composeImplementationGuide(parent, null, "ImplementationGuide", (ImplementationGuide)resource, -1);
        } else if (resource instanceof Library) {
            this.composeLibrary(parent, null, "Library", (Library)resource, -1);
        } else if (resource instanceof Linkage) {
            this.composeLinkage(parent, null, "Linkage", (Linkage)resource, -1);
        } else if (resource instanceof ListResource) {
            this.composeListResource(parent, null, "ListResource", (ListResource)resource, -1);
        } else if (resource instanceof Location) {
            this.composeLocation(parent, null, "Location", (Location)resource, -1);
        } else if (resource instanceof Measure) {
            this.composeMeasure(parent, null, "Measure", (Measure)resource, -1);
        } else if (resource instanceof MeasureReport) {
            this.composeMeasureReport(parent, null, "MeasureReport", (MeasureReport)resource, -1);
        } else if (resource instanceof Media) {
            this.composeMedia(parent, null, "Media", (Media)resource, -1);
        } else if (resource instanceof Medication) {
            this.composeMedication(parent, null, "Medication", (Medication)resource, -1);
        } else if (resource instanceof MedicationAdministration) {
            this.composeMedicationAdministration(parent, null, "MedicationAdministration", (MedicationAdministration)resource, -1);
        } else if (resource instanceof MedicationDispense) {
            this.composeMedicationDispense(parent, null, "MedicationDispense", (MedicationDispense)resource, -1);
        } else if (resource instanceof MedicationOrder) {
            this.composeMedicationOrder(parent, null, "MedicationOrder", (MedicationOrder)resource, -1);
        } else if (resource instanceof MedicationStatement) {
            this.composeMedicationStatement(parent, null, "MedicationStatement", (MedicationStatement)resource, -1);
        } else if (resource instanceof MessageHeader) {
            this.composeMessageHeader(parent, null, "MessageHeader", (MessageHeader)resource, -1);
        } else if (resource instanceof ModuleDefinition) {
            this.composeModuleDefinition(parent, null, "ModuleDefinition", (ModuleDefinition)resource, -1);
        } else if (resource instanceof NamingSystem) {
            this.composeNamingSystem(parent, null, "NamingSystem", (NamingSystem)resource, -1);
        } else if (resource instanceof NutritionOrder) {
            this.composeNutritionOrder(parent, null, "NutritionOrder", (NutritionOrder)resource, -1);
        } else if (resource instanceof Observation) {
            this.composeObservation(parent, null, "Observation", (Observation)resource, -1);
        } else if (resource instanceof OperationDefinition) {
            this.composeOperationDefinition(parent, null, "OperationDefinition", (OperationDefinition)resource, -1);
        } else if (resource instanceof OperationOutcome) {
            this.composeOperationOutcome(parent, null, "OperationOutcome", (OperationOutcome)resource, -1);
        } else if (resource instanceof Order) {
            this.composeOrder(parent, null, "Order", (Order)resource, -1);
        } else if (resource instanceof OrderResponse) {
            this.composeOrderResponse(parent, null, "OrderResponse", (OrderResponse)resource, -1);
        } else if (resource instanceof OrderSet) {
            this.composeOrderSet(parent, null, "OrderSet", (OrderSet)resource, -1);
        } else if (resource instanceof Organization) {
            this.composeOrganization(parent, null, "Organization", (Organization)resource, -1);
        } else if (resource instanceof Patient) {
            this.composePatient(parent, null, "Patient", (Patient)resource, -1);
        } else if (resource instanceof PaymentNotice) {
            this.composePaymentNotice(parent, null, "PaymentNotice", (PaymentNotice)resource, -1);
        } else if (resource instanceof PaymentReconciliation) {
            this.composePaymentReconciliation(parent, null, "PaymentReconciliation", (PaymentReconciliation)resource, -1);
        } else if (resource instanceof Person) {
            this.composePerson(parent, null, "Person", (Person)resource, -1);
        } else if (resource instanceof Practitioner) {
            this.composePractitioner(parent, null, "Practitioner", (Practitioner)resource, -1);
        } else if (resource instanceof PractitionerRole) {
            this.composePractitionerRole(parent, null, "PractitionerRole", (PractitionerRole)resource, -1);
        } else if (resource instanceof Procedure) {
            this.composeProcedure(parent, null, "Procedure", (Procedure)resource, -1);
        } else if (resource instanceof ProcedureRequest) {
            this.composeProcedureRequest(parent, null, "ProcedureRequest", (ProcedureRequest)resource, -1);
        } else if (resource instanceof ProcessRequest) {
            this.composeProcessRequest(parent, null, "ProcessRequest", (ProcessRequest)resource, -1);
        } else if (resource instanceof ProcessResponse) {
            this.composeProcessResponse(parent, null, "ProcessResponse", (ProcessResponse)resource, -1);
        } else if (resource instanceof Protocol) {
            this.composeProtocol(parent, null, "Protocol", (Protocol)resource, -1);
        } else if (resource instanceof Provenance) {
            this.composeProvenance(parent, null, "Provenance", (Provenance)resource, -1);
        } else if (resource instanceof Questionnaire) {
            this.composeQuestionnaire(parent, null, "Questionnaire", (Questionnaire)resource, -1);
        } else if (resource instanceof QuestionnaireResponse) {
            this.composeQuestionnaireResponse(parent, null, "QuestionnaireResponse", (QuestionnaireResponse)resource, -1);
        } else if (resource instanceof ReferralRequest) {
            this.composeReferralRequest(parent, null, "ReferralRequest", (ReferralRequest)resource, -1);
        } else if (resource instanceof RelatedPerson) {
            this.composeRelatedPerson(parent, null, "RelatedPerson", (RelatedPerson)resource, -1);
        } else if (resource instanceof RiskAssessment) {
            this.composeRiskAssessment(parent, null, "RiskAssessment", (RiskAssessment)resource, -1);
        } else if (resource instanceof Schedule) {
            this.composeSchedule(parent, null, "Schedule", (Schedule)resource, -1);
        } else if (resource instanceof SearchParameter) {
            this.composeSearchParameter(parent, null, "SearchParameter", (SearchParameter)resource, -1);
        } else if (resource instanceof Sequence) {
            this.composeSequence(parent, null, "Sequence", (Sequence)resource, -1);
        } else if (resource instanceof Slot) {
            this.composeSlot(parent, null, "Slot", (Slot)resource, -1);
        } else if (resource instanceof Specimen) {
            this.composeSpecimen(parent, null, "Specimen", (Specimen)resource, -1);
        } else if (resource instanceof StructureDefinition) {
            this.composeStructureDefinition(parent, null, "StructureDefinition", (StructureDefinition)resource, -1);
        } else if (resource instanceof StructureMap) {
            this.composeStructureMap(parent, null, "StructureMap", (StructureMap)resource, -1);
        } else if (resource instanceof Subscription) {
            this.composeSubscription(parent, null, "Subscription", (Subscription)resource, -1);
        } else if (resource instanceof Substance) {
            this.composeSubstance(parent, null, "Substance", (Substance)resource, -1);
        } else if (resource instanceof SupplyDelivery) {
            this.composeSupplyDelivery(parent, null, "SupplyDelivery", (SupplyDelivery)resource, -1);
        } else if (resource instanceof SupplyRequest) {
            this.composeSupplyRequest(parent, null, "SupplyRequest", (SupplyRequest)resource, -1);
        } else if (resource instanceof Task) {
            this.composeTask(parent, null, "Task", (Task)resource, -1);
        } else if (resource instanceof TestScript) {
            this.composeTestScript(parent, null, "TestScript", (TestScript)resource, -1);
        } else if (resource instanceof ValueSet) {
            this.composeValueSet(parent, null, "ValueSet", (ValueSet)resource, -1);
        } else if (resource instanceof VisionPrescription) {
            this.composeVisionPrescription(parent, null, "VisionPrescription", (VisionPrescription)resource, -1);
        } else {
            throw new Error("Unhandled resource type " + resource.getClass().getName());
        }
    }

    protected void composeType(RdfGenerator.Complex parent, String parentType, String name, Type value, int index) {
        if (value == null) {
            return;
        }
        if (value instanceof MarkdownType) {
            this.composeMarkdown(parent, parentType, name, (MarkdownType)value, index);
        } else if (value instanceof IntegerType) {
            this.composeInteger(parent, parentType, name, (IntegerType)value, index);
        } else if (value instanceof DateTimeType) {
            this.composeDateTime(parent, parentType, name, (DateTimeType)value, index);
        } else if (value instanceof UnsignedIntType) {
            this.composeUnsignedInt(parent, parentType, name, (UnsignedIntType)value, index);
        } else if (value instanceof CodeType) {
            this.composeCode(parent, parentType, name, (CodeType)value, index);
        } else if (value instanceof DateType) {
            this.composeDate(parent, parentType, name, (DateType)value, index);
        } else if (value instanceof DecimalType) {
            this.composeDecimal(parent, parentType, name, (DecimalType)value, index);
        } else if (value instanceof UriType) {
            this.composeUri(parent, parentType, name, (UriType)value, index);
        } else if (value instanceof IdType) {
            this.composeId(parent, parentType, name, (IdType)value, index);
        } else if (value instanceof Base64BinaryType) {
            this.composeBase64Binary(parent, parentType, name, (Base64BinaryType)value, index);
        } else if (value instanceof TimeType) {
            this.composeTime(parent, parentType, name, (TimeType)value, index);
        } else if (value instanceof OidType) {
            this.composeOid(parent, parentType, name, (OidType)value, index);
        } else if (value instanceof PositiveIntType) {
            this.composePositiveInt(parent, parentType, name, (PositiveIntType)value, index);
        } else if (value instanceof StringType) {
            this.composeString(parent, parentType, name, (StringType)value, index);
        } else if (value instanceof BooleanType) {
            this.composeBoolean(parent, parentType, name, (BooleanType)value, index);
        } else if (value instanceof UuidType) {
            this.composeUuid(parent, parentType, name, (UuidType)value, index);
        } else if (value instanceof InstantType) {
            this.composeInstant(parent, parentType, name, (InstantType)value, index);
        } else if (value instanceof Extension) {
            this.composeExtension(parent, parentType, name, (Extension)value, index);
        } else if (value instanceof Narrative) {
            this.composeNarrative(parent, parentType, name, (Narrative)value, index);
        } else if (value instanceof Period) {
            this.composePeriod(parent, parentType, name, (Period)value, index);
        } else if (value instanceof Coding) {
            this.composeCoding(parent, parentType, name, (Coding)value, index);
        } else if (value instanceof Range) {
            this.composeRange(parent, parentType, name, (Range)value, index);
        } else if (value instanceof Quantity) {
            this.composeQuantity(parent, parentType, name, (Quantity)value, index);
        } else if (value instanceof Attachment) {
            this.composeAttachment(parent, parentType, name, (Attachment)value, index);
        } else if (value instanceof Ratio) {
            this.composeRatio(parent, parentType, name, (Ratio)value, index);
        } else if (value instanceof Annotation) {
            this.composeAnnotation(parent, parentType, name, (Annotation)value, index);
        } else if (value instanceof SampledData) {
            this.composeSampledData(parent, parentType, name, (SampledData)value, index);
        } else if (value instanceof Reference) {
            this.composeReference(parent, parentType, name, (Reference)value, index);
        } else if (value instanceof CodeableConcept) {
            this.composeCodeableConcept(parent, parentType, name, (CodeableConcept)value, index);
        } else if (value instanceof Identifier) {
            this.composeIdentifier(parent, parentType, name, (Identifier)value, index);
        } else if (value instanceof Signature) {
            this.composeSignature(parent, parentType, name, (Signature)value, index);
        } else if (value instanceof TriggerDefinition) {
            this.composeTriggerDefinition(parent, parentType, name, (TriggerDefinition)value, index);
        } else if (value instanceof ElementDefinition) {
            this.composeElementDefinition(parent, parentType, name, (ElementDefinition)value, index);
        } else if (value instanceof Timing) {
            this.composeTiming(parent, parentType, name, (Timing)value, index);
        } else if (value instanceof ModuleMetadata) {
            this.composeModuleMetadata(parent, parentType, name, (ModuleMetadata)value, index);
        } else if (value instanceof ActionDefinition) {
            this.composeActionDefinition(parent, parentType, name, (ActionDefinition)value, index);
        } else if (value instanceof Address) {
            this.composeAddress(parent, parentType, name, (Address)value, index);
        } else if (value instanceof HumanName) {
            this.composeHumanName(parent, parentType, name, (HumanName)value, index);
        } else if (value instanceof DataRequirement) {
            this.composeDataRequirement(parent, parentType, name, (DataRequirement)value, index);
        } else if (value instanceof Meta) {
            this.composeMeta(parent, parentType, name, (Meta)value, index);
        } else if (value instanceof ParameterDefinition) {
            this.composeParameterDefinition(parent, parentType, name, (ParameterDefinition)value, index);
        } else if (value instanceof ContactPoint) {
            this.composeContactPoint(parent, parentType, name, (ContactPoint)value, index);
        } else {
            throw new Error("Unhandled type");
        }
    }
}

