/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hl7.fhir.dstu2016may.formats.IParser;
import org.hl7.fhir.dstu2016may.formats.XmlParser;
import org.hl7.fhir.dstu2016may.metamodel.Element;
import org.hl7.fhir.dstu2016may.metamodel.Manager;
import org.hl7.fhir.dstu2016may.model.Bundle;
import org.hl7.fhir.dstu2016may.model.StructureMap;
import org.hl7.fhir.dstu2016may.utils.SimpleWorkerContext;
import org.hl7.fhir.dstu2016may.utils.StructureMapUtilities;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;

public class Transformer {
    private String txServer;
    private String definitions;
    private List<String> folders = new ArrayList<String>();
    private String source;
    private String mapUri;
    private String output;
    private String message;
    private StructureMapUtilities scu;

    public String getTxServer() {
        return this.txServer;
    }

    public void setTxServer(String txServer) {
        this.txServer = txServer;
    }

    public String getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(String definitions) {
        this.definitions = definitions;
    }

    public List<String> getFolders() {
        return this.folders;
    }

    public void addFolder(String value) {
        this.folders.add(value);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public String getMapUri() {
        return this.mapUri;
    }

    public void setMapUri(String mapUri) {
        this.mapUri = mapUri;
    }

    public boolean process() {
        try {
            System.out.println("  .. load definitions from " + this.definitions);
            SimpleWorkerContext context = SimpleWorkerContext.fromPack(this.definitions);
            this.scu = new StructureMapUtilities(context, new HashMap<String, StructureMap>(), null);
            for (String folder : this.folders) {
                System.out.println("  .. load additional definitions from " + folder);
                context.loadFromFolder(folder);
                this.loadMaps(folder);
            }
            System.out.println("  .. load source from " + this.source);
            Element e = Manager.parse(context, ManagedFileAccess.inStream((String)this.source), Manager.FhirFormat.XML);
            Bundle bundle = new Bundle();
            StructureMap map = this.scu.getLibrary().get(this.mapUri);
            if (map == null) {
                throw new Error("Unable to find map " + this.mapUri + " (Known Maps = " + Utilities.listCanonicalUrls(this.scu.getLibrary().keySet()) + ")");
            }
            this.scu.transform(null, e, map, bundle);
            new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(ManagedFileAccess.outStream((String)this.output), bundle);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = e.getMessage();
            return false;
        }
    }

    private void loadMaps(String folder) throws IOException {
        for (String f : ManagedFileAccess.file((String)folder).list()) {
            try {
                StructureMap map = this.scu.parse(TextFile.fileToString((String)Utilities.path((String[])new String[]{folder, f})));
                this.scu.getLibrary().put(map.getUrl(), map);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getMessage() {
        return this.message;
    }
}

