/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.utils;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.hl7.fhir.dstu2016may.formats.IParser;
import org.hl7.fhir.dstu2016may.formats.JsonParser;
import org.hl7.fhir.dstu2016may.formats.ParserType;
import org.hl7.fhir.dstu2016may.formats.XmlParser;
import org.hl7.fhir.dstu2016may.model.Bundle;
import org.hl7.fhir.dstu2016may.model.CodeSystem;
import org.hl7.fhir.dstu2016may.model.ConceptMap;
import org.hl7.fhir.dstu2016may.model.ElementDefinition;
import org.hl7.fhir.dstu2016may.model.NamingSystem;
import org.hl7.fhir.dstu2016may.model.Questionnaire;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StructureDefinition;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.dstu2016may.terminologies.ValueSetExpansionCache;
import org.hl7.fhir.dstu2016may.utils.BaseWorkerContext;
import org.hl7.fhir.dstu2016may.utils.INarrativeGenerator;
import org.hl7.fhir.dstu2016may.utils.IWorkerContext;
import org.hl7.fhir.dstu2016may.utils.NarrativeGenerator;
import org.hl7.fhir.dstu2016may.utils.ProfileUtilities;
import org.hl7.fhir.dstu2016may.utils.client.FHIRToolingClient;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.OIDUtils;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.CSFileInputStream;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class SimpleWorkerContext
extends BaseWorkerContext
implements IWorkerContext,
ProfileUtilities.ProfileKnowledgeProvider {
    private Map<String, StructureDefinition> structures = new HashMap<String, StructureDefinition>();
    private List<NamingSystem> systems = new ArrayList<NamingSystem>();
    private Questionnaire questionnaire;

    public static SimpleWorkerContext fromPack(String path) throws FileNotFoundException, IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        res.loadFromPack(path);
        return res;
    }

    public static SimpleWorkerContext fromClassPath() throws IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        res.loadFromStream(SimpleWorkerContext.class.getResourceAsStream("validation.zip"));
        return res;
    }

    public static SimpleWorkerContext fromDefinitions(Map<String, byte[]> source) throws IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        for (String name : source.keySet()) {
            if (!name.endsWith(".xml")) continue;
            res.loadFromFile(new ByteArrayInputStream(source.get(name)), name);
        }
        return res;
    }

    public void connectToTSServer(String url) throws URISyntaxException {
        this.txServer = new FHIRToolingClient(url);
    }

    private void loadFromFile(InputStream stream, String name) throws IOException, FHIRException {
        Bundle f;
        XmlParser xml = new XmlParser();
        try {
            f = (Bundle)xml.parse(stream);
        }
        catch (FHIRFormatError e1) {
            throw new FHIRFormatError(e1.getMessage(), (Throwable)e1);
        }
        for (Bundle.BundleEntryComponent e : f.getEntry()) {
            if (e.getFullUrl() == null) {
                System.out.println("unidentified resource in " + name + " (no fullUrl)");
            }
            this.seeResource(e.getFullUrl(), e.getResource());
        }
    }

    public void seeResource(String url, Resource r) throws FHIRException {
        if (r instanceof StructureDefinition) {
            this.seeProfile(url, (StructureDefinition)r);
        } else if (r instanceof ValueSet) {
            this.seeValueSet(url, (ValueSet)r);
        } else if (r instanceof CodeSystem) {
            this.seeCodeSystem(url, (CodeSystem)r);
        } else if (r instanceof ConceptMap) {
            this.maps.put(((ConceptMap)r).getUrl(), (ConceptMap)r);
        } else if (r instanceof NamingSystem) {
            this.systems.add((NamingSystem)r);
        }
    }

    private void seeValueSet(String url, ValueSet vs) throws DefinitionException {
        if (Utilities.noString((String)url)) {
            url = vs.getUrl();
        }
        if (this.valueSets.containsKey(vs.getUrl())) {
            throw new DefinitionException("Duplicate Profile " + vs.getUrl());
        }
        this.valueSets.put(vs.getId(), vs);
        this.valueSets.put(vs.getUrl(), vs);
        if (!vs.getUrl().equals(url)) {
            this.valueSets.put(url, vs);
        }
    }

    private void seeCodeSystem(String url, CodeSystem cs) throws DefinitionException {
        this.codeSystems.put(cs.getUrl(), cs);
    }

    private void seeProfile(String url, StructureDefinition p) throws FHIRException {
        if (Utilities.noString((String)url)) {
            url = p.getUrl();
        }
        if (!p.hasSnapshot()) {
            if (!p.hasBaseDefinition()) {
                throw new DefinitionException("Profile " + p.getName() + " (" + p.getUrl() + ") has no base and no snapshot");
            }
            StructureDefinition sd = this.fetchResource(StructureDefinition.class, p.getBaseDefinition());
            if (sd == null) {
                throw new DefinitionException("Profile " + p.getName() + " (" + p.getUrl() + ") base " + p.getBaseDefinition() + " could not be resolved");
            }
            ArrayList<ValidationMessage> msgs = new ArrayList<ValidationMessage>();
            ProfileUtilities pu = new ProfileUtilities(this, msgs, this);
            pu.generateSnapshot(sd, p, p.getUrl(), p.getName());
            for (ValidationMessage msg : msgs) {
                if (msg.getLevel() != ValidationMessage.IssueSeverity.ERROR && msg.getLevel() != ValidationMessage.IssueSeverity.FATAL) continue;
                throw new DefinitionException("Profile " + p.getName() + " (" + p.getUrl() + "). Error generating snapshot: " + msg.getMessage());
            }
            if (!p.hasSnapshot()) {
                throw new DefinitionException("Profile " + p.getName() + " (" + p.getUrl() + "). Error generating snapshot");
            }
            pu = null;
        }
        if (this.structures.containsKey(p.getUrl())) {
            throw new DefinitionException("Duplicate structures " + p.getUrl());
        }
        this.structures.put(p.getId(), p);
        this.structures.put(p.getUrl(), p);
        if (!p.getUrl().equals(url)) {
            this.structures.put(url, p);
        }
    }

    private void loadFromPack(String path) throws FileNotFoundException, IOException, FHIRException {
        this.loadFromStream((InputStream)new CSFileInputStream(path));
    }

    private void loadFromStream(InputStream stream) throws IOException, FHIRException {
        ZipEntry ze;
        ZipInputStream zip = new ZipInputStream(stream);
        while ((ze = zip.getNextEntry()) != null) {
            if (ze.getName().endsWith(".xml")) {
                String name = ze.getName();
                this.loadFromFile(zip, name);
            }
            zip.closeEntry();
        }
        zip.close();
    }

    @Override
    public IParser getParser(ParserType type) {
        switch (type) {
            case JSON: {
                return this.newJsonParser();
            }
            case XML: {
                return this.newXmlParser();
            }
        }
        throw new Error("Parser Type " + type.toString() + " not supported");
    }

    @Override
    public IParser getParser(String type) {
        if (type.equalsIgnoreCase("JSON")) {
            return new JsonParser();
        }
        if (type.equalsIgnoreCase("XML")) {
            return new XmlParser();
        }
        throw new Error("Parser Type " + type.toString() + " not supported");
    }

    @Override
    public IParser newJsonParser() {
        return new JsonParser();
    }

    @Override
    public IParser newXmlParser() {
        return new XmlParser();
    }

    @Override
    public <T extends Resource> boolean hasResource(Class<T> class_, String uri) {
        try {
            return this.fetchResource(class_, uri) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public INarrativeGenerator getNarrativeGenerator(String prefix, String basePath) {
        return new NarrativeGenerator(prefix, basePath, this);
    }

    @Override
    public <T extends Resource> T fetchResource(Class<T> class_, String uri) {
        if (class_ == Questionnaire.class) {
            return (T)this.questionnaire;
        }
        if (class_ == StructureDefinition.class && !((String)uri).contains("/")) {
            uri = "http://hl7.org/fhir/StructureDefinition/" + (String)uri;
        }
        if (((String)uri).startsWith("http:")) {
            if (((String)uri).contains("#")) {
                uri = ((String)uri).substring(0, ((String)uri).indexOf("#"));
            }
            if (class_ == StructureDefinition.class) {
                if (this.structures.containsKey(uri)) {
                    return (T)this.structures.get(uri);
                }
                return null;
            }
            if (class_ == ValueSet.class) {
                if (this.valueSets.containsKey(uri)) {
                    return (T)((Resource)this.valueSets.get(uri));
                }
                return null;
            }
            if (class_ == CodeSystem.class) {
                if (this.codeSystems.containsKey(uri)) {
                    return (T)((Resource)this.codeSystems.get(uri));
                }
                return null;
            }
            if (class_ == ConceptMap.class) {
                if (this.maps.containsKey(uri)) {
                    return (T)((Resource)this.maps.get(uri));
                }
                return null;
            }
        }
        if (class_ == null && ((String)uri).contains("/")) {
            return null;
        }
        throw new Error("not done yet");
    }

    public int totalCount() {
        return this.valueSets.size() + this.maps.size() + this.structures.size();
    }

    public void setCache(ValueSetExpansionCache cache) {
        this.expansionCache = cache;
    }

    @Override
    public List<String> getResourceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (StructureDefinition sd : this.structures.values()) {
            if (sd.getKind() != StructureDefinition.StructureDefinitionKind.RESOURCE || sd.hasBaseType()) continue;
            result.add(sd.getName());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public String getAbbreviation(String name) {
        return "xxx";
    }

    @Override
    public boolean isDatatype(String typeSimple) {
        return false;
    }

    @Override
    public boolean isResource(String t) {
        StructureDefinition sd;
        try {
            sd = this.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + t);
        }
        catch (Exception e) {
            return false;
        }
        if (sd == null) {
            return false;
        }
        if (sd.hasBaseType()) {
            return false;
        }
        return sd.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE;
    }

    @Override
    public boolean hasLinkFor(String typeSimple) {
        return false;
    }

    @Override
    public String getLinkFor(String typeSimple) {
        return null;
    }

    @Override
    public ProfileUtilities.ProfileKnowledgeProvider.BindingResolution resolveBinding(ElementDefinition.ElementDefinitionBindingComponent binding) {
        return null;
    }

    @Override
    public String getLinkForProfile(StructureDefinition profile, String url) {
        return null;
    }

    public Questionnaire getQuestionnaire() {
        return this.questionnaire;
    }

    public void setQuestionnaire(Questionnaire questionnaire) {
        this.questionnaire = questionnaire;
    }

    @Override
    public Set<String> typeTails() {
        return new HashSet<String>(Arrays.asList("Integer", "UnsignedInt", "PositiveInt", "Decimal", "DateTime", "Date", "Time", "Instant", "String", "Uri", "Oid", "Uuid", "Id", "Boolean", "Code", "Markdown", "Base64Binary", "Coding", "CodeableConcept", "Attachment", "Identifier", "Quantity", "SampledData", "Range", "Period", "Ratio", "HumanName", "Address", "ContactPoint", "Timing", "Reference", "Annotation", "Signature", "Meta"));
    }

    @Override
    public List<StructureDefinition> allStructures() {
        ArrayList<StructureDefinition> result = new ArrayList<StructureDefinition>();
        result.addAll(this.structures.values());
        return result;
    }

    @Override
    public String oid2Uri(String oid) {
        String uri = OIDUtils.getUriForOid((String)oid);
        if (uri != null) {
            return uri;
        }
        for (NamingSystem ns : this.systems) {
            if (!this.hasOid(ns, oid) || (uri = this.getUri(ns)) == null) continue;
            return null;
        }
        return null;
    }

    private String getUri(NamingSystem ns) {
        for (NamingSystem.NamingSystemUniqueIdComponent id : ns.getUniqueId()) {
            if (id.getType() != NamingSystem.NamingSystemIdentifierType.URI) continue;
            return id.getValue();
        }
        return null;
    }

    private boolean hasOid(NamingSystem ns, String oid) {
        for (NamingSystem.NamingSystemUniqueIdComponent id : ns.getUniqueId()) {
            if (id.getType() != NamingSystem.NamingSystemIdentifierType.OID || !id.getValue().equals(oid)) continue;
            return true;
        }
        return false;
    }

    public void loadFromFolder(String folder) throws FileNotFoundException, Exception {
        for (String n : ManagedFileAccess.file((String)folder).list()) {
            if (n.endsWith(".json")) {
                this.loadFromFile(Utilities.path((String[])new String[]{folder, n}), new JsonParser());
                continue;
            }
            if (!n.endsWith(".xml")) continue;
            this.loadFromFile(Utilities.path((String[])new String[]{folder, n}), new XmlParser());
        }
    }

    private void loadFromFile(String filename, IParser p) throws FileNotFoundException, Exception {
        try {
            Resource r = p.parse(ManagedFileAccess.inStream((String)filename));
            if (r.getResourceType() == ResourceType.Bundle) {
                for (Bundle.BundleEntryComponent e : ((Bundle)r).getEntry()) {
                    this.seeResource(null, e.getResource());
                }
            } else {
                this.seeResource(null, r);
            }
        }
        catch (Exception e) {
            return;
        }
    }
}

