/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum VersioningPolicy {
    NOVERSION,
    VERSIONED,
    VERSIONEDUPDATE,
    NULL;


    public static VersioningPolicy fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("no-version".equals(codeString)) {
            return NOVERSION;
        }
        if ("versioned".equals(codeString)) {
            return VERSIONED;
        }
        if ("versioned-update".equals(codeString)) {
            return VERSIONEDUPDATE;
        }
        throw new FHIRException("Unknown VersioningPolicy code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case NOVERSION: {
                return "no-version";
            }
            case VERSIONED: {
                return "versioned";
            }
            case VERSIONEDUPDATE: {
                return "versioned-update";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/versioning-policy";
    }

    public String getDefinition() {
        switch (this) {
            case NOVERSION: {
                return "VersionId meta-property is not supported (server) or used (client).";
            }
            case VERSIONED: {
                return "VersionId meta-property is supported (server) or used (client).";
            }
            case VERSIONEDUPDATE: {
                return "VersionId is must be correct for updates (server) or will be specified (If-match header) for updates (client).";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case NOVERSION: {
                return "No VersionId Support";
            }
            case VERSIONED: {
                return "Versioned";
            }
            case VERSIONEDUPDATE: {
                return "VersionId tracked fully";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

