/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum SequenceType {
    AA,
    DNA,
    RNA,
    NULL;


    public static SequenceType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("AA".equals(codeString)) {
            return AA;
        }
        if ("DNA".equals(codeString)) {
            return DNA;
        }
        if ("RNA".equals(codeString)) {
            return RNA;
        }
        throw new FHIRException("Unknown SequenceType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case AA: {
                return "AA";
            }
            case DNA: {
                return "DNA";
            }
            case RNA: {
                return "RNA";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/sequence-type";
    }

    public String getDefinition() {
        switch (this) {
            case AA: {
                return "Amino acid sequence";
            }
            case DNA: {
                return "DNA Sequence";
            }
            case RNA: {
                return "RNA Sequence";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case AA: {
                return "AA Sequence";
            }
            case DNA: {
                return "DNA Sequence";
            }
            case RNA: {
                return "RNA Sequence";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

