/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ProcedureRequestStatus {
    PROPOSED,
    DRAFT,
    REQUESTED,
    RECEIVED,
    ACCEPTED,
    INPROGRESS,
    COMPLETED,
    SUSPENDED,
    REJECTED,
    ABORTED,
    NULL;


    public static ProcedureRequestStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("proposed".equals(codeString)) {
            return PROPOSED;
        }
        if ("draft".equals(codeString)) {
            return DRAFT;
        }
        if ("requested".equals(codeString)) {
            return REQUESTED;
        }
        if ("received".equals(codeString)) {
            return RECEIVED;
        }
        if ("accepted".equals(codeString)) {
            return ACCEPTED;
        }
        if ("in-progress".equals(codeString)) {
            return INPROGRESS;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("suspended".equals(codeString)) {
            return SUSPENDED;
        }
        if ("rejected".equals(codeString)) {
            return REJECTED;
        }
        if ("aborted".equals(codeString)) {
            return ABORTED;
        }
        throw new FHIRException("Unknown ProcedureRequestStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PROPOSED: {
                return "proposed";
            }
            case DRAFT: {
                return "draft";
            }
            case REQUESTED: {
                return "requested";
            }
            case RECEIVED: {
                return "received";
            }
            case ACCEPTED: {
                return "accepted";
            }
            case INPROGRESS: {
                return "in-progress";
            }
            case COMPLETED: {
                return "completed";
            }
            case SUSPENDED: {
                return "suspended";
            }
            case REJECTED: {
                return "rejected";
            }
            case ABORTED: {
                return "aborted";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/procedure-request-status";
    }

    public String getDefinition() {
        switch (this) {
            case PROPOSED: {
                return "The request has been proposed.";
            }
            case DRAFT: {
                return "The request is in preliminary form, prior to being requested.";
            }
            case REQUESTED: {
                return "The request has been placed.";
            }
            case RECEIVED: {
                return "The receiving system has received the request but not yet decided whether it will be performed.";
            }
            case ACCEPTED: {
                return "The receiving system has accepted the request, but work has not yet commenced.";
            }
            case INPROGRESS: {
                return "The work to fulfill the request is happening.";
            }
            case COMPLETED: {
                return "The work has been completed, the report(s) released, and no further work is planned.";
            }
            case SUSPENDED: {
                return "The request has been held by originating system/user request.";
            }
            case REJECTED: {
                return "The receiving system has declined to fulfill the request.";
            }
            case ABORTED: {
                return "The request was attempted, but due to some procedural error, it could not be completed.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PROPOSED: {
                return "Proposed";
            }
            case DRAFT: {
                return "Draft";
            }
            case REQUESTED: {
                return "Requested";
            }
            case RECEIVED: {
                return "Received";
            }
            case ACCEPTED: {
                return "Accepted";
            }
            case INPROGRESS: {
                return "In Progress";
            }
            case COMPLETED: {
                return "Completed";
            }
            case SUSPENDED: {
                return "Suspended";
            }
            case REJECTED: {
                return "Rejected";
            }
            case ABORTED: {
                return "Aborted";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

