/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MapContextType {
    TYPE,
    VARIABLE,
    NULL;


    public static MapContextType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("type".equals(codeString)) {
            return TYPE;
        }
        if ("variable".equals(codeString)) {
            return VARIABLE;
        }
        throw new FHIRException("Unknown MapContextType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case TYPE: {
                return "type";
            }
            case VARIABLE: {
                return "variable";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/map-context-type";
    }

    public String getDefinition() {
        switch (this) {
            case TYPE: {
                return "The context specifies a type";
            }
            case VARIABLE: {
                return "The context specifies a variable";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case TYPE: {
                return "Type";
            }
            case VARIABLE: {
                return "Variable";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

