/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.IdentityAssuranceLevel;

public class IdentityAssuranceLevelEnumFactory
implements EnumFactory<IdentityAssuranceLevel> {
    @Override
    public IdentityAssuranceLevel fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("level1".equals(codeString)) {
            return IdentityAssuranceLevel.LEVEL1;
        }
        if ("level2".equals(codeString)) {
            return IdentityAssuranceLevel.LEVEL2;
        }
        if ("level3".equals(codeString)) {
            return IdentityAssuranceLevel.LEVEL3;
        }
        if ("level4".equals(codeString)) {
            return IdentityAssuranceLevel.LEVEL4;
        }
        throw new IllegalArgumentException("Unknown IdentityAssuranceLevel code '" + codeString + "'");
    }

    @Override
    public String toCode(IdentityAssuranceLevel code) {
        if (code == IdentityAssuranceLevel.LEVEL1) {
            return "level1";
        }
        if (code == IdentityAssuranceLevel.LEVEL2) {
            return "level2";
        }
        if (code == IdentityAssuranceLevel.LEVEL3) {
            return "level3";
        }
        if (code == IdentityAssuranceLevel.LEVEL4) {
            return "level4";
        }
        return "?";
    }

    @Override
    public String toSystem(IdentityAssuranceLevel code) {
        return code.getSystem();
    }
}

