/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum HspcObservationWeightMeasMethodDevice {
    _1964,
    _2007,
    _2139,
    _2142,
    _2180,
    _2181,
    _2185,
    _50550851,
    _521443011,
    NULL;


    public static HspcObservationWeightMeasMethodDevice fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("1964".equals(codeString)) {
            return _1964;
        }
        if ("2007".equals(codeString)) {
            return _2007;
        }
        if ("2139".equals(codeString)) {
            return _2139;
        }
        if ("2142".equals(codeString)) {
            return _2142;
        }
        if ("2180".equals(codeString)) {
            return _2180;
        }
        if ("2181".equals(codeString)) {
            return _2181;
        }
        if ("2185".equals(codeString)) {
            return _2185;
        }
        if ("50550851".equals(codeString)) {
            return _50550851;
        }
        if ("521443011".equals(codeString)) {
            return _521443011;
        }
        throw new FHIRException("Unknown HspcObservationWeightMeasMethodDevice code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _1964: {
                return "1964";
            }
            case _2007: {
                return "2007";
            }
            case _2139: {
                return "2139";
            }
            case _2142: {
                return "2142";
            }
            case _2180: {
                return "2180";
            }
            case _2181: {
                return "2181";
            }
            case _2185: {
                return "2185";
            }
            case _50550851: {
                return "50550851";
            }
            case _521443011: {
                return "521443011";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7,org/fhir/observation-hspc-weightMeasMethodDevice";
    }

    public String getDefinition() {
        switch (this) {
            case _1964: {
                return "A scale that measures the weight of a patient by measuring the total mass of a bed and patient, then subtracts the known mass of the bed.";
            }
            case _2007: {
                return "A scale that measures the weight of a patient by measuring the total mass of a chair and patient, then subtracts the known mass of the chair.";
            }
            case _2139: {
                return "A scale for patients that are unable to stand, patients sit in a sling attached to a boom.";
            }
            case _2142: {
                return "A scale upon which an individual will stand to measure body weight";
            }
            case _2180: {
                return "A measurement of lean body weight made by immersing an individual in water and then measuring the mass of the displacement.";
            }
            case _2181: {
                return "A measurement of lean body weight made by measuring the thickness of a fold of skin.";
            }
            case _2185: {
                return "A body weight based on other measurements plotted on a percentile chart.";
            }
            case _50550851: {
                return "A scale designed for use with infants only";
            }
            case _521443011: {
                return "A measuring tape created to relate a child's height, as measured by the tape to the child's weight";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _1964: {
                return "Bed scale";
            }
            case _2007: {
                return "Chair scale";
            }
            case _2139: {
                return "Sling scale";
            }
            case _2142: {
                return "Standing scale";
            }
            case _2180: {
                return "Weight, lean; immersion";
            }
            case _2181: {
                return "Weight, lean; skin fold";
            }
            case _2185: {
                return "Weight, percentile";
            }
            case _50550851: {
                return "Infant Scale";
            }
            case _521443011: {
                return "Broselow tape";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

