/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum HspcBodytempmethoddevice {
    _30277,
    _30522,
    _82735,
    _84301,
    NULL;


    public static HspcBodytempmethoddevice fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("30277".equals(codeString)) {
            return _30277;
        }
        if ("30522".equals(codeString)) {
            return _30522;
        }
        if ("82735".equals(codeString)) {
            return _82735;
        }
        if ("84301".equals(codeString)) {
            return _84301;
        }
        throw new FHIRException("Unknown HspcBodytempmethoddevice code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _30277: {
                return "30277";
            }
            case _30522: {
                return "30522";
            }
            case _82735: {
                return "82735";
            }
            case _84301: {
                return "84301";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/hspc-bodytempmethoddevice";
    }

    public String getDefinition() {
        switch (this) {
            case _30277: {
                return "The electronic thermometer that displays body temperature in numeric values.";
            }
            case _30522: {
                return "The thermometer that measure the temperature by the intensity of infrared light emission. ";
            }
            case _82735: {
                return "Thermoluminescent diode thermometer is a thermometer that measures the temperature of the emitted heat from the surface of an area.";
            }
            case _84301: {
                return "MRI diffusion thermometer is an instrument that uses MRI diffusion to indicate the temperature of a substance.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _30277: {
                return "Digital Thermometer";
            }
            case _30522: {
                return "Infrared Thermometer";
            }
            case _82735: {
                return "Thermoluminescent diode thermometer";
            }
            case _84301: {
                return "MRI diffusion thermometer";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

