/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.DocumentMode;

public class DocumentModeEnumFactory
implements EnumFactory<DocumentMode> {
    @Override
    public DocumentMode fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("producer".equals(codeString)) {
            return DocumentMode.PRODUCER;
        }
        if ("consumer".equals(codeString)) {
            return DocumentMode.CONSUMER;
        }
        throw new IllegalArgumentException("Unknown DocumentMode code '" + codeString + "'");
    }

    @Override
    public String toCode(DocumentMode code) {
        if (code == DocumentMode.PRODUCER) {
            return "producer";
        }
        if (code == DocumentMode.CONSUMER) {
            return "consumer";
        }
        return "?";
    }

    @Override
    public String toSystem(DocumentMode code) {
        return code.getSystem();
    }
}

