/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.ContractTermSubtype;

public class ContractTermSubtypeEnumFactory
implements EnumFactory<ContractTermSubtype> {
    @Override
    public ContractTermSubtype fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("OralHealth-Basic".equals(codeString)) {
            return ContractTermSubtype.ORALHEALTHBASIC;
        }
        if ("OralHealth-Major".equals(codeString)) {
            return ContractTermSubtype.ORALHEALTHMAJOR;
        }
        if ("OralHealth-Orthodontic".equals(codeString)) {
            return ContractTermSubtype.ORALHEALTHORTHODONTIC;
        }
        throw new IllegalArgumentException("Unknown ContractTermSubtype code '" + codeString + "'");
    }

    @Override
    public String toCode(ContractTermSubtype code) {
        if (code == ContractTermSubtype.ORALHEALTHBASIC) {
            return "OralHealth-Basic";
        }
        if (code == ContractTermSubtype.ORALHEALTHMAJOR) {
            return "OralHealth-Major";
        }
        if (code == ContractTermSubtype.ORALHEALTHORTHODONTIC) {
            return "OralHealth-Orthodontic";
        }
        return "?";
    }

    @Override
    public String toSystem(ContractTermSubtype code) {
        return code.getSystem();
    }
}

