/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.CompartmentType;

public class CompartmentTypeEnumFactory
implements EnumFactory<CompartmentType> {
    @Override
    public CompartmentType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("Patient".equals(codeString)) {
            return CompartmentType.PATIENT;
        }
        if ("Encounter".equals(codeString)) {
            return CompartmentType.ENCOUNTER;
        }
        if ("RelatedPerson".equals(codeString)) {
            return CompartmentType.RELATEDPERSON;
        }
        if ("Practitioner".equals(codeString)) {
            return CompartmentType.PRACTITIONER;
        }
        if ("Device".equals(codeString)) {
            return CompartmentType.DEVICE;
        }
        throw new IllegalArgumentException("Unknown CompartmentType code '" + codeString + "'");
    }

    @Override
    public String toCode(CompartmentType code) {
        if (code == CompartmentType.PATIENT) {
            return "Patient";
        }
        if (code == CompartmentType.ENCOUNTER) {
            return "Encounter";
        }
        if (code == CompartmentType.RELATEDPERSON) {
            return "RelatedPerson";
        }
        if (code == CompartmentType.PRACTITIONER) {
            return "Practitioner";
        }
        if (code == CompartmentType.DEVICE) {
            return "Device";
        }
        return "?";
    }

    @Override
    public String toSystem(CompartmentType code) {
        return code.getSystem();
    }
}

