/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.ActionBehaviorType;

public class ActionBehaviorTypeEnumFactory
implements EnumFactory<ActionBehaviorType> {
    @Override
    public ActionBehaviorType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("grouping".equals(codeString)) {
            return ActionBehaviorType.GROUPING;
        }
        if ("selection".equals(codeString)) {
            return ActionBehaviorType.SELECTION;
        }
        if ("required".equals(codeString)) {
            return ActionBehaviorType.REQUIRED;
        }
        if ("precheck".equals(codeString)) {
            return ActionBehaviorType.PRECHECK;
        }
        if ("cardinality".equals(codeString)) {
            return ActionBehaviorType.CARDINALITY;
        }
        throw new IllegalArgumentException("Unknown ActionBehaviorType code '" + codeString + "'");
    }

    @Override
    public String toCode(ActionBehaviorType code) {
        if (code == ActionBehaviorType.GROUPING) {
            return "grouping";
        }
        if (code == ActionBehaviorType.SELECTION) {
            return "selection";
        }
        if (code == ActionBehaviorType.REQUIRED) {
            return "required";
        }
        if (code == ActionBehaviorType.PRECHECK) {
            return "precheck";
        }
        if (code == ActionBehaviorType.CARDINALITY) {
            return "cardinality";
        }
        return "?";
    }

    @Override
    public String toSystem(ActionBehaviorType code) {
        return code.getSystem();
    }
}

