/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.Base64BinaryType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.Device;
import org.hl7.fhir.dstu2016may.model.InstantType;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.RelatedPerson;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="Signature")
public class Signature
extends Type
implements ICompositeType {
    @Child(name="type", type={Coding.class}, order=0, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Indication of the reason the entity signed the object(s)", formalDefinition="An indication of the reason that the entity signed this document. This may be explicitly included as part of the signature information and can be used when determining accountability for various actions concerning the document.")
    protected List<Coding> type;
    @Child(name="when", type={InstantType.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the signature was created", formalDefinition="When the digital signature was signed.")
    protected InstantType when;
    @Child(name="who", type={UriType.class, Practitioner.class, RelatedPerson.class, Patient.class, Device.class, Organization.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who signed the signature", formalDefinition="A reference to an application-usable description of the person that signed the certificate (e.g. the signature used their private key).")
    protected Type who;
    @Child(name="contentType", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The technical format of the signature", formalDefinition="A mime type that indicates the technical format of the signature. Important mime types are application/signature+xml for X ML DigSig, application/jwt for JWT, and image/* for a graphical image of a signature, etc.")
    protected CodeType contentType;
    @Child(name="blob", type={Base64BinaryType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The actual signature content (XML DigSig. JWT, picture, etc.)", formalDefinition="The base64 encoding of the Signature content. When signature is not recorded electronically this element would be empty.")
    protected Base64BinaryType blob;
    private static final long serialVersionUID = -452432714L;

    public Signature() {
    }

    public Signature(InstantType when, Type who) {
        this.when = when;
        this.who = who;
    }

    public List<Coding> getType() {
        if (this.type == null) {
            this.type = new ArrayList<Coding>();
        }
        return this.type;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (Coding item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addType() {
        Coding t = new Coding();
        if (this.type == null) {
            this.type = new ArrayList<Coding>();
        }
        this.type.add(t);
        return t;
    }

    public Signature addType(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.type == null) {
            this.type = new ArrayList<Coding>();
        }
        this.type.add(t);
        return this;
    }

    public InstantType getWhenElement() {
        if (this.when == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Signature.when");
            }
            if (Configuration.doAutoCreate()) {
                this.when = new InstantType();
            }
        }
        return this.when;
    }

    public boolean hasWhenElement() {
        return this.when != null && !this.when.isEmpty();
    }

    public boolean hasWhen() {
        return this.when != null && !this.when.isEmpty();
    }

    public Signature setWhenElement(InstantType value) {
        this.when = value;
        return this;
    }

    public Date getWhen() {
        return this.when == null ? null : (Date)this.when.getValue();
    }

    public Signature setWhen(Date value) {
        if (this.when == null) {
            this.when = new InstantType();
        }
        this.when.setValue(value);
        return this;
    }

    public Type getWho() {
        return this.who;
    }

    public UriType getWhoUriType() throws FHIRException {
        if (!(this.who instanceof UriType)) {
            throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.who.getClass().getName() + " was encountered");
        }
        return (UriType)this.who;
    }

    public boolean hasWhoUriType() {
        return this.who instanceof UriType;
    }

    public Reference getWhoReference() throws FHIRException {
        if (!(this.who instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.who.getClass().getName() + " was encountered");
        }
        return (Reference)this.who;
    }

    public boolean hasWhoReference() {
        return this.who instanceof Reference;
    }

    public boolean hasWho() {
        return this.who != null && !this.who.isEmpty();
    }

    public Signature setWho(Type value) {
        this.who = value;
        return this;
    }

    public CodeType getContentTypeElement() {
        if (this.contentType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Signature.contentType");
            }
            if (Configuration.doAutoCreate()) {
                this.contentType = new CodeType();
            }
        }
        return this.contentType;
    }

    public boolean hasContentTypeElement() {
        return this.contentType != null && !this.contentType.isEmpty();
    }

    public boolean hasContentType() {
        return this.contentType != null && !this.contentType.isEmpty();
    }

    public Signature setContentTypeElement(CodeType value) {
        this.contentType = value;
        return this;
    }

    public String getContentType() {
        return this.contentType == null ? null : (String)this.contentType.getValue();
    }

    public Signature setContentType(String value) {
        if (Utilities.noString((String)value)) {
            this.contentType = null;
        } else {
            if (this.contentType == null) {
                this.contentType = new CodeType();
            }
            this.contentType.setValue(value);
        }
        return this;
    }

    public Base64BinaryType getBlobElement() {
        if (this.blob == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Signature.blob");
            }
            if (Configuration.doAutoCreate()) {
                this.blob = new Base64BinaryType();
            }
        }
        return this.blob;
    }

    public boolean hasBlobElement() {
        return this.blob != null && !this.blob.isEmpty();
    }

    public boolean hasBlob() {
        return this.blob != null && !this.blob.isEmpty();
    }

    public Signature setBlobElement(Base64BinaryType value) {
        this.blob = value;
        return this;
    }

    public byte[] getBlob() {
        return this.blob == null ? null : (byte[])this.blob.getValue();
    }

    public Signature setBlob(byte[] value) {
        if (value == null) {
            this.blob = null;
        } else {
            if (this.blob == null) {
                this.blob = new Base64BinaryType();
            }
            this.blob.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("type", "Coding", "An indication of the reason that the entity signed this document. This may be explicitly included as part of the signature information and can be used when determining accountability for various actions concerning the document.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property("when", "instant", "When the digital signature was signed.", 0, Integer.MAX_VALUE, this.when));
        childrenList.add(new Property("who[x]", "uri|Reference(Practitioner|RelatedPerson|Patient|Device|Organization)", "A reference to an application-usable description of the person that signed the certificate (e.g. the signature used their private key).", 0, Integer.MAX_VALUE, this.who));
        childrenList.add(new Property("contentType", "code", "A mime type that indicates the technical format of the signature. Important mime types are application/signature+xml for X ML DigSig, application/jwt for JWT, and image/* for a graphical image of a signature, etc.", 0, Integer.MAX_VALUE, this.contentType));
        childrenList.add(new Property("blob", "base64Binary", "The base64 encoding of the Signature content. When signature is not recorded electronically this element would be empty.", 0, Integer.MAX_VALUE, this.blob));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
            }
            case 3648314: {
                Base[] baseArray;
                if (this.when == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.when;
                }
                return baseArray;
            }
            case 117694: {
                Base[] baseArray;
                if (this.who == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.who;
                }
                return baseArray;
            }
            case -389131437: {
                Base[] baseArray;
                if (this.contentType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.contentType;
                }
                return baseArray;
            }
            case 3026845: {
                Base[] baseArray;
                if (this.blob == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.blob;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3575610: {
                this.getType().add(this.castToCoding(value));
                break;
            }
            case 3648314: {
                this.when = this.castToInstant(value);
                break;
            }
            case 117694: {
                this.who = (Type)value;
                break;
            }
            case -389131437: {
                this.contentType = this.castToCode(value);
                break;
            }
            case 3026845: {
                this.blob = this.castToBase64Binary(value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("type")) {
            this.getType().add(this.castToCoding(value));
        } else if (name.equals("when")) {
            this.when = this.castToInstant(value);
        } else if (name.equals("who[x]")) {
            this.who = (Type)value;
        } else if (name.equals("contentType")) {
            this.contentType = this.castToCode(value);
        } else if (name.equals("blob")) {
            this.blob = this.castToBase64Binary(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return this.addType();
            }
            case 3648314: {
                throw new FHIRException("Cannot make property when as it is not a complex type");
            }
            case -788654078: {
                return this.getWho();
            }
            case -389131437: {
                throw new FHIRException("Cannot make property contentType as it is not a complex type");
            }
            case 3026845: {
                throw new FHIRException("Cannot make property blob as it is not a complex type");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("type")) {
            return this.addType();
        }
        if (name.equals("when")) {
            throw new FHIRException("Cannot call addChild on a singleton property Signature.when");
        }
        if (name.equals("whoUri")) {
            this.who = new UriType();
            return this.who;
        }
        if (name.equals("whoReference")) {
            this.who = new Reference();
            return this.who;
        }
        if (name.equals("contentType")) {
            throw new FHIRException("Cannot call addChild on a singleton property Signature.contentType");
        }
        if (name.equals("blob")) {
            throw new FHIRException("Cannot call addChild on a singleton property Signature.blob");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Signature";
    }

    @Override
    public Signature copy() {
        Signature dst = new Signature();
        this.copyValues(dst);
        if (this.type != null) {
            dst.type = new ArrayList<Coding>();
            for (Coding i : this.type) {
                dst.type.add(i.copy());
            }
        }
        dst.when = this.when == null ? null : this.when.copy();
        dst.who = this.who == null ? null : this.who.copy();
        dst.contentType = this.contentType == null ? null : this.contentType.copy();
        dst.blob = this.blob == null ? null : this.blob.copy();
        return dst;
    }

    @Override
    protected Signature typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Signature)) {
            return false;
        }
        Signature o = (Signature)other;
        return Signature.compareDeep(this.type, o.type, true) && Signature.compareDeep(this.when, o.when, true) && Signature.compareDeep(this.who, o.who, true) && Signature.compareDeep(this.contentType, o.contentType, true) && Signature.compareDeep(this.blob, o.blob, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Signature)) {
            return false;
        }
        Signature o = (Signature)other;
        return Signature.compareValues(this.when, o.when, true) && Signature.compareValues(this.contentType, o.contentType, true) && Signature.compareValues(this.blob, o.blob, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.when != null && !this.when.isEmpty() || this.who != null && !this.who.isEmpty() || this.contentType != null && !this.contentType.isEmpty() || this.blob != null && !this.blob.isEmpty());
    }
}

