/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.Device;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Group;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.Substance;
import org.hl7.fhir.dstu2016may.model.Timing;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;

@ResourceDef(name="Order", profile="http://hl7.org/fhir/Profile/Order")
public class Order
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Identifiers assigned to this order by the orderer or by the receiver", formalDefinition="Identifiers assigned to this order by the orderer or by the receiver.")
    protected List<Identifier> identifier;
    @Child(name="date", type={DateTimeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the order was made", formalDefinition="When the order was made.")
    protected DateTimeType date;
    @Child(name="subject", type={Patient.class, Group.class, Device.class, Substance.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Patient this order is about", formalDefinition="Patient this order is about.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="source", type={Practitioner.class, Organization.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who initiated the order", formalDefinition="Who initiated the order.")
    protected Reference source;
    protected Resource sourceTarget;
    @Child(name="target", type={Organization.class, Device.class, Practitioner.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who is intended to fulfill the order", formalDefinition="Who is intended to fulfill the order.")
    protected Reference target;
    protected Resource targetTarget;
    @Child(name="reason", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Text - why the order was made", formalDefinition="Text - why the order was made.")
    protected Type reason;
    @Child(name="when", type={}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When order should be fulfilled", formalDefinition="When order should be fulfilled.")
    protected OrderWhenComponent when;
    @Child(name="detail", type={}, order=7, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="What action is being ordered", formalDefinition="What action is being ordered.")
    protected List<Reference> detail;
    protected List<Resource> detailTarget;
    private static final long serialVersionUID = -1392311096L;
    @SearchParamDefinition(name="detail", path="Order.detail", description="What action is being ordered", type="reference")
    public static final String SP_DETAIL = "detail";
    public static final ReferenceClientParam DETAIL = new ReferenceClientParam("detail");
    public static final Include INCLUDE_DETAIL = new Include("Order:detail").toLocked();
    @SearchParamDefinition(name="patient", path="Order.subject", description="Patient this order is about", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Order:patient").toLocked();
    @SearchParamDefinition(name="source", path="Order.source", description="Who initiated the order", type="reference")
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_SOURCE = new Include("Order:source").toLocked();
    @SearchParamDefinition(name="subject", path="Order.subject", description="Patient this order is about", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Order:subject").toLocked();
    @SearchParamDefinition(name="when", path="Order.when.schedule", description="A formal schedule", type="date")
    public static final String SP_WHEN = "when";
    public static final DateClientParam WHEN = new DateClientParam("when");
    @SearchParamDefinition(name="target", path="Order.target", description="Who is intended to fulfill the order", type="reference")
    public static final String SP_TARGET = "target";
    public static final ReferenceClientParam TARGET = new ReferenceClientParam("target");
    public static final Include INCLUDE_TARGET = new Include("Order:target").toLocked();
    @SearchParamDefinition(name="when_code", path="Order.when.code", description="Code specifies when request should be done. The code may simply be a priority code", type="token")
    public static final String SP_WHENCODE = "when_code";
    public static final TokenClientParam WHENCODE = new TokenClientParam("when_code");
    @SearchParamDefinition(name="date", path="Order.date", description="When the order was made", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Order.identifier", description="Instance id from source, target, and/or  others", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Order addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Order.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public Order setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public Order setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Order.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Order setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Order setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getSource() {
        if (this.source == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Order.source");
            }
            if (Configuration.doAutoCreate()) {
                this.source = new Reference();
            }
        }
        return this.source;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public Order setSource(Reference value) {
        this.source = value;
        return this;
    }

    public Resource getSourceTarget() {
        return this.sourceTarget;
    }

    public Order setSourceTarget(Resource value) {
        this.sourceTarget = value;
        return this;
    }

    public Reference getTarget() {
        if (this.target == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Order.target");
            }
            if (Configuration.doAutoCreate()) {
                this.target = new Reference();
            }
        }
        return this.target;
    }

    public boolean hasTarget() {
        return this.target != null && !this.target.isEmpty();
    }

    public Order setTarget(Reference value) {
        this.target = value;
        return this;
    }

    public Resource getTargetTarget() {
        return this.targetTarget;
    }

    public Order setTargetTarget(Resource value) {
        this.targetTarget = value;
        return this;
    }

    public Type getReason() {
        return this.reason;
    }

    public CodeableConcept getReasonCodeableConcept() throws FHIRException {
        if (!(this.reason instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.reason.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.reason;
    }

    public boolean hasReasonCodeableConcept() {
        return this.reason instanceof CodeableConcept;
    }

    public Reference getReasonReference() throws FHIRException {
        if (!(this.reason instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.reason.getClass().getName() + " was encountered");
        }
        return (Reference)this.reason;
    }

    public boolean hasReasonReference() {
        return this.reason instanceof Reference;
    }

    public boolean hasReason() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public Order setReason(Type value) {
        this.reason = value;
        return this;
    }

    public OrderWhenComponent getWhen() {
        if (this.when == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Order.when");
            }
            if (Configuration.doAutoCreate()) {
                this.when = new OrderWhenComponent();
            }
        }
        return this.when;
    }

    public boolean hasWhen() {
        return this.when != null && !this.when.isEmpty();
    }

    public Order setWhen(OrderWhenComponent value) {
        this.when = value;
        return this;
    }

    public List<Reference> getDetail() {
        if (this.detail == null) {
            this.detail = new ArrayList<Reference>();
        }
        return this.detail;
    }

    public boolean hasDetail() {
        if (this.detail == null) {
            return false;
        }
        for (Reference item : this.detail) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDetail() {
        Reference t = new Reference();
        if (this.detail == null) {
            this.detail = new ArrayList<Reference>();
        }
        this.detail.add(t);
        return t;
    }

    public Order addDetail(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.detail == null) {
            this.detail = new ArrayList<Reference>();
        }
        this.detail.add(t);
        return this;
    }

    public List<Resource> getDetailTarget() {
        if (this.detailTarget == null) {
            this.detailTarget = new ArrayList<Resource>();
        }
        return this.detailTarget;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this order by the orderer or by the receiver.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_DATE, "dateTime", "When the order was made.", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Substance)", "Patient this order is about.", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property(SP_SOURCE, "Reference(Practitioner|Organization)", "Who initiated the order.", 0, Integer.MAX_VALUE, this.source));
        childrenList.add(new Property(SP_TARGET, "Reference(Organization|Device|Practitioner)", "Who is intended to fulfill the order.", 0, Integer.MAX_VALUE, this.target));
        childrenList.add(new Property("reason[x]", "CodeableConcept|Reference(Any)", "Text - why the order was made.", 0, Integer.MAX_VALUE, this.reason));
        childrenList.add(new Property(SP_WHEN, "", "When order should be fulfilled.", 0, Integer.MAX_VALUE, this.when));
        childrenList.add(new Property(SP_DETAIL, "Reference(Any)", "What action is being ordered.", 0, Integer.MAX_VALUE, this.detail));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.date;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.subject;
                }
                return baseArray;
            }
            case -896505829: {
                Base[] baseArray;
                if (this.source == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.source;
                }
                return baseArray;
            }
            case -880905839: {
                Base[] baseArray;
                if (this.target == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.target;
                }
                return baseArray;
            }
            case -934964668: {
                Base[] baseArray;
                if (this.reason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.reason;
                }
                return baseArray;
            }
            case 3648314: {
                Base[] baseArray;
                if (this.when == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.when;
                }
                return baseArray;
            }
            case -1335224239: {
                return this.detail == null ? new Base[]{} : this.detail.toArray(new Base[this.detail.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                break;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                break;
            }
            case -896505829: {
                this.source = this.castToReference(value);
                break;
            }
            case -880905839: {
                this.target = this.castToReference(value);
                break;
            }
            case -934964668: {
                this.reason = (Type)value;
                break;
            }
            case 3648314: {
                this.when = (OrderWhenComponent)value;
                break;
            }
            case -1335224239: {
                this.getDetail().add(this.castToReference(value));
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_SOURCE)) {
            this.source = this.castToReference(value);
        } else if (name.equals(SP_TARGET)) {
            this.target = this.castToReference(value);
        } else if (name.equals("reason[x]")) {
            this.reason = (Type)value;
        } else if (name.equals(SP_WHEN)) {
            this.when = (OrderWhenComponent)value;
        } else if (name.equals(SP_DETAIL)) {
            this.getDetail().add(this.castToReference(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 3076014: {
                throw new FHIRException("Cannot make property date as it is not a complex type");
            }
            case -1867885268: {
                return this.getSubject();
            }
            case -896505829: {
                return this.getSource();
            }
            case -880905839: {
                return this.getTarget();
            }
            case -669418564: {
                return this.getReason();
            }
            case 3648314: {
                return this.getWhen();
            }
            case -1335224239: {
                return this.addDetail();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a singleton property Order.date");
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_SOURCE)) {
            this.source = new Reference();
            return this.source;
        }
        if (name.equals(SP_TARGET)) {
            this.target = new Reference();
            return this.target;
        }
        if (name.equals("reasonCodeableConcept")) {
            this.reason = new CodeableConcept();
            return this.reason;
        }
        if (name.equals("reasonReference")) {
            this.reason = new Reference();
            return this.reason;
        }
        if (name.equals(SP_WHEN)) {
            this.when = new OrderWhenComponent();
            return this.when;
        }
        if (name.equals(SP_DETAIL)) {
            return this.addDetail();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Order";
    }

    @Override
    public Order copy() {
        Order dst = new Order();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.date = this.date == null ? null : this.date.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.source = this.source == null ? null : this.source.copy();
        dst.target = this.target == null ? null : this.target.copy();
        dst.reason = this.reason == null ? null : this.reason.copy();
        OrderWhenComponent orderWhenComponent = dst.when = this.when == null ? null : this.when.copy();
        if (this.detail != null) {
            dst.detail = new ArrayList<Reference>();
            for (Reference reference : this.detail) {
                dst.detail.add(reference.copy());
            }
        }
        return dst;
    }

    protected Order typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Order)) {
            return false;
        }
        Order o = (Order)other;
        return Order.compareDeep(this.identifier, o.identifier, true) && Order.compareDeep(this.date, o.date, true) && Order.compareDeep(this.subject, o.subject, true) && Order.compareDeep(this.source, o.source, true) && Order.compareDeep(this.target, o.target, true) && Order.compareDeep(this.reason, o.reason, true) && Order.compareDeep(this.when, o.when, true) && Order.compareDeep(this.detail, o.detail, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Order)) {
            return false;
        }
        Order o = (Order)other;
        return Order.compareValues(this.date, o.date, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.date != null && !this.date.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.source != null && !this.source.isEmpty() || this.target != null && !this.target.isEmpty() || this.reason != null && !this.reason.isEmpty() || this.when != null && !this.when.isEmpty() || this.detail != null && !this.detail.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Order;
    }

    @Block
    public static class OrderWhenComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Code specifies when request should be done. The code may simply be a priority code", formalDefinition="Code specifies when request should be done. The code may simply be a priority code.")
        protected CodeableConcept code;
        @Child(name="schedule", type={Timing.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A formal schedule", formalDefinition="A formal schedule.")
        protected Timing schedule;
        private static final long serialVersionUID = 307115287L;

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OrderWhenComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public OrderWhenComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public Timing getSchedule() {
            if (this.schedule == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OrderWhenComponent.schedule");
                }
                if (Configuration.doAutoCreate()) {
                    this.schedule = new Timing();
                }
            }
            return this.schedule;
        }

        public boolean hasSchedule() {
            return this.schedule != null && !this.schedule.isEmpty();
        }

        public OrderWhenComponent setSchedule(Timing value) {
            this.schedule = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("code", "CodeableConcept", "Code specifies when request should be done. The code may simply be a priority code.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("schedule", "Timing", "A formal schedule.", 0, Integer.MAX_VALUE, this.schedule));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -697920873: {
                    Base[] baseArray;
                    if (this.schedule == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.schedule;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    break;
                }
                case -697920873: {
                    this.schedule = this.castToTiming(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("schedule")) {
                this.schedule = this.castToTiming(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -697920873: {
                    return this.getSchedule();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("schedule")) {
                this.schedule = new Timing();
                return this.schedule;
            }
            return super.addChild(name);
        }

        @Override
        public OrderWhenComponent copy() {
            OrderWhenComponent dst = new OrderWhenComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.schedule = this.schedule == null ? null : this.schedule.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof OrderWhenComponent)) {
                return false;
            }
            OrderWhenComponent o = (OrderWhenComponent)other;
            return OrderWhenComponent.compareDeep(this.code, o.code, true) && OrderWhenComponent.compareDeep(this.schedule, o.schedule, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof OrderWhenComponent)) {
                return false;
            }
            OrderWhenComponent o = (OrderWhenComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.schedule != null && !this.schedule.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Order.when";
        }
    }
}

