/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Library;
import org.hl7.fhir.dstu2016may.model.MarkdownType;
import org.hl7.fhir.dstu2016may.model.ModuleMetadata;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Measure", profile="http://hl7.org/fhir/Profile/Measure")
public class Measure
extends DomainResource {
    @Child(name="moduleMetadata", type={ModuleMetadata.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Metadata for the measure", formalDefinition="The metadata for the measure, including publishing, life-cycle, version, documentation, and supporting evidence.")
    protected ModuleMetadata moduleMetadata;
    @Child(name="library", type={Library.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Logic used by the measure", formalDefinition="A reference to a Library resource containing the formal logic used by the measure.")
    protected List<Reference> library;
    protected List<Library> libraryTarget;
    @Child(name="disclaimer", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Disclaimer for the measure", formalDefinition="A disclaimer for the use of the measure.")
    protected MarkdownType disclaimer;
    @Child(name="scoring", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="proportion | ratio | continuous-variable | cohort", formalDefinition="The measure scoring type, e.g. proportion, CV.")
    protected Enumeration<MeasureScoring> scoring;
    @Child(name="type", type={CodeType.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="process | outcome", formalDefinition="The measure type, e.g. process, outcome.")
    protected List<Enumeration<MeasureType>> type;
    @Child(name="riskAdjustment", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="How is risk adjustment applied for this measure", formalDefinition="A description of the risk adjustment factors that may impact the resulting score for the measure and how they may be accounted for when computing and reporting measure results.")
    protected StringType riskAdjustment;
    @Child(name="rateAggregation", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="How is rate aggregation performed for this measure", formalDefinition="A description of the rate aggregation for the measure.")
    protected StringType rateAggregation;
    @Child(name="rationale", type={MarkdownType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Why does this measure exist", formalDefinition="The rationale for the measure.")
    protected MarkdownType rationale;
    @Child(name="clinicalRecommendationStatement", type={MarkdownType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Clinical recommendation", formalDefinition="The clinical recommendation statement for the measure.")
    protected MarkdownType clinicalRecommendationStatement;
    @Child(name="improvementNotation", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Improvement notation for the measure, e.g. higher score indicates better quality", formalDefinition="Improvement notation for the measure, e.g. higher score indicates better quality.")
    protected StringType improvementNotation;
    @Child(name="definition", type={MarkdownType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A natural language definition of the measure", formalDefinition="A narrative description of the complete measure calculation.")
    protected MarkdownType definition;
    @Child(name="guidance", type={MarkdownType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The guidance for the measure", formalDefinition="Additional guidance for the measure including how it can be used in a clinical context, and the intent of the measure.")
    protected MarkdownType guidance;
    @Child(name="set", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The measure set, e.g. Preventive Care and Screening", formalDefinition="The measure set, e.g. Preventive Care and Screening.")
    protected StringType set;
    @Child(name="group", type={}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Population criteria group", formalDefinition="A group of population criteria for the measure.")
    protected List<MeasureGroupComponent> group;
    @Child(name="supplementalData", type={}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Supplemental data", formalDefinition="The supplemental data criteria for the measure report, specified as either the name of a valid CQL expression within a referenced library, or a valid FHIR Resource Path.")
    protected List<MeasureSupplementalDataComponent> supplementalData;
    private static final long serialVersionUID = -1000974672L;
    @SearchParamDefinition(name="topic", path="Measure.moduleMetadata.topic", description="Topics associated with the module", type="token")
    public static final String SP_TOPIC = "topic";
    public static final TokenClientParam TOPIC = new TokenClientParam("topic");
    @SearchParamDefinition(name="title", path="Measure.moduleMetadata.title", description="Text search against the title", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="status", path="Measure.moduleMetadata.status", description="Status of the module", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="description", path="Measure.moduleMetadata.description", description="Text search against the description", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="identifier", path="Measure.moduleMetadata.identifier", description="Logical identifier for the module (e.g. CMS-143)", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="version", path="Measure.moduleMetadata.version", description="Version of the module (e.g. 1.0.0)", type="string")
    public static final String SP_VERSION = "version";
    public static final StringClientParam VERSION = new StringClientParam("version");

    public ModuleMetadata getModuleMetadata() {
        if (this.moduleMetadata == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.moduleMetadata");
            }
            if (Configuration.doAutoCreate()) {
                this.moduleMetadata = new ModuleMetadata();
            }
        }
        return this.moduleMetadata;
    }

    public boolean hasModuleMetadata() {
        return this.moduleMetadata != null && !this.moduleMetadata.isEmpty();
    }

    public Measure setModuleMetadata(ModuleMetadata value) {
        this.moduleMetadata = value;
        return this;
    }

    public List<Reference> getLibrary() {
        if (this.library == null) {
            this.library = new ArrayList<Reference>();
        }
        return this.library;
    }

    public boolean hasLibrary() {
        if (this.library == null) {
            return false;
        }
        for (Reference item : this.library) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addLibrary() {
        Reference t = new Reference();
        if (this.library == null) {
            this.library = new ArrayList<Reference>();
        }
        this.library.add(t);
        return t;
    }

    public Measure addLibrary(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.library == null) {
            this.library = new ArrayList<Reference>();
        }
        this.library.add(t);
        return this;
    }

    public List<Library> getLibraryTarget() {
        if (this.libraryTarget == null) {
            this.libraryTarget = new ArrayList<Library>();
        }
        return this.libraryTarget;
    }

    public Library addLibraryTarget() {
        Library r = new Library();
        if (this.libraryTarget == null) {
            this.libraryTarget = new ArrayList<Library>();
        }
        this.libraryTarget.add(r);
        return r;
    }

    public MarkdownType getDisclaimerElement() {
        if (this.disclaimer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.disclaimer");
            }
            if (Configuration.doAutoCreate()) {
                this.disclaimer = new MarkdownType();
            }
        }
        return this.disclaimer;
    }

    public boolean hasDisclaimerElement() {
        return this.disclaimer != null && !this.disclaimer.isEmpty();
    }

    public boolean hasDisclaimer() {
        return this.disclaimer != null && !this.disclaimer.isEmpty();
    }

    public Measure setDisclaimerElement(MarkdownType value) {
        this.disclaimer = value;
        return this;
    }

    public String getDisclaimer() {
        return this.disclaimer == null ? null : (String)this.disclaimer.getValue();
    }

    public Measure setDisclaimer(String value) {
        if (value == null) {
            this.disclaimer = null;
        } else {
            if (this.disclaimer == null) {
                this.disclaimer = new MarkdownType();
            }
            this.disclaimer.setValue(value);
        }
        return this;
    }

    public Enumeration<MeasureScoring> getScoringElement() {
        if (this.scoring == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.scoring");
            }
            if (Configuration.doAutoCreate()) {
                this.scoring = new Enumeration<MeasureScoring>(new MeasureScoringEnumFactory());
            }
        }
        return this.scoring;
    }

    public boolean hasScoringElement() {
        return this.scoring != null && !this.scoring.isEmpty();
    }

    public boolean hasScoring() {
        return this.scoring != null && !this.scoring.isEmpty();
    }

    public Measure setScoringElement(Enumeration<MeasureScoring> value) {
        this.scoring = value;
        return this;
    }

    public MeasureScoring getScoring() {
        return this.scoring == null ? null : (MeasureScoring)((Object)this.scoring.getValue());
    }

    public Measure setScoring(MeasureScoring value) {
        if (value == null) {
            this.scoring = null;
        } else {
            if (this.scoring == null) {
                this.scoring = new Enumeration<MeasureScoring>(new MeasureScoringEnumFactory());
            }
            this.scoring.setValue((Object)value);
        }
        return this;
    }

    public List<Enumeration<MeasureType>> getType() {
        if (this.type == null) {
            this.type = new ArrayList<Enumeration<MeasureType>>();
        }
        return this.type;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (Enumeration<MeasureType> item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Enumeration<MeasureType> addTypeElement() {
        Enumeration<MeasureType> t = new Enumeration<MeasureType>(new MeasureTypeEnumFactory());
        if (this.type == null) {
            this.type = new ArrayList<Enumeration<MeasureType>>();
        }
        this.type.add(t);
        return t;
    }

    public Measure addType(MeasureType value) {
        Enumeration<MeasureType> t = new Enumeration<MeasureType>(new MeasureTypeEnumFactory());
        t.setValue((Object)value);
        if (this.type == null) {
            this.type = new ArrayList<Enumeration<MeasureType>>();
        }
        this.type.add(t);
        return this;
    }

    public boolean hasType(MeasureType value) {
        if (this.type == null) {
            return false;
        }
        for (Enumeration<MeasureType> v : this.type) {
            if (!((MeasureType)((Object)v.getValue())).equals((Object)value)) continue;
            return true;
        }
        return false;
    }

    public StringType getRiskAdjustmentElement() {
        if (this.riskAdjustment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.riskAdjustment");
            }
            if (Configuration.doAutoCreate()) {
                this.riskAdjustment = new StringType();
            }
        }
        return this.riskAdjustment;
    }

    public boolean hasRiskAdjustmentElement() {
        return this.riskAdjustment != null && !this.riskAdjustment.isEmpty();
    }

    public boolean hasRiskAdjustment() {
        return this.riskAdjustment != null && !this.riskAdjustment.isEmpty();
    }

    public Measure setRiskAdjustmentElement(StringType value) {
        this.riskAdjustment = value;
        return this;
    }

    public String getRiskAdjustment() {
        return this.riskAdjustment == null ? null : (String)this.riskAdjustment.getValue();
    }

    public Measure setRiskAdjustment(String value) {
        if (Utilities.noString((String)value)) {
            this.riskAdjustment = null;
        } else {
            if (this.riskAdjustment == null) {
                this.riskAdjustment = new StringType();
            }
            this.riskAdjustment.setValue(value);
        }
        return this;
    }

    public StringType getRateAggregationElement() {
        if (this.rateAggregation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.rateAggregation");
            }
            if (Configuration.doAutoCreate()) {
                this.rateAggregation = new StringType();
            }
        }
        return this.rateAggregation;
    }

    public boolean hasRateAggregationElement() {
        return this.rateAggregation != null && !this.rateAggregation.isEmpty();
    }

    public boolean hasRateAggregation() {
        return this.rateAggregation != null && !this.rateAggregation.isEmpty();
    }

    public Measure setRateAggregationElement(StringType value) {
        this.rateAggregation = value;
        return this;
    }

    public String getRateAggregation() {
        return this.rateAggregation == null ? null : (String)this.rateAggregation.getValue();
    }

    public Measure setRateAggregation(String value) {
        if (Utilities.noString((String)value)) {
            this.rateAggregation = null;
        } else {
            if (this.rateAggregation == null) {
                this.rateAggregation = new StringType();
            }
            this.rateAggregation.setValue(value);
        }
        return this;
    }

    public MarkdownType getRationaleElement() {
        if (this.rationale == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.rationale");
            }
            if (Configuration.doAutoCreate()) {
                this.rationale = new MarkdownType();
            }
        }
        return this.rationale;
    }

    public boolean hasRationaleElement() {
        return this.rationale != null && !this.rationale.isEmpty();
    }

    public boolean hasRationale() {
        return this.rationale != null && !this.rationale.isEmpty();
    }

    public Measure setRationaleElement(MarkdownType value) {
        this.rationale = value;
        return this;
    }

    public String getRationale() {
        return this.rationale == null ? null : (String)this.rationale.getValue();
    }

    public Measure setRationale(String value) {
        if (value == null) {
            this.rationale = null;
        } else {
            if (this.rationale == null) {
                this.rationale = new MarkdownType();
            }
            this.rationale.setValue(value);
        }
        return this;
    }

    public MarkdownType getClinicalRecommendationStatementElement() {
        if (this.clinicalRecommendationStatement == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.clinicalRecommendationStatement");
            }
            if (Configuration.doAutoCreate()) {
                this.clinicalRecommendationStatement = new MarkdownType();
            }
        }
        return this.clinicalRecommendationStatement;
    }

    public boolean hasClinicalRecommendationStatementElement() {
        return this.clinicalRecommendationStatement != null && !this.clinicalRecommendationStatement.isEmpty();
    }

    public boolean hasClinicalRecommendationStatement() {
        return this.clinicalRecommendationStatement != null && !this.clinicalRecommendationStatement.isEmpty();
    }

    public Measure setClinicalRecommendationStatementElement(MarkdownType value) {
        this.clinicalRecommendationStatement = value;
        return this;
    }

    public String getClinicalRecommendationStatement() {
        return this.clinicalRecommendationStatement == null ? null : (String)this.clinicalRecommendationStatement.getValue();
    }

    public Measure setClinicalRecommendationStatement(String value) {
        if (value == null) {
            this.clinicalRecommendationStatement = null;
        } else {
            if (this.clinicalRecommendationStatement == null) {
                this.clinicalRecommendationStatement = new MarkdownType();
            }
            this.clinicalRecommendationStatement.setValue(value);
        }
        return this;
    }

    public StringType getImprovementNotationElement() {
        if (this.improvementNotation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.improvementNotation");
            }
            if (Configuration.doAutoCreate()) {
                this.improvementNotation = new StringType();
            }
        }
        return this.improvementNotation;
    }

    public boolean hasImprovementNotationElement() {
        return this.improvementNotation != null && !this.improvementNotation.isEmpty();
    }

    public boolean hasImprovementNotation() {
        return this.improvementNotation != null && !this.improvementNotation.isEmpty();
    }

    public Measure setImprovementNotationElement(StringType value) {
        this.improvementNotation = value;
        return this;
    }

    public String getImprovementNotation() {
        return this.improvementNotation == null ? null : (String)this.improvementNotation.getValue();
    }

    public Measure setImprovementNotation(String value) {
        if (Utilities.noString((String)value)) {
            this.improvementNotation = null;
        } else {
            if (this.improvementNotation == null) {
                this.improvementNotation = new StringType();
            }
            this.improvementNotation.setValue(value);
        }
        return this;
    }

    public MarkdownType getDefinitionElement() {
        if (this.definition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.definition");
            }
            if (Configuration.doAutoCreate()) {
                this.definition = new MarkdownType();
            }
        }
        return this.definition;
    }

    public boolean hasDefinitionElement() {
        return this.definition != null && !this.definition.isEmpty();
    }

    public boolean hasDefinition() {
        return this.definition != null && !this.definition.isEmpty();
    }

    public Measure setDefinitionElement(MarkdownType value) {
        this.definition = value;
        return this;
    }

    public String getDefinition() {
        return this.definition == null ? null : (String)this.definition.getValue();
    }

    public Measure setDefinition(String value) {
        if (value == null) {
            this.definition = null;
        } else {
            if (this.definition == null) {
                this.definition = new MarkdownType();
            }
            this.definition.setValue(value);
        }
        return this;
    }

    public MarkdownType getGuidanceElement() {
        if (this.guidance == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.guidance");
            }
            if (Configuration.doAutoCreate()) {
                this.guidance = new MarkdownType();
            }
        }
        return this.guidance;
    }

    public boolean hasGuidanceElement() {
        return this.guidance != null && !this.guidance.isEmpty();
    }

    public boolean hasGuidance() {
        return this.guidance != null && !this.guidance.isEmpty();
    }

    public Measure setGuidanceElement(MarkdownType value) {
        this.guidance = value;
        return this;
    }

    public String getGuidance() {
        return this.guidance == null ? null : (String)this.guidance.getValue();
    }

    public Measure setGuidance(String value) {
        if (value == null) {
            this.guidance = null;
        } else {
            if (this.guidance == null) {
                this.guidance = new MarkdownType();
            }
            this.guidance.setValue(value);
        }
        return this;
    }

    public StringType getSetElement() {
        if (this.set == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Measure.set");
            }
            if (Configuration.doAutoCreate()) {
                this.set = new StringType();
            }
        }
        return this.set;
    }

    public boolean hasSetElement() {
        return this.set != null && !this.set.isEmpty();
    }

    public boolean hasSet() {
        return this.set != null && !this.set.isEmpty();
    }

    public Measure setSetElement(StringType value) {
        this.set = value;
        return this;
    }

    public String getSet() {
        return this.set == null ? null : (String)this.set.getValue();
    }

    public Measure setSet(String value) {
        if (Utilities.noString((String)value)) {
            this.set = null;
        } else {
            if (this.set == null) {
                this.set = new StringType();
            }
            this.set.setValue(value);
        }
        return this;
    }

    public List<MeasureGroupComponent> getGroup() {
        if (this.group == null) {
            this.group = new ArrayList<MeasureGroupComponent>();
        }
        return this.group;
    }

    public boolean hasGroup() {
        if (this.group == null) {
            return false;
        }
        for (MeasureGroupComponent item : this.group) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MeasureGroupComponent addGroup() {
        MeasureGroupComponent t = new MeasureGroupComponent();
        if (this.group == null) {
            this.group = new ArrayList<MeasureGroupComponent>();
        }
        this.group.add(t);
        return t;
    }

    public Measure addGroup(MeasureGroupComponent t) {
        if (t == null) {
            return this;
        }
        if (this.group == null) {
            this.group = new ArrayList<MeasureGroupComponent>();
        }
        this.group.add(t);
        return this;
    }

    public List<MeasureSupplementalDataComponent> getSupplementalData() {
        if (this.supplementalData == null) {
            this.supplementalData = new ArrayList<MeasureSupplementalDataComponent>();
        }
        return this.supplementalData;
    }

    public boolean hasSupplementalData() {
        if (this.supplementalData == null) {
            return false;
        }
        for (MeasureSupplementalDataComponent item : this.supplementalData) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MeasureSupplementalDataComponent addSupplementalData() {
        MeasureSupplementalDataComponent t = new MeasureSupplementalDataComponent();
        if (this.supplementalData == null) {
            this.supplementalData = new ArrayList<MeasureSupplementalDataComponent>();
        }
        this.supplementalData.add(t);
        return t;
    }

    public Measure addSupplementalData(MeasureSupplementalDataComponent t) {
        if (t == null) {
            return this;
        }
        if (this.supplementalData == null) {
            this.supplementalData = new ArrayList<MeasureSupplementalDataComponent>();
        }
        this.supplementalData.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("moduleMetadata", "ModuleMetadata", "The metadata for the measure, including publishing, life-cycle, version, documentation, and supporting evidence.", 0, Integer.MAX_VALUE, this.moduleMetadata));
        childrenList.add(new Property("library", "Reference(Library)", "A reference to a Library resource containing the formal logic used by the measure.", 0, Integer.MAX_VALUE, this.library));
        childrenList.add(new Property("disclaimer", "markdown", "A disclaimer for the use of the measure.", 0, Integer.MAX_VALUE, this.disclaimer));
        childrenList.add(new Property("scoring", "code", "The measure scoring type, e.g. proportion, CV.", 0, Integer.MAX_VALUE, this.scoring));
        childrenList.add(new Property("type", "code", "The measure type, e.g. process, outcome.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property("riskAdjustment", "string", "A description of the risk adjustment factors that may impact the resulting score for the measure and how they may be accounted for when computing and reporting measure results.", 0, Integer.MAX_VALUE, this.riskAdjustment));
        childrenList.add(new Property("rateAggregation", "string", "A description of the rate aggregation for the measure.", 0, Integer.MAX_VALUE, this.rateAggregation));
        childrenList.add(new Property("rationale", "markdown", "The rationale for the measure.", 0, Integer.MAX_VALUE, this.rationale));
        childrenList.add(new Property("clinicalRecommendationStatement", "markdown", "The clinical recommendation statement for the measure.", 0, Integer.MAX_VALUE, this.clinicalRecommendationStatement));
        childrenList.add(new Property("improvementNotation", "string", "Improvement notation for the measure, e.g. higher score indicates better quality.", 0, Integer.MAX_VALUE, this.improvementNotation));
        childrenList.add(new Property("definition", "markdown", "A narrative description of the complete measure calculation.", 0, Integer.MAX_VALUE, this.definition));
        childrenList.add(new Property("guidance", "markdown", "Additional guidance for the measure including how it can be used in a clinical context, and the intent of the measure.", 0, Integer.MAX_VALUE, this.guidance));
        childrenList.add(new Property("set", "string", "The measure set, e.g. Preventive Care and Screening.", 0, Integer.MAX_VALUE, this.set));
        childrenList.add(new Property("group", "", "A group of population criteria for the measure.", 0, Integer.MAX_VALUE, this.group));
        childrenList.add(new Property("supplementalData", "", "The supplemental data criteria for the measure report, specified as either the name of a valid CQL expression within a referenced library, or a valid FHIR Resource Path.", 0, Integer.MAX_VALUE, this.supplementalData));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 455891387: {
                Base[] baseArray;
                if (this.moduleMetadata == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.moduleMetadata;
                }
                return baseArray;
            }
            case 166208699: {
                return this.library == null ? new Base[]{} : this.library.toArray(new Base[this.library.size()]);
            }
            case 432371099: {
                Base[] baseArray;
                if (this.disclaimer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.disclaimer;
                }
                return baseArray;
            }
            case 1924005583: {
                Base[] baseArray;
                if (this.scoring == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.scoring;
                }
                return baseArray;
            }
            case 3575610: {
                return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
            }
            case 93273500: {
                Base[] baseArray;
                if (this.riskAdjustment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.riskAdjustment;
                }
                return baseArray;
            }
            case 1254503906: {
                Base[] baseArray;
                if (this.rateAggregation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.rateAggregation;
                }
                return baseArray;
            }
            case 345689335: {
                Base[] baseArray;
                if (this.rationale == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.rationale;
                }
                return baseArray;
            }
            case -18631389: {
                Base[] baseArray;
                if (this.clinicalRecommendationStatement == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.clinicalRecommendationStatement;
                }
                return baseArray;
            }
            case -2085456136: {
                Base[] baseArray;
                if (this.improvementNotation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.improvementNotation;
                }
                return baseArray;
            }
            case -1014418093: {
                Base[] baseArray;
                if (this.definition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.definition;
                }
                return baseArray;
            }
            case -1314002088: {
                Base[] baseArray;
                if (this.guidance == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.guidance;
                }
                return baseArray;
            }
            case 113762: {
                Base[] baseArray;
                if (this.set == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.set;
                }
                return baseArray;
            }
            case 98629247: {
                return this.group == null ? new Base[]{} : this.group.toArray(new Base[this.group.size()]);
            }
            case 1447496814: {
                return this.supplementalData == null ? new Base[]{} : this.supplementalData.toArray(new Base[this.supplementalData.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 455891387: {
                this.moduleMetadata = this.castToModuleMetadata(value);
                break;
            }
            case 166208699: {
                this.getLibrary().add(this.castToReference(value));
                break;
            }
            case 432371099: {
                this.disclaimer = this.castToMarkdown(value);
                break;
            }
            case 1924005583: {
                this.scoring = new MeasureScoringEnumFactory().fromType(value);
                break;
            }
            case 3575610: {
                this.getType().add(new MeasureTypeEnumFactory().fromType(value));
                break;
            }
            case 93273500: {
                this.riskAdjustment = this.castToString(value);
                break;
            }
            case 1254503906: {
                this.rateAggregation = this.castToString(value);
                break;
            }
            case 345689335: {
                this.rationale = this.castToMarkdown(value);
                break;
            }
            case -18631389: {
                this.clinicalRecommendationStatement = this.castToMarkdown(value);
                break;
            }
            case -2085456136: {
                this.improvementNotation = this.castToString(value);
                break;
            }
            case -1014418093: {
                this.definition = this.castToMarkdown(value);
                break;
            }
            case -1314002088: {
                this.guidance = this.castToMarkdown(value);
                break;
            }
            case 113762: {
                this.set = this.castToString(value);
                break;
            }
            case 98629247: {
                this.getGroup().add((MeasureGroupComponent)value);
                break;
            }
            case 1447496814: {
                this.getSupplementalData().add((MeasureSupplementalDataComponent)value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("moduleMetadata")) {
            this.moduleMetadata = this.castToModuleMetadata(value);
        } else if (name.equals("library")) {
            this.getLibrary().add(this.castToReference(value));
        } else if (name.equals("disclaimer")) {
            this.disclaimer = this.castToMarkdown(value);
        } else if (name.equals("scoring")) {
            this.scoring = new MeasureScoringEnumFactory().fromType(value);
        } else if (name.equals("type")) {
            this.getType().add(new MeasureTypeEnumFactory().fromType(value));
        } else if (name.equals("riskAdjustment")) {
            this.riskAdjustment = this.castToString(value);
        } else if (name.equals("rateAggregation")) {
            this.rateAggregation = this.castToString(value);
        } else if (name.equals("rationale")) {
            this.rationale = this.castToMarkdown(value);
        } else if (name.equals("clinicalRecommendationStatement")) {
            this.clinicalRecommendationStatement = this.castToMarkdown(value);
        } else if (name.equals("improvementNotation")) {
            this.improvementNotation = this.castToString(value);
        } else if (name.equals("definition")) {
            this.definition = this.castToMarkdown(value);
        } else if (name.equals("guidance")) {
            this.guidance = this.castToMarkdown(value);
        } else if (name.equals("set")) {
            this.set = this.castToString(value);
        } else if (name.equals("group")) {
            this.getGroup().add((MeasureGroupComponent)value);
        } else if (name.equals("supplementalData")) {
            this.getSupplementalData().add((MeasureSupplementalDataComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 455891387: {
                return this.getModuleMetadata();
            }
            case 166208699: {
                return this.addLibrary();
            }
            case 432371099: {
                throw new FHIRException("Cannot make property disclaimer as it is not a complex type");
            }
            case 1924005583: {
                throw new FHIRException("Cannot make property scoring as it is not a complex type");
            }
            case 3575610: {
                throw new FHIRException("Cannot make property type as it is not a complex type");
            }
            case 93273500: {
                throw new FHIRException("Cannot make property riskAdjustment as it is not a complex type");
            }
            case 1254503906: {
                throw new FHIRException("Cannot make property rateAggregation as it is not a complex type");
            }
            case 345689335: {
                throw new FHIRException("Cannot make property rationale as it is not a complex type");
            }
            case -18631389: {
                throw new FHIRException("Cannot make property clinicalRecommendationStatement as it is not a complex type");
            }
            case -2085456136: {
                throw new FHIRException("Cannot make property improvementNotation as it is not a complex type");
            }
            case -1014418093: {
                throw new FHIRException("Cannot make property definition as it is not a complex type");
            }
            case -1314002088: {
                throw new FHIRException("Cannot make property guidance as it is not a complex type");
            }
            case 113762: {
                throw new FHIRException("Cannot make property set as it is not a complex type");
            }
            case 98629247: {
                return this.addGroup();
            }
            case 1447496814: {
                return this.addSupplementalData();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("moduleMetadata")) {
            this.moduleMetadata = new ModuleMetadata();
            return this.moduleMetadata;
        }
        if (name.equals("library")) {
            return this.addLibrary();
        }
        if (name.equals("disclaimer")) {
            throw new FHIRException("Cannot call addChild on a singleton property Measure.disclaimer");
        }
        if (name.equals("scoring")) {
            throw new FHIRException("Cannot call addChild on a singleton property Measure.scoring");
        }
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a singleton property Measure.type");
        }
        if (name.equals("riskAdjustment")) {
            throw new FHIRException("Cannot call addChild on a singleton property Measure.riskAdjustment");
        }
        if (name.equals("rateAggregation")) {
            throw new FHIRException("Cannot call addChild on a singleton property Measure.rateAggregation");
        }
        if (name.equals("rationale")) {
            throw new FHIRException("Cannot call addChild on a singleton property Measure.rationale");
        }
        if (name.equals("clinicalRecommendationStatement")) {
            throw new FHIRException("Cannot call addChild on a singleton property Measure.clinicalRecommendationStatement");
        }
        if (name.equals("improvementNotation")) {
            throw new FHIRException("Cannot call addChild on a singleton property Measure.improvementNotation");
        }
        if (name.equals("definition")) {
            throw new FHIRException("Cannot call addChild on a singleton property Measure.definition");
        }
        if (name.equals("guidance")) {
            throw new FHIRException("Cannot call addChild on a singleton property Measure.guidance");
        }
        if (name.equals("set")) {
            throw new FHIRException("Cannot call addChild on a singleton property Measure.set");
        }
        if (name.equals("group")) {
            return this.addGroup();
        }
        if (name.equals("supplementalData")) {
            return this.addSupplementalData();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Measure";
    }

    @Override
    public Measure copy() {
        Measure dst = new Measure();
        this.copyValues(dst);
        ModuleMetadata moduleMetadata = dst.moduleMetadata = this.moduleMetadata == null ? null : this.moduleMetadata.copy();
        if (this.library != null) {
            dst.library = new ArrayList<Reference>();
            for (Reference reference : this.library) {
                dst.library.add(reference.copy());
            }
        }
        dst.disclaimer = this.disclaimer == null ? null : this.disclaimer.copy();
        Enumeration<MeasureScoring> enumeration = dst.scoring = this.scoring == null ? null : this.scoring.copy();
        if (this.type != null) {
            dst.type = new ArrayList<Enumeration<MeasureType>>();
            for (Enumeration enumeration2 : this.type) {
                dst.type.add((Enumeration<MeasureType>)enumeration2.copy());
            }
        }
        dst.riskAdjustment = this.riskAdjustment == null ? null : this.riskAdjustment.copy();
        dst.rateAggregation = this.rateAggregation == null ? null : this.rateAggregation.copy();
        dst.rationale = this.rationale == null ? null : this.rationale.copy();
        dst.clinicalRecommendationStatement = this.clinicalRecommendationStatement == null ? null : this.clinicalRecommendationStatement.copy();
        dst.improvementNotation = this.improvementNotation == null ? null : this.improvementNotation.copy();
        dst.definition = this.definition == null ? null : this.definition.copy();
        dst.guidance = this.guidance == null ? null : this.guidance.copy();
        StringType stringType = dst.set = this.set == null ? null : this.set.copy();
        if (this.group != null) {
            dst.group = new ArrayList<MeasureGroupComponent>();
            for (MeasureGroupComponent measureGroupComponent : this.group) {
                dst.group.add(measureGroupComponent.copy());
            }
        }
        if (this.supplementalData != null) {
            dst.supplementalData = new ArrayList<MeasureSupplementalDataComponent>();
            for (MeasureSupplementalDataComponent measureSupplementalDataComponent : this.supplementalData) {
                dst.supplementalData.add(measureSupplementalDataComponent.copy());
            }
        }
        return dst;
    }

    protected Measure typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Measure)) {
            return false;
        }
        Measure o = (Measure)other;
        return Measure.compareDeep(this.moduleMetadata, o.moduleMetadata, true) && Measure.compareDeep(this.library, o.library, true) && Measure.compareDeep(this.disclaimer, o.disclaimer, true) && Measure.compareDeep(this.scoring, o.scoring, true) && Measure.compareDeep(this.type, o.type, true) && Measure.compareDeep(this.riskAdjustment, o.riskAdjustment, true) && Measure.compareDeep(this.rateAggregation, o.rateAggregation, true) && Measure.compareDeep(this.rationale, o.rationale, true) && Measure.compareDeep(this.clinicalRecommendationStatement, o.clinicalRecommendationStatement, true) && Measure.compareDeep(this.improvementNotation, o.improvementNotation, true) && Measure.compareDeep(this.definition, o.definition, true) && Measure.compareDeep(this.guidance, o.guidance, true) && Measure.compareDeep(this.set, o.set, true) && Measure.compareDeep(this.group, o.group, true) && Measure.compareDeep(this.supplementalData, o.supplementalData, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Measure)) {
            return false;
        }
        Measure o = (Measure)other;
        return Measure.compareValues(this.disclaimer, o.disclaimer, true) && Measure.compareValues(this.scoring, o.scoring, true) && Measure.compareValues(this.type, o.type, true) && Measure.compareValues(this.riskAdjustment, o.riskAdjustment, true) && Measure.compareValues(this.rateAggregation, o.rateAggregation, true) && Measure.compareValues(this.rationale, o.rationale, true) && Measure.compareValues(this.clinicalRecommendationStatement, o.clinicalRecommendationStatement, true) && Measure.compareValues(this.improvementNotation, o.improvementNotation, true) && Measure.compareValues(this.definition, o.definition, true) && Measure.compareValues(this.guidance, o.guidance, true) && Measure.compareValues(this.set, o.set, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.moduleMetadata != null && !this.moduleMetadata.isEmpty() || this.library != null && !this.library.isEmpty() || this.disclaimer != null && !this.disclaimer.isEmpty() || this.scoring != null && !this.scoring.isEmpty() || this.type != null && !this.type.isEmpty() || this.riskAdjustment != null && !this.riskAdjustment.isEmpty() || this.rateAggregation != null && !this.rateAggregation.isEmpty() || this.rationale != null && !this.rationale.isEmpty() || this.clinicalRecommendationStatement != null && !this.clinicalRecommendationStatement.isEmpty() || this.improvementNotation != null && !this.improvementNotation.isEmpty() || this.definition != null && !this.definition.isEmpty() || this.guidance != null && !this.guidance.isEmpty() || this.set != null && !this.set.isEmpty() || this.group != null && !this.group.isEmpty() || this.supplementalData != null && !this.supplementalData.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Measure;
    }

    @Block
    public static class MeasureSupplementalDataComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identifier, unique within the measure", formalDefinition="An identifier for the supplemental data.")
        protected Identifier identifier;
        @Child(name="usage", type={CodeType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="supplemental-data | risk-adjustment-factor", formalDefinition="An indicator of the intended usage for the supplemental data element. Supplemental data indicates the data is additional information requested to augment the measure information. Risk adjustment factor indicates the data is additional information used to calculate risk adjustment factors when applying a risk model to the measure calculation.")
        protected List<Enumeration<MeasureDataUsage>> usage;
        @Child(name="criteria", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Supplemental data criteria", formalDefinition="The criteria for the supplemental data. This must be the name of a valid expression defined within a referenced library, and defines the data to be returned for this element.")
        protected StringType criteria;
        @Child(name="path", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Path to the supplemental data element", formalDefinition="The supplemental data to be supplied as part of the measure response, specified as a valid FHIR Resource Path.")
        protected StringType path;
        private static final long serialVersionUID = 1666728717L;

        public MeasureSupplementalDataComponent() {
        }

        public MeasureSupplementalDataComponent(Identifier identifier) {
            this.identifier = identifier;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureSupplementalDataComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public MeasureSupplementalDataComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public List<Enumeration<MeasureDataUsage>> getUsage() {
            if (this.usage == null) {
                this.usage = new ArrayList<Enumeration<MeasureDataUsage>>();
            }
            return this.usage;
        }

        public boolean hasUsage() {
            if (this.usage == null) {
                return false;
            }
            for (Enumeration<MeasureDataUsage> item : this.usage) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<MeasureDataUsage> addUsageElement() {
            Enumeration<MeasureDataUsage> t = new Enumeration<MeasureDataUsage>(new MeasureDataUsageEnumFactory());
            if (this.usage == null) {
                this.usage = new ArrayList<Enumeration<MeasureDataUsage>>();
            }
            this.usage.add(t);
            return t;
        }

        public MeasureSupplementalDataComponent addUsage(MeasureDataUsage value) {
            Enumeration<MeasureDataUsage> t = new Enumeration<MeasureDataUsage>(new MeasureDataUsageEnumFactory());
            t.setValue((Object)value);
            if (this.usage == null) {
                this.usage = new ArrayList<Enumeration<MeasureDataUsage>>();
            }
            this.usage.add(t);
            return this;
        }

        public boolean hasUsage(MeasureDataUsage value) {
            if (this.usage == null) {
                return false;
            }
            for (Enumeration<MeasureDataUsage> v : this.usage) {
                if (!((MeasureDataUsage)((Object)v.getValue())).equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        public StringType getCriteriaElement() {
            if (this.criteria == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureSupplementalDataComponent.criteria");
                }
                if (Configuration.doAutoCreate()) {
                    this.criteria = new StringType();
                }
            }
            return this.criteria;
        }

        public boolean hasCriteriaElement() {
            return this.criteria != null && !this.criteria.isEmpty();
        }

        public boolean hasCriteria() {
            return this.criteria != null && !this.criteria.isEmpty();
        }

        public MeasureSupplementalDataComponent setCriteriaElement(StringType value) {
            this.criteria = value;
            return this;
        }

        public String getCriteria() {
            return this.criteria == null ? null : (String)this.criteria.getValue();
        }

        public MeasureSupplementalDataComponent setCriteria(String value) {
            if (Utilities.noString((String)value)) {
                this.criteria = null;
            } else {
                if (this.criteria == null) {
                    this.criteria = new StringType();
                }
                this.criteria.setValue(value);
            }
            return this;
        }

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureSupplementalDataComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public MeasureSupplementalDataComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public MeasureSupplementalDataComponent setPath(String value) {
            if (Utilities.noString((String)value)) {
                this.path = null;
            } else {
                if (this.path == null) {
                    this.path = new StringType();
                }
                this.path.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Measure.SP_IDENTIFIER, "Identifier", "An identifier for the supplemental data.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property("usage", "code", "An indicator of the intended usage for the supplemental data element. Supplemental data indicates the data is additional information requested to augment the measure information. Risk adjustment factor indicates the data is additional information used to calculate risk adjustment factors when applying a risk model to the measure calculation.", 0, Integer.MAX_VALUE, this.usage));
            childrenList.add(new Property("criteria", "string", "The criteria for the supplemental data. This must be the name of a valid expression defined within a referenced library, and defines the data to be returned for this element.", 0, Integer.MAX_VALUE, this.criteria));
            childrenList.add(new Property("path", "string", "The supplemental data to be supplied as part of the measure response, specified as a valid FHIR Resource Path.", 0, Integer.MAX_VALUE, this.path));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 111574433: {
                    return this.usage == null ? new Base[]{} : this.usage.toArray(new Base[this.usage.size()]);
                }
                case 1952046943: {
                    Base[] baseArray;
                    if (this.criteria == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.criteria;
                    }
                    return baseArray;
                }
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.path;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    break;
                }
                case 111574433: {
                    this.getUsage().add(new MeasureDataUsageEnumFactory().fromType(value));
                    break;
                }
                case 1952046943: {
                    this.criteria = this.castToString(value);
                    break;
                }
                case 3433509: {
                    this.path = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Measure.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("usage")) {
                this.getUsage().add(new MeasureDataUsageEnumFactory().fromType(value));
            } else if (name.equals("criteria")) {
                this.criteria = this.castToString(value);
            } else if (name.equals("path")) {
                this.path = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifier();
                }
                case 111574433: {
                    throw new FHIRException("Cannot make property usage as it is not a complex type");
                }
                case 1952046943: {
                    throw new FHIRException("Cannot make property criteria as it is not a complex type");
                }
                case 3433509: {
                    throw new FHIRException("Cannot make property path as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Measure.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("usage")) {
                throw new FHIRException("Cannot call addChild on a singleton property Measure.usage");
            }
            if (name.equals("criteria")) {
                throw new FHIRException("Cannot call addChild on a singleton property Measure.criteria");
            }
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a singleton property Measure.path");
            }
            return super.addChild(name);
        }

        @Override
        public MeasureSupplementalDataComponent copy() {
            MeasureSupplementalDataComponent dst = new MeasureSupplementalDataComponent();
            this.copyValues(dst);
            Identifier identifier = dst.identifier = this.identifier == null ? null : this.identifier.copy();
            if (this.usage != null) {
                dst.usage = new ArrayList<Enumeration<MeasureDataUsage>>();
                for (Enumeration<MeasureDataUsage> i : this.usage) {
                    dst.usage.add((Enumeration<MeasureDataUsage>)i.copy());
                }
            }
            dst.criteria = this.criteria == null ? null : this.criteria.copy();
            dst.path = this.path == null ? null : this.path.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MeasureSupplementalDataComponent)) {
                return false;
            }
            MeasureSupplementalDataComponent o = (MeasureSupplementalDataComponent)other;
            return MeasureSupplementalDataComponent.compareDeep(this.identifier, o.identifier, true) && MeasureSupplementalDataComponent.compareDeep(this.usage, o.usage, true) && MeasureSupplementalDataComponent.compareDeep(this.criteria, o.criteria, true) && MeasureSupplementalDataComponent.compareDeep(this.path, o.path, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MeasureSupplementalDataComponent)) {
                return false;
            }
            MeasureSupplementalDataComponent o = (MeasureSupplementalDataComponent)other;
            return MeasureSupplementalDataComponent.compareValues(this.usage, o.usage, true) && MeasureSupplementalDataComponent.compareValues(this.criteria, o.criteria, true) && MeasureSupplementalDataComponent.compareValues(this.path, o.path, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.usage != null && !this.usage.isEmpty() || this.criteria != null && !this.criteria.isEmpty() || this.path != null && !this.path.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Measure.supplementalData";
        }
    }

    @Block
    public static class MeasureGroupStratifierComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The identifier for the stratifier used to coordinate the reported data back to this stratifier", formalDefinition="The identifier for the stratifier used to coordinate the reported data back to this stratifier.")
        protected Identifier identifier;
        @Child(name="criteria", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Stratifier criteria", formalDefinition="The criteria for the stratifier. This must be the name of an expression defined within a referenced library.")
        protected StringType criteria;
        @Child(name="path", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Path to the stratifier", formalDefinition="The path to an element that defines the stratifier, specified as a valid FHIR resource path.")
        protected StringType path;
        private static final long serialVersionUID = -196134448L;

        public MeasureGroupStratifierComponent() {
        }

        public MeasureGroupStratifierComponent(Identifier identifier) {
            this.identifier = identifier;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupStratifierComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public MeasureGroupStratifierComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public StringType getCriteriaElement() {
            if (this.criteria == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupStratifierComponent.criteria");
                }
                if (Configuration.doAutoCreate()) {
                    this.criteria = new StringType();
                }
            }
            return this.criteria;
        }

        public boolean hasCriteriaElement() {
            return this.criteria != null && !this.criteria.isEmpty();
        }

        public boolean hasCriteria() {
            return this.criteria != null && !this.criteria.isEmpty();
        }

        public MeasureGroupStratifierComponent setCriteriaElement(StringType value) {
            this.criteria = value;
            return this;
        }

        public String getCriteria() {
            return this.criteria == null ? null : (String)this.criteria.getValue();
        }

        public MeasureGroupStratifierComponent setCriteria(String value) {
            if (Utilities.noString((String)value)) {
                this.criteria = null;
            } else {
                if (this.criteria == null) {
                    this.criteria = new StringType();
                }
                this.criteria.setValue(value);
            }
            return this;
        }

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupStratifierComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public MeasureGroupStratifierComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public MeasureGroupStratifierComponent setPath(String value) {
            if (Utilities.noString((String)value)) {
                this.path = null;
            } else {
                if (this.path == null) {
                    this.path = new StringType();
                }
                this.path.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Measure.SP_IDENTIFIER, "Identifier", "The identifier for the stratifier used to coordinate the reported data back to this stratifier.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property("criteria", "string", "The criteria for the stratifier. This must be the name of an expression defined within a referenced library.", 0, Integer.MAX_VALUE, this.criteria));
            childrenList.add(new Property("path", "string", "The path to an element that defines the stratifier, specified as a valid FHIR resource path.", 0, Integer.MAX_VALUE, this.path));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 1952046943: {
                    Base[] baseArray;
                    if (this.criteria == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.criteria;
                    }
                    return baseArray;
                }
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.path;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    break;
                }
                case 1952046943: {
                    this.criteria = this.castToString(value);
                    break;
                }
                case 3433509: {
                    this.path = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Measure.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("criteria")) {
                this.criteria = this.castToString(value);
            } else if (name.equals("path")) {
                this.path = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifier();
                }
                case 1952046943: {
                    throw new FHIRException("Cannot make property criteria as it is not a complex type");
                }
                case 3433509: {
                    throw new FHIRException("Cannot make property path as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Measure.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("criteria")) {
                throw new FHIRException("Cannot call addChild on a singleton property Measure.criteria");
            }
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a singleton property Measure.path");
            }
            return super.addChild(name);
        }

        @Override
        public MeasureGroupStratifierComponent copy() {
            MeasureGroupStratifierComponent dst = new MeasureGroupStratifierComponent();
            this.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.criteria = this.criteria == null ? null : this.criteria.copy();
            dst.path = this.path == null ? null : this.path.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MeasureGroupStratifierComponent)) {
                return false;
            }
            MeasureGroupStratifierComponent o = (MeasureGroupStratifierComponent)other;
            return MeasureGroupStratifierComponent.compareDeep(this.identifier, o.identifier, true) && MeasureGroupStratifierComponent.compareDeep(this.criteria, o.criteria, true) && MeasureGroupStratifierComponent.compareDeep(this.path, o.path, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MeasureGroupStratifierComponent)) {
                return false;
            }
            MeasureGroupStratifierComponent o = (MeasureGroupStratifierComponent)other;
            return MeasureGroupStratifierComponent.compareValues(this.criteria, o.criteria, true) && MeasureGroupStratifierComponent.compareValues(this.path, o.path, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.criteria != null && !this.criteria.isEmpty() || this.path != null && !this.path.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Measure.group.stratifier";
        }
    }

    @Block
    public static class MeasureGroupPopulationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="initial-population | numerator | numerator-exclusion | denominator | denominator-exclusion | denominator-exception | measure-population | measure-population-exclusion | measure-score", formalDefinition="The type of population criteria.")
        protected Enumeration<MeasurePopulationType> type;
        @Child(name="identifier", type={Identifier.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Unique identifier", formalDefinition="A unique identifier for the population criteria. This identifier is used to report data against this criteria within the measure report.")
        protected Identifier identifier;
        @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Short name", formalDefinition="Optional name or short description of this population.")
        protected StringType name;
        @Child(name="description", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The human readable description of this population criteria", formalDefinition="The human readable description of this population criteria.")
        protected StringType description;
        @Child(name="criteria", type={StringType.class}, order=5, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The name of a valid referenced CQL expression (may be namespaced) that defines this population criteria", formalDefinition="The name of a valid referenced CQL expression (may be namespaced) that defines this population criteria.")
        protected StringType criteria;
        private static final long serialVersionUID = 1158202275L;

        public MeasureGroupPopulationComponent() {
        }

        public MeasureGroupPopulationComponent(Enumeration<MeasurePopulationType> type, Identifier identifier, StringType criteria) {
            this.type = type;
            this.identifier = identifier;
            this.criteria = criteria;
        }

        public Enumeration<MeasurePopulationType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupPopulationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<MeasurePopulationType>(new MeasurePopulationTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MeasureGroupPopulationComponent setTypeElement(Enumeration<MeasurePopulationType> value) {
            this.type = value;
            return this;
        }

        public MeasurePopulationType getType() {
            return this.type == null ? null : (MeasurePopulationType)((Object)this.type.getValue());
        }

        public MeasureGroupPopulationComponent setType(MeasurePopulationType value) {
            if (this.type == null) {
                this.type = new Enumeration<MeasurePopulationType>(new MeasurePopulationTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupPopulationComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public MeasureGroupPopulationComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupPopulationComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public MeasureGroupPopulationComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public MeasureGroupPopulationComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupPopulationComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public MeasureGroupPopulationComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public MeasureGroupPopulationComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public StringType getCriteriaElement() {
            if (this.criteria == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupPopulationComponent.criteria");
                }
                if (Configuration.doAutoCreate()) {
                    this.criteria = new StringType();
                }
            }
            return this.criteria;
        }

        public boolean hasCriteriaElement() {
            return this.criteria != null && !this.criteria.isEmpty();
        }

        public boolean hasCriteria() {
            return this.criteria != null && !this.criteria.isEmpty();
        }

        public MeasureGroupPopulationComponent setCriteriaElement(StringType value) {
            this.criteria = value;
            return this;
        }

        public String getCriteria() {
            return this.criteria == null ? null : (String)this.criteria.getValue();
        }

        public MeasureGroupPopulationComponent setCriteria(String value) {
            if (this.criteria == null) {
                this.criteria = new StringType();
            }
            this.criteria.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "code", "The type of population criteria.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property(Measure.SP_IDENTIFIER, "Identifier", "A unique identifier for the population criteria. This identifier is used to report data against this criteria within the measure report.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property("name", "string", "Optional name or short description of this population.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property(Measure.SP_DESCRIPTION, "string", "The human readable description of this population criteria.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property("criteria", "string", "The name of a valid referenced CQL expression (may be namespaced) that defines this population criteria.", 0, Integer.MAX_VALUE, this.criteria));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.description;
                    }
                    return baseArray;
                }
                case 1952046943: {
                    Base[] baseArray;
                    if (this.criteria == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.criteria;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = new MeasurePopulationTypeEnumFactory().fromType(value);
                    break;
                }
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    break;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    break;
                }
                case 1952046943: {
                    this.criteria = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = new MeasurePopulationTypeEnumFactory().fromType(value);
            } else if (name.equals(Measure.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals(Measure.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("criteria")) {
                this.criteria = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    throw new FHIRException("Cannot make property type as it is not a complex type");
                }
                case -1618432855: {
                    return this.getIdentifier();
                }
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1724546052: {
                    throw new FHIRException("Cannot make property description as it is not a complex type");
                }
                case 1952046943: {
                    throw new FHIRException("Cannot make property criteria as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a singleton property Measure.type");
            }
            if (name.equals(Measure.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a singleton property Measure.name");
            }
            if (name.equals(Measure.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a singleton property Measure.description");
            }
            if (name.equals("criteria")) {
                throw new FHIRException("Cannot call addChild on a singleton property Measure.criteria");
            }
            return super.addChild(name);
        }

        @Override
        public MeasureGroupPopulationComponent copy() {
            MeasureGroupPopulationComponent dst = new MeasureGroupPopulationComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.criteria = this.criteria == null ? null : this.criteria.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MeasureGroupPopulationComponent)) {
                return false;
            }
            MeasureGroupPopulationComponent o = (MeasureGroupPopulationComponent)other;
            return MeasureGroupPopulationComponent.compareDeep(this.type, o.type, true) && MeasureGroupPopulationComponent.compareDeep(this.identifier, o.identifier, true) && MeasureGroupPopulationComponent.compareDeep(this.name, o.name, true) && MeasureGroupPopulationComponent.compareDeep(this.description, o.description, true) && MeasureGroupPopulationComponent.compareDeep(this.criteria, o.criteria, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MeasureGroupPopulationComponent)) {
                return false;
            }
            MeasureGroupPopulationComponent o = (MeasureGroupPopulationComponent)other;
            return MeasureGroupPopulationComponent.compareValues(this.type, o.type, true) && MeasureGroupPopulationComponent.compareValues(this.name, o.name, true) && MeasureGroupPopulationComponent.compareValues(this.description, o.description, true) && MeasureGroupPopulationComponent.compareValues(this.criteria, o.criteria, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.name != null && !this.name.isEmpty() || this.description != null && !this.description.isEmpty() || this.criteria != null && !this.criteria.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Measure.group.population";
        }
    }

    @Block
    public static class MeasureGroupComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Unique identifier", formalDefinition="A unique identifier for the group. This identifier will used to report data for the group in the measure report.")
        protected Identifier identifier;
        @Child(name="name", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Short name", formalDefinition="Optional name or short description of this group.")
        protected StringType name;
        @Child(name="description", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Summary description", formalDefinition="The human readable description of this population group.")
        protected StringType description;
        @Child(name="population", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Population criteria", formalDefinition="A population criteria for the measure.")
        protected List<MeasureGroupPopulationComponent> population;
        @Child(name="stratifier", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Stratifier criteria for the measure", formalDefinition="The stratifier criteria for the measure report, specified as either the name of a valid CQL expression defined within a referenced library, or a valid FHIR Resource Path.")
        protected List<MeasureGroupStratifierComponent> stratifier;
        private static final long serialVersionUID = 1287622059L;

        public MeasureGroupComponent() {
        }

        public MeasureGroupComponent(Identifier identifier) {
            this.identifier = identifier;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public MeasureGroupComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public MeasureGroupComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public MeasureGroupComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureGroupComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public MeasureGroupComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public MeasureGroupComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<MeasureGroupPopulationComponent> getPopulation() {
            if (this.population == null) {
                this.population = new ArrayList<MeasureGroupPopulationComponent>();
            }
            return this.population;
        }

        public boolean hasPopulation() {
            if (this.population == null) {
                return false;
            }
            for (MeasureGroupPopulationComponent item : this.population) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MeasureGroupPopulationComponent addPopulation() {
            MeasureGroupPopulationComponent t = new MeasureGroupPopulationComponent();
            if (this.population == null) {
                this.population = new ArrayList<MeasureGroupPopulationComponent>();
            }
            this.population.add(t);
            return t;
        }

        public MeasureGroupComponent addPopulation(MeasureGroupPopulationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.population == null) {
                this.population = new ArrayList<MeasureGroupPopulationComponent>();
            }
            this.population.add(t);
            return this;
        }

        public List<MeasureGroupStratifierComponent> getStratifier() {
            if (this.stratifier == null) {
                this.stratifier = new ArrayList<MeasureGroupStratifierComponent>();
            }
            return this.stratifier;
        }

        public boolean hasStratifier() {
            if (this.stratifier == null) {
                return false;
            }
            for (MeasureGroupStratifierComponent item : this.stratifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MeasureGroupStratifierComponent addStratifier() {
            MeasureGroupStratifierComponent t = new MeasureGroupStratifierComponent();
            if (this.stratifier == null) {
                this.stratifier = new ArrayList<MeasureGroupStratifierComponent>();
            }
            this.stratifier.add(t);
            return t;
        }

        public MeasureGroupComponent addStratifier(MeasureGroupStratifierComponent t) {
            if (t == null) {
                return this;
            }
            if (this.stratifier == null) {
                this.stratifier = new ArrayList<MeasureGroupStratifierComponent>();
            }
            this.stratifier.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Measure.SP_IDENTIFIER, "Identifier", "A unique identifier for the group. This identifier will used to report data for the group in the measure report.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property("name", "string", "Optional name or short description of this group.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property(Measure.SP_DESCRIPTION, "string", "The human readable description of this population group.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property("population", "", "A population criteria for the measure.", 0, Integer.MAX_VALUE, this.population));
            childrenList.add(new Property("stratifier", "", "The stratifier criteria for the measure report, specified as either the name of a valid CQL expression defined within a referenced library, or a valid FHIR Resource Path.", 0, Integer.MAX_VALUE, this.stratifier));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.description;
                    }
                    return baseArray;
                }
                case -2023558323: {
                    return this.population == null ? new Base[]{} : this.population.toArray(new Base[this.population.size()]);
                }
                case 90983669: {
                    return this.stratifier == null ? new Base[]{} : this.stratifier.toArray(new Base[this.stratifier.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    break;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    break;
                }
                case -2023558323: {
                    this.getPopulation().add((MeasureGroupPopulationComponent)value);
                    break;
                }
                case 90983669: {
                    this.getStratifier().add((MeasureGroupStratifierComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Measure.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals(Measure.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("population")) {
                this.getPopulation().add((MeasureGroupPopulationComponent)value);
            } else if (name.equals("stratifier")) {
                this.getStratifier().add((MeasureGroupStratifierComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifier();
                }
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1724546052: {
                    throw new FHIRException("Cannot make property description as it is not a complex type");
                }
                case -2023558323: {
                    return this.addPopulation();
                }
                case 90983669: {
                    return this.addStratifier();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Measure.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a singleton property Measure.name");
            }
            if (name.equals(Measure.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a singleton property Measure.description");
            }
            if (name.equals("population")) {
                return this.addPopulation();
            }
            if (name.equals("stratifier")) {
                return this.addStratifier();
            }
            return super.addChild(name);
        }

        @Override
        public MeasureGroupComponent copy() {
            MeasureGroupComponent dst = new MeasureGroupComponent();
            this.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.name = this.name == null ? null : this.name.copy();
            StringType stringType = dst.description = this.description == null ? null : this.description.copy();
            if (this.population != null) {
                dst.population = new ArrayList<MeasureGroupPopulationComponent>();
                for (MeasureGroupPopulationComponent measureGroupPopulationComponent : this.population) {
                    dst.population.add(measureGroupPopulationComponent.copy());
                }
            }
            if (this.stratifier != null) {
                dst.stratifier = new ArrayList<MeasureGroupStratifierComponent>();
                for (MeasureGroupStratifierComponent measureGroupStratifierComponent : this.stratifier) {
                    dst.stratifier.add(measureGroupStratifierComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MeasureGroupComponent)) {
                return false;
            }
            MeasureGroupComponent o = (MeasureGroupComponent)other;
            return MeasureGroupComponent.compareDeep(this.identifier, o.identifier, true) && MeasureGroupComponent.compareDeep(this.name, o.name, true) && MeasureGroupComponent.compareDeep(this.description, o.description, true) && MeasureGroupComponent.compareDeep(this.population, o.population, true) && MeasureGroupComponent.compareDeep(this.stratifier, o.stratifier, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MeasureGroupComponent)) {
                return false;
            }
            MeasureGroupComponent o = (MeasureGroupComponent)other;
            return MeasureGroupComponent.compareValues(this.name, o.name, true) && MeasureGroupComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.name != null && !this.name.isEmpty() || this.description != null && !this.description.isEmpty() || this.population != null && !this.population.isEmpty() || this.stratifier != null && !this.stratifier.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Measure.group";
        }
    }

    public static class MeasureDataUsageEnumFactory
    implements EnumFactory<MeasureDataUsage> {
        @Override
        public MeasureDataUsage fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("supplemental-data".equals(codeString)) {
                return MeasureDataUsage.SUPPLEMENTALDATA;
            }
            if ("risk-adjustment-factor".equals(codeString)) {
                return MeasureDataUsage.RISKADJUSTMENTFACTOR;
            }
            throw new IllegalArgumentException("Unknown MeasureDataUsage code '" + codeString + "'");
        }

        public Enumeration<MeasureDataUsage> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("supplemental-data".equals(codeString)) {
                return new Enumeration<MeasureDataUsage>(this, MeasureDataUsage.SUPPLEMENTALDATA);
            }
            if ("risk-adjustment-factor".equals(codeString)) {
                return new Enumeration<MeasureDataUsage>(this, MeasureDataUsage.RISKADJUSTMENTFACTOR);
            }
            throw new FHIRException("Unknown MeasureDataUsage code '" + codeString + "'");
        }

        @Override
        public String toCode(MeasureDataUsage code) {
            if (code == MeasureDataUsage.SUPPLEMENTALDATA) {
                return "supplemental-data";
            }
            if (code == MeasureDataUsage.RISKADJUSTMENTFACTOR) {
                return "risk-adjustment-factor";
            }
            return "?";
        }

        @Override
        public String toSystem(MeasureDataUsage code) {
            return code.getSystem();
        }
    }

    public static enum MeasureDataUsage {
        SUPPLEMENTALDATA,
        RISKADJUSTMENTFACTOR,
        NULL;


        public static MeasureDataUsage fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("supplemental-data".equals(codeString)) {
                return SUPPLEMENTALDATA;
            }
            if ("risk-adjustment-factor".equals(codeString)) {
                return RISKADJUSTMENTFACTOR;
            }
            throw new FHIRException("Unknown MeasureDataUsage code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case SUPPLEMENTALDATA: {
                    return "supplemental-data";
                }
                case RISKADJUSTMENTFACTOR: {
                    return "risk-adjustment-factor";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case SUPPLEMENTALDATA: {
                    return "http://hl7.org/fhir/measure-data-usage";
                }
                case RISKADJUSTMENTFACTOR: {
                    return "http://hl7.org/fhir/measure-data-usage";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case SUPPLEMENTALDATA: {
                    return "The data is intended to be provided as additional information alongside the measure results";
                }
                case RISKADJUSTMENTFACTOR: {
                    return "The data is intended to be used to calculate and apply a risk adjustment model for the measure";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case SUPPLEMENTALDATA: {
                    return "Supplemental Data";
                }
                case RISKADJUSTMENTFACTOR: {
                    return "Risk Adjustment Factor";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class MeasurePopulationTypeEnumFactory
    implements EnumFactory<MeasurePopulationType> {
        @Override
        public MeasurePopulationType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("initial-population".equals(codeString)) {
                return MeasurePopulationType.INITIALPOPULATION;
            }
            if ("numerator".equals(codeString)) {
                return MeasurePopulationType.NUMERATOR;
            }
            if ("numerator-exclusion".equals(codeString)) {
                return MeasurePopulationType.NUMERATOREXCLUSION;
            }
            if ("denominator".equals(codeString)) {
                return MeasurePopulationType.DENOMINATOR;
            }
            if ("denominator-exclusion".equals(codeString)) {
                return MeasurePopulationType.DENOMINATOREXCLUSION;
            }
            if ("denominator-exception".equals(codeString)) {
                return MeasurePopulationType.DENOMINATOREXCEPTION;
            }
            if ("measure-population".equals(codeString)) {
                return MeasurePopulationType.MEASUREPOPULATION;
            }
            if ("measure-population-exclusion".equals(codeString)) {
                return MeasurePopulationType.MEASUREPOPULATIONEXCLUSION;
            }
            if ("measure-score".equals(codeString)) {
                return MeasurePopulationType.MEASURESCORE;
            }
            throw new IllegalArgumentException("Unknown MeasurePopulationType code '" + codeString + "'");
        }

        public Enumeration<MeasurePopulationType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("initial-population".equals(codeString)) {
                return new Enumeration<MeasurePopulationType>(this, MeasurePopulationType.INITIALPOPULATION);
            }
            if ("numerator".equals(codeString)) {
                return new Enumeration<MeasurePopulationType>(this, MeasurePopulationType.NUMERATOR);
            }
            if ("numerator-exclusion".equals(codeString)) {
                return new Enumeration<MeasurePopulationType>(this, MeasurePopulationType.NUMERATOREXCLUSION);
            }
            if ("denominator".equals(codeString)) {
                return new Enumeration<MeasurePopulationType>(this, MeasurePopulationType.DENOMINATOR);
            }
            if ("denominator-exclusion".equals(codeString)) {
                return new Enumeration<MeasurePopulationType>(this, MeasurePopulationType.DENOMINATOREXCLUSION);
            }
            if ("denominator-exception".equals(codeString)) {
                return new Enumeration<MeasurePopulationType>(this, MeasurePopulationType.DENOMINATOREXCEPTION);
            }
            if ("measure-population".equals(codeString)) {
                return new Enumeration<MeasurePopulationType>(this, MeasurePopulationType.MEASUREPOPULATION);
            }
            if ("measure-population-exclusion".equals(codeString)) {
                return new Enumeration<MeasurePopulationType>(this, MeasurePopulationType.MEASUREPOPULATIONEXCLUSION);
            }
            if ("measure-score".equals(codeString)) {
                return new Enumeration<MeasurePopulationType>(this, MeasurePopulationType.MEASURESCORE);
            }
            throw new FHIRException("Unknown MeasurePopulationType code '" + codeString + "'");
        }

        @Override
        public String toCode(MeasurePopulationType code) {
            if (code == MeasurePopulationType.INITIALPOPULATION) {
                return "initial-population";
            }
            if (code == MeasurePopulationType.NUMERATOR) {
                return "numerator";
            }
            if (code == MeasurePopulationType.NUMERATOREXCLUSION) {
                return "numerator-exclusion";
            }
            if (code == MeasurePopulationType.DENOMINATOR) {
                return "denominator";
            }
            if (code == MeasurePopulationType.DENOMINATOREXCLUSION) {
                return "denominator-exclusion";
            }
            if (code == MeasurePopulationType.DENOMINATOREXCEPTION) {
                return "denominator-exception";
            }
            if (code == MeasurePopulationType.MEASUREPOPULATION) {
                return "measure-population";
            }
            if (code == MeasurePopulationType.MEASUREPOPULATIONEXCLUSION) {
                return "measure-population-exclusion";
            }
            if (code == MeasurePopulationType.MEASURESCORE) {
                return "measure-score";
            }
            return "?";
        }

        @Override
        public String toSystem(MeasurePopulationType code) {
            return code.getSystem();
        }
    }

    public static enum MeasurePopulationType {
        INITIALPOPULATION,
        NUMERATOR,
        NUMERATOREXCLUSION,
        DENOMINATOR,
        DENOMINATOREXCLUSION,
        DENOMINATOREXCEPTION,
        MEASUREPOPULATION,
        MEASUREPOPULATIONEXCLUSION,
        MEASURESCORE,
        NULL;


        public static MeasurePopulationType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("initial-population".equals(codeString)) {
                return INITIALPOPULATION;
            }
            if ("numerator".equals(codeString)) {
                return NUMERATOR;
            }
            if ("numerator-exclusion".equals(codeString)) {
                return NUMERATOREXCLUSION;
            }
            if ("denominator".equals(codeString)) {
                return DENOMINATOR;
            }
            if ("denominator-exclusion".equals(codeString)) {
                return DENOMINATOREXCLUSION;
            }
            if ("denominator-exception".equals(codeString)) {
                return DENOMINATOREXCEPTION;
            }
            if ("measure-population".equals(codeString)) {
                return MEASUREPOPULATION;
            }
            if ("measure-population-exclusion".equals(codeString)) {
                return MEASUREPOPULATIONEXCLUSION;
            }
            if ("measure-score".equals(codeString)) {
                return MEASURESCORE;
            }
            throw new FHIRException("Unknown MeasurePopulationType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INITIALPOPULATION: {
                    return "initial-population";
                }
                case NUMERATOR: {
                    return "numerator";
                }
                case NUMERATOREXCLUSION: {
                    return "numerator-exclusion";
                }
                case DENOMINATOR: {
                    return "denominator";
                }
                case DENOMINATOREXCLUSION: {
                    return "denominator-exclusion";
                }
                case DENOMINATOREXCEPTION: {
                    return "denominator-exception";
                }
                case MEASUREPOPULATION: {
                    return "measure-population";
                }
                case MEASUREPOPULATIONEXCLUSION: {
                    return "measure-population-exclusion";
                }
                case MEASURESCORE: {
                    return "measure-score";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INITIALPOPULATION: {
                    return "http://hl7.org/fhir/measure-population";
                }
                case NUMERATOR: {
                    return "http://hl7.org/fhir/measure-population";
                }
                case NUMERATOREXCLUSION: {
                    return "http://hl7.org/fhir/measure-population";
                }
                case DENOMINATOR: {
                    return "http://hl7.org/fhir/measure-population";
                }
                case DENOMINATOREXCLUSION: {
                    return "http://hl7.org/fhir/measure-population";
                }
                case DENOMINATOREXCEPTION: {
                    return "http://hl7.org/fhir/measure-population";
                }
                case MEASUREPOPULATION: {
                    return "http://hl7.org/fhir/measure-population";
                }
                case MEASUREPOPULATIONEXCLUSION: {
                    return "http://hl7.org/fhir/measure-population";
                }
                case MEASURESCORE: {
                    return "http://hl7.org/fhir/measure-population";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INITIALPOPULATION: {
                    return "The initial population for the measure";
                }
                case NUMERATOR: {
                    return "The numerator for the measure";
                }
                case NUMERATOREXCLUSION: {
                    return "The numerator exclusion for the measure";
                }
                case DENOMINATOR: {
                    return "The denominator for the measure";
                }
                case DENOMINATOREXCLUSION: {
                    return "The denominator exclusion for the measure";
                }
                case DENOMINATOREXCEPTION: {
                    return "The denominator exception for the measure";
                }
                case MEASUREPOPULATION: {
                    return "The measure population for the measure";
                }
                case MEASUREPOPULATIONEXCLUSION: {
                    return "The measure population exclusion for the measure";
                }
                case MEASURESCORE: {
                    return "The measure score for the measure";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INITIALPOPULATION: {
                    return "Initial Population";
                }
                case NUMERATOR: {
                    return "Numerator";
                }
                case NUMERATOREXCLUSION: {
                    return "Numerator Exclusion";
                }
                case DENOMINATOR: {
                    return "Denominator";
                }
                case DENOMINATOREXCLUSION: {
                    return "Denominator Exclusion";
                }
                case DENOMINATOREXCEPTION: {
                    return "Denominator Exception";
                }
                case MEASUREPOPULATION: {
                    return "Measure Population";
                }
                case MEASUREPOPULATIONEXCLUSION: {
                    return "Measure Population Exclusion";
                }
                case MEASURESCORE: {
                    return "Measure Score";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class MeasureTypeEnumFactory
    implements EnumFactory<MeasureType> {
        @Override
        public MeasureType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("process".equals(codeString)) {
                return MeasureType.PROCESS;
            }
            if ("outcome".equals(codeString)) {
                return MeasureType.OUTCOME;
            }
            throw new IllegalArgumentException("Unknown MeasureType code '" + codeString + "'");
        }

        public Enumeration<MeasureType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("process".equals(codeString)) {
                return new Enumeration<MeasureType>(this, MeasureType.PROCESS);
            }
            if ("outcome".equals(codeString)) {
                return new Enumeration<MeasureType>(this, MeasureType.OUTCOME);
            }
            throw new FHIRException("Unknown MeasureType code '" + codeString + "'");
        }

        @Override
        public String toCode(MeasureType code) {
            if (code == MeasureType.PROCESS) {
                return "process";
            }
            if (code == MeasureType.OUTCOME) {
                return "outcome";
            }
            return "?";
        }

        @Override
        public String toSystem(MeasureType code) {
            return code.getSystem();
        }
    }

    public static enum MeasureType {
        PROCESS,
        OUTCOME,
        NULL;


        public static MeasureType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("process".equals(codeString)) {
                return PROCESS;
            }
            if ("outcome".equals(codeString)) {
                return OUTCOME;
            }
            throw new FHIRException("Unknown MeasureType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROCESS: {
                    return "process";
                }
                case OUTCOME: {
                    return "outcome";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROCESS: {
                    return "http://hl7.org/fhir/measure-type";
                }
                case OUTCOME: {
                    return "http://hl7.org/fhir/measure-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROCESS: {
                    return "The measure is a process measure";
                }
                case OUTCOME: {
                    return "The measure is an outcome measure";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROCESS: {
                    return "Process";
                }
                case OUTCOME: {
                    return "Outcome";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class MeasureScoringEnumFactory
    implements EnumFactory<MeasureScoring> {
        @Override
        public MeasureScoring fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("proportion".equals(codeString)) {
                return MeasureScoring.PROPORTION;
            }
            if ("ratio".equals(codeString)) {
                return MeasureScoring.RATIO;
            }
            if ("continuous-variable".equals(codeString)) {
                return MeasureScoring.CONTINUOUSVARIABLE;
            }
            if ("cohort".equals(codeString)) {
                return MeasureScoring.COHORT;
            }
            throw new IllegalArgumentException("Unknown MeasureScoring code '" + codeString + "'");
        }

        public Enumeration<MeasureScoring> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proportion".equals(codeString)) {
                return new Enumeration<MeasureScoring>(this, MeasureScoring.PROPORTION);
            }
            if ("ratio".equals(codeString)) {
                return new Enumeration<MeasureScoring>(this, MeasureScoring.RATIO);
            }
            if ("continuous-variable".equals(codeString)) {
                return new Enumeration<MeasureScoring>(this, MeasureScoring.CONTINUOUSVARIABLE);
            }
            if ("cohort".equals(codeString)) {
                return new Enumeration<MeasureScoring>(this, MeasureScoring.COHORT);
            }
            throw new FHIRException("Unknown MeasureScoring code '" + codeString + "'");
        }

        @Override
        public String toCode(MeasureScoring code) {
            if (code == MeasureScoring.PROPORTION) {
                return "proportion";
            }
            if (code == MeasureScoring.RATIO) {
                return "ratio";
            }
            if (code == MeasureScoring.CONTINUOUSVARIABLE) {
                return "continuous-variable";
            }
            if (code == MeasureScoring.COHORT) {
                return "cohort";
            }
            return "?";
        }

        @Override
        public String toSystem(MeasureScoring code) {
            return code.getSystem();
        }
    }

    public static enum MeasureScoring {
        PROPORTION,
        RATIO,
        CONTINUOUSVARIABLE,
        COHORT,
        NULL;


        public static MeasureScoring fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proportion".equals(codeString)) {
                return PROPORTION;
            }
            if ("ratio".equals(codeString)) {
                return RATIO;
            }
            if ("continuous-variable".equals(codeString)) {
                return CONTINUOUSVARIABLE;
            }
            if ("cohort".equals(codeString)) {
                return COHORT;
            }
            throw new FHIRException("Unknown MeasureScoring code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROPORTION: {
                    return "proportion";
                }
                case RATIO: {
                    return "ratio";
                }
                case CONTINUOUSVARIABLE: {
                    return "continuous-variable";
                }
                case COHORT: {
                    return "cohort";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROPORTION: {
                    return "http://hl7.org/fhir/measure-scoring";
                }
                case RATIO: {
                    return "http://hl7.org/fhir/measure-scoring";
                }
                case CONTINUOUSVARIABLE: {
                    return "http://hl7.org/fhir/measure-scoring";
                }
                case COHORT: {
                    return "http://hl7.org/fhir/measure-scoring";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROPORTION: {
                    return "The measure score is defined using a proportion";
                }
                case RATIO: {
                    return "The measure score is defined using a ratio";
                }
                case CONTINUOUSVARIABLE: {
                    return "The score is defined by a calculation of some quantity";
                }
                case COHORT: {
                    return "The measure is a cohort definition";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROPORTION: {
                    return "Proportion";
                }
                case RATIO: {
                    return "Ratio";
                }
                case CONTINUOUSVARIABLE: {
                    return "Continuous Variable";
                }
                case COHORT: {
                    return "Cohort";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

