/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Attachment;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.Device;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Encounter;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.RelatedPerson;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;

@ResourceDef(name="CommunicationRequest", profile="http://hl7.org/fhir/Profile/CommunicationRequest")
public class CommunicationRequest
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique identifier", formalDefinition="A unique ID of this request for reference purposes. It must be provided if user wants it returned as part of any output, otherwise it will be autogenerated, if needed, by CDS system. Does not need to be the actual ID of the source system.")
    protected List<Identifier> identifier;
    @Child(name="category", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Message category", formalDefinition="The type of message to be sent such as alert, notification, reminder, instruction, etc.")
    protected CodeableConcept category;
    @Child(name="sender", type={Device.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Message sender", formalDefinition="The entity (e.g. person, organization, clinical information system, or device) which is to be the source of the communication.")
    protected Reference sender;
    protected Resource senderTarget;
    @Child(name="recipient", type={Device.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Message recipient", formalDefinition="The entity (e.g. person, organization, clinical information system, or device) which is the intended target of the communication.")
    protected List<Reference> recipient;
    protected List<Resource> recipientTarget;
    @Child(name="payload", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Message payload", formalDefinition="Text, attachment(s), or resource(s) to be communicated to the recipient.")
    protected List<CommunicationRequestPayloadComponent> payload;
    @Child(name="medium", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A channel of communication", formalDefinition="A channel that was used for this communication (e.g. email, fax).")
    protected List<CodeableConcept> medium;
    @Child(name="requester", type={Practitioner.class, Patient.class, RelatedPerson.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="An individual who requested a communication", formalDefinition="The responsible person who authorizes this order, e.g. physician. This may be different than the author of the order statement, e.g. clerk, who may have entered the statement into the order entry application.")
    protected Reference requester;
    protected Resource requesterTarget;
    @Child(name="status", type={CodeType.class}, order=7, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="proposed | planned | requested | received | accepted | in-progress | completed | suspended | rejected | failed", formalDefinition="The status of the proposal or order.")
    protected Enumeration<CommunicationRequestStatus> status;
    @Child(name="encounter", type={Encounter.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Encounter leading to message", formalDefinition="The encounter within which the communication request was created.")
    protected Reference encounter;
    protected Encounter encounterTarget;
    @Child(name="scheduled", type={DateTimeType.class, Period.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When scheduled", formalDefinition="The time when this communication is to occur.")
    protected Type scheduled;
    @Child(name="reason", type={CodeableConcept.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Indication for message", formalDefinition="The reason or justification for the communication request.")
    protected List<CodeableConcept> reason;
    @Child(name="requestedOn", type={DateTimeType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When ordered or proposed", formalDefinition="The time when the request was made.")
    protected DateTimeType requestedOn;
    @Child(name="subject", type={Patient.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Focus of message", formalDefinition="The patient who is the focus of this communication request.")
    protected Reference subject;
    protected Patient subjectTarget;
    @Child(name="priority", type={CodeableConcept.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Message urgency", formalDefinition="Characterizes how quickly the proposed act must be initiated. Includes concepts such as stat, urgent, routine.")
    protected CodeableConcept priority;
    private static final long serialVersionUID = 146906020L;
    @SearchParamDefinition(name="sender", path="CommunicationRequest.sender", description="Message sender", type="reference")
    public static final String SP_SENDER = "sender";
    public static final ReferenceClientParam SENDER = new ReferenceClientParam("sender");
    public static final Include INCLUDE_SENDER = new Include("CommunicationRequest:sender").toLocked();
    @SearchParamDefinition(name="requested", path="CommunicationRequest.requestedOn", description="When ordered or proposed", type="date")
    public static final String SP_REQUESTED = "requested";
    public static final DateClientParam REQUESTED = new DateClientParam("requested");
    @SearchParamDefinition(name="time", path="CommunicationRequest.scheduled.as(DateTime)", description="When scheduled", type="date")
    public static final String SP_TIME = "time";
    public static final DateClientParam TIME = new DateClientParam("time");
    @SearchParamDefinition(name="requester", path="CommunicationRequest.requester", description="An individual who requested a communication", type="reference")
    public static final String SP_REQUESTER = "requester";
    public static final ReferenceClientParam REQUESTER = new ReferenceClientParam("requester");
    public static final Include INCLUDE_REQUESTER = new Include("CommunicationRequest:requester").toLocked();
    @SearchParamDefinition(name="category", path="CommunicationRequest.category", description="Message category", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="patient", path="CommunicationRequest.subject", description="Focus of message", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("CommunicationRequest:patient").toLocked();
    @SearchParamDefinition(name="status", path="CommunicationRequest.status", description="proposed | planned | requested | received | accepted | in-progress | completed | suspended | rejected | failed", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="priority", path="CommunicationRequest.priority", description="Message urgency", type="token")
    public static final String SP_PRIORITY = "priority";
    public static final TokenClientParam PRIORITY = new TokenClientParam("priority");
    @SearchParamDefinition(name="subject", path="CommunicationRequest.subject", description="Focus of message", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("CommunicationRequest:subject").toLocked();
    @SearchParamDefinition(name="encounter", path="CommunicationRequest.encounter", description="Encounter leading to message", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("CommunicationRequest:encounter").toLocked();
    @SearchParamDefinition(name="identifier", path="CommunicationRequest.identifier", description="Unique identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="medium", path="CommunicationRequest.medium", description="A channel of communication", type="token")
    public static final String SP_MEDIUM = "medium";
    public static final TokenClientParam MEDIUM = new TokenClientParam("medium");
    @SearchParamDefinition(name="recipient", path="CommunicationRequest.recipient", description="Message recipient", type="reference")
    public static final String SP_RECIPIENT = "recipient";
    public static final ReferenceClientParam RECIPIENT = new ReferenceClientParam("recipient");
    public static final Include INCLUDE_RECIPIENT = new Include("CommunicationRequest:recipient").toLocked();

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public CommunicationRequest addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public CodeableConcept getCategory() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CommunicationRequest.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new CodeableConcept();
            }
        }
        return this.category;
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public CommunicationRequest setCategory(CodeableConcept value) {
        this.category = value;
        return this;
    }

    public Reference getSender() {
        if (this.sender == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CommunicationRequest.sender");
            }
            if (Configuration.doAutoCreate()) {
                this.sender = new Reference();
            }
        }
        return this.sender;
    }

    public boolean hasSender() {
        return this.sender != null && !this.sender.isEmpty();
    }

    public CommunicationRequest setSender(Reference value) {
        this.sender = value;
        return this;
    }

    public Resource getSenderTarget() {
        return this.senderTarget;
    }

    public CommunicationRequest setSenderTarget(Resource value) {
        this.senderTarget = value;
        return this;
    }

    public List<Reference> getRecipient() {
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        return this.recipient;
    }

    public boolean hasRecipient() {
        if (this.recipient == null) {
            return false;
        }
        for (Reference item : this.recipient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addRecipient() {
        Reference t = new Reference();
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        this.recipient.add(t);
        return t;
    }

    public CommunicationRequest addRecipient(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        this.recipient.add(t);
        return this;
    }

    public List<Resource> getRecipientTarget() {
        if (this.recipientTarget == null) {
            this.recipientTarget = new ArrayList<Resource>();
        }
        return this.recipientTarget;
    }

    public List<CommunicationRequestPayloadComponent> getPayload() {
        if (this.payload == null) {
            this.payload = new ArrayList<CommunicationRequestPayloadComponent>();
        }
        return this.payload;
    }

    public boolean hasPayload() {
        if (this.payload == null) {
            return false;
        }
        for (CommunicationRequestPayloadComponent item : this.payload) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CommunicationRequestPayloadComponent addPayload() {
        CommunicationRequestPayloadComponent t = new CommunicationRequestPayloadComponent();
        if (this.payload == null) {
            this.payload = new ArrayList<CommunicationRequestPayloadComponent>();
        }
        this.payload.add(t);
        return t;
    }

    public CommunicationRequest addPayload(CommunicationRequestPayloadComponent t) {
        if (t == null) {
            return this;
        }
        if (this.payload == null) {
            this.payload = new ArrayList<CommunicationRequestPayloadComponent>();
        }
        this.payload.add(t);
        return this;
    }

    public List<CodeableConcept> getMedium() {
        if (this.medium == null) {
            this.medium = new ArrayList<CodeableConcept>();
        }
        return this.medium;
    }

    public boolean hasMedium() {
        if (this.medium == null) {
            return false;
        }
        for (CodeableConcept item : this.medium) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addMedium() {
        CodeableConcept t = new CodeableConcept();
        if (this.medium == null) {
            this.medium = new ArrayList<CodeableConcept>();
        }
        this.medium.add(t);
        return t;
    }

    public CommunicationRequest addMedium(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.medium == null) {
            this.medium = new ArrayList<CodeableConcept>();
        }
        this.medium.add(t);
        return this;
    }

    public Reference getRequester() {
        if (this.requester == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CommunicationRequest.requester");
            }
            if (Configuration.doAutoCreate()) {
                this.requester = new Reference();
            }
        }
        return this.requester;
    }

    public boolean hasRequester() {
        return this.requester != null && !this.requester.isEmpty();
    }

    public CommunicationRequest setRequester(Reference value) {
        this.requester = value;
        return this;
    }

    public Resource getRequesterTarget() {
        return this.requesterTarget;
    }

    public CommunicationRequest setRequesterTarget(Resource value) {
        this.requesterTarget = value;
        return this;
    }

    public Enumeration<CommunicationRequestStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CommunicationRequest.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<CommunicationRequestStatus>(new CommunicationRequestStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public CommunicationRequest setStatusElement(Enumeration<CommunicationRequestStatus> value) {
        this.status = value;
        return this;
    }

    public CommunicationRequestStatus getStatus() {
        return this.status == null ? null : (CommunicationRequestStatus)((Object)this.status.getValue());
    }

    public CommunicationRequest setStatus(CommunicationRequestStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<CommunicationRequestStatus>(new CommunicationRequestStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CommunicationRequest.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public CommunicationRequest setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Encounter getEncounterTarget() {
        if (this.encounterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CommunicationRequest.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterTarget = new Encounter();
            }
        }
        return this.encounterTarget;
    }

    public CommunicationRequest setEncounterTarget(Encounter value) {
        this.encounterTarget = value;
        return this;
    }

    public Type getScheduled() {
        return this.scheduled;
    }

    public DateTimeType getScheduledDateTimeType() throws FHIRException {
        if (!(this.scheduled instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.scheduled.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.scheduled;
    }

    public boolean hasScheduledDateTimeType() {
        return this.scheduled instanceof DateTimeType;
    }

    public Period getScheduledPeriod() throws FHIRException {
        if (!(this.scheduled instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.scheduled.getClass().getName() + " was encountered");
        }
        return (Period)this.scheduled;
    }

    public boolean hasScheduledPeriod() {
        return this.scheduled instanceof Period;
    }

    public boolean hasScheduled() {
        return this.scheduled != null && !this.scheduled.isEmpty();
    }

    public CommunicationRequest setScheduled(Type value) {
        this.scheduled = value;
        return this;
    }

    public List<CodeableConcept> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        return this.reason;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableConcept item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReason() {
        CodeableConcept t = new CodeableConcept();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        this.reason.add(t);
        return t;
    }

    public CommunicationRequest addReason(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        this.reason.add(t);
        return this;
    }

    public DateTimeType getRequestedOnElement() {
        if (this.requestedOn == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CommunicationRequest.requestedOn");
            }
            if (Configuration.doAutoCreate()) {
                this.requestedOn = new DateTimeType();
            }
        }
        return this.requestedOn;
    }

    public boolean hasRequestedOnElement() {
        return this.requestedOn != null && !this.requestedOn.isEmpty();
    }

    public boolean hasRequestedOn() {
        return this.requestedOn != null && !this.requestedOn.isEmpty();
    }

    public CommunicationRequest setRequestedOnElement(DateTimeType value) {
        this.requestedOn = value;
        return this;
    }

    public Date getRequestedOn() {
        return this.requestedOn == null ? null : (Date)this.requestedOn.getValue();
    }

    public CommunicationRequest setRequestedOn(Date value) {
        if (value == null) {
            this.requestedOn = null;
        } else {
            if (this.requestedOn == null) {
                this.requestedOn = new DateTimeType();
            }
            this.requestedOn.setValue(value);
        }
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CommunicationRequest.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public CommunicationRequest setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Patient getSubjectTarget() {
        if (this.subjectTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CommunicationRequest.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subjectTarget = new Patient();
            }
        }
        return this.subjectTarget;
    }

    public CommunicationRequest setSubjectTarget(Patient value) {
        this.subjectTarget = value;
        return this;
    }

    public CodeableConcept getPriority() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CommunicationRequest.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new CodeableConcept();
            }
        }
        return this.priority;
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public CommunicationRequest setPriority(CodeableConcept value) {
        this.priority = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "A unique ID of this request for reference purposes. It must be provided if user wants it returned as part of any output, otherwise it will be autogenerated, if needed, by CDS system. Does not need to be the actual ID of the source system.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_CATEGORY, "CodeableConcept", "The type of message to be sent such as alert, notification, reminder, instruction, etc.", 0, Integer.MAX_VALUE, this.category));
        childrenList.add(new Property(SP_SENDER, "Reference(Device|Organization|Patient|Practitioner|RelatedPerson)", "The entity (e.g. person, organization, clinical information system, or device) which is to be the source of the communication.", 0, Integer.MAX_VALUE, this.sender));
        childrenList.add(new Property(SP_RECIPIENT, "Reference(Device|Organization|Patient|Practitioner|RelatedPerson)", "The entity (e.g. person, organization, clinical information system, or device) which is the intended target of the communication.", 0, Integer.MAX_VALUE, this.recipient));
        childrenList.add(new Property("payload", "", "Text, attachment(s), or resource(s) to be communicated to the recipient.", 0, Integer.MAX_VALUE, this.payload));
        childrenList.add(new Property(SP_MEDIUM, "CodeableConcept", "A channel that was used for this communication (e.g. email, fax).", 0, Integer.MAX_VALUE, this.medium));
        childrenList.add(new Property(SP_REQUESTER, "Reference(Practitioner|Patient|RelatedPerson)", "The responsible person who authorizes this order, e.g. physician. This may be different than the author of the order statement, e.g. clerk, who may have entered the statement into the order entry application.", 0, Integer.MAX_VALUE, this.requester));
        childrenList.add(new Property(SP_STATUS, "code", "The status of the proposal or order.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The encounter within which the communication request was created.", 0, Integer.MAX_VALUE, this.encounter));
        childrenList.add(new Property("scheduled[x]", "dateTime|Period", "The time when this communication is to occur.", 0, Integer.MAX_VALUE, this.scheduled));
        childrenList.add(new Property("reason", "CodeableConcept", "The reason or justification for the communication request.", 0, Integer.MAX_VALUE, this.reason));
        childrenList.add(new Property("requestedOn", "dateTime", "The time when the request was made.", 0, Integer.MAX_VALUE, this.requestedOn));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Patient)", "The patient who is the focus of this communication request.", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property(SP_PRIORITY, "CodeableConcept", "Characterizes how quickly the proposed act must be initiated. Includes concepts such as stat, urgent, routine.", 0, Integer.MAX_VALUE, this.priority));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 50511102: {
                Base[] baseArray;
                if (this.category == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.category;
                }
                return baseArray;
            }
            case -905962955: {
                Base[] baseArray;
                if (this.sender == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.sender;
                }
                return baseArray;
            }
            case 820081177: {
                return this.recipient == null ? new Base[]{} : this.recipient.toArray(new Base[this.recipient.size()]);
            }
            case -786701938: {
                return this.payload == null ? new Base[]{} : this.payload.toArray(new Base[this.payload.size()]);
            }
            case -1078030475: {
                return this.medium == null ? new Base[]{} : this.medium.toArray(new Base[this.medium.size()]);
            }
            case 693933948: {
                Base[] baseArray;
                if (this.requester == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.requester;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.encounter;
                }
                return baseArray;
            }
            case -160710483: {
                Base[] baseArray;
                if (this.scheduled == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.scheduled;
                }
                return baseArray;
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case 1150582253: {
                Base[] baseArray;
                if (this.requestedOn == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.requestedOn;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.subject;
                }
                return baseArray;
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.priority;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case 50511102: {
                this.category = this.castToCodeableConcept(value);
                break;
            }
            case -905962955: {
                this.sender = this.castToReference(value);
                break;
            }
            case 820081177: {
                this.getRecipient().add(this.castToReference(value));
                break;
            }
            case -786701938: {
                this.getPayload().add((CommunicationRequestPayloadComponent)value);
                break;
            }
            case -1078030475: {
                this.getMedium().add(this.castToCodeableConcept(value));
                break;
            }
            case 693933948: {
                this.requester = this.castToReference(value);
                break;
            }
            case -892481550: {
                this.status = new CommunicationRequestStatusEnumFactory().fromType(value);
                break;
            }
            case 1524132147: {
                this.encounter = this.castToReference(value);
                break;
            }
            case -160710483: {
                this.scheduled = (Type)value;
                break;
            }
            case -934964668: {
                this.getReason().add(this.castToCodeableConcept(value));
                break;
            }
            case 1150582253: {
                this.requestedOn = this.castToDateTime(value);
                break;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                break;
            }
            case -1165461084: {
                this.priority = this.castToCodeableConcept(value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_CATEGORY)) {
            this.category = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SENDER)) {
            this.sender = this.castToReference(value);
        } else if (name.equals(SP_RECIPIENT)) {
            this.getRecipient().add(this.castToReference(value));
        } else if (name.equals("payload")) {
            this.getPayload().add((CommunicationRequestPayloadComponent)value);
        } else if (name.equals(SP_MEDIUM)) {
            this.getMedium().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_REQUESTER)) {
            this.requester = this.castToReference(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new CommunicationRequestStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = this.castToReference(value);
        } else if (name.equals("scheduled[x]")) {
            this.scheduled = (Type)value;
        } else if (name.equals("reason")) {
            this.getReason().add(this.castToCodeableConcept(value));
        } else if (name.equals("requestedOn")) {
            this.requestedOn = this.castToDateTime(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_PRIORITY)) {
            this.priority = this.castToCodeableConcept(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 50511102: {
                return this.getCategory();
            }
            case -905962955: {
                return this.getSender();
            }
            case 820081177: {
                return this.addRecipient();
            }
            case -786701938: {
                return this.addPayload();
            }
            case -1078030475: {
                return this.addMedium();
            }
            case 693933948: {
                return this.getRequester();
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case 1162627251: {
                return this.getScheduled();
            }
            case -934964668: {
                return this.addReason();
            }
            case 1150582253: {
                throw new FHIRException("Cannot make property requestedOn as it is not a complex type");
            }
            case -1867885268: {
                return this.getSubject();
            }
            case -1165461084: {
                return this.getPriority();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_CATEGORY)) {
            this.category = new CodeableConcept();
            return this.category;
        }
        if (name.equals(SP_SENDER)) {
            this.sender = new Reference();
            return this.sender;
        }
        if (name.equals(SP_RECIPIENT)) {
            return this.addRecipient();
        }
        if (name.equals("payload")) {
            return this.addPayload();
        }
        if (name.equals(SP_MEDIUM)) {
            return this.addMedium();
        }
        if (name.equals(SP_REQUESTER)) {
            this.requester = new Reference();
            return this.requester;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property CommunicationRequest.status");
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("scheduledDateTime")) {
            this.scheduled = new DateTimeType();
            return this.scheduled;
        }
        if (name.equals("scheduledPeriod")) {
            this.scheduled = new Period();
            return this.scheduled;
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals("requestedOn")) {
            throw new FHIRException("Cannot call addChild on a singleton property CommunicationRequest.requestedOn");
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_PRIORITY)) {
            this.priority = new CodeableConcept();
            return this.priority;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CommunicationRequest";
    }

    @Override
    public CommunicationRequest copy() {
        CommunicationRequest dst = new CommunicationRequest();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.category = this.category == null ? null : this.category.copy();
        Reference reference = dst.sender = this.sender == null ? null : this.sender.copy();
        if (this.recipient != null) {
            dst.recipient = new ArrayList<Reference>();
            for (Reference reference2 : this.recipient) {
                dst.recipient.add(reference2.copy());
            }
        }
        if (this.payload != null) {
            dst.payload = new ArrayList<CommunicationRequestPayloadComponent>();
            for (CommunicationRequestPayloadComponent communicationRequestPayloadComponent : this.payload) {
                dst.payload.add(communicationRequestPayloadComponent.copy());
            }
        }
        if (this.medium != null) {
            dst.medium = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.medium) {
                dst.medium.add(codeableConcept.copy());
            }
        }
        dst.requester = this.requester == null ? null : this.requester.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        Type type = dst.scheduled = this.scheduled == null ? null : this.scheduled.copy();
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reason) {
                dst.reason.add(codeableConcept.copy());
            }
        }
        dst.requestedOn = this.requestedOn == null ? null : this.requestedOn.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.priority = this.priority == null ? null : this.priority.copy();
        return dst;
    }

    protected CommunicationRequest typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof CommunicationRequest)) {
            return false;
        }
        CommunicationRequest o = (CommunicationRequest)other;
        return CommunicationRequest.compareDeep(this.identifier, o.identifier, true) && CommunicationRequest.compareDeep(this.category, o.category, true) && CommunicationRequest.compareDeep(this.sender, o.sender, true) && CommunicationRequest.compareDeep(this.recipient, o.recipient, true) && CommunicationRequest.compareDeep(this.payload, o.payload, true) && CommunicationRequest.compareDeep(this.medium, o.medium, true) && CommunicationRequest.compareDeep(this.requester, o.requester, true) && CommunicationRequest.compareDeep(this.status, o.status, true) && CommunicationRequest.compareDeep(this.encounter, o.encounter, true) && CommunicationRequest.compareDeep(this.scheduled, o.scheduled, true) && CommunicationRequest.compareDeep(this.reason, o.reason, true) && CommunicationRequest.compareDeep(this.requestedOn, o.requestedOn, true) && CommunicationRequest.compareDeep(this.subject, o.subject, true) && CommunicationRequest.compareDeep(this.priority, o.priority, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof CommunicationRequest)) {
            return false;
        }
        CommunicationRequest o = (CommunicationRequest)other;
        return CommunicationRequest.compareValues(this.status, o.status, true) && CommunicationRequest.compareValues(this.requestedOn, o.requestedOn, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.category != null && !this.category.isEmpty() || this.sender != null && !this.sender.isEmpty() || this.recipient != null && !this.recipient.isEmpty() || this.payload != null && !this.payload.isEmpty() || this.medium != null && !this.medium.isEmpty() || this.requester != null && !this.requester.isEmpty() || this.status != null && !this.status.isEmpty() || this.encounter != null && !this.encounter.isEmpty() || this.scheduled != null && !this.scheduled.isEmpty() || this.reason != null && !this.reason.isEmpty() || this.requestedOn != null && !this.requestedOn.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.priority != null && !this.priority.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.CommunicationRequest;
    }

    @Block
    public static class CommunicationRequestPayloadComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="content", type={StringType.class, Attachment.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Message part content", formalDefinition="The communicated content (or for multi-part communications, one portion of the communication).")
        protected Type content;
        private static final long serialVersionUID = -1763459053L;

        public CommunicationRequestPayloadComponent() {
        }

        public CommunicationRequestPayloadComponent(Type content) {
            this.content = content;
        }

        public Type getContent() {
            return this.content;
        }

        public StringType getContentStringType() throws FHIRException {
            if (!(this.content instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (StringType)this.content;
        }

        public boolean hasContentStringType() {
            return this.content instanceof StringType;
        }

        public Attachment getContentAttachment() throws FHIRException {
            if (!(this.content instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Attachment)this.content;
        }

        public boolean hasContentAttachment() {
            return this.content instanceof Attachment;
        }

        public Reference getContentReference() throws FHIRException {
            if (!(this.content instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Reference)this.content;
        }

        public boolean hasContentReference() {
            return this.content instanceof Reference;
        }

        public boolean hasContent() {
            return this.content != null && !this.content.isEmpty();
        }

        public CommunicationRequestPayloadComponent setContent(Type value) {
            this.content = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("content[x]", "string|Attachment|Reference(Any)", "The communicated content (or for multi-part communications, one portion of the communication).", 0, Integer.MAX_VALUE, this.content));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    Base[] baseArray;
                    if (this.content == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.content;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    this.content = (Type)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("content[x]")) {
                this.content = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 264548711: {
                    return this.getContent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("contentString")) {
                this.content = new StringType();
                return this.content;
            }
            if (name.equals("contentAttachment")) {
                this.content = new Attachment();
                return this.content;
            }
            if (name.equals("contentReference")) {
                this.content = new Reference();
                return this.content;
            }
            return super.addChild(name);
        }

        @Override
        public CommunicationRequestPayloadComponent copy() {
            CommunicationRequestPayloadComponent dst = new CommunicationRequestPayloadComponent();
            this.copyValues(dst);
            dst.content = this.content == null ? null : this.content.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof CommunicationRequestPayloadComponent)) {
                return false;
            }
            CommunicationRequestPayloadComponent o = (CommunicationRequestPayloadComponent)other;
            return CommunicationRequestPayloadComponent.compareDeep(this.content, o.content, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof CommunicationRequestPayloadComponent)) {
                return false;
            }
            CommunicationRequestPayloadComponent o = (CommunicationRequestPayloadComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && (this.content == null || this.content.isEmpty());
        }

        @Override
        public String fhirType() {
            return "CommunicationRequest.payload";
        }
    }

    public static class CommunicationRequestStatusEnumFactory
    implements EnumFactory<CommunicationRequestStatus> {
        @Override
        public CommunicationRequestStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return CommunicationRequestStatus.PROPOSED;
            }
            if ("planned".equals(codeString)) {
                return CommunicationRequestStatus.PLANNED;
            }
            if (CommunicationRequest.SP_REQUESTED.equals(codeString)) {
                return CommunicationRequestStatus.REQUESTED;
            }
            if ("received".equals(codeString)) {
                return CommunicationRequestStatus.RECEIVED;
            }
            if ("accepted".equals(codeString)) {
                return CommunicationRequestStatus.ACCEPTED;
            }
            if ("in-progress".equals(codeString)) {
                return CommunicationRequestStatus.INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return CommunicationRequestStatus.COMPLETED;
            }
            if ("suspended".equals(codeString)) {
                return CommunicationRequestStatus.SUSPENDED;
            }
            if ("rejected".equals(codeString)) {
                return CommunicationRequestStatus.REJECTED;
            }
            if ("failed".equals(codeString)) {
                return CommunicationRequestStatus.FAILED;
            }
            throw new IllegalArgumentException("Unknown CommunicationRequestStatus code '" + codeString + "'");
        }

        public Enumeration<CommunicationRequestStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return new Enumeration<CommunicationRequestStatus>(this, CommunicationRequestStatus.PROPOSED);
            }
            if ("planned".equals(codeString)) {
                return new Enumeration<CommunicationRequestStatus>(this, CommunicationRequestStatus.PLANNED);
            }
            if (CommunicationRequest.SP_REQUESTED.equals(codeString)) {
                return new Enumeration<CommunicationRequestStatus>(this, CommunicationRequestStatus.REQUESTED);
            }
            if ("received".equals(codeString)) {
                return new Enumeration<CommunicationRequestStatus>(this, CommunicationRequestStatus.RECEIVED);
            }
            if ("accepted".equals(codeString)) {
                return new Enumeration<CommunicationRequestStatus>(this, CommunicationRequestStatus.ACCEPTED);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<CommunicationRequestStatus>(this, CommunicationRequestStatus.INPROGRESS);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<CommunicationRequestStatus>(this, CommunicationRequestStatus.COMPLETED);
            }
            if ("suspended".equals(codeString)) {
                return new Enumeration<CommunicationRequestStatus>(this, CommunicationRequestStatus.SUSPENDED);
            }
            if ("rejected".equals(codeString)) {
                return new Enumeration<CommunicationRequestStatus>(this, CommunicationRequestStatus.REJECTED);
            }
            if ("failed".equals(codeString)) {
                return new Enumeration<CommunicationRequestStatus>(this, CommunicationRequestStatus.FAILED);
            }
            throw new FHIRException("Unknown CommunicationRequestStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(CommunicationRequestStatus code) {
            if (code == CommunicationRequestStatus.PROPOSED) {
                return "proposed";
            }
            if (code == CommunicationRequestStatus.PLANNED) {
                return "planned";
            }
            if (code == CommunicationRequestStatus.REQUESTED) {
                return CommunicationRequest.SP_REQUESTED;
            }
            if (code == CommunicationRequestStatus.RECEIVED) {
                return "received";
            }
            if (code == CommunicationRequestStatus.ACCEPTED) {
                return "accepted";
            }
            if (code == CommunicationRequestStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == CommunicationRequestStatus.COMPLETED) {
                return "completed";
            }
            if (code == CommunicationRequestStatus.SUSPENDED) {
                return "suspended";
            }
            if (code == CommunicationRequestStatus.REJECTED) {
                return "rejected";
            }
            if (code == CommunicationRequestStatus.FAILED) {
                return "failed";
            }
            return "?";
        }

        @Override
        public String toSystem(CommunicationRequestStatus code) {
            return code.getSystem();
        }
    }

    public static enum CommunicationRequestStatus {
        PROPOSED,
        PLANNED,
        REQUESTED,
        RECEIVED,
        ACCEPTED,
        INPROGRESS,
        COMPLETED,
        SUSPENDED,
        REJECTED,
        FAILED,
        NULL;


        public static CommunicationRequestStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return PROPOSED;
            }
            if ("planned".equals(codeString)) {
                return PLANNED;
            }
            if (CommunicationRequest.SP_REQUESTED.equals(codeString)) {
                return REQUESTED;
            }
            if ("received".equals(codeString)) {
                return RECEIVED;
            }
            if ("accepted".equals(codeString)) {
                return ACCEPTED;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("suspended".equals(codeString)) {
                return SUSPENDED;
            }
            if ("rejected".equals(codeString)) {
                return REJECTED;
            }
            if ("failed".equals(codeString)) {
                return FAILED;
            }
            throw new FHIRException("Unknown CommunicationRequestStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROPOSED: {
                    return "proposed";
                }
                case PLANNED: {
                    return "planned";
                }
                case REQUESTED: {
                    return CommunicationRequest.SP_REQUESTED;
                }
                case RECEIVED: {
                    return "received";
                }
                case ACCEPTED: {
                    return "accepted";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case COMPLETED: {
                    return "completed";
                }
                case SUSPENDED: {
                    return "suspended";
                }
                case REJECTED: {
                    return "rejected";
                }
                case FAILED: {
                    return "failed";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROPOSED: {
                    return "http://hl7.org/fhir/communication-request-status";
                }
                case PLANNED: {
                    return "http://hl7.org/fhir/communication-request-status";
                }
                case REQUESTED: {
                    return "http://hl7.org/fhir/communication-request-status";
                }
                case RECEIVED: {
                    return "http://hl7.org/fhir/communication-request-status";
                }
                case ACCEPTED: {
                    return "http://hl7.org/fhir/communication-request-status";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/communication-request-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/communication-request-status";
                }
                case SUSPENDED: {
                    return "http://hl7.org/fhir/communication-request-status";
                }
                case REJECTED: {
                    return "http://hl7.org/fhir/communication-request-status";
                }
                case FAILED: {
                    return "http://hl7.org/fhir/communication-request-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROPOSED: {
                    return "The request has been proposed.";
                }
                case PLANNED: {
                    return "The request has been planned.";
                }
                case REQUESTED: {
                    return "The request has been placed.";
                }
                case RECEIVED: {
                    return "The receiving system has received the request but not yet decided whether it will be performed.";
                }
                case ACCEPTED: {
                    return "The receiving system has accepted the order, but work has not yet commenced.";
                }
                case INPROGRESS: {
                    return "The work to fulfill the order is happening.";
                }
                case COMPLETED: {
                    return "The work has been complete, the report(s) released, and no further work is planned.";
                }
                case SUSPENDED: {
                    return "The request has been held by originating system/user request.";
                }
                case REJECTED: {
                    return "The receiving system has declined to fulfill the request";
                }
                case FAILED: {
                    return "The communication was attempted, but due to some procedural error, it could not be completed.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROPOSED: {
                    return "Proposed";
                }
                case PLANNED: {
                    return "Planned";
                }
                case REQUESTED: {
                    return "Requested";
                }
                case RECEIVED: {
                    return "Received";
                }
                case ACCEPTED: {
                    return "Accepted";
                }
                case INPROGRESS: {
                    return "In Progress";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case SUSPENDED: {
                    return "Suspended";
                }
                case REJECTED: {
                    return "Rejected";
                }
                case FAILED: {
                    return "Failed";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

