/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.metamodel;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Map;
import org.hl7.fhir.dstu2016may.formats.IParser;
import org.hl7.fhir.dstu2016may.metamodel.Element;
import org.hl7.fhir.dstu2016may.metamodel.Manager;
import org.hl7.fhir.dstu2016may.utils.SimpleWorkerContext;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;

public class Tester {
    private static JsonParser parser = new JsonParser();

    public static void main(String[] args) throws Exception {
        SimpleWorkerContext context = SimpleWorkerContext.fromPack(Utilities.path((String[])new String[]{"C:\\work\\org.hl7.fhir\\build\\publish", "validation-min.xml.zip"}));
        int t = 0;
        int ok = 0;
        for (String f : ManagedFileAccess.file((String)"C:\\work\\org.hl7.fhir\\build\\publish").list()) {
            if (!f.endsWith(".xml") || f.endsWith(".canonical.xml") || f.contains("profile") || f.contains("questionnaire") || !ManagedFileAccess.file((String)("C:\\work\\org.hl7.fhir\\build\\publish\\" + Utilities.changeFileExt((String)f, (String)".ttl"))).exists()) continue;
            System.out.print("convert " + f);
            Element e = Manager.parse(context, ManagedFileAccess.inStream((String)("C:\\work\\org.hl7.fhir\\build\\publish\\" + f)), Manager.FhirFormat.XML);
            Manager.compose(context, e, ManagedFileAccess.outStream((String)("C:\\work\\org.hl7.fhir\\build\\publish\\" + Utilities.changeFileExt((String)f, (String)".mm.ttl"))), Manager.FhirFormat.TURTLE, IParser.OutputStyle.PRETTY, null);
            Manager.compose(context, e, ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{"[tmp]", "resource.xml"})), Manager.FhirFormat.XML, IParser.OutputStyle.PRETTY, null);
            String src = TextFile.fileToString((String)("C:\\work\\org.hl7.fhir\\build\\publish\\" + Utilities.changeFileExt((String)f, (String)".mm.ttl")));
            String tgt = TextFile.fileToString((String)("C:\\work\\org.hl7.fhir\\build\\publish\\" + Utilities.changeFileExt((String)f, (String)".ttl")));
            ++t;
            if (src.equals(tgt)) {
                System.out.println(".. ok");
                ++ok;
                continue;
            }
            System.out.println(".. fail");
        }
        System.out.println("done - " + Integer.toString(t) + " files, " + Integer.toString(ok) + " ok");
    }

    private static String normalise(String s) {
        JsonObject json = parser.parse(s).getAsJsonObject();
        JsonElement txt = json.get("text");
        if (txt != null && ((JsonObject)txt).has("div")) {
            ((JsonObject)txt).remove("div");
        }
        Tester.removeComments(json);
        return json.toString();
    }

    private static void removeComments(JsonArray arr) {
        for (JsonElement i : arr) {
            if (i instanceof JsonObject) {
                Tester.removeComments((JsonObject)i);
            }
            if (!(i instanceof JsonArray)) continue;
            Tester.removeComments((JsonArray)i);
        }
    }

    private static void removeComments(JsonObject json) {
        if (json.has("fhir_comments")) {
            json.remove("fhir_comments");
        }
        for (Map.Entry p : json.entrySet()) {
            if (p.getValue() instanceof JsonObject) {
                Tester.removeComments((JsonObject)p.getValue());
            }
            if (!(p.getValue() instanceof JsonArray)) continue;
            Tester.removeComments((JsonArray)p.getValue());
        }
    }
}

