package org.hl7.fhir.dstu2016may.model.codesystems;

/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, 
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this 
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, 
     this list of conditions and the following disclaimer in the documentation 
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
  
*/

// Generated on Sun, May 8, 2016 03:05+1000 for FHIR v1.4.0

import org.hl7.fhir.exceptions.FHIRException;

public enum HspcAllergyIntoleranceStatus {

  /**
   * Indication that a symptom or condition is subsided or healed.
   */
  _1797,
  /**
   * The state of being mistaken.
   */
  _69074,
  /**
   * The state of not likely being true.
   */
  _31119,
  /**
   * added to help the parsers
   */
  NULL;

  public static HspcAllergyIntoleranceStatus fromCode(String codeString) throws FHIRException {
    if (codeString == null || "".equals(codeString))
      return null;
    if ("1797".equals(codeString))
      return _1797;
    if ("69074".equals(codeString))
      return _69074;
    if ("31119".equals(codeString))
      return _31119;
    throw new FHIRException("Unknown HspcAllergyIntoleranceStatus code '" + codeString + "'");
  }

  public String toCode() {
    switch (this) {
    case _1797:
      return "1797";
    case _69074:
      return "69074";
    case _31119:
      return "31119";
    case NULL:
      return null;
    default:
      return "?";
    }
  }

  public String getSystem() {
    return "http://hl7.org/fhir/hspc-allergyintolerancestatus";
  }

  public String getDefinition() {
    switch (this) {
    case _1797:
      return "Indication that a symptom or condition is subsided or healed.";
    case _69074:
      return "The state of being mistaken.";
    case _31119:
      return "The state of not likely being true.";
    case NULL:
      return null;
    default:
      return "?";
    }
  }

  public String getDisplay() {
    switch (this) {
    case _1797:
      return "Resolved";
    case _69074:
      return "Error";
    case _31119:
      return "Unlikely";
    case NULL:
      return null;
    default:
      return "?";
    }
  }

}