/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu2016may.formats.JsonParser;
import org.hl7.fhir.dstu2016may.model.Bundle;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.Utilities;

public class Unbundler {
    public static void main(String[] args) throws Exception {
        Unbundler.unbundle(args[0]);
    }

    private static void unbundle(String src) throws FHIRFormatError, FileNotFoundException, IOException {
        String folder = Utilities.getDirectoryForFile((String)src);
        Bundle bnd = (Bundle)new JsonParser().parse(new FileInputStream(src));
        for (Bundle.BundleEntryComponent be : bnd.getEntry()) {
            Resource r = be.getResource();
            if (r == null) continue;
            if (StringUtils.isBlank((CharSequence)r.getId()) && r instanceof ValueSet) {
                r.setId(Unbundler.tail((ValueSet)r));
            }
            if (StringUtils.isBlank((CharSequence)r.getId())) continue;
            String tgt = Utilities.path((String[])new String[]{folder, r.fhirType() + "-" + r.getId() + ".json"});
            new JsonParser().compose(new FileOutputStream(tgt), r);
        }
    }

    private static String tail(ValueSet r) {
        return r.getUrl().contains("/") ? r.getUrl().substring(r.getUrl().lastIndexOf("/") + 1) : null;
    }
}

