/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CdsRuleParticipant {
    PATIENT,
    PERSON,
    PRACTITIONER,
    RELATEDPERSON,
    NULL;


    public static CdsRuleParticipant fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("patient".equals(codeString)) {
            return PATIENT;
        }
        if ("person".equals(codeString)) {
            return PERSON;
        }
        if ("practitioner".equals(codeString)) {
            return PRACTITIONER;
        }
        if ("related-person".equals(codeString)) {
            return RELATEDPERSON;
        }
        throw new FHIRException("Unknown CdsRuleParticipant code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PATIENT: {
                return "patient";
            }
            case PERSON: {
                return "person";
            }
            case PRACTITIONER: {
                return "practitioner";
            }
            case RELATEDPERSON: {
                return "related-person";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/cds-rule-participant";
    }

    public String getDefinition() {
        switch (this) {
            case PATIENT: {
                return "The participant is the patient under evaluation";
            }
            case PERSON: {
                return "The participant is a person";
            }
            case PRACTITIONER: {
                return "The participant is a practitioner involved in the patient's care";
            }
            case RELATEDPERSON: {
                return "The participant is a person related to the patient";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PATIENT: {
                return "Patient";
            }
            case PERSON: {
                return "Person";
            }
            case PRACTITIONER: {
                return "Practitioner";
            }
            case RELATEDPERSON: {
                return "Related Person";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

