/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.AllergyIntolerance;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Encounter;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Ratio;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.SimpleQuantity;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Timing;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="NutritionOrder", profile="http://hl7.org/fhir/Profile/NutritionOrder")
public class NutritionOrder
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Identifiers assigned to this order", formalDefinition="Identifiers assigned to this order by the order sender or by the order receiver.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="proposed | draft | planned | requested | active | on-hold | completed | cancelled | entered-in-error", formalDefinition="The workflow status of the nutrition order/request.")
    protected Enumeration<NutritionOrderStatus> status;
    @Child(name="patient", type={Patient.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The person who requires the diet, formula or nutritional supplement", formalDefinition="The person (patient) who needs the nutrition order for an oral diet, nutritional supplement and/or enteral or formula feeding.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="encounter", type={Encounter.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The encounter associated with this nutrition order", formalDefinition="An encounter that provides additional information about the healthcare context in which this request is made.")
    protected Reference encounter;
    protected Encounter encounterTarget;
    @Child(name="dateTime", type={DateTimeType.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date and time the nutrition order was requested", formalDefinition="The date and time that this nutrition order was requested.")
    protected DateTimeType dateTime;
    @Child(name="orderer", type={Practitioner.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who ordered the diet, formula or nutritional supplement", formalDefinition="The practitioner that holds legal responsibility for ordering the diet, nutritional supplement, or formula feedings.")
    protected Reference orderer;
    protected Practitioner ordererTarget;
    @Child(name="allergyIntolerance", type={AllergyIntolerance.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="List of the patient's food and nutrition-related allergies and intolerances", formalDefinition="A link to a record of allergies or intolerances  which should be included in the nutrition order.")
    protected List<Reference> allergyIntolerance;
    protected List<AllergyIntolerance> allergyIntoleranceTarget;
    @Child(name="foodPreferenceModifier", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Order-specific modifier about the type of food that should be given", formalDefinition="This modifier is used to convey order-specific modifiers about the type of food that should be given. These can be derived from patient allergies, intolerances, or preferences such as Halal, Vegan or Kosher. This modifier applies to the entire nutrition order inclusive of the oral diet, nutritional supplements and enteral formula feedings.")
    protected List<CodeableConcept> foodPreferenceModifier;
    @Child(name="excludeFoodModifier", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Order-specific modifier about the type of food that should not be given", formalDefinition="This modifier is used to convey order-specific modifiers about the type of food that should NOT be given. These can be derived from patient allergies, intolerances, or preferences such as No Red Meat, No Soy or No Wheat or  Gluten-Free.  While it should not be necessary to repeat allergy or intolerance information captured in the referenced allergyIntolerance resource in the excludeFoodModifier, this element may be used to convey additional specificity related to foods that should be eliminated from the patient\u2019s diet for any reason.  This modifier applies to the entire nutrition order inclusive of the oral diet, nutritional supplements and enteral formula feedings.")
    protected List<CodeableConcept> excludeFoodModifier;
    @Child(name="oralDiet", type={}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Oral diet components", formalDefinition="Diet given orally in contrast to enteral (tube) feeding.")
    protected NutritionOrderOralDietComponent oralDiet;
    @Child(name="supplement", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Supplement components", formalDefinition="Oral nutritional products given in order to add further nutritional value to the patient's diet.")
    protected List<NutritionOrderSupplementComponent> supplement;
    @Child(name="enteralFormula", type={}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Enteral formula components", formalDefinition="Feeding provided through the gastrointestinal tract via a tube, catheter, or stoma that delivers nutrition distal to the oral cavity.")
    protected NutritionOrderEnteralFormulaComponent enteralFormula;
    private static final long serialVersionUID = 1429947433L;
    @SearchParamDefinition(name="patient", path="NutritionOrder.patient", description="The identity of the person who requires the diet, formula or nutritional supplement", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("NutritionOrder:patient").toLocked();
    @SearchParamDefinition(name="status", path="NutritionOrder.status", description="Status of the nutrition order.", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="supplement", path="NutritionOrder.supplement.type", description="Type of supplement product requested", type="token")
    public static final String SP_SUPPLEMENT = "supplement";
    public static final TokenClientParam SUPPLEMENT = new TokenClientParam("supplement");
    @SearchParamDefinition(name="oraldiet", path="NutritionOrder.oralDiet.type", description="Type of diet that can be consumed orally (i.e., take via the mouth).", type="token")
    public static final String SP_ORALDIET = "oraldiet";
    public static final TokenClientParam ORALDIET = new TokenClientParam("oraldiet");
    @SearchParamDefinition(name="provider", path="NutritionOrder.orderer", description="The identify of the provider who placed the nutrition order", type="reference")
    public static final String SP_PROVIDER = "provider";
    public static final ReferenceClientParam PROVIDER = new ReferenceClientParam("provider");
    public static final Include INCLUDE_PROVIDER = new Include("NutritionOrder:provider").toLocked();
    @SearchParamDefinition(name="encounter", path="NutritionOrder.encounter", description="Return nutrition orders with this encounter identifier", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("NutritionOrder:encounter").toLocked();
    @SearchParamDefinition(name="datetime", path="NutritionOrder.dateTime", description="Return nutrition orders requested on this date", type="date")
    public static final String SP_DATETIME = "datetime";
    public static final DateClientParam DATETIME = new DateClientParam("datetime");
    @SearchParamDefinition(name="additive", path="NutritionOrder.enteralFormula.additiveType", description="Type of module component to add to the feeding", type="token")
    public static final String SP_ADDITIVE = "additive";
    public static final TokenClientParam ADDITIVE = new TokenClientParam("additive");
    @SearchParamDefinition(name="identifier", path="NutritionOrder.identifier", description="Return nutrition orders with this external identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="formula", path="NutritionOrder.enteralFormula.baseFormulaType", description="Type of enteral or infant formula", type="token")
    public static final String SP_FORMULA = "formula";
    public static final TokenClientParam FORMULA = new TokenClientParam("formula");

    public NutritionOrder() {
    }

    public NutritionOrder(Reference patient, DateTimeType dateTime) {
        this.patient = patient;
        this.dateTime = dateTime;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public NutritionOrder addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Enumeration<NutritionOrderStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionOrder.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<NutritionOrderStatus>(new NutritionOrderStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public NutritionOrder setStatusElement(Enumeration<NutritionOrderStatus> value) {
        this.status = value;
        return this;
    }

    public NutritionOrderStatus getStatus() {
        return this.status == null ? null : (NutritionOrderStatus)((Object)this.status.getValue());
    }

    public NutritionOrder setStatus(NutritionOrderStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<NutritionOrderStatus>(new NutritionOrderStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionOrder.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public NutritionOrder setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionOrder.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public NutritionOrder setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionOrder.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public NutritionOrder setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Encounter getEncounterTarget() {
        if (this.encounterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionOrder.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterTarget = new Encounter();
            }
        }
        return this.encounterTarget;
    }

    public NutritionOrder setEncounterTarget(Encounter value) {
        this.encounterTarget = value;
        return this;
    }

    public DateTimeType getDateTimeElement() {
        if (this.dateTime == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionOrder.dateTime");
            }
            if (Configuration.doAutoCreate()) {
                this.dateTime = new DateTimeType();
            }
        }
        return this.dateTime;
    }

    public boolean hasDateTimeElement() {
        return this.dateTime != null && !this.dateTime.isEmpty();
    }

    public boolean hasDateTime() {
        return this.dateTime != null && !this.dateTime.isEmpty();
    }

    public NutritionOrder setDateTimeElement(DateTimeType value) {
        this.dateTime = value;
        return this;
    }

    public Date getDateTime() {
        return this.dateTime == null ? null : (Date)this.dateTime.getValue();
    }

    public NutritionOrder setDateTime(Date value) {
        if (this.dateTime == null) {
            this.dateTime = new DateTimeType();
        }
        this.dateTime.setValue(value);
        return this;
    }

    public Reference getOrderer() {
        if (this.orderer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionOrder.orderer");
            }
            if (Configuration.doAutoCreate()) {
                this.orderer = new Reference();
            }
        }
        return this.orderer;
    }

    public boolean hasOrderer() {
        return this.orderer != null && !this.orderer.isEmpty();
    }

    public NutritionOrder setOrderer(Reference value) {
        this.orderer = value;
        return this;
    }

    public Practitioner getOrdererTarget() {
        if (this.ordererTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionOrder.orderer");
            }
            if (Configuration.doAutoCreate()) {
                this.ordererTarget = new Practitioner();
            }
        }
        return this.ordererTarget;
    }

    public NutritionOrder setOrdererTarget(Practitioner value) {
        this.ordererTarget = value;
        return this;
    }

    public List<Reference> getAllergyIntolerance() {
        if (this.allergyIntolerance == null) {
            this.allergyIntolerance = new ArrayList<Reference>();
        }
        return this.allergyIntolerance;
    }

    public boolean hasAllergyIntolerance() {
        if (this.allergyIntolerance == null) {
            return false;
        }
        for (Reference item : this.allergyIntolerance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAllergyIntolerance() {
        Reference t = new Reference();
        if (this.allergyIntolerance == null) {
            this.allergyIntolerance = new ArrayList<Reference>();
        }
        this.allergyIntolerance.add(t);
        return t;
    }

    public NutritionOrder addAllergyIntolerance(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.allergyIntolerance == null) {
            this.allergyIntolerance = new ArrayList<Reference>();
        }
        this.allergyIntolerance.add(t);
        return this;
    }

    public List<AllergyIntolerance> getAllergyIntoleranceTarget() {
        if (this.allergyIntoleranceTarget == null) {
            this.allergyIntoleranceTarget = new ArrayList<AllergyIntolerance>();
        }
        return this.allergyIntoleranceTarget;
    }

    public AllergyIntolerance addAllergyIntoleranceTarget() {
        AllergyIntolerance r = new AllergyIntolerance();
        if (this.allergyIntoleranceTarget == null) {
            this.allergyIntoleranceTarget = new ArrayList<AllergyIntolerance>();
        }
        this.allergyIntoleranceTarget.add(r);
        return r;
    }

    public List<CodeableConcept> getFoodPreferenceModifier() {
        if (this.foodPreferenceModifier == null) {
            this.foodPreferenceModifier = new ArrayList<CodeableConcept>();
        }
        return this.foodPreferenceModifier;
    }

    public boolean hasFoodPreferenceModifier() {
        if (this.foodPreferenceModifier == null) {
            return false;
        }
        for (CodeableConcept item : this.foodPreferenceModifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addFoodPreferenceModifier() {
        CodeableConcept t = new CodeableConcept();
        if (this.foodPreferenceModifier == null) {
            this.foodPreferenceModifier = new ArrayList<CodeableConcept>();
        }
        this.foodPreferenceModifier.add(t);
        return t;
    }

    public NutritionOrder addFoodPreferenceModifier(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.foodPreferenceModifier == null) {
            this.foodPreferenceModifier = new ArrayList<CodeableConcept>();
        }
        this.foodPreferenceModifier.add(t);
        return this;
    }

    public List<CodeableConcept> getExcludeFoodModifier() {
        if (this.excludeFoodModifier == null) {
            this.excludeFoodModifier = new ArrayList<CodeableConcept>();
        }
        return this.excludeFoodModifier;
    }

    public boolean hasExcludeFoodModifier() {
        if (this.excludeFoodModifier == null) {
            return false;
        }
        for (CodeableConcept item : this.excludeFoodModifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addExcludeFoodModifier() {
        CodeableConcept t = new CodeableConcept();
        if (this.excludeFoodModifier == null) {
            this.excludeFoodModifier = new ArrayList<CodeableConcept>();
        }
        this.excludeFoodModifier.add(t);
        return t;
    }

    public NutritionOrder addExcludeFoodModifier(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.excludeFoodModifier == null) {
            this.excludeFoodModifier = new ArrayList<CodeableConcept>();
        }
        this.excludeFoodModifier.add(t);
        return this;
    }

    public NutritionOrderOralDietComponent getOralDiet() {
        if (this.oralDiet == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionOrder.oralDiet");
            }
            if (Configuration.doAutoCreate()) {
                this.oralDiet = new NutritionOrderOralDietComponent();
            }
        }
        return this.oralDiet;
    }

    public boolean hasOralDiet() {
        return this.oralDiet != null && !this.oralDiet.isEmpty();
    }

    public NutritionOrder setOralDiet(NutritionOrderOralDietComponent value) {
        this.oralDiet = value;
        return this;
    }

    public List<NutritionOrderSupplementComponent> getSupplement() {
        if (this.supplement == null) {
            this.supplement = new ArrayList<NutritionOrderSupplementComponent>();
        }
        return this.supplement;
    }

    public boolean hasSupplement() {
        if (this.supplement == null) {
            return false;
        }
        for (NutritionOrderSupplementComponent item : this.supplement) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public NutritionOrderSupplementComponent addSupplement() {
        NutritionOrderSupplementComponent t = new NutritionOrderSupplementComponent();
        if (this.supplement == null) {
            this.supplement = new ArrayList<NutritionOrderSupplementComponent>();
        }
        this.supplement.add(t);
        return t;
    }

    public NutritionOrder addSupplement(NutritionOrderSupplementComponent t) {
        if (t == null) {
            return this;
        }
        if (this.supplement == null) {
            this.supplement = new ArrayList<NutritionOrderSupplementComponent>();
        }
        this.supplement.add(t);
        return this;
    }

    public NutritionOrderEnteralFormulaComponent getEnteralFormula() {
        if (this.enteralFormula == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create NutritionOrder.enteralFormula");
            }
            if (Configuration.doAutoCreate()) {
                this.enteralFormula = new NutritionOrderEnteralFormulaComponent();
            }
        }
        return this.enteralFormula;
    }

    public boolean hasEnteralFormula() {
        return this.enteralFormula != null && !this.enteralFormula.isEmpty();
    }

    public NutritionOrder setEnteralFormula(NutritionOrderEnteralFormulaComponent value) {
        this.enteralFormula = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this order by the order sender or by the order receiver.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_STATUS, "code", "The workflow status of the nutrition order/request.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "The person (patient) who needs the nutrition order for an oral diet, nutritional supplement and/or enteral or formula feeding.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "An encounter that provides additional information about the healthcare context in which this request is made.", 0, Integer.MAX_VALUE, this.encounter));
        childrenList.add(new Property("dateTime", "dateTime", "The date and time that this nutrition order was requested.", 0, Integer.MAX_VALUE, this.dateTime));
        childrenList.add(new Property("orderer", "Reference(Practitioner)", "The practitioner that holds legal responsibility for ordering the diet, nutritional supplement, or formula feedings.", 0, Integer.MAX_VALUE, this.orderer));
        childrenList.add(new Property("allergyIntolerance", "Reference(AllergyIntolerance)", "A link to a record of allergies or intolerances  which should be included in the nutrition order.", 0, Integer.MAX_VALUE, this.allergyIntolerance));
        childrenList.add(new Property("foodPreferenceModifier", "CodeableConcept", "This modifier is used to convey order-specific modifiers about the type of food that should be given. These can be derived from patient allergies, intolerances, or preferences such as Halal, Vegan or Kosher. This modifier applies to the entire nutrition order inclusive of the oral diet, nutritional supplements and enteral formula feedings.", 0, Integer.MAX_VALUE, this.foodPreferenceModifier));
        childrenList.add(new Property("excludeFoodModifier", "CodeableConcept", "This modifier is used to convey order-specific modifiers about the type of food that should NOT be given. These can be derived from patient allergies, intolerances, or preferences such as No Red Meat, No Soy or No Wheat or  Gluten-Free.  While it should not be necessary to repeat allergy or intolerance information captured in the referenced allergyIntolerance resource in the excludeFoodModifier, this element may be used to convey additional specificity related to foods that should be eliminated from the patient\u2019s diet for any reason.  This modifier applies to the entire nutrition order inclusive of the oral diet, nutritional supplements and enteral formula feedings.", 0, Integer.MAX_VALUE, this.excludeFoodModifier));
        childrenList.add(new Property("oralDiet", "", "Diet given orally in contrast to enteral (tube) feeding.", 0, Integer.MAX_VALUE, this.oralDiet));
        childrenList.add(new Property(SP_SUPPLEMENT, "", "Oral nutritional products given in order to add further nutritional value to the patient's diet.", 0, Integer.MAX_VALUE, this.supplement));
        childrenList.add(new Property("enteralFormula", "", "Feeding provided through the gastrointestinal tract via a tube, catheter, or stoma that delivers nutrition distal to the oral cavity.", 0, Integer.MAX_VALUE, this.enteralFormula));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.patient;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.encounter;
                }
                return baseArray;
            }
            case 1792749467: {
                Base[] baseArray;
                if (this.dateTime == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.dateTime;
                }
                return baseArray;
            }
            case -1207109509: {
                Base[] baseArray;
                if (this.orderer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.orderer;
                }
                return baseArray;
            }
            case -120164120: {
                return this.allergyIntolerance == null ? new Base[]{} : this.allergyIntolerance.toArray(new Base[this.allergyIntolerance.size()]);
            }
            case 659473872: {
                return this.foodPreferenceModifier == null ? new Base[]{} : this.foodPreferenceModifier.toArray(new Base[this.foodPreferenceModifier.size()]);
            }
            case 1760260175: {
                return this.excludeFoodModifier == null ? new Base[]{} : this.excludeFoodModifier.toArray(new Base[this.excludeFoodModifier.size()]);
            }
            case 1153521250: {
                Base[] baseArray;
                if (this.oralDiet == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.oralDiet;
                }
                return baseArray;
            }
            case -711993159: {
                return this.supplement == null ? new Base[]{} : this.supplement.toArray(new Base[this.supplement.size()]);
            }
            case -671083805: {
                Base[] baseArray;
                if (this.enteralFormula == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.enteralFormula;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case -892481550: {
                this.status = new NutritionOrderStatusEnumFactory().fromType(value);
                break;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                break;
            }
            case 1524132147: {
                this.encounter = this.castToReference(value);
                break;
            }
            case 1792749467: {
                this.dateTime = this.castToDateTime(value);
                break;
            }
            case -1207109509: {
                this.orderer = this.castToReference(value);
                break;
            }
            case -120164120: {
                this.getAllergyIntolerance().add(this.castToReference(value));
                break;
            }
            case 659473872: {
                this.getFoodPreferenceModifier().add(this.castToCodeableConcept(value));
                break;
            }
            case 1760260175: {
                this.getExcludeFoodModifier().add(this.castToCodeableConcept(value));
                break;
            }
            case 1153521250: {
                this.oralDiet = (NutritionOrderOralDietComponent)value;
                break;
            }
            case -711993159: {
                this.getSupplement().add((NutritionOrderSupplementComponent)value);
                break;
            }
            case -671083805: {
                this.enteralFormula = (NutritionOrderEnteralFormulaComponent)value;
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = new NutritionOrderStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = this.castToReference(value);
        } else if (name.equals("dateTime")) {
            this.dateTime = this.castToDateTime(value);
        } else if (name.equals("orderer")) {
            this.orderer = this.castToReference(value);
        } else if (name.equals("allergyIntolerance")) {
            this.getAllergyIntolerance().add(this.castToReference(value));
        } else if (name.equals("foodPreferenceModifier")) {
            this.getFoodPreferenceModifier().add(this.castToCodeableConcept(value));
        } else if (name.equals("excludeFoodModifier")) {
            this.getExcludeFoodModifier().add(this.castToCodeableConcept(value));
        } else if (name.equals("oralDiet")) {
            this.oralDiet = (NutritionOrderOralDietComponent)value;
        } else if (name.equals(SP_SUPPLEMENT)) {
            this.getSupplement().add((NutritionOrderSupplementComponent)value);
        } else if (name.equals("enteralFormula")) {
            this.enteralFormula = (NutritionOrderEnteralFormulaComponent)value;
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case -791418107: {
                return this.getPatient();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case 1792749467: {
                throw new FHIRException("Cannot make property dateTime as it is not a complex type");
            }
            case -1207109509: {
                return this.getOrderer();
            }
            case -120164120: {
                return this.addAllergyIntolerance();
            }
            case 659473872: {
                return this.addFoodPreferenceModifier();
            }
            case 1760260175: {
                return this.addExcludeFoodModifier();
            }
            case 1153521250: {
                return this.getOralDiet();
            }
            case -711993159: {
                return this.addSupplement();
            }
            case -671083805: {
                return this.getEnteralFormula();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property NutritionOrder.status");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("dateTime")) {
            throw new FHIRException("Cannot call addChild on a singleton property NutritionOrder.dateTime");
        }
        if (name.equals("orderer")) {
            this.orderer = new Reference();
            return this.orderer;
        }
        if (name.equals("allergyIntolerance")) {
            return this.addAllergyIntolerance();
        }
        if (name.equals("foodPreferenceModifier")) {
            return this.addFoodPreferenceModifier();
        }
        if (name.equals("excludeFoodModifier")) {
            return this.addExcludeFoodModifier();
        }
        if (name.equals("oralDiet")) {
            this.oralDiet = new NutritionOrderOralDietComponent();
            return this.oralDiet;
        }
        if (name.equals(SP_SUPPLEMENT)) {
            return this.addSupplement();
        }
        if (name.equals("enteralFormula")) {
            this.enteralFormula = new NutritionOrderEnteralFormulaComponent();
            return this.enteralFormula;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "NutritionOrder";
    }

    @Override
    public NutritionOrder copy() {
        NutritionOrder dst = new NutritionOrder();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.dateTime = this.dateTime == null ? null : this.dateTime.copy();
        Reference reference = dst.orderer = this.orderer == null ? null : this.orderer.copy();
        if (this.allergyIntolerance != null) {
            dst.allergyIntolerance = new ArrayList<Reference>();
            for (Reference reference2 : this.allergyIntolerance) {
                dst.allergyIntolerance.add(reference2.copy());
            }
        }
        if (this.foodPreferenceModifier != null) {
            dst.foodPreferenceModifier = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.foodPreferenceModifier) {
                dst.foodPreferenceModifier.add(codeableConcept.copy());
            }
        }
        if (this.excludeFoodModifier != null) {
            dst.excludeFoodModifier = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.excludeFoodModifier) {
                dst.excludeFoodModifier.add(codeableConcept.copy());
            }
        }
        NutritionOrderOralDietComponent nutritionOrderOralDietComponent = dst.oralDiet = this.oralDiet == null ? null : this.oralDiet.copy();
        if (this.supplement != null) {
            dst.supplement = new ArrayList<NutritionOrderSupplementComponent>();
            for (NutritionOrderSupplementComponent nutritionOrderSupplementComponent : this.supplement) {
                dst.supplement.add(nutritionOrderSupplementComponent.copy());
            }
        }
        dst.enteralFormula = this.enteralFormula == null ? null : this.enteralFormula.copy();
        return dst;
    }

    protected NutritionOrder typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof NutritionOrder)) {
            return false;
        }
        NutritionOrder o = (NutritionOrder)other;
        return NutritionOrder.compareDeep(this.identifier, o.identifier, true) && NutritionOrder.compareDeep(this.status, o.status, true) && NutritionOrder.compareDeep(this.patient, o.patient, true) && NutritionOrder.compareDeep(this.encounter, o.encounter, true) && NutritionOrder.compareDeep(this.dateTime, o.dateTime, true) && NutritionOrder.compareDeep(this.orderer, o.orderer, true) && NutritionOrder.compareDeep(this.allergyIntolerance, o.allergyIntolerance, true) && NutritionOrder.compareDeep(this.foodPreferenceModifier, o.foodPreferenceModifier, true) && NutritionOrder.compareDeep(this.excludeFoodModifier, o.excludeFoodModifier, true) && NutritionOrder.compareDeep(this.oralDiet, o.oralDiet, true) && NutritionOrder.compareDeep(this.supplement, o.supplement, true) && NutritionOrder.compareDeep(this.enteralFormula, o.enteralFormula, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof NutritionOrder)) {
            return false;
        }
        NutritionOrder o = (NutritionOrder)other;
        return NutritionOrder.compareValues(this.status, o.status, true) && NutritionOrder.compareValues(this.dateTime, o.dateTime, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.status != null && !this.status.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.encounter != null && !this.encounter.isEmpty() || this.dateTime != null && !this.dateTime.isEmpty() || this.orderer != null && !this.orderer.isEmpty() || this.allergyIntolerance != null && !this.allergyIntolerance.isEmpty() || this.foodPreferenceModifier != null && !this.foodPreferenceModifier.isEmpty() || this.excludeFoodModifier != null && !this.excludeFoodModifier.isEmpty() || this.oralDiet != null && !this.oralDiet.isEmpty() || this.supplement != null && !this.supplement.isEmpty() || this.enteralFormula != null && !this.enteralFormula.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.NutritionOrder;
    }

    @Block
    public static class NutritionOrderEnteralFormulaAdministrationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="schedule", type={Timing.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Scheduled frequency of enteral feeding", formalDefinition="The time period and frequency at which the enteral formula should be delivered to the patient.")
        protected Timing schedule;
        @Child(name="quantity", type={SimpleQuantity.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The volume of formula to provide", formalDefinition="The volume of formula to provide to the patient per the specified administration schedule.")
        protected SimpleQuantity quantity;
        @Child(name="rate", type={SimpleQuantity.class, Ratio.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Speed with which the formula is provided per period of time", formalDefinition="The rate of administration of formula via a feeding pump, e.g. 60 mL per hour, according to the specified schedule.")
        protected Type rate;
        private static final long serialVersionUID = 1895031997L;

        public Timing getSchedule() {
            if (this.schedule == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderEnteralFormulaAdministrationComponent.schedule");
                }
                if (Configuration.doAutoCreate()) {
                    this.schedule = new Timing();
                }
            }
            return this.schedule;
        }

        public boolean hasSchedule() {
            return this.schedule != null && !this.schedule.isEmpty();
        }

        public NutritionOrderEnteralFormulaAdministrationComponent setSchedule(Timing value) {
            this.schedule = value;
            return this;
        }

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderEnteralFormulaAdministrationComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public NutritionOrderEnteralFormulaAdministrationComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        public Type getRate() {
            return this.rate;
        }

        public SimpleQuantity getRateSimpleQuantity() throws FHIRException {
            if (!(this.rate instanceof SimpleQuantity)) {
                throw new FHIRException("Type mismatch: the type SimpleQuantity was expected, but " + this.rate.getClass().getName() + " was encountered");
            }
            return (SimpleQuantity)this.rate;
        }

        public boolean hasRateSimpleQuantity() {
            return this.rate instanceof SimpleQuantity;
        }

        public Ratio getRateRatio() throws FHIRException {
            if (!(this.rate instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.rate.getClass().getName() + " was encountered");
            }
            return (Ratio)this.rate;
        }

        public boolean hasRateRatio() {
            return this.rate instanceof Ratio;
        }

        public boolean hasRate() {
            return this.rate != null && !this.rate.isEmpty();
        }

        public NutritionOrderEnteralFormulaAdministrationComponent setRate(Type value) {
            this.rate = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("schedule", "Timing", "The time period and frequency at which the enteral formula should be delivered to the patient.", 0, Integer.MAX_VALUE, this.schedule));
            childrenList.add(new Property("quantity", "SimpleQuantity", "The volume of formula to provide to the patient per the specified administration schedule.", 0, Integer.MAX_VALUE, this.quantity));
            childrenList.add(new Property("rate[x]", "SimpleQuantity|Ratio", "The rate of administration of formula via a feeding pump, e.g. 60 mL per hour, according to the specified schedule.", 0, Integer.MAX_VALUE, this.rate));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -697920873: {
                    Base[] baseArray;
                    if (this.schedule == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.schedule;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.quantity;
                    }
                    return baseArray;
                }
                case 3493088: {
                    Base[] baseArray;
                    if (this.rate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.rate;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -697920873: {
                    this.schedule = this.castToTiming(value);
                    break;
                }
                case -1285004149: {
                    this.quantity = this.castToSimpleQuantity(value);
                    break;
                }
                case 3493088: {
                    this.rate = (Type)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("schedule")) {
                this.schedule = this.castToTiming(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToSimpleQuantity(value);
            } else if (name.equals("rate[x]")) {
                this.rate = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -697920873: {
                    return this.getSchedule();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case 983460768: {
                    return this.getRate();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("schedule")) {
                this.schedule = new Timing();
                return this.schedule;
            }
            if (name.equals("quantity")) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            if (name.equals("rateSimpleQuantity")) {
                this.rate = new SimpleQuantity();
                return this.rate;
            }
            if (name.equals("rateRatio")) {
                this.rate = new Ratio();
                return this.rate;
            }
            return super.addChild(name);
        }

        @Override
        public NutritionOrderEnteralFormulaAdministrationComponent copy() {
            NutritionOrderEnteralFormulaAdministrationComponent dst = new NutritionOrderEnteralFormulaAdministrationComponent();
            this.copyValues(dst);
            dst.schedule = this.schedule == null ? null : this.schedule.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.rate = this.rate == null ? null : this.rate.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof NutritionOrderEnteralFormulaAdministrationComponent)) {
                return false;
            }
            NutritionOrderEnteralFormulaAdministrationComponent o = (NutritionOrderEnteralFormulaAdministrationComponent)other;
            return NutritionOrderEnteralFormulaAdministrationComponent.compareDeep(this.schedule, o.schedule, true) && NutritionOrderEnteralFormulaAdministrationComponent.compareDeep(this.quantity, o.quantity, true) && NutritionOrderEnteralFormulaAdministrationComponent.compareDeep(this.rate, o.rate, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof NutritionOrderEnteralFormulaAdministrationComponent)) {
                return false;
            }
            NutritionOrderEnteralFormulaAdministrationComponent o = (NutritionOrderEnteralFormulaAdministrationComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.schedule != null && !this.schedule.isEmpty() || this.quantity != null && !this.quantity.isEmpty() || this.rate != null && !this.rate.isEmpty());
        }

        @Override
        public String fhirType() {
            return "NutritionOrder.enteralFormula.administration";
        }
    }

    @Block
    public static class NutritionOrderEnteralFormulaComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="baseFormulaType", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of enteral or infant formula", formalDefinition="The type of enteral or infant formula such as an adult standard formula with fiber or a soy-based infant formula.")
        protected CodeableConcept baseFormulaType;
        @Child(name="baseFormulaProductName", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Product or brand name of the enteral or infant formula", formalDefinition="The product or brand name of the enteral or infant formula product such as \"ACME Adult Standard Formula\".")
        protected StringType baseFormulaProductName;
        @Child(name="additiveType", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of modular component to add to the feeding", formalDefinition="Indicates the type of modular component such as protein, carbohydrate, fat or fiber to be provided in addition to or mixed with the base formula.")
        protected CodeableConcept additiveType;
        @Child(name="additiveProductName", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Product or brand name of the modular additive", formalDefinition="The product or brand name of the type of modular component to be added to the formula.")
        protected StringType additiveProductName;
        @Child(name="caloricDensity", type={SimpleQuantity.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Amount of energy per specified volume that is required", formalDefinition="The amount of energy (Calories) that the formula should provide per specified volume, typically per mL or fluid oz.  For example, an infant may require a formula that provides 24 Calories per fluid ounce or an adult may require an enteral formula that provides 1.5 Calorie/mL.")
        protected SimpleQuantity caloricDensity;
        @Child(name="routeofAdministration", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How the formula should enter the patient's gastrointestinal tract", formalDefinition="The route or physiological path of administration into the patient's gastrointestinal  tract for purposes of providing the formula feeding, e.g. nasogastric tube.")
        protected CodeableConcept routeofAdministration;
        @Child(name="administration", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Formula feeding instruction as structured data", formalDefinition="Formula administration instructions as structured data.  This repeating structure allows for changing the administration rate or volume over time for both bolus and continuous feeding.  An example of this would be an instruction to increase the rate of continuous feeding every 2 hours.")
        protected List<NutritionOrderEnteralFormulaAdministrationComponent> administration;
        @Child(name="maxVolumeToDeliver", type={SimpleQuantity.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Upper limit on formula volume per unit of time", formalDefinition="The maximum total quantity of formula that may be administered to a subject over the period of time, e.g. 1440 mL over 24 hours.")
        protected SimpleQuantity maxVolumeToDeliver;
        @Child(name="administrationInstruction", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Formula feeding instructions expressed as text", formalDefinition="Free text formula administration, feeding instructions or additional instructions or information.")
        protected StringType administrationInstruction;
        private static final long serialVersionUID = 292116061L;

        public CodeableConcept getBaseFormulaType() {
            if (this.baseFormulaType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderEnteralFormulaComponent.baseFormulaType");
                }
                if (Configuration.doAutoCreate()) {
                    this.baseFormulaType = new CodeableConcept();
                }
            }
            return this.baseFormulaType;
        }

        public boolean hasBaseFormulaType() {
            return this.baseFormulaType != null && !this.baseFormulaType.isEmpty();
        }

        public NutritionOrderEnteralFormulaComponent setBaseFormulaType(CodeableConcept value) {
            this.baseFormulaType = value;
            return this;
        }

        public StringType getBaseFormulaProductNameElement() {
            if (this.baseFormulaProductName == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderEnteralFormulaComponent.baseFormulaProductName");
                }
                if (Configuration.doAutoCreate()) {
                    this.baseFormulaProductName = new StringType();
                }
            }
            return this.baseFormulaProductName;
        }

        public boolean hasBaseFormulaProductNameElement() {
            return this.baseFormulaProductName != null && !this.baseFormulaProductName.isEmpty();
        }

        public boolean hasBaseFormulaProductName() {
            return this.baseFormulaProductName != null && !this.baseFormulaProductName.isEmpty();
        }

        public NutritionOrderEnteralFormulaComponent setBaseFormulaProductNameElement(StringType value) {
            this.baseFormulaProductName = value;
            return this;
        }

        public String getBaseFormulaProductName() {
            return this.baseFormulaProductName == null ? null : (String)this.baseFormulaProductName.getValue();
        }

        public NutritionOrderEnteralFormulaComponent setBaseFormulaProductName(String value) {
            if (Utilities.noString((String)value)) {
                this.baseFormulaProductName = null;
            } else {
                if (this.baseFormulaProductName == null) {
                    this.baseFormulaProductName = new StringType();
                }
                this.baseFormulaProductName.setValue(value);
            }
            return this;
        }

        public CodeableConcept getAdditiveType() {
            if (this.additiveType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderEnteralFormulaComponent.additiveType");
                }
                if (Configuration.doAutoCreate()) {
                    this.additiveType = new CodeableConcept();
                }
            }
            return this.additiveType;
        }

        public boolean hasAdditiveType() {
            return this.additiveType != null && !this.additiveType.isEmpty();
        }

        public NutritionOrderEnteralFormulaComponent setAdditiveType(CodeableConcept value) {
            this.additiveType = value;
            return this;
        }

        public StringType getAdditiveProductNameElement() {
            if (this.additiveProductName == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderEnteralFormulaComponent.additiveProductName");
                }
                if (Configuration.doAutoCreate()) {
                    this.additiveProductName = new StringType();
                }
            }
            return this.additiveProductName;
        }

        public boolean hasAdditiveProductNameElement() {
            return this.additiveProductName != null && !this.additiveProductName.isEmpty();
        }

        public boolean hasAdditiveProductName() {
            return this.additiveProductName != null && !this.additiveProductName.isEmpty();
        }

        public NutritionOrderEnteralFormulaComponent setAdditiveProductNameElement(StringType value) {
            this.additiveProductName = value;
            return this;
        }

        public String getAdditiveProductName() {
            return this.additiveProductName == null ? null : (String)this.additiveProductName.getValue();
        }

        public NutritionOrderEnteralFormulaComponent setAdditiveProductName(String value) {
            if (Utilities.noString((String)value)) {
                this.additiveProductName = null;
            } else {
                if (this.additiveProductName == null) {
                    this.additiveProductName = new StringType();
                }
                this.additiveProductName.setValue(value);
            }
            return this;
        }

        public SimpleQuantity getCaloricDensity() {
            if (this.caloricDensity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderEnteralFormulaComponent.caloricDensity");
                }
                if (Configuration.doAutoCreate()) {
                    this.caloricDensity = new SimpleQuantity();
                }
            }
            return this.caloricDensity;
        }

        public boolean hasCaloricDensity() {
            return this.caloricDensity != null && !this.caloricDensity.isEmpty();
        }

        public NutritionOrderEnteralFormulaComponent setCaloricDensity(SimpleQuantity value) {
            this.caloricDensity = value;
            return this;
        }

        public CodeableConcept getRouteofAdministration() {
            if (this.routeofAdministration == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderEnteralFormulaComponent.routeofAdministration");
                }
                if (Configuration.doAutoCreate()) {
                    this.routeofAdministration = new CodeableConcept();
                }
            }
            return this.routeofAdministration;
        }

        public boolean hasRouteofAdministration() {
            return this.routeofAdministration != null && !this.routeofAdministration.isEmpty();
        }

        public NutritionOrderEnteralFormulaComponent setRouteofAdministration(CodeableConcept value) {
            this.routeofAdministration = value;
            return this;
        }

        public List<NutritionOrderEnteralFormulaAdministrationComponent> getAdministration() {
            if (this.administration == null) {
                this.administration = new ArrayList<NutritionOrderEnteralFormulaAdministrationComponent>();
            }
            return this.administration;
        }

        public boolean hasAdministration() {
            if (this.administration == null) {
                return false;
            }
            for (NutritionOrderEnteralFormulaAdministrationComponent item : this.administration) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public NutritionOrderEnteralFormulaAdministrationComponent addAdministration() {
            NutritionOrderEnteralFormulaAdministrationComponent t = new NutritionOrderEnteralFormulaAdministrationComponent();
            if (this.administration == null) {
                this.administration = new ArrayList<NutritionOrderEnteralFormulaAdministrationComponent>();
            }
            this.administration.add(t);
            return t;
        }

        public NutritionOrderEnteralFormulaComponent addAdministration(NutritionOrderEnteralFormulaAdministrationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.administration == null) {
                this.administration = new ArrayList<NutritionOrderEnteralFormulaAdministrationComponent>();
            }
            this.administration.add(t);
            return this;
        }

        public SimpleQuantity getMaxVolumeToDeliver() {
            if (this.maxVolumeToDeliver == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderEnteralFormulaComponent.maxVolumeToDeliver");
                }
                if (Configuration.doAutoCreate()) {
                    this.maxVolumeToDeliver = new SimpleQuantity();
                }
            }
            return this.maxVolumeToDeliver;
        }

        public boolean hasMaxVolumeToDeliver() {
            return this.maxVolumeToDeliver != null && !this.maxVolumeToDeliver.isEmpty();
        }

        public NutritionOrderEnteralFormulaComponent setMaxVolumeToDeliver(SimpleQuantity value) {
            this.maxVolumeToDeliver = value;
            return this;
        }

        public StringType getAdministrationInstructionElement() {
            if (this.administrationInstruction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderEnteralFormulaComponent.administrationInstruction");
                }
                if (Configuration.doAutoCreate()) {
                    this.administrationInstruction = new StringType();
                }
            }
            return this.administrationInstruction;
        }

        public boolean hasAdministrationInstructionElement() {
            return this.administrationInstruction != null && !this.administrationInstruction.isEmpty();
        }

        public boolean hasAdministrationInstruction() {
            return this.administrationInstruction != null && !this.administrationInstruction.isEmpty();
        }

        public NutritionOrderEnteralFormulaComponent setAdministrationInstructionElement(StringType value) {
            this.administrationInstruction = value;
            return this;
        }

        public String getAdministrationInstruction() {
            return this.administrationInstruction == null ? null : (String)this.administrationInstruction.getValue();
        }

        public NutritionOrderEnteralFormulaComponent setAdministrationInstruction(String value) {
            if (Utilities.noString((String)value)) {
                this.administrationInstruction = null;
            } else {
                if (this.administrationInstruction == null) {
                    this.administrationInstruction = new StringType();
                }
                this.administrationInstruction.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("baseFormulaType", "CodeableConcept", "The type of enteral or infant formula such as an adult standard formula with fiber or a soy-based infant formula.", 0, Integer.MAX_VALUE, this.baseFormulaType));
            childrenList.add(new Property("baseFormulaProductName", "string", "The product or brand name of the enteral or infant formula product such as \"ACME Adult Standard Formula\".", 0, Integer.MAX_VALUE, this.baseFormulaProductName));
            childrenList.add(new Property("additiveType", "CodeableConcept", "Indicates the type of modular component such as protein, carbohydrate, fat or fiber to be provided in addition to or mixed with the base formula.", 0, Integer.MAX_VALUE, this.additiveType));
            childrenList.add(new Property("additiveProductName", "string", "The product or brand name of the type of modular component to be added to the formula.", 0, Integer.MAX_VALUE, this.additiveProductName));
            childrenList.add(new Property("caloricDensity", "SimpleQuantity", "The amount of energy (Calories) that the formula should provide per specified volume, typically per mL or fluid oz.  For example, an infant may require a formula that provides 24 Calories per fluid ounce or an adult may require an enteral formula that provides 1.5 Calorie/mL.", 0, Integer.MAX_VALUE, this.caloricDensity));
            childrenList.add(new Property("routeofAdministration", "CodeableConcept", "The route or physiological path of administration into the patient's gastrointestinal  tract for purposes of providing the formula feeding, e.g. nasogastric tube.", 0, Integer.MAX_VALUE, this.routeofAdministration));
            childrenList.add(new Property("administration", "", "Formula administration instructions as structured data.  This repeating structure allows for changing the administration rate or volume over time for both bolus and continuous feeding.  An example of this would be an instruction to increase the rate of continuous feeding every 2 hours.", 0, Integer.MAX_VALUE, this.administration));
            childrenList.add(new Property("maxVolumeToDeliver", "SimpleQuantity", "The maximum total quantity of formula that may be administered to a subject over the period of time, e.g. 1440 mL over 24 hours.", 0, Integer.MAX_VALUE, this.maxVolumeToDeliver));
            childrenList.add(new Property("administrationInstruction", "string", "Free text formula administration, feeding instructions or additional instructions or information.", 0, Integer.MAX_VALUE, this.administrationInstruction));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -138930641: {
                    Base[] baseArray;
                    if (this.baseFormulaType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.baseFormulaType;
                    }
                    return baseArray;
                }
                case -1267705979: {
                    Base[] baseArray;
                    if (this.baseFormulaProductName == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.baseFormulaProductName;
                    }
                    return baseArray;
                }
                case -470746842: {
                    Base[] baseArray;
                    if (this.additiveType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.additiveType;
                    }
                    return baseArray;
                }
                case 488079534: {
                    Base[] baseArray;
                    if (this.additiveProductName == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.additiveProductName;
                    }
                    return baseArray;
                }
                case 186983261: {
                    Base[] baseArray;
                    if (this.caloricDensity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.caloricDensity;
                    }
                    return baseArray;
                }
                case -1710107042: {
                    Base[] baseArray;
                    if (this.routeofAdministration == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.routeofAdministration;
                    }
                    return baseArray;
                }
                case 1255702622: {
                    return this.administration == null ? new Base[]{} : this.administration.toArray(new Base[this.administration.size()]);
                }
                case 2017924652: {
                    Base[] baseArray;
                    if (this.maxVolumeToDeliver == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.maxVolumeToDeliver;
                    }
                    return baseArray;
                }
                case 427085136: {
                    Base[] baseArray;
                    if (this.administrationInstruction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.administrationInstruction;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -138930641: {
                    this.baseFormulaType = this.castToCodeableConcept(value);
                    break;
                }
                case -1267705979: {
                    this.baseFormulaProductName = this.castToString(value);
                    break;
                }
                case -470746842: {
                    this.additiveType = this.castToCodeableConcept(value);
                    break;
                }
                case 488079534: {
                    this.additiveProductName = this.castToString(value);
                    break;
                }
                case 186983261: {
                    this.caloricDensity = this.castToSimpleQuantity(value);
                    break;
                }
                case -1710107042: {
                    this.routeofAdministration = this.castToCodeableConcept(value);
                    break;
                }
                case 1255702622: {
                    this.getAdministration().add((NutritionOrderEnteralFormulaAdministrationComponent)value);
                    break;
                }
                case 2017924652: {
                    this.maxVolumeToDeliver = this.castToSimpleQuantity(value);
                    break;
                }
                case 427085136: {
                    this.administrationInstruction = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("baseFormulaType")) {
                this.baseFormulaType = this.castToCodeableConcept(value);
            } else if (name.equals("baseFormulaProductName")) {
                this.baseFormulaProductName = this.castToString(value);
            } else if (name.equals("additiveType")) {
                this.additiveType = this.castToCodeableConcept(value);
            } else if (name.equals("additiveProductName")) {
                this.additiveProductName = this.castToString(value);
            } else if (name.equals("caloricDensity")) {
                this.caloricDensity = this.castToSimpleQuantity(value);
            } else if (name.equals("routeofAdministration")) {
                this.routeofAdministration = this.castToCodeableConcept(value);
            } else if (name.equals("administration")) {
                this.getAdministration().add((NutritionOrderEnteralFormulaAdministrationComponent)value);
            } else if (name.equals("maxVolumeToDeliver")) {
                this.maxVolumeToDeliver = this.castToSimpleQuantity(value);
            } else if (name.equals("administrationInstruction")) {
                this.administrationInstruction = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -138930641: {
                    return this.getBaseFormulaType();
                }
                case -1267705979: {
                    throw new FHIRException("Cannot make property baseFormulaProductName as it is not a complex type");
                }
                case -470746842: {
                    return this.getAdditiveType();
                }
                case 488079534: {
                    throw new FHIRException("Cannot make property additiveProductName as it is not a complex type");
                }
                case 186983261: {
                    return this.getCaloricDensity();
                }
                case -1710107042: {
                    return this.getRouteofAdministration();
                }
                case 1255702622: {
                    return this.addAdministration();
                }
                case 2017924652: {
                    return this.getMaxVolumeToDeliver();
                }
                case 427085136: {
                    throw new FHIRException("Cannot make property administrationInstruction as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("baseFormulaType")) {
                this.baseFormulaType = new CodeableConcept();
                return this.baseFormulaType;
            }
            if (name.equals("baseFormulaProductName")) {
                throw new FHIRException("Cannot call addChild on a singleton property NutritionOrder.baseFormulaProductName");
            }
            if (name.equals("additiveType")) {
                this.additiveType = new CodeableConcept();
                return this.additiveType;
            }
            if (name.equals("additiveProductName")) {
                throw new FHIRException("Cannot call addChild on a singleton property NutritionOrder.additiveProductName");
            }
            if (name.equals("caloricDensity")) {
                this.caloricDensity = new SimpleQuantity();
                return this.caloricDensity;
            }
            if (name.equals("routeofAdministration")) {
                this.routeofAdministration = new CodeableConcept();
                return this.routeofAdministration;
            }
            if (name.equals("administration")) {
                return this.addAdministration();
            }
            if (name.equals("maxVolumeToDeliver")) {
                this.maxVolumeToDeliver = new SimpleQuantity();
                return this.maxVolumeToDeliver;
            }
            if (name.equals("administrationInstruction")) {
                throw new FHIRException("Cannot call addChild on a singleton property NutritionOrder.administrationInstruction");
            }
            return super.addChild(name);
        }

        @Override
        public NutritionOrderEnteralFormulaComponent copy() {
            NutritionOrderEnteralFormulaComponent dst = new NutritionOrderEnteralFormulaComponent();
            this.copyValues(dst);
            dst.baseFormulaType = this.baseFormulaType == null ? null : this.baseFormulaType.copy();
            dst.baseFormulaProductName = this.baseFormulaProductName == null ? null : this.baseFormulaProductName.copy();
            dst.additiveType = this.additiveType == null ? null : this.additiveType.copy();
            dst.additiveProductName = this.additiveProductName == null ? null : this.additiveProductName.copy();
            dst.caloricDensity = this.caloricDensity == null ? null : this.caloricDensity.copy();
            CodeableConcept codeableConcept = dst.routeofAdministration = this.routeofAdministration == null ? null : this.routeofAdministration.copy();
            if (this.administration != null) {
                dst.administration = new ArrayList<NutritionOrderEnteralFormulaAdministrationComponent>();
                for (NutritionOrderEnteralFormulaAdministrationComponent i : this.administration) {
                    dst.administration.add(i.copy());
                }
            }
            dst.maxVolumeToDeliver = this.maxVolumeToDeliver == null ? null : this.maxVolumeToDeliver.copy();
            dst.administrationInstruction = this.administrationInstruction == null ? null : this.administrationInstruction.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof NutritionOrderEnteralFormulaComponent)) {
                return false;
            }
            NutritionOrderEnteralFormulaComponent o = (NutritionOrderEnteralFormulaComponent)other;
            return NutritionOrderEnteralFormulaComponent.compareDeep(this.baseFormulaType, o.baseFormulaType, true) && NutritionOrderEnteralFormulaComponent.compareDeep(this.baseFormulaProductName, o.baseFormulaProductName, true) && NutritionOrderEnteralFormulaComponent.compareDeep(this.additiveType, o.additiveType, true) && NutritionOrderEnteralFormulaComponent.compareDeep(this.additiveProductName, o.additiveProductName, true) && NutritionOrderEnteralFormulaComponent.compareDeep(this.caloricDensity, o.caloricDensity, true) && NutritionOrderEnteralFormulaComponent.compareDeep(this.routeofAdministration, o.routeofAdministration, true) && NutritionOrderEnteralFormulaComponent.compareDeep(this.administration, o.administration, true) && NutritionOrderEnteralFormulaComponent.compareDeep(this.maxVolumeToDeliver, o.maxVolumeToDeliver, true) && NutritionOrderEnteralFormulaComponent.compareDeep(this.administrationInstruction, o.administrationInstruction, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof NutritionOrderEnteralFormulaComponent)) {
                return false;
            }
            NutritionOrderEnteralFormulaComponent o = (NutritionOrderEnteralFormulaComponent)other;
            return NutritionOrderEnteralFormulaComponent.compareValues(this.baseFormulaProductName, o.baseFormulaProductName, true) && NutritionOrderEnteralFormulaComponent.compareValues(this.additiveProductName, o.additiveProductName, true) && NutritionOrderEnteralFormulaComponent.compareValues(this.administrationInstruction, o.administrationInstruction, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.baseFormulaType != null && !this.baseFormulaType.isEmpty() || this.baseFormulaProductName != null && !this.baseFormulaProductName.isEmpty() || this.additiveType != null && !this.additiveType.isEmpty() || this.additiveProductName != null && !this.additiveProductName.isEmpty() || this.caloricDensity != null && !this.caloricDensity.isEmpty() || this.routeofAdministration != null && !this.routeofAdministration.isEmpty() || this.administration != null && !this.administration.isEmpty() || this.maxVolumeToDeliver != null && !this.maxVolumeToDeliver.isEmpty() || this.administrationInstruction != null && !this.administrationInstruction.isEmpty());
        }

        @Override
        public String fhirType() {
            return "NutritionOrder.enteralFormula";
        }
    }

    @Block
    public static class NutritionOrderSupplementComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of supplement product requested", formalDefinition="The kind of nutritional supplement product required such as a high protein or pediatric clear liquid supplement.")
        protected CodeableConcept type;
        @Child(name="productName", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Product or brand name of the nutritional supplement", formalDefinition="The product or brand name of the nutritional supplement such as \"Acme Protein Shake\".")
        protected StringType productName;
        @Child(name="schedule", type={Timing.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Scheduled frequency of supplement", formalDefinition="The time period and frequency at which the supplement(s) should be given.")
        protected List<Timing> schedule;
        @Child(name="quantity", type={SimpleQuantity.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Amount of the nutritional supplement", formalDefinition="The amount of the nutritional supplement to be given.")
        protected SimpleQuantity quantity;
        @Child(name="instruction", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Instructions or additional information about the oral supplement", formalDefinition="Free text or additional instructions or information pertaining to the oral supplement.")
        protected StringType instruction;
        private static final long serialVersionUID = 297545236L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderSupplementComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public NutritionOrderSupplementComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getProductNameElement() {
            if (this.productName == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderSupplementComponent.productName");
                }
                if (Configuration.doAutoCreate()) {
                    this.productName = new StringType();
                }
            }
            return this.productName;
        }

        public boolean hasProductNameElement() {
            return this.productName != null && !this.productName.isEmpty();
        }

        public boolean hasProductName() {
            return this.productName != null && !this.productName.isEmpty();
        }

        public NutritionOrderSupplementComponent setProductNameElement(StringType value) {
            this.productName = value;
            return this;
        }

        public String getProductName() {
            return this.productName == null ? null : (String)this.productName.getValue();
        }

        public NutritionOrderSupplementComponent setProductName(String value) {
            if (Utilities.noString((String)value)) {
                this.productName = null;
            } else {
                if (this.productName == null) {
                    this.productName = new StringType();
                }
                this.productName.setValue(value);
            }
            return this;
        }

        public List<Timing> getSchedule() {
            if (this.schedule == null) {
                this.schedule = new ArrayList<Timing>();
            }
            return this.schedule;
        }

        public boolean hasSchedule() {
            if (this.schedule == null) {
                return false;
            }
            for (Timing item : this.schedule) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Timing addSchedule() {
            Timing t = new Timing();
            if (this.schedule == null) {
                this.schedule = new ArrayList<Timing>();
            }
            this.schedule.add(t);
            return t;
        }

        public NutritionOrderSupplementComponent addSchedule(Timing t) {
            if (t == null) {
                return this;
            }
            if (this.schedule == null) {
                this.schedule = new ArrayList<Timing>();
            }
            this.schedule.add(t);
            return this;
        }

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderSupplementComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public NutritionOrderSupplementComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        public StringType getInstructionElement() {
            if (this.instruction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderSupplementComponent.instruction");
                }
                if (Configuration.doAutoCreate()) {
                    this.instruction = new StringType();
                }
            }
            return this.instruction;
        }

        public boolean hasInstructionElement() {
            return this.instruction != null && !this.instruction.isEmpty();
        }

        public boolean hasInstruction() {
            return this.instruction != null && !this.instruction.isEmpty();
        }

        public NutritionOrderSupplementComponent setInstructionElement(StringType value) {
            this.instruction = value;
            return this;
        }

        public String getInstruction() {
            return this.instruction == null ? null : (String)this.instruction.getValue();
        }

        public NutritionOrderSupplementComponent setInstruction(String value) {
            if (Utilities.noString((String)value)) {
                this.instruction = null;
            } else {
                if (this.instruction == null) {
                    this.instruction = new StringType();
                }
                this.instruction.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "CodeableConcept", "The kind of nutritional supplement product required such as a high protein or pediatric clear liquid supplement.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("productName", "string", "The product or brand name of the nutritional supplement such as \"Acme Protein Shake\".", 0, Integer.MAX_VALUE, this.productName));
            childrenList.add(new Property("schedule", "Timing", "The time period and frequency at which the supplement(s) should be given.", 0, Integer.MAX_VALUE, this.schedule));
            childrenList.add(new Property("quantity", "SimpleQuantity", "The amount of the nutritional supplement to be given.", 0, Integer.MAX_VALUE, this.quantity));
            childrenList.add(new Property("instruction", "string", "Free text or additional instructions or information pertaining to the oral supplement.", 0, Integer.MAX_VALUE, this.instruction));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1491817446: {
                    Base[] baseArray;
                    if (this.productName == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.productName;
                    }
                    return baseArray;
                }
                case -697920873: {
                    return this.schedule == null ? new Base[]{} : this.schedule.toArray(new Base[this.schedule.size()]);
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.quantity;
                    }
                    return baseArray;
                }
                case 301526158: {
                    Base[] baseArray;
                    if (this.instruction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.instruction;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    break;
                }
                case -1491817446: {
                    this.productName = this.castToString(value);
                    break;
                }
                case -697920873: {
                    this.getSchedule().add(this.castToTiming(value));
                    break;
                }
                case -1285004149: {
                    this.quantity = this.castToSimpleQuantity(value);
                    break;
                }
                case 301526158: {
                    this.instruction = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("productName")) {
                this.productName = this.castToString(value);
            } else if (name.equals("schedule")) {
                this.getSchedule().add(this.castToTiming(value));
            } else if (name.equals("quantity")) {
                this.quantity = this.castToSimpleQuantity(value);
            } else if (name.equals("instruction")) {
                this.instruction = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1491817446: {
                    throw new FHIRException("Cannot make property productName as it is not a complex type");
                }
                case -697920873: {
                    return this.addSchedule();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case 301526158: {
                    throw new FHIRException("Cannot make property instruction as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("productName")) {
                throw new FHIRException("Cannot call addChild on a singleton property NutritionOrder.productName");
            }
            if (name.equals("schedule")) {
                return this.addSchedule();
            }
            if (name.equals("quantity")) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            if (name.equals("instruction")) {
                throw new FHIRException("Cannot call addChild on a singleton property NutritionOrder.instruction");
            }
            return super.addChild(name);
        }

        @Override
        public NutritionOrderSupplementComponent copy() {
            NutritionOrderSupplementComponent dst = new NutritionOrderSupplementComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            StringType stringType = dst.productName = this.productName == null ? null : this.productName.copy();
            if (this.schedule != null) {
                dst.schedule = new ArrayList<Timing>();
                for (Timing i : this.schedule) {
                    dst.schedule.add(i.copy());
                }
            }
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.instruction = this.instruction == null ? null : this.instruction.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof NutritionOrderSupplementComponent)) {
                return false;
            }
            NutritionOrderSupplementComponent o = (NutritionOrderSupplementComponent)other;
            return NutritionOrderSupplementComponent.compareDeep(this.type, o.type, true) && NutritionOrderSupplementComponent.compareDeep(this.productName, o.productName, true) && NutritionOrderSupplementComponent.compareDeep(this.schedule, o.schedule, true) && NutritionOrderSupplementComponent.compareDeep(this.quantity, o.quantity, true) && NutritionOrderSupplementComponent.compareDeep(this.instruction, o.instruction, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof NutritionOrderSupplementComponent)) {
                return false;
            }
            NutritionOrderSupplementComponent o = (NutritionOrderSupplementComponent)other;
            return NutritionOrderSupplementComponent.compareValues(this.productName, o.productName, true) && NutritionOrderSupplementComponent.compareValues(this.instruction, o.instruction, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.productName != null && !this.productName.isEmpty() || this.schedule != null && !this.schedule.isEmpty() || this.quantity != null && !this.quantity.isEmpty() || this.instruction != null && !this.instruction.isEmpty());
        }

        @Override
        public String fhirType() {
            return "NutritionOrder.supplement";
        }
    }

    @Block
    public static class NutritionOrderOralDietTextureComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="modifier", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code to indicate how to alter the texture of the foods, e.g. pureed", formalDefinition="Any texture modifications (for solid foods) that should be made, e.g. easy to chew, chopped, ground, and pureed.")
        protected CodeableConcept modifier;
        @Child(name="foodType", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Concepts that are used to identify an entity that is ingested for nutritional purposes", formalDefinition="The food type(s) (e.g. meats, all foods)  that the texture modification applies to.  This could be all foods types.")
        protected CodeableConcept foodType;
        private static final long serialVersionUID = -56402817L;

        public CodeableConcept getModifier() {
            if (this.modifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderOralDietTextureComponent.modifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.modifier = new CodeableConcept();
                }
            }
            return this.modifier;
        }

        public boolean hasModifier() {
            return this.modifier != null && !this.modifier.isEmpty();
        }

        public NutritionOrderOralDietTextureComponent setModifier(CodeableConcept value) {
            this.modifier = value;
            return this;
        }

        public CodeableConcept getFoodType() {
            if (this.foodType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderOralDietTextureComponent.foodType");
                }
                if (Configuration.doAutoCreate()) {
                    this.foodType = new CodeableConcept();
                }
            }
            return this.foodType;
        }

        public boolean hasFoodType() {
            return this.foodType != null && !this.foodType.isEmpty();
        }

        public NutritionOrderOralDietTextureComponent setFoodType(CodeableConcept value) {
            this.foodType = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("modifier", "CodeableConcept", "Any texture modifications (for solid foods) that should be made, e.g. easy to chew, chopped, ground, and pureed.", 0, Integer.MAX_VALUE, this.modifier));
            childrenList.add(new Property("foodType", "CodeableConcept", "The food type(s) (e.g. meats, all foods)  that the texture modification applies to.  This could be all foods types.", 0, Integer.MAX_VALUE, this.foodType));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -615513385: {
                    Base[] baseArray;
                    if (this.modifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.modifier;
                    }
                    return baseArray;
                }
                case 379498680: {
                    Base[] baseArray;
                    if (this.foodType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.foodType;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -615513385: {
                    this.modifier = this.castToCodeableConcept(value);
                    break;
                }
                case 379498680: {
                    this.foodType = this.castToCodeableConcept(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("modifier")) {
                this.modifier = this.castToCodeableConcept(value);
            } else if (name.equals("foodType")) {
                this.foodType = this.castToCodeableConcept(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -615513385: {
                    return this.getModifier();
                }
                case 379498680: {
                    return this.getFoodType();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("modifier")) {
                this.modifier = new CodeableConcept();
                return this.modifier;
            }
            if (name.equals("foodType")) {
                this.foodType = new CodeableConcept();
                return this.foodType;
            }
            return super.addChild(name);
        }

        @Override
        public NutritionOrderOralDietTextureComponent copy() {
            NutritionOrderOralDietTextureComponent dst = new NutritionOrderOralDietTextureComponent();
            this.copyValues(dst);
            dst.modifier = this.modifier == null ? null : this.modifier.copy();
            dst.foodType = this.foodType == null ? null : this.foodType.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof NutritionOrderOralDietTextureComponent)) {
                return false;
            }
            NutritionOrderOralDietTextureComponent o = (NutritionOrderOralDietTextureComponent)other;
            return NutritionOrderOralDietTextureComponent.compareDeep(this.modifier, o.modifier, true) && NutritionOrderOralDietTextureComponent.compareDeep(this.foodType, o.foodType, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof NutritionOrderOralDietTextureComponent)) {
                return false;
            }
            NutritionOrderOralDietTextureComponent o = (NutritionOrderOralDietTextureComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.modifier != null && !this.modifier.isEmpty() || this.foodType != null && !this.foodType.isEmpty());
        }

        @Override
        public String fhirType() {
            return "NutritionOrder.oralDiet.texture";
        }
    }

    @Block
    public static class NutritionOrderOralDietNutrientComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="modifier", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of nutrient that is being modified", formalDefinition="The nutrient that is being modified such as carbohydrate or sodium.")
        protected CodeableConcept modifier;
        @Child(name="amount", type={SimpleQuantity.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Quantity of the specified nutrient", formalDefinition="The quantity of the specified nutrient to include in diet.")
        protected SimpleQuantity amount;
        private static final long serialVersionUID = 465107295L;

        public CodeableConcept getModifier() {
            if (this.modifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderOralDietNutrientComponent.modifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.modifier = new CodeableConcept();
                }
            }
            return this.modifier;
        }

        public boolean hasModifier() {
            return this.modifier != null && !this.modifier.isEmpty();
        }

        public NutritionOrderOralDietNutrientComponent setModifier(CodeableConcept value) {
            this.modifier = value;
            return this;
        }

        public SimpleQuantity getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderOralDietNutrientComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new SimpleQuantity();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public NutritionOrderOralDietNutrientComponent setAmount(SimpleQuantity value) {
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("modifier", "CodeableConcept", "The nutrient that is being modified such as carbohydrate or sodium.", 0, Integer.MAX_VALUE, this.modifier));
            childrenList.add(new Property("amount", "SimpleQuantity", "The quantity of the specified nutrient to include in diet.", 0, Integer.MAX_VALUE, this.amount));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -615513385: {
                    Base[] baseArray;
                    if (this.modifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.modifier;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -615513385: {
                    this.modifier = this.castToCodeableConcept(value);
                    break;
                }
                case -1413853096: {
                    this.amount = this.castToSimpleQuantity(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("modifier")) {
                this.modifier = this.castToCodeableConcept(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToSimpleQuantity(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -615513385: {
                    return this.getModifier();
                }
                case -1413853096: {
                    return this.getAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("modifier")) {
                this.modifier = new CodeableConcept();
                return this.modifier;
            }
            if (name.equals("amount")) {
                this.amount = new SimpleQuantity();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public NutritionOrderOralDietNutrientComponent copy() {
            NutritionOrderOralDietNutrientComponent dst = new NutritionOrderOralDietNutrientComponent();
            this.copyValues(dst);
            dst.modifier = this.modifier == null ? null : this.modifier.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof NutritionOrderOralDietNutrientComponent)) {
                return false;
            }
            NutritionOrderOralDietNutrientComponent o = (NutritionOrderOralDietNutrientComponent)other;
            return NutritionOrderOralDietNutrientComponent.compareDeep(this.modifier, o.modifier, true) && NutritionOrderOralDietNutrientComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof NutritionOrderOralDietNutrientComponent)) {
                return false;
            }
            NutritionOrderOralDietNutrientComponent o = (NutritionOrderOralDietNutrientComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.modifier != null && !this.modifier.isEmpty() || this.amount != null && !this.amount.isEmpty());
        }

        @Override
        public String fhirType() {
            return "NutritionOrder.oralDiet.nutrient";
        }
    }

    @Block
    public static class NutritionOrderOralDietComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Type of oral diet or diet restrictions that describe what can be consumed orally", formalDefinition="The kind of diet or dietary restriction such as fiber restricted diet or diabetic diet.")
        protected List<CodeableConcept> type;
        @Child(name="schedule", type={Timing.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Scheduled frequency of diet", formalDefinition="The time period and frequency at which the diet should be given.")
        protected List<Timing> schedule;
        @Child(name="nutrient", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Required  nutrient modifications", formalDefinition="Class that defines the quantity and type of nutrient modifications required for the oral diet.")
        protected List<NutritionOrderOralDietNutrientComponent> nutrient;
        @Child(name="texture", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Required  texture modifications", formalDefinition="Class that describes any texture modifications required for the patient to safely consume various types of solid foods.")
        protected List<NutritionOrderOralDietTextureComponent> texture;
        @Child(name="fluidConsistencyType", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The required consistency of fluids and liquids provided to the patient", formalDefinition="The required consistency (e.g. honey-thick, nectar-thick, thin, thickened.) of liquids or fluids served to the patient.")
        protected List<CodeableConcept> fluidConsistencyType;
        @Child(name="instruction", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Instructions or additional information about the oral diet", formalDefinition="Free text or additional instructions or information pertaining to the oral diet.")
        protected StringType instruction;
        private static final long serialVersionUID = 973058412L;

        public List<CodeableConcept> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            return this.type;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeableConcept item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addType() {
            CodeableConcept t = new CodeableConcept();
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return t;
        }

        public NutritionOrderOralDietComponent addType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return this;
        }

        public List<Timing> getSchedule() {
            if (this.schedule == null) {
                this.schedule = new ArrayList<Timing>();
            }
            return this.schedule;
        }

        public boolean hasSchedule() {
            if (this.schedule == null) {
                return false;
            }
            for (Timing item : this.schedule) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Timing addSchedule() {
            Timing t = new Timing();
            if (this.schedule == null) {
                this.schedule = new ArrayList<Timing>();
            }
            this.schedule.add(t);
            return t;
        }

        public NutritionOrderOralDietComponent addSchedule(Timing t) {
            if (t == null) {
                return this;
            }
            if (this.schedule == null) {
                this.schedule = new ArrayList<Timing>();
            }
            this.schedule.add(t);
            return this;
        }

        public List<NutritionOrderOralDietNutrientComponent> getNutrient() {
            if (this.nutrient == null) {
                this.nutrient = new ArrayList<NutritionOrderOralDietNutrientComponent>();
            }
            return this.nutrient;
        }

        public boolean hasNutrient() {
            if (this.nutrient == null) {
                return false;
            }
            for (NutritionOrderOralDietNutrientComponent item : this.nutrient) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public NutritionOrderOralDietNutrientComponent addNutrient() {
            NutritionOrderOralDietNutrientComponent t = new NutritionOrderOralDietNutrientComponent();
            if (this.nutrient == null) {
                this.nutrient = new ArrayList<NutritionOrderOralDietNutrientComponent>();
            }
            this.nutrient.add(t);
            return t;
        }

        public NutritionOrderOralDietComponent addNutrient(NutritionOrderOralDietNutrientComponent t) {
            if (t == null) {
                return this;
            }
            if (this.nutrient == null) {
                this.nutrient = new ArrayList<NutritionOrderOralDietNutrientComponent>();
            }
            this.nutrient.add(t);
            return this;
        }

        public List<NutritionOrderOralDietTextureComponent> getTexture() {
            if (this.texture == null) {
                this.texture = new ArrayList<NutritionOrderOralDietTextureComponent>();
            }
            return this.texture;
        }

        public boolean hasTexture() {
            if (this.texture == null) {
                return false;
            }
            for (NutritionOrderOralDietTextureComponent item : this.texture) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public NutritionOrderOralDietTextureComponent addTexture() {
            NutritionOrderOralDietTextureComponent t = new NutritionOrderOralDietTextureComponent();
            if (this.texture == null) {
                this.texture = new ArrayList<NutritionOrderOralDietTextureComponent>();
            }
            this.texture.add(t);
            return t;
        }

        public NutritionOrderOralDietComponent addTexture(NutritionOrderOralDietTextureComponent t) {
            if (t == null) {
                return this;
            }
            if (this.texture == null) {
                this.texture = new ArrayList<NutritionOrderOralDietTextureComponent>();
            }
            this.texture.add(t);
            return this;
        }

        public List<CodeableConcept> getFluidConsistencyType() {
            if (this.fluidConsistencyType == null) {
                this.fluidConsistencyType = new ArrayList<CodeableConcept>();
            }
            return this.fluidConsistencyType;
        }

        public boolean hasFluidConsistencyType() {
            if (this.fluidConsistencyType == null) {
                return false;
            }
            for (CodeableConcept item : this.fluidConsistencyType) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addFluidConsistencyType() {
            CodeableConcept t = new CodeableConcept();
            if (this.fluidConsistencyType == null) {
                this.fluidConsistencyType = new ArrayList<CodeableConcept>();
            }
            this.fluidConsistencyType.add(t);
            return t;
        }

        public NutritionOrderOralDietComponent addFluidConsistencyType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.fluidConsistencyType == null) {
                this.fluidConsistencyType = new ArrayList<CodeableConcept>();
            }
            this.fluidConsistencyType.add(t);
            return this;
        }

        public StringType getInstructionElement() {
            if (this.instruction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NutritionOrderOralDietComponent.instruction");
                }
                if (Configuration.doAutoCreate()) {
                    this.instruction = new StringType();
                }
            }
            return this.instruction;
        }

        public boolean hasInstructionElement() {
            return this.instruction != null && !this.instruction.isEmpty();
        }

        public boolean hasInstruction() {
            return this.instruction != null && !this.instruction.isEmpty();
        }

        public NutritionOrderOralDietComponent setInstructionElement(StringType value) {
            this.instruction = value;
            return this;
        }

        public String getInstruction() {
            return this.instruction == null ? null : (String)this.instruction.getValue();
        }

        public NutritionOrderOralDietComponent setInstruction(String value) {
            if (Utilities.noString((String)value)) {
                this.instruction = null;
            } else {
                if (this.instruction == null) {
                    this.instruction = new StringType();
                }
                this.instruction.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "CodeableConcept", "The kind of diet or dietary restriction such as fiber restricted diet or diabetic diet.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("schedule", "Timing", "The time period and frequency at which the diet should be given.", 0, Integer.MAX_VALUE, this.schedule));
            childrenList.add(new Property("nutrient", "", "Class that defines the quantity and type of nutrient modifications required for the oral diet.", 0, Integer.MAX_VALUE, this.nutrient));
            childrenList.add(new Property("texture", "", "Class that describes any texture modifications required for the patient to safely consume various types of solid foods.", 0, Integer.MAX_VALUE, this.texture));
            childrenList.add(new Property("fluidConsistencyType", "CodeableConcept", "The required consistency (e.g. honey-thick, nectar-thick, thin, thickened.) of liquids or fluids served to the patient.", 0, Integer.MAX_VALUE, this.fluidConsistencyType));
            childrenList.add(new Property("instruction", "string", "Free text or additional instructions or information pertaining to the oral diet.", 0, Integer.MAX_VALUE, this.instruction));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
                case -697920873: {
                    return this.schedule == null ? new Base[]{} : this.schedule.toArray(new Base[this.schedule.size()]);
                }
                case -1671151641: {
                    return this.nutrient == null ? new Base[]{} : this.nutrient.toArray(new Base[this.nutrient.size()]);
                }
                case -1417816805: {
                    return this.texture == null ? new Base[]{} : this.texture.toArray(new Base[this.texture.size()]);
                }
                case -525105592: {
                    return this.fluidConsistencyType == null ? new Base[]{} : this.fluidConsistencyType.toArray(new Base[this.fluidConsistencyType.size()]);
                }
                case 301526158: {
                    Base[] baseArray;
                    if (this.instruction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.instruction;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.getType().add(this.castToCodeableConcept(value));
                    break;
                }
                case -697920873: {
                    this.getSchedule().add(this.castToTiming(value));
                    break;
                }
                case -1671151641: {
                    this.getNutrient().add((NutritionOrderOralDietNutrientComponent)value);
                    break;
                }
                case -1417816805: {
                    this.getTexture().add((NutritionOrderOralDietTextureComponent)value);
                    break;
                }
                case -525105592: {
                    this.getFluidConsistencyType().add(this.castToCodeableConcept(value));
                    break;
                }
                case 301526158: {
                    this.instruction = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.getType().add(this.castToCodeableConcept(value));
            } else if (name.equals("schedule")) {
                this.getSchedule().add(this.castToTiming(value));
            } else if (name.equals("nutrient")) {
                this.getNutrient().add((NutritionOrderOralDietNutrientComponent)value);
            } else if (name.equals("texture")) {
                this.getTexture().add((NutritionOrderOralDietTextureComponent)value);
            } else if (name.equals("fluidConsistencyType")) {
                this.getFluidConsistencyType().add(this.castToCodeableConcept(value));
            } else if (name.equals("instruction")) {
                this.instruction = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.addType();
                }
                case -697920873: {
                    return this.addSchedule();
                }
                case -1671151641: {
                    return this.addNutrient();
                }
                case -1417816805: {
                    return this.addTexture();
                }
                case -525105592: {
                    return this.addFluidConsistencyType();
                }
                case 301526158: {
                    throw new FHIRException("Cannot make property instruction as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                return this.addType();
            }
            if (name.equals("schedule")) {
                return this.addSchedule();
            }
            if (name.equals("nutrient")) {
                return this.addNutrient();
            }
            if (name.equals("texture")) {
                return this.addTexture();
            }
            if (name.equals("fluidConsistencyType")) {
                return this.addFluidConsistencyType();
            }
            if (name.equals("instruction")) {
                throw new FHIRException("Cannot call addChild on a singleton property NutritionOrder.instruction");
            }
            return super.addChild(name);
        }

        @Override
        public NutritionOrderOralDietComponent copy() {
            NutritionOrderOralDietComponent dst = new NutritionOrderOralDietComponent();
            this.copyValues(dst);
            if (this.type != null) {
                dst.type = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.type) {
                    dst.type.add(codeableConcept.copy());
                }
            }
            if (this.schedule != null) {
                dst.schedule = new ArrayList<Timing>();
                for (Timing timing : this.schedule) {
                    dst.schedule.add(timing.copy());
                }
            }
            if (this.nutrient != null) {
                dst.nutrient = new ArrayList<NutritionOrderOralDietNutrientComponent>();
                for (NutritionOrderOralDietNutrientComponent nutritionOrderOralDietNutrientComponent : this.nutrient) {
                    dst.nutrient.add(nutritionOrderOralDietNutrientComponent.copy());
                }
            }
            if (this.texture != null) {
                dst.texture = new ArrayList<NutritionOrderOralDietTextureComponent>();
                for (NutritionOrderOralDietTextureComponent nutritionOrderOralDietTextureComponent : this.texture) {
                    dst.texture.add(nutritionOrderOralDietTextureComponent.copy());
                }
            }
            if (this.fluidConsistencyType != null) {
                dst.fluidConsistencyType = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.fluidConsistencyType) {
                    dst.fluidConsistencyType.add(codeableConcept.copy());
                }
            }
            dst.instruction = this.instruction == null ? null : this.instruction.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof NutritionOrderOralDietComponent)) {
                return false;
            }
            NutritionOrderOralDietComponent o = (NutritionOrderOralDietComponent)other;
            return NutritionOrderOralDietComponent.compareDeep(this.type, o.type, true) && NutritionOrderOralDietComponent.compareDeep(this.schedule, o.schedule, true) && NutritionOrderOralDietComponent.compareDeep(this.nutrient, o.nutrient, true) && NutritionOrderOralDietComponent.compareDeep(this.texture, o.texture, true) && NutritionOrderOralDietComponent.compareDeep(this.fluidConsistencyType, o.fluidConsistencyType, true) && NutritionOrderOralDietComponent.compareDeep(this.instruction, o.instruction, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof NutritionOrderOralDietComponent)) {
                return false;
            }
            NutritionOrderOralDietComponent o = (NutritionOrderOralDietComponent)other;
            return NutritionOrderOralDietComponent.compareValues(this.instruction, o.instruction, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.schedule != null && !this.schedule.isEmpty() || this.nutrient != null && !this.nutrient.isEmpty() || this.texture != null && !this.texture.isEmpty() || this.fluidConsistencyType != null && !this.fluidConsistencyType.isEmpty() || this.instruction != null && !this.instruction.isEmpty());
        }

        @Override
        public String fhirType() {
            return "NutritionOrder.oralDiet";
        }
    }

    public static class NutritionOrderStatusEnumFactory
    implements EnumFactory<NutritionOrderStatus> {
        @Override
        public NutritionOrderStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return NutritionOrderStatus.PROPOSED;
            }
            if ("draft".equals(codeString)) {
                return NutritionOrderStatus.DRAFT;
            }
            if ("planned".equals(codeString)) {
                return NutritionOrderStatus.PLANNED;
            }
            if ("requested".equals(codeString)) {
                return NutritionOrderStatus.REQUESTED;
            }
            if ("active".equals(codeString)) {
                return NutritionOrderStatus.ACTIVE;
            }
            if ("on-hold".equals(codeString)) {
                return NutritionOrderStatus.ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return NutritionOrderStatus.COMPLETED;
            }
            if ("cancelled".equals(codeString)) {
                return NutritionOrderStatus.CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return NutritionOrderStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown NutritionOrderStatus code '" + codeString + "'");
        }

        public Enumeration<NutritionOrderStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return new Enumeration<NutritionOrderStatus>(this, NutritionOrderStatus.PROPOSED);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<NutritionOrderStatus>(this, NutritionOrderStatus.DRAFT);
            }
            if ("planned".equals(codeString)) {
                return new Enumeration<NutritionOrderStatus>(this, NutritionOrderStatus.PLANNED);
            }
            if ("requested".equals(codeString)) {
                return new Enumeration<NutritionOrderStatus>(this, NutritionOrderStatus.REQUESTED);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<NutritionOrderStatus>(this, NutritionOrderStatus.ACTIVE);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<NutritionOrderStatus>(this, NutritionOrderStatus.ONHOLD);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<NutritionOrderStatus>(this, NutritionOrderStatus.COMPLETED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<NutritionOrderStatus>(this, NutritionOrderStatus.CANCELLED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<NutritionOrderStatus>(this, NutritionOrderStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown NutritionOrderStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(NutritionOrderStatus code) {
            if (code == NutritionOrderStatus.PROPOSED) {
                return "proposed";
            }
            if (code == NutritionOrderStatus.DRAFT) {
                return "draft";
            }
            if (code == NutritionOrderStatus.PLANNED) {
                return "planned";
            }
            if (code == NutritionOrderStatus.REQUESTED) {
                return "requested";
            }
            if (code == NutritionOrderStatus.ACTIVE) {
                return "active";
            }
            if (code == NutritionOrderStatus.ONHOLD) {
                return "on-hold";
            }
            if (code == NutritionOrderStatus.COMPLETED) {
                return "completed";
            }
            if (code == NutritionOrderStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == NutritionOrderStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(NutritionOrderStatus code) {
            return code.getSystem();
        }
    }

    public static enum NutritionOrderStatus {
        PROPOSED,
        DRAFT,
        PLANNED,
        REQUESTED,
        ACTIVE,
        ONHOLD,
        COMPLETED,
        CANCELLED,
        ENTEREDINERROR,
        NULL;


        public static NutritionOrderStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return PROPOSED;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("planned".equals(codeString)) {
                return PLANNED;
            }
            if ("requested".equals(codeString)) {
                return REQUESTED;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            throw new FHIRException("Unknown NutritionOrderStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROPOSED: {
                    return "proposed";
                }
                case DRAFT: {
                    return "draft";
                }
                case PLANNED: {
                    return "planned";
                }
                case REQUESTED: {
                    return "requested";
                }
                case ACTIVE: {
                    return "active";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case COMPLETED: {
                    return "completed";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROPOSED: {
                    return "http://hl7.org/fhir/nutrition-order-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/nutrition-order-status";
                }
                case PLANNED: {
                    return "http://hl7.org/fhir/nutrition-order-status";
                }
                case REQUESTED: {
                    return "http://hl7.org/fhir/nutrition-order-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/nutrition-order-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/nutrition-order-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/nutrition-order-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/nutrition-order-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/nutrition-order-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROPOSED: {
                    return "The request has been proposed.";
                }
                case DRAFT: {
                    return "The request is in preliminary form prior to being sent.";
                }
                case PLANNED: {
                    return "The request has been planned.";
                }
                case REQUESTED: {
                    return "The request has been placed.";
                }
                case ACTIVE: {
                    return "The request is 'actionable', but not all actions that are implied by it have occurred yet.";
                }
                case ONHOLD: {
                    return "Actions implied by the request have been temporarily halted, but are expected to continue later. May also be called \"suspended\".";
                }
                case COMPLETED: {
                    return "All actions that are implied by the order have occurred and no continuation is planned (this will rarely be made explicit).";
                }
                case CANCELLED: {
                    return "The request has been withdrawn and is no longer actionable.";
                }
                case ENTEREDINERROR: {
                    return "The request was entered in error and voided.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROPOSED: {
                    return "Proposed";
                }
                case DRAFT: {
                    return "Draft";
                }
                case PLANNED: {
                    return "Planned";
                }
                case REQUESTED: {
                    return "Requested";
                }
                case ACTIVE: {
                    return "Active";
                }
                case ONHOLD: {
                    return "On-Hold";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

