/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;

@ResourceDef(name="Linkage", profile="http://hl7.org/fhir/Profile/Linkage")
public class Linkage
extends DomainResource {
    @Child(name="author", type={Practitioner.class, Organization.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who is responsible for linkages", formalDefinition="Identifies the user or organization responsible for asserting the linkages and who establishes the context for evaluating the nature of each linkage.")
    protected Reference author;
    protected Resource authorTarget;
    @Child(name="item", type={}, order=1, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Item to be linked", formalDefinition="Identifies one of the records that is considered to refer to the same real-world occurrence as well as how the items hould be evaluated within the collection of linked items.")
    protected List<LinkageItemComponent> item;
    private static final long serialVersionUID = 371266420L;
    @SearchParamDefinition(name="author", path="Linkage.author", description="Author of the Linkage", type="reference")
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("Linkage:author").toLocked();
    @SearchParamDefinition(name="source", path="Linkage.item.resource", description="Matches on any item in the Linkage with a type of 'source'", type="reference")
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_SOURCE = new Include("Linkage:source").toLocked();
    @SearchParamDefinition(name="item", path="Linkage.item.resource", description="Matches on any item in the Linkage", type="reference")
    public static final String SP_ITEM = "item";
    public static final ReferenceClientParam ITEM = new ReferenceClientParam("item");
    public static final Include INCLUDE_ITEM = new Include("Linkage:item").toLocked();

    public Reference getAuthor() {
        if (this.author == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Linkage.author");
            }
            if (Configuration.doAutoCreate()) {
                this.author = new Reference();
            }
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public Linkage setAuthor(Reference value) {
        this.author = value;
        return this;
    }

    public Resource getAuthorTarget() {
        return this.authorTarget;
    }

    public Linkage setAuthorTarget(Resource value) {
        this.authorTarget = value;
        return this;
    }

    public List<LinkageItemComponent> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<LinkageItemComponent>();
        }
        return this.item;
    }

    public boolean hasItem() {
        if (this.item == null) {
            return false;
        }
        for (LinkageItemComponent item : this.item) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public LinkageItemComponent addItem() {
        LinkageItemComponent t = new LinkageItemComponent();
        if (this.item == null) {
            this.item = new ArrayList<LinkageItemComponent>();
        }
        this.item.add(t);
        return t;
    }

    public Linkage addItem(LinkageItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.item == null) {
            this.item = new ArrayList<LinkageItemComponent>();
        }
        this.item.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_AUTHOR, "Reference(Practitioner|Organization)", "Identifies the user or organization responsible for asserting the linkages and who establishes the context for evaluating the nature of each linkage.", 0, Integer.MAX_VALUE, this.author));
        childrenList.add(new Property(SP_ITEM, "", "Identifies one of the records that is considered to refer to the same real-world occurrence as well as how the items hould be evaluated within the collection of linked items.", 0, Integer.MAX_VALUE, this.item));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1406328437: {
                Base[] baseArray;
                if (this.author == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.author;
                }
                return baseArray;
            }
            case 3242771: {
                return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1406328437: {
                this.author = this.castToReference(value);
                break;
            }
            case 3242771: {
                this.getItem().add((LinkageItemComponent)value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_AUTHOR)) {
            this.author = this.castToReference(value);
        } else if (name.equals(SP_ITEM)) {
            this.getItem().add((LinkageItemComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1406328437: {
                return this.getAuthor();
            }
            case 3242771: {
                return this.addItem();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_AUTHOR)) {
            this.author = new Reference();
            return this.author;
        }
        if (name.equals(SP_ITEM)) {
            return this.addItem();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Linkage";
    }

    @Override
    public Linkage copy() {
        Linkage dst = new Linkage();
        this.copyValues(dst);
        Reference reference = dst.author = this.author == null ? null : this.author.copy();
        if (this.item != null) {
            dst.item = new ArrayList<LinkageItemComponent>();
            for (LinkageItemComponent i : this.item) {
                dst.item.add(i.copy());
            }
        }
        return dst;
    }

    protected Linkage typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Linkage)) {
            return false;
        }
        Linkage o = (Linkage)other;
        return Linkage.compareDeep(this.author, o.author, true) && Linkage.compareDeep(this.item, o.item, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Linkage)) {
            return false;
        }
        Linkage o = (Linkage)other;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.author != null && !this.author.isEmpty() || this.item != null && !this.item.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Linkage;
    }

    @Block
    public static class LinkageItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="source | alternate | historical", formalDefinition="Distinguishes which item is \"source of truth\" (if any) and which items are no longer considered to be current representations.")
        protected Enumeration<LinkageType> type;
        @Child(name="resource", type={Reference.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Resource being linked", formalDefinition="The resource instance being linked as part of the group.")
        protected Reference resource;
        private static final long serialVersionUID = 527428511L;

        public LinkageItemComponent() {
        }

        public LinkageItemComponent(Enumeration<LinkageType> type, Reference resource) {
            this.type = type;
            this.resource = resource;
        }

        public Enumeration<LinkageType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create LinkageItemComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<LinkageType>(new LinkageTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public LinkageItemComponent setTypeElement(Enumeration<LinkageType> value) {
            this.type = value;
            return this;
        }

        public LinkageType getType() {
            return this.type == null ? null : (LinkageType)((Object)this.type.getValue());
        }

        public LinkageItemComponent setType(LinkageType value) {
            if (this.type == null) {
                this.type = new Enumeration<LinkageType>(new LinkageTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public Reference getResource() {
            if (this.resource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create LinkageItemComponent.resource");
                }
                if (Configuration.doAutoCreate()) {
                    this.resource = new Reference();
                }
            }
            return this.resource;
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public LinkageItemComponent setResource(Reference value) {
            this.resource = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "code", "Distinguishes which item is \"source of truth\" (if any) and which items are no longer considered to be current representations.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("resource", "Reference", "The resource instance being linked as part of the group.", 0, Integer.MAX_VALUE, this.resource));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.resource;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = new LinkageTypeEnumFactory().fromType(value);
                    break;
                }
                case -341064690: {
                    this.resource = this.castToReference(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = new LinkageTypeEnumFactory().fromType(value);
            } else if (name.equals("resource")) {
                this.resource = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    throw new FHIRException("Cannot make property type as it is not a complex type");
                }
                case -341064690: {
                    return this.getResource();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a singleton property Linkage.type");
            }
            if (name.equals("resource")) {
                this.resource = new Reference();
                return this.resource;
            }
            return super.addChild(name);
        }

        @Override
        public LinkageItemComponent copy() {
            LinkageItemComponent dst = new LinkageItemComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.resource = this.resource == null ? null : this.resource.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof LinkageItemComponent)) {
                return false;
            }
            LinkageItemComponent o = (LinkageItemComponent)other;
            return LinkageItemComponent.compareDeep(this.type, o.type, true) && LinkageItemComponent.compareDeep(this.resource, o.resource, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof LinkageItemComponent)) {
                return false;
            }
            LinkageItemComponent o = (LinkageItemComponent)other;
            return LinkageItemComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.resource != null && !this.resource.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Linkage.item";
        }
    }

    public static class LinkageTypeEnumFactory
    implements EnumFactory<LinkageType> {
        @Override
        public LinkageType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if (Linkage.SP_SOURCE.equals(codeString)) {
                return LinkageType.SOURCE;
            }
            if ("alternate".equals(codeString)) {
                return LinkageType.ALTERNATE;
            }
            if ("historical".equals(codeString)) {
                return LinkageType.HISTORICAL;
            }
            throw new IllegalArgumentException("Unknown LinkageType code '" + codeString + "'");
        }

        public Enumeration<LinkageType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if (Linkage.SP_SOURCE.equals(codeString)) {
                return new Enumeration<LinkageType>(this, LinkageType.SOURCE);
            }
            if ("alternate".equals(codeString)) {
                return new Enumeration<LinkageType>(this, LinkageType.ALTERNATE);
            }
            if ("historical".equals(codeString)) {
                return new Enumeration<LinkageType>(this, LinkageType.HISTORICAL);
            }
            throw new FHIRException("Unknown LinkageType code '" + codeString + "'");
        }

        @Override
        public String toCode(LinkageType code) {
            if (code == LinkageType.SOURCE) {
                return Linkage.SP_SOURCE;
            }
            if (code == LinkageType.ALTERNATE) {
                return "alternate";
            }
            if (code == LinkageType.HISTORICAL) {
                return "historical";
            }
            return "?";
        }

        @Override
        public String toSystem(LinkageType code) {
            return code.getSystem();
        }
    }

    public static enum LinkageType {
        SOURCE,
        ALTERNATE,
        HISTORICAL,
        NULL;


        public static LinkageType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if (Linkage.SP_SOURCE.equals(codeString)) {
                return SOURCE;
            }
            if ("alternate".equals(codeString)) {
                return ALTERNATE;
            }
            if ("historical".equals(codeString)) {
                return HISTORICAL;
            }
            throw new FHIRException("Unknown LinkageType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case SOURCE: {
                    return Linkage.SP_SOURCE;
                }
                case ALTERNATE: {
                    return "alternate";
                }
                case HISTORICAL: {
                    return "historical";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case SOURCE: {
                    return "http://hl7.org/fhir/linkage-type";
                }
                case ALTERNATE: {
                    return "http://hl7.org/fhir/linkage-type";
                }
                case HISTORICAL: {
                    return "http://hl7.org/fhir/linkage-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case SOURCE: {
                    return "The record represents the \"source of truth\" (from the perspective of this Linkage resource) for the underlying event/condition/etc.";
                }
                case ALTERNATE: {
                    return "The record represents the alternative view of the underlying event/condition/etc.  The record may still be actively maintained, even though it is not considered to be the source of truth.";
                }
                case HISTORICAL: {
                    return "The record represents an obsolete record of the underlyng event/condition/etc.  It is not expected to be actively maintained.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case SOURCE: {
                    return "Source of truth";
                }
                case ALTERNATE: {
                    return "Alternate record";
                }
                case HISTORICAL: {
                    return "Historical/obsolete record";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

