/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.metamodel;

import org.hl7.fhir.dstu2016may.metamodel.ParserBase;
import org.hl7.fhir.dstu2016may.model.ElementDefinition;
import org.hl7.fhir.dstu2016may.model.StructureDefinition;
import org.hl7.fhir.dstu2016may.utils.IWorkerContext;
import org.hl7.fhir.dstu2016may.utils.ToolingExtensions;

public class Property {
    private IWorkerContext context;
    private ElementDefinition definition;
    private StructureDefinition structure;
    private Boolean canBePrimitive;

    public Property(IWorkerContext context, ElementDefinition definition, StructureDefinition structure) {
        this.context = context;
        this.definition = definition;
        this.structure = structure;
    }

    public String getName() {
        return this.definition.getPath().substring(this.definition.getPath().lastIndexOf(".") + 1);
    }

    public ElementDefinition getDefinition() {
        return this.definition;
    }

    public String getType() {
        if (this.definition.getType().size() == 0) {
            return null;
        }
        if (this.definition.getType().size() > 1) {
            String tn = this.definition.getType().get(0).getCode();
            for (int i = 1; i < this.definition.getType().size(); ++i) {
                if (tn.equals(this.definition.getType().get(i).getCode())) continue;
                throw new Error("logic error, gettype when types > 1");
            }
            return tn;
        }
        return this.definition.getType().get(0).getCode();
    }

    public String getType(String elementName) {
        if (this.definition.getType().size() == 0) {
            return null;
        }
        if (this.definition.getType().size() > 1) {
            String t = this.definition.getType().get(0).getCode();
            boolean all = true;
            for (ElementDefinition.TypeRefComponent tr : this.definition.getType()) {
                if (t.equals(tr.getCode())) continue;
                all = false;
            }
            if (all) {
                return t;
            }
            String tail = this.definition.getPath().substring(this.definition.getPath().lastIndexOf(".") + 1);
            if (tail.endsWith("[x]") && elementName != null && elementName.startsWith(tail.substring(0, tail.length() - 3))) {
                String name = elementName.substring(tail.length() - 3);
                return ParserBase.isPrimitive(this.lowFirst(name)) ? this.lowFirst(name) : name;
            }
            throw new Error("logic error, gettype when types > 1, name mismatch for " + elementName + " on at " + this.definition.getPath());
        }
        if (this.definition.getType().get(0).getCode() == null) {
            return this.structure.getId();
        }
        return this.definition.getType().get(0).getCode();
    }

    public boolean hasType(String elementName) {
        if (this.definition.getType().size() == 0) {
            return false;
        }
        if (this.definition.getType().size() > 1) {
            String t = this.definition.getType().get(0).getCode();
            boolean all = true;
            for (ElementDefinition.TypeRefComponent tr : this.definition.getType()) {
                if (t.equals(tr.getCode())) continue;
                all = false;
            }
            if (all) {
                return true;
            }
            String tail = this.definition.getPath().substring(this.definition.getPath().lastIndexOf(".") + 1);
            if (tail.endsWith("[x]") && elementName.startsWith(tail.substring(0, tail.length() - 3))) {
                String name = elementName.substring(tail.length() - 3);
                return true;
            }
            return false;
        }
        return true;
    }

    public StructureDefinition getStructure() {
        return this.structure;
    }

    public boolean isPrimitive(String name) {
        return ParserBase.isPrimitive(this.getType(name));
    }

    private String lowFirst(String t) {
        return t.substring(0, 1).toLowerCase() + t.substring(1);
    }

    public boolean isResource() {
        return this.definition.getType().size() == 1 && ("Resource".equals(this.definition.getType().get(0).getCode()) || "DomainResource".equals(this.definition.getType().get(0).getCode()));
    }

    public boolean isList() {
        return !this.definition.getMax().equals("1");
    }

    public String getScopedPropertyName() {
        return this.definition.getBase().getPath();
    }

    public String getNamespace() {
        if (ToolingExtensions.hasExtension(this.definition, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace")) {
            return ToolingExtensions.readStringExtension(this.definition, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace");
        }
        if (ToolingExtensions.hasExtension(this.structure, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace")) {
            return ToolingExtensions.readStringExtension(this.structure, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace");
        }
        return "http://hl7.org/fhir";
    }

    public boolean IsLogicalAndHasPrimitiveValue(String name) {
        if (this.canBePrimitive != null) {
            return this.canBePrimitive;
        }
        this.canBePrimitive = false;
        if (this.structure.getKind() != StructureDefinition.StructureDefinitionKind.LOGICAL) {
            return false;
        }
        if (!this.hasType(name)) {
            return false;
        }
        StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, this.structure.getUrl().substring(0, this.structure.getUrl().lastIndexOf("/") + 1) + this.getType(name));
        if (sd == null || sd.getKind() != StructureDefinition.StructureDefinitionKind.LOGICAL) {
            return false;
        }
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (!ed.getPath().equals(sd.getId() + ".value") || ed.getType().size() != 1 || !ParserBase.isPrimitive(ed.getType().get(0).getCode())) continue;
            this.canBePrimitive = true;
            return true;
        }
        return false;
    }

    public boolean isChoice() {
        if (this.definition.getType().size() <= 1) {
            return false;
        }
        String tn = this.definition.getType().get(0).getCode();
        for (int i = 1; i < this.definition.getType().size(); ++i) {
            if (this.definition.getType().get(i).getCode().equals(tn)) continue;
            return true;
        }
        return false;
    }
}

