package org.hl7.fhir.dstu2016may.model.codesystems;

/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, 
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this 
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, 
     this list of conditions and the following disclaimer in the documentation 
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
  
*/

// Generated on Sun, May 8, 2016 03:05+1000 for FHIR v1.4.0

import org.hl7.fhir.exceptions.FHIRException;

public enum Participantrequired {

  /**
   * The participant is required to attend the appointment.
   */
  REQUIRED,
  /**
   * The participant may optionally attend the appointment.
   */
  OPTIONAL,
  /**
   * The participant is excluded from the appointment, and may not be informed of
   * the appointment taking place. (Appointment is about them, not for them - such
   * as 2 doctors discussing results about a patient's test).
   */
  INFORMATIONONLY,
  /**
   * added to help the parsers
   */
  NULL;

  public static Participantrequired fromCode(String codeString) throws FHIRException {
    if (codeString == null || "".equals(codeString))
      return null;
    if ("required".equals(codeString))
      return REQUIRED;
    if ("optional".equals(codeString))
      return OPTIONAL;
    if ("information-only".equals(codeString))
      return INFORMATIONONLY;
    throw new FHIRException("Unknown Participantrequired code '" + codeString + "'");
  }

  public String toCode() {
    switch (this) {
    case REQUIRED:
      return "required";
    case OPTIONAL:
      return "optional";
    case INFORMATIONONLY:
      return "information-only";
    case NULL:
      return null;
    default:
      return "?";
    }
  }

  public String getSystem() {
    return "http://hl7.org/fhir/participantrequired";
  }

  public String getDefinition() {
    switch (this) {
    case REQUIRED:
      return "The participant is required to attend the appointment.";
    case OPTIONAL:
      return "The participant may optionally attend the appointment.";
    case INFORMATIONONLY:
      return "The participant is excluded from the appointment, and may not be informed of the appointment taking place. (Appointment is about them, not for them - such as 2 doctors discussing results about a patient's test).";
    case NULL:
      return null;
    default:
      return "?";
    }
  }

  public String getDisplay() {
    switch (this) {
    case REQUIRED:
      return "Required";
    case OPTIONAL:
      return "Optional";
    case INFORMATIONONLY:
      return "Information Only";
    case NULL:
      return null;
    default:
      return "?";
    }
  }

}