package org.hl7.fhir.dstu2016may.formats;

import java.io.IOException;

/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, 
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this 
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, 
     this list of conditions and the following disclaimer in the documentation 
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
  
*/

// Generated on Sun, May 8, 2016 03:05+1000 for FHIR v1.4.0
import org.hl7.fhir.dstu2016may.model.*;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

public class JsonParser extends JsonParserBase {

  public JsonParser() {
    super();
  }

  public JsonParser(boolean allowUnknownContent) {
    super();
    setAllowUnknownContent(allowUnknownContent);
  }

  protected void parseElementProperties(JsonObject json, Element element) throws IOException, FHIRFormatError {
    super.parseElementProperties(json, element);
    if (json.has("extension")) {
      JsonArray array = json.getAsJsonArray("extension");
      for (int i = 0; i < array.size(); i++) {
        element.getExtension().add(parseExtension(array.get(i).getAsJsonObject()));
      }
    }
    ;
  }

  protected void parseBackboneProperties(JsonObject json, BackboneElement element) throws IOException, FHIRFormatError {
    parseElementProperties(json, element);
    if (json.has("modifierExtension")) {
      JsonArray array = json.getAsJsonArray("modifierExtension");
      for (int i = 0; i < array.size(); i++) {
        element.getModifierExtension().add(parseExtension(array.get(i).getAsJsonObject()));
      }
    }
  }

  protected void parseTypeProperties(JsonObject json, Element element) throws IOException, FHIRFormatError {
    parseElementProperties(json, element);
  }

  @SuppressWarnings("unchecked")
  protected <E extends Enum<E>> Enumeration<E> parseEnumeration(String s, E item, EnumFactory e)
      throws IOException, FHIRFormatError {
    Enumeration<E> res = new Enumeration<E>(e);
    if (s != null)
      res.setValue((E) e.fromCode(s));
    return res;
  }

  protected MarkdownType parseMarkdown(String v) throws IOException, FHIRFormatError {
    MarkdownType res = new MarkdownType(v);
    return res;
  }

  protected IntegerType parseInteger(java.lang.Long v) throws IOException, FHIRFormatError {
    IntegerType res = new IntegerType(v);
    return res;
  }

  protected DateTimeType parseDateTime(String v) throws IOException, FHIRFormatError {
    DateTimeType res = new DateTimeType(v);
    return res;
  }

  protected UnsignedIntType parseUnsignedInt(String v) throws IOException, FHIRFormatError {
    UnsignedIntType res = new UnsignedIntType(v);
    return res;
  }

  protected CodeType parseCode(String v) throws IOException, FHIRFormatError {
    CodeType res = new CodeType(v);
    return res;
  }

  protected DateType parseDate(String v) throws IOException, FHIRFormatError {
    DateType res = new DateType(v);
    return res;
  }

  protected DecimalType parseDecimal(java.math.BigDecimal v) throws IOException, FHIRFormatError {
    DecimalType res = new DecimalType(v);
    return res;
  }

  protected UriType parseUri(String v) throws IOException, FHIRFormatError {
    UriType res = new UriType(v);
    return res;
  }

  protected IdType parseId(String v) throws IOException, FHIRFormatError {
    IdType res = new IdType(v);
    return res;
  }

  protected Base64BinaryType parseBase64Binary(String v) throws IOException, FHIRFormatError {
    Base64BinaryType res = new Base64BinaryType(v);
    return res;
  }

  protected TimeType parseTime(String v) throws IOException, FHIRFormatError {
    TimeType res = new TimeType(v);
    return res;
  }

  protected OidType parseOid(String v) throws IOException, FHIRFormatError {
    OidType res = new OidType(v);
    return res;
  }

  protected PositiveIntType parsePositiveInt(String v) throws IOException, FHIRFormatError {
    PositiveIntType res = new PositiveIntType(v);
    return res;
  }

  protected StringType parseString(String v) throws IOException, FHIRFormatError {
    StringType res = new StringType(v);
    return res;
  }

  protected BooleanType parseBoolean(java.lang.Boolean v) throws IOException, FHIRFormatError {
    BooleanType res = new BooleanType(v);
    return res;
  }

  protected UuidType parseUuid(String v) throws IOException, FHIRFormatError {
    UuidType res = new UuidType(v);
    return res;
  }

  protected InstantType parseInstant(String v) throws IOException, FHIRFormatError {
    InstantType res = new InstantType(v);
    return res;
  }

  protected Extension parseExtension(JsonObject json) throws IOException, FHIRFormatError {
    Extension res = new Extension();
    parseElementProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    return res;
  }

  protected Narrative parseNarrative(JsonObject json) throws IOException, FHIRFormatError {
    Narrative res = new Narrative();
    parseElementProperties(json, res);
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Narrative.NarrativeStatus.NULL,
          new Narrative.NarrativeStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("div"))
      res.setDiv(parseXhtml(json.get("div").getAsString()));
    return res;
  }

  protected Period parsePeriod(JsonObject json) throws IOException, FHIRFormatError {
    Period res = new Period();
    parseTypeProperties(json, res);
    if (json.has("start"))
      res.setStartElement(parseDateTime(json.get("start").getAsString()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseDateTime(json.get("end").getAsString()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
    return res;
  }

  protected Coding parseCoding(JsonObject json) throws IOException, FHIRFormatError {
    Coding res = new Coding();
    parseTypeProperties(json, res);
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    if (json.has("userSelected"))
      res.setUserSelectedElement(parseBoolean(json.get("userSelected").getAsBoolean()));
    if (json.has("_userSelected"))
      parseElementProperties(json.getAsJsonObject("_userSelected"), res.getUserSelectedElement());
    return res;
  }

  protected Range parseRange(JsonObject json) throws IOException, FHIRFormatError {
    Range res = new Range();
    parseTypeProperties(json, res);
    if (json.has("low"))
      res.setLow(parseSimpleQuantity(json.getAsJsonObject("low")));
    if (json.has("high"))
      res.setHigh(parseSimpleQuantity(json.getAsJsonObject("high")));
    return res;
  }

  protected Quantity parseQuantity(JsonObject json) throws IOException, FHIRFormatError {
    Quantity res = new Quantity();
    parseTypeProperties(json, res);
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("comparator"))
      res.setComparatorElement(parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL,
          new Quantity.QuantityComparatorEnumFactory()));
    if (json.has("_comparator"))
      parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
    if (json.has("unit"))
      res.setUnitElement(parseString(json.get("unit").getAsString()));
    if (json.has("_unit"))
      parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    return res;
  }

  protected Attachment parseAttachment(JsonObject json) throws IOException, FHIRFormatError {
    Attachment res = new Attachment();
    parseTypeProperties(json, res);
    if (json.has("contentType"))
      res.setContentTypeElement(parseCode(json.get("contentType").getAsString()));
    if (json.has("_contentType"))
      parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("data"))
      res.setDataElement(parseBase64Binary(json.get("data").getAsString()));
    if (json.has("_data"))
      parseElementProperties(json.getAsJsonObject("_data"), res.getDataElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("size"))
      res.setSizeElement(parseUnsignedInt(json.get("size").getAsString()));
    if (json.has("_size"))
      parseElementProperties(json.getAsJsonObject("_size"), res.getSizeElement());
    if (json.has("hash"))
      res.setHashElement(parseBase64Binary(json.get("hash").getAsString()));
    if (json.has("_hash"))
      parseElementProperties(json.getAsJsonObject("_hash"), res.getHashElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("creation"))
      res.setCreationElement(parseDateTime(json.get("creation").getAsString()));
    if (json.has("_creation"))
      parseElementProperties(json.getAsJsonObject("_creation"), res.getCreationElement());
    return res;
  }

  protected Ratio parseRatio(JsonObject json) throws IOException, FHIRFormatError {
    Ratio res = new Ratio();
    parseTypeProperties(json, res);
    if (json.has("numerator"))
      res.setNumerator(parseQuantity(json.getAsJsonObject("numerator")));
    if (json.has("denominator"))
      res.setDenominator(parseQuantity(json.getAsJsonObject("denominator")));
    return res;
  }

  protected Annotation parseAnnotation(JsonObject json) throws IOException, FHIRFormatError {
    Annotation res = new Annotation();
    parseTypeProperties(json, res);
    Type author = parseType("author", json);
    if (author != null)
      res.setAuthor(author);
    if (json.has("time"))
      res.setTimeElement(parseDateTime(json.get("time").getAsString()));
    if (json.has("_time"))
      parseElementProperties(json.getAsJsonObject("_time"), res.getTimeElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    return res;
  }

  protected SampledData parseSampledData(JsonObject json) throws IOException, FHIRFormatError {
    SampledData res = new SampledData();
    parseTypeProperties(json, res);
    if (json.has("origin"))
      res.setOrigin(parseSimpleQuantity(json.getAsJsonObject("origin")));
    if (json.has("period"))
      res.setPeriodElement(parseDecimal(json.get("period").getAsBigDecimal()));
    if (json.has("_period"))
      parseElementProperties(json.getAsJsonObject("_period"), res.getPeriodElement());
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("lowerLimit"))
      res.setLowerLimitElement(parseDecimal(json.get("lowerLimit").getAsBigDecimal()));
    if (json.has("_lowerLimit"))
      parseElementProperties(json.getAsJsonObject("_lowerLimit"), res.getLowerLimitElement());
    if (json.has("upperLimit"))
      res.setUpperLimitElement(parseDecimal(json.get("upperLimit").getAsBigDecimal()));
    if (json.has("_upperLimit"))
      parseElementProperties(json.getAsJsonObject("_upperLimit"), res.getUpperLimitElement());
    if (json.has("dimensions"))
      res.setDimensionsElement(parsePositiveInt(json.get("dimensions").getAsString()));
    if (json.has("_dimensions"))
      parseElementProperties(json.getAsJsonObject("_dimensions"), res.getDimensionsElement());
    if (json.has("data"))
      res.setDataElement(parseString(json.get("data").getAsString()));
    if (json.has("_data"))
      parseElementProperties(json.getAsJsonObject("_data"), res.getDataElement());
    return res;
  }

  protected Reference parseReference(JsonObject json) throws IOException, FHIRFormatError {
    Reference res = new Reference();
    parseTypeProperties(json, res);
    if (json.has("reference"))
      res.setReferenceElement(parseString(json.get("reference").getAsString()));
    if (json.has("_reference"))
      parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    return res;
  }

  protected CodeableConcept parseCodeableConcept(JsonObject json) throws IOException, FHIRFormatError {
    CodeableConcept res = new CodeableConcept();
    parseTypeProperties(json, res);
    if (json.has("coding")) {
      JsonArray array = json.getAsJsonArray("coding");
      for (int i = 0; i < array.size(); i++) {
        res.getCoding().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    return res;
  }

  protected Identifier parseIdentifier(JsonObject json) throws IOException, FHIRFormatError {
    Identifier res = new Identifier();
    parseTypeProperties(json, res);
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), Identifier.IdentifierUse.NULL,
          new Identifier.IdentifierUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("assigner"))
      res.setAssigner(parseReference(json.getAsJsonObject("assigner")));
    return res;
  }

  protected Signature parseSignature(JsonObject json) throws IOException, FHIRFormatError {
    Signature res = new Signature();
    parseTypeProperties(json, res);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("when"))
      res.setWhenElement(parseInstant(json.get("when").getAsString()));
    if (json.has("_when"))
      parseElementProperties(json.getAsJsonObject("_when"), res.getWhenElement());
    Type who = parseType("who", json);
    if (who != null)
      res.setWho(who);
    if (json.has("contentType"))
      res.setContentTypeElement(parseCode(json.get("contentType").getAsString()));
    if (json.has("_contentType"))
      parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
    if (json.has("blob"))
      res.setBlobElement(parseBase64Binary(json.get("blob").getAsString()));
    if (json.has("_blob"))
      parseElementProperties(json.getAsJsonObject("_blob"), res.getBlobElement());
    return res;
  }

  protected Age parseAge(JsonObject json) throws IOException, FHIRFormatError {
    Age res = new Age();
    parseElementProperties(json, res);
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("comparator"))
      res.setComparatorElement(parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL,
          new Quantity.QuantityComparatorEnumFactory()));
    if (json.has("_comparator"))
      parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
    if (json.has("unit"))
      res.setUnitElement(parseString(json.get("unit").getAsString()));
    if (json.has("_unit"))
      parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    return res;
  }

  protected Count parseCount(JsonObject json) throws IOException, FHIRFormatError {
    Count res = new Count();
    parseElementProperties(json, res);
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("comparator"))
      res.setComparatorElement(parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL,
          new Quantity.QuantityComparatorEnumFactory()));
    if (json.has("_comparator"))
      parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
    if (json.has("unit"))
      res.setUnitElement(parseString(json.get("unit").getAsString()));
    if (json.has("_unit"))
      parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    return res;
  }

  protected Money parseMoney(JsonObject json) throws IOException, FHIRFormatError {
    Money res = new Money();
    parseElementProperties(json, res);
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("comparator"))
      res.setComparatorElement(parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL,
          new Quantity.QuantityComparatorEnumFactory()));
    if (json.has("_comparator"))
      parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
    if (json.has("unit"))
      res.setUnitElement(parseString(json.get("unit").getAsString()));
    if (json.has("_unit"))
      parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    return res;
  }

  protected Distance parseDistance(JsonObject json) throws IOException, FHIRFormatError {
    Distance res = new Distance();
    parseElementProperties(json, res);
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("comparator"))
      res.setComparatorElement(parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL,
          new Quantity.QuantityComparatorEnumFactory()));
    if (json.has("_comparator"))
      parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
    if (json.has("unit"))
      res.setUnitElement(parseString(json.get("unit").getAsString()));
    if (json.has("_unit"))
      parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    return res;
  }

  protected Duration parseDuration(JsonObject json) throws IOException, FHIRFormatError {
    Duration res = new Duration();
    parseElementProperties(json, res);
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("comparator"))
      res.setComparatorElement(parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL,
          new Quantity.QuantityComparatorEnumFactory()));
    if (json.has("_comparator"))
      parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
    if (json.has("unit"))
      res.setUnitElement(parseString(json.get("unit").getAsString()));
    if (json.has("_unit"))
      parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    return res;
  }

  protected SimpleQuantity parseSimpleQuantity(JsonObject json) throws IOException, FHIRFormatError {
    SimpleQuantity res = new SimpleQuantity();
    parseElementProperties(json, res);
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("comparator"))
      res.setComparatorElement(parseEnumeration(json.get("comparator").getAsString(), Quantity.QuantityComparator.NULL,
          new Quantity.QuantityComparatorEnumFactory()));
    if (json.has("_comparator"))
      parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
    if (json.has("unit"))
      res.setUnitElement(parseString(json.get("unit").getAsString()));
    if (json.has("_unit"))
      parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    return res;
  }

  protected TriggerDefinition parseTriggerDefinition(JsonObject json) throws IOException, FHIRFormatError {
    TriggerDefinition res = new TriggerDefinition();
    parseElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), TriggerDefinition.TriggerType.NULL,
          new TriggerDefinition.TriggerTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("eventName"))
      res.setEventNameElement(parseString(json.get("eventName").getAsString()));
    if (json.has("_eventName"))
      parseElementProperties(json.getAsJsonObject("_eventName"), res.getEventNameElement());
    Type eventTiming = parseType("eventTiming", json);
    if (eventTiming != null)
      res.setEventTiming(eventTiming);
    if (json.has("eventData"))
      res.setEventData(parseDataRequirement(json.getAsJsonObject("eventData")));
    return res;
  }

  protected ElementDefinition parseElementDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ElementDefinition res = new ElementDefinition();
    parseElementProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("representation")) {
      JsonArray array = json.getAsJsonArray("representation");
      for (int i = 0; i < array.size(); i++) {
        res.getRepresentation().add(parseEnumeration(array.get(i).getAsString(),
            ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
      }
    }
    ;
    if (json.has("_representation")) {
      JsonArray array = json.getAsJsonArray("_representation");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getRepresentation().size())
          res.getRepresentation().add(parseEnumeration(null, ElementDefinition.PropertyRepresentation.NULL,
              new ElementDefinition.PropertyRepresentationEnumFactory()));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getRepresentation().get(i));
      }
    }
    ;
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("label"))
      res.setLabelElement(parseString(json.get("label").getAsString()));
    if (json.has("_label"))
      parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("slicing"))
      res.setSlicing(parseElementDefinitionElementDefinitionSlicingComponent(json.getAsJsonObject("slicing"), res));
    if (json.has("short"))
      res.setShortElement(parseString(json.get("short").getAsString()));
    if (json.has("_short"))
      parseElementProperties(json.getAsJsonObject("_short"), res.getShortElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseMarkdown(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
    if (json.has("comments"))
      res.setCommentsElement(parseMarkdown(json.get("comments").getAsString()));
    if (json.has("_comments"))
      parseElementProperties(json.getAsJsonObject("_comments"), res.getCommentsElement());
    if (json.has("requirements"))
      res.setRequirementsElement(parseMarkdown(json.get("requirements").getAsString()));
    if (json.has("_requirements"))
      parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
    if (json.has("alias")) {
      JsonArray array = json.getAsJsonArray("alias");
      for (int i = 0; i < array.size(); i++) {
        res.getAlias().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_alias")) {
      JsonArray array = json.getAsJsonArray("_alias");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAlias().size())
          res.getAlias().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAlias().get(i));
      }
    }
    ;
    if (json.has("min"))
      res.setMinElement(parseInteger(json.get("min").getAsLong()));
    if (json.has("_min"))
      parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
    if (json.has("base"))
      res.setBase(parseElementDefinitionElementDefinitionBaseComponent(json.getAsJsonObject("base"), res));
    if (json.has("contentReference"))
      res.setContentReferenceElement(parseUri(json.get("contentReference").getAsString()));
    if (json.has("_contentReference"))
      parseElementProperties(json.getAsJsonObject("_contentReference"), res.getContentReferenceElement());
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseElementDefinitionTypeRefComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    Type defaultValue = parseType("defaultValue", json);
    if (defaultValue != null)
      res.setDefaultValue(defaultValue);
    if (json.has("meaningWhenMissing"))
      res.setMeaningWhenMissingElement(parseMarkdown(json.get("meaningWhenMissing").getAsString()));
    if (json.has("_meaningWhenMissing"))
      parseElementProperties(json.getAsJsonObject("_meaningWhenMissing"), res.getMeaningWhenMissingElement());
    Type fixed = parseType("fixed", json);
    if (fixed != null)
      res.setFixed(fixed);
    Type pattern = parseType("pattern", json);
    if (pattern != null)
      res.setPattern(pattern);
    Type example = parseType("example", json);
    if (example != null)
      res.setExample(example);
    Type minValue = parseType("minValue", json);
    if (minValue != null)
      res.setMinValue(minValue);
    Type maxValue = parseType("maxValue", json);
    if (maxValue != null)
      res.setMaxValue(maxValue);
    if (json.has("maxLength"))
      res.setMaxLengthElement(parseInteger(json.get("maxLength").getAsLong()));
    if (json.has("_maxLength"))
      parseElementProperties(json.getAsJsonObject("_maxLength"), res.getMaxLengthElement());
    if (json.has("condition")) {
      JsonArray array = json.getAsJsonArray("condition");
      for (int i = 0; i < array.size(); i++) {
        res.getCondition().add(parseId(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_condition")) {
      JsonArray array = json.getAsJsonArray("_condition");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCondition().size())
          res.getCondition().add(parseId(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getCondition().get(i));
      }
    }
    ;
    if (json.has("constraint")) {
      JsonArray array = json.getAsJsonArray("constraint");
      for (int i = 0; i < array.size(); i++) {
        res.getConstraint()
            .add(parseElementDefinitionElementDefinitionConstraintComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("mustSupport"))
      res.setMustSupportElement(parseBoolean(json.get("mustSupport").getAsBoolean()));
    if (json.has("_mustSupport"))
      parseElementProperties(json.getAsJsonObject("_mustSupport"), res.getMustSupportElement());
    if (json.has("isModifier"))
      res.setIsModifierElement(parseBoolean(json.get("isModifier").getAsBoolean()));
    if (json.has("_isModifier"))
      parseElementProperties(json.getAsJsonObject("_isModifier"), res.getIsModifierElement());
    if (json.has("isSummary"))
      res.setIsSummaryElement(parseBoolean(json.get("isSummary").getAsBoolean()));
    if (json.has("_isSummary"))
      parseElementProperties(json.getAsJsonObject("_isSummary"), res.getIsSummaryElement());
    if (json.has("binding"))
      res.setBinding(parseElementDefinitionElementDefinitionBindingComponent(json.getAsJsonObject("binding"), res));
    if (json.has("mapping")) {
      JsonArray array = json.getAsJsonArray("mapping");
      for (int i = 0; i < array.size(); i++) {
        res.getMapping()
            .add(parseElementDefinitionElementDefinitionMappingComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected ElementDefinition.ElementDefinitionSlicingComponent parseElementDefinitionElementDefinitionSlicingComponent(
      JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionSlicingComponent res = new ElementDefinition.ElementDefinitionSlicingComponent();
    parseElementProperties(json, res);
    if (json.has("discriminator")) {
      JsonArray array = json.getAsJsonArray("discriminator");
      for (int i = 0; i < array.size(); i++) {
        res.getDiscriminator().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_discriminator")) {
      JsonArray array = json.getAsJsonArray("_discriminator");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDiscriminator().size())
          res.getDiscriminator().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDiscriminator().get(i));
      }
    }
    ;
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("ordered"))
      res.setOrderedElement(parseBoolean(json.get("ordered").getAsBoolean()));
    if (json.has("_ordered"))
      parseElementProperties(json.getAsJsonObject("_ordered"), res.getOrderedElement());
    if (json.has("rules"))
      res.setRulesElement(parseEnumeration(json.get("rules").getAsString(), ElementDefinition.SlicingRules.NULL,
          new ElementDefinition.SlicingRulesEnumFactory()));
    if (json.has("_rules"))
      parseElementProperties(json.getAsJsonObject("_rules"), res.getRulesElement());
    return res;
  }

  protected ElementDefinition.ElementDefinitionBaseComponent parseElementDefinitionElementDefinitionBaseComponent(
      JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionBaseComponent res = new ElementDefinition.ElementDefinitionBaseComponent();
    parseElementProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("min"))
      res.setMinElement(parseInteger(json.get("min").getAsLong()));
    if (json.has("_min"))
      parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
    return res;
  }

  protected ElementDefinition.TypeRefComponent parseElementDefinitionTypeRefComponent(JsonObject json,
      ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.TypeRefComponent res = new ElementDefinition.TypeRefComponent();
    parseElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("profile")) {
      JsonArray array = json.getAsJsonArray("profile");
      for (int i = 0; i < array.size(); i++) {
        res.getProfile().add(parseUri(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_profile")) {
      JsonArray array = json.getAsJsonArray("_profile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProfile().size())
          res.getProfile().add(parseUri(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProfile().get(i));
      }
    }
    ;
    if (json.has("aggregation")) {
      JsonArray array = json.getAsJsonArray("aggregation");
      for (int i = 0; i < array.size(); i++) {
        res.getAggregation().add(parseEnumeration(array.get(i).getAsString(), ElementDefinition.AggregationMode.NULL,
            new ElementDefinition.AggregationModeEnumFactory()));
      }
    }
    ;
    if (json.has("_aggregation")) {
      JsonArray array = json.getAsJsonArray("_aggregation");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAggregation().size())
          res.getAggregation().add(parseEnumeration(null, ElementDefinition.AggregationMode.NULL,
              new ElementDefinition.AggregationModeEnumFactory()));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAggregation().get(i));
      }
    }
    ;
    if (json.has("versioning"))
      res.setVersioningElement(parseEnumeration(json.get("versioning").getAsString(),
          ElementDefinition.ReferenceVersionRules.NULL, new ElementDefinition.ReferenceVersionRulesEnumFactory()));
    if (json.has("_versioning"))
      parseElementProperties(json.getAsJsonObject("_versioning"), res.getVersioningElement());
    return res;
  }

  protected ElementDefinition.ElementDefinitionConstraintComponent parseElementDefinitionElementDefinitionConstraintComponent(
      JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionConstraintComponent res = new ElementDefinition.ElementDefinitionConstraintComponent();
    parseElementProperties(json, res);
    if (json.has("key"))
      res.setKeyElement(parseId(json.get("key").getAsString()));
    if (json.has("_key"))
      parseElementProperties(json.getAsJsonObject("_key"), res.getKeyElement());
    if (json.has("requirements"))
      res.setRequirementsElement(parseString(json.get("requirements").getAsString()));
    if (json.has("_requirements"))
      parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
    if (json.has("severity"))
      res.setSeverityElement(parseEnumeration(json.get("severity").getAsString(),
          ElementDefinition.ConstraintSeverity.NULL, new ElementDefinition.ConstraintSeverityEnumFactory()));
    if (json.has("_severity"))
      parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
    if (json.has("human"))
      res.setHumanElement(parseString(json.get("human").getAsString()));
    if (json.has("_human"))
      parseElementProperties(json.getAsJsonObject("_human"), res.getHumanElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
    if (json.has("xpath"))
      res.setXpathElement(parseString(json.get("xpath").getAsString()));
    if (json.has("_xpath"))
      parseElementProperties(json.getAsJsonObject("_xpath"), res.getXpathElement());
    return res;
  }

  protected ElementDefinition.ElementDefinitionBindingComponent parseElementDefinitionElementDefinitionBindingComponent(
      JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionBindingComponent res = new ElementDefinition.ElementDefinitionBindingComponent();
    parseElementProperties(json, res);
    if (json.has("strength"))
      res.setStrengthElement(parseEnumeration(json.get("strength").getAsString(), Enumerations.BindingStrength.NULL,
          new Enumerations.BindingStrengthEnumFactory()));
    if (json.has("_strength"))
      parseElementProperties(json.getAsJsonObject("_strength"), res.getStrengthElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    Type valueSet = parseType("valueSet", json);
    if (valueSet != null)
      res.setValueSet(valueSet);
    return res;
  }

  protected ElementDefinition.ElementDefinitionMappingComponent parseElementDefinitionElementDefinitionMappingComponent(
      JsonObject json, ElementDefinition owner) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionMappingComponent res = new ElementDefinition.ElementDefinitionMappingComponent();
    parseElementProperties(json, res);
    if (json.has("identity"))
      res.setIdentityElement(parseId(json.get("identity").getAsString()));
    if (json.has("_identity"))
      parseElementProperties(json.getAsJsonObject("_identity"), res.getIdentityElement());
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("map"))
      res.setMapElement(parseString(json.get("map").getAsString()));
    if (json.has("_map"))
      parseElementProperties(json.getAsJsonObject("_map"), res.getMapElement());
    return res;
  }

  protected Timing parseTiming(JsonObject json) throws IOException, FHIRFormatError {
    Timing res = new Timing();
    parseElementProperties(json, res);
    if (json.has("event")) {
      JsonArray array = json.getAsJsonArray("event");
      for (int i = 0; i < array.size(); i++) {
        res.getEvent().add(parseDateTime(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_event")) {
      JsonArray array = json.getAsJsonArray("_event");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getEvent().size())
          res.getEvent().add(parseDateTime(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getEvent().get(i));
      }
    }
    ;
    if (json.has("repeat"))
      res.setRepeat(parseTimingTimingRepeatComponent(json.getAsJsonObject("repeat"), res));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    return res;
  }

  protected Timing.TimingRepeatComponent parseTimingTimingRepeatComponent(JsonObject json, Timing owner)
      throws IOException, FHIRFormatError {
    Timing.TimingRepeatComponent res = new Timing.TimingRepeatComponent();
    parseElementProperties(json, res);
    Type bounds = parseType("bounds", json);
    if (bounds != null)
      res.setBounds(bounds);
    if (json.has("count"))
      res.setCountElement(parseInteger(json.get("count").getAsLong()));
    if (json.has("_count"))
      parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
    if (json.has("countMax"))
      res.setCountMaxElement(parseInteger(json.get("countMax").getAsLong()));
    if (json.has("_countMax"))
      parseElementProperties(json.getAsJsonObject("_countMax"), res.getCountMaxElement());
    if (json.has("duration"))
      res.setDurationElement(parseDecimal(json.get("duration").getAsBigDecimal()));
    if (json.has("_duration"))
      parseElementProperties(json.getAsJsonObject("_duration"), res.getDurationElement());
    if (json.has("durationMax"))
      res.setDurationMaxElement(parseDecimal(json.get("durationMax").getAsBigDecimal()));
    if (json.has("_durationMax"))
      parseElementProperties(json.getAsJsonObject("_durationMax"), res.getDurationMaxElement());
    if (json.has("durationUnit"))
      res.setDurationUnitElement(parseEnumeration(json.get("durationUnit").getAsString(), Timing.UnitsOfTime.NULL,
          new Timing.UnitsOfTimeEnumFactory()));
    if (json.has("_durationUnit"))
      parseElementProperties(json.getAsJsonObject("_durationUnit"), res.getDurationUnitElement());
    if (json.has("frequency"))
      res.setFrequencyElement(parseInteger(json.get("frequency").getAsLong()));
    if (json.has("_frequency"))
      parseElementProperties(json.getAsJsonObject("_frequency"), res.getFrequencyElement());
    if (json.has("frequencyMax"))
      res.setFrequencyMaxElement(parseInteger(json.get("frequencyMax").getAsLong()));
    if (json.has("_frequencyMax"))
      parseElementProperties(json.getAsJsonObject("_frequencyMax"), res.getFrequencyMaxElement());
    if (json.has("period"))
      res.setPeriodElement(parseDecimal(json.get("period").getAsBigDecimal()));
    if (json.has("_period"))
      parseElementProperties(json.getAsJsonObject("_period"), res.getPeriodElement());
    if (json.has("periodMax"))
      res.setPeriodMaxElement(parseDecimal(json.get("periodMax").getAsBigDecimal()));
    if (json.has("_periodMax"))
      parseElementProperties(json.getAsJsonObject("_periodMax"), res.getPeriodMaxElement());
    if (json.has("periodUnit"))
      res.setPeriodUnitElement(parseEnumeration(json.get("periodUnit").getAsString(), Timing.UnitsOfTime.NULL,
          new Timing.UnitsOfTimeEnumFactory()));
    if (json.has("_periodUnit"))
      parseElementProperties(json.getAsJsonObject("_periodUnit"), res.getPeriodUnitElement());
    if (json.has("when"))
      res.setWhenElement(parseEnumeration(json.get("when").getAsString(), Timing.EventTiming.NULL,
          new Timing.EventTimingEnumFactory()));
    if (json.has("_when"))
      parseElementProperties(json.getAsJsonObject("_when"), res.getWhenElement());
    if (json.has("offset"))
      res.setOffsetElement(parseUnsignedInt(json.get("offset").getAsString()));
    if (json.has("_offset"))
      parseElementProperties(json.getAsJsonObject("_offset"), res.getOffsetElement());
    return res;
  }

  protected ModuleMetadata parseModuleMetadata(JsonObject json) throws IOException, FHIRFormatError {
    ModuleMetadata res = new ModuleMetadata();
    parseElementProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ModuleMetadata.ModuleMetadataType.NULL,
          new ModuleMetadata.ModuleMetadataTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ModuleMetadata.ModuleMetadataStatus.NULL,
          new ModuleMetadata.ModuleMetadataStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("purpose"))
      res.setPurposeElement(parseString(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("usage"))
      res.setUsageElement(parseString(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
    if (json.has("publicationDate"))
      res.setPublicationDateElement(parseDate(json.get("publicationDate").getAsString()));
    if (json.has("_publicationDate"))
      parseElementProperties(json.getAsJsonObject("_publicationDate"), res.getPublicationDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(json.getAsJsonObject("_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(json.getAsJsonObject("effectivePeriod")));
    if (json.has("coverage")) {
      JsonArray array = json.getAsJsonArray("coverage");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverage().add(parseModuleMetadataModuleMetadataCoverageComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("contributor")) {
      JsonArray array = json.getAsJsonArray("contributor");
      for (int i = 0; i < array.size(); i++) {
        res.getContributor()
            .add(parseModuleMetadataModuleMetadataContributorComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseModuleMetadataModuleMetadataContactComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("copyright"))
      res.setCopyrightElement(parseString(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("relatedResource")) {
      JsonArray array = json.getAsJsonArray("relatedResource");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedResource()
            .add(parseModuleMetadataModuleMetadataRelatedResourceComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected ModuleMetadata.ModuleMetadataCoverageComponent parseModuleMetadataModuleMetadataCoverageComponent(
      JsonObject json, ModuleMetadata owner) throws IOException, FHIRFormatError {
    ModuleMetadata.ModuleMetadataCoverageComponent res = new ModuleMetadata.ModuleMetadataCoverageComponent();
    parseElementProperties(json, res);
    if (json.has("focus"))
      res.setFocus(parseCoding(json.getAsJsonObject("focus")));
    if (json.has("value"))
      res.setValue(parseCodeableConcept(json.getAsJsonObject("value")));
    return res;
  }

  protected ModuleMetadata.ModuleMetadataContributorComponent parseModuleMetadataModuleMetadataContributorComponent(
      JsonObject json, ModuleMetadata owner) throws IOException, FHIRFormatError {
    ModuleMetadata.ModuleMetadataContributorComponent res = new ModuleMetadata.ModuleMetadataContributorComponent();
    parseElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(
          parseEnumeration(json.get("type").getAsString(), ModuleMetadata.ModuleMetadataContributorType.NULL,
              new ModuleMetadata.ModuleMetadataContributorTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact()
            .add(parseModuleMetadataModuleMetadataContributorContactComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ModuleMetadata.ModuleMetadataContributorContactComponent parseModuleMetadataModuleMetadataContributorContactComponent(
      JsonObject json, ModuleMetadata owner) throws IOException, FHIRFormatError {
    ModuleMetadata.ModuleMetadataContributorContactComponent res = new ModuleMetadata.ModuleMetadataContributorContactComponent();
    parseElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected ModuleMetadata.ModuleMetadataContactComponent parseModuleMetadataModuleMetadataContactComponent(
      JsonObject json, ModuleMetadata owner) throws IOException, FHIRFormatError {
    ModuleMetadata.ModuleMetadataContactComponent res = new ModuleMetadata.ModuleMetadataContactComponent();
    parseElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected ModuleMetadata.ModuleMetadataRelatedResourceComponent parseModuleMetadataModuleMetadataRelatedResourceComponent(
      JsonObject json, ModuleMetadata owner) throws IOException, FHIRFormatError {
    ModuleMetadata.ModuleMetadataRelatedResourceComponent res = new ModuleMetadata.ModuleMetadataRelatedResourceComponent();
    parseElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(),
          ModuleMetadata.ModuleMetadataResourceType.NULL, new ModuleMetadata.ModuleMetadataResourceTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("document"))
      res.setDocument(parseAttachment(json.getAsJsonObject("document")));
    if (json.has("resource"))
      res.setResource(parseReference(json.getAsJsonObject("resource")));
    return res;
  }

  protected ActionDefinition parseActionDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ActionDefinition res = new ActionDefinition();
    parseElementProperties(json, res);
    if (json.has("actionIdentifier"))
      res.setActionIdentifier(parseIdentifier(json.getAsJsonObject("actionIdentifier")));
    if (json.has("label"))
      res.setLabelElement(parseString(json.get("label").getAsString()));
    if (json.has("_label"))
      parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("textEquivalent"))
      res.setTextEquivalentElement(parseString(json.get("textEquivalent").getAsString()));
    if (json.has("_textEquivalent"))
      parseElementProperties(json.getAsJsonObject("_textEquivalent"), res.getTextEquivalentElement());
    if (json.has("concept")) {
      JsonArray array = json.getAsJsonArray("concept");
      for (int i = 0; i < array.size(); i++) {
        res.getConcept().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("supportingEvidence")) {
      JsonArray array = json.getAsJsonArray("supportingEvidence");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingEvidence().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("documentation")) {
      JsonArray array = json.getAsJsonArray("documentation");
      for (int i = 0; i < array.size(); i++) {
        res.getDocumentation().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("relatedAction"))
      res.setRelatedAction(
          parseActionDefinitionActionDefinitionRelatedActionComponent(json.getAsJsonObject("relatedAction"), res));
    if (json.has("participantType")) {
      JsonArray array = json.getAsJsonArray("participantType");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipantType().add(parseEnumeration(array.get(i).getAsString(), ActionDefinition.ParticipantType.NULL,
            new ActionDefinition.ParticipantTypeEnumFactory()));
      }
    }
    ;
    if (json.has("_participantType")) {
      JsonArray array = json.getAsJsonArray("_participantType");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getParticipantType().size())
          res.getParticipantType().add(parseEnumeration(null, ActionDefinition.ParticipantType.NULL,
              new ActionDefinition.ParticipantTypeEnumFactory()));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getParticipantType().get(i));
      }
    }
    ;
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ActionDefinition.ActionType.NULL,
          new ActionDefinition.ActionTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("behavior")) {
      JsonArray array = json.getAsJsonArray("behavior");
      for (int i = 0; i < array.size(); i++) {
        res.getBehavior()
            .add(parseActionDefinitionActionDefinitionBehaviorComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("resource"))
      res.setResource(parseReference(json.getAsJsonObject("resource")));
    if (json.has("customization")) {
      JsonArray array = json.getAsJsonArray("customization");
      for (int i = 0; i < array.size(); i++) {
        res.getCustomization()
            .add(parseActionDefinitionActionDefinitionCustomizationComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseActionDefinition(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected ActionDefinition.ActionDefinitionRelatedActionComponent parseActionDefinitionActionDefinitionRelatedActionComponent(
      JsonObject json, ActionDefinition owner) throws IOException, FHIRFormatError {
    ActionDefinition.ActionDefinitionRelatedActionComponent res = new ActionDefinition.ActionDefinitionRelatedActionComponent();
    parseElementProperties(json, res);
    if (json.has("actionIdentifier"))
      res.setActionIdentifier(parseIdentifier(json.getAsJsonObject("actionIdentifier")));
    if (json.has("relationship"))
      res.setRelationshipElement(parseEnumeration(json.get("relationship").getAsString(),
          ActionDefinition.ActionRelationshipType.NULL, new ActionDefinition.ActionRelationshipTypeEnumFactory()));
    if (json.has("_relationship"))
      parseElementProperties(json.getAsJsonObject("_relationship"), res.getRelationshipElement());
    Type offset = parseType("offset", json);
    if (offset != null)
      res.setOffset(offset);
    if (json.has("anchor"))
      res.setAnchorElement(parseEnumeration(json.get("anchor").getAsString(),
          ActionDefinition.ActionRelationshipAnchor.NULL, new ActionDefinition.ActionRelationshipAnchorEnumFactory()));
    if (json.has("_anchor"))
      parseElementProperties(json.getAsJsonObject("_anchor"), res.getAnchorElement());
    return res;
  }

  protected ActionDefinition.ActionDefinitionBehaviorComponent parseActionDefinitionActionDefinitionBehaviorComponent(
      JsonObject json, ActionDefinition owner) throws IOException, FHIRFormatError {
    ActionDefinition.ActionDefinitionBehaviorComponent res = new ActionDefinition.ActionDefinitionBehaviorComponent();
    parseElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("value"))
      res.setValue(parseCoding(json.getAsJsonObject("value")));
    return res;
  }

  protected ActionDefinition.ActionDefinitionCustomizationComponent parseActionDefinitionActionDefinitionCustomizationComponent(
      JsonObject json, ActionDefinition owner) throws IOException, FHIRFormatError {
    ActionDefinition.ActionDefinitionCustomizationComponent res = new ActionDefinition.ActionDefinitionCustomizationComponent();
    parseElementProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
    return res;
  }

  protected Address parseAddress(JsonObject json) throws IOException, FHIRFormatError {
    Address res = new Address();
    parseElementProperties(json, res);
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), Address.AddressUse.NULL,
          new Address.AddressUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Address.AddressType.NULL,
          new Address.AddressTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("line")) {
      JsonArray array = json.getAsJsonArray("line");
      for (int i = 0; i < array.size(); i++) {
        res.getLine().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_line")) {
      JsonArray array = json.getAsJsonArray("_line");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLine().size())
          res.getLine().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLine().get(i));
      }
    }
    ;
    if (json.has("city"))
      res.setCityElement(parseString(json.get("city").getAsString()));
    if (json.has("_city"))
      parseElementProperties(json.getAsJsonObject("_city"), res.getCityElement());
    if (json.has("district"))
      res.setDistrictElement(parseString(json.get("district").getAsString()));
    if (json.has("_district"))
      parseElementProperties(json.getAsJsonObject("_district"), res.getDistrictElement());
    if (json.has("state"))
      res.setStateElement(parseString(json.get("state").getAsString()));
    if (json.has("_state"))
      parseElementProperties(json.getAsJsonObject("_state"), res.getStateElement());
    if (json.has("postalCode"))
      res.setPostalCodeElement(parseString(json.get("postalCode").getAsString()));
    if (json.has("_postalCode"))
      parseElementProperties(json.getAsJsonObject("_postalCode"), res.getPostalCodeElement());
    if (json.has("country"))
      res.setCountryElement(parseString(json.get("country").getAsString()));
    if (json.has("_country"))
      parseElementProperties(json.getAsJsonObject("_country"), res.getCountryElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    return res;
  }

  protected HumanName parseHumanName(JsonObject json) throws IOException, FHIRFormatError {
    HumanName res = new HumanName();
    parseElementProperties(json, res);
    if (json.has("use"))
      res.setUseElement(
          parseEnumeration(json.get("use").getAsString(), HumanName.NameUse.NULL, new HumanName.NameUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("family")) {
      JsonArray array = json.getAsJsonArray("family");
      for (int i = 0; i < array.size(); i++) {
        res.getFamily().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_family")) {
      JsonArray array = json.getAsJsonArray("_family");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getFamily().size())
          res.getFamily().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getFamily().get(i));
      }
    }
    ;
    if (json.has("given")) {
      JsonArray array = json.getAsJsonArray("given");
      for (int i = 0; i < array.size(); i++) {
        res.getGiven().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_given")) {
      JsonArray array = json.getAsJsonArray("_given");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getGiven().size())
          res.getGiven().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getGiven().get(i));
      }
    }
    ;
    if (json.has("prefix")) {
      JsonArray array = json.getAsJsonArray("prefix");
      for (int i = 0; i < array.size(); i++) {
        res.getPrefix().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_prefix")) {
      JsonArray array = json.getAsJsonArray("_prefix");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPrefix().size())
          res.getPrefix().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPrefix().get(i));
      }
    }
    ;
    if (json.has("suffix")) {
      JsonArray array = json.getAsJsonArray("suffix");
      for (int i = 0; i < array.size(); i++) {
        res.getSuffix().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_suffix")) {
      JsonArray array = json.getAsJsonArray("_suffix");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSuffix().size())
          res.getSuffix().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSuffix().get(i));
      }
    }
    ;
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    return res;
  }

  protected DataRequirement parseDataRequirement(JsonObject json) throws IOException, FHIRFormatError {
    DataRequirement res = new DataRequirement();
    parseElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("profile"))
      res.setProfile(parseReference(json.getAsJsonObject("profile")));
    if (json.has("mustSupport")) {
      JsonArray array = json.getAsJsonArray("mustSupport");
      for (int i = 0; i < array.size(); i++) {
        res.getMustSupport().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_mustSupport")) {
      JsonArray array = json.getAsJsonArray("_mustSupport");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getMustSupport().size())
          res.getMustSupport().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getMustSupport().get(i));
      }
    }
    ;
    if (json.has("codeFilter")) {
      JsonArray array = json.getAsJsonArray("codeFilter");
      for (int i = 0; i < array.size(); i++) {
        res.getCodeFilter()
            .add(parseDataRequirementDataRequirementCodeFilterComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("dateFilter")) {
      JsonArray array = json.getAsJsonArray("dateFilter");
      for (int i = 0; i < array.size(); i++) {
        res.getDateFilter()
            .add(parseDataRequirementDataRequirementDateFilterComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected DataRequirement.DataRequirementCodeFilterComponent parseDataRequirementDataRequirementCodeFilterComponent(
      JsonObject json, DataRequirement owner) throws IOException, FHIRFormatError {
    DataRequirement.DataRequirementCodeFilterComponent res = new DataRequirement.DataRequirementCodeFilterComponent();
    parseElementProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    Type valueSet = parseType("valueSet", json);
    if (valueSet != null)
      res.setValueSet(valueSet);
    if (json.has("valueCode")) {
      JsonArray array = json.getAsJsonArray("valueCode");
      for (int i = 0; i < array.size(); i++) {
        res.getValueCode().add(parseCode(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_valueCode")) {
      JsonArray array = json.getAsJsonArray("_valueCode");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getValueCode().size())
          res.getValueCode().add(parseCode(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getValueCode().get(i));
      }
    }
    ;
    if (json.has("valueCoding")) {
      JsonArray array = json.getAsJsonArray("valueCoding");
      for (int i = 0; i < array.size(); i++) {
        res.getValueCoding().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("valueCodeableConcept")) {
      JsonArray array = json.getAsJsonArray("valueCodeableConcept");
      for (int i = 0; i < array.size(); i++) {
        res.getValueCodeableConcept().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected DataRequirement.DataRequirementDateFilterComponent parseDataRequirementDataRequirementDateFilterComponent(
      JsonObject json, DataRequirement owner) throws IOException, FHIRFormatError {
    DataRequirement.DataRequirementDateFilterComponent res = new DataRequirement.DataRequirementDateFilterComponent();
    parseElementProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    return res;
  }

  protected Meta parseMeta(JsonObject json) throws IOException, FHIRFormatError {
    Meta res = new Meta();
    parseElementProperties(json, res);
    if (json.has("versionId"))
      res.setVersionIdElement(parseId(json.get("versionId").getAsString()));
    if (json.has("_versionId"))
      parseElementProperties(json.getAsJsonObject("_versionId"), res.getVersionIdElement());
    if (json.has("lastUpdated"))
      res.setLastUpdatedElement(parseInstant(json.get("lastUpdated").getAsString()));
    if (json.has("_lastUpdated"))
      parseElementProperties(json.getAsJsonObject("_lastUpdated"), res.getLastUpdatedElement());
    if (json.has("profile")) {
      JsonArray array = json.getAsJsonArray("profile");
      for (int i = 0; i < array.size(); i++) {
        res.getProfile().add(parseUri(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_profile")) {
      JsonArray array = json.getAsJsonArray("_profile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProfile().size())
          res.getProfile().add(parseUri(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProfile().get(i));
      }
    }
    ;
    if (json.has("security")) {
      JsonArray array = json.getAsJsonArray("security");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurity().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("tag")) {
      JsonArray array = json.getAsJsonArray("tag");
      for (int i = 0; i < array.size(); i++) {
        res.getTag().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected ParameterDefinition parseParameterDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ParameterDefinition res = new ParameterDefinition();
    parseElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseCode(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("use"))
      res.setUseElement(parseCode(json.get("use").getAsString()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("min"))
      res.setMinElement(parseInteger(json.get("min").getAsLong()));
    if (json.has("_min"))
      parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("profile"))
      res.setProfile(parseReference(json.getAsJsonObject("profile")));
    return res;
  }

  protected ContactPoint parseContactPoint(JsonObject json) throws IOException, FHIRFormatError {
    ContactPoint res = new ContactPoint();
    parseElementProperties(json, res);
    if (json.has("system"))
      res.setSystemElement(parseEnumeration(json.get("system").getAsString(), ContactPoint.ContactPointSystem.NULL,
          new ContactPoint.ContactPointSystemEnumFactory()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), ContactPoint.ContactPointUse.NULL,
          new ContactPoint.ContactPointUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("rank"))
      res.setRankElement(parsePositiveInt(json.get("rank").getAsString()));
    if (json.has("_rank"))
      parseElementProperties(json.getAsJsonObject("_rank"), res.getRankElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    return res;
  }

  protected Parameters parseParameters(JsonObject json) throws IOException, FHIRFormatError {
    Parameters res = new Parameters();
    parseResourceProperties(json, res);
    if (json.has("parameter")) {
      JsonArray array = json.getAsJsonArray("parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter().add(parseParametersParametersParameterComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected Parameters.ParametersParameterComponent parseParametersParametersParameterComponent(JsonObject json,
      Parameters owner) throws IOException, FHIRFormatError {
    Parameters.ParametersParameterComponent res = new Parameters.ParametersParameterComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("resource"))
      res.setResource(parseResource(json.getAsJsonObject("resource")));
    if (json.has("part")) {
      JsonArray array = json.getAsJsonArray("part");
      for (int i = 0; i < array.size(); i++) {
        res.getPart().add(parseParametersParametersParameterComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected void parseResourceProperties(JsonObject json, Resource res) throws IOException, FHIRFormatError {
    if (json.has("id"))
      res.setIdElement(parseId(json.get("id").getAsString()));
    if (json.has("_id"))
      parseElementProperties(json.getAsJsonObject("_id"), res.getIdElement());
    if (json.has("meta"))
      res.setMeta(parseMeta(json.getAsJsonObject("meta")));
    if (json.has("implicitRules"))
      res.setImplicitRulesElement(parseUri(json.get("implicitRules").getAsString()));
    if (json.has("_implicitRules"))
      parseElementProperties(json.getAsJsonObject("_implicitRules"), res.getImplicitRulesElement());
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
  }

  protected void parseDomainResourceProperties(JsonObject json, DomainResource res)
      throws IOException, FHIRFormatError {
    parseResourceProperties(json, res);
    if (json.has("text"))
      res.setText(parseNarrative(json.getAsJsonObject("text")));
    if (json.has("contained")) {
      JsonArray array = json.getAsJsonArray("contained");
      for (int i = 0; i < array.size(); i++) {
        res.getContained().add(parseResource(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("extension")) {
      JsonArray array = json.getAsJsonArray("extension");
      for (int i = 0; i < array.size(); i++) {
        res.getExtension().add(parseExtension(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("modifierExtension")) {
      JsonArray array = json.getAsJsonArray("modifierExtension");
      for (int i = 0; i < array.size(); i++) {
        res.getModifierExtension().add(parseExtension(array.get(i).getAsJsonObject()));
      }
    }
    ;
  }

  protected Account parseAccount(JsonObject json) throws IOException, FHIRFormatError {
    Account res = new Account();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Account.AccountStatus.NULL,
          new Account.AccountStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("activePeriod"))
      res.setActivePeriod(parsePeriod(json.getAsJsonObject("activePeriod")));
    if (json.has("currency"))
      res.setCurrency(parseCoding(json.getAsJsonObject("currency")));
    if (json.has("balance"))
      res.setBalance(parseMoney(json.getAsJsonObject("balance")));
    if (json.has("coveragePeriod"))
      res.setCoveragePeriod(parsePeriod(json.getAsJsonObject("coveragePeriod")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("owner"))
      res.setOwner(parseReference(json.getAsJsonObject("owner")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    return res;
  }

  protected AllergyIntolerance parseAllergyIntolerance(JsonObject json) throws IOException, FHIRFormatError {
    AllergyIntolerance res = new AllergyIntolerance();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("status"))
      res.setStatusElement(
          parseEnumeration(json.get("status").getAsString(), AllergyIntolerance.AllergyIntoleranceStatus.NULL,
              new AllergyIntolerance.AllergyIntoleranceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(),
          AllergyIntolerance.AllergyIntoleranceType.NULL, new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("category"))
      res.setCategoryElement(
          parseEnumeration(json.get("category").getAsString(), AllergyIntolerance.AllergyIntoleranceCategory.NULL,
              new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
    if (json.has("_category"))
      parseElementProperties(json.getAsJsonObject("_category"), res.getCategoryElement());
    if (json.has("criticality"))
      res.setCriticalityElement(
          parseEnumeration(json.get("criticality").getAsString(), AllergyIntolerance.AllergyIntoleranceCriticality.NULL,
              new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory()));
    if (json.has("_criticality"))
      parseElementProperties(json.getAsJsonObject("_criticality"), res.getCriticalityElement());
    if (json.has("substance"))
      res.setSubstance(parseCodeableConcept(json.getAsJsonObject("substance")));
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("recordedDate"))
      res.setRecordedDateElement(parseDateTime(json.get("recordedDate").getAsString()));
    if (json.has("_recordedDate"))
      parseElementProperties(json.getAsJsonObject("_recordedDate"), res.getRecordedDateElement());
    if (json.has("recorder"))
      res.setRecorder(parseReference(json.getAsJsonObject("recorder")));
    if (json.has("reporter"))
      res.setReporter(parseReference(json.getAsJsonObject("reporter")));
    if (json.has("onset"))
      res.setOnsetElement(parseDateTime(json.get("onset").getAsString()));
    if (json.has("_onset"))
      parseElementProperties(json.getAsJsonObject("_onset"), res.getOnsetElement());
    if (json.has("lastOccurence"))
      res.setLastOccurenceElement(parseDateTime(json.get("lastOccurence").getAsString()));
    if (json.has("_lastOccurence"))
      parseElementProperties(json.getAsJsonObject("_lastOccurence"), res.getLastOccurenceElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("reaction")) {
      JsonArray array = json.getAsJsonArray("reaction");
      for (int i = 0; i < array.size(); i++) {
        res.getReaction()
            .add(parseAllergyIntoleranceAllergyIntoleranceReactionComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected AllergyIntolerance.AllergyIntoleranceReactionComponent parseAllergyIntoleranceAllergyIntoleranceReactionComponent(
      JsonObject json, AllergyIntolerance owner) throws IOException, FHIRFormatError {
    AllergyIntolerance.AllergyIntoleranceReactionComponent res = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
    parseBackboneProperties(json, res);
    if (json.has("substance"))
      res.setSubstance(parseCodeableConcept(json.getAsJsonObject("substance")));
    if (json.has("certainty"))
      res.setCertaintyElement(
          parseEnumeration(json.get("certainty").getAsString(), AllergyIntolerance.AllergyIntoleranceCertainty.NULL,
              new AllergyIntolerance.AllergyIntoleranceCertaintyEnumFactory()));
    if (json.has("_certainty"))
      parseElementProperties(json.getAsJsonObject("_certainty"), res.getCertaintyElement());
    if (json.has("manifestation")) {
      JsonArray array = json.getAsJsonArray("manifestation");
      for (int i = 0; i < array.size(); i++) {
        res.getManifestation().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("onset"))
      res.setOnsetElement(parseDateTime(json.get("onset").getAsString()));
    if (json.has("_onset"))
      parseElementProperties(json.getAsJsonObject("_onset"), res.getOnsetElement());
    if (json.has("severity"))
      res.setSeverityElement(
          parseEnumeration(json.get("severity").getAsString(), AllergyIntolerance.AllergyIntoleranceSeverity.NULL,
              new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory()));
    if (json.has("_severity"))
      parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
    if (json.has("exposureRoute"))
      res.setExposureRoute(parseCodeableConcept(json.getAsJsonObject("exposureRoute")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected Appointment parseAppointment(JsonObject json) throws IOException, FHIRFormatError {
    Appointment res = new Appointment();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Appointment.AppointmentStatus.NULL,
          new Appointment.AppointmentStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("serviceCategory"))
      res.setServiceCategory(parseCodeableConcept(json.getAsJsonObject("serviceCategory")));
    if (json.has("serviceType")) {
      JsonArray array = json.getAsJsonArray("serviceType");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("specialty")) {
      JsonArray array = json.getAsJsonArray("specialty");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialty().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("appointmentType"))
      res.setAppointmentType(parseCodeableConcept(json.getAsJsonObject("appointmentType")));
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(json.getAsJsonObject("reason")));
    if (json.has("priority"))
      res.setPriorityElement(parseUnsignedInt(json.get("priority").getAsString()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("start"))
      res.setStartElement(parseInstant(json.get("start").getAsString()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInstant(json.get("end").getAsString()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
    if (json.has("minutesDuration"))
      res.setMinutesDurationElement(parsePositiveInt(json.get("minutesDuration").getAsString()));
    if (json.has("_minutesDuration"))
      parseElementProperties(json.getAsJsonObject("_minutesDuration"), res.getMinutesDurationElement());
    if (json.has("slot")) {
      JsonArray array = json.getAsJsonArray("slot");
      for (int i = 0; i < array.size(); i++) {
        res.getSlot().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseAppointmentAppointmentParticipantComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected Appointment.AppointmentParticipantComponent parseAppointmentAppointmentParticipantComponent(JsonObject json,
      Appointment owner) throws IOException, FHIRFormatError {
    Appointment.AppointmentParticipantComponent res = new Appointment.AppointmentParticipantComponent();
    parseBackboneProperties(json, res);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
    if (json.has("required"))
      res.setRequiredElement(parseEnumeration(json.get("required").getAsString(), Appointment.ParticipantRequired.NULL,
          new Appointment.ParticipantRequiredEnumFactory()));
    if (json.has("_required"))
      parseElementProperties(json.getAsJsonObject("_required"), res.getRequiredElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Appointment.ParticipationStatus.NULL,
          new Appointment.ParticipationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    return res;
  }

  protected AppointmentResponse parseAppointmentResponse(JsonObject json) throws IOException, FHIRFormatError {
    AppointmentResponse res = new AppointmentResponse();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("appointment"))
      res.setAppointment(parseReference(json.getAsJsonObject("appointment")));
    if (json.has("start"))
      res.setStartElement(parseInstant(json.get("start").getAsString()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInstant(json.get("end").getAsString()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
    if (json.has("participantType")) {
      JsonArray array = json.getAsJsonArray("participantType");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipantType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
    if (json.has("participantStatus"))
      res.setParticipantStatusElement(parseCode(json.get("participantStatus").getAsString()));
    if (json.has("_participantStatus"))
      parseElementProperties(json.getAsJsonObject("_participantStatus"), res.getParticipantStatusElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    return res;
  }

  protected AuditEvent parseAuditEvent(JsonObject json) throws IOException, FHIRFormatError {
    AuditEvent res = new AuditEvent();
    parseDomainResourceProperties(json, res);
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("subtype")) {
      JsonArray array = json.getAsJsonArray("subtype");
      for (int i = 0; i < array.size(); i++) {
        res.getSubtype().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("action"))
      res.setActionElement(parseEnumeration(json.get("action").getAsString(), AuditEvent.AuditEventAction.NULL,
          new AuditEvent.AuditEventActionEnumFactory()));
    if (json.has("_action"))
      parseElementProperties(json.getAsJsonObject("_action"), res.getActionElement());
    if (json.has("recorded"))
      res.setRecordedElement(parseInstant(json.get("recorded").getAsString()));
    if (json.has("_recorded"))
      parseElementProperties(json.getAsJsonObject("_recorded"), res.getRecordedElement());
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), AuditEvent.AuditEventOutcome.NULL,
          new AuditEvent.AuditEventOutcomeEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
    if (json.has("outcomeDesc"))
      res.setOutcomeDescElement(parseString(json.get("outcomeDesc").getAsString()));
    if (json.has("_outcomeDesc"))
      parseElementProperties(json.getAsJsonObject("_outcomeDesc"), res.getOutcomeDescElement());
    if (json.has("purposeOfEvent")) {
      JsonArray array = json.getAsJsonArray("purposeOfEvent");
      for (int i = 0; i < array.size(); i++) {
        res.getPurposeOfEvent().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("agent")) {
      JsonArray array = json.getAsJsonArray("agent");
      for (int i = 0; i < array.size(); i++) {
        res.getAgent().add(parseAuditEventAuditEventAgentComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("source"))
      res.setSource(parseAuditEventAuditEventSourceComponent(json.getAsJsonObject("source"), res));
    if (json.has("entity")) {
      JsonArray array = json.getAsJsonArray("entity");
      for (int i = 0; i < array.size(); i++) {
        res.getEntity().add(parseAuditEventAuditEventEntityComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected AuditEvent.AuditEventAgentComponent parseAuditEventAuditEventAgentComponent(JsonObject json,
      AuditEvent owner) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventAgentComponent res = new AuditEvent.AuditEventAgentComponent();
    parseBackboneProperties(json, res);
    if (json.has("role")) {
      JsonArray array = json.getAsJsonArray("role");
      for (int i = 0; i < array.size(); i++) {
        res.getRole().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("reference"))
      res.setReference(parseReference(json.getAsJsonObject("reference")));
    if (json.has("userId"))
      res.setUserId(parseIdentifier(json.getAsJsonObject("userId")));
    if (json.has("altId"))
      res.setAltIdElement(parseString(json.get("altId").getAsString()));
    if (json.has("_altId"))
      parseElementProperties(json.getAsJsonObject("_altId"), res.getAltIdElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("requestor"))
      res.setRequestorElement(parseBoolean(json.get("requestor").getAsBoolean()));
    if (json.has("_requestor"))
      parseElementProperties(json.getAsJsonObject("_requestor"), res.getRequestorElement());
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("policy")) {
      JsonArray array = json.getAsJsonArray("policy");
      for (int i = 0; i < array.size(); i++) {
        res.getPolicy().add(parseUri(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_policy")) {
      JsonArray array = json.getAsJsonArray("_policy");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPolicy().size())
          res.getPolicy().add(parseUri(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPolicy().get(i));
      }
    }
    ;
    if (json.has("media"))
      res.setMedia(parseCoding(json.getAsJsonObject("media")));
    if (json.has("network"))
      res.setNetwork(parseAuditEventAuditEventAgentNetworkComponent(json.getAsJsonObject("network"), owner));
    if (json.has("purposeOfUse")) {
      JsonArray array = json.getAsJsonArray("purposeOfUse");
      for (int i = 0; i < array.size(); i++) {
        res.getPurposeOfUse().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected AuditEvent.AuditEventAgentNetworkComponent parseAuditEventAuditEventAgentNetworkComponent(JsonObject json,
      AuditEvent owner) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventAgentNetworkComponent res = new AuditEvent.AuditEventAgentNetworkComponent();
    parseBackboneProperties(json, res);
    if (json.has("address"))
      res.setAddressElement(parseString(json.get("address").getAsString()));
    if (json.has("_address"))
      parseElementProperties(json.getAsJsonObject("_address"), res.getAddressElement());
    if (json.has("type"))
      res.setTypeElement(
          parseEnumeration(json.get("type").getAsString(), AuditEvent.AuditEventParticipantNetworkType.NULL,
              new AuditEvent.AuditEventParticipantNetworkTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    return res;
  }

  protected AuditEvent.AuditEventSourceComponent parseAuditEventAuditEventSourceComponent(JsonObject json,
      AuditEvent owner) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventSourceComponent res = new AuditEvent.AuditEventSourceComponent();
    parseBackboneProperties(json, res);
    if (json.has("site"))
      res.setSiteElement(parseString(json.get("site").getAsString()));
    if (json.has("_site"))
      parseElementProperties(json.getAsJsonObject("_site"), res.getSiteElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected AuditEvent.AuditEventEntityComponent parseAuditEventAuditEventEntityComponent(JsonObject json,
      AuditEvent owner) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventEntityComponent res = new AuditEvent.AuditEventEntityComponent();
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("reference"))
      res.setReference(parseReference(json.getAsJsonObject("reference")));
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("role"))
      res.setRole(parseCoding(json.getAsJsonObject("role")));
    if (json.has("lifecycle"))
      res.setLifecycle(parseCoding(json.getAsJsonObject("lifecycle")));
    if (json.has("securityLabel")) {
      JsonArray array = json.getAsJsonArray("securityLabel");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabel().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("query"))
      res.setQueryElement(parseBase64Binary(json.get("query").getAsString()));
    if (json.has("_query"))
      parseElementProperties(json.getAsJsonObject("_query"), res.getQueryElement());
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseAuditEventAuditEventEntityDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected AuditEvent.AuditEventEntityDetailComponent parseAuditEventAuditEventEntityDetailComponent(JsonObject json,
      AuditEvent owner) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventEntityDetailComponent res = new AuditEvent.AuditEventEntityDetailComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseString(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("value"))
      res.setValueElement(parseBase64Binary(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    return res;
  }

  protected Basic parseBasic(JsonObject json) throws IOException, FHIRFormatError {
    Basic res = new Basic();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("created"))
      res.setCreatedElement(parseDate(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    return res;
  }

  protected Binary parseBinary(JsonObject json) throws IOException, FHIRFormatError {
    Binary res = new Binary();
    parseResourceProperties(json, res);
    if (json.has("contentType"))
      res.setContentTypeElement(parseCode(json.get("contentType").getAsString()));
    if (json.has("_contentType"))
      parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
    if (json.has("content"))
      res.setContentElement(parseBase64Binary(json.get("content").getAsString()));
    if (json.has("_content"))
      parseElementProperties(json.getAsJsonObject("_content"), res.getContentElement());
    return res;
  }

  protected BodySite parseBodySite(JsonObject json) throws IOException, FHIRFormatError {
    BodySite res = new BodySite();
    parseDomainResourceProperties(json, res);
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("image")) {
      JsonArray array = json.getAsJsonArray("image");
      for (int i = 0; i < array.size(); i++) {
        res.getImage().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected Bundle parseBundle(JsonObject json) throws IOException, FHIRFormatError {
    Bundle res = new Bundle();
    parseResourceProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(
          parseEnumeration(json.get("type").getAsString(), Bundle.BundleType.NULL, new Bundle.BundleTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("total"))
      res.setTotalElement(parseUnsignedInt(json.get("total").getAsString()));
    if (json.has("_total"))
      parseElementProperties(json.getAsJsonObject("_total"), res.getTotalElement());
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseBundleBundleLinkComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("entry")) {
      JsonArray array = json.getAsJsonArray("entry");
      for (int i = 0; i < array.size(); i++) {
        res.getEntry().add(parseBundleBundleEntryComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("signature"))
      res.setSignature(parseSignature(json.getAsJsonObject("signature")));
    return res;
  }

  protected Bundle.BundleLinkComponent parseBundleBundleLinkComponent(JsonObject json, Bundle owner)
      throws IOException, FHIRFormatError {
    Bundle.BundleLinkComponent res = new Bundle.BundleLinkComponent();
    parseBackboneProperties(json, res);
    if (json.has("relation"))
      res.setRelationElement(parseString(json.get("relation").getAsString()));
    if (json.has("_relation"))
      parseElementProperties(json.getAsJsonObject("_relation"), res.getRelationElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    return res;
  }

  protected Bundle.BundleEntryComponent parseBundleBundleEntryComponent(JsonObject json, Bundle owner)
      throws IOException, FHIRFormatError {
    Bundle.BundleEntryComponent res = new Bundle.BundleEntryComponent();
    parseBackboneProperties(json, res);
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseBundleBundleLinkComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("fullUrl"))
      res.setFullUrlElement(parseUri(json.get("fullUrl").getAsString()));
    if (json.has("_fullUrl"))
      parseElementProperties(json.getAsJsonObject("_fullUrl"), res.getFullUrlElement());
    if (json.has("resource"))
      res.setResource(parseResource(json.getAsJsonObject("resource")));
    if (json.has("search"))
      res.setSearch(parseBundleBundleEntrySearchComponent(json.getAsJsonObject("search"), owner));
    if (json.has("request"))
      res.setRequest(parseBundleBundleEntryRequestComponent(json.getAsJsonObject("request"), owner));
    if (json.has("response"))
      res.setResponse(parseBundleBundleEntryResponseComponent(json.getAsJsonObject("response"), owner));
    return res;
  }

  protected Bundle.BundleEntrySearchComponent parseBundleBundleEntrySearchComponent(JsonObject json, Bundle owner)
      throws IOException, FHIRFormatError {
    Bundle.BundleEntrySearchComponent res = new Bundle.BundleEntrySearchComponent();
    parseBackboneProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Bundle.SearchEntryMode.NULL,
          new Bundle.SearchEntryModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("score"))
      res.setScoreElement(parseDecimal(json.get("score").getAsBigDecimal()));
    if (json.has("_score"))
      parseElementProperties(json.getAsJsonObject("_score"), res.getScoreElement());
    return res;
  }

  protected Bundle.BundleEntryRequestComponent parseBundleBundleEntryRequestComponent(JsonObject json, Bundle owner)
      throws IOException, FHIRFormatError {
    Bundle.BundleEntryRequestComponent res = new Bundle.BundleEntryRequestComponent();
    parseBackboneProperties(json, res);
    if (json.has("method"))
      res.setMethodElement(
          parseEnumeration(json.get("method").getAsString(), Bundle.HTTPVerb.NULL, new Bundle.HTTPVerbEnumFactory()));
    if (json.has("_method"))
      parseElementProperties(json.getAsJsonObject("_method"), res.getMethodElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("ifNoneMatch"))
      res.setIfNoneMatchElement(parseString(json.get("ifNoneMatch").getAsString()));
    if (json.has("_ifNoneMatch"))
      parseElementProperties(json.getAsJsonObject("_ifNoneMatch"), res.getIfNoneMatchElement());
    if (json.has("ifModifiedSince"))
      res.setIfModifiedSinceElement(parseInstant(json.get("ifModifiedSince").getAsString()));
    if (json.has("_ifModifiedSince"))
      parseElementProperties(json.getAsJsonObject("_ifModifiedSince"), res.getIfModifiedSinceElement());
    if (json.has("ifMatch"))
      res.setIfMatchElement(parseString(json.get("ifMatch").getAsString()));
    if (json.has("_ifMatch"))
      parseElementProperties(json.getAsJsonObject("_ifMatch"), res.getIfMatchElement());
    if (json.has("ifNoneExist"))
      res.setIfNoneExistElement(parseString(json.get("ifNoneExist").getAsString()));
    if (json.has("_ifNoneExist"))
      parseElementProperties(json.getAsJsonObject("_ifNoneExist"), res.getIfNoneExistElement());
    return res;
  }

  protected Bundle.BundleEntryResponseComponent parseBundleBundleEntryResponseComponent(JsonObject json, Bundle owner)
      throws IOException, FHIRFormatError {
    Bundle.BundleEntryResponseComponent res = new Bundle.BundleEntryResponseComponent();
    parseBackboneProperties(json, res);
    if (json.has("status"))
      res.setStatusElement(parseString(json.get("status").getAsString()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("location"))
      res.setLocationElement(parseUri(json.get("location").getAsString()));
    if (json.has("_location"))
      parseElementProperties(json.getAsJsonObject("_location"), res.getLocationElement());
    if (json.has("etag"))
      res.setEtagElement(parseString(json.get("etag").getAsString()));
    if (json.has("_etag"))
      parseElementProperties(json.getAsJsonObject("_etag"), res.getEtagElement());
    if (json.has("lastModified"))
      res.setLastModifiedElement(parseInstant(json.get("lastModified").getAsString()));
    if (json.has("_lastModified"))
      parseElementProperties(json.getAsJsonObject("_lastModified"), res.getLastModifiedElement());
    return res;
  }

  protected CarePlan parseCarePlan(JsonObject json) throws IOException, FHIRFormatError {
    CarePlan res = new CarePlan();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), CarePlan.CarePlanStatus.NULL,
          new CarePlan.CarePlanStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("modified"))
      res.setModifiedElement(parseDateTime(json.get("modified").getAsString()));
    if (json.has("_modified"))
      parseElementProperties(json.getAsJsonObject("_modified"), res.getModifiedElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("addresses")) {
      JsonArray array = json.getAsJsonArray("addresses");
      for (int i = 0; i < array.size(); i++) {
        res.getAddresses().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("support")) {
      JsonArray array = json.getAsJsonArray("support");
      for (int i = 0; i < array.size(); i++) {
        res.getSupport().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("relatedPlan")) {
      JsonArray array = json.getAsJsonArray("relatedPlan");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedPlan().add(parseCarePlanCarePlanRelatedPlanComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseCarePlanCarePlanParticipantComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("goal")) {
      JsonArray array = json.getAsJsonArray("goal");
      for (int i = 0; i < array.size(); i++) {
        res.getGoal().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("activity")) {
      JsonArray array = json.getAsJsonArray("activity");
      for (int i = 0; i < array.size(); i++) {
        res.getActivity().add(parseCarePlanCarePlanActivityComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("note"))
      res.setNote(parseAnnotation(json.getAsJsonObject("note")));
    return res;
  }

  protected CarePlan.CarePlanRelatedPlanComponent parseCarePlanCarePlanRelatedPlanComponent(JsonObject json,
      CarePlan owner) throws IOException, FHIRFormatError {
    CarePlan.CarePlanRelatedPlanComponent res = new CarePlan.CarePlanRelatedPlanComponent();
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), CarePlan.CarePlanRelationship.NULL,
          new CarePlan.CarePlanRelationshipEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("plan"))
      res.setPlan(parseReference(json.getAsJsonObject("plan")));
    return res;
  }

  protected CarePlan.CarePlanParticipantComponent parseCarePlanCarePlanParticipantComponent(JsonObject json,
      CarePlan owner) throws IOException, FHIRFormatError {
    CarePlan.CarePlanParticipantComponent res = new CarePlan.CarePlanParticipantComponent();
    parseBackboneProperties(json, res);
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("member"))
      res.setMember(parseReference(json.getAsJsonObject("member")));
    return res;
  }

  protected CarePlan.CarePlanActivityComponent parseCarePlanCarePlanActivityComponent(JsonObject json, CarePlan owner)
      throws IOException, FHIRFormatError {
    CarePlan.CarePlanActivityComponent res = new CarePlan.CarePlanActivityComponent();
    parseBackboneProperties(json, res);
    if (json.has("actionResulting")) {
      JsonArray array = json.getAsJsonArray("actionResulting");
      for (int i = 0; i < array.size(); i++) {
        res.getActionResulting().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("progress")) {
      JsonArray array = json.getAsJsonArray("progress");
      for (int i = 0; i < array.size(); i++) {
        res.getProgress().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("reference"))
      res.setReference(parseReference(json.getAsJsonObject("reference")));
    if (json.has("detail"))
      res.setDetail(parseCarePlanCarePlanActivityDetailComponent(json.getAsJsonObject("detail"), owner));
    return res;
  }

  protected CarePlan.CarePlanActivityDetailComponent parseCarePlanCarePlanActivityDetailComponent(JsonObject json,
      CarePlan owner) throws IOException, FHIRFormatError {
    CarePlan.CarePlanActivityDetailComponent res = new CarePlan.CarePlanActivityDetailComponent();
    parseBackboneProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("goal")) {
      JsonArray array = json.getAsJsonArray("goal");
      for (int i = 0; i < array.size(); i++) {
        res.getGoal().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), CarePlan.CarePlanActivityStatus.NULL,
          new CarePlan.CarePlanActivityStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableConcept(json.getAsJsonObject("statusReason")));
    if (json.has("prohibited"))
      res.setProhibitedElement(parseBoolean(json.get("prohibited").getAsBoolean()));
    if (json.has("_prohibited"))
      parseElementProperties(json.getAsJsonObject("_prohibited"), res.getProhibitedElement());
    Type scheduled = parseType("scheduled", json);
    if (scheduled != null)
      res.setScheduled(scheduled);
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    Type product = parseType("product", json);
    if (product != null)
      res.setProduct(product);
    if (json.has("dailyAmount"))
      res.setDailyAmount(parseSimpleQuantity(json.getAsJsonObject("dailyAmount")));
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    return res;
  }

  protected CareTeam parseCareTeam(JsonObject json) throws IOException, FHIRFormatError {
    CareTeam res = new CareTeam();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("status"))
      res.setStatus(parseCodeableConcept(json.getAsJsonObject("status")));
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseCareTeamCareTeamParticipantComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("managingOrganization"))
      res.setManagingOrganization(parseReference(json.getAsJsonObject("managingOrganization")));
    return res;
  }

  protected CareTeam.CareTeamParticipantComponent parseCareTeamCareTeamParticipantComponent(JsonObject json,
      CareTeam owner) throws IOException, FHIRFormatError {
    CareTeam.CareTeamParticipantComponent res = new CareTeam.CareTeamParticipantComponent();
    parseBackboneProperties(json, res);
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("member"))
      res.setMember(parseReference(json.getAsJsonObject("member")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    return res;
  }

  protected Claim parseClaim(JsonObject json) throws IOException, FHIRFormatError {
    Claim res = new Claim();
    parseDomainResourceProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(
          parseEnumeration(json.get("type").getAsString(), Claim.ClaimType.NULL, new Claim.ClaimTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("subType")) {
      JsonArray array = json.getAsJsonArray("subType");
      for (int i = 0; i < array.size(); i++) {
        res.getSubType().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("ruleset"))
      res.setRuleset(parseCoding(json.getAsJsonObject("ruleset")));
    if (json.has("originalRuleset"))
      res.setOriginalRuleset(parseCoding(json.getAsJsonObject("originalRuleset")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("billablePeriod"))
      res.setBillablePeriod(parsePeriod(json.getAsJsonObject("billablePeriod")));
    Type target = parseType("target", json);
    if (target != null)
      res.setTarget(target);
    Type provider = parseType("provider", json);
    if (provider != null)
      res.setProvider(provider);
    Type organization = parseType("organization", json);
    if (organization != null)
      res.setOrganization(organization);
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), Claim.Use.NULL, new Claim.UseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("priority"))
      res.setPriority(parseCoding(json.getAsJsonObject("priority")));
    if (json.has("fundsReserve"))
      res.setFundsReserve(parseCoding(json.getAsJsonObject("fundsReserve")));
    Type enterer = parseType("enterer", json);
    if (enterer != null)
      res.setEnterer(enterer);
    Type facility = parseType("facility", json);
    if (facility != null)
      res.setFacility(facility);
    if (json.has("related")) {
      JsonArray array = json.getAsJsonArray("related");
      for (int i = 0; i < array.size(); i++) {
        res.getRelated().add(parseClaimRelatedClaimsComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    Type prescription = parseType("prescription", json);
    if (prescription != null)
      res.setPrescription(prescription);
    Type originalPrescription = parseType("originalPrescription", json);
    if (originalPrescription != null)
      res.setOriginalPrescription(originalPrescription);
    if (json.has("payee"))
      res.setPayee(parseClaimPayeeComponent(json.getAsJsonObject("payee"), res));
    Type referral = parseType("referral", json);
    if (referral != null)
      res.setReferral(referral);
    if (json.has("occurrenceCode")) {
      JsonArray array = json.getAsJsonArray("occurrenceCode");
      for (int i = 0; i < array.size(); i++) {
        res.getOccurrenceCode().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("occurenceSpanCode")) {
      JsonArray array = json.getAsJsonArray("occurenceSpanCode");
      for (int i = 0; i < array.size(); i++) {
        res.getOccurenceSpanCode().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("valueCode")) {
      JsonArray array = json.getAsJsonArray("valueCode");
      for (int i = 0; i < array.size(); i++) {
        res.getValueCode().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("diagnosis")) {
      JsonArray array = json.getAsJsonArray("diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseClaimDiagnosisComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("procedure")) {
      JsonArray array = json.getAsJsonArray("procedure");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedure().add(parseClaimProcedureComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("specialCondition")) {
      JsonArray array = json.getAsJsonArray("specialCondition");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialCondition().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    Type patient = parseType("patient", json);
    if (patient != null)
      res.setPatient(patient);
    if (json.has("coverage")) {
      JsonArray array = json.getAsJsonArray("coverage");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverage().add(parseClaimCoverageComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("accidentDate"))
      res.setAccidentDateElement(parseDate(json.get("accidentDate").getAsString()));
    if (json.has("_accidentDate"))
      parseElementProperties(json.getAsJsonObject("_accidentDate"), res.getAccidentDateElement());
    if (json.has("accidentType"))
      res.setAccidentType(parseCoding(json.getAsJsonObject("accidentType")));
    Type accidentLocation = parseType("accidentLocation", json);
    if (accidentLocation != null)
      res.setAccidentLocation(accidentLocation);
    if (json.has("interventionException")) {
      JsonArray array = json.getAsJsonArray("interventionException");
      for (int i = 0; i < array.size(); i++) {
        res.getInterventionException().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("onset")) {
      JsonArray array = json.getAsJsonArray("onset");
      for (int i = 0; i < array.size(); i++) {
        res.getOnset().add(parseClaimOnsetComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("employmentImpacted"))
      res.setEmploymentImpacted(parsePeriod(json.getAsJsonObject("employmentImpacted")));
    if (json.has("hospitalization"))
      res.setHospitalization(parsePeriod(json.getAsJsonObject("hospitalization")));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseClaimItemsComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("total"))
      res.setTotal(parseMoney(json.getAsJsonObject("total")));
    if (json.has("additionalMaterial")) {
      JsonArray array = json.getAsJsonArray("additionalMaterial");
      for (int i = 0; i < array.size(); i++) {
        res.getAdditionalMaterial().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("missingTeeth")) {
      JsonArray array = json.getAsJsonArray("missingTeeth");
      for (int i = 0; i < array.size(); i++) {
        res.getMissingTeeth().add(parseClaimMissingTeethComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected Claim.RelatedClaimsComponent parseClaimRelatedClaimsComponent(JsonObject json, Claim owner)
      throws IOException, FHIRFormatError {
    Claim.RelatedClaimsComponent res = new Claim.RelatedClaimsComponent();
    parseBackboneProperties(json, res);
    Type claim = parseType("claim", json);
    if (claim != null)
      res.setClaim(claim);
    if (json.has("relationship"))
      res.setRelationship(parseCoding(json.getAsJsonObject("relationship")));
    if (json.has("reference"))
      res.setReference(parseIdentifier(json.getAsJsonObject("reference")));
    return res;
  }

  protected Claim.PayeeComponent parseClaimPayeeComponent(JsonObject json, Claim owner)
      throws IOException, FHIRFormatError {
    Claim.PayeeComponent res = new Claim.PayeeComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    Type party = parseType("party", json);
    if (party != null)
      res.setParty(party);
    return res;
  }

  protected Claim.DiagnosisComponent parseClaimDiagnosisComponent(JsonObject json, Claim owner)
      throws IOException, FHIRFormatError {
    Claim.DiagnosisComponent res = new Claim.DiagnosisComponent();
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("diagnosis"))
      res.setDiagnosis(parseCoding(json.getAsJsonObject("diagnosis")));
    return res;
  }

  protected Claim.ProcedureComponent parseClaimProcedureComponent(JsonObject json, Claim owner)
      throws IOException, FHIRFormatError {
    Claim.ProcedureComponent res = new Claim.ProcedureComponent();
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    Type procedure = parseType("procedure", json);
    if (procedure != null)
      res.setProcedure(procedure);
    return res;
  }

  protected Claim.CoverageComponent parseClaimCoverageComponent(JsonObject json, Claim owner)
      throws IOException, FHIRFormatError {
    Claim.CoverageComponent res = new Claim.CoverageComponent();
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("focal"))
      res.setFocalElement(parseBoolean(json.get("focal").getAsBoolean()));
    if (json.has("_focal"))
      parseElementProperties(json.getAsJsonObject("_focal"), res.getFocalElement());
    Type coverage = parseType("coverage", json);
    if (coverage != null)
      res.setCoverage(coverage);
    if (json.has("businessArrangement"))
      res.setBusinessArrangementElement(parseString(json.get("businessArrangement").getAsString()));
    if (json.has("_businessArrangement"))
      parseElementProperties(json.getAsJsonObject("_businessArrangement"), res.getBusinessArrangementElement());
    if (json.has("preAuthRef")) {
      JsonArray array = json.getAsJsonArray("preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        res.getPreAuthRef().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_preAuthRef")) {
      JsonArray array = json.getAsJsonArray("_preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPreAuthRef().size())
          res.getPreAuthRef().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPreAuthRef().get(i));
      }
    }
    ;
    if (json.has("claimResponse"))
      res.setClaimResponse(parseReference(json.getAsJsonObject("claimResponse")));
    if (json.has("originalRuleset"))
      res.setOriginalRuleset(parseCoding(json.getAsJsonObject("originalRuleset")));
    return res;
  }

  protected Claim.OnsetComponent parseClaimOnsetComponent(JsonObject json, Claim owner)
      throws IOException, FHIRFormatError {
    Claim.OnsetComponent res = new Claim.OnsetComponent();
    parseBackboneProperties(json, res);
    Type time = parseType("time", json);
    if (time != null)
      res.setTime(time);
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    return res;
  }

  protected Claim.ItemsComponent parseClaimItemsComponent(JsonObject json, Claim owner)
      throws IOException, FHIRFormatError {
    Claim.ItemsComponent res = new Claim.ItemsComponent();
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    Type provider = parseType("provider", json);
    if (provider != null)
      res.setProvider(provider);
    Type supervisor = parseType("supervisor", json);
    if (supervisor != null)
      res.setSupervisor(supervisor);
    if (json.has("providerQualification"))
      res.setProviderQualification(parseCoding(json.getAsJsonObject("providerQualification")));
    if (json.has("diagnosisLinkId")) {
      JsonArray array = json.getAsJsonArray("diagnosisLinkId");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosisLinkId().add(parsePositiveInt(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_diagnosisLinkId")) {
      JsonArray array = json.getAsJsonArray("_diagnosisLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDiagnosisLinkId().size())
          res.getDiagnosisLinkId().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDiagnosisLinkId().get(i));
      }
    }
    ;
    if (json.has("service"))
      res.setService(parseCoding(json.getAsJsonObject("service")));
    if (json.has("serviceModifier")) {
      JsonArray array = json.getAsJsonArray("serviceModifier");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceModifier().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    Type serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    if (json.has("place"))
      res.setPlace(parseCoding(json.getAsJsonObject("place")));
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("points"))
      res.setPointsElement(parseDecimal(json.get("points").getAsBigDecimal()));
    if (json.has("_points"))
      parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("bodySite"))
      res.setBodySite(parseCoding(json.getAsJsonObject("bodySite")));
    if (json.has("subSite")) {
      JsonArray array = json.getAsJsonArray("subSite");
      for (int i = 0; i < array.size(); i++) {
        res.getSubSite().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseClaimDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("prosthesis"))
      res.setProsthesis(parseClaimProsthesisComponent(json.getAsJsonObject("prosthesis"), owner));
    return res;
  }

  protected Claim.DetailComponent parseClaimDetailComponent(JsonObject json, Claim owner)
      throws IOException, FHIRFormatError {
    Claim.DetailComponent res = new Claim.DetailComponent();
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("service"))
      res.setService(parseCoding(json.getAsJsonObject("service")));
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("points"))
      res.setPointsElement(parseDecimal(json.get("points").getAsBigDecimal()));
    if (json.has("_points"))
      parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("subDetail")) {
      JsonArray array = json.getAsJsonArray("subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseClaimSubDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected Claim.SubDetailComponent parseClaimSubDetailComponent(JsonObject json, Claim owner)
      throws IOException, FHIRFormatError {
    Claim.SubDetailComponent res = new Claim.SubDetailComponent();
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("service"))
      res.setService(parseCoding(json.getAsJsonObject("service")));
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("points"))
      res.setPointsElement(parseDecimal(json.get("points").getAsBigDecimal()));
    if (json.has("_points"))
      parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected Claim.ProsthesisComponent parseClaimProsthesisComponent(JsonObject json, Claim owner)
      throws IOException, FHIRFormatError {
    Claim.ProsthesisComponent res = new Claim.ProsthesisComponent();
    parseBackboneProperties(json, res);
    if (json.has("initial"))
      res.setInitialElement(parseBoolean(json.get("initial").getAsBoolean()));
    if (json.has("_initial"))
      parseElementProperties(json.getAsJsonObject("_initial"), res.getInitialElement());
    if (json.has("priorDate"))
      res.setPriorDateElement(parseDate(json.get("priorDate").getAsString()));
    if (json.has("_priorDate"))
      parseElementProperties(json.getAsJsonObject("_priorDate"), res.getPriorDateElement());
    if (json.has("priorMaterial"))
      res.setPriorMaterial(parseCoding(json.getAsJsonObject("priorMaterial")));
    return res;
  }

  protected Claim.MissingTeethComponent parseClaimMissingTeethComponent(JsonObject json, Claim owner)
      throws IOException, FHIRFormatError {
    Claim.MissingTeethComponent res = new Claim.MissingTeethComponent();
    parseBackboneProperties(json, res);
    if (json.has("tooth"))
      res.setTooth(parseCoding(json.getAsJsonObject("tooth")));
    if (json.has("reason"))
      res.setReason(parseCoding(json.getAsJsonObject("reason")));
    if (json.has("extractionDate"))
      res.setExtractionDateElement(parseDate(json.get("extractionDate").getAsString()));
    if (json.has("_extractionDate"))
      parseElementProperties(json.getAsJsonObject("_extractionDate"), res.getExtractionDateElement());
    return res;
  }

  protected ClaimResponse parseClaimResponse(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse res = new ClaimResponse();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    Type request = parseType("request", json);
    if (request != null)
      res.setRequest(request);
    if (json.has("ruleset"))
      res.setRuleset(parseCoding(json.getAsJsonObject("ruleset")));
    if (json.has("originalRuleset"))
      res.setOriginalRuleset(parseCoding(json.getAsJsonObject("originalRuleset")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    Type organization = parseType("organization", json);
    if (organization != null)
      res.setOrganization(organization);
    Type requestProvider = parseType("requestProvider", json);
    if (requestProvider != null)
      res.setRequestProvider(requestProvider);
    Type requestOrganization = parseType("requestOrganization", json);
    if (requestOrganization != null)
      res.setRequestOrganization(requestOrganization);
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), Enumerations.RemittanceOutcome.NULL,
          new Enumerations.RemittanceOutcomeEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
    if (json.has("payeeType"))
      res.setPayeeType(parseCoding(json.getAsJsonObject("payeeType")));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseClaimResponseItemsComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("addItem")) {
      JsonArray array = json.getAsJsonArray("addItem");
      for (int i = 0; i < array.size(); i++) {
        res.getAddItem().add(parseClaimResponseAddedItemComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("error")) {
      JsonArray array = json.getAsJsonArray("error");
      for (int i = 0; i < array.size(); i++) {
        res.getError().add(parseClaimResponseErrorsComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("totalCost"))
      res.setTotalCost(parseMoney(json.getAsJsonObject("totalCost")));
    if (json.has("unallocDeductable"))
      res.setUnallocDeductable(parseMoney(json.getAsJsonObject("unallocDeductable")));
    if (json.has("totalBenefit"))
      res.setTotalBenefit(parseMoney(json.getAsJsonObject("totalBenefit")));
    if (json.has("paymentAdjustment"))
      res.setPaymentAdjustment(parseMoney(json.getAsJsonObject("paymentAdjustment")));
    if (json.has("paymentAdjustmentReason"))
      res.setPaymentAdjustmentReason(parseCoding(json.getAsJsonObject("paymentAdjustmentReason")));
    if (json.has("paymentDate"))
      res.setPaymentDateElement(parseDate(json.get("paymentDate").getAsString()));
    if (json.has("_paymentDate"))
      parseElementProperties(json.getAsJsonObject("_paymentDate"), res.getPaymentDateElement());
    if (json.has("paymentAmount"))
      res.setPaymentAmount(parseMoney(json.getAsJsonObject("paymentAmount")));
    if (json.has("paymentRef"))
      res.setPaymentRef(parseIdentifier(json.getAsJsonObject("paymentRef")));
    if (json.has("reserved"))
      res.setReserved(parseCoding(json.getAsJsonObject("reserved")));
    if (json.has("form"))
      res.setForm(parseCoding(json.getAsJsonObject("form")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseClaimResponseNotesComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("coverage")) {
      JsonArray array = json.getAsJsonArray("coverage");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverage().add(parseClaimResponseCoverageComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected ClaimResponse.ItemsComponent parseClaimResponseItemsComponent(JsonObject json, ClaimResponse owner)
      throws IOException, FHIRFormatError {
    ClaimResponse.ItemsComponent res = new ClaimResponse.ItemsComponent();
    parseBackboneProperties(json, res);
    if (json.has("sequenceLinkId"))
      res.setSequenceLinkIdElement(parsePositiveInt(json.get("sequenceLinkId").getAsString()));
    if (json.has("_sequenceLinkId"))
      parseElementProperties(json.getAsJsonObject("_sequenceLinkId"), res.getSequenceLinkIdElement());
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    }
    ;
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseItemAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseClaimResponseItemDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ClaimResponse.ItemAdjudicationComponent parseClaimResponseItemAdjudicationComponent(JsonObject json,
      ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.ItemAdjudicationComponent res = new ClaimResponse.ItemAdjudicationComponent();
    parseBackboneProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCoding(json.getAsJsonObject("category")));
    if (json.has("reason"))
      res.setReason(parseCoding(json.getAsJsonObject("reason")));
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    return res;
  }

  protected ClaimResponse.ItemDetailComponent parseClaimResponseItemDetailComponent(JsonObject json,
      ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.ItemDetailComponent res = new ClaimResponse.ItemDetailComponent();
    parseBackboneProperties(json, res);
    if (json.has("sequenceLinkId"))
      res.setSequenceLinkIdElement(parsePositiveInt(json.get("sequenceLinkId").getAsString()));
    if (json.has("_sequenceLinkId"))
      parseElementProperties(json.getAsJsonObject("_sequenceLinkId"), res.getSequenceLinkIdElement());
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseDetailAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("subDetail")) {
      JsonArray array = json.getAsJsonArray("subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseClaimResponseSubDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ClaimResponse.DetailAdjudicationComponent parseClaimResponseDetailAdjudicationComponent(JsonObject json,
      ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.DetailAdjudicationComponent res = new ClaimResponse.DetailAdjudicationComponent();
    parseBackboneProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCoding(json.getAsJsonObject("category")));
    if (json.has("reason"))
      res.setReason(parseCoding(json.getAsJsonObject("reason")));
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    return res;
  }

  protected ClaimResponse.SubDetailComponent parseClaimResponseSubDetailComponent(JsonObject json, ClaimResponse owner)
      throws IOException, FHIRFormatError {
    ClaimResponse.SubDetailComponent res = new ClaimResponse.SubDetailComponent();
    parseBackboneProperties(json, res);
    if (json.has("sequenceLinkId"))
      res.setSequenceLinkIdElement(parsePositiveInt(json.get("sequenceLinkId").getAsString()));
    if (json.has("_sequenceLinkId"))
      parseElementProperties(json.getAsJsonObject("_sequenceLinkId"), res.getSequenceLinkIdElement());
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication()
            .add(parseClaimResponseSubdetailAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ClaimResponse.SubdetailAdjudicationComponent parseClaimResponseSubdetailAdjudicationComponent(
      JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.SubdetailAdjudicationComponent res = new ClaimResponse.SubdetailAdjudicationComponent();
    parseBackboneProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCoding(json.getAsJsonObject("category")));
    if (json.has("reason"))
      res.setReason(parseCoding(json.getAsJsonObject("reason")));
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    return res;
  }

  protected ClaimResponse.AddedItemComponent parseClaimResponseAddedItemComponent(JsonObject json, ClaimResponse owner)
      throws IOException, FHIRFormatError {
    ClaimResponse.AddedItemComponent res = new ClaimResponse.AddedItemComponent();
    parseBackboneProperties(json, res);
    if (json.has("sequenceLinkId")) {
      JsonArray array = json.getAsJsonArray("sequenceLinkId");
      for (int i = 0; i < array.size(); i++) {
        res.getSequenceLinkId().add(parsePositiveInt(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_sequenceLinkId")) {
      JsonArray array = json.getAsJsonArray("_sequenceLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSequenceLinkId().size())
          res.getSequenceLinkId().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSequenceLinkId().get(i));
      }
    }
    ;
    if (json.has("service"))
      res.setService(parseCoding(json.getAsJsonObject("service")));
    if (json.has("fee"))
      res.setFee(parseMoney(json.getAsJsonObject("fee")));
    if (json.has("noteNumberLinkId")) {
      JsonArray array = json.getAsJsonArray("noteNumberLinkId");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumberLinkId().add(parsePositiveInt(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_noteNumberLinkId")) {
      JsonArray array = json.getAsJsonArray("_noteNumberLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumberLinkId().size())
          res.getNoteNumberLinkId().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumberLinkId().get(i));
      }
    }
    ;
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication()
            .add(parseClaimResponseAddedItemAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseClaimResponseAddedItemsDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ClaimResponse.AddedItemAdjudicationComponent parseClaimResponseAddedItemAdjudicationComponent(
      JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.AddedItemAdjudicationComponent res = new ClaimResponse.AddedItemAdjudicationComponent();
    parseBackboneProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCoding(json.getAsJsonObject("category")));
    if (json.has("reason"))
      res.setReason(parseCoding(json.getAsJsonObject("reason")));
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    return res;
  }

  protected ClaimResponse.AddedItemsDetailComponent parseClaimResponseAddedItemsDetailComponent(JsonObject json,
      ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.AddedItemsDetailComponent res = new ClaimResponse.AddedItemsDetailComponent();
    parseBackboneProperties(json, res);
    if (json.has("service"))
      res.setService(parseCoding(json.getAsJsonObject("service")));
    if (json.has("fee"))
      res.setFee(parseMoney(json.getAsJsonObject("fee")));
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication()
            .add(parseClaimResponseAddedItemDetailAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ClaimResponse.AddedItemDetailAdjudicationComponent parseClaimResponseAddedItemDetailAdjudicationComponent(
      JsonObject json, ClaimResponse owner) throws IOException, FHIRFormatError {
    ClaimResponse.AddedItemDetailAdjudicationComponent res = new ClaimResponse.AddedItemDetailAdjudicationComponent();
    parseBackboneProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCoding(json.getAsJsonObject("category")));
    if (json.has("reason"))
      res.setReason(parseCoding(json.getAsJsonObject("reason")));
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    return res;
  }

  protected ClaimResponse.ErrorsComponent parseClaimResponseErrorsComponent(JsonObject json, ClaimResponse owner)
      throws IOException, FHIRFormatError {
    ClaimResponse.ErrorsComponent res = new ClaimResponse.ErrorsComponent();
    parseBackboneProperties(json, res);
    if (json.has("sequenceLinkId"))
      res.setSequenceLinkIdElement(parsePositiveInt(json.get("sequenceLinkId").getAsString()));
    if (json.has("_sequenceLinkId"))
      parseElementProperties(json.getAsJsonObject("_sequenceLinkId"), res.getSequenceLinkIdElement());
    if (json.has("detailSequenceLinkId"))
      res.setDetailSequenceLinkIdElement(parsePositiveInt(json.get("detailSequenceLinkId").getAsString()));
    if (json.has("_detailSequenceLinkId"))
      parseElementProperties(json.getAsJsonObject("_detailSequenceLinkId"), res.getDetailSequenceLinkIdElement());
    if (json.has("subdetailSequenceLinkId"))
      res.setSubdetailSequenceLinkIdElement(parsePositiveInt(json.get("subdetailSequenceLinkId").getAsString()));
    if (json.has("_subdetailSequenceLinkId"))
      parseElementProperties(json.getAsJsonObject("_subdetailSequenceLinkId"), res.getSubdetailSequenceLinkIdElement());
    if (json.has("code"))
      res.setCode(parseCoding(json.getAsJsonObject("code")));
    return res;
  }

  protected ClaimResponse.NotesComponent parseClaimResponseNotesComponent(JsonObject json, ClaimResponse owner)
      throws IOException, FHIRFormatError {
    ClaimResponse.NotesComponent res = new ClaimResponse.NotesComponent();
    parseBackboneProperties(json, res);
    if (json.has("number"))
      res.setNumberElement(parsePositiveInt(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    return res;
  }

  protected ClaimResponse.CoverageComponent parseClaimResponseCoverageComponent(JsonObject json, ClaimResponse owner)
      throws IOException, FHIRFormatError {
    ClaimResponse.CoverageComponent res = new ClaimResponse.CoverageComponent();
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("focal"))
      res.setFocalElement(parseBoolean(json.get("focal").getAsBoolean()));
    if (json.has("_focal"))
      parseElementProperties(json.getAsJsonObject("_focal"), res.getFocalElement());
    Type coverage = parseType("coverage", json);
    if (coverage != null)
      res.setCoverage(coverage);
    if (json.has("businessArrangement"))
      res.setBusinessArrangementElement(parseString(json.get("businessArrangement").getAsString()));
    if (json.has("_businessArrangement"))
      parseElementProperties(json.getAsJsonObject("_businessArrangement"), res.getBusinessArrangementElement());
    if (json.has("preAuthRef")) {
      JsonArray array = json.getAsJsonArray("preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        res.getPreAuthRef().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_preAuthRef")) {
      JsonArray array = json.getAsJsonArray("_preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPreAuthRef().size())
          res.getPreAuthRef().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPreAuthRef().get(i));
      }
    }
    ;
    if (json.has("claimResponse"))
      res.setClaimResponse(parseReference(json.getAsJsonObject("claimResponse")));
    return res;
  }

  protected ClinicalImpression parseClinicalImpression(JsonObject json) throws IOException, FHIRFormatError {
    ClinicalImpression res = new ClinicalImpression();
    parseDomainResourceProperties(json, res);
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("assessor"))
      res.setAssessor(parseReference(json.getAsJsonObject("assessor")));
    if (json.has("status"))
      res.setStatusElement(
          parseEnumeration(json.get("status").getAsString(), ClinicalImpression.ClinicalImpressionStatus.NULL,
              new ClinicalImpression.ClinicalImpressionStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("previous"))
      res.setPrevious(parseReference(json.getAsJsonObject("previous")));
    if (json.has("problem")) {
      JsonArray array = json.getAsJsonArray("problem");
      for (int i = 0; i < array.size(); i++) {
        res.getProblem().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    Type trigger = parseType("trigger", json);
    if (trigger != null)
      res.setTrigger(trigger);
    if (json.has("investigations")) {
      JsonArray array = json.getAsJsonArray("investigations");
      for (int i = 0; i < array.size(); i++) {
        res.getInvestigations()
            .add(parseClinicalImpressionClinicalImpressionInvestigationsComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("protocol"))
      res.setProtocolElement(parseUri(json.get("protocol").getAsString()));
    if (json.has("_protocol"))
      parseElementProperties(json.getAsJsonObject("_protocol"), res.getProtocolElement());
    if (json.has("summary"))
      res.setSummaryElement(parseString(json.get("summary").getAsString()));
    if (json.has("_summary"))
      parseElementProperties(json.getAsJsonObject("_summary"), res.getSummaryElement());
    if (json.has("finding")) {
      JsonArray array = json.getAsJsonArray("finding");
      for (int i = 0; i < array.size(); i++) {
        res.getFinding()
            .add(parseClinicalImpressionClinicalImpressionFindingComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("resolved")) {
      JsonArray array = json.getAsJsonArray("resolved");
      for (int i = 0; i < array.size(); i++) {
        res.getResolved().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("ruledOut")) {
      JsonArray array = json.getAsJsonArray("ruledOut");
      for (int i = 0; i < array.size(); i++) {
        res.getRuledOut()
            .add(parseClinicalImpressionClinicalImpressionRuledOutComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("prognosis"))
      res.setPrognosisElement(parseString(json.get("prognosis").getAsString()));
    if (json.has("_prognosis"))
      parseElementProperties(json.getAsJsonObject("_prognosis"), res.getPrognosisElement());
    if (json.has("plan")) {
      JsonArray array = json.getAsJsonArray("plan");
      for (int i = 0; i < array.size(); i++) {
        res.getPlan().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected ClinicalImpression.ClinicalImpressionInvestigationsComponent parseClinicalImpressionClinicalImpressionInvestigationsComponent(
      JsonObject json, ClinicalImpression owner) throws IOException, FHIRFormatError {
    ClinicalImpression.ClinicalImpressionInvestigationsComponent res = new ClinicalImpression.ClinicalImpressionInvestigationsComponent();
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected ClinicalImpression.ClinicalImpressionFindingComponent parseClinicalImpressionClinicalImpressionFindingComponent(
      JsonObject json, ClinicalImpression owner) throws IOException, FHIRFormatError {
    ClinicalImpression.ClinicalImpressionFindingComponent res = new ClinicalImpression.ClinicalImpressionFindingComponent();
    parseBackboneProperties(json, res);
    if (json.has("item"))
      res.setItem(parseCodeableConcept(json.getAsJsonObject("item")));
    if (json.has("cause"))
      res.setCauseElement(parseString(json.get("cause").getAsString()));
    if (json.has("_cause"))
      parseElementProperties(json.getAsJsonObject("_cause"), res.getCauseElement());
    return res;
  }

  protected ClinicalImpression.ClinicalImpressionRuledOutComponent parseClinicalImpressionClinicalImpressionRuledOutComponent(
      JsonObject json, ClinicalImpression owner) throws IOException, FHIRFormatError {
    ClinicalImpression.ClinicalImpressionRuledOutComponent res = new ClinicalImpression.ClinicalImpressionRuledOutComponent();
    parseBackboneProperties(json, res);
    if (json.has("item"))
      res.setItem(parseCodeableConcept(json.getAsJsonObject("item")));
    if (json.has("reason"))
      res.setReasonElement(parseString(json.get("reason").getAsString()));
    if (json.has("_reason"))
      parseElementProperties(json.getAsJsonObject("_reason"), res.getReasonElement());
    return res;
  }

  protected CodeSystem parseCodeSystem(JsonObject json) throws IOException, FHIRFormatError {
    CodeSystem res = new CodeSystem();
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(),
          Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseCodeSystemCodeSystemContactComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("requirements"))
      res.setRequirementsElement(parseString(json.get("requirements").getAsString()));
    if (json.has("_requirements"))
      parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseString(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("caseSensitive"))
      res.setCaseSensitiveElement(parseBoolean(json.get("caseSensitive").getAsBoolean()));
    if (json.has("_caseSensitive"))
      parseElementProperties(json.getAsJsonObject("_caseSensitive"), res.getCaseSensitiveElement());
    if (json.has("valueSet"))
      res.setValueSetElement(parseUri(json.get("valueSet").getAsString()));
    if (json.has("_valueSet"))
      parseElementProperties(json.getAsJsonObject("_valueSet"), res.getValueSetElement());
    if (json.has("compositional"))
      res.setCompositionalElement(parseBoolean(json.get("compositional").getAsBoolean()));
    if (json.has("_compositional"))
      parseElementProperties(json.getAsJsonObject("_compositional"), res.getCompositionalElement());
    if (json.has("versionNeeded"))
      res.setVersionNeededElement(parseBoolean(json.get("versionNeeded").getAsBoolean()));
    if (json.has("_versionNeeded"))
      parseElementProperties(json.getAsJsonObject("_versionNeeded"), res.getVersionNeededElement());
    if (json.has("content"))
      res.setContentElement(parseEnumeration(json.get("content").getAsString(), CodeSystem.CodeSystemContentMode.NULL,
          new CodeSystem.CodeSystemContentModeEnumFactory()));
    if (json.has("_content"))
      parseElementProperties(json.getAsJsonObject("_content"), res.getContentElement());
    if (json.has("count"))
      res.setCountElement(parseUnsignedInt(json.get("count").getAsString()));
    if (json.has("_count"))
      parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
    if (json.has("filter")) {
      JsonArray array = json.getAsJsonArray("filter");
      for (int i = 0; i < array.size(); i++) {
        res.getFilter().add(parseCodeSystemCodeSystemFilterComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("property")) {
      JsonArray array = json.getAsJsonArray("property");
      for (int i = 0; i < array.size(); i++) {
        res.getProperty().add(parseCodeSystemCodeSystemPropertyComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("concept")) {
      JsonArray array = json.getAsJsonArray("concept");
      for (int i = 0; i < array.size(); i++) {
        res.getConcept().add(parseCodeSystemConceptDefinitionComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected CodeSystem.CodeSystemContactComponent parseCodeSystemCodeSystemContactComponent(JsonObject json,
      CodeSystem owner) throws IOException, FHIRFormatError {
    CodeSystem.CodeSystemContactComponent res = new CodeSystem.CodeSystemContactComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected CodeSystem.CodeSystemFilterComponent parseCodeSystemCodeSystemFilterComponent(JsonObject json,
      CodeSystem owner) throws IOException, FHIRFormatError {
    CodeSystem.CodeSystemFilterComponent res = new CodeSystem.CodeSystemFilterComponent();
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("operator")) {
      JsonArray array = json.getAsJsonArray("operator");
      for (int i = 0; i < array.size(); i++) {
        res.getOperator().add(parseCode(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_operator")) {
      JsonArray array = json.getAsJsonArray("_operator");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getOperator().size())
          res.getOperator().add(parseCode(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getOperator().get(i));
      }
    }
    ;
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    return res;
  }

  protected CodeSystem.CodeSystemPropertyComponent parseCodeSystemCodeSystemPropertyComponent(JsonObject json,
      CodeSystem owner) throws IOException, FHIRFormatError {
    CodeSystem.CodeSystemPropertyComponent res = new CodeSystem.CodeSystemPropertyComponent();
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), CodeSystem.PropertyType.NULL,
          new CodeSystem.PropertyTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    return res;
  }

  protected CodeSystem.ConceptDefinitionComponent parseCodeSystemConceptDefinitionComponent(JsonObject json,
      CodeSystem owner) throws IOException, FHIRFormatError {
    CodeSystem.ConceptDefinitionComponent res = new CodeSystem.ConceptDefinitionComponent();
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseString(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
    if (json.has("designation")) {
      JsonArray array = json.getAsJsonArray("designation");
      for (int i = 0; i < array.size(); i++) {
        res.getDesignation()
            .add(parseCodeSystemConceptDefinitionDesignationComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("property")) {
      JsonArray array = json.getAsJsonArray("property");
      for (int i = 0; i < array.size(); i++) {
        res.getProperty().add(parseCodeSystemConceptDefinitionPropertyComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("concept")) {
      JsonArray array = json.getAsJsonArray("concept");
      for (int i = 0; i < array.size(); i++) {
        res.getConcept().add(parseCodeSystemConceptDefinitionComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected CodeSystem.ConceptDefinitionDesignationComponent parseCodeSystemConceptDefinitionDesignationComponent(
      JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
    CodeSystem.ConceptDefinitionDesignationComponent res = new CodeSystem.ConceptDefinitionDesignationComponent();
    parseBackboneProperties(json, res);
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("use"))
      res.setUse(parseCoding(json.getAsJsonObject("use")));
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    return res;
  }

  protected CodeSystem.ConceptDefinitionPropertyComponent parseCodeSystemConceptDefinitionPropertyComponent(
      JsonObject json, CodeSystem owner) throws IOException, FHIRFormatError {
    CodeSystem.ConceptDefinitionPropertyComponent res = new CodeSystem.ConceptDefinitionPropertyComponent();
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    return res;
  }

  protected Communication parseCommunication(JsonObject json) throws IOException, FHIRFormatError {
    Communication res = new Communication();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("sender"))
      res.setSender(parseReference(json.getAsJsonObject("sender")));
    if (json.has("recipient")) {
      JsonArray array = json.getAsJsonArray("recipient");
      for (int i = 0; i < array.size(); i++) {
        res.getRecipient().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("payload")) {
      JsonArray array = json.getAsJsonArray("payload");
      for (int i = 0; i < array.size(); i++) {
        res.getPayload().add(parseCommunicationCommunicationPayloadComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("medium")) {
      JsonArray array = json.getAsJsonArray("medium");
      for (int i = 0; i < array.size(); i++) {
        res.getMedium().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Communication.CommunicationStatus.NULL,
          new Communication.CommunicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("sent"))
      res.setSentElement(parseDateTime(json.get("sent").getAsString()));
    if (json.has("_sent"))
      parseElementProperties(json.getAsJsonObject("_sent"), res.getSentElement());
    if (json.has("received"))
      res.setReceivedElement(parseDateTime(json.get("received").getAsString()));
    if (json.has("_received"))
      parseElementProperties(json.getAsJsonObject("_received"), res.getReceivedElement());
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("requestDetail"))
      res.setRequestDetail(parseReference(json.getAsJsonObject("requestDetail")));
    return res;
  }

  protected Communication.CommunicationPayloadComponent parseCommunicationCommunicationPayloadComponent(JsonObject json,
      Communication owner) throws IOException, FHIRFormatError {
    Communication.CommunicationPayloadComponent res = new Communication.CommunicationPayloadComponent();
    parseBackboneProperties(json, res);
    Type content = parseType("content", json);
    if (content != null)
      res.setContent(content);
    return res;
  }

  protected CommunicationRequest parseCommunicationRequest(JsonObject json) throws IOException, FHIRFormatError {
    CommunicationRequest res = new CommunicationRequest();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("sender"))
      res.setSender(parseReference(json.getAsJsonObject("sender")));
    if (json.has("recipient")) {
      JsonArray array = json.getAsJsonArray("recipient");
      for (int i = 0; i < array.size(); i++) {
        res.getRecipient().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("payload")) {
      JsonArray array = json.getAsJsonArray("payload");
      for (int i = 0; i < array.size(); i++) {
        res.getPayload()
            .add(parseCommunicationRequestCommunicationRequestPayloadComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("medium")) {
      JsonArray array = json.getAsJsonArray("medium");
      for (int i = 0; i < array.size(); i++) {
        res.getMedium().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("requester"))
      res.setRequester(parseReference(json.getAsJsonObject("requester")));
    if (json.has("status"))
      res.setStatusElement(
          parseEnumeration(json.get("status").getAsString(), CommunicationRequest.CommunicationRequestStatus.NULL,
              new CommunicationRequest.CommunicationRequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    Type scheduled = parseType("scheduled", json);
    if (scheduled != null)
      res.setScheduled(scheduled);
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("requestedOn"))
      res.setRequestedOnElement(parseDateTime(json.get("requestedOn").getAsString()));
    if (json.has("_requestedOn"))
      parseElementProperties(json.getAsJsonObject("_requestedOn"), res.getRequestedOnElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(json.getAsJsonObject("priority")));
    return res;
  }

  protected CommunicationRequest.CommunicationRequestPayloadComponent parseCommunicationRequestCommunicationRequestPayloadComponent(
      JsonObject json, CommunicationRequest owner) throws IOException, FHIRFormatError {
    CommunicationRequest.CommunicationRequestPayloadComponent res = new CommunicationRequest.CommunicationRequestPayloadComponent();
    parseBackboneProperties(json, res);
    Type content = parseType("content", json);
    if (content != null)
      res.setContent(content);
    return res;
  }

  protected CompartmentDefinition parseCompartmentDefinition(JsonObject json) throws IOException, FHIRFormatError {
    CompartmentDefinition res = new CompartmentDefinition();
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(),
          Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact()
            .add(parseCompartmentDefinitionCompartmentDefinitionContactComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("requirements"))
      res.setRequirementsElement(parseString(json.get("requirements").getAsString()));
    if (json.has("_requirements"))
      parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), CompartmentDefinition.CompartmentType.NULL,
          new CompartmentDefinition.CompartmentTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("search"))
      res.setSearchElement(parseBoolean(json.get("search").getAsBoolean()));
    if (json.has("_search"))
      parseElementProperties(json.getAsJsonObject("_search"), res.getSearchElement());
    if (json.has("resource")) {
      JsonArray array = json.getAsJsonArray("resource");
      for (int i = 0; i < array.size(); i++) {
        res.getResource()
            .add(parseCompartmentDefinitionCompartmentDefinitionResourceComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected CompartmentDefinition.CompartmentDefinitionContactComponent parseCompartmentDefinitionCompartmentDefinitionContactComponent(
      JsonObject json, CompartmentDefinition owner) throws IOException, FHIRFormatError {
    CompartmentDefinition.CompartmentDefinitionContactComponent res = new CompartmentDefinition.CompartmentDefinitionContactComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected CompartmentDefinition.CompartmentDefinitionResourceComponent parseCompartmentDefinitionCompartmentDefinitionResourceComponent(
      JsonObject json, CompartmentDefinition owner) throws IOException, FHIRFormatError {
    CompartmentDefinition.CompartmentDefinitionResourceComponent res = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("param")) {
      JsonArray array = json.getAsJsonArray("param");
      for (int i = 0; i < array.size(); i++) {
        res.getParam().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_param")) {
      JsonArray array = json.getAsJsonArray("_param");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getParam().size())
          res.getParam().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getParam().get(i));
      }
    }
    ;
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    return res;
  }

  protected Composition parseComposition(JsonObject json) throws IOException, FHIRFormatError {
    Composition res = new Composition();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("class"))
      res.setClass_(parseCodeableConcept(json.getAsJsonObject("class")));
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Composition.CompositionStatus.NULL,
          new Composition.CompositionStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("confidentiality"))
      res.setConfidentialityElement(parseCode(json.get("confidentiality").getAsString()));
    if (json.has("_confidentiality"))
      parseElementProperties(json.getAsJsonObject("_confidentiality"), res.getConfidentialityElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("attester")) {
      JsonArray array = json.getAsJsonArray("attester");
      for (int i = 0; i < array.size(); i++) {
        res.getAttester().add(parseCompositionCompositionAttesterComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("custodian"))
      res.setCustodian(parseReference(json.getAsJsonObject("custodian")));
    if (json.has("event")) {
      JsonArray array = json.getAsJsonArray("event");
      for (int i = 0; i < array.size(); i++) {
        res.getEvent().add(parseCompositionCompositionEventComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("section")) {
      JsonArray array = json.getAsJsonArray("section");
      for (int i = 0; i < array.size(); i++) {
        res.getSection().add(parseCompositionSectionComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected Composition.CompositionAttesterComponent parseCompositionCompositionAttesterComponent(JsonObject json,
      Composition owner) throws IOException, FHIRFormatError {
    Composition.CompositionAttesterComponent res = new Composition.CompositionAttesterComponent();
    parseBackboneProperties(json, res);
    if (json.has("mode")) {
      JsonArray array = json.getAsJsonArray("mode");
      for (int i = 0; i < array.size(); i++) {
        res.getMode().add(parseEnumeration(array.get(i).getAsString(), Composition.CompositionAttestationMode.NULL,
            new Composition.CompositionAttestationModeEnumFactory()));
      }
    }
    ;
    if (json.has("_mode")) {
      JsonArray array = json.getAsJsonArray("_mode");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getMode().size())
          res.getMode().add(parseEnumeration(null, Composition.CompositionAttestationMode.NULL,
              new Composition.CompositionAttestationModeEnumFactory()));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getMode().get(i));
      }
    }
    ;
    if (json.has("time"))
      res.setTimeElement(parseDateTime(json.get("time").getAsString()));
    if (json.has("_time"))
      parseElementProperties(json.getAsJsonObject("_time"), res.getTimeElement());
    if (json.has("party"))
      res.setParty(parseReference(json.getAsJsonObject("party")));
    return res;
  }

  protected Composition.CompositionEventComponent parseCompositionCompositionEventComponent(JsonObject json,
      Composition owner) throws IOException, FHIRFormatError {
    Composition.CompositionEventComponent res = new Composition.CompositionEventComponent();
    parseBackboneProperties(json, res);
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected Composition.SectionComponent parseCompositionSectionComponent(JsonObject json, Composition owner)
      throws IOException, FHIRFormatError {
    Composition.SectionComponent res = new Composition.SectionComponent();
    parseBackboneProperties(json, res);
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("text"))
      res.setText(parseNarrative(json.getAsJsonObject("text")));
    if (json.has("mode"))
      res.setModeElement(parseCode(json.get("mode").getAsString()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("orderedBy"))
      res.setOrderedBy(parseCodeableConcept(json.getAsJsonObject("orderedBy")));
    if (json.has("entry")) {
      JsonArray array = json.getAsJsonArray("entry");
      for (int i = 0; i < array.size(); i++) {
        res.getEntry().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("emptyReason"))
      res.setEmptyReason(parseCodeableConcept(json.getAsJsonObject("emptyReason")));
    if (json.has("section")) {
      JsonArray array = json.getAsJsonArray("section");
      for (int i = 0; i < array.size(); i++) {
        res.getSection().add(parseCompositionSectionComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ConceptMap parseConceptMap(JsonObject json) throws IOException, FHIRFormatError {
    ConceptMap res = new ConceptMap();
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(),
          Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseConceptMapConceptMapContactComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("requirements"))
      res.setRequirementsElement(parseString(json.get("requirements").getAsString()));
    if (json.has("_requirements"))
      parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseString(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    Type source = parseType("source", json);
    if (source != null)
      res.setSource(source);
    Type target = parseType("target", json);
    if (target != null)
      res.setTarget(target);
    if (json.has("element")) {
      JsonArray array = json.getAsJsonArray("element");
      for (int i = 0; i < array.size(); i++) {
        res.getElement().add(parseConceptMapSourceElementComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected ConceptMap.ConceptMapContactComponent parseConceptMapConceptMapContactComponent(JsonObject json,
      ConceptMap owner) throws IOException, FHIRFormatError {
    ConceptMap.ConceptMapContactComponent res = new ConceptMap.ConceptMapContactComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected ConceptMap.SourceElementComponent parseConceptMapSourceElementComponent(JsonObject json, ConceptMap owner)
      throws IOException, FHIRFormatError {
    ConceptMap.SourceElementComponent res = new ConceptMap.SourceElementComponent();
    parseBackboneProperties(json, res);
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("target")) {
      JsonArray array = json.getAsJsonArray("target");
      for (int i = 0; i < array.size(); i++) {
        res.getTarget().add(parseConceptMapTargetElementComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ConceptMap.TargetElementComponent parseConceptMapTargetElementComponent(JsonObject json, ConceptMap owner)
      throws IOException, FHIRFormatError {
    ConceptMap.TargetElementComponent res = new ConceptMap.TargetElementComponent();
    parseBackboneProperties(json, res);
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("equivalence"))
      res.setEquivalenceElement(parseEnumeration(json.get("equivalence").getAsString(),
          Enumerations.ConceptMapEquivalence.NULL, new Enumerations.ConceptMapEquivalenceEnumFactory()));
    if (json.has("_equivalence"))
      parseElementProperties(json.getAsJsonObject("_equivalence"), res.getEquivalenceElement());
    if (json.has("comments"))
      res.setCommentsElement(parseString(json.get("comments").getAsString()));
    if (json.has("_comments"))
      parseElementProperties(json.getAsJsonObject("_comments"), res.getCommentsElement());
    if (json.has("dependsOn")) {
      JsonArray array = json.getAsJsonArray("dependsOn");
      for (int i = 0; i < array.size(); i++) {
        res.getDependsOn().add(parseConceptMapOtherElementComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("product")) {
      JsonArray array = json.getAsJsonArray("product");
      for (int i = 0; i < array.size(); i++) {
        res.getProduct().add(parseConceptMapOtherElementComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ConceptMap.OtherElementComponent parseConceptMapOtherElementComponent(JsonObject json, ConceptMap owner)
      throws IOException, FHIRFormatError {
    ConceptMap.OtherElementComponent res = new ConceptMap.OtherElementComponent();
    parseBackboneProperties(json, res);
    if (json.has("element"))
      res.setElementElement(parseUri(json.get("element").getAsString()));
    if (json.has("_element"))
      parseElementProperties(json.getAsJsonObject("_element"), res.getElementElement());
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("code"))
      res.setCodeElement(parseString(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    return res;
  }

  protected Condition parseCondition(JsonObject json) throws IOException, FHIRFormatError {
    Condition res = new Condition();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("asserter"))
      res.setAsserter(parseReference(json.getAsJsonObject("asserter")));
    if (json.has("dateRecorded"))
      res.setDateRecordedElement(parseDate(json.get("dateRecorded").getAsString()));
    if (json.has("_dateRecorded"))
      parseElementProperties(json.getAsJsonObject("_dateRecorded"), res.getDateRecordedElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("clinicalStatus"))
      res.setClinicalStatusElement(parseCode(json.get("clinicalStatus").getAsString()));
    if (json.has("_clinicalStatus"))
      parseElementProperties(json.getAsJsonObject("_clinicalStatus"), res.getClinicalStatusElement());
    if (json.has("verificationStatus"))
      res.setVerificationStatusElement(parseEnumeration(json.get("verificationStatus").getAsString(),
          Condition.ConditionVerificationStatus.NULL, new Condition.ConditionVerificationStatusEnumFactory()));
    if (json.has("_verificationStatus"))
      parseElementProperties(json.getAsJsonObject("_verificationStatus"), res.getVerificationStatusElement());
    if (json.has("severity"))
      res.setSeverity(parseCodeableConcept(json.getAsJsonObject("severity")));
    Type onset = parseType("onset", json);
    if (onset != null)
      res.setOnset(onset);
    Type abatement = parseType("abatement", json);
    if (abatement != null)
      res.setAbatement(abatement);
    if (json.has("stage"))
      res.setStage(parseConditionConditionStageComponent(json.getAsJsonObject("stage"), res));
    if (json.has("evidence")) {
      JsonArray array = json.getAsJsonArray("evidence");
      for (int i = 0; i < array.size(); i++) {
        res.getEvidence().add(parseConditionConditionEvidenceComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("bodySite")) {
      JsonArray array = json.getAsJsonArray("bodySite");
      for (int i = 0; i < array.size(); i++) {
        res.getBodySite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("notes"))
      res.setNotesElement(parseString(json.get("notes").getAsString()));
    if (json.has("_notes"))
      parseElementProperties(json.getAsJsonObject("_notes"), res.getNotesElement());
    return res;
  }

  protected Condition.ConditionStageComponent parseConditionConditionStageComponent(JsonObject json, Condition owner)
      throws IOException, FHIRFormatError {
    Condition.ConditionStageComponent res = new Condition.ConditionStageComponent();
    parseBackboneProperties(json, res);
    if (json.has("summary"))
      res.setSummary(parseCodeableConcept(json.getAsJsonObject("summary")));
    if (json.has("assessment")) {
      JsonArray array = json.getAsJsonArray("assessment");
      for (int i = 0; i < array.size(); i++) {
        res.getAssessment().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected Condition.ConditionEvidenceComponent parseConditionConditionEvidenceComponent(JsonObject json,
      Condition owner) throws IOException, FHIRFormatError {
    Condition.ConditionEvidenceComponent res = new Condition.ConditionEvidenceComponent();
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected Conformance parseConformance(JsonObject json) throws IOException, FHIRFormatError {
    Conformance res = new Conformance();
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(),
          Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseConformanceConformanceContactComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("requirements"))
      res.setRequirementsElement(parseString(json.get("requirements").getAsString()));
    if (json.has("_requirements"))
      parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseString(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), Conformance.ConformanceStatementKind.NULL,
          new Conformance.ConformanceStatementKindEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
    if (json.has("software"))
      res.setSoftware(parseConformanceConformanceSoftwareComponent(json.getAsJsonObject("software"), res));
    if (json.has("implementation"))
      res.setImplementation(
          parseConformanceConformanceImplementationComponent(json.getAsJsonObject("implementation"), res));
    if (json.has("fhirVersion"))
      res.setFhirVersionElement(parseId(json.get("fhirVersion").getAsString()));
    if (json.has("_fhirVersion"))
      parseElementProperties(json.getAsJsonObject("_fhirVersion"), res.getFhirVersionElement());
    if (json.has("acceptUnknown"))
      res.setAcceptUnknownElement(parseEnumeration(json.get("acceptUnknown").getAsString(),
          Conformance.UnknownContentCode.NULL, new Conformance.UnknownContentCodeEnumFactory()));
    if (json.has("_acceptUnknown"))
      parseElementProperties(json.getAsJsonObject("_acceptUnknown"), res.getAcceptUnknownElement());
    if (json.has("format")) {
      JsonArray array = json.getAsJsonArray("format");
      for (int i = 0; i < array.size(); i++) {
        res.getFormat().add(parseCode(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_format")) {
      JsonArray array = json.getAsJsonArray("_format");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getFormat().size())
          res.getFormat().add(parseCode(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getFormat().get(i));
      }
    }
    ;
    if (json.has("profile")) {
      JsonArray array = json.getAsJsonArray("profile");
      for (int i = 0; i < array.size(); i++) {
        res.getProfile().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("rest")) {
      JsonArray array = json.getAsJsonArray("rest");
      for (int i = 0; i < array.size(); i++) {
        res.getRest().add(parseConformanceConformanceRestComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("messaging")) {
      JsonArray array = json.getAsJsonArray("messaging");
      for (int i = 0; i < array.size(); i++) {
        res.getMessaging().add(parseConformanceConformanceMessagingComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("document")) {
      JsonArray array = json.getAsJsonArray("document");
      for (int i = 0; i < array.size(); i++) {
        res.getDocument().add(parseConformanceConformanceDocumentComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected Conformance.ConformanceContactComponent parseConformanceConformanceContactComponent(JsonObject json,
      Conformance owner) throws IOException, FHIRFormatError {
    Conformance.ConformanceContactComponent res = new Conformance.ConformanceContactComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected Conformance.ConformanceSoftwareComponent parseConformanceConformanceSoftwareComponent(JsonObject json,
      Conformance owner) throws IOException, FHIRFormatError {
    Conformance.ConformanceSoftwareComponent res = new Conformance.ConformanceSoftwareComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("releaseDate"))
      res.setReleaseDateElement(parseDateTime(json.get("releaseDate").getAsString()));
    if (json.has("_releaseDate"))
      parseElementProperties(json.getAsJsonObject("_releaseDate"), res.getReleaseDateElement());
    return res;
  }

  protected Conformance.ConformanceImplementationComponent parseConformanceConformanceImplementationComponent(
      JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
    Conformance.ConformanceImplementationComponent res = new Conformance.ConformanceImplementationComponent();
    parseBackboneProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    return res;
  }

  protected Conformance.ConformanceRestComponent parseConformanceConformanceRestComponent(JsonObject json,
      Conformance owner) throws IOException, FHIRFormatError {
    Conformance.ConformanceRestComponent res = new Conformance.ConformanceRestComponent();
    parseBackboneProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Conformance.RestfulConformanceMode.NULL,
          new Conformance.RestfulConformanceModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("security"))
      res.setSecurity(parseConformanceConformanceRestSecurityComponent(json.getAsJsonObject("security"), owner));
    if (json.has("resource")) {
      JsonArray array = json.getAsJsonArray("resource");
      for (int i = 0; i < array.size(); i++) {
        res.getResource().add(parseConformanceConformanceRestResourceComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("interaction")) {
      JsonArray array = json.getAsJsonArray("interaction");
      for (int i = 0; i < array.size(); i++) {
        res.getInteraction().add(parseConformanceSystemInteractionComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("transactionMode"))
      res.setTransactionModeElement(parseEnumeration(json.get("transactionMode").getAsString(),
          Conformance.TransactionMode.NULL, new Conformance.TransactionModeEnumFactory()));
    if (json.has("_transactionMode"))
      parseElementProperties(json.getAsJsonObject("_transactionMode"), res.getTransactionModeElement());
    if (json.has("searchParam")) {
      JsonArray array = json.getAsJsonArray("searchParam");
      for (int i = 0; i < array.size(); i++) {
        res.getSearchParam()
            .add(parseConformanceConformanceRestResourceSearchParamComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("operation")) {
      JsonArray array = json.getAsJsonArray("operation");
      for (int i = 0; i < array.size(); i++) {
        res.getOperation()
            .add(parseConformanceConformanceRestOperationComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("compartment")) {
      JsonArray array = json.getAsJsonArray("compartment");
      for (int i = 0; i < array.size(); i++) {
        res.getCompartment().add(parseUri(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_compartment")) {
      JsonArray array = json.getAsJsonArray("_compartment");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCompartment().size())
          res.getCompartment().add(parseUri(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getCompartment().get(i));
      }
    }
    ;
    return res;
  }

  protected Conformance.ConformanceRestSecurityComponent parseConformanceConformanceRestSecurityComponent(
      JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
    Conformance.ConformanceRestSecurityComponent res = new Conformance.ConformanceRestSecurityComponent();
    parseBackboneProperties(json, res);
    if (json.has("cors"))
      res.setCorsElement(parseBoolean(json.get("cors").getAsBoolean()));
    if (json.has("_cors"))
      parseElementProperties(json.getAsJsonObject("_cors"), res.getCorsElement());
    if (json.has("service")) {
      JsonArray array = json.getAsJsonArray("service");
      for (int i = 0; i < array.size(); i++) {
        res.getService().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("certificate")) {
      JsonArray array = json.getAsJsonArray("certificate");
      for (int i = 0; i < array.size(); i++) {
        res.getCertificate()
            .add(parseConformanceConformanceRestSecurityCertificateComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected Conformance.ConformanceRestSecurityCertificateComponent parseConformanceConformanceRestSecurityCertificateComponent(
      JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
    Conformance.ConformanceRestSecurityCertificateComponent res = new Conformance.ConformanceRestSecurityCertificateComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("blob"))
      res.setBlobElement(parseBase64Binary(json.get("blob").getAsString()));
    if (json.has("_blob"))
      parseElementProperties(json.getAsJsonObject("_blob"), res.getBlobElement());
    return res;
  }

  protected Conformance.ConformanceRestResourceComponent parseConformanceConformanceRestResourceComponent(
      JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
    Conformance.ConformanceRestResourceComponent res = new Conformance.ConformanceRestResourceComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("profile"))
      res.setProfile(parseReference(json.getAsJsonObject("profile")));
    if (json.has("interaction")) {
      JsonArray array = json.getAsJsonArray("interaction");
      for (int i = 0; i < array.size(); i++) {
        res.getInteraction().add(parseConformanceResourceInteractionComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("versioning"))
      res.setVersioningElement(parseEnumeration(json.get("versioning").getAsString(),
          Conformance.ResourceVersionPolicy.NULL, new Conformance.ResourceVersionPolicyEnumFactory()));
    if (json.has("_versioning"))
      parseElementProperties(json.getAsJsonObject("_versioning"), res.getVersioningElement());
    if (json.has("readHistory"))
      res.setReadHistoryElement(parseBoolean(json.get("readHistory").getAsBoolean()));
    if (json.has("_readHistory"))
      parseElementProperties(json.getAsJsonObject("_readHistory"), res.getReadHistoryElement());
    if (json.has("updateCreate"))
      res.setUpdateCreateElement(parseBoolean(json.get("updateCreate").getAsBoolean()));
    if (json.has("_updateCreate"))
      parseElementProperties(json.getAsJsonObject("_updateCreate"), res.getUpdateCreateElement());
    if (json.has("conditionalCreate"))
      res.setConditionalCreateElement(parseBoolean(json.get("conditionalCreate").getAsBoolean()));
    if (json.has("_conditionalCreate"))
      parseElementProperties(json.getAsJsonObject("_conditionalCreate"), res.getConditionalCreateElement());
    if (json.has("conditionalUpdate"))
      res.setConditionalUpdateElement(parseBoolean(json.get("conditionalUpdate").getAsBoolean()));
    if (json.has("_conditionalUpdate"))
      parseElementProperties(json.getAsJsonObject("_conditionalUpdate"), res.getConditionalUpdateElement());
    if (json.has("conditionalDelete"))
      res.setConditionalDeleteElement(parseEnumeration(json.get("conditionalDelete").getAsString(),
          Conformance.ConditionalDeleteStatus.NULL, new Conformance.ConditionalDeleteStatusEnumFactory()));
    if (json.has("_conditionalDelete"))
      parseElementProperties(json.getAsJsonObject("_conditionalDelete"), res.getConditionalDeleteElement());
    if (json.has("searchInclude")) {
      JsonArray array = json.getAsJsonArray("searchInclude");
      for (int i = 0; i < array.size(); i++) {
        res.getSearchInclude().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_searchInclude")) {
      JsonArray array = json.getAsJsonArray("_searchInclude");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSearchInclude().size())
          res.getSearchInclude().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSearchInclude().get(i));
      }
    }
    ;
    if (json.has("searchRevInclude")) {
      JsonArray array = json.getAsJsonArray("searchRevInclude");
      for (int i = 0; i < array.size(); i++) {
        res.getSearchRevInclude().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_searchRevInclude")) {
      JsonArray array = json.getAsJsonArray("_searchRevInclude");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSearchRevInclude().size())
          res.getSearchRevInclude().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSearchRevInclude().get(i));
      }
    }
    ;
    if (json.has("searchParam")) {
      JsonArray array = json.getAsJsonArray("searchParam");
      for (int i = 0; i < array.size(); i++) {
        res.getSearchParam()
            .add(parseConformanceConformanceRestResourceSearchParamComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected Conformance.ResourceInteractionComponent parseConformanceResourceInteractionComponent(JsonObject json,
      Conformance owner) throws IOException, FHIRFormatError {
    Conformance.ResourceInteractionComponent res = new Conformance.ResourceInteractionComponent();
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), Conformance.TypeRestfulInteraction.NULL,
          new Conformance.TypeRestfulInteractionEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    return res;
  }

  protected Conformance.ConformanceRestResourceSearchParamComponent parseConformanceConformanceRestResourceSearchParamComponent(
      JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
    Conformance.ConformanceRestResourceSearchParamComponent res = new Conformance.ConformanceRestResourceSearchParamComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseUri(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.SearchParamType.NULL,
          new Enumerations.SearchParamTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("target")) {
      JsonArray array = json.getAsJsonArray("target");
      for (int i = 0; i < array.size(); i++) {
        res.getTarget().add(parseCode(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_target")) {
      JsonArray array = json.getAsJsonArray("_target");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getTarget().size())
          res.getTarget().add(parseCode(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getTarget().get(i));
      }
    }
    ;
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseEnumeration(array.get(i).getAsString(), Conformance.SearchModifierCode.NULL,
            new Conformance.SearchModifierCodeEnumFactory()));
      }
    }
    ;
    if (json.has("_modifier")) {
      JsonArray array = json.getAsJsonArray("_modifier");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getModifier().size())
          res.getModifier().add(parseEnumeration(null, Conformance.SearchModifierCode.NULL,
              new Conformance.SearchModifierCodeEnumFactory()));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getModifier().get(i));
      }
    }
    ;
    if (json.has("chain")) {
      JsonArray array = json.getAsJsonArray("chain");
      for (int i = 0; i < array.size(); i++) {
        res.getChain().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_chain")) {
      JsonArray array = json.getAsJsonArray("_chain");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getChain().size())
          res.getChain().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getChain().get(i));
      }
    }
    ;
    return res;
  }

  protected Conformance.SystemInteractionComponent parseConformanceSystemInteractionComponent(JsonObject json,
      Conformance owner) throws IOException, FHIRFormatError {
    Conformance.SystemInteractionComponent res = new Conformance.SystemInteractionComponent();
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), Conformance.SystemRestfulInteraction.NULL,
          new Conformance.SystemRestfulInteractionEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    return res;
  }

  protected Conformance.ConformanceRestOperationComponent parseConformanceConformanceRestOperationComponent(
      JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
    Conformance.ConformanceRestOperationComponent res = new Conformance.ConformanceRestOperationComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("definition"))
      res.setDefinition(parseReference(json.getAsJsonObject("definition")));
    return res;
  }

  protected Conformance.ConformanceMessagingComponent parseConformanceConformanceMessagingComponent(JsonObject json,
      Conformance owner) throws IOException, FHIRFormatError {
    Conformance.ConformanceMessagingComponent res = new Conformance.ConformanceMessagingComponent();
    parseBackboneProperties(json, res);
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint()
            .add(parseConformanceConformanceMessagingEndpointComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("reliableCache"))
      res.setReliableCacheElement(parseUnsignedInt(json.get("reliableCache").getAsString()));
    if (json.has("_reliableCache"))
      parseElementProperties(json.getAsJsonObject("_reliableCache"), res.getReliableCacheElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("event")) {
      JsonArray array = json.getAsJsonArray("event");
      for (int i = 0; i < array.size(); i++) {
        res.getEvent().add(parseConformanceConformanceMessagingEventComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected Conformance.ConformanceMessagingEndpointComponent parseConformanceConformanceMessagingEndpointComponent(
      JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
    Conformance.ConformanceMessagingEndpointComponent res = new Conformance.ConformanceMessagingEndpointComponent();
    parseBackboneProperties(json, res);
    if (json.has("protocol"))
      res.setProtocol(parseCoding(json.getAsJsonObject("protocol")));
    if (json.has("address"))
      res.setAddressElement(parseUri(json.get("address").getAsString()));
    if (json.has("_address"))
      parseElementProperties(json.getAsJsonObject("_address"), res.getAddressElement());
    return res;
  }

  protected Conformance.ConformanceMessagingEventComponent parseConformanceConformanceMessagingEventComponent(
      JsonObject json, Conformance owner) throws IOException, FHIRFormatError {
    Conformance.ConformanceMessagingEventComponent res = new Conformance.ConformanceMessagingEventComponent();
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCoding(json.getAsJsonObject("code")));
    if (json.has("category"))
      res.setCategoryElement(parseEnumeration(json.get("category").getAsString(),
          Conformance.MessageSignificanceCategory.NULL, new Conformance.MessageSignificanceCategoryEnumFactory()));
    if (json.has("_category"))
      parseElementProperties(json.getAsJsonObject("_category"), res.getCategoryElement());
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Conformance.ConformanceEventMode.NULL,
          new Conformance.ConformanceEventModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("focus"))
      res.setFocusElement(parseCode(json.get("focus").getAsString()));
    if (json.has("_focus"))
      parseElementProperties(json.getAsJsonObject("_focus"), res.getFocusElement());
    if (json.has("request"))
      res.setRequest(parseReference(json.getAsJsonObject("request")));
    if (json.has("response"))
      res.setResponse(parseReference(json.getAsJsonObject("response")));
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    return res;
  }

  protected Conformance.ConformanceDocumentComponent parseConformanceConformanceDocumentComponent(JsonObject json,
      Conformance owner) throws IOException, FHIRFormatError {
    Conformance.ConformanceDocumentComponent res = new Conformance.ConformanceDocumentComponent();
    parseBackboneProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Conformance.DocumentMode.NULL,
          new Conformance.DocumentModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("profile"))
      res.setProfile(parseReference(json.getAsJsonObject("profile")));
    return res;
  }

  protected Contract parseContract(JsonObject json) throws IOException, FHIRFormatError {
    Contract res = new Contract();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("issued"))
      res.setIssuedElement(parseDateTime(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
    if (json.has("applies"))
      res.setApplies(parsePeriod(json.getAsJsonObject("applies")));
    if (json.has("subject")) {
      JsonArray array = json.getAsJsonArray("subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("authority")) {
      JsonArray array = json.getAsJsonArray("authority");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthority().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("domain")) {
      JsonArray array = json.getAsJsonArray("domain");
      for (int i = 0; i < array.size(); i++) {
        res.getDomain().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subType")) {
      JsonArray array = json.getAsJsonArray("subType");
      for (int i = 0; i < array.size(); i++) {
        res.getSubType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("actionReason")) {
      JsonArray array = json.getAsJsonArray("actionReason");
      for (int i = 0; i < array.size(); i++) {
        res.getActionReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("agent")) {
      JsonArray array = json.getAsJsonArray("agent");
      for (int i = 0; i < array.size(); i++) {
        res.getAgent().add(parseContractAgentComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("signer")) {
      JsonArray array = json.getAsJsonArray("signer");
      for (int i = 0; i < array.size(); i++) {
        res.getSigner().add(parseContractSignatoryComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("valuedItem")) {
      JsonArray array = json.getAsJsonArray("valuedItem");
      for (int i = 0; i < array.size(); i++) {
        res.getValuedItem().add(parseContractValuedItemComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("term")) {
      JsonArray array = json.getAsJsonArray("term");
      for (int i = 0; i < array.size(); i++) {
        res.getTerm().add(parseContractTermComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    Type binding = parseType("binding", json);
    if (binding != null)
      res.setBinding(binding);
    if (json.has("friendly")) {
      JsonArray array = json.getAsJsonArray("friendly");
      for (int i = 0; i < array.size(); i++) {
        res.getFriendly().add(parseContractFriendlyLanguageComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("legal")) {
      JsonArray array = json.getAsJsonArray("legal");
      for (int i = 0; i < array.size(); i++) {
        res.getLegal().add(parseContractLegalLanguageComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("rule")) {
      JsonArray array = json.getAsJsonArray("rule");
      for (int i = 0; i < array.size(); i++) {
        res.getRule().add(parseContractComputableLanguageComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected Contract.AgentComponent parseContractAgentComponent(JsonObject json, Contract owner)
      throws IOException, FHIRFormatError {
    Contract.AgentComponent res = new Contract.AgentComponent();
    parseBackboneProperties(json, res);
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
    if (json.has("role")) {
      JsonArray array = json.getAsJsonArray("role");
      for (int i = 0; i < array.size(); i++) {
        res.getRole().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected Contract.SignatoryComponent parseContractSignatoryComponent(JsonObject json, Contract owner)
      throws IOException, FHIRFormatError {
    Contract.SignatoryComponent res = new Contract.SignatoryComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("party"))
      res.setParty(parseReference(json.getAsJsonObject("party")));
    if (json.has("signature")) {
      JsonArray array = json.getAsJsonArray("signature");
      for (int i = 0; i < array.size(); i++) {
        res.getSignature().add(parseSignature(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected Contract.ValuedItemComponent parseContractValuedItemComponent(JsonObject json, Contract owner)
      throws IOException, FHIRFormatError {
    Contract.ValuedItemComponent res = new Contract.ValuedItemComponent();
    parseBackboneProperties(json, res);
    Type entity = parseType("entity", json);
    if (entity != null)
      res.setEntity(entity);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("effectiveTime"))
      res.setEffectiveTimeElement(parseDateTime(json.get("effectiveTime").getAsString()));
    if (json.has("_effectiveTime"))
      parseElementProperties(json.getAsJsonObject("_effectiveTime"), res.getEffectiveTimeElement());
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("points"))
      res.setPointsElement(parseDecimal(json.get("points").getAsBigDecimal()));
    if (json.has("_points"))
      parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    return res;
  }

  protected Contract.TermComponent parseContractTermComponent(JsonObject json, Contract owner)
      throws IOException, FHIRFormatError {
    Contract.TermComponent res = new Contract.TermComponent();
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("issued"))
      res.setIssuedElement(parseDateTime(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
    if (json.has("applies"))
      res.setApplies(parsePeriod(json.getAsJsonObject("applies")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subType"))
      res.setSubType(parseCodeableConcept(json.getAsJsonObject("subType")));
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("actionReason")) {
      JsonArray array = json.getAsJsonArray("actionReason");
      for (int i = 0; i < array.size(); i++) {
        res.getActionReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("agent")) {
      JsonArray array = json.getAsJsonArray("agent");
      for (int i = 0; i < array.size(); i++) {
        res.getAgent().add(parseContractTermAgentComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("valuedItem")) {
      JsonArray array = json.getAsJsonArray("valuedItem");
      for (int i = 0; i < array.size(); i++) {
        res.getValuedItem().add(parseContractTermValuedItemComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("group")) {
      JsonArray array = json.getAsJsonArray("group");
      for (int i = 0; i < array.size(); i++) {
        res.getGroup().add(parseContractTermComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected Contract.TermAgentComponent parseContractTermAgentComponent(JsonObject json, Contract owner)
      throws IOException, FHIRFormatError {
    Contract.TermAgentComponent res = new Contract.TermAgentComponent();
    parseBackboneProperties(json, res);
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
    if (json.has("role")) {
      JsonArray array = json.getAsJsonArray("role");
      for (int i = 0; i < array.size(); i++) {
        res.getRole().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected Contract.TermValuedItemComponent parseContractTermValuedItemComponent(JsonObject json, Contract owner)
      throws IOException, FHIRFormatError {
    Contract.TermValuedItemComponent res = new Contract.TermValuedItemComponent();
    parseBackboneProperties(json, res);
    Type entity = parseType("entity", json);
    if (entity != null)
      res.setEntity(entity);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("effectiveTime"))
      res.setEffectiveTimeElement(parseDateTime(json.get("effectiveTime").getAsString()));
    if (json.has("_effectiveTime"))
      parseElementProperties(json.getAsJsonObject("_effectiveTime"), res.getEffectiveTimeElement());
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("points"))
      res.setPointsElement(parseDecimal(json.get("points").getAsBigDecimal()));
    if (json.has("_points"))
      parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    return res;
  }

  protected Contract.FriendlyLanguageComponent parseContractFriendlyLanguageComponent(JsonObject json, Contract owner)
      throws IOException, FHIRFormatError {
    Contract.FriendlyLanguageComponent res = new Contract.FriendlyLanguageComponent();
    parseBackboneProperties(json, res);
    Type content = parseType("content", json);
    if (content != null)
      res.setContent(content);
    return res;
  }

  protected Contract.LegalLanguageComponent parseContractLegalLanguageComponent(JsonObject json, Contract owner)
      throws IOException, FHIRFormatError {
    Contract.LegalLanguageComponent res = new Contract.LegalLanguageComponent();
    parseBackboneProperties(json, res);
    Type content = parseType("content", json);
    if (content != null)
      res.setContent(content);
    return res;
  }

  protected Contract.ComputableLanguageComponent parseContractComputableLanguageComponent(JsonObject json,
      Contract owner) throws IOException, FHIRFormatError {
    Contract.ComputableLanguageComponent res = new Contract.ComputableLanguageComponent();
    parseBackboneProperties(json, res);
    Type content = parseType("content", json);
    if (content != null)
      res.setContent(content);
    return res;
  }

  protected Coverage parseCoverage(JsonObject json) throws IOException, FHIRFormatError {
    Coverage res = new Coverage();
    parseDomainResourceProperties(json, res);
    Type issuer = parseType("issuer", json);
    if (issuer != null)
      res.setIssuer(issuer);
    if (json.has("bin"))
      res.setBinElement(parseString(json.get("bin").getAsString()));
    if (json.has("_bin"))
      parseElementProperties(json.getAsJsonObject("_bin"), res.getBinElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    Type planholder = parseType("planholder", json);
    if (planholder != null)
      res.setPlanholder(planholder);
    Type beneficiary = parseType("beneficiary", json);
    if (beneficiary != null)
      res.setBeneficiary(beneficiary);
    if (json.has("relationship"))
      res.setRelationship(parseCoding(json.getAsJsonObject("relationship")));
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("group"))
      res.setGroupElement(parseString(json.get("group").getAsString()));
    if (json.has("_group"))
      parseElementProperties(json.getAsJsonObject("_group"), res.getGroupElement());
    if (json.has("plan"))
      res.setPlanElement(parseString(json.get("plan").getAsString()));
    if (json.has("_plan"))
      parseElementProperties(json.getAsJsonObject("_plan"), res.getPlanElement());
    if (json.has("subPlan"))
      res.setSubPlanElement(parseString(json.get("subPlan").getAsString()));
    if (json.has("_subPlan"))
      parseElementProperties(json.getAsJsonObject("_subPlan"), res.getSubPlanElement());
    if (json.has("dependent"))
      res.setDependentElement(parsePositiveInt(json.get("dependent").getAsString()));
    if (json.has("_dependent"))
      parseElementProperties(json.getAsJsonObject("_dependent"), res.getDependentElement());
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("exception")) {
      JsonArray array = json.getAsJsonArray("exception");
      for (int i = 0; i < array.size(); i++) {
        res.getException().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("school"))
      res.setSchoolElement(parseString(json.get("school").getAsString()));
    if (json.has("_school"))
      parseElementProperties(json.getAsJsonObject("_school"), res.getSchoolElement());
    if (json.has("network"))
      res.setNetworkElement(parseString(json.get("network").getAsString()));
    if (json.has("_network"))
      parseElementProperties(json.getAsJsonObject("_network"), res.getNetworkElement());
    if (json.has("contract")) {
      JsonArray array = json.getAsJsonArray("contract");
      for (int i = 0; i < array.size(); i++) {
        res.getContract().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected DataElement parseDataElement(JsonObject json) throws IOException, FHIRFormatError {
    DataElement res = new DataElement();
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(),
          Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseDataElementDataElementContactComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("copyright"))
      res.setCopyrightElement(parseString(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("stringency"))
      res.setStringencyElement(parseEnumeration(json.get("stringency").getAsString(),
          DataElement.DataElementStringency.NULL, new DataElement.DataElementStringencyEnumFactory()));
    if (json.has("_stringency"))
      parseElementProperties(json.getAsJsonObject("_stringency"), res.getStringencyElement());
    if (json.has("mapping")) {
      JsonArray array = json.getAsJsonArray("mapping");
      for (int i = 0; i < array.size(); i++) {
        res.getMapping().add(parseDataElementDataElementMappingComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("element")) {
      JsonArray array = json.getAsJsonArray("element");
      for (int i = 0; i < array.size(); i++) {
        res.getElement().add(parseElementDefinition(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected DataElement.DataElementContactComponent parseDataElementDataElementContactComponent(JsonObject json,
      DataElement owner) throws IOException, FHIRFormatError {
    DataElement.DataElementContactComponent res = new DataElement.DataElementContactComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected DataElement.DataElementMappingComponent parseDataElementDataElementMappingComponent(JsonObject json,
      DataElement owner) throws IOException, FHIRFormatError {
    DataElement.DataElementMappingComponent res = new DataElement.DataElementMappingComponent();
    parseBackboneProperties(json, res);
    if (json.has("identity"))
      res.setIdentityElement(parseId(json.get("identity").getAsString()));
    if (json.has("_identity"))
      parseElementProperties(json.getAsJsonObject("_identity"), res.getIdentityElement());
    if (json.has("uri"))
      res.setUriElement(parseUri(json.get("uri").getAsString()));
    if (json.has("_uri"))
      parseElementProperties(json.getAsJsonObject("_uri"), res.getUriElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    return res;
  }

  protected DecisionSupportRule parseDecisionSupportRule(JsonObject json) throws IOException, FHIRFormatError {
    DecisionSupportRule res = new DecisionSupportRule();
    parseDomainResourceProperties(json, res);
    if (json.has("moduleMetadata"))
      res.setModuleMetadata(parseModuleMetadata(json.getAsJsonObject("moduleMetadata")));
    if (json.has("library")) {
      JsonArray array = json.getAsJsonArray("library");
      for (int i = 0; i < array.size(); i++) {
        res.getLibrary().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("trigger")) {
      JsonArray array = json.getAsJsonArray("trigger");
      for (int i = 0; i < array.size(); i++) {
        res.getTrigger().add(parseTriggerDefinition(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("condition"))
      res.setConditionElement(parseString(json.get("condition").getAsString()));
    if (json.has("_condition"))
      parseElementProperties(json.getAsJsonObject("_condition"), res.getConditionElement());
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseActionDefinition(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected DecisionSupportServiceModule parseDecisionSupportServiceModule(JsonObject json)
      throws IOException, FHIRFormatError {
    DecisionSupportServiceModule res = new DecisionSupportServiceModule();
    parseDomainResourceProperties(json, res);
    if (json.has("moduleMetadata"))
      res.setModuleMetadata(parseModuleMetadata(json.getAsJsonObject("moduleMetadata")));
    if (json.has("trigger")) {
      JsonArray array = json.getAsJsonArray("trigger");
      for (int i = 0; i < array.size(); i++) {
        res.getTrigger().add(parseTriggerDefinition(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("parameter")) {
      JsonArray array = json.getAsJsonArray("parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter().add(parseParameterDefinition(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("dataRequirement")) {
      JsonArray array = json.getAsJsonArray("dataRequirement");
      for (int i = 0; i < array.size(); i++) {
        res.getDataRequirement().add(parseDataRequirement(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected DetectedIssue parseDetectedIssue(JsonObject json) throws IOException, FHIRFormatError {
    DetectedIssue res = new DetectedIssue();
    parseDomainResourceProperties(json, res);
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("severity"))
      res.setSeverityElement(parseEnumeration(json.get("severity").getAsString(),
          DetectedIssue.DetectedIssueSeverity.NULL, new DetectedIssue.DetectedIssueSeverityEnumFactory()));
    if (json.has("_severity"))
      parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
    if (json.has("implicated")) {
      JsonArray array = json.getAsJsonArray("implicated");
      for (int i = 0; i < array.size(); i++) {
        res.getImplicated().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("detail"))
      res.setDetailElement(parseString(json.get("detail").getAsString()));
    if (json.has("_detail"))
      parseElementProperties(json.getAsJsonObject("_detail"), res.getDetailElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("reference"))
      res.setReferenceElement(parseUri(json.get("reference").getAsString()));
    if (json.has("_reference"))
      parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
    if (json.has("mitigation")) {
      JsonArray array = json.getAsJsonArray("mitigation");
      for (int i = 0; i < array.size(); i++) {
        res.getMitigation()
            .add(parseDetectedIssueDetectedIssueMitigationComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected DetectedIssue.DetectedIssueMitigationComponent parseDetectedIssueDetectedIssueMitigationComponent(
      JsonObject json, DetectedIssue owner) throws IOException, FHIRFormatError {
    DetectedIssue.DetectedIssueMitigationComponent res = new DetectedIssue.DetectedIssueMitigationComponent();
    parseBackboneProperties(json, res);
    if (json.has("action"))
      res.setAction(parseCodeableConcept(json.getAsJsonObject("action")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    return res;
  }

  protected Device parseDevice(JsonObject json) throws IOException, FHIRFormatError {
    Device res = new Device();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("udiCarrier"))
      res.setUdiCarrier(parseIdentifier(json.getAsJsonObject("udiCarrier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Device.DeviceStatus.NULL,
          new Device.DeviceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("lotNumber"))
      res.setLotNumberElement(parseString(json.get("lotNumber").getAsString()));
    if (json.has("_lotNumber"))
      parseElementProperties(json.getAsJsonObject("_lotNumber"), res.getLotNumberElement());
    if (json.has("manufacturer"))
      res.setManufacturerElement(parseString(json.get("manufacturer").getAsString()));
    if (json.has("_manufacturer"))
      parseElementProperties(json.getAsJsonObject("_manufacturer"), res.getManufacturerElement());
    if (json.has("manufactureDate"))
      res.setManufactureDateElement(parseDateTime(json.get("manufactureDate").getAsString()));
    if (json.has("_manufactureDate"))
      parseElementProperties(json.getAsJsonObject("_manufactureDate"), res.getManufactureDateElement());
    if (json.has("expirationDate"))
      res.setExpirationDateElement(parseDateTime(json.get("expirationDate").getAsString()));
    if (json.has("_expirationDate"))
      parseElementProperties(json.getAsJsonObject("_expirationDate"), res.getExpirationDateElement());
    if (json.has("model"))
      res.setModelElement(parseString(json.get("model").getAsString()));
    if (json.has("_model"))
      parseElementProperties(json.getAsJsonObject("_model"), res.getModelElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("owner"))
      res.setOwner(parseReference(json.getAsJsonObject("owner")));
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected DeviceComponent parseDeviceComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceComponent res = new DeviceComponent();
    parseDomainResourceProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("lastSystemChange"))
      res.setLastSystemChangeElement(parseInstant(json.get("lastSystemChange").getAsString()));
    if (json.has("_lastSystemChange"))
      parseElementProperties(json.getAsJsonObject("_lastSystemChange"), res.getLastSystemChangeElement());
    if (json.has("source"))
      res.setSource(parseReference(json.getAsJsonObject("source")));
    if (json.has("parent"))
      res.setParent(parseReference(json.getAsJsonObject("parent")));
    if (json.has("operationalStatus")) {
      JsonArray array = json.getAsJsonArray("operationalStatus");
      for (int i = 0; i < array.size(); i++) {
        res.getOperationalStatus().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("parameterGroup"))
      res.setParameterGroup(parseCodeableConcept(json.getAsJsonObject("parameterGroup")));
    if (json.has("measurementPrinciple"))
      res.setMeasurementPrincipleElement(parseEnumeration(json.get("measurementPrinciple").getAsString(),
          DeviceComponent.MeasmntPrinciple.NULL, new DeviceComponent.MeasmntPrincipleEnumFactory()));
    if (json.has("_measurementPrinciple"))
      parseElementProperties(json.getAsJsonObject("_measurementPrinciple"), res.getMeasurementPrincipleElement());
    if (json.has("productionSpecification")) {
      JsonArray array = json.getAsJsonArray("productionSpecification");
      for (int i = 0; i < array.size(); i++) {
        res.getProductionSpecification().add(
            parseDeviceComponentDeviceComponentProductionSpecificationComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("languageCode"))
      res.setLanguageCode(parseCodeableConcept(json.getAsJsonObject("languageCode")));
    return res;
  }

  protected DeviceComponent.DeviceComponentProductionSpecificationComponent parseDeviceComponentDeviceComponentProductionSpecificationComponent(
      JsonObject json, DeviceComponent owner) throws IOException, FHIRFormatError {
    DeviceComponent.DeviceComponentProductionSpecificationComponent res = new DeviceComponent.DeviceComponentProductionSpecificationComponent();
    parseBackboneProperties(json, res);
    if (json.has("specType"))
      res.setSpecType(parseCodeableConcept(json.getAsJsonObject("specType")));
    if (json.has("componentId"))
      res.setComponentId(parseIdentifier(json.getAsJsonObject("componentId")));
    if (json.has("productionSpec"))
      res.setProductionSpecElement(parseString(json.get("productionSpec").getAsString()));
    if (json.has("_productionSpec"))
      parseElementProperties(json.getAsJsonObject("_productionSpec"), res.getProductionSpecElement());
    return res;
  }

  protected DeviceMetric parseDeviceMetric(JsonObject json) throws IOException, FHIRFormatError {
    DeviceMetric res = new DeviceMetric();
    parseDomainResourceProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("unit"))
      res.setUnit(parseCodeableConcept(json.getAsJsonObject("unit")));
    if (json.has("source"))
      res.setSource(parseReference(json.getAsJsonObject("source")));
    if (json.has("parent"))
      res.setParent(parseReference(json.getAsJsonObject("parent")));
    if (json.has("operationalStatus"))
      res.setOperationalStatusElement(
          parseEnumeration(json.get("operationalStatus").getAsString(), DeviceMetric.DeviceMetricOperationalStatus.NULL,
              new DeviceMetric.DeviceMetricOperationalStatusEnumFactory()));
    if (json.has("_operationalStatus"))
      parseElementProperties(json.getAsJsonObject("_operationalStatus"), res.getOperationalStatusElement());
    if (json.has("color"))
      res.setColorElement(parseEnumeration(json.get("color").getAsString(), DeviceMetric.DeviceMetricColor.NULL,
          new DeviceMetric.DeviceMetricColorEnumFactory()));
    if (json.has("_color"))
      parseElementProperties(json.getAsJsonObject("_color"), res.getColorElement());
    if (json.has("category"))
      res.setCategoryElement(parseEnumeration(json.get("category").getAsString(),
          DeviceMetric.DeviceMetricCategory.NULL, new DeviceMetric.DeviceMetricCategoryEnumFactory()));
    if (json.has("_category"))
      parseElementProperties(json.getAsJsonObject("_category"), res.getCategoryElement());
    if (json.has("measurementPeriod"))
      res.setMeasurementPeriod(parseTiming(json.getAsJsonObject("measurementPeriod")));
    if (json.has("calibration")) {
      JsonArray array = json.getAsJsonArray("calibration");
      for (int i = 0; i < array.size(); i++) {
        res.getCalibration()
            .add(parseDeviceMetricDeviceMetricCalibrationComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected DeviceMetric.DeviceMetricCalibrationComponent parseDeviceMetricDeviceMetricCalibrationComponent(
      JsonObject json, DeviceMetric owner) throws IOException, FHIRFormatError {
    DeviceMetric.DeviceMetricCalibrationComponent res = new DeviceMetric.DeviceMetricCalibrationComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), DeviceMetric.DeviceMetricCalibrationType.NULL,
          new DeviceMetric.DeviceMetricCalibrationTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("state"))
      res.setStateElement(parseEnumeration(json.get("state").getAsString(),
          DeviceMetric.DeviceMetricCalibrationState.NULL, new DeviceMetric.DeviceMetricCalibrationStateEnumFactory()));
    if (json.has("_state"))
      parseElementProperties(json.getAsJsonObject("_state"), res.getStateElement());
    if (json.has("time"))
      res.setTimeElement(parseInstant(json.get("time").getAsString()));
    if (json.has("_time"))
      parseElementProperties(json.getAsJsonObject("_time"), res.getTimeElement());
    return res;
  }

  protected DeviceUseRequest parseDeviceUseRequest(JsonObject json) throws IOException, FHIRFormatError {
    DeviceUseRequest res = new DeviceUseRequest();
    parseDomainResourceProperties(json, res);
    Type bodySite = parseType("bodySite", json);
    if (bodySite != null)
      res.setBodySite(bodySite);
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(),
          DeviceUseRequest.DeviceUseRequestStatus.NULL, new DeviceUseRequest.DeviceUseRequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("device"))
      res.setDevice(parseReference(json.getAsJsonObject("device")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("indication")) {
      JsonArray array = json.getAsJsonArray("indication");
      for (int i = 0; i < array.size(); i++) {
        res.getIndication().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("notes")) {
      JsonArray array = json.getAsJsonArray("notes");
      for (int i = 0; i < array.size(); i++) {
        res.getNotes().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_notes")) {
      JsonArray array = json.getAsJsonArray("_notes");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNotes().size())
          res.getNotes().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNotes().get(i));
      }
    }
    ;
    if (json.has("prnReason")) {
      JsonArray array = json.getAsJsonArray("prnReason");
      for (int i = 0; i < array.size(); i++) {
        res.getPrnReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("orderedOn"))
      res.setOrderedOnElement(parseDateTime(json.get("orderedOn").getAsString()));
    if (json.has("_orderedOn"))
      parseElementProperties(json.getAsJsonObject("_orderedOn"), res.getOrderedOnElement());
    if (json.has("recordedOn"))
      res.setRecordedOnElement(parseDateTime(json.get("recordedOn").getAsString()));
    if (json.has("_recordedOn"))
      parseElementProperties(json.getAsJsonObject("_recordedOn"), res.getRecordedOnElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    Type timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(),
          DeviceUseRequest.DeviceUseRequestPriority.NULL, new DeviceUseRequest.DeviceUseRequestPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    return res;
  }

  protected DeviceUseStatement parseDeviceUseStatement(JsonObject json) throws IOException, FHIRFormatError {
    DeviceUseStatement res = new DeviceUseStatement();
    parseDomainResourceProperties(json, res);
    Type bodySite = parseType("bodySite", json);
    if (bodySite != null)
      res.setBodySite(bodySite);
    if (json.has("whenUsed"))
      res.setWhenUsed(parsePeriod(json.getAsJsonObject("whenUsed")));
    if (json.has("device"))
      res.setDevice(parseReference(json.getAsJsonObject("device")));
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("indication")) {
      JsonArray array = json.getAsJsonArray("indication");
      for (int i = 0; i < array.size(); i++) {
        res.getIndication().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("notes")) {
      JsonArray array = json.getAsJsonArray("notes");
      for (int i = 0; i < array.size(); i++) {
        res.getNotes().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_notes")) {
      JsonArray array = json.getAsJsonArray("_notes");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNotes().size())
          res.getNotes().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNotes().get(i));
      }
    }
    ;
    if (json.has("recordedOn"))
      res.setRecordedOnElement(parseDateTime(json.get("recordedOn").getAsString()));
    if (json.has("_recordedOn"))
      parseElementProperties(json.getAsJsonObject("_recordedOn"), res.getRecordedOnElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    Type timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    return res;
  }

  protected DiagnosticOrder parseDiagnosticOrder(JsonObject json) throws IOException, FHIRFormatError {
    DiagnosticOrder res = new DiagnosticOrder();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(),
          DiagnosticOrder.DiagnosticOrderStatus.NULL, new DiagnosticOrder.DiagnosticOrderStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(),
          DiagnosticOrder.DiagnosticOrderPriority.NULL, new DiagnosticOrder.DiagnosticOrderPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("orderer"))
      res.setOrderer(parseReference(json.getAsJsonObject("orderer")));
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("supportingInformation")) {
      JsonArray array = json.getAsJsonArray("supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("specimen")) {
      JsonArray array = json.getAsJsonArray("specimen");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecimen().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("event")) {
      JsonArray array = json.getAsJsonArray("event");
      for (int i = 0; i < array.size(); i++) {
        res.getEvent().add(parseDiagnosticOrderDiagnosticOrderEventComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseDiagnosticOrderDiagnosticOrderItemComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected DiagnosticOrder.DiagnosticOrderEventComponent parseDiagnosticOrderDiagnosticOrderEventComponent(
      JsonObject json, DiagnosticOrder owner) throws IOException, FHIRFormatError {
    DiagnosticOrder.DiagnosticOrderEventComponent res = new DiagnosticOrder.DiagnosticOrderEventComponent();
    parseBackboneProperties(json, res);
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(),
          DiagnosticOrder.DiagnosticOrderStatus.NULL, new DiagnosticOrder.DiagnosticOrderStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("description"))
      res.setDescription(parseCodeableConcept(json.getAsJsonObject("description")));
    if (json.has("dateTime"))
      res.setDateTimeElement(parseDateTime(json.get("dateTime").getAsString()));
    if (json.has("_dateTime"))
      parseElementProperties(json.getAsJsonObject("_dateTime"), res.getDateTimeElement());
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
    return res;
  }

  protected DiagnosticOrder.DiagnosticOrderItemComponent parseDiagnosticOrderDiagnosticOrderItemComponent(
      JsonObject json, DiagnosticOrder owner) throws IOException, FHIRFormatError {
    DiagnosticOrder.DiagnosticOrderItemComponent res = new DiagnosticOrder.DiagnosticOrderItemComponent();
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("specimen")) {
      JsonArray array = json.getAsJsonArray("specimen");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecimen().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(json.getAsJsonObject("bodySite")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(),
          DiagnosticOrder.DiagnosticOrderStatus.NULL, new DiagnosticOrder.DiagnosticOrderStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("event")) {
      JsonArray array = json.getAsJsonArray("event");
      for (int i = 0; i < array.size(); i++) {
        res.getEvent().add(parseDiagnosticOrderDiagnosticOrderEventComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected DiagnosticReport parseDiagnosticReport(JsonObject json) throws IOException, FHIRFormatError {
    DiagnosticReport res = new DiagnosticReport();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(),
          DiagnosticReport.DiagnosticReportStatus.NULL, new DiagnosticReport.DiagnosticReportStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    Type effective = parseType("effective", json);
    if (effective != null)
      res.setEffective(effective);
    if (json.has("issued"))
      res.setIssuedElement(parseInstant(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
    if (json.has("performer"))
      res.setPerformer(parseReference(json.getAsJsonObject("performer")));
    if (json.has("request")) {
      JsonArray array = json.getAsJsonArray("request");
      for (int i = 0; i < array.size(); i++) {
        res.getRequest().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("specimen")) {
      JsonArray array = json.getAsJsonArray("specimen");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecimen().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("result")) {
      JsonArray array = json.getAsJsonArray("result");
      for (int i = 0; i < array.size(); i++) {
        res.getResult().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("imagingStudy")) {
      JsonArray array = json.getAsJsonArray("imagingStudy");
      for (int i = 0; i < array.size(); i++) {
        res.getImagingStudy().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("image")) {
      JsonArray array = json.getAsJsonArray("image");
      for (int i = 0; i < array.size(); i++) {
        res.getImage().add(parseDiagnosticReportDiagnosticReportImageComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("conclusion"))
      res.setConclusionElement(parseString(json.get("conclusion").getAsString()));
    if (json.has("_conclusion"))
      parseElementProperties(json.getAsJsonObject("_conclusion"), res.getConclusionElement());
    if (json.has("codedDiagnosis")) {
      JsonArray array = json.getAsJsonArray("codedDiagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getCodedDiagnosis().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("presentedForm")) {
      JsonArray array = json.getAsJsonArray("presentedForm");
      for (int i = 0; i < array.size(); i++) {
        res.getPresentedForm().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected DiagnosticReport.DiagnosticReportImageComponent parseDiagnosticReportDiagnosticReportImageComponent(
      JsonObject json, DiagnosticReport owner) throws IOException, FHIRFormatError {
    DiagnosticReport.DiagnosticReportImageComponent res = new DiagnosticReport.DiagnosticReportImageComponent();
    parseBackboneProperties(json, res);
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("link"))
      res.setLink(parseReference(json.getAsJsonObject("link")));
    return res;
  }

  protected DocumentManifest parseDocumentManifest(JsonObject json) throws IOException, FHIRFormatError {
    DocumentManifest res = new DocumentManifest();
    parseDomainResourceProperties(json, res);
    if (json.has("masterIdentifier"))
      res.setMasterIdentifier(parseIdentifier(json.getAsJsonObject("masterIdentifier")));
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("recipient")) {
      JsonArray array = json.getAsJsonArray("recipient");
      for (int i = 0; i < array.size(); i++) {
        res.getRecipient().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("source"))
      res.setSourceElement(parseUri(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.DocumentReferenceStatus.NULL,
          new Enumerations.DocumentReferenceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("content")) {
      JsonArray array = json.getAsJsonArray("content");
      for (int i = 0; i < array.size(); i++) {
        res.getContent()
            .add(parseDocumentManifestDocumentManifestContentComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("related")) {
      JsonArray array = json.getAsJsonArray("related");
      for (int i = 0; i < array.size(); i++) {
        res.getRelated()
            .add(parseDocumentManifestDocumentManifestRelatedComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected DocumentManifest.DocumentManifestContentComponent parseDocumentManifestDocumentManifestContentComponent(
      JsonObject json, DocumentManifest owner) throws IOException, FHIRFormatError {
    DocumentManifest.DocumentManifestContentComponent res = new DocumentManifest.DocumentManifestContentComponent();
    parseBackboneProperties(json, res);
    Type p = parseType("p", json);
    if (p != null)
      res.setP(p);
    return res;
  }

  protected DocumentManifest.DocumentManifestRelatedComponent parseDocumentManifestDocumentManifestRelatedComponent(
      JsonObject json, DocumentManifest owner) throws IOException, FHIRFormatError {
    DocumentManifest.DocumentManifestRelatedComponent res = new DocumentManifest.DocumentManifestRelatedComponent();
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("ref"))
      res.setRef(parseReference(json.getAsJsonObject("ref")));
    return res;
  }

  protected DocumentReference parseDocumentReference(JsonObject json) throws IOException, FHIRFormatError {
    DocumentReference res = new DocumentReference();
    parseDomainResourceProperties(json, res);
    if (json.has("masterIdentifier"))
      res.setMasterIdentifier(parseIdentifier(json.getAsJsonObject("masterIdentifier")));
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("class"))
      res.setClass_(parseCodeableConcept(json.getAsJsonObject("class")));
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("custodian"))
      res.setCustodian(parseReference(json.getAsJsonObject("custodian")));
    if (json.has("authenticator"))
      res.setAuthenticator(parseReference(json.getAsJsonObject("authenticator")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("indexed"))
      res.setIndexedElement(parseInstant(json.get("indexed").getAsString()));
    if (json.has("_indexed"))
      parseElementProperties(json.getAsJsonObject("_indexed"), res.getIndexedElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.DocumentReferenceStatus.NULL,
          new Enumerations.DocumentReferenceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("docStatus"))
      res.setDocStatus(parseCodeableConcept(json.getAsJsonObject("docStatus")));
    if (json.has("relatesTo")) {
      JsonArray array = json.getAsJsonArray("relatesTo");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatesTo()
            .add(parseDocumentReferenceDocumentReferenceRelatesToComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("securityLabel")) {
      JsonArray array = json.getAsJsonArray("securityLabel");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabel().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("content")) {
      JsonArray array = json.getAsJsonArray("content");
      for (int i = 0; i < array.size(); i++) {
        res.getContent()
            .add(parseDocumentReferenceDocumentReferenceContentComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("context"))
      res.setContext(parseDocumentReferenceDocumentReferenceContextComponent(json.getAsJsonObject("context"), res));
    return res;
  }

  protected DocumentReference.DocumentReferenceRelatesToComponent parseDocumentReferenceDocumentReferenceRelatesToComponent(
      JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceRelatesToComponent res = new DocumentReference.DocumentReferenceRelatesToComponent();
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(
          parseEnumeration(json.get("code").getAsString(), DocumentReference.DocumentRelationshipType.NULL,
              new DocumentReference.DocumentRelationshipTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("target"))
      res.setTarget(parseReference(json.getAsJsonObject("target")));
    return res;
  }

  protected DocumentReference.DocumentReferenceContentComponent parseDocumentReferenceDocumentReferenceContentComponent(
      JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceContentComponent res = new DocumentReference.DocumentReferenceContentComponent();
    parseBackboneProperties(json, res);
    if (json.has("attachment"))
      res.setAttachment(parseAttachment(json.getAsJsonObject("attachment")));
    if (json.has("format")) {
      JsonArray array = json.getAsJsonArray("format");
      for (int i = 0; i < array.size(); i++) {
        res.getFormat().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected DocumentReference.DocumentReferenceContextComponent parseDocumentReferenceDocumentReferenceContextComponent(
      JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceContextComponent res = new DocumentReference.DocumentReferenceContextComponent();
    parseBackboneProperties(json, res);
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("event")) {
      JsonArray array = json.getAsJsonArray("event");
      for (int i = 0; i < array.size(); i++) {
        res.getEvent().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("facilityType"))
      res.setFacilityType(parseCodeableConcept(json.getAsJsonObject("facilityType")));
    if (json.has("practiceSetting"))
      res.setPracticeSetting(parseCodeableConcept(json.getAsJsonObject("practiceSetting")));
    if (json.has("sourcePatientInfo"))
      res.setSourcePatientInfo(parseReference(json.getAsJsonObject("sourcePatientInfo")));
    if (json.has("related")) {
      JsonArray array = json.getAsJsonArray("related");
      for (int i = 0; i < array.size(); i++) {
        res.getRelated()
            .add(parseDocumentReferenceDocumentReferenceContextRelatedComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected DocumentReference.DocumentReferenceContextRelatedComponent parseDocumentReferenceDocumentReferenceContextRelatedComponent(
      JsonObject json, DocumentReference owner) throws IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceContextRelatedComponent res = new DocumentReference.DocumentReferenceContextRelatedComponent();
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("ref"))
      res.setRef(parseReference(json.getAsJsonObject("ref")));
    return res;
  }

  protected EligibilityRequest parseEligibilityRequest(JsonObject json) throws IOException, FHIRFormatError {
    EligibilityRequest res = new EligibilityRequest();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("ruleset"))
      res.setRuleset(parseCoding(json.getAsJsonObject("ruleset")));
    if (json.has("originalRuleset"))
      res.setOriginalRuleset(parseCoding(json.getAsJsonObject("originalRuleset")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    Type target = parseType("target", json);
    if (target != null)
      res.setTarget(target);
    Type provider = parseType("provider", json);
    if (provider != null)
      res.setProvider(provider);
    Type organization = parseType("organization", json);
    if (organization != null)
      res.setOrganization(organization);
    if (json.has("priority"))
      res.setPriority(parseCoding(json.getAsJsonObject("priority")));
    Type enterer = parseType("enterer", json);
    if (enterer != null)
      res.setEnterer(enterer);
    Type facility = parseType("facility", json);
    if (facility != null)
      res.setFacility(facility);
    Type patient = parseType("patient", json);
    if (patient != null)
      res.setPatient(patient);
    Type coverage = parseType("coverage", json);
    if (coverage != null)
      res.setCoverage(coverage);
    if (json.has("businessArrangement"))
      res.setBusinessArrangementElement(parseString(json.get("businessArrangement").getAsString()));
    if (json.has("_businessArrangement"))
      parseElementProperties(json.getAsJsonObject("_businessArrangement"), res.getBusinessArrangementElement());
    Type serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    if (json.has("benefitCategory"))
      res.setBenefitCategory(parseCoding(json.getAsJsonObject("benefitCategory")));
    if (json.has("benefitSubCategory"))
      res.setBenefitSubCategory(parseCoding(json.getAsJsonObject("benefitSubCategory")));
    return res;
  }

  protected EligibilityResponse parseEligibilityResponse(JsonObject json) throws IOException, FHIRFormatError {
    EligibilityResponse res = new EligibilityResponse();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    Type request = parseType("request", json);
    if (request != null)
      res.setRequest(request);
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), Enumerations.RemittanceOutcome.NULL,
          new Enumerations.RemittanceOutcomeEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
    if (json.has("ruleset"))
      res.setRuleset(parseCoding(json.getAsJsonObject("ruleset")));
    if (json.has("originalRuleset"))
      res.setOriginalRuleset(parseCoding(json.getAsJsonObject("originalRuleset")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    Type organization = parseType("organization", json);
    if (organization != null)
      res.setOrganization(organization);
    Type requestProvider = parseType("requestProvider", json);
    if (requestProvider != null)
      res.setRequestProvider(requestProvider);
    Type requestOrganization = parseType("requestOrganization", json);
    if (requestOrganization != null)
      res.setRequestOrganization(requestOrganization);
    if (json.has("inforce"))
      res.setInforceElement(parseBoolean(json.get("inforce").getAsBoolean()));
    if (json.has("_inforce"))
      parseElementProperties(json.getAsJsonObject("_inforce"), res.getInforceElement());
    if (json.has("contract"))
      res.setContract(parseReference(json.getAsJsonObject("contract")));
    if (json.has("form"))
      res.setForm(parseCoding(json.getAsJsonObject("form")));
    if (json.has("benefitBalance")) {
      JsonArray array = json.getAsJsonArray("benefitBalance");
      for (int i = 0; i < array.size(); i++) {
        res.getBenefitBalance().add(parseEligibilityResponseBenefitsComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("error")) {
      JsonArray array = json.getAsJsonArray("error");
      for (int i = 0; i < array.size(); i++) {
        res.getError().add(parseEligibilityResponseErrorsComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected EligibilityResponse.BenefitsComponent parseEligibilityResponseBenefitsComponent(JsonObject json,
      EligibilityResponse owner) throws IOException, FHIRFormatError {
    EligibilityResponse.BenefitsComponent res = new EligibilityResponse.BenefitsComponent();
    parseBackboneProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCoding(json.getAsJsonObject("category")));
    if (json.has("subCategory"))
      res.setSubCategory(parseCoding(json.getAsJsonObject("subCategory")));
    if (json.has("network"))
      res.setNetwork(parseCoding(json.getAsJsonObject("network")));
    if (json.has("unit"))
      res.setUnit(parseCoding(json.getAsJsonObject("unit")));
    if (json.has("term"))
      res.setTerm(parseCoding(json.getAsJsonObject("term")));
    if (json.has("financial")) {
      JsonArray array = json.getAsJsonArray("financial");
      for (int i = 0; i < array.size(); i++) {
        res.getFinancial().add(parseEligibilityResponseBenefitComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected EligibilityResponse.BenefitComponent parseEligibilityResponseBenefitComponent(JsonObject json,
      EligibilityResponse owner) throws IOException, FHIRFormatError {
    EligibilityResponse.BenefitComponent res = new EligibilityResponse.BenefitComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    Type benefit = parseType("benefit", json);
    if (benefit != null)
      res.setBenefit(benefit);
    Type benefitUsed = parseType("benefitUsed", json);
    if (benefitUsed != null)
      res.setBenefitUsed(benefitUsed);
    return res;
  }

  protected EligibilityResponse.ErrorsComponent parseEligibilityResponseErrorsComponent(JsonObject json,
      EligibilityResponse owner) throws IOException, FHIRFormatError {
    EligibilityResponse.ErrorsComponent res = new EligibilityResponse.ErrorsComponent();
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCoding(json.getAsJsonObject("code")));
    return res;
  }

  protected Encounter parseEncounter(JsonObject json) throws IOException, FHIRFormatError {
    Encounter res = new Encounter();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Encounter.EncounterState.NULL,
          new Encounter.EncounterStateEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusHistory")) {
      JsonArray array = json.getAsJsonArray("statusHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getStatusHistory().add(parseEncounterEncounterStatusHistoryComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("class"))
      res.setClass_Element(parseEnumeration(json.get("class").getAsString(), Encounter.EncounterClass.NULL,
          new Encounter.EncounterClassEnumFactory()));
    if (json.has("_class"))
      parseElementProperties(json.getAsJsonObject("_class"), res.getClass_Element());
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(json.getAsJsonObject("priority")));
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("episodeOfCare")) {
      JsonArray array = json.getAsJsonArray("episodeOfCare");
      for (int i = 0; i < array.size(); i++) {
        res.getEpisodeOfCare().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("incomingReferral")) {
      JsonArray array = json.getAsJsonArray("incomingReferral");
      for (int i = 0; i < array.size(); i++) {
        res.getIncomingReferral().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseEncounterEncounterParticipantComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("appointment"))
      res.setAppointment(parseReference(json.getAsJsonObject("appointment")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("length"))
      res.setLength(parseDuration(json.getAsJsonObject("length")));
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("indication")) {
      JsonArray array = json.getAsJsonArray("indication");
      for (int i = 0; i < array.size(); i++) {
        res.getIndication().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("hospitalization"))
      res.setHospitalization(
          parseEncounterEncounterHospitalizationComponent(json.getAsJsonObject("hospitalization"), res));
    if (json.has("location")) {
      JsonArray array = json.getAsJsonArray("location");
      for (int i = 0; i < array.size(); i++) {
        res.getLocation().add(parseEncounterEncounterLocationComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("serviceProvider"))
      res.setServiceProvider(parseReference(json.getAsJsonObject("serviceProvider")));
    if (json.has("partOf"))
      res.setPartOf(parseReference(json.getAsJsonObject("partOf")));
    return res;
  }

  protected Encounter.EncounterStatusHistoryComponent parseEncounterEncounterStatusHistoryComponent(JsonObject json,
      Encounter owner) throws IOException, FHIRFormatError {
    Encounter.EncounterStatusHistoryComponent res = new Encounter.EncounterStatusHistoryComponent();
    parseBackboneProperties(json, res);
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Encounter.EncounterState.NULL,
          new Encounter.EncounterStateEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    return res;
  }

  protected Encounter.EncounterParticipantComponent parseEncounterEncounterParticipantComponent(JsonObject json,
      Encounter owner) throws IOException, FHIRFormatError {
    Encounter.EncounterParticipantComponent res = new Encounter.EncounterParticipantComponent();
    parseBackboneProperties(json, res);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("individual"))
      res.setIndividual(parseReference(json.getAsJsonObject("individual")));
    return res;
  }

  protected Encounter.EncounterHospitalizationComponent parseEncounterEncounterHospitalizationComponent(JsonObject json,
      Encounter owner) throws IOException, FHIRFormatError {
    Encounter.EncounterHospitalizationComponent res = new Encounter.EncounterHospitalizationComponent();
    parseBackboneProperties(json, res);
    if (json.has("preAdmissionIdentifier"))
      res.setPreAdmissionIdentifier(parseIdentifier(json.getAsJsonObject("preAdmissionIdentifier")));
    if (json.has("origin"))
      res.setOrigin(parseReference(json.getAsJsonObject("origin")));
    if (json.has("admitSource"))
      res.setAdmitSource(parseCodeableConcept(json.getAsJsonObject("admitSource")));
    if (json.has("admittingDiagnosis")) {
      JsonArray array = json.getAsJsonArray("admittingDiagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getAdmittingDiagnosis().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("reAdmission"))
      res.setReAdmission(parseCodeableConcept(json.getAsJsonObject("reAdmission")));
    if (json.has("dietPreference")) {
      JsonArray array = json.getAsJsonArray("dietPreference");
      for (int i = 0; i < array.size(); i++) {
        res.getDietPreference().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("specialCourtesy")) {
      JsonArray array = json.getAsJsonArray("specialCourtesy");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialCourtesy().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("specialArrangement")) {
      JsonArray array = json.getAsJsonArray("specialArrangement");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialArrangement().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("destination"))
      res.setDestination(parseReference(json.getAsJsonObject("destination")));
    if (json.has("dischargeDisposition"))
      res.setDischargeDisposition(parseCodeableConcept(json.getAsJsonObject("dischargeDisposition")));
    if (json.has("dischargeDiagnosis")) {
      JsonArray array = json.getAsJsonArray("dischargeDiagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDischargeDiagnosis().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected Encounter.EncounterLocationComponent parseEncounterEncounterLocationComponent(JsonObject json,
      Encounter owner) throws IOException, FHIRFormatError {
    Encounter.EncounterLocationComponent res = new Encounter.EncounterLocationComponent();
    parseBackboneProperties(json, res);
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Encounter.EncounterLocationStatus.NULL,
          new Encounter.EncounterLocationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    return res;
  }

  protected EnrollmentRequest parseEnrollmentRequest(JsonObject json) throws IOException, FHIRFormatError {
    EnrollmentRequest res = new EnrollmentRequest();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("ruleset"))
      res.setRuleset(parseCoding(json.getAsJsonObject("ruleset")));
    if (json.has("originalRuleset"))
      res.setOriginalRuleset(parseCoding(json.getAsJsonObject("originalRuleset")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("target"))
      res.setTarget(parseReference(json.getAsJsonObject("target")));
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("organization"))
      res.setOrganization(parseReference(json.getAsJsonObject("organization")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("coverage"))
      res.setCoverage(parseReference(json.getAsJsonObject("coverage")));
    if (json.has("relationship"))
      res.setRelationship(parseCoding(json.getAsJsonObject("relationship")));
    return res;
  }

  protected EnrollmentResponse parseEnrollmentResponse(JsonObject json) throws IOException, FHIRFormatError {
    EnrollmentResponse res = new EnrollmentResponse();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("request"))
      res.setRequest(parseReference(json.getAsJsonObject("request")));
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), Enumerations.RemittanceOutcome.NULL,
          new Enumerations.RemittanceOutcomeEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
    if (json.has("ruleset"))
      res.setRuleset(parseCoding(json.getAsJsonObject("ruleset")));
    if (json.has("originalRuleset"))
      res.setOriginalRuleset(parseCoding(json.getAsJsonObject("originalRuleset")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("organization"))
      res.setOrganization(parseReference(json.getAsJsonObject("organization")));
    if (json.has("requestProvider"))
      res.setRequestProvider(parseReference(json.getAsJsonObject("requestProvider")));
    if (json.has("requestOrganization"))
      res.setRequestOrganization(parseReference(json.getAsJsonObject("requestOrganization")));
    return res;
  }

  protected EpisodeOfCare parseEpisodeOfCare(JsonObject json) throws IOException, FHIRFormatError {
    EpisodeOfCare res = new EpisodeOfCare();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), EpisodeOfCare.EpisodeOfCareStatus.NULL,
          new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusHistory")) {
      JsonArray array = json.getAsJsonArray("statusHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getStatusHistory()
            .add(parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("condition")) {
      JsonArray array = json.getAsJsonArray("condition");
      for (int i = 0; i < array.size(); i++) {
        res.getCondition().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("managingOrganization"))
      res.setManagingOrganization(parseReference(json.getAsJsonObject("managingOrganization")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("referralRequest")) {
      JsonArray array = json.getAsJsonArray("referralRequest");
      for (int i = 0; i < array.size(); i++) {
        res.getReferralRequest().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("careManager"))
      res.setCareManager(parseReference(json.getAsJsonObject("careManager")));
    if (json.has("team")) {
      JsonArray array = json.getAsJsonArray("team");
      for (int i = 0; i < array.size(); i++) {
        res.getTeam().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected EpisodeOfCare.EpisodeOfCareStatusHistoryComponent parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(
      JsonObject json, EpisodeOfCare owner) throws IOException, FHIRFormatError {
    EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
    parseBackboneProperties(json, res);
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), EpisodeOfCare.EpisodeOfCareStatus.NULL,
          new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    return res;
  }

  protected ExpansionProfile parseExpansionProfile(JsonObject json) throws IOException, FHIRFormatError {
    ExpansionProfile res = new ExpansionProfile();
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(),
          Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact()
            .add(parseExpansionProfileExpansionProfileContactComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("codeSystem"))
      res.setCodeSystem(
          parseExpansionProfileExpansionProfileCodeSystemComponent(json.getAsJsonObject("codeSystem"), res));
    if (json.has("includeDesignations"))
      res.setIncludeDesignationsElement(parseBoolean(json.get("includeDesignations").getAsBoolean()));
    if (json.has("_includeDesignations"))
      parseElementProperties(json.getAsJsonObject("_includeDesignations"), res.getIncludeDesignationsElement());
    if (json.has("designation"))
      res.setDesignation(
          parseExpansionProfileExpansionProfileDesignationComponent(json.getAsJsonObject("designation"), res));
    if (json.has("includeDefinition"))
      res.setIncludeDefinitionElement(parseBoolean(json.get("includeDefinition").getAsBoolean()));
    if (json.has("_includeDefinition"))
      parseElementProperties(json.getAsJsonObject("_includeDefinition"), res.getIncludeDefinitionElement());
    if (json.has("includeInactive"))
      res.setIncludeInactiveElement(parseBoolean(json.get("includeInactive").getAsBoolean()));
    if (json.has("_includeInactive"))
      parseElementProperties(json.getAsJsonObject("_includeInactive"), res.getIncludeInactiveElement());
    if (json.has("excludeNested"))
      res.setExcludeNestedElement(parseBoolean(json.get("excludeNested").getAsBoolean()));
    if (json.has("_excludeNested"))
      parseElementProperties(json.getAsJsonObject("_excludeNested"), res.getExcludeNestedElement());
    if (json.has("excludeNotForUI"))
      res.setExcludeNotForUIElement(parseBoolean(json.get("excludeNotForUI").getAsBoolean()));
    if (json.has("_excludeNotForUI"))
      parseElementProperties(json.getAsJsonObject("_excludeNotForUI"), res.getExcludeNotForUIElement());
    if (json.has("excludePostCoordinated"))
      res.setExcludePostCoordinatedElement(parseBoolean(json.get("excludePostCoordinated").getAsBoolean()));
    if (json.has("_excludePostCoordinated"))
      parseElementProperties(json.getAsJsonObject("_excludePostCoordinated"), res.getExcludePostCoordinatedElement());
    if (json.has("displayLanguage"))
      res.setDisplayLanguageElement(parseCode(json.get("displayLanguage").getAsString()));
    if (json.has("_displayLanguage"))
      parseElementProperties(json.getAsJsonObject("_displayLanguage"), res.getDisplayLanguageElement());
    if (json.has("limitedExpansion"))
      res.setLimitedExpansionElement(parseBoolean(json.get("limitedExpansion").getAsBoolean()));
    if (json.has("_limitedExpansion"))
      parseElementProperties(json.getAsJsonObject("_limitedExpansion"), res.getLimitedExpansionElement());
    return res;
  }

  protected ExpansionProfile.ExpansionProfileContactComponent parseExpansionProfileExpansionProfileContactComponent(
      JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
    ExpansionProfile.ExpansionProfileContactComponent res = new ExpansionProfile.ExpansionProfileContactComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected ExpansionProfile.ExpansionProfileCodeSystemComponent parseExpansionProfileExpansionProfileCodeSystemComponent(
      JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
    ExpansionProfile.ExpansionProfileCodeSystemComponent res = new ExpansionProfile.ExpansionProfileCodeSystemComponent();
    parseBackboneProperties(json, res);
    if (json.has("include"))
      res.setInclude(parseExpansionProfileCodeSystemIncludeComponent(json.getAsJsonObject("include"), owner));
    if (json.has("exclude"))
      res.setExclude(parseExpansionProfileCodeSystemExcludeComponent(json.getAsJsonObject("exclude"), owner));
    return res;
  }

  protected ExpansionProfile.CodeSystemIncludeComponent parseExpansionProfileCodeSystemIncludeComponent(JsonObject json,
      ExpansionProfile owner) throws IOException, FHIRFormatError {
    ExpansionProfile.CodeSystemIncludeComponent res = new ExpansionProfile.CodeSystemIncludeComponent();
    parseBackboneProperties(json, res);
    if (json.has("codeSystem")) {
      JsonArray array = json.getAsJsonArray("codeSystem");
      for (int i = 0; i < array.size(); i++) {
        res.getCodeSystem()
            .add(parseExpansionProfileCodeSystemIncludeCodeSystemComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ExpansionProfile.CodeSystemIncludeCodeSystemComponent parseExpansionProfileCodeSystemIncludeCodeSystemComponent(
      JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
    ExpansionProfile.CodeSystemIncludeCodeSystemComponent res = new ExpansionProfile.CodeSystemIncludeCodeSystemComponent();
    parseBackboneProperties(json, res);
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    return res;
  }

  protected ExpansionProfile.CodeSystemExcludeComponent parseExpansionProfileCodeSystemExcludeComponent(JsonObject json,
      ExpansionProfile owner) throws IOException, FHIRFormatError {
    ExpansionProfile.CodeSystemExcludeComponent res = new ExpansionProfile.CodeSystemExcludeComponent();
    parseBackboneProperties(json, res);
    if (json.has("codeSystem")) {
      JsonArray array = json.getAsJsonArray("codeSystem");
      for (int i = 0; i < array.size(); i++) {
        res.getCodeSystem()
            .add(parseExpansionProfileCodeSystemExcludeCodeSystemComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ExpansionProfile.CodeSystemExcludeCodeSystemComponent parseExpansionProfileCodeSystemExcludeCodeSystemComponent(
      JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
    ExpansionProfile.CodeSystemExcludeCodeSystemComponent res = new ExpansionProfile.CodeSystemExcludeCodeSystemComponent();
    parseBackboneProperties(json, res);
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    return res;
  }

  protected ExpansionProfile.ExpansionProfileDesignationComponent parseExpansionProfileExpansionProfileDesignationComponent(
      JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
    ExpansionProfile.ExpansionProfileDesignationComponent res = new ExpansionProfile.ExpansionProfileDesignationComponent();
    parseBackboneProperties(json, res);
    if (json.has("include"))
      res.setInclude(parseExpansionProfileDesignationIncludeComponent(json.getAsJsonObject("include"), owner));
    if (json.has("exclude"))
      res.setExclude(parseExpansionProfileDesignationExcludeComponent(json.getAsJsonObject("exclude"), owner));
    return res;
  }

  protected ExpansionProfile.DesignationIncludeComponent parseExpansionProfileDesignationIncludeComponent(
      JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
    ExpansionProfile.DesignationIncludeComponent res = new ExpansionProfile.DesignationIncludeComponent();
    parseBackboneProperties(json, res);
    if (json.has("designation")) {
      JsonArray array = json.getAsJsonArray("designation");
      for (int i = 0; i < array.size(); i++) {
        res.getDesignation()
            .add(parseExpansionProfileDesignationIncludeDesignationComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ExpansionProfile.DesignationIncludeDesignationComponent parseExpansionProfileDesignationIncludeDesignationComponent(
      JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
    ExpansionProfile.DesignationIncludeDesignationComponent res = new ExpansionProfile.DesignationIncludeDesignationComponent();
    parseBackboneProperties(json, res);
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("use"))
      res.setUse(parseCoding(json.getAsJsonObject("use")));
    return res;
  }

  protected ExpansionProfile.DesignationExcludeComponent parseExpansionProfileDesignationExcludeComponent(
      JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
    ExpansionProfile.DesignationExcludeComponent res = new ExpansionProfile.DesignationExcludeComponent();
    parseBackboneProperties(json, res);
    if (json.has("designation")) {
      JsonArray array = json.getAsJsonArray("designation");
      for (int i = 0; i < array.size(); i++) {
        res.getDesignation()
            .add(parseExpansionProfileDesignationExcludeDesignationComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ExpansionProfile.DesignationExcludeDesignationComponent parseExpansionProfileDesignationExcludeDesignationComponent(
      JsonObject json, ExpansionProfile owner) throws IOException, FHIRFormatError {
    ExpansionProfile.DesignationExcludeDesignationComponent res = new ExpansionProfile.DesignationExcludeDesignationComponent();
    parseBackboneProperties(json, res);
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("use"))
      res.setUse(parseCoding(json.getAsJsonObject("use")));
    return res;
  }

  protected ExplanationOfBenefit parseExplanationOfBenefit(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit res = new ExplanationOfBenefit();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    Type claim = parseType("claim", json);
    if (claim != null)
      res.setClaim(claim);
    Type claimResponse = parseType("claimResponse", json);
    if (claimResponse != null)
      res.setClaimResponse(claimResponse);
    if (json.has("subType")) {
      JsonArray array = json.getAsJsonArray("subType");
      for (int i = 0; i < array.size(); i++) {
        res.getSubType().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("ruleset"))
      res.setRuleset(parseCoding(json.getAsJsonObject("ruleset")));
    if (json.has("originalRuleset"))
      res.setOriginalRuleset(parseCoding(json.getAsJsonObject("originalRuleset")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("billablePeriod"))
      res.setBillablePeriod(parsePeriod(json.getAsJsonObject("billablePeriod")));
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
    Type provider = parseType("provider", json);
    if (provider != null)
      res.setProvider(provider);
    Type organization = parseType("organization", json);
    if (organization != null)
      res.setOrganization(organization);
    Type facility = parseType("facility", json);
    if (facility != null)
      res.setFacility(facility);
    if (json.has("related")) {
      JsonArray array = json.getAsJsonArray("related");
      for (int i = 0; i < array.size(); i++) {
        res.getRelated().add(parseExplanationOfBenefitRelatedClaimsComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    Type prescription = parseType("prescription", json);
    if (prescription != null)
      res.setPrescription(prescription);
    Type originalPrescription = parseType("originalPrescription", json);
    if (originalPrescription != null)
      res.setOriginalPrescription(originalPrescription);
    if (json.has("payee"))
      res.setPayee(parseExplanationOfBenefitPayeeComponent(json.getAsJsonObject("payee"), res));
    Type referral = parseType("referral", json);
    if (referral != null)
      res.setReferral(referral);
    if (json.has("occurrenceCode")) {
      JsonArray array = json.getAsJsonArray("occurrenceCode");
      for (int i = 0; i < array.size(); i++) {
        res.getOccurrenceCode().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("occurenceSpanCode")) {
      JsonArray array = json.getAsJsonArray("occurenceSpanCode");
      for (int i = 0; i < array.size(); i++) {
        res.getOccurenceSpanCode().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("valueCode")) {
      JsonArray array = json.getAsJsonArray("valueCode");
      for (int i = 0; i < array.size(); i++) {
        res.getValueCode().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("diagnosis")) {
      JsonArray array = json.getAsJsonArray("diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseExplanationOfBenefitDiagnosisComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("procedure")) {
      JsonArray array = json.getAsJsonArray("procedure");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedure().add(parseExplanationOfBenefitProcedureComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("specialCondition")) {
      JsonArray array = json.getAsJsonArray("specialCondition");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialCondition().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    Type patient = parseType("patient", json);
    if (patient != null)
      res.setPatient(patient);
    if (json.has("precedence"))
      res.setPrecedenceElement(parsePositiveInt(json.get("precedence").getAsString()));
    if (json.has("_precedence"))
      parseElementProperties(json.getAsJsonObject("_precedence"), res.getPrecedenceElement());
    if (json.has("coverage"))
      res.setCoverage(parseExplanationOfBenefitCoverageComponent(json.getAsJsonObject("coverage"), res));
    if (json.has("accidentDate"))
      res.setAccidentDateElement(parseDate(json.get("accidentDate").getAsString()));
    if (json.has("_accidentDate"))
      parseElementProperties(json.getAsJsonObject("_accidentDate"), res.getAccidentDateElement());
    if (json.has("accidentType"))
      res.setAccidentType(parseCoding(json.getAsJsonObject("accidentType")));
    Type accidentLocation = parseType("accidentLocation", json);
    if (accidentLocation != null)
      res.setAccidentLocation(accidentLocation);
    if (json.has("interventionException")) {
      JsonArray array = json.getAsJsonArray("interventionException");
      for (int i = 0; i < array.size(); i++) {
        res.getInterventionException().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("onset")) {
      JsonArray array = json.getAsJsonArray("onset");
      for (int i = 0; i < array.size(); i++) {
        res.getOnset().add(parseExplanationOfBenefitOnsetComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("employmentImpacted"))
      res.setEmploymentImpacted(parsePeriod(json.getAsJsonObject("employmentImpacted")));
    if (json.has("hospitalization"))
      res.setHospitalization(parsePeriod(json.getAsJsonObject("hospitalization")));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseExplanationOfBenefitItemsComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("addItem")) {
      JsonArray array = json.getAsJsonArray("addItem");
      for (int i = 0; i < array.size(); i++) {
        res.getAddItem().add(parseExplanationOfBenefitAddedItemComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("missingTeeth")) {
      JsonArray array = json.getAsJsonArray("missingTeeth");
      for (int i = 0; i < array.size(); i++) {
        res.getMissingTeeth().add(parseExplanationOfBenefitMissingTeethComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("totalCost"))
      res.setTotalCost(parseMoney(json.getAsJsonObject("totalCost")));
    if (json.has("unallocDeductable"))
      res.setUnallocDeductable(parseMoney(json.getAsJsonObject("unallocDeductable")));
    if (json.has("totalBenefit"))
      res.setTotalBenefit(parseMoney(json.getAsJsonObject("totalBenefit")));
    if (json.has("paymentAdjustment"))
      res.setPaymentAdjustment(parseMoney(json.getAsJsonObject("paymentAdjustment")));
    if (json.has("paymentAdjustmentReason"))
      res.setPaymentAdjustmentReason(parseCoding(json.getAsJsonObject("paymentAdjustmentReason")));
    if (json.has("paymentDate"))
      res.setPaymentDateElement(parseDate(json.get("paymentDate").getAsString()));
    if (json.has("_paymentDate"))
      parseElementProperties(json.getAsJsonObject("_paymentDate"), res.getPaymentDateElement());
    if (json.has("paymentAmount"))
      res.setPaymentAmount(parseMoney(json.getAsJsonObject("paymentAmount")));
    if (json.has("paymentRef"))
      res.setPaymentRef(parseIdentifier(json.getAsJsonObject("paymentRef")));
    if (json.has("reserved"))
      res.setReserved(parseCoding(json.getAsJsonObject("reserved")));
    if (json.has("form"))
      res.setForm(parseCoding(json.getAsJsonObject("form")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseExplanationOfBenefitNotesComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("benefitBalance")) {
      JsonArray array = json.getAsJsonArray("benefitBalance");
      for (int i = 0; i < array.size(); i++) {
        res.getBenefitBalance()
            .add(parseExplanationOfBenefitBenefitBalanceComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected ExplanationOfBenefit.RelatedClaimsComponent parseExplanationOfBenefitRelatedClaimsComponent(JsonObject json,
      ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.RelatedClaimsComponent res = new ExplanationOfBenefit.RelatedClaimsComponent();
    parseBackboneProperties(json, res);
    Type claim = parseType("claim", json);
    if (claim != null)
      res.setClaim(claim);
    if (json.has("relationship"))
      res.setRelationship(parseCoding(json.getAsJsonObject("relationship")));
    if (json.has("reference"))
      res.setReference(parseIdentifier(json.getAsJsonObject("reference")));
    return res;
  }

  protected ExplanationOfBenefit.PayeeComponent parseExplanationOfBenefitPayeeComponent(JsonObject json,
      ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.PayeeComponent res = new ExplanationOfBenefit.PayeeComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    Type party = parseType("party", json);
    if (party != null)
      res.setParty(party);
    return res;
  }

  protected ExplanationOfBenefit.DiagnosisComponent parseExplanationOfBenefitDiagnosisComponent(JsonObject json,
      ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.DiagnosisComponent res = new ExplanationOfBenefit.DiagnosisComponent();
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("diagnosis"))
      res.setDiagnosis(parseCoding(json.getAsJsonObject("diagnosis")));
    return res;
  }

  protected ExplanationOfBenefit.ProcedureComponent parseExplanationOfBenefitProcedureComponent(JsonObject json,
      ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.ProcedureComponent res = new ExplanationOfBenefit.ProcedureComponent();
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    Type procedure = parseType("procedure", json);
    if (procedure != null)
      res.setProcedure(procedure);
    return res;
  }

  protected ExplanationOfBenefit.CoverageComponent parseExplanationOfBenefitCoverageComponent(JsonObject json,
      ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.CoverageComponent res = new ExplanationOfBenefit.CoverageComponent();
    parseBackboneProperties(json, res);
    Type coverage = parseType("coverage", json);
    if (coverage != null)
      res.setCoverage(coverage);
    if (json.has("preAuthRef")) {
      JsonArray array = json.getAsJsonArray("preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        res.getPreAuthRef().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_preAuthRef")) {
      JsonArray array = json.getAsJsonArray("_preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPreAuthRef().size())
          res.getPreAuthRef().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPreAuthRef().get(i));
      }
    }
    ;
    return res;
  }

  protected ExplanationOfBenefit.OnsetComponent parseExplanationOfBenefitOnsetComponent(JsonObject json,
      ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.OnsetComponent res = new ExplanationOfBenefit.OnsetComponent();
    parseBackboneProperties(json, res);
    Type time = parseType("time", json);
    if (time != null)
      res.setTime(time);
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    return res;
  }

  protected ExplanationOfBenefit.ItemsComponent parseExplanationOfBenefitItemsComponent(JsonObject json,
      ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.ItemsComponent res = new ExplanationOfBenefit.ItemsComponent();
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    Type provider = parseType("provider", json);
    if (provider != null)
      res.setProvider(provider);
    Type supervisor = parseType("supervisor", json);
    if (supervisor != null)
      res.setSupervisor(supervisor);
    if (json.has("providerQualification"))
      res.setProviderQualification(parseCoding(json.getAsJsonObject("providerQualification")));
    if (json.has("diagnosisLinkId")) {
      JsonArray array = json.getAsJsonArray("diagnosisLinkId");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosisLinkId().add(parsePositiveInt(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_diagnosisLinkId")) {
      JsonArray array = json.getAsJsonArray("_diagnosisLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDiagnosisLinkId().size())
          res.getDiagnosisLinkId().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDiagnosisLinkId().get(i));
      }
    }
    ;
    if (json.has("service"))
      res.setService(parseCoding(json.getAsJsonObject("service")));
    if (json.has("serviceModifier")) {
      JsonArray array = json.getAsJsonArray("serviceModifier");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceModifier().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    Type serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    if (json.has("place"))
      res.setPlace(parseCoding(json.getAsJsonObject("place")));
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("points"))
      res.setPointsElement(parseDecimal(json.get("points").getAsBigDecimal()));
    if (json.has("_points"))
      parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("bodySite"))
      res.setBodySite(parseCoding(json.getAsJsonObject("bodySite")));
    if (json.has("subSite")) {
      JsonArray array = json.getAsJsonArray("subSite");
      for (int i = 0; i < array.size(); i++) {
        res.getSubSite().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    }
    ;
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication()
            .add(parseExplanationOfBenefitItemAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseExplanationOfBenefitDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("prosthesis"))
      res.setProsthesis(parseExplanationOfBenefitProsthesisComponent(json.getAsJsonObject("prosthesis"), owner));
    return res;
  }

  protected ExplanationOfBenefit.ItemAdjudicationComponent parseExplanationOfBenefitItemAdjudicationComponent(
      JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.ItemAdjudicationComponent res = new ExplanationOfBenefit.ItemAdjudicationComponent();
    parseBackboneProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCoding(json.getAsJsonObject("category")));
    if (json.has("reason"))
      res.setReason(parseCoding(json.getAsJsonObject("reason")));
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    return res;
  }

  protected ExplanationOfBenefit.DetailComponent parseExplanationOfBenefitDetailComponent(JsonObject json,
      ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.DetailComponent res = new ExplanationOfBenefit.DetailComponent();
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("service"))
      res.setService(parseCoding(json.getAsJsonObject("service")));
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("points"))
      res.setPointsElement(parseDecimal(json.get("points").getAsBigDecimal()));
    if (json.has("_points"))
      parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication()
            .add(parseExplanationOfBenefitDetailAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("subDetail")) {
      JsonArray array = json.getAsJsonArray("subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseExplanationOfBenefitSubDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ExplanationOfBenefit.DetailAdjudicationComponent parseExplanationOfBenefitDetailAdjudicationComponent(
      JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.DetailAdjudicationComponent res = new ExplanationOfBenefit.DetailAdjudicationComponent();
    parseBackboneProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCoding(json.getAsJsonObject("category")));
    if (json.has("reason"))
      res.setReason(parseCoding(json.getAsJsonObject("reason")));
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    return res;
  }

  protected ExplanationOfBenefit.SubDetailComponent parseExplanationOfBenefitSubDetailComponent(JsonObject json,
      ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.SubDetailComponent res = new ExplanationOfBenefit.SubDetailComponent();
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("service"))
      res.setService(parseCoding(json.getAsJsonObject("service")));
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("points"))
      res.setPointsElement(parseDecimal(json.get("points").getAsBigDecimal()));
    if (json.has("_points"))
      parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication()
            .add(parseExplanationOfBenefitSubDetailAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ExplanationOfBenefit.SubDetailAdjudicationComponent parseExplanationOfBenefitSubDetailAdjudicationComponent(
      JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.SubDetailAdjudicationComponent res = new ExplanationOfBenefit.SubDetailAdjudicationComponent();
    parseBackboneProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCoding(json.getAsJsonObject("category")));
    if (json.has("reason"))
      res.setReason(parseCoding(json.getAsJsonObject("reason")));
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    return res;
  }

  protected ExplanationOfBenefit.ProsthesisComponent parseExplanationOfBenefitProsthesisComponent(JsonObject json,
      ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.ProsthesisComponent res = new ExplanationOfBenefit.ProsthesisComponent();
    parseBackboneProperties(json, res);
    if (json.has("initial"))
      res.setInitialElement(parseBoolean(json.get("initial").getAsBoolean()));
    if (json.has("_initial"))
      parseElementProperties(json.getAsJsonObject("_initial"), res.getInitialElement());
    if (json.has("priorDate"))
      res.setPriorDateElement(parseDate(json.get("priorDate").getAsString()));
    if (json.has("_priorDate"))
      parseElementProperties(json.getAsJsonObject("_priorDate"), res.getPriorDateElement());
    if (json.has("priorMaterial"))
      res.setPriorMaterial(parseCoding(json.getAsJsonObject("priorMaterial")));
    return res;
  }

  protected ExplanationOfBenefit.AddedItemComponent parseExplanationOfBenefitAddedItemComponent(JsonObject json,
      ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemComponent res = new ExplanationOfBenefit.AddedItemComponent();
    parseBackboneProperties(json, res);
    if (json.has("sequenceLinkId")) {
      JsonArray array = json.getAsJsonArray("sequenceLinkId");
      for (int i = 0; i < array.size(); i++) {
        res.getSequenceLinkId().add(parsePositiveInt(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_sequenceLinkId")) {
      JsonArray array = json.getAsJsonArray("_sequenceLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSequenceLinkId().size())
          res.getSequenceLinkId().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSequenceLinkId().get(i));
      }
    }
    ;
    if (json.has("service"))
      res.setService(parseCoding(json.getAsJsonObject("service")));
    if (json.has("fee"))
      res.setFee(parseMoney(json.getAsJsonObject("fee")));
    if (json.has("noteNumberLinkId")) {
      JsonArray array = json.getAsJsonArray("noteNumberLinkId");
      for (int i = 0; i < array.size(); i++) {
        res.getNoteNumberLinkId().add(parsePositiveInt(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_noteNumberLinkId")) {
      JsonArray array = json.getAsJsonArray("_noteNumberLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumberLinkId().size())
          res.getNoteNumberLinkId().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumberLinkId().get(i));
      }
    }
    ;
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication()
            .add(parseExplanationOfBenefitAddedItemAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseExplanationOfBenefitAddedItemsDetailComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ExplanationOfBenefit.AddedItemAdjudicationComponent parseExplanationOfBenefitAddedItemAdjudicationComponent(
      JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemAdjudicationComponent res = new ExplanationOfBenefit.AddedItemAdjudicationComponent();
    parseBackboneProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCoding(json.getAsJsonObject("category")));
    if (json.has("reason"))
      res.setReason(parseCoding(json.getAsJsonObject("reason")));
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    return res;
  }

  protected ExplanationOfBenefit.AddedItemsDetailComponent parseExplanationOfBenefitAddedItemsDetailComponent(
      JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemsDetailComponent res = new ExplanationOfBenefit.AddedItemsDetailComponent();
    parseBackboneProperties(json, res);
    if (json.has("service"))
      res.setService(parseCoding(json.getAsJsonObject("service")));
    if (json.has("fee"))
      res.setFee(parseMoney(json.getAsJsonObject("fee")));
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication()
            .add(parseExplanationOfBenefitAddedItemDetailAdjudicationComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ExplanationOfBenefit.AddedItemDetailAdjudicationComponent parseExplanationOfBenefitAddedItemDetailAdjudicationComponent(
      JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemDetailAdjudicationComponent res = new ExplanationOfBenefit.AddedItemDetailAdjudicationComponent();
    parseBackboneProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCoding(json.getAsJsonObject("category")));
    if (json.has("reason"))
      res.setReason(parseCoding(json.getAsJsonObject("reason")));
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    return res;
  }

  protected ExplanationOfBenefit.MissingTeethComponent parseExplanationOfBenefitMissingTeethComponent(JsonObject json,
      ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.MissingTeethComponent res = new ExplanationOfBenefit.MissingTeethComponent();
    parseBackboneProperties(json, res);
    if (json.has("tooth"))
      res.setTooth(parseCoding(json.getAsJsonObject("tooth")));
    if (json.has("reason"))
      res.setReason(parseCoding(json.getAsJsonObject("reason")));
    if (json.has("extractionDate"))
      res.setExtractionDateElement(parseDate(json.get("extractionDate").getAsString()));
    if (json.has("_extractionDate"))
      parseElementProperties(json.getAsJsonObject("_extractionDate"), res.getExtractionDateElement());
    return res;
  }

  protected ExplanationOfBenefit.NotesComponent parseExplanationOfBenefitNotesComponent(JsonObject json,
      ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.NotesComponent res = new ExplanationOfBenefit.NotesComponent();
    parseBackboneProperties(json, res);
    if (json.has("number"))
      res.setNumberElement(parsePositiveInt(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    return res;
  }

  protected ExplanationOfBenefit.BenefitBalanceComponent parseExplanationOfBenefitBenefitBalanceComponent(
      JsonObject json, ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.BenefitBalanceComponent res = new ExplanationOfBenefit.BenefitBalanceComponent();
    parseBackboneProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCoding(json.getAsJsonObject("category")));
    if (json.has("subCategory"))
      res.setSubCategory(parseCoding(json.getAsJsonObject("subCategory")));
    if (json.has("network"))
      res.setNetwork(parseCoding(json.getAsJsonObject("network")));
    if (json.has("unit"))
      res.setUnit(parseCoding(json.getAsJsonObject("unit")));
    if (json.has("term"))
      res.setTerm(parseCoding(json.getAsJsonObject("term")));
    if (json.has("financial")) {
      JsonArray array = json.getAsJsonArray("financial");
      for (int i = 0; i < array.size(); i++) {
        res.getFinancial().add(parseExplanationOfBenefitBenefitComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ExplanationOfBenefit.BenefitComponent parseExplanationOfBenefitBenefitComponent(JsonObject json,
      ExplanationOfBenefit owner) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.BenefitComponent res = new ExplanationOfBenefit.BenefitComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    Type benefit = parseType("benefit", json);
    if (benefit != null)
      res.setBenefit(benefit);
    Type benefitUsed = parseType("benefitUsed", json);
    if (benefitUsed != null)
      res.setBenefitUsed(benefitUsed);
    return res;
  }

  protected FamilyMemberHistory parseFamilyMemberHistory(JsonObject json) throws IOException, FHIRFormatError {
    FamilyMemberHistory res = new FamilyMemberHistory();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(),
          FamilyMemberHistory.FamilyHistoryStatus.NULL, new FamilyMemberHistory.FamilyHistoryStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("relationship"))
      res.setRelationship(parseCodeableConcept(json.getAsJsonObject("relationship")));
    if (json.has("gender"))
      res.setGenderElement(parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL,
          new Enumerations.AdministrativeGenderEnumFactory()));
    if (json.has("_gender"))
      parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
    Type born = parseType("born", json);
    if (born != null)
      res.setBorn(born);
    Type age = parseType("age", json);
    if (age != null)
      res.setAge(age);
    Type deceased = parseType("deceased", json);
    if (deceased != null)
      res.setDeceased(deceased);
    if (json.has("note"))
      res.setNote(parseAnnotation(json.getAsJsonObject("note")));
    if (json.has("condition")) {
      JsonArray array = json.getAsJsonArray("condition");
      for (int i = 0; i < array.size(); i++) {
        res.getCondition()
            .add(parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected FamilyMemberHistory.FamilyMemberHistoryConditionComponent parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(
      JsonObject json, FamilyMemberHistory owner) throws IOException, FHIRFormatError {
    FamilyMemberHistory.FamilyMemberHistoryConditionComponent res = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("outcome"))
      res.setOutcome(parseCodeableConcept(json.getAsJsonObject("outcome")));
    Type onset = parseType("onset", json);
    if (onset != null)
      res.setOnset(onset);
    if (json.has("note"))
      res.setNote(parseAnnotation(json.getAsJsonObject("note")));
    return res;
  }

  protected Flag parseFlag(JsonObject json) throws IOException, FHIRFormatError {
    Flag res = new Flag();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("status"))
      res.setStatusElement(
          parseEnumeration(json.get("status").getAsString(), Flag.FlagStatus.NULL, new Flag.FlagStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    return res;
  }

  protected Goal parseGoal(JsonObject json) throws IOException, FHIRFormatError {
    Goal res = new Goal();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    Type start = parseType("start", json);
    if (start != null)
      res.setStart(start);
    Type target = parseType("target", json);
    if (target != null)
      res.setTarget(target);
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("status"))
      res.setStatusElement(
          parseEnumeration(json.get("status").getAsString(), Goal.GoalStatus.NULL, new Goal.GoalStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusDate"))
      res.setStatusDateElement(parseDate(json.get("statusDate").getAsString()));
    if (json.has("_statusDate"))
      parseElementProperties(json.getAsJsonObject("_statusDate"), res.getStatusDateElement());
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableConcept(json.getAsJsonObject("statusReason")));
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(json.getAsJsonObject("priority")));
    if (json.has("addresses")) {
      JsonArray array = json.getAsJsonArray("addresses");
      for (int i = 0; i < array.size(); i++) {
        res.getAddresses().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("outcome")) {
      JsonArray array = json.getAsJsonArray("outcome");
      for (int i = 0; i < array.size(); i++) {
        res.getOutcome().add(parseGoalGoalOutcomeComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected Goal.GoalOutcomeComponent parseGoalGoalOutcomeComponent(JsonObject json, Goal owner)
      throws IOException, FHIRFormatError {
    Goal.GoalOutcomeComponent res = new Goal.GoalOutcomeComponent();
    parseBackboneProperties(json, res);
    Type result = parseType("result", json);
    if (result != null)
      res.setResult(result);
    return res;
  }

  protected Group parseGroup(JsonObject json) throws IOException, FHIRFormatError {
    Group res = new Group();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("type"))
      res.setTypeElement(
          parseEnumeration(json.get("type").getAsString(), Group.GroupType.NULL, new Group.GroupTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("actual"))
      res.setActualElement(parseBoolean(json.get("actual").getAsBoolean()));
    if (json.has("_actual"))
      parseElementProperties(json.getAsJsonObject("_actual"), res.getActualElement());
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("quantity"))
      res.setQuantityElement(parseUnsignedInt(json.get("quantity").getAsString()));
    if (json.has("_quantity"))
      parseElementProperties(json.getAsJsonObject("_quantity"), res.getQuantityElement());
    if (json.has("characteristic")) {
      JsonArray array = json.getAsJsonArray("characteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getCharacteristic().add(parseGroupGroupCharacteristicComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("member")) {
      JsonArray array = json.getAsJsonArray("member");
      for (int i = 0; i < array.size(); i++) {
        res.getMember().add(parseGroupGroupMemberComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected Group.GroupCharacteristicComponent parseGroupGroupCharacteristicComponent(JsonObject json, Group owner)
      throws IOException, FHIRFormatError {
    Group.GroupCharacteristicComponent res = new Group.GroupCharacteristicComponent();
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("exclude"))
      res.setExcludeElement(parseBoolean(json.get("exclude").getAsBoolean()));
    if (json.has("_exclude"))
      parseElementProperties(json.getAsJsonObject("_exclude"), res.getExcludeElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    return res;
  }

  protected Group.GroupMemberComponent parseGroupGroupMemberComponent(JsonObject json, Group owner)
      throws IOException, FHIRFormatError {
    Group.GroupMemberComponent res = new Group.GroupMemberComponent();
    parseBackboneProperties(json, res);
    if (json.has("entity"))
      res.setEntity(parseReference(json.getAsJsonObject("entity")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("inactive"))
      res.setInactiveElement(parseBoolean(json.get("inactive").getAsBoolean()));
    if (json.has("_inactive"))
      parseElementProperties(json.getAsJsonObject("_inactive"), res.getInactiveElement());
    return res;
  }

  protected GuidanceResponse parseGuidanceResponse(JsonObject json) throws IOException, FHIRFormatError {
    GuidanceResponse res = new GuidanceResponse();
    parseDomainResourceProperties(json, res);
    if (json.has("requestId"))
      res.setRequestIdElement(parseString(json.get("requestId").getAsString()));
    if (json.has("_requestId"))
      parseElementProperties(json.getAsJsonObject("_requestId"), res.getRequestIdElement());
    if (json.has("module"))
      res.setModule(parseReference(json.getAsJsonObject("module")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(),
          GuidanceResponse.GuidanceResponseStatus.NULL, new GuidanceResponse.GuidanceResponseStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("evaluationMessage")) {
      JsonArray array = json.getAsJsonArray("evaluationMessage");
      for (int i = 0; i < array.size(); i++) {
        res.getEvaluationMessage().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("outputParameters"))
      res.setOutputParameters(parseReference(json.getAsJsonObject("outputParameters")));
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseGuidanceResponseGuidanceResponseActionComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("dataRequirement")) {
      JsonArray array = json.getAsJsonArray("dataRequirement");
      for (int i = 0; i < array.size(); i++) {
        res.getDataRequirement().add(parseDataRequirement(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected GuidanceResponse.GuidanceResponseActionComponent parseGuidanceResponseGuidanceResponseActionComponent(
      JsonObject json, GuidanceResponse owner) throws IOException, FHIRFormatError {
    GuidanceResponse.GuidanceResponseActionComponent res = new GuidanceResponse.GuidanceResponseActionComponent();
    parseBackboneProperties(json, res);
    if (json.has("actionIdentifier"))
      res.setActionIdentifier(parseIdentifier(json.getAsJsonObject("actionIdentifier")));
    if (json.has("label"))
      res.setLabelElement(parseString(json.get("label").getAsString()));
    if (json.has("_label"))
      parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("textEquivalent"))
      res.setTextEquivalentElement(parseString(json.get("textEquivalent").getAsString()));
    if (json.has("_textEquivalent"))
      parseElementProperties(json.getAsJsonObject("_textEquivalent"), res.getTextEquivalentElement());
    if (json.has("concept")) {
      JsonArray array = json.getAsJsonArray("concept");
      for (int i = 0; i < array.size(); i++) {
        res.getConcept().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("supportingEvidence")) {
      JsonArray array = json.getAsJsonArray("supportingEvidence");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingEvidence().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("relatedAction"))
      res.setRelatedAction(parseGuidanceResponseGuidanceResponseActionRelatedActionComponent(
          json.getAsJsonObject("relatedAction"), owner));
    if (json.has("documentation")) {
      JsonArray array = json.getAsJsonArray("documentation");
      for (int i = 0; i < array.size(); i++) {
        res.getDocumentation().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("behavior")) {
      JsonArray array = json.getAsJsonArray("behavior");
      for (int i = 0; i < array.size(); i++) {
        res.getBehavior()
            .add(parseGuidanceResponseGuidanceResponseActionBehaviorComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("resource"))
      res.setResource(parseReference(json.getAsJsonObject("resource")));
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction()
            .add(parseGuidanceResponseGuidanceResponseActionComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected GuidanceResponse.GuidanceResponseActionRelatedActionComponent parseGuidanceResponseGuidanceResponseActionRelatedActionComponent(
      JsonObject json, GuidanceResponse owner) throws IOException, FHIRFormatError {
    GuidanceResponse.GuidanceResponseActionRelatedActionComponent res = new GuidanceResponse.GuidanceResponseActionRelatedActionComponent();
    parseBackboneProperties(json, res);
    if (json.has("actionIdentifier"))
      res.setActionIdentifier(parseIdentifier(json.getAsJsonObject("actionIdentifier")));
    if (json.has("relationship"))
      res.setRelationshipElement(parseCode(json.get("relationship").getAsString()));
    if (json.has("_relationship"))
      parseElementProperties(json.getAsJsonObject("_relationship"), res.getRelationshipElement());
    Type offset = parseType("offset", json);
    if (offset != null)
      res.setOffset(offset);
    if (json.has("anchor"))
      res.setAnchorElement(parseCode(json.get("anchor").getAsString()));
    if (json.has("_anchor"))
      parseElementProperties(json.getAsJsonObject("_anchor"), res.getAnchorElement());
    return res;
  }

  protected GuidanceResponse.GuidanceResponseActionBehaviorComponent parseGuidanceResponseGuidanceResponseActionBehaviorComponent(
      JsonObject json, GuidanceResponse owner) throws IOException, FHIRFormatError {
    GuidanceResponse.GuidanceResponseActionBehaviorComponent res = new GuidanceResponse.GuidanceResponseActionBehaviorComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("value"))
      res.setValue(parseCoding(json.getAsJsonObject("value")));
    return res;
  }

  protected HealthcareService parseHealthcareService(JsonObject json) throws IOException, FHIRFormatError {
    HealthcareService res = new HealthcareService();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("providedBy"))
      res.setProvidedBy(parseReference(json.getAsJsonObject("providedBy")));
    if (json.has("serviceCategory"))
      res.setServiceCategory(parseCodeableConcept(json.getAsJsonObject("serviceCategory")));
    if (json.has("serviceType")) {
      JsonArray array = json.getAsJsonArray("serviceType");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("specialty")) {
      JsonArray array = json.getAsJsonArray("specialty");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialty().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("location")) {
      JsonArray array = json.getAsJsonArray("location");
      for (int i = 0; i < array.size(); i++) {
        res.getLocation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("serviceName"))
      res.setServiceNameElement(parseString(json.get("serviceName").getAsString()));
    if (json.has("_serviceName"))
      parseElementProperties(json.getAsJsonObject("_serviceName"), res.getServiceNameElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("extraDetails"))
      res.setExtraDetailsElement(parseString(json.get("extraDetails").getAsString()));
    if (json.has("_extraDetails"))
      parseElementProperties(json.getAsJsonObject("_extraDetails"), res.getExtraDetailsElement());
    if (json.has("photo"))
      res.setPhoto(parseAttachment(json.getAsJsonObject("photo")));
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("coverageArea")) {
      JsonArray array = json.getAsJsonArray("coverageArea");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverageArea().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("serviceProvisionCode")) {
      JsonArray array = json.getAsJsonArray("serviceProvisionCode");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceProvisionCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("eligibility"))
      res.setEligibility(parseCodeableConcept(json.getAsJsonObject("eligibility")));
    if (json.has("eligibilityNote"))
      res.setEligibilityNoteElement(parseString(json.get("eligibilityNote").getAsString()));
    if (json.has("_eligibilityNote"))
      parseElementProperties(json.getAsJsonObject("_eligibilityNote"), res.getEligibilityNoteElement());
    if (json.has("programName")) {
      JsonArray array = json.getAsJsonArray("programName");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramName().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_programName")) {
      JsonArray array = json.getAsJsonArray("_programName");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProgramName().size())
          res.getProgramName().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProgramName().get(i));
      }
    }
    ;
    if (json.has("characteristic")) {
      JsonArray array = json.getAsJsonArray("characteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getCharacteristic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("referralMethod")) {
      JsonArray array = json.getAsJsonArray("referralMethod");
      for (int i = 0; i < array.size(); i++) {
        res.getReferralMethod().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("publicKey"))
      res.setPublicKeyElement(parseString(json.get("publicKey").getAsString()));
    if (json.has("_publicKey"))
      parseElementProperties(json.getAsJsonObject("_publicKey"), res.getPublicKeyElement());
    if (json.has("appointmentRequired"))
      res.setAppointmentRequiredElement(parseBoolean(json.get("appointmentRequired").getAsBoolean()));
    if (json.has("_appointmentRequired"))
      parseElementProperties(json.getAsJsonObject("_appointmentRequired"), res.getAppointmentRequiredElement());
    if (json.has("availableTime")) {
      JsonArray array = json.getAsJsonArray("availableTime");
      for (int i = 0; i < array.size(); i++) {
        res.getAvailableTime()
            .add(parseHealthcareServiceHealthcareServiceAvailableTimeComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("notAvailable")) {
      JsonArray array = json.getAsJsonArray("notAvailable");
      for (int i = 0; i < array.size(); i++) {
        res.getNotAvailable()
            .add(parseHealthcareServiceHealthcareServiceNotAvailableComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("availabilityExceptions"))
      res.setAvailabilityExceptionsElement(parseString(json.get("availabilityExceptions").getAsString()));
    if (json.has("_availabilityExceptions"))
      parseElementProperties(json.getAsJsonObject("_availabilityExceptions"), res.getAvailabilityExceptionsElement());
    return res;
  }

  protected HealthcareService.HealthcareServiceAvailableTimeComponent parseHealthcareServiceHealthcareServiceAvailableTimeComponent(
      JsonObject json, HealthcareService owner) throws IOException, FHIRFormatError {
    HealthcareService.HealthcareServiceAvailableTimeComponent res = new HealthcareService.HealthcareServiceAvailableTimeComponent();
    parseBackboneProperties(json, res);
    if (json.has("daysOfWeek")) {
      JsonArray array = json.getAsJsonArray("daysOfWeek");
      for (int i = 0; i < array.size(); i++) {
        res.getDaysOfWeek().add(parseEnumeration(array.get(i).getAsString(), HealthcareService.DaysOfWeek.NULL,
            new HealthcareService.DaysOfWeekEnumFactory()));
      }
    }
    ;
    if (json.has("_daysOfWeek")) {
      JsonArray array = json.getAsJsonArray("_daysOfWeek");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDaysOfWeek().size())
          res.getDaysOfWeek().add(
              parseEnumeration(null, HealthcareService.DaysOfWeek.NULL, new HealthcareService.DaysOfWeekEnumFactory()));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDaysOfWeek().get(i));
      }
    }
    ;
    if (json.has("allDay"))
      res.setAllDayElement(parseBoolean(json.get("allDay").getAsBoolean()));
    if (json.has("_allDay"))
      parseElementProperties(json.getAsJsonObject("_allDay"), res.getAllDayElement());
    if (json.has("availableStartTime"))
      res.setAvailableStartTimeElement(parseTime(json.get("availableStartTime").getAsString()));
    if (json.has("_availableStartTime"))
      parseElementProperties(json.getAsJsonObject("_availableStartTime"), res.getAvailableStartTimeElement());
    if (json.has("availableEndTime"))
      res.setAvailableEndTimeElement(parseTime(json.get("availableEndTime").getAsString()));
    if (json.has("_availableEndTime"))
      parseElementProperties(json.getAsJsonObject("_availableEndTime"), res.getAvailableEndTimeElement());
    return res;
  }

  protected HealthcareService.HealthcareServiceNotAvailableComponent parseHealthcareServiceHealthcareServiceNotAvailableComponent(
      JsonObject json, HealthcareService owner) throws IOException, FHIRFormatError {
    HealthcareService.HealthcareServiceNotAvailableComponent res = new HealthcareService.HealthcareServiceNotAvailableComponent();
    parseBackboneProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("during"))
      res.setDuring(parsePeriod(json.getAsJsonObject("during")));
    return res;
  }

  protected ImagingExcerpt parseImagingExcerpt(JsonObject json) throws IOException, FHIRFormatError {
    ImagingExcerpt res = new ImagingExcerpt();
    parseDomainResourceProperties(json, res);
    if (json.has("uid"))
      res.setUidElement(parseOid(json.get("uid").getAsString()));
    if (json.has("_uid"))
      parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("authoringTime"))
      res.setAuthoringTimeElement(parseDateTime(json.get("authoringTime").getAsString()));
    if (json.has("_authoringTime"))
      parseElementProperties(json.getAsJsonObject("_authoringTime"), res.getAuthoringTimeElement());
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    if (json.has("title"))
      res.setTitle(parseCodeableConcept(json.getAsJsonObject("title")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("study")) {
      JsonArray array = json.getAsJsonArray("study");
      for (int i = 0; i < array.size(); i++) {
        res.getStudy().add(parseImagingExcerptStudyComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected ImagingExcerpt.StudyComponent parseImagingExcerptStudyComponent(JsonObject json, ImagingExcerpt owner)
      throws IOException, FHIRFormatError {
    ImagingExcerpt.StudyComponent res = new ImagingExcerpt.StudyComponent();
    parseBackboneProperties(json, res);
    if (json.has("uid"))
      res.setUidElement(parseOid(json.get("uid").getAsString()));
    if (json.has("_uid"))
      parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
    if (json.has("imagingStudy"))
      res.setImagingStudy(parseReference(json.getAsJsonObject("imagingStudy")));
    if (json.has("dicom")) {
      JsonArray array = json.getAsJsonArray("dicom");
      for (int i = 0; i < array.size(); i++) {
        res.getDicom().add(parseImagingExcerptStudyDicomComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("viewable")) {
      JsonArray array = json.getAsJsonArray("viewable");
      for (int i = 0; i < array.size(); i++) {
        res.getViewable().add(parseImagingExcerptStudyViewableComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("series")) {
      JsonArray array = json.getAsJsonArray("series");
      for (int i = 0; i < array.size(); i++) {
        res.getSeries().add(parseImagingExcerptSeriesComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ImagingExcerpt.StudyDicomComponent parseImagingExcerptStudyDicomComponent(JsonObject json,
      ImagingExcerpt owner) throws IOException, FHIRFormatError {
    ImagingExcerpt.StudyDicomComponent res = new ImagingExcerpt.StudyDicomComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ImagingExcerpt.DWebType.NULL,
          new ImagingExcerpt.DWebTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    return res;
  }

  protected ImagingExcerpt.StudyViewableComponent parseImagingExcerptStudyViewableComponent(JsonObject json,
      ImagingExcerpt owner) throws IOException, FHIRFormatError {
    ImagingExcerpt.StudyViewableComponent res = new ImagingExcerpt.StudyViewableComponent();
    parseBackboneProperties(json, res);
    if (json.has("contentType"))
      res.setContentTypeElement(parseCode(json.get("contentType").getAsString()));
    if (json.has("_contentType"))
      parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
    if (json.has("height"))
      res.setHeightElement(parsePositiveInt(json.get("height").getAsString()));
    if (json.has("_height"))
      parseElementProperties(json.getAsJsonObject("_height"), res.getHeightElement());
    if (json.has("width"))
      res.setWidthElement(parsePositiveInt(json.get("width").getAsString()));
    if (json.has("_width"))
      parseElementProperties(json.getAsJsonObject("_width"), res.getWidthElement());
    if (json.has("frames"))
      res.setFramesElement(parsePositiveInt(json.get("frames").getAsString()));
    if (json.has("_frames"))
      parseElementProperties(json.getAsJsonObject("_frames"), res.getFramesElement());
    if (json.has("duration"))
      res.setDurationElement(parseUnsignedInt(json.get("duration").getAsString()));
    if (json.has("_duration"))
      parseElementProperties(json.getAsJsonObject("_duration"), res.getDurationElement());
    if (json.has("size"))
      res.setSizeElement(parseUnsignedInt(json.get("size").getAsString()));
    if (json.has("_size"))
      parseElementProperties(json.getAsJsonObject("_size"), res.getSizeElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    return res;
  }

  protected ImagingExcerpt.SeriesComponent parseImagingExcerptSeriesComponent(JsonObject json, ImagingExcerpt owner)
      throws IOException, FHIRFormatError {
    ImagingExcerpt.SeriesComponent res = new ImagingExcerpt.SeriesComponent();
    parseBackboneProperties(json, res);
    if (json.has("uid"))
      res.setUidElement(parseOid(json.get("uid").getAsString()));
    if (json.has("_uid"))
      parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
    if (json.has("dicom")) {
      JsonArray array = json.getAsJsonArray("dicom");
      for (int i = 0; i < array.size(); i++) {
        res.getDicom().add(parseImagingExcerptSeriesDicomComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("instance")) {
      JsonArray array = json.getAsJsonArray("instance");
      for (int i = 0; i < array.size(); i++) {
        res.getInstance().add(parseImagingExcerptInstanceComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ImagingExcerpt.SeriesDicomComponent parseImagingExcerptSeriesDicomComponent(JsonObject json,
      ImagingExcerpt owner) throws IOException, FHIRFormatError {
    ImagingExcerpt.SeriesDicomComponent res = new ImagingExcerpt.SeriesDicomComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ImagingExcerpt.DWebType.NULL,
          new ImagingExcerpt.DWebTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    return res;
  }

  protected ImagingExcerpt.InstanceComponent parseImagingExcerptInstanceComponent(JsonObject json, ImagingExcerpt owner)
      throws IOException, FHIRFormatError {
    ImagingExcerpt.InstanceComponent res = new ImagingExcerpt.InstanceComponent();
    parseBackboneProperties(json, res);
    if (json.has("sopClass"))
      res.setSopClassElement(parseOid(json.get("sopClass").getAsString()));
    if (json.has("_sopClass"))
      parseElementProperties(json.getAsJsonObject("_sopClass"), res.getSopClassElement());
    if (json.has("uid"))
      res.setUidElement(parseOid(json.get("uid").getAsString()));
    if (json.has("_uid"))
      parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
    if (json.has("dicom")) {
      JsonArray array = json.getAsJsonArray("dicom");
      for (int i = 0; i < array.size(); i++) {
        res.getDicom().add(parseImagingExcerptInstanceDicomComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("frameNumbers")) {
      JsonArray array = json.getAsJsonArray("frameNumbers");
      for (int i = 0; i < array.size(); i++) {
        res.getFrameNumbers().add(parseUnsignedInt(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_frameNumbers")) {
      JsonArray array = json.getAsJsonArray("_frameNumbers");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getFrameNumbers().size())
          res.getFrameNumbers().add(parseUnsignedInt(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getFrameNumbers().get(i));
      }
    }
    ;
    return res;
  }

  protected ImagingExcerpt.InstanceDicomComponent parseImagingExcerptInstanceDicomComponent(JsonObject json,
      ImagingExcerpt owner) throws IOException, FHIRFormatError {
    ImagingExcerpt.InstanceDicomComponent res = new ImagingExcerpt.InstanceDicomComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ImagingExcerpt.DWebType.NULL,
          new ImagingExcerpt.DWebTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    return res;
  }

  protected ImagingObjectSelection parseImagingObjectSelection(JsonObject json) throws IOException, FHIRFormatError {
    ImagingObjectSelection res = new ImagingObjectSelection();
    parseDomainResourceProperties(json, res);
    if (json.has("uid"))
      res.setUidElement(parseOid(json.get("uid").getAsString()));
    if (json.has("_uid"))
      parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("authoringTime"))
      res.setAuthoringTimeElement(parseDateTime(json.get("authoringTime").getAsString()));
    if (json.has("_authoringTime"))
      parseElementProperties(json.getAsJsonObject("_authoringTime"), res.getAuthoringTimeElement());
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    if (json.has("title"))
      res.setTitle(parseCodeableConcept(json.getAsJsonObject("title")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("study")) {
      JsonArray array = json.getAsJsonArray("study");
      for (int i = 0; i < array.size(); i++) {
        res.getStudy().add(parseImagingObjectSelectionStudyComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected ImagingObjectSelection.StudyComponent parseImagingObjectSelectionStudyComponent(JsonObject json,
      ImagingObjectSelection owner) throws IOException, FHIRFormatError {
    ImagingObjectSelection.StudyComponent res = new ImagingObjectSelection.StudyComponent();
    parseBackboneProperties(json, res);
    if (json.has("uid"))
      res.setUidElement(parseOid(json.get("uid").getAsString()));
    if (json.has("_uid"))
      parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("imagingStudy"))
      res.setImagingStudy(parseReference(json.getAsJsonObject("imagingStudy")));
    if (json.has("series")) {
      JsonArray array = json.getAsJsonArray("series");
      for (int i = 0; i < array.size(); i++) {
        res.getSeries().add(parseImagingObjectSelectionSeriesComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ImagingObjectSelection.SeriesComponent parseImagingObjectSelectionSeriesComponent(JsonObject json,
      ImagingObjectSelection owner) throws IOException, FHIRFormatError {
    ImagingObjectSelection.SeriesComponent res = new ImagingObjectSelection.SeriesComponent();
    parseBackboneProperties(json, res);
    if (json.has("uid"))
      res.setUidElement(parseOid(json.get("uid").getAsString()));
    if (json.has("_uid"))
      parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("instance")) {
      JsonArray array = json.getAsJsonArray("instance");
      for (int i = 0; i < array.size(); i++) {
        res.getInstance().add(parseImagingObjectSelectionInstanceComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ImagingObjectSelection.InstanceComponent parseImagingObjectSelectionInstanceComponent(JsonObject json,
      ImagingObjectSelection owner) throws IOException, FHIRFormatError {
    ImagingObjectSelection.InstanceComponent res = new ImagingObjectSelection.InstanceComponent();
    parseBackboneProperties(json, res);
    if (json.has("sopClass"))
      res.setSopClassElement(parseOid(json.get("sopClass").getAsString()));
    if (json.has("_sopClass"))
      parseElementProperties(json.getAsJsonObject("_sopClass"), res.getSopClassElement());
    if (json.has("uid"))
      res.setUidElement(parseOid(json.get("uid").getAsString()));
    if (json.has("_uid"))
      parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("frame")) {
      JsonArray array = json.getAsJsonArray("frame");
      for (int i = 0; i < array.size(); i++) {
        res.getFrame().add(parseImagingObjectSelectionFramesComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ImagingObjectSelection.FramesComponent parseImagingObjectSelectionFramesComponent(JsonObject json,
      ImagingObjectSelection owner) throws IOException, FHIRFormatError {
    ImagingObjectSelection.FramesComponent res = new ImagingObjectSelection.FramesComponent();
    parseBackboneProperties(json, res);
    if (json.has("number")) {
      JsonArray array = json.getAsJsonArray("number");
      for (int i = 0; i < array.size(); i++) {
        res.getNumber().add(parseUnsignedInt(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_number")) {
      JsonArray array = json.getAsJsonArray("_number");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNumber().size())
          res.getNumber().add(parseUnsignedInt(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNumber().get(i));
      }
    }
    ;
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    return res;
  }

  protected ImagingStudy parseImagingStudy(JsonObject json) throws IOException, FHIRFormatError {
    ImagingStudy res = new ImagingStudy();
    parseDomainResourceProperties(json, res);
    if (json.has("uid"))
      res.setUidElement(parseOid(json.get("uid").getAsString()));
    if (json.has("_uid"))
      parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
    if (json.has("accession"))
      res.setAccession(parseIdentifier(json.getAsJsonObject("accession")));
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("availability"))
      res.setAvailabilityElement(parseEnumeration(json.get("availability").getAsString(),
          ImagingStudy.InstanceAvailability.NULL, new ImagingStudy.InstanceAvailabilityEnumFactory()));
    if (json.has("_availability"))
      parseElementProperties(json.getAsJsonObject("_availability"), res.getAvailabilityElement());
    if (json.has("modalityList")) {
      JsonArray array = json.getAsJsonArray("modalityList");
      for (int i = 0; i < array.size(); i++) {
        res.getModalityList().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("started"))
      res.setStartedElement(parseDateTime(json.get("started").getAsString()));
    if (json.has("_started"))
      parseElementProperties(json.getAsJsonObject("_started"), res.getStartedElement());
    if (json.has("order")) {
      JsonArray array = json.getAsJsonArray("order");
      for (int i = 0; i < array.size(); i++) {
        res.getOrder().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("referrer"))
      res.setReferrer(parseReference(json.getAsJsonObject("referrer")));
    if (json.has("interpreter"))
      res.setInterpreter(parseReference(json.getAsJsonObject("interpreter")));
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("numberOfSeries"))
      res.setNumberOfSeriesElement(parseUnsignedInt(json.get("numberOfSeries").getAsString()));
    if (json.has("_numberOfSeries"))
      parseElementProperties(json.getAsJsonObject("_numberOfSeries"), res.getNumberOfSeriesElement());
    if (json.has("numberOfInstances"))
      res.setNumberOfInstancesElement(parseUnsignedInt(json.get("numberOfInstances").getAsString()));
    if (json.has("_numberOfInstances"))
      parseElementProperties(json.getAsJsonObject("_numberOfInstances"), res.getNumberOfInstancesElement());
    if (json.has("procedure")) {
      JsonArray array = json.getAsJsonArray("procedure");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedure().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("series")) {
      JsonArray array = json.getAsJsonArray("series");
      for (int i = 0; i < array.size(); i++) {
        res.getSeries().add(parseImagingStudyImagingStudySeriesComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected ImagingStudy.ImagingStudySeriesComponent parseImagingStudyImagingStudySeriesComponent(JsonObject json,
      ImagingStudy owner) throws IOException, FHIRFormatError {
    ImagingStudy.ImagingStudySeriesComponent res = new ImagingStudy.ImagingStudySeriesComponent();
    parseBackboneProperties(json, res);
    if (json.has("uid"))
      res.setUidElement(parseOid(json.get("uid").getAsString()));
    if (json.has("_uid"))
      parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
    if (json.has("number"))
      res.setNumberElement(parseUnsignedInt(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
    if (json.has("modality"))
      res.setModality(parseCoding(json.getAsJsonObject("modality")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("numberOfInstances"))
      res.setNumberOfInstancesElement(parseUnsignedInt(json.get("numberOfInstances").getAsString()));
    if (json.has("_numberOfInstances"))
      parseElementProperties(json.getAsJsonObject("_numberOfInstances"), res.getNumberOfInstancesElement());
    if (json.has("availability"))
      res.setAvailabilityElement(parseEnumeration(json.get("availability").getAsString(),
          ImagingStudy.InstanceAvailability.NULL, new ImagingStudy.InstanceAvailabilityEnumFactory()));
    if (json.has("_availability"))
      parseElementProperties(json.getAsJsonObject("_availability"), res.getAvailabilityElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("bodySite"))
      res.setBodySite(parseCoding(json.getAsJsonObject("bodySite")));
    if (json.has("laterality"))
      res.setLaterality(parseCoding(json.getAsJsonObject("laterality")));
    if (json.has("started"))
      res.setStartedElement(parseDateTime(json.get("started").getAsString()));
    if (json.has("_started"))
      parseElementProperties(json.getAsJsonObject("_started"), res.getStartedElement());
    if (json.has("instance")) {
      JsonArray array = json.getAsJsonArray("instance");
      for (int i = 0; i < array.size(); i++) {
        res.getInstance()
            .add(parseImagingStudyImagingStudySeriesInstanceComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ImagingStudy.ImagingStudySeriesInstanceComponent parseImagingStudyImagingStudySeriesInstanceComponent(
      JsonObject json, ImagingStudy owner) throws IOException, FHIRFormatError {
    ImagingStudy.ImagingStudySeriesInstanceComponent res = new ImagingStudy.ImagingStudySeriesInstanceComponent();
    parseBackboneProperties(json, res);
    if (json.has("uid"))
      res.setUidElement(parseOid(json.get("uid").getAsString()));
    if (json.has("_uid"))
      parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
    if (json.has("number"))
      res.setNumberElement(parseUnsignedInt(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
    if (json.has("sopClass"))
      res.setSopClassElement(parseOid(json.get("sopClass").getAsString()));
    if (json.has("_sopClass"))
      parseElementProperties(json.getAsJsonObject("_sopClass"), res.getSopClassElement());
    if (json.has("type"))
      res.setTypeElement(parseString(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("content")) {
      JsonArray array = json.getAsJsonArray("content");
      for (int i = 0; i < array.size(); i++) {
        res.getContent().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected Immunization parseImmunization(JsonObject json) throws IOException, FHIRFormatError {
    Immunization res = new Immunization();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("status"))
      res.setStatusElement(parseCode(json.get("status").getAsString()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("vaccineCode"))
      res.setVaccineCode(parseCodeableConcept(json.getAsJsonObject("vaccineCode")));
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("wasNotGiven"))
      res.setWasNotGivenElement(parseBoolean(json.get("wasNotGiven").getAsBoolean()));
    if (json.has("_wasNotGiven"))
      parseElementProperties(json.getAsJsonObject("_wasNotGiven"), res.getWasNotGivenElement());
    if (json.has("reported"))
      res.setReportedElement(parseBoolean(json.get("reported").getAsBoolean()));
    if (json.has("_reported"))
      parseElementProperties(json.getAsJsonObject("_reported"), res.getReportedElement());
    if (json.has("performer"))
      res.setPerformer(parseReference(json.getAsJsonObject("performer")));
    if (json.has("requester"))
      res.setRequester(parseReference(json.getAsJsonObject("requester")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("manufacturer"))
      res.setManufacturer(parseReference(json.getAsJsonObject("manufacturer")));
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("lotNumber"))
      res.setLotNumberElement(parseString(json.get("lotNumber").getAsString()));
    if (json.has("_lotNumber"))
      parseElementProperties(json.getAsJsonObject("_lotNumber"), res.getLotNumberElement());
    if (json.has("expirationDate"))
      res.setExpirationDateElement(parseDate(json.get("expirationDate").getAsString()));
    if (json.has("_expirationDate"))
      parseElementProperties(json.getAsJsonObject("_expirationDate"), res.getExpirationDateElement());
    if (json.has("site"))
      res.setSite(parseCodeableConcept(json.getAsJsonObject("site")));
    if (json.has("route"))
      res.setRoute(parseCodeableConcept(json.getAsJsonObject("route")));
    if (json.has("doseQuantity"))
      res.setDoseQuantity(parseSimpleQuantity(json.getAsJsonObject("doseQuantity")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("explanation"))
      res.setExplanation(parseImmunizationImmunizationExplanationComponent(json.getAsJsonObject("explanation"), res));
    if (json.has("reaction")) {
      JsonArray array = json.getAsJsonArray("reaction");
      for (int i = 0; i < array.size(); i++) {
        res.getReaction().add(parseImmunizationImmunizationReactionComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("vaccinationProtocol")) {
      JsonArray array = json.getAsJsonArray("vaccinationProtocol");
      for (int i = 0; i < array.size(); i++) {
        res.getVaccinationProtocol()
            .add(parseImmunizationImmunizationVaccinationProtocolComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected Immunization.ImmunizationExplanationComponent parseImmunizationImmunizationExplanationComponent(
      JsonObject json, Immunization owner) throws IOException, FHIRFormatError {
    Immunization.ImmunizationExplanationComponent res = new Immunization.ImmunizationExplanationComponent();
    parseBackboneProperties(json, res);
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("reasonNotGiven")) {
      JsonArray array = json.getAsJsonArray("reasonNotGiven");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonNotGiven().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected Immunization.ImmunizationReactionComponent parseImmunizationImmunizationReactionComponent(JsonObject json,
      Immunization owner) throws IOException, FHIRFormatError {
    Immunization.ImmunizationReactionComponent res = new Immunization.ImmunizationReactionComponent();
    parseBackboneProperties(json, res);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("detail"))
      res.setDetail(parseReference(json.getAsJsonObject("detail")));
    if (json.has("reported"))
      res.setReportedElement(parseBoolean(json.get("reported").getAsBoolean()));
    if (json.has("_reported"))
      parseElementProperties(json.getAsJsonObject("_reported"), res.getReportedElement());
    return res;
  }

  protected Immunization.ImmunizationVaccinationProtocolComponent parseImmunizationImmunizationVaccinationProtocolComponent(
      JsonObject json, Immunization owner) throws IOException, FHIRFormatError {
    Immunization.ImmunizationVaccinationProtocolComponent res = new Immunization.ImmunizationVaccinationProtocolComponent();
    parseBackboneProperties(json, res);
    if (json.has("doseSequence"))
      res.setDoseSequenceElement(parsePositiveInt(json.get("doseSequence").getAsString()));
    if (json.has("_doseSequence"))
      parseElementProperties(json.getAsJsonObject("_doseSequence"), res.getDoseSequenceElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("authority"))
      res.setAuthority(parseReference(json.getAsJsonObject("authority")));
    if (json.has("series"))
      res.setSeriesElement(parseString(json.get("series").getAsString()));
    if (json.has("_series"))
      parseElementProperties(json.getAsJsonObject("_series"), res.getSeriesElement());
    if (json.has("seriesDoses"))
      res.setSeriesDosesElement(parsePositiveInt(json.get("seriesDoses").getAsString()));
    if (json.has("_seriesDoses"))
      parseElementProperties(json.getAsJsonObject("_seriesDoses"), res.getSeriesDosesElement());
    if (json.has("targetDisease")) {
      JsonArray array = json.getAsJsonArray("targetDisease");
      for (int i = 0; i < array.size(); i++) {
        res.getTargetDisease().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("doseStatus"))
      res.setDoseStatus(parseCodeableConcept(json.getAsJsonObject("doseStatus")));
    if (json.has("doseStatusReason"))
      res.setDoseStatusReason(parseCodeableConcept(json.getAsJsonObject("doseStatusReason")));
    return res;
  }

  protected ImmunizationRecommendation parseImmunizationRecommendation(JsonObject json)
      throws IOException, FHIRFormatError {
    ImmunizationRecommendation res = new ImmunizationRecommendation();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("recommendation")) {
      JsonArray array = json.getAsJsonArray("recommendation");
      for (int i = 0; i < array.size(); i++) {
        res.getRecommendation().add(parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(
            array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(
      JsonObject json, ImmunizationRecommendation owner) throws IOException, FHIRFormatError {
    ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent();
    parseBackboneProperties(json, res);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("vaccineCode"))
      res.setVaccineCode(parseCodeableConcept(json.getAsJsonObject("vaccineCode")));
    if (json.has("doseNumber"))
      res.setDoseNumberElement(parsePositiveInt(json.get("doseNumber").getAsString()));
    if (json.has("_doseNumber"))
      parseElementProperties(json.getAsJsonObject("_doseNumber"), res.getDoseNumberElement());
    if (json.has("forecastStatus"))
      res.setForecastStatus(parseCodeableConcept(json.getAsJsonObject("forecastStatus")));
    if (json.has("dateCriterion")) {
      JsonArray array = json.getAsJsonArray("dateCriterion");
      for (int i = 0; i < array.size(); i++) {
        res.getDateCriterion()
            .add(parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(
                array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("protocol"))
      res.setProtocol(parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(
          json.getAsJsonObject("protocol"), owner));
    if (json.has("supportingImmunization")) {
      JsonArray array = json.getAsJsonArray("supportingImmunization");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingImmunization().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("supportingPatientInformation")) {
      JsonArray array = json.getAsJsonArray("supportingPatientInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingPatientInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(
      JsonObject json, ImmunizationRecommendation owner) throws IOException, FHIRFormatError {
    ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent();
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("value"))
      res.setValueElement(parseDateTime(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    return res;
  }

  protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationProtocolComponent(
      JsonObject json, ImmunizationRecommendation owner) throws IOException, FHIRFormatError {
    ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationProtocolComponent();
    parseBackboneProperties(json, res);
    if (json.has("doseSequence"))
      res.setDoseSequenceElement(parseInteger(json.get("doseSequence").getAsLong()));
    if (json.has("_doseSequence"))
      parseElementProperties(json.getAsJsonObject("_doseSequence"), res.getDoseSequenceElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("authority"))
      res.setAuthority(parseReference(json.getAsJsonObject("authority")));
    if (json.has("series"))
      res.setSeriesElement(parseString(json.get("series").getAsString()));
    if (json.has("_series"))
      parseElementProperties(json.getAsJsonObject("_series"), res.getSeriesElement());
    return res;
  }

  protected ImplementationGuide parseImplementationGuide(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide res = new ImplementationGuide();
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(),
          Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact()
            .add(parseImplementationGuideImplementationGuideContactComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("copyright"))
      res.setCopyrightElement(parseString(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("fhirVersion"))
      res.setFhirVersionElement(parseId(json.get("fhirVersion").getAsString()));
    if (json.has("_fhirVersion"))
      parseElementProperties(json.getAsJsonObject("_fhirVersion"), res.getFhirVersionElement());
    if (json.has("dependency")) {
      JsonArray array = json.getAsJsonArray("dependency");
      for (int i = 0; i < array.size(); i++) {
        res.getDependency()
            .add(parseImplementationGuideImplementationGuideDependencyComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("package")) {
      JsonArray array = json.getAsJsonArray("package");
      for (int i = 0; i < array.size(); i++) {
        res.getPackage()
            .add(parseImplementationGuideImplementationGuidePackageComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("global")) {
      JsonArray array = json.getAsJsonArray("global");
      for (int i = 0; i < array.size(); i++) {
        res.getGlobal()
            .add(parseImplementationGuideImplementationGuideGlobalComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("binary")) {
      JsonArray array = json.getAsJsonArray("binary");
      for (int i = 0; i < array.size(); i++) {
        res.getBinary().add(parseUri(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_binary")) {
      JsonArray array = json.getAsJsonArray("_binary");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getBinary().size())
          res.getBinary().add(parseUri(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getBinary().get(i));
      }
    }
    ;
    if (json.has("page"))
      res.setPage(parseImplementationGuideImplementationGuidePageComponent(json.getAsJsonObject("page"), res));
    return res;
  }

  protected ImplementationGuide.ImplementationGuideContactComponent parseImplementationGuideImplementationGuideContactComponent(
      JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideContactComponent res = new ImplementationGuide.ImplementationGuideContactComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected ImplementationGuide.ImplementationGuideDependencyComponent parseImplementationGuideImplementationGuideDependencyComponent(
      JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDependencyComponent res = new ImplementationGuide.ImplementationGuideDependencyComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ImplementationGuide.GuideDependencyType.NULL,
          new ImplementationGuide.GuideDependencyTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("uri"))
      res.setUriElement(parseUri(json.get("uri").getAsString()));
    if (json.has("_uri"))
      parseElementProperties(json.getAsJsonObject("_uri"), res.getUriElement());
    return res;
  }

  protected ImplementationGuide.ImplementationGuidePackageComponent parseImplementationGuideImplementationGuidePackageComponent(
      JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuidePackageComponent res = new ImplementationGuide.ImplementationGuidePackageComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("resource")) {
      JsonArray array = json.getAsJsonArray("resource");
      for (int i = 0; i < array.size(); i++) {
        res.getResource().add(
            parseImplementationGuideImplementationGuidePackageResourceComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ImplementationGuide.ImplementationGuidePackageResourceComponent parseImplementationGuideImplementationGuidePackageResourceComponent(
      JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuidePackageResourceComponent res = new ImplementationGuide.ImplementationGuidePackageResourceComponent();
    parseBackboneProperties(json, res);
    if (json.has("example"))
      res.setExampleElement(parseBoolean(json.get("example").getAsBoolean()));
    if (json.has("_example"))
      parseElementProperties(json.getAsJsonObject("_example"), res.getExampleElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("acronym"))
      res.setAcronymElement(parseString(json.get("acronym").getAsString()));
    if (json.has("_acronym"))
      parseElementProperties(json.getAsJsonObject("_acronym"), res.getAcronymElement());
    Type source = parseType("source", json);
    if (source != null)
      res.setSource(source);
    if (json.has("exampleFor"))
      res.setExampleFor(parseReference(json.getAsJsonObject("exampleFor")));
    return res;
  }

  protected ImplementationGuide.ImplementationGuideGlobalComponent parseImplementationGuideImplementationGuideGlobalComponent(
      JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideGlobalComponent res = new ImplementationGuide.ImplementationGuideGlobalComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("profile"))
      res.setProfile(parseReference(json.getAsJsonObject("profile")));
    return res;
  }

  protected ImplementationGuide.ImplementationGuidePageComponent parseImplementationGuideImplementationGuidePageComponent(
      JsonObject json, ImplementationGuide owner) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuidePageComponent res = new ImplementationGuide.ImplementationGuidePageComponent();
    parseBackboneProperties(json, res);
    if (json.has("source"))
      res.setSourceElement(parseUri(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), ImplementationGuide.GuidePageKind.NULL,
          new ImplementationGuide.GuidePageKindEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCode(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_type")) {
      JsonArray array = json.getAsJsonArray("_type");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getType().size())
          res.getType().add(parseCode(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getType().get(i));
      }
    }
    ;
    if (json.has("package")) {
      JsonArray array = json.getAsJsonArray("package");
      for (int i = 0; i < array.size(); i++) {
        res.getPackage().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_package")) {
      JsonArray array = json.getAsJsonArray("_package");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPackage().size())
          res.getPackage().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPackage().get(i));
      }
    }
    ;
    if (json.has("format"))
      res.setFormatElement(parseCode(json.get("format").getAsString()));
    if (json.has("_format"))
      parseElementProperties(json.getAsJsonObject("_format"), res.getFormatElement());
    if (json.has("page")) {
      JsonArray array = json.getAsJsonArray("page");
      for (int i = 0; i < array.size(); i++) {
        res.getPage()
            .add(parseImplementationGuideImplementationGuidePageComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected Library parseLibrary(JsonObject json) throws IOException, FHIRFormatError {
    Library res = new Library();
    parseDomainResourceProperties(json, res);
    if (json.has("moduleMetadata"))
      res.setModuleMetadata(parseModuleMetadata(json.getAsJsonObject("moduleMetadata")));
    if (json.has("model")) {
      JsonArray array = json.getAsJsonArray("model");
      for (int i = 0; i < array.size(); i++) {
        res.getModel().add(parseLibraryLibraryModelComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("library")) {
      JsonArray array = json.getAsJsonArray("library");
      for (int i = 0; i < array.size(); i++) {
        res.getLibrary().add(parseLibraryLibraryLibraryComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("codeSystem")) {
      JsonArray array = json.getAsJsonArray("codeSystem");
      for (int i = 0; i < array.size(); i++) {
        res.getCodeSystem().add(parseLibraryLibraryCodeSystemComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("valueSet")) {
      JsonArray array = json.getAsJsonArray("valueSet");
      for (int i = 0; i < array.size(); i++) {
        res.getValueSet().add(parseLibraryLibraryValueSetComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("parameter")) {
      JsonArray array = json.getAsJsonArray("parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter().add(parseParameterDefinition(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("dataRequirement")) {
      JsonArray array = json.getAsJsonArray("dataRequirement");
      for (int i = 0; i < array.size(); i++) {
        res.getDataRequirement().add(parseDataRequirement(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("document"))
      res.setDocument(parseAttachment(json.getAsJsonObject("document")));
    return res;
  }

  protected Library.LibraryModelComponent parseLibraryLibraryModelComponent(JsonObject json, Library owner)
      throws IOException, FHIRFormatError {
    Library.LibraryModelComponent res = new Library.LibraryModelComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("identifier"))
      res.setIdentifierElement(parseString(json.get("identifier").getAsString()));
    if (json.has("_identifier"))
      parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    return res;
  }

  protected Library.LibraryLibraryComponent parseLibraryLibraryLibraryComponent(JsonObject json, Library owner)
      throws IOException, FHIRFormatError {
    Library.LibraryLibraryComponent res = new Library.LibraryLibraryComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("identifier"))
      res.setIdentifierElement(parseString(json.get("identifier").getAsString()));
    if (json.has("_identifier"))
      parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    Type document = parseType("document", json);
    if (document != null)
      res.setDocument(document);
    return res;
  }

  protected Library.LibraryCodeSystemComponent parseLibraryLibraryCodeSystemComponent(JsonObject json, Library owner)
      throws IOException, FHIRFormatError {
    Library.LibraryCodeSystemComponent res = new Library.LibraryCodeSystemComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("identifier"))
      res.setIdentifierElement(parseString(json.get("identifier").getAsString()));
    if (json.has("_identifier"))
      parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    return res;
  }

  protected Library.LibraryValueSetComponent parseLibraryLibraryValueSetComponent(JsonObject json, Library owner)
      throws IOException, FHIRFormatError {
    Library.LibraryValueSetComponent res = new Library.LibraryValueSetComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("identifier"))
      res.setIdentifierElement(parseString(json.get("identifier").getAsString()));
    if (json.has("_identifier"))
      parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("codeSystem")) {
      JsonArray array = json.getAsJsonArray("codeSystem");
      for (int i = 0; i < array.size(); i++) {
        res.getCodeSystem().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_codeSystem")) {
      JsonArray array = json.getAsJsonArray("_codeSystem");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCodeSystem().size())
          res.getCodeSystem().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getCodeSystem().get(i));
      }
    }
    ;
    return res;
  }

  protected Linkage parseLinkage(JsonObject json) throws IOException, FHIRFormatError {
    Linkage res = new Linkage();
    parseDomainResourceProperties(json, res);
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseLinkageLinkageItemComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected Linkage.LinkageItemComponent parseLinkageLinkageItemComponent(JsonObject json, Linkage owner)
      throws IOException, FHIRFormatError {
    Linkage.LinkageItemComponent res = new Linkage.LinkageItemComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Linkage.LinkageType.NULL,
          new Linkage.LinkageTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("resource"))
      res.setResource(parseReference(json.getAsJsonObject("resource")));
    return res;
  }

  protected ListResource parseListResource(JsonObject json) throws IOException, FHIRFormatError {
    ListResource res = new ListResource();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ListResource.ListStatus.NULL,
          new ListResource.ListStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), ListResource.ListMode.NULL,
          new ListResource.ListModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("source"))
      res.setSource(parseReference(json.getAsJsonObject("source")));
    if (json.has("orderedBy"))
      res.setOrderedBy(parseCodeableConcept(json.getAsJsonObject("orderedBy")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("entry")) {
      JsonArray array = json.getAsJsonArray("entry");
      for (int i = 0; i < array.size(); i++) {
        res.getEntry().add(parseListResourceListEntryComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("emptyReason"))
      res.setEmptyReason(parseCodeableConcept(json.getAsJsonObject("emptyReason")));
    return res;
  }

  protected ListResource.ListEntryComponent parseListResourceListEntryComponent(JsonObject json, ListResource owner)
      throws IOException, FHIRFormatError {
    ListResource.ListEntryComponent res = new ListResource.ListEntryComponent();
    parseBackboneProperties(json, res);
    if (json.has("flag"))
      res.setFlag(parseCodeableConcept(json.getAsJsonObject("flag")));
    if (json.has("deleted"))
      res.setDeletedElement(parseBoolean(json.get("deleted").getAsBoolean()));
    if (json.has("_deleted"))
      parseElementProperties(json.getAsJsonObject("_deleted"), res.getDeletedElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("item"))
      res.setItem(parseReference(json.getAsJsonObject("item")));
    return res;
  }

  protected Location parseLocation(JsonObject json) throws IOException, FHIRFormatError {
    Location res = new Location();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Location.LocationStatus.NULL,
          new Location.LocationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Location.LocationMode.NULL,
          new Location.LocationModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("address"))
      res.setAddress(parseAddress(json.getAsJsonObject("address")));
    if (json.has("physicalType"))
      res.setPhysicalType(parseCodeableConcept(json.getAsJsonObject("physicalType")));
    if (json.has("position"))
      res.setPosition(parseLocationLocationPositionComponent(json.getAsJsonObject("position"), res));
    if (json.has("managingOrganization"))
      res.setManagingOrganization(parseReference(json.getAsJsonObject("managingOrganization")));
    if (json.has("partOf"))
      res.setPartOf(parseReference(json.getAsJsonObject("partOf")));
    return res;
  }

  protected Location.LocationPositionComponent parseLocationLocationPositionComponent(JsonObject json, Location owner)
      throws IOException, FHIRFormatError {
    Location.LocationPositionComponent res = new Location.LocationPositionComponent();
    parseBackboneProperties(json, res);
    if (json.has("longitude"))
      res.setLongitudeElement(parseDecimal(json.get("longitude").getAsBigDecimal()));
    if (json.has("_longitude"))
      parseElementProperties(json.getAsJsonObject("_longitude"), res.getLongitudeElement());
    if (json.has("latitude"))
      res.setLatitudeElement(parseDecimal(json.get("latitude").getAsBigDecimal()));
    if (json.has("_latitude"))
      parseElementProperties(json.getAsJsonObject("_latitude"), res.getLatitudeElement());
    if (json.has("altitude"))
      res.setAltitudeElement(parseDecimal(json.get("altitude").getAsBigDecimal()));
    if (json.has("_altitude"))
      parseElementProperties(json.getAsJsonObject("_altitude"), res.getAltitudeElement());
    return res;
  }

  protected Measure parseMeasure(JsonObject json) throws IOException, FHIRFormatError {
    Measure res = new Measure();
    parseDomainResourceProperties(json, res);
    if (json.has("moduleMetadata"))
      res.setModuleMetadata(parseModuleMetadata(json.getAsJsonObject("moduleMetadata")));
    if (json.has("library")) {
      JsonArray array = json.getAsJsonArray("library");
      for (int i = 0; i < array.size(); i++) {
        res.getLibrary().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("disclaimer"))
      res.setDisclaimerElement(parseMarkdown(json.get("disclaimer").getAsString()));
    if (json.has("_disclaimer"))
      parseElementProperties(json.getAsJsonObject("_disclaimer"), res.getDisclaimerElement());
    if (json.has("scoring"))
      res.setScoringElement(parseEnumeration(json.get("scoring").getAsString(), Measure.MeasureScoring.NULL,
          new Measure.MeasureScoringEnumFactory()));
    if (json.has("_scoring"))
      parseElementProperties(json.getAsJsonObject("_scoring"), res.getScoringElement());
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseEnumeration(array.get(i).getAsString(), Measure.MeasureType.NULL,
            new Measure.MeasureTypeEnumFactory()));
      }
    }
    ;
    if (json.has("_type")) {
      JsonArray array = json.getAsJsonArray("_type");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getType().size())
          res.getType().add(parseEnumeration(null, Measure.MeasureType.NULL, new Measure.MeasureTypeEnumFactory()));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getType().get(i));
      }
    }
    ;
    if (json.has("riskAdjustment"))
      res.setRiskAdjustmentElement(parseString(json.get("riskAdjustment").getAsString()));
    if (json.has("_riskAdjustment"))
      parseElementProperties(json.getAsJsonObject("_riskAdjustment"), res.getRiskAdjustmentElement());
    if (json.has("rateAggregation"))
      res.setRateAggregationElement(parseString(json.get("rateAggregation").getAsString()));
    if (json.has("_rateAggregation"))
      parseElementProperties(json.getAsJsonObject("_rateAggregation"), res.getRateAggregationElement());
    if (json.has("rationale"))
      res.setRationaleElement(parseMarkdown(json.get("rationale").getAsString()));
    if (json.has("_rationale"))
      parseElementProperties(json.getAsJsonObject("_rationale"), res.getRationaleElement());
    if (json.has("clinicalRecommendationStatement"))
      res.setClinicalRecommendationStatementElement(
          parseMarkdown(json.get("clinicalRecommendationStatement").getAsString()));
    if (json.has("_clinicalRecommendationStatement"))
      parseElementProperties(json.getAsJsonObject("_clinicalRecommendationStatement"),
          res.getClinicalRecommendationStatementElement());
    if (json.has("improvementNotation"))
      res.setImprovementNotationElement(parseString(json.get("improvementNotation").getAsString()));
    if (json.has("_improvementNotation"))
      parseElementProperties(json.getAsJsonObject("_improvementNotation"), res.getImprovementNotationElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseMarkdown(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
    if (json.has("guidance"))
      res.setGuidanceElement(parseMarkdown(json.get("guidance").getAsString()));
    if (json.has("_guidance"))
      parseElementProperties(json.getAsJsonObject("_guidance"), res.getGuidanceElement());
    if (json.has("set"))
      res.setSetElement(parseString(json.get("set").getAsString()));
    if (json.has("_set"))
      parseElementProperties(json.getAsJsonObject("_set"), res.getSetElement());
    if (json.has("group")) {
      JsonArray array = json.getAsJsonArray("group");
      for (int i = 0; i < array.size(); i++) {
        res.getGroup().add(parseMeasureMeasureGroupComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("supplementalData")) {
      JsonArray array = json.getAsJsonArray("supplementalData");
      for (int i = 0; i < array.size(); i++) {
        res.getSupplementalData()
            .add(parseMeasureMeasureSupplementalDataComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected Measure.MeasureGroupComponent parseMeasureMeasureGroupComponent(JsonObject json, Measure owner)
      throws IOException, FHIRFormatError {
    Measure.MeasureGroupComponent res = new Measure.MeasureGroupComponent();
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("population")) {
      JsonArray array = json.getAsJsonArray("population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation().add(parseMeasureMeasureGroupPopulationComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("stratifier")) {
      JsonArray array = json.getAsJsonArray("stratifier");
      for (int i = 0; i < array.size(); i++) {
        res.getStratifier().add(parseMeasureMeasureGroupStratifierComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected Measure.MeasureGroupPopulationComponent parseMeasureMeasureGroupPopulationComponent(JsonObject json,
      Measure owner) throws IOException, FHIRFormatError {
    Measure.MeasureGroupPopulationComponent res = new Measure.MeasureGroupPopulationComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Measure.MeasurePopulationType.NULL,
          new Measure.MeasurePopulationTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("criteria"))
      res.setCriteriaElement(parseString(json.get("criteria").getAsString()));
    if (json.has("_criteria"))
      parseElementProperties(json.getAsJsonObject("_criteria"), res.getCriteriaElement());
    return res;
  }

  protected Measure.MeasureGroupStratifierComponent parseMeasureMeasureGroupStratifierComponent(JsonObject json,
      Measure owner) throws IOException, FHIRFormatError {
    Measure.MeasureGroupStratifierComponent res = new Measure.MeasureGroupStratifierComponent();
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("criteria"))
      res.setCriteriaElement(parseString(json.get("criteria").getAsString()));
    if (json.has("_criteria"))
      parseElementProperties(json.getAsJsonObject("_criteria"), res.getCriteriaElement());
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    return res;
  }

  protected Measure.MeasureSupplementalDataComponent parseMeasureMeasureSupplementalDataComponent(JsonObject json,
      Measure owner) throws IOException, FHIRFormatError {
    Measure.MeasureSupplementalDataComponent res = new Measure.MeasureSupplementalDataComponent();
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("usage")) {
      JsonArray array = json.getAsJsonArray("usage");
      for (int i = 0; i < array.size(); i++) {
        res.getUsage().add(parseEnumeration(array.get(i).getAsString(), Measure.MeasureDataUsage.NULL,
            new Measure.MeasureDataUsageEnumFactory()));
      }
    }
    ;
    if (json.has("_usage")) {
      JsonArray array = json.getAsJsonArray("_usage");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getUsage().size())
          res.getUsage()
              .add(parseEnumeration(null, Measure.MeasureDataUsage.NULL, new Measure.MeasureDataUsageEnumFactory()));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getUsage().get(i));
      }
    }
    ;
    if (json.has("criteria"))
      res.setCriteriaElement(parseString(json.get("criteria").getAsString()));
    if (json.has("_criteria"))
      parseElementProperties(json.getAsJsonObject("_criteria"), res.getCriteriaElement());
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    return res;
  }

  protected MeasureReport parseMeasureReport(JsonObject json) throws IOException, FHIRFormatError {
    MeasureReport res = new MeasureReport();
    parseDomainResourceProperties(json, res);
    if (json.has("measure"))
      res.setMeasure(parseReference(json.getAsJsonObject("measure")));
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), MeasureReport.MeasureReportType.NULL,
          new MeasureReport.MeasureReportTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), MeasureReport.MeasureReportStatus.NULL,
          new MeasureReport.MeasureReportStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("reportingOrganization"))
      res.setReportingOrganization(parseReference(json.getAsJsonObject("reportingOrganization")));
    if (json.has("group")) {
      JsonArray array = json.getAsJsonArray("group");
      for (int i = 0; i < array.size(); i++) {
        res.getGroup().add(parseMeasureReportMeasureReportGroupComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("evaluatedResources"))
      res.setEvaluatedResources(parseReference(json.getAsJsonObject("evaluatedResources")));
    return res;
  }

  protected MeasureReport.MeasureReportGroupComponent parseMeasureReportMeasureReportGroupComponent(JsonObject json,
      MeasureReport owner) throws IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupComponent res = new MeasureReport.MeasureReportGroupComponent();
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("population")) {
      JsonArray array = json.getAsJsonArray("population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation()
            .add(parseMeasureReportMeasureReportGroupPopulationComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("measureScore"))
      res.setMeasureScoreElement(parseDecimal(json.get("measureScore").getAsBigDecimal()));
    if (json.has("_measureScore"))
      parseElementProperties(json.getAsJsonObject("_measureScore"), res.getMeasureScoreElement());
    if (json.has("stratifier")) {
      JsonArray array = json.getAsJsonArray("stratifier");
      for (int i = 0; i < array.size(); i++) {
        res.getStratifier()
            .add(parseMeasureReportMeasureReportGroupStratifierComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("supplementalData")) {
      JsonArray array = json.getAsJsonArray("supplementalData");
      for (int i = 0; i < array.size(); i++) {
        res.getSupplementalData()
            .add(parseMeasureReportMeasureReportGroupSupplementalDataComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected MeasureReport.MeasureReportGroupPopulationComponent parseMeasureReportMeasureReportGroupPopulationComponent(
      JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupPopulationComponent res = new MeasureReport.MeasureReportGroupPopulationComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("count"))
      res.setCountElement(parseInteger(json.get("count").getAsLong()));
    if (json.has("_count"))
      parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
    if (json.has("patients"))
      res.setPatients(parseReference(json.getAsJsonObject("patients")));
    return res;
  }

  protected MeasureReport.MeasureReportGroupStratifierComponent parseMeasureReportMeasureReportGroupStratifierComponent(
      JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupStratifierComponent res = new MeasureReport.MeasureReportGroupStratifierComponent();
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("group")) {
      JsonArray array = json.getAsJsonArray("group");
      for (int i = 0; i < array.size(); i++) {
        res.getGroup()
            .add(parseMeasureReportMeasureReportGroupStratifierGroupComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected MeasureReport.MeasureReportGroupStratifierGroupComponent parseMeasureReportMeasureReportGroupStratifierGroupComponent(
      JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupStratifierGroupComponent res = new MeasureReport.MeasureReportGroupStratifierGroupComponent();
    parseBackboneProperties(json, res);
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("population")) {
      JsonArray array = json.getAsJsonArray("population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation().add(parseMeasureReportMeasureReportGroupStratifierGroupPopulationComponent(
            array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("measureScore"))
      res.setMeasureScoreElement(parseDecimal(json.get("measureScore").getAsBigDecimal()));
    if (json.has("_measureScore"))
      parseElementProperties(json.getAsJsonObject("_measureScore"), res.getMeasureScoreElement());
    return res;
  }

  protected MeasureReport.MeasureReportGroupStratifierGroupPopulationComponent parseMeasureReportMeasureReportGroupStratifierGroupPopulationComponent(
      JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupStratifierGroupPopulationComponent res = new MeasureReport.MeasureReportGroupStratifierGroupPopulationComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("count"))
      res.setCountElement(parseInteger(json.get("count").getAsLong()));
    if (json.has("_count"))
      parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
    if (json.has("patients"))
      res.setPatients(parseReference(json.getAsJsonObject("patients")));
    return res;
  }

  protected MeasureReport.MeasureReportGroupSupplementalDataComponent parseMeasureReportMeasureReportGroupSupplementalDataComponent(
      JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupSupplementalDataComponent res = new MeasureReport.MeasureReportGroupSupplementalDataComponent();
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("group")) {
      JsonArray array = json.getAsJsonArray("group");
      for (int i = 0; i < array.size(); i++) {
        res.getGroup().add(
            parseMeasureReportMeasureReportGroupSupplementalDataGroupComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected MeasureReport.MeasureReportGroupSupplementalDataGroupComponent parseMeasureReportMeasureReportGroupSupplementalDataGroupComponent(
      JsonObject json, MeasureReport owner) throws IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupSupplementalDataGroupComponent res = new MeasureReport.MeasureReportGroupSupplementalDataGroupComponent();
    parseBackboneProperties(json, res);
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("count"))
      res.setCountElement(parseInteger(json.get("count").getAsLong()));
    if (json.has("_count"))
      parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
    if (json.has("patients"))
      res.setPatients(parseReference(json.getAsJsonObject("patients")));
    return res;
  }

  protected Media parseMedia(JsonObject json) throws IOException, FHIRFormatError {
    Media res = new Media();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Media.DigitalMediaType.NULL,
          new Media.DigitalMediaTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("subtype"))
      res.setSubtype(parseCodeableConcept(json.getAsJsonObject("subtype")));
    if (json.has("view"))
      res.setView(parseCodeableConcept(json.getAsJsonObject("view")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("operator"))
      res.setOperator(parseReference(json.getAsJsonObject("operator")));
    if (json.has("deviceName"))
      res.setDeviceNameElement(parseString(json.get("deviceName").getAsString()));
    if (json.has("_deviceName"))
      parseElementProperties(json.getAsJsonObject("_deviceName"), res.getDeviceNameElement());
    if (json.has("height"))
      res.setHeightElement(parsePositiveInt(json.get("height").getAsString()));
    if (json.has("_height"))
      parseElementProperties(json.getAsJsonObject("_height"), res.getHeightElement());
    if (json.has("width"))
      res.setWidthElement(parsePositiveInt(json.get("width").getAsString()));
    if (json.has("_width"))
      parseElementProperties(json.getAsJsonObject("_width"), res.getWidthElement());
    if (json.has("frames"))
      res.setFramesElement(parsePositiveInt(json.get("frames").getAsString()));
    if (json.has("_frames"))
      parseElementProperties(json.getAsJsonObject("_frames"), res.getFramesElement());
    if (json.has("duration"))
      res.setDurationElement(parseUnsignedInt(json.get("duration").getAsString()));
    if (json.has("_duration"))
      parseElementProperties(json.getAsJsonObject("_duration"), res.getDurationElement());
    if (json.has("content"))
      res.setContent(parseAttachment(json.getAsJsonObject("content")));
    return res;
  }

  protected Medication parseMedication(JsonObject json) throws IOException, FHIRFormatError {
    Medication res = new Medication();
    parseDomainResourceProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("isBrand"))
      res.setIsBrandElement(parseBoolean(json.get("isBrand").getAsBoolean()));
    if (json.has("_isBrand"))
      parseElementProperties(json.getAsJsonObject("_isBrand"), res.getIsBrandElement());
    if (json.has("manufacturer"))
      res.setManufacturer(parseReference(json.getAsJsonObject("manufacturer")));
    if (json.has("product"))
      res.setProduct(parseMedicationMedicationProductComponent(json.getAsJsonObject("product"), res));
    if (json.has("package"))
      res.setPackage(parseMedicationMedicationPackageComponent(json.getAsJsonObject("package"), res));
    return res;
  }

  protected Medication.MedicationProductComponent parseMedicationMedicationProductComponent(JsonObject json,
      Medication owner) throws IOException, FHIRFormatError {
    Medication.MedicationProductComponent res = new Medication.MedicationProductComponent();
    parseBackboneProperties(json, res);
    if (json.has("form"))
      res.setForm(parseCodeableConcept(json.getAsJsonObject("form")));
    if (json.has("ingredient")) {
      JsonArray array = json.getAsJsonArray("ingredient");
      for (int i = 0; i < array.size(); i++) {
        res.getIngredient()
            .add(parseMedicationMedicationProductIngredientComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("batch")) {
      JsonArray array = json.getAsJsonArray("batch");
      for (int i = 0; i < array.size(); i++) {
        res.getBatch().add(parseMedicationMedicationProductBatchComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected Medication.MedicationProductIngredientComponent parseMedicationMedicationProductIngredientComponent(
      JsonObject json, Medication owner) throws IOException, FHIRFormatError {
    Medication.MedicationProductIngredientComponent res = new Medication.MedicationProductIngredientComponent();
    parseBackboneProperties(json, res);
    Type item = parseType("item", json);
    if (item != null)
      res.setItem(item);
    if (json.has("amount"))
      res.setAmount(parseRatio(json.getAsJsonObject("amount")));
    return res;
  }

  protected Medication.MedicationProductBatchComponent parseMedicationMedicationProductBatchComponent(JsonObject json,
      Medication owner) throws IOException, FHIRFormatError {
    Medication.MedicationProductBatchComponent res = new Medication.MedicationProductBatchComponent();
    parseBackboneProperties(json, res);
    if (json.has("lotNumber"))
      res.setLotNumberElement(parseString(json.get("lotNumber").getAsString()));
    if (json.has("_lotNumber"))
      parseElementProperties(json.getAsJsonObject("_lotNumber"), res.getLotNumberElement());
    if (json.has("expirationDate"))
      res.setExpirationDateElement(parseDateTime(json.get("expirationDate").getAsString()));
    if (json.has("_expirationDate"))
      parseElementProperties(json.getAsJsonObject("_expirationDate"), res.getExpirationDateElement());
    return res;
  }

  protected Medication.MedicationPackageComponent parseMedicationMedicationPackageComponent(JsonObject json,
      Medication owner) throws IOException, FHIRFormatError {
    Medication.MedicationPackageComponent res = new Medication.MedicationPackageComponent();
    parseBackboneProperties(json, res);
    if (json.has("container"))
      res.setContainer(parseCodeableConcept(json.getAsJsonObject("container")));
    if (json.has("content")) {
      JsonArray array = json.getAsJsonArray("content");
      for (int i = 0; i < array.size(); i++) {
        res.getContent().add(parseMedicationMedicationPackageContentComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected Medication.MedicationPackageContentComponent parseMedicationMedicationPackageContentComponent(
      JsonObject json, Medication owner) throws IOException, FHIRFormatError {
    Medication.MedicationPackageContentComponent res = new Medication.MedicationPackageContentComponent();
    parseBackboneProperties(json, res);
    Type item = parseType("item", json);
    if (item != null)
      res.setItem(item);
    if (json.has("amount"))
      res.setAmount(parseSimpleQuantity(json.getAsJsonObject("amount")));
    return res;
  }

  protected MedicationAdministration parseMedicationAdministration(JsonObject json)
      throws IOException, FHIRFormatError {
    MedicationAdministration res = new MedicationAdministration();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(),
          MedicationAdministration.MedicationAdministrationStatus.NULL,
          new MedicationAdministration.MedicationAdministrationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    Type medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    Type effectiveTime = parseType("effectiveTime", json);
    if (effectiveTime != null)
      res.setEffectiveTime(effectiveTime);
    if (json.has("practitioner"))
      res.setPractitioner(parseReference(json.getAsJsonObject("practitioner")));
    if (json.has("prescription"))
      res.setPrescription(parseReference(json.getAsJsonObject("prescription")));
    if (json.has("wasNotGiven"))
      res.setWasNotGivenElement(parseBoolean(json.get("wasNotGiven").getAsBoolean()));
    if (json.has("_wasNotGiven"))
      parseElementProperties(json.getAsJsonObject("_wasNotGiven"), res.getWasNotGivenElement());
    if (json.has("reasonNotGiven")) {
      JsonArray array = json.getAsJsonArray("reasonNotGiven");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonNotGiven().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("reasonGiven")) {
      JsonArray array = json.getAsJsonArray("reasonGiven");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonGiven().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("device")) {
      JsonArray array = json.getAsJsonArray("device");
      for (int i = 0; i < array.size(); i++) {
        res.getDevice().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("dosage"))
      res.setDosage(
          parseMedicationAdministrationMedicationAdministrationDosageComponent(json.getAsJsonObject("dosage"), res));
    return res;
  }

  protected MedicationAdministration.MedicationAdministrationDosageComponent parseMedicationAdministrationMedicationAdministrationDosageComponent(
      JsonObject json, MedicationAdministration owner) throws IOException, FHIRFormatError {
    MedicationAdministration.MedicationAdministrationDosageComponent res = new MedicationAdministration.MedicationAdministrationDosageComponent();
    parseBackboneProperties(json, res);
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    Type site = parseType("site", json);
    if (site != null)
      res.setSite(site);
    if (json.has("route"))
      res.setRoute(parseCodeableConcept(json.getAsJsonObject("route")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(json.getAsJsonObject("method")));
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    Type rate = parseType("rate", json);
    if (rate != null)
      res.setRate(rate);
    return res;
  }

  protected MedicationDispense parseMedicationDispense(JsonObject json) throws IOException, FHIRFormatError {
    MedicationDispense res = new MedicationDispense();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("status"))
      res.setStatusElement(
          parseEnumeration(json.get("status").getAsString(), MedicationDispense.MedicationDispenseStatus.NULL,
              new MedicationDispense.MedicationDispenseStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    Type medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("dispenser"))
      res.setDispenser(parseReference(json.getAsJsonObject("dispenser")));
    if (json.has("authorizingPrescription")) {
      JsonArray array = json.getAsJsonArray("authorizingPrescription");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthorizingPrescription().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("daysSupply"))
      res.setDaysSupply(parseSimpleQuantity(json.getAsJsonObject("daysSupply")));
    if (json.has("whenPrepared"))
      res.setWhenPreparedElement(parseDateTime(json.get("whenPrepared").getAsString()));
    if (json.has("_whenPrepared"))
      parseElementProperties(json.getAsJsonObject("_whenPrepared"), res.getWhenPreparedElement());
    if (json.has("whenHandedOver"))
      res.setWhenHandedOverElement(parseDateTime(json.get("whenHandedOver").getAsString()));
    if (json.has("_whenHandedOver"))
      parseElementProperties(json.getAsJsonObject("_whenHandedOver"), res.getWhenHandedOverElement());
    if (json.has("destination"))
      res.setDestination(parseReference(json.getAsJsonObject("destination")));
    if (json.has("receiver")) {
      JsonArray array = json.getAsJsonArray("receiver");
      for (int i = 0; i < array.size(); i++) {
        res.getReceiver().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("dosageInstruction")) {
      JsonArray array = json.getAsJsonArray("dosageInstruction");
      for (int i = 0; i < array.size(); i++) {
        res.getDosageInstruction().add(
            parseMedicationDispenseMedicationDispenseDosageInstructionComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("substitution"))
      res.setSubstitution(
          parseMedicationDispenseMedicationDispenseSubstitutionComponent(json.getAsJsonObject("substitution"), res));
    return res;
  }

  protected MedicationDispense.MedicationDispenseDosageInstructionComponent parseMedicationDispenseMedicationDispenseDosageInstructionComponent(
      JsonObject json, MedicationDispense owner) throws IOException, FHIRFormatError {
    MedicationDispense.MedicationDispenseDosageInstructionComponent res = new MedicationDispense.MedicationDispenseDosageInstructionComponent();
    parseBackboneProperties(json, res);
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("additionalInstructions"))
      res.setAdditionalInstructions(parseCodeableConcept(json.getAsJsonObject("additionalInstructions")));
    if (json.has("timing"))
      res.setTiming(parseTiming(json.getAsJsonObject("timing")));
    Type asNeeded = parseType("asNeeded", json);
    if (asNeeded != null)
      res.setAsNeeded(asNeeded);
    Type site = parseType("site", json);
    if (site != null)
      res.setSite(site);
    if (json.has("route"))
      res.setRoute(parseCodeableConcept(json.getAsJsonObject("route")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(json.getAsJsonObject("method")));
    Type dose = parseType("dose", json);
    if (dose != null)
      res.setDose(dose);
    Type rate = parseType("rate", json);
    if (rate != null)
      res.setRate(rate);
    if (json.has("maxDosePerPeriod"))
      res.setMaxDosePerPeriod(parseRatio(json.getAsJsonObject("maxDosePerPeriod")));
    return res;
  }

  protected MedicationDispense.MedicationDispenseSubstitutionComponent parseMedicationDispenseMedicationDispenseSubstitutionComponent(
      JsonObject json, MedicationDispense owner) throws IOException, FHIRFormatError {
    MedicationDispense.MedicationDispenseSubstitutionComponent res = new MedicationDispense.MedicationDispenseSubstitutionComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("responsibleParty")) {
      JsonArray array = json.getAsJsonArray("responsibleParty");
      for (int i = 0; i < array.size(); i++) {
        res.getResponsibleParty().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected MedicationOrder parseMedicationOrder(JsonObject json) throws IOException, FHIRFormatError {
    MedicationOrder res = new MedicationOrder();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(),
          MedicationOrder.MedicationOrderStatus.NULL, new MedicationOrder.MedicationOrderStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    Type medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("dateWritten"))
      res.setDateWrittenElement(parseDateTime(json.get("dateWritten").getAsString()));
    if (json.has("_dateWritten"))
      parseElementProperties(json.getAsJsonObject("_dateWritten"), res.getDateWrittenElement());
    if (json.has("prescriber"))
      res.setPrescriber(parseReference(json.getAsJsonObject("prescriber")));
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("reasonReference")) {
      JsonArray array = json.getAsJsonArray("reasonReference");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("dateEnded"))
      res.setDateEndedElement(parseDateTime(json.get("dateEnded").getAsString()));
    if (json.has("_dateEnded"))
      parseElementProperties(json.getAsJsonObject("_dateEnded"), res.getDateEndedElement());
    if (json.has("reasonEnded"))
      res.setReasonEnded(parseCodeableConcept(json.getAsJsonObject("reasonEnded")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("dosageInstruction")) {
      JsonArray array = json.getAsJsonArray("dosageInstruction");
      for (int i = 0; i < array.size(); i++) {
        res.getDosageInstruction()
            .add(parseMedicationOrderMedicationOrderDosageInstructionComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("dispenseRequest"))
      res.setDispenseRequest(
          parseMedicationOrderMedicationOrderDispenseRequestComponent(json.getAsJsonObject("dispenseRequest"), res));
    if (json.has("substitution"))
      res.setSubstitution(
          parseMedicationOrderMedicationOrderSubstitutionComponent(json.getAsJsonObject("substitution"), res));
    if (json.has("priorPrescription"))
      res.setPriorPrescription(parseReference(json.getAsJsonObject("priorPrescription")));
    return res;
  }

  protected MedicationOrder.MedicationOrderDosageInstructionComponent parseMedicationOrderMedicationOrderDosageInstructionComponent(
      JsonObject json, MedicationOrder owner) throws IOException, FHIRFormatError {
    MedicationOrder.MedicationOrderDosageInstructionComponent res = new MedicationOrder.MedicationOrderDosageInstructionComponent();
    parseBackboneProperties(json, res);
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("additionalInstructions"))
      res.setAdditionalInstructions(parseCodeableConcept(json.getAsJsonObject("additionalInstructions")));
    if (json.has("timing"))
      res.setTiming(parseTiming(json.getAsJsonObject("timing")));
    Type asNeeded = parseType("asNeeded", json);
    if (asNeeded != null)
      res.setAsNeeded(asNeeded);
    Type site = parseType("site", json);
    if (site != null)
      res.setSite(site);
    if (json.has("route"))
      res.setRoute(parseCodeableConcept(json.getAsJsonObject("route")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(json.getAsJsonObject("method")));
    Type dose = parseType("dose", json);
    if (dose != null)
      res.setDose(dose);
    Type rate = parseType("rate", json);
    if (rate != null)
      res.setRate(rate);
    if (json.has("maxDosePerPeriod"))
      res.setMaxDosePerPeriod(parseRatio(json.getAsJsonObject("maxDosePerPeriod")));
    return res;
  }

  protected MedicationOrder.MedicationOrderDispenseRequestComponent parseMedicationOrderMedicationOrderDispenseRequestComponent(
      JsonObject json, MedicationOrder owner) throws IOException, FHIRFormatError {
    MedicationOrder.MedicationOrderDispenseRequestComponent res = new MedicationOrder.MedicationOrderDispenseRequestComponent();
    parseBackboneProperties(json, res);
    Type medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
    if (json.has("validityPeriod"))
      res.setValidityPeriod(parsePeriod(json.getAsJsonObject("validityPeriod")));
    if (json.has("numberOfRepeatsAllowed"))
      res.setNumberOfRepeatsAllowedElement(parsePositiveInt(json.get("numberOfRepeatsAllowed").getAsString()));
    if (json.has("_numberOfRepeatsAllowed"))
      parseElementProperties(json.getAsJsonObject("_numberOfRepeatsAllowed"), res.getNumberOfRepeatsAllowedElement());
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("expectedSupplyDuration"))
      res.setExpectedSupplyDuration(parseDuration(json.getAsJsonObject("expectedSupplyDuration")));
    return res;
  }

  protected MedicationOrder.MedicationOrderSubstitutionComponent parseMedicationOrderMedicationOrderSubstitutionComponent(
      JsonObject json, MedicationOrder owner) throws IOException, FHIRFormatError {
    MedicationOrder.MedicationOrderSubstitutionComponent res = new MedicationOrder.MedicationOrderSubstitutionComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(json.getAsJsonObject("reason")));
    return res;
  }

  protected MedicationStatement parseMedicationStatement(JsonObject json) throws IOException, FHIRFormatError {
    MedicationStatement res = new MedicationStatement();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("status"))
      res.setStatusElement(
          parseEnumeration(json.get("status").getAsString(), MedicationStatement.MedicationStatementStatus.NULL,
              new MedicationStatement.MedicationStatementStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    Type medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    Type effective = parseType("effective", json);
    if (effective != null)
      res.setEffective(effective);
    if (json.has("informationSource"))
      res.setInformationSource(parseReference(json.getAsJsonObject("informationSource")));
    if (json.has("supportingInformation")) {
      JsonArray array = json.getAsJsonArray("supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("dateAsserted"))
      res.setDateAssertedElement(parseDateTime(json.get("dateAsserted").getAsString()));
    if (json.has("_dateAsserted"))
      parseElementProperties(json.getAsJsonObject("_dateAsserted"), res.getDateAssertedElement());
    if (json.has("wasNotTaken"))
      res.setWasNotTakenElement(parseBoolean(json.get("wasNotTaken").getAsBoolean()));
    if (json.has("_wasNotTaken"))
      parseElementProperties(json.getAsJsonObject("_wasNotTaken"), res.getWasNotTakenElement());
    if (json.has("reasonNotTaken")) {
      JsonArray array = json.getAsJsonArray("reasonNotTaken");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonNotTaken().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    Type reasonForUse = parseType("reasonForUse", json);
    if (reasonForUse != null)
      res.setReasonForUse(reasonForUse);
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("dosage")) {
      JsonArray array = json.getAsJsonArray("dosage");
      for (int i = 0; i < array.size(); i++) {
        res.getDosage()
            .add(parseMedicationStatementMedicationStatementDosageComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected MedicationStatement.MedicationStatementDosageComponent parseMedicationStatementMedicationStatementDosageComponent(
      JsonObject json, MedicationStatement owner) throws IOException, FHIRFormatError {
    MedicationStatement.MedicationStatementDosageComponent res = new MedicationStatement.MedicationStatementDosageComponent();
    parseBackboneProperties(json, res);
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("timing"))
      res.setTiming(parseTiming(json.getAsJsonObject("timing")));
    Type asNeeded = parseType("asNeeded", json);
    if (asNeeded != null)
      res.setAsNeeded(asNeeded);
    Type site = parseType("site", json);
    if (site != null)
      res.setSite(site);
    if (json.has("route"))
      res.setRoute(parseCodeableConcept(json.getAsJsonObject("route")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(json.getAsJsonObject("method")));
    Type quantity = parseType("quantity", json);
    if (quantity != null)
      res.setQuantity(quantity);
    Type rate = parseType("rate", json);
    if (rate != null)
      res.setRate(rate);
    if (json.has("maxDosePerPeriod"))
      res.setMaxDosePerPeriod(parseRatio(json.getAsJsonObject("maxDosePerPeriod")));
    return res;
  }

  protected MessageHeader parseMessageHeader(JsonObject json) throws IOException, FHIRFormatError {
    MessageHeader res = new MessageHeader();
    parseDomainResourceProperties(json, res);
    if (json.has("timestamp"))
      res.setTimestampElement(parseInstant(json.get("timestamp").getAsString()));
    if (json.has("_timestamp"))
      parseElementProperties(json.getAsJsonObject("_timestamp"), res.getTimestampElement());
    if (json.has("event"))
      res.setEvent(parseCoding(json.getAsJsonObject("event")));
    if (json.has("response"))
      res.setResponse(parseMessageHeaderMessageHeaderResponseComponent(json.getAsJsonObject("response"), res));
    if (json.has("source"))
      res.setSource(parseMessageHeaderMessageSourceComponent(json.getAsJsonObject("source"), res));
    if (json.has("destination")) {
      JsonArray array = json.getAsJsonArray("destination");
      for (int i = 0; i < array.size(); i++) {
        res.getDestination().add(parseMessageHeaderMessageDestinationComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("enterer"))
      res.setEnterer(parseReference(json.getAsJsonObject("enterer")));
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    if (json.has("receiver"))
      res.setReceiver(parseReference(json.getAsJsonObject("receiver")));
    if (json.has("responsible"))
      res.setResponsible(parseReference(json.getAsJsonObject("responsible")));
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(json.getAsJsonObject("reason")));
    if (json.has("data")) {
      JsonArray array = json.getAsJsonArray("data");
      for (int i = 0; i < array.size(); i++) {
        res.getData().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected MessageHeader.MessageHeaderResponseComponent parseMessageHeaderMessageHeaderResponseComponent(
      JsonObject json, MessageHeader owner) throws IOException, FHIRFormatError {
    MessageHeader.MessageHeaderResponseComponent res = new MessageHeader.MessageHeaderResponseComponent();
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifierElement(parseId(json.get("identifier").getAsString()));
    if (json.has("_identifier"))
      parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), MessageHeader.ResponseType.NULL,
          new MessageHeader.ResponseTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("details"))
      res.setDetails(parseReference(json.getAsJsonObject("details")));
    return res;
  }

  protected MessageHeader.MessageSourceComponent parseMessageHeaderMessageSourceComponent(JsonObject json,
      MessageHeader owner) throws IOException, FHIRFormatError {
    MessageHeader.MessageSourceComponent res = new MessageHeader.MessageSourceComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("software"))
      res.setSoftwareElement(parseString(json.get("software").getAsString()));
    if (json.has("_software"))
      parseElementProperties(json.getAsJsonObject("_software"), res.getSoftwareElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("contact"))
      res.setContact(parseContactPoint(json.getAsJsonObject("contact")));
    if (json.has("endpoint"))
      res.setEndpointElement(parseUri(json.get("endpoint").getAsString()));
    if (json.has("_endpoint"))
      parseElementProperties(json.getAsJsonObject("_endpoint"), res.getEndpointElement());
    return res;
  }

  protected MessageHeader.MessageDestinationComponent parseMessageHeaderMessageDestinationComponent(JsonObject json,
      MessageHeader owner) throws IOException, FHIRFormatError {
    MessageHeader.MessageDestinationComponent res = new MessageHeader.MessageDestinationComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("target"))
      res.setTarget(parseReference(json.getAsJsonObject("target")));
    if (json.has("endpoint"))
      res.setEndpointElement(parseUri(json.get("endpoint").getAsString()));
    if (json.has("_endpoint"))
      parseElementProperties(json.getAsJsonObject("_endpoint"), res.getEndpointElement());
    return res;
  }

  protected ModuleDefinition parseModuleDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ModuleDefinition res = new ModuleDefinition();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("model")) {
      JsonArray array = json.getAsJsonArray("model");
      for (int i = 0; i < array.size(); i++) {
        res.getModel().add(parseModuleDefinitionModuleDefinitionModelComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("library")) {
      JsonArray array = json.getAsJsonArray("library");
      for (int i = 0; i < array.size(); i++) {
        res.getLibrary()
            .add(parseModuleDefinitionModuleDefinitionLibraryComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("codeSystem")) {
      JsonArray array = json.getAsJsonArray("codeSystem");
      for (int i = 0; i < array.size(); i++) {
        res.getCodeSystem()
            .add(parseModuleDefinitionModuleDefinitionCodeSystemComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("valueSet")) {
      JsonArray array = json.getAsJsonArray("valueSet");
      for (int i = 0; i < array.size(); i++) {
        res.getValueSet()
            .add(parseModuleDefinitionModuleDefinitionValueSetComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("parameter")) {
      JsonArray array = json.getAsJsonArray("parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter()
            .add(parseModuleDefinitionModuleDefinitionParameterComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("data")) {
      JsonArray array = json.getAsJsonArray("data");
      for (int i = 0; i < array.size(); i++) {
        res.getData().add(parseModuleDefinitionModuleDefinitionDataComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected ModuleDefinition.ModuleDefinitionModelComponent parseModuleDefinitionModuleDefinitionModelComponent(
      JsonObject json, ModuleDefinition owner) throws IOException, FHIRFormatError {
    ModuleDefinition.ModuleDefinitionModelComponent res = new ModuleDefinition.ModuleDefinitionModelComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("identifier"))
      res.setIdentifierElement(parseString(json.get("identifier").getAsString()));
    if (json.has("_identifier"))
      parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    return res;
  }

  protected ModuleDefinition.ModuleDefinitionLibraryComponent parseModuleDefinitionModuleDefinitionLibraryComponent(
      JsonObject json, ModuleDefinition owner) throws IOException, FHIRFormatError {
    ModuleDefinition.ModuleDefinitionLibraryComponent res = new ModuleDefinition.ModuleDefinitionLibraryComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("identifier"))
      res.setIdentifierElement(parseString(json.get("identifier").getAsString()));
    if (json.has("_identifier"))
      parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    Type document = parseType("document", json);
    if (document != null)
      res.setDocument(document);
    return res;
  }

  protected ModuleDefinition.ModuleDefinitionCodeSystemComponent parseModuleDefinitionModuleDefinitionCodeSystemComponent(
      JsonObject json, ModuleDefinition owner) throws IOException, FHIRFormatError {
    ModuleDefinition.ModuleDefinitionCodeSystemComponent res = new ModuleDefinition.ModuleDefinitionCodeSystemComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("identifier"))
      res.setIdentifierElement(parseString(json.get("identifier").getAsString()));
    if (json.has("_identifier"))
      parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    return res;
  }

  protected ModuleDefinition.ModuleDefinitionValueSetComponent parseModuleDefinitionModuleDefinitionValueSetComponent(
      JsonObject json, ModuleDefinition owner) throws IOException, FHIRFormatError {
    ModuleDefinition.ModuleDefinitionValueSetComponent res = new ModuleDefinition.ModuleDefinitionValueSetComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("identifier"))
      res.setIdentifierElement(parseString(json.get("identifier").getAsString()));
    if (json.has("_identifier"))
      parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("codeSystem")) {
      JsonArray array = json.getAsJsonArray("codeSystem");
      for (int i = 0; i < array.size(); i++) {
        res.getCodeSystem().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_codeSystem")) {
      JsonArray array = json.getAsJsonArray("_codeSystem");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCodeSystem().size())
          res.getCodeSystem().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getCodeSystem().get(i));
      }
    }
    ;
    return res;
  }

  protected ModuleDefinition.ModuleDefinitionParameterComponent parseModuleDefinitionModuleDefinitionParameterComponent(
      JsonObject json, ModuleDefinition owner) throws IOException, FHIRFormatError {
    ModuleDefinition.ModuleDefinitionParameterComponent res = new ModuleDefinition.ModuleDefinitionParameterComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseCode(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("use"))
      res.setUseElement(parseCode(json.get("use").getAsString()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("profile"))
      res.setProfile(parseReference(json.getAsJsonObject("profile")));
    return res;
  }

  protected ModuleDefinition.ModuleDefinitionDataComponent parseModuleDefinitionModuleDefinitionDataComponent(
      JsonObject json, ModuleDefinition owner) throws IOException, FHIRFormatError {
    ModuleDefinition.ModuleDefinitionDataComponent res = new ModuleDefinition.ModuleDefinitionDataComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("profile"))
      res.setProfile(parseReference(json.getAsJsonObject("profile")));
    if (json.has("mustSupport")) {
      JsonArray array = json.getAsJsonArray("mustSupport");
      for (int i = 0; i < array.size(); i++) {
        res.getMustSupport().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_mustSupport")) {
      JsonArray array = json.getAsJsonArray("_mustSupport");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getMustSupport().size())
          res.getMustSupport().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getMustSupport().get(i));
      }
    }
    ;
    if (json.has("codeFilter")) {
      JsonArray array = json.getAsJsonArray("codeFilter");
      for (int i = 0; i < array.size(); i++) {
        res.getCodeFilter()
            .add(parseModuleDefinitionModuleDefinitionDataCodeFilterComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("dateFilter")) {
      JsonArray array = json.getAsJsonArray("dateFilter");
      for (int i = 0; i < array.size(); i++) {
        res.getDateFilter()
            .add(parseModuleDefinitionModuleDefinitionDataDateFilterComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ModuleDefinition.ModuleDefinitionDataCodeFilterComponent parseModuleDefinitionModuleDefinitionDataCodeFilterComponent(
      JsonObject json, ModuleDefinition owner) throws IOException, FHIRFormatError {
    ModuleDefinition.ModuleDefinitionDataCodeFilterComponent res = new ModuleDefinition.ModuleDefinitionDataCodeFilterComponent();
    parseBackboneProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    Type valueSet = parseType("valueSet", json);
    if (valueSet != null)
      res.setValueSet(valueSet);
    if (json.has("codeableConcept")) {
      JsonArray array = json.getAsJsonArray("codeableConcept");
      for (int i = 0; i < array.size(); i++) {
        res.getCodeableConcept().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected ModuleDefinition.ModuleDefinitionDataDateFilterComponent parseModuleDefinitionModuleDefinitionDataDateFilterComponent(
      JsonObject json, ModuleDefinition owner) throws IOException, FHIRFormatError {
    ModuleDefinition.ModuleDefinitionDataDateFilterComponent res = new ModuleDefinition.ModuleDefinitionDataDateFilterComponent();
    parseBackboneProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    return res;
  }

  protected NamingSystem parseNamingSystem(JsonObject json) throws IOException, FHIRFormatError {
    NamingSystem res = new NamingSystem();
    parseDomainResourceProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(),
          Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), NamingSystem.NamingSystemType.NULL,
          new NamingSystem.NamingSystemTypeEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseNamingSystemNamingSystemContactComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("responsible"))
      res.setResponsibleElement(parseString(json.get("responsible").getAsString()));
    if (json.has("_responsible"))
      parseElementProperties(json.getAsJsonObject("_responsible"), res.getResponsibleElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("usage"))
      res.setUsageElement(parseString(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
    if (json.has("uniqueId")) {
      JsonArray array = json.getAsJsonArray("uniqueId");
      for (int i = 0; i < array.size(); i++) {
        res.getUniqueId().add(parseNamingSystemNamingSystemUniqueIdComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("replacedBy"))
      res.setReplacedBy(parseReference(json.getAsJsonObject("replacedBy")));
    return res;
  }

  protected NamingSystem.NamingSystemContactComponent parseNamingSystemNamingSystemContactComponent(JsonObject json,
      NamingSystem owner) throws IOException, FHIRFormatError {
    NamingSystem.NamingSystemContactComponent res = new NamingSystem.NamingSystemContactComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected NamingSystem.NamingSystemUniqueIdComponent parseNamingSystemNamingSystemUniqueIdComponent(JsonObject json,
      NamingSystem owner) throws IOException, FHIRFormatError {
    NamingSystem.NamingSystemUniqueIdComponent res = new NamingSystem.NamingSystemUniqueIdComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), NamingSystem.NamingSystemIdentifierType.NULL,
          new NamingSystem.NamingSystemIdentifierTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("preferred"))
      res.setPreferredElement(parseBoolean(json.get("preferred").getAsBoolean()));
    if (json.has("_preferred"))
      parseElementProperties(json.getAsJsonObject("_preferred"), res.getPreferredElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    return res;
  }

  protected NutritionOrder parseNutritionOrder(JsonObject json) throws IOException, FHIRFormatError {
    NutritionOrder res = new NutritionOrder();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), NutritionOrder.NutritionOrderStatus.NULL,
          new NutritionOrder.NutritionOrderStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("dateTime"))
      res.setDateTimeElement(parseDateTime(json.get("dateTime").getAsString()));
    if (json.has("_dateTime"))
      parseElementProperties(json.getAsJsonObject("_dateTime"), res.getDateTimeElement());
    if (json.has("orderer"))
      res.setOrderer(parseReference(json.getAsJsonObject("orderer")));
    if (json.has("allergyIntolerance")) {
      JsonArray array = json.getAsJsonArray("allergyIntolerance");
      for (int i = 0; i < array.size(); i++) {
        res.getAllergyIntolerance().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("foodPreferenceModifier")) {
      JsonArray array = json.getAsJsonArray("foodPreferenceModifier");
      for (int i = 0; i < array.size(); i++) {
        res.getFoodPreferenceModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("excludeFoodModifier")) {
      JsonArray array = json.getAsJsonArray("excludeFoodModifier");
      for (int i = 0; i < array.size(); i++) {
        res.getExcludeFoodModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("oralDiet"))
      res.setOralDiet(parseNutritionOrderNutritionOrderOralDietComponent(json.getAsJsonObject("oralDiet"), res));
    if (json.has("supplement")) {
      JsonArray array = json.getAsJsonArray("supplement");
      for (int i = 0; i < array.size(); i++) {
        res.getSupplement()
            .add(parseNutritionOrderNutritionOrderSupplementComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("enteralFormula"))
      res.setEnteralFormula(
          parseNutritionOrderNutritionOrderEnteralFormulaComponent(json.getAsJsonObject("enteralFormula"), res));
    return res;
  }

  protected NutritionOrder.NutritionOrderOralDietComponent parseNutritionOrderNutritionOrderOralDietComponent(
      JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderOralDietComponent res = new NutritionOrder.NutritionOrderOralDietComponent();
    parseBackboneProperties(json, res);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("schedule")) {
      JsonArray array = json.getAsJsonArray("schedule");
      for (int i = 0; i < array.size(); i++) {
        res.getSchedule().add(parseTiming(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("nutrient")) {
      JsonArray array = json.getAsJsonArray("nutrient");
      for (int i = 0; i < array.size(); i++) {
        res.getNutrient()
            .add(parseNutritionOrderNutritionOrderOralDietNutrientComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("texture")) {
      JsonArray array = json.getAsJsonArray("texture");
      for (int i = 0; i < array.size(); i++) {
        res.getTexture()
            .add(parseNutritionOrderNutritionOrderOralDietTextureComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("fluidConsistencyType")) {
      JsonArray array = json.getAsJsonArray("fluidConsistencyType");
      for (int i = 0; i < array.size(); i++) {
        res.getFluidConsistencyType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("instruction"))
      res.setInstructionElement(parseString(json.get("instruction").getAsString()));
    if (json.has("_instruction"))
      parseElementProperties(json.getAsJsonObject("_instruction"), res.getInstructionElement());
    return res;
  }

  protected NutritionOrder.NutritionOrderOralDietNutrientComponent parseNutritionOrderNutritionOrderOralDietNutrientComponent(
      JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderOralDietNutrientComponent res = new NutritionOrder.NutritionOrderOralDietNutrientComponent();
    parseBackboneProperties(json, res);
    if (json.has("modifier"))
      res.setModifier(parseCodeableConcept(json.getAsJsonObject("modifier")));
    if (json.has("amount"))
      res.setAmount(parseSimpleQuantity(json.getAsJsonObject("amount")));
    return res;
  }

  protected NutritionOrder.NutritionOrderOralDietTextureComponent parseNutritionOrderNutritionOrderOralDietTextureComponent(
      JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderOralDietTextureComponent res = new NutritionOrder.NutritionOrderOralDietTextureComponent();
    parseBackboneProperties(json, res);
    if (json.has("modifier"))
      res.setModifier(parseCodeableConcept(json.getAsJsonObject("modifier")));
    if (json.has("foodType"))
      res.setFoodType(parseCodeableConcept(json.getAsJsonObject("foodType")));
    return res;
  }

  protected NutritionOrder.NutritionOrderSupplementComponent parseNutritionOrderNutritionOrderSupplementComponent(
      JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderSupplementComponent res = new NutritionOrder.NutritionOrderSupplementComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("productName"))
      res.setProductNameElement(parseString(json.get("productName").getAsString()));
    if (json.has("_productName"))
      parseElementProperties(json.getAsJsonObject("_productName"), res.getProductNameElement());
    if (json.has("schedule")) {
      JsonArray array = json.getAsJsonArray("schedule");
      for (int i = 0; i < array.size(); i++) {
        res.getSchedule().add(parseTiming(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("instruction"))
      res.setInstructionElement(parseString(json.get("instruction").getAsString()));
    if (json.has("_instruction"))
      parseElementProperties(json.getAsJsonObject("_instruction"), res.getInstructionElement());
    return res;
  }

  protected NutritionOrder.NutritionOrderEnteralFormulaComponent parseNutritionOrderNutritionOrderEnteralFormulaComponent(
      JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderEnteralFormulaComponent res = new NutritionOrder.NutritionOrderEnteralFormulaComponent();
    parseBackboneProperties(json, res);
    if (json.has("baseFormulaType"))
      res.setBaseFormulaType(parseCodeableConcept(json.getAsJsonObject("baseFormulaType")));
    if (json.has("baseFormulaProductName"))
      res.setBaseFormulaProductNameElement(parseString(json.get("baseFormulaProductName").getAsString()));
    if (json.has("_baseFormulaProductName"))
      parseElementProperties(json.getAsJsonObject("_baseFormulaProductName"), res.getBaseFormulaProductNameElement());
    if (json.has("additiveType"))
      res.setAdditiveType(parseCodeableConcept(json.getAsJsonObject("additiveType")));
    if (json.has("additiveProductName"))
      res.setAdditiveProductNameElement(parseString(json.get("additiveProductName").getAsString()));
    if (json.has("_additiveProductName"))
      parseElementProperties(json.getAsJsonObject("_additiveProductName"), res.getAdditiveProductNameElement());
    if (json.has("caloricDensity"))
      res.setCaloricDensity(parseSimpleQuantity(json.getAsJsonObject("caloricDensity")));
    if (json.has("routeofAdministration"))
      res.setRouteofAdministration(parseCodeableConcept(json.getAsJsonObject("routeofAdministration")));
    if (json.has("administration")) {
      JsonArray array = json.getAsJsonArray("administration");
      for (int i = 0; i < array.size(); i++) {
        res.getAdministration().add(parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(
            array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("maxVolumeToDeliver"))
      res.setMaxVolumeToDeliver(parseSimpleQuantity(json.getAsJsonObject("maxVolumeToDeliver")));
    if (json.has("administrationInstruction"))
      res.setAdministrationInstructionElement(parseString(json.get("administrationInstruction").getAsString()));
    if (json.has("_administrationInstruction"))
      parseElementProperties(json.getAsJsonObject("_administrationInstruction"),
          res.getAdministrationInstructionElement());
    return res;
  }

  protected NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(
      JsonObject json, NutritionOrder owner) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent res = new NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent();
    parseBackboneProperties(json, res);
    if (json.has("schedule"))
      res.setSchedule(parseTiming(json.getAsJsonObject("schedule")));
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    Type rate = parseType("rate", json);
    if (rate != null)
      res.setRate(rate);
    return res;
  }

  protected Observation parseObservation(JsonObject json) throws IOException, FHIRFormatError {
    Observation res = new Observation();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Observation.ObservationStatus.NULL,
          new Observation.ObservationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    Type effective = parseType("effective", json);
    if (effective != null)
      res.setEffective(effective);
    if (json.has("issued"))
      res.setIssuedElement(parseInstant(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("dataAbsentReason"))
      res.setDataAbsentReason(parseCodeableConcept(json.getAsJsonObject("dataAbsentReason")));
    if (json.has("interpretation"))
      res.setInterpretation(parseCodeableConcept(json.getAsJsonObject("interpretation")));
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(json.getAsJsonObject("bodySite")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(json.getAsJsonObject("method")));
    if (json.has("specimen"))
      res.setSpecimen(parseReference(json.getAsJsonObject("specimen")));
    if (json.has("device"))
      res.setDevice(parseReference(json.getAsJsonObject("device")));
    if (json.has("referenceRange")) {
      JsonArray array = json.getAsJsonArray("referenceRange");
      for (int i = 0; i < array.size(); i++) {
        res.getReferenceRange()
            .add(parseObservationObservationReferenceRangeComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("related")) {
      JsonArray array = json.getAsJsonArray("related");
      for (int i = 0; i < array.size(); i++) {
        res.getRelated().add(parseObservationObservationRelatedComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("component")) {
      JsonArray array = json.getAsJsonArray("component");
      for (int i = 0; i < array.size(); i++) {
        res.getComponent().add(parseObservationObservationComponentComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected Observation.ObservationReferenceRangeComponent parseObservationObservationReferenceRangeComponent(
      JsonObject json, Observation owner) throws IOException, FHIRFormatError {
    Observation.ObservationReferenceRangeComponent res = new Observation.ObservationReferenceRangeComponent();
    parseBackboneProperties(json, res);
    if (json.has("low"))
      res.setLow(parseSimpleQuantity(json.getAsJsonObject("low")));
    if (json.has("high"))
      res.setHigh(parseSimpleQuantity(json.getAsJsonObject("high")));
    if (json.has("meaning"))
      res.setMeaning(parseCodeableConcept(json.getAsJsonObject("meaning")));
    if (json.has("age"))
      res.setAge(parseRange(json.getAsJsonObject("age")));
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    return res;
  }

  protected Observation.ObservationRelatedComponent parseObservationObservationRelatedComponent(JsonObject json,
      Observation owner) throws IOException, FHIRFormatError {
    Observation.ObservationRelatedComponent res = new Observation.ObservationRelatedComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Observation.ObservationRelationshipType.NULL,
          new Observation.ObservationRelationshipTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("target"))
      res.setTarget(parseReference(json.getAsJsonObject("target")));
    return res;
  }

  protected Observation.ObservationComponentComponent parseObservationObservationComponentComponent(JsonObject json,
      Observation owner) throws IOException, FHIRFormatError {
    Observation.ObservationComponentComponent res = new Observation.ObservationComponentComponent();
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("dataAbsentReason"))
      res.setDataAbsentReason(parseCodeableConcept(json.getAsJsonObject("dataAbsentReason")));
    if (json.has("referenceRange")) {
      JsonArray array = json.getAsJsonArray("referenceRange");
      for (int i = 0; i < array.size(); i++) {
        res.getReferenceRange()
            .add(parseObservationObservationReferenceRangeComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected OperationDefinition parseOperationDefinition(JsonObject json) throws IOException, FHIRFormatError {
    OperationDefinition res = new OperationDefinition();
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(),
          Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), OperationDefinition.OperationKind.NULL,
          new OperationDefinition.OperationKindEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact()
            .add(parseOperationDefinitionOperationDefinitionContactComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("requirements"))
      res.setRequirementsElement(parseString(json.get("requirements").getAsString()));
    if (json.has("_requirements"))
      parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
    if (json.has("idempotent"))
      res.setIdempotentElement(parseBoolean(json.get("idempotent").getAsBoolean()));
    if (json.has("_idempotent"))
      parseElementProperties(json.getAsJsonObject("_idempotent"), res.getIdempotentElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("base"))
      res.setBase(parseReference(json.getAsJsonObject("base")));
    if (json.has("system"))
      res.setSystemElement(parseBoolean(json.get("system").getAsBoolean()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCode(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_type")) {
      JsonArray array = json.getAsJsonArray("_type");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getType().size())
          res.getType().add(parseCode(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getType().get(i));
      }
    }
    ;
    if (json.has("instance"))
      res.setInstanceElement(parseBoolean(json.get("instance").getAsBoolean()));
    if (json.has("_instance"))
      parseElementProperties(json.getAsJsonObject("_instance"), res.getInstanceElement());
    if (json.has("parameter")) {
      JsonArray array = json.getAsJsonArray("parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter()
            .add(parseOperationDefinitionOperationDefinitionParameterComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected OperationDefinition.OperationDefinitionContactComponent parseOperationDefinitionOperationDefinitionContactComponent(
      JsonObject json, OperationDefinition owner) throws IOException, FHIRFormatError {
    OperationDefinition.OperationDefinitionContactComponent res = new OperationDefinition.OperationDefinitionContactComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected OperationDefinition.OperationDefinitionParameterComponent parseOperationDefinitionOperationDefinitionParameterComponent(
      JsonObject json, OperationDefinition owner) throws IOException, FHIRFormatError {
    OperationDefinition.OperationDefinitionParameterComponent res = new OperationDefinition.OperationDefinitionParameterComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseCode(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), OperationDefinition.OperationParameterUse.NULL,
          new OperationDefinition.OperationParameterUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("min"))
      res.setMinElement(parseInteger(json.get("min").getAsLong()));
    if (json.has("_min"))
      parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("searchType"))
      res.setSearchTypeElement(parseEnumeration(json.get("searchType").getAsString(), Enumerations.SearchParamType.NULL,
          new Enumerations.SearchParamTypeEnumFactory()));
    if (json.has("_searchType"))
      parseElementProperties(json.getAsJsonObject("_searchType"), res.getSearchTypeElement());
    if (json.has("profile"))
      res.setProfile(parseReference(json.getAsJsonObject("profile")));
    if (json.has("binding"))
      res.setBinding(
          parseOperationDefinitionOperationDefinitionParameterBindingComponent(json.getAsJsonObject("binding"), owner));
    if (json.has("part")) {
      JsonArray array = json.getAsJsonArray("part");
      for (int i = 0; i < array.size(); i++) {
        res.getPart()
            .add(parseOperationDefinitionOperationDefinitionParameterComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected OperationDefinition.OperationDefinitionParameterBindingComponent parseOperationDefinitionOperationDefinitionParameterBindingComponent(
      JsonObject json, OperationDefinition owner) throws IOException, FHIRFormatError {
    OperationDefinition.OperationDefinitionParameterBindingComponent res = new OperationDefinition.OperationDefinitionParameterBindingComponent();
    parseBackboneProperties(json, res);
    if (json.has("strength"))
      res.setStrengthElement(parseEnumeration(json.get("strength").getAsString(), Enumerations.BindingStrength.NULL,
          new Enumerations.BindingStrengthEnumFactory()));
    if (json.has("_strength"))
      parseElementProperties(json.getAsJsonObject("_strength"), res.getStrengthElement());
    Type valueSet = parseType("valueSet", json);
    if (valueSet != null)
      res.setValueSet(valueSet);
    return res;
  }

  protected OperationOutcome parseOperationOutcome(JsonObject json) throws IOException, FHIRFormatError {
    OperationOutcome res = new OperationOutcome();
    parseDomainResourceProperties(json, res);
    if (json.has("issue")) {
      JsonArray array = json.getAsJsonArray("issue");
      for (int i = 0; i < array.size(); i++) {
        res.getIssue().add(parseOperationOutcomeOperationOutcomeIssueComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected OperationOutcome.OperationOutcomeIssueComponent parseOperationOutcomeOperationOutcomeIssueComponent(
      JsonObject json, OperationOutcome owner) throws IOException, FHIRFormatError {
    OperationOutcome.OperationOutcomeIssueComponent res = new OperationOutcome.OperationOutcomeIssueComponent();
    parseBackboneProperties(json, res);
    if (json.has("severity"))
      res.setSeverityElement(parseEnumeration(json.get("severity").getAsString(), OperationOutcome.IssueSeverity.NULL,
          new OperationOutcome.IssueSeverityEnumFactory()));
    if (json.has("_severity"))
      parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), OperationOutcome.IssueType.NULL,
          new OperationOutcome.IssueTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("details"))
      res.setDetails(parseCodeableConcept(json.getAsJsonObject("details")));
    if (json.has("diagnostics"))
      res.setDiagnosticsElement(parseString(json.get("diagnostics").getAsString()));
    if (json.has("_diagnostics"))
      parseElementProperties(json.getAsJsonObject("_diagnostics"), res.getDiagnosticsElement());
    if (json.has("location")) {
      JsonArray array = json.getAsJsonArray("location");
      for (int i = 0; i < array.size(); i++) {
        res.getLocation().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_location")) {
      JsonArray array = json.getAsJsonArray("_location");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLocation().size())
          res.getLocation().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLocation().get(i));
      }
    }
    ;
    if (json.has("expression")) {
      JsonArray array = json.getAsJsonArray("expression");
      for (int i = 0; i < array.size(); i++) {
        res.getExpression().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_expression")) {
      JsonArray array = json.getAsJsonArray("_expression");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getExpression().size())
          res.getExpression().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getExpression().get(i));
      }
    }
    ;
    return res;
  }

  protected Order parseOrder(JsonObject json) throws IOException, FHIRFormatError {
    Order res = new Order();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("source"))
      res.setSource(parseReference(json.getAsJsonObject("source")));
    if (json.has("target"))
      res.setTarget(parseReference(json.getAsJsonObject("target")));
    Type reason = parseType("reason", json);
    if (reason != null)
      res.setReason(reason);
    if (json.has("when"))
      res.setWhen(parseOrderOrderWhenComponent(json.getAsJsonObject("when"), res));
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected Order.OrderWhenComponent parseOrderOrderWhenComponent(JsonObject json, Order owner)
      throws IOException, FHIRFormatError {
    Order.OrderWhenComponent res = new Order.OrderWhenComponent();
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("schedule"))
      res.setSchedule(parseTiming(json.getAsJsonObject("schedule")));
    return res;
  }

  protected OrderResponse parseOrderResponse(JsonObject json) throws IOException, FHIRFormatError {
    OrderResponse res = new OrderResponse();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("request"))
      res.setRequest(parseReference(json.getAsJsonObject("request")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("who"))
      res.setWho(parseReference(json.getAsJsonObject("who")));
    if (json.has("orderStatus"))
      res.setOrderStatusElement(parseEnumeration(json.get("orderStatus").getAsString(), OrderResponse.OrderStatus.NULL,
          new OrderResponse.OrderStatusEnumFactory()));
    if (json.has("_orderStatus"))
      parseElementProperties(json.getAsJsonObject("_orderStatus"), res.getOrderStatusElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("fulfillment")) {
      JsonArray array = json.getAsJsonArray("fulfillment");
      for (int i = 0; i < array.size(); i++) {
        res.getFulfillment().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected OrderSet parseOrderSet(JsonObject json) throws IOException, FHIRFormatError {
    OrderSet res = new OrderSet();
    parseDomainResourceProperties(json, res);
    if (json.has("moduleMetadata"))
      res.setModuleMetadata(parseModuleMetadata(json.getAsJsonObject("moduleMetadata")));
    if (json.has("library")) {
      JsonArray array = json.getAsJsonArray("library");
      for (int i = 0; i < array.size(); i++) {
        res.getLibrary().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseActionDefinition(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected Organization parseOrganization(JsonObject json) throws IOException, FHIRFormatError {
    Organization res = new Organization();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("address")) {
      JsonArray array = json.getAsJsonArray("address");
      for (int i = 0; i < array.size(); i++) {
        res.getAddress().add(parseAddress(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("partOf"))
      res.setPartOf(parseReference(json.getAsJsonObject("partOf")));
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseOrganizationOrganizationContactComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected Organization.OrganizationContactComponent parseOrganizationOrganizationContactComponent(JsonObject json,
      Organization owner) throws IOException, FHIRFormatError {
    Organization.OrganizationContactComponent res = new Organization.OrganizationContactComponent();
    parseBackboneProperties(json, res);
    if (json.has("purpose"))
      res.setPurpose(parseCodeableConcept(json.getAsJsonObject("purpose")));
    if (json.has("name"))
      res.setName(parseHumanName(json.getAsJsonObject("name")));
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("address"))
      res.setAddress(parseAddress(json.getAsJsonObject("address")));
    return res;
  }

  protected Patient parsePatient(JsonObject json) throws IOException, FHIRFormatError {
    Patient res = new Patient();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("name")) {
      JsonArray array = json.getAsJsonArray("name");
      for (int i = 0; i < array.size(); i++) {
        res.getName().add(parseHumanName(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("gender"))
      res.setGenderElement(parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL,
          new Enumerations.AdministrativeGenderEnumFactory()));
    if (json.has("_gender"))
      parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
    if (json.has("birthDate"))
      res.setBirthDateElement(parseDate(json.get("birthDate").getAsString()));
    if (json.has("_birthDate"))
      parseElementProperties(json.getAsJsonObject("_birthDate"), res.getBirthDateElement());
    Type deceased = parseType("deceased", json);
    if (deceased != null)
      res.setDeceased(deceased);
    if (json.has("address")) {
      JsonArray array = json.getAsJsonArray("address");
      for (int i = 0; i < array.size(); i++) {
        res.getAddress().add(parseAddress(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("maritalStatus"))
      res.setMaritalStatus(parseCodeableConcept(json.getAsJsonObject("maritalStatus")));
    Type multipleBirth = parseType("multipleBirth", json);
    if (multipleBirth != null)
      res.setMultipleBirth(multipleBirth);
    if (json.has("photo")) {
      JsonArray array = json.getAsJsonArray("photo");
      for (int i = 0; i < array.size(); i++) {
        res.getPhoto().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parsePatientContactComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("animal"))
      res.setAnimal(parsePatientAnimalComponent(json.getAsJsonObject("animal"), res));
    if (json.has("communication")) {
      JsonArray array = json.getAsJsonArray("communication");
      for (int i = 0; i < array.size(); i++) {
        res.getCommunication().add(parsePatientPatientCommunicationComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("careProvider")) {
      JsonArray array = json.getAsJsonArray("careProvider");
      for (int i = 0; i < array.size(); i++) {
        res.getCareProvider().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("managingOrganization"))
      res.setManagingOrganization(parseReference(json.getAsJsonObject("managingOrganization")));
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parsePatientPatientLinkComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected Patient.ContactComponent parsePatientContactComponent(JsonObject json, Patient owner)
      throws IOException, FHIRFormatError {
    Patient.ContactComponent res = new Patient.ContactComponent();
    parseBackboneProperties(json, res);
    if (json.has("relationship")) {
      JsonArray array = json.getAsJsonArray("relationship");
      for (int i = 0; i < array.size(); i++) {
        res.getRelationship().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("name"))
      res.setName(parseHumanName(json.getAsJsonObject("name")));
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("address"))
      res.setAddress(parseAddress(json.getAsJsonObject("address")));
    if (json.has("gender"))
      res.setGenderElement(parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL,
          new Enumerations.AdministrativeGenderEnumFactory()));
    if (json.has("_gender"))
      parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
    if (json.has("organization"))
      res.setOrganization(parseReference(json.getAsJsonObject("organization")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    return res;
  }

  protected Patient.AnimalComponent parsePatientAnimalComponent(JsonObject json, Patient owner)
      throws IOException, FHIRFormatError {
    Patient.AnimalComponent res = new Patient.AnimalComponent();
    parseBackboneProperties(json, res);
    if (json.has("species"))
      res.setSpecies(parseCodeableConcept(json.getAsJsonObject("species")));
    if (json.has("breed"))
      res.setBreed(parseCodeableConcept(json.getAsJsonObject("breed")));
    if (json.has("genderStatus"))
      res.setGenderStatus(parseCodeableConcept(json.getAsJsonObject("genderStatus")));
    return res;
  }

  protected Patient.PatientCommunicationComponent parsePatientPatientCommunicationComponent(JsonObject json,
      Patient owner) throws IOException, FHIRFormatError {
    Patient.PatientCommunicationComponent res = new Patient.PatientCommunicationComponent();
    parseBackboneProperties(json, res);
    if (json.has("language"))
      res.setLanguage(parseCodeableConcept(json.getAsJsonObject("language")));
    if (json.has("preferred"))
      res.setPreferredElement(parseBoolean(json.get("preferred").getAsBoolean()));
    if (json.has("_preferred"))
      parseElementProperties(json.getAsJsonObject("_preferred"), res.getPreferredElement());
    return res;
  }

  protected Patient.PatientLinkComponent parsePatientPatientLinkComponent(JsonObject json, Patient owner)
      throws IOException, FHIRFormatError {
    Patient.PatientLinkComponent res = new Patient.PatientLinkComponent();
    parseBackboneProperties(json, res);
    if (json.has("other"))
      res.setOther(parseReference(json.getAsJsonObject("other")));
    if (json.has("type"))
      res.setTypeElement(
          parseEnumeration(json.get("type").getAsString(), Patient.LinkType.NULL, new Patient.LinkTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    return res;
  }

  protected PaymentNotice parsePaymentNotice(JsonObject json) throws IOException, FHIRFormatError {
    PaymentNotice res = new PaymentNotice();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("ruleset"))
      res.setRuleset(parseCoding(json.getAsJsonObject("ruleset")));
    if (json.has("originalRuleset"))
      res.setOriginalRuleset(parseCoding(json.getAsJsonObject("originalRuleset")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    Type target = parseType("target", json);
    if (target != null)
      res.setTarget(target);
    Type provider = parseType("provider", json);
    if (provider != null)
      res.setProvider(provider);
    Type organization = parseType("organization", json);
    if (organization != null)
      res.setOrganization(organization);
    Type request = parseType("request", json);
    if (request != null)
      res.setRequest(request);
    Type response = parseType("response", json);
    if (response != null)
      res.setResponse(response);
    if (json.has("paymentStatus"))
      res.setPaymentStatus(parseCoding(json.getAsJsonObject("paymentStatus")));
    if (json.has("statusDate"))
      res.setStatusDateElement(parseDate(json.get("statusDate").getAsString()));
    if (json.has("_statusDate"))
      parseElementProperties(json.getAsJsonObject("_statusDate"), res.getStatusDateElement());
    return res;
  }

  protected PaymentReconciliation parsePaymentReconciliation(JsonObject json) throws IOException, FHIRFormatError {
    PaymentReconciliation res = new PaymentReconciliation();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    Type request = parseType("request", json);
    if (request != null)
      res.setRequest(request);
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), Enumerations.RemittanceOutcome.NULL,
          new Enumerations.RemittanceOutcomeEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
    if (json.has("ruleset"))
      res.setRuleset(parseCoding(json.getAsJsonObject("ruleset")));
    if (json.has("originalRuleset"))
      res.setOriginalRuleset(parseCoding(json.getAsJsonObject("originalRuleset")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    Type organization = parseType("organization", json);
    if (organization != null)
      res.setOrganization(organization);
    Type requestProvider = parseType("requestProvider", json);
    if (requestProvider != null)
      res.setRequestProvider(requestProvider);
    Type requestOrganization = parseType("requestOrganization", json);
    if (requestOrganization != null)
      res.setRequestOrganization(requestOrganization);
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parsePaymentReconciliationDetailsComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("form"))
      res.setForm(parseCoding(json.getAsJsonObject("form")));
    if (json.has("total"))
      res.setTotal(parseMoney(json.getAsJsonObject("total")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parsePaymentReconciliationNotesComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected PaymentReconciliation.DetailsComponent parsePaymentReconciliationDetailsComponent(JsonObject json,
      PaymentReconciliation owner) throws IOException, FHIRFormatError {
    PaymentReconciliation.DetailsComponent res = new PaymentReconciliation.DetailsComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    Type request = parseType("request", json);
    if (request != null)
      res.setRequest(request);
    Type responce = parseType("responce", json);
    if (responce != null)
      res.setResponce(responce);
    Type submitter = parseType("submitter", json);
    if (submitter != null)
      res.setSubmitter(submitter);
    Type payee = parseType("payee", json);
    if (payee != null)
      res.setPayee(payee);
    if (json.has("date"))
      res.setDateElement(parseDate(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
    return res;
  }

  protected PaymentReconciliation.NotesComponent parsePaymentReconciliationNotesComponent(JsonObject json,
      PaymentReconciliation owner) throws IOException, FHIRFormatError {
    PaymentReconciliation.NotesComponent res = new PaymentReconciliation.NotesComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    return res;
  }

  protected Person parsePerson(JsonObject json) throws IOException, FHIRFormatError {
    Person res = new Person();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("name")) {
      JsonArray array = json.getAsJsonArray("name");
      for (int i = 0; i < array.size(); i++) {
        res.getName().add(parseHumanName(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("gender"))
      res.setGenderElement(parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL,
          new Enumerations.AdministrativeGenderEnumFactory()));
    if (json.has("_gender"))
      parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
    if (json.has("birthDate"))
      res.setBirthDateElement(parseDate(json.get("birthDate").getAsString()));
    if (json.has("_birthDate"))
      parseElementProperties(json.getAsJsonObject("_birthDate"), res.getBirthDateElement());
    if (json.has("address")) {
      JsonArray array = json.getAsJsonArray("address");
      for (int i = 0; i < array.size(); i++) {
        res.getAddress().add(parseAddress(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("photo"))
      res.setPhoto(parseAttachment(json.getAsJsonObject("photo")));
    if (json.has("managingOrganization"))
      res.setManagingOrganization(parseReference(json.getAsJsonObject("managingOrganization")));
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parsePersonPersonLinkComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected Person.PersonLinkComponent parsePersonPersonLinkComponent(JsonObject json, Person owner)
      throws IOException, FHIRFormatError {
    Person.PersonLinkComponent res = new Person.PersonLinkComponent();
    parseBackboneProperties(json, res);
    if (json.has("target"))
      res.setTarget(parseReference(json.getAsJsonObject("target")));
    if (json.has("assurance"))
      res.setAssuranceElement(parseEnumeration(json.get("assurance").getAsString(), Person.IdentityAssuranceLevel.NULL,
          new Person.IdentityAssuranceLevelEnumFactory()));
    if (json.has("_assurance"))
      parseElementProperties(json.getAsJsonObject("_assurance"), res.getAssuranceElement());
    return res;
  }

  protected Practitioner parsePractitioner(JsonObject json) throws IOException, FHIRFormatError {
    Practitioner res = new Practitioner();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("name")) {
      JsonArray array = json.getAsJsonArray("name");
      for (int i = 0; i < array.size(); i++) {
        res.getName().add(parseHumanName(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("address")) {
      JsonArray array = json.getAsJsonArray("address");
      for (int i = 0; i < array.size(); i++) {
        res.getAddress().add(parseAddress(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("gender"))
      res.setGenderElement(parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL,
          new Enumerations.AdministrativeGenderEnumFactory()));
    if (json.has("_gender"))
      parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
    if (json.has("birthDate"))
      res.setBirthDateElement(parseDate(json.get("birthDate").getAsString()));
    if (json.has("_birthDate"))
      parseElementProperties(json.getAsJsonObject("_birthDate"), res.getBirthDateElement());
    if (json.has("photo")) {
      JsonArray array = json.getAsJsonArray("photo");
      for (int i = 0; i < array.size(); i++) {
        res.getPhoto().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("practitionerRole")) {
      JsonArray array = json.getAsJsonArray("practitionerRole");
      for (int i = 0; i < array.size(); i++) {
        res.getPractitionerRole()
            .add(parsePractitionerPractitionerPractitionerRoleComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("qualification")) {
      JsonArray array = json.getAsJsonArray("qualification");
      for (int i = 0; i < array.size(); i++) {
        res.getQualification()
            .add(parsePractitionerPractitionerQualificationComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("communication")) {
      JsonArray array = json.getAsJsonArray("communication");
      for (int i = 0; i < array.size(); i++) {
        res.getCommunication().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected Practitioner.PractitionerPractitionerRoleComponent parsePractitionerPractitionerPractitionerRoleComponent(
      JsonObject json, Practitioner owner) throws IOException, FHIRFormatError {
    Practitioner.PractitionerPractitionerRoleComponent res = new Practitioner.PractitionerPractitionerRoleComponent();
    parseBackboneProperties(json, res);
    if (json.has("organization"))
      res.setOrganization(parseReference(json.getAsJsonObject("organization")));
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("specialty")) {
      JsonArray array = json.getAsJsonArray("specialty");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialty().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("location")) {
      JsonArray array = json.getAsJsonArray("location");
      for (int i = 0; i < array.size(); i++) {
        res.getLocation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("healthcareService")) {
      JsonArray array = json.getAsJsonArray("healthcareService");
      for (int i = 0; i < array.size(); i++) {
        res.getHealthcareService().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected Practitioner.PractitionerQualificationComponent parsePractitionerPractitionerQualificationComponent(
      JsonObject json, Practitioner owner) throws IOException, FHIRFormatError {
    Practitioner.PractitionerQualificationComponent res = new Practitioner.PractitionerQualificationComponent();
    parseBackboneProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("issuer"))
      res.setIssuer(parseReference(json.getAsJsonObject("issuer")));
    return res;
  }

  protected PractitionerRole parsePractitionerRole(JsonObject json) throws IOException, FHIRFormatError {
    PractitionerRole res = new PractitionerRole();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("practitioner"))
      res.setPractitioner(parseReference(json.getAsJsonObject("practitioner")));
    if (json.has("organization"))
      res.setOrganization(parseReference(json.getAsJsonObject("organization")));
    if (json.has("role")) {
      JsonArray array = json.getAsJsonArray("role");
      for (int i = 0; i < array.size(); i++) {
        res.getRole().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("specialty")) {
      JsonArray array = json.getAsJsonArray("specialty");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialty().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("location")) {
      JsonArray array = json.getAsJsonArray("location");
      for (int i = 0; i < array.size(); i++) {
        res.getLocation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("healthcareService")) {
      JsonArray array = json.getAsJsonArray("healthcareService");
      for (int i = 0; i < array.size(); i++) {
        res.getHealthcareService().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("availableTime")) {
      JsonArray array = json.getAsJsonArray("availableTime");
      for (int i = 0; i < array.size(); i++) {
        res.getAvailableTime()
            .add(parsePractitionerRolePractitionerRoleAvailableTimeComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("notAvailable")) {
      JsonArray array = json.getAsJsonArray("notAvailable");
      for (int i = 0; i < array.size(); i++) {
        res.getNotAvailable()
            .add(parsePractitionerRolePractitionerRoleNotAvailableComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("availabilityExceptions"))
      res.setAvailabilityExceptionsElement(parseString(json.get("availabilityExceptions").getAsString()));
    if (json.has("_availabilityExceptions"))
      parseElementProperties(json.getAsJsonObject("_availabilityExceptions"), res.getAvailabilityExceptionsElement());
    return res;
  }

  protected PractitionerRole.PractitionerRoleAvailableTimeComponent parsePractitionerRolePractitionerRoleAvailableTimeComponent(
      JsonObject json, PractitionerRole owner) throws IOException, FHIRFormatError {
    PractitionerRole.PractitionerRoleAvailableTimeComponent res = new PractitionerRole.PractitionerRoleAvailableTimeComponent();
    parseBackboneProperties(json, res);
    if (json.has("daysOfWeek")) {
      JsonArray array = json.getAsJsonArray("daysOfWeek");
      for (int i = 0; i < array.size(); i++) {
        res.getDaysOfWeek().add(parseCode(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_daysOfWeek")) {
      JsonArray array = json.getAsJsonArray("_daysOfWeek");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDaysOfWeek().size())
          res.getDaysOfWeek().add(parseCode(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDaysOfWeek().get(i));
      }
    }
    ;
    if (json.has("allDay"))
      res.setAllDayElement(parseBoolean(json.get("allDay").getAsBoolean()));
    if (json.has("_allDay"))
      parseElementProperties(json.getAsJsonObject("_allDay"), res.getAllDayElement());
    if (json.has("availableStartTime"))
      res.setAvailableStartTimeElement(parseTime(json.get("availableStartTime").getAsString()));
    if (json.has("_availableStartTime"))
      parseElementProperties(json.getAsJsonObject("_availableStartTime"), res.getAvailableStartTimeElement());
    if (json.has("availableEndTime"))
      res.setAvailableEndTimeElement(parseTime(json.get("availableEndTime").getAsString()));
    if (json.has("_availableEndTime"))
      parseElementProperties(json.getAsJsonObject("_availableEndTime"), res.getAvailableEndTimeElement());
    return res;
  }

  protected PractitionerRole.PractitionerRoleNotAvailableComponent parsePractitionerRolePractitionerRoleNotAvailableComponent(
      JsonObject json, PractitionerRole owner) throws IOException, FHIRFormatError {
    PractitionerRole.PractitionerRoleNotAvailableComponent res = new PractitionerRole.PractitionerRoleNotAvailableComponent();
    parseBackboneProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("during"))
      res.setDuring(parsePeriod(json.getAsJsonObject("during")));
    return res;
  }

  protected Procedure parseProcedure(JsonObject json) throws IOException, FHIRFormatError {
    Procedure res = new Procedure();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Procedure.ProcedureStatus.NULL,
          new Procedure.ProcedureStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("notPerformed"))
      res.setNotPerformedElement(parseBoolean(json.get("notPerformed").getAsBoolean()));
    if (json.has("_notPerformed"))
      parseElementProperties(json.getAsJsonObject("_notPerformed"), res.getNotPerformedElement());
    if (json.has("reasonNotPerformed")) {
      JsonArray array = json.getAsJsonArray("reasonNotPerformed");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonNotPerformed().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("bodySite")) {
      JsonArray array = json.getAsJsonArray("bodySite");
      for (int i = 0; i < array.size(); i++) {
        res.getBodySite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    Type reason = parseType("reason", json);
    if (reason != null)
      res.setReason(reason);
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseProcedureProcedurePerformerComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    Type performed = parseType("performed", json);
    if (performed != null)
      res.setPerformed(performed);
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("outcome"))
      res.setOutcome(parseCodeableConcept(json.getAsJsonObject("outcome")));
    if (json.has("report")) {
      JsonArray array = json.getAsJsonArray("report");
      for (int i = 0; i < array.size(); i++) {
        res.getReport().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("complication")) {
      JsonArray array = json.getAsJsonArray("complication");
      for (int i = 0; i < array.size(); i++) {
        res.getComplication().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("followUp")) {
      JsonArray array = json.getAsJsonArray("followUp");
      for (int i = 0; i < array.size(); i++) {
        res.getFollowUp().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("request"))
      res.setRequest(parseReference(json.getAsJsonObject("request")));
    if (json.has("notes")) {
      JsonArray array = json.getAsJsonArray("notes");
      for (int i = 0; i < array.size(); i++) {
        res.getNotes().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("focalDevice")) {
      JsonArray array = json.getAsJsonArray("focalDevice");
      for (int i = 0; i < array.size(); i++) {
        res.getFocalDevice().add(parseProcedureProcedureFocalDeviceComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("used")) {
      JsonArray array = json.getAsJsonArray("used");
      for (int i = 0; i < array.size(); i++) {
        res.getUsed().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected Procedure.ProcedurePerformerComponent parseProcedureProcedurePerformerComponent(JsonObject json,
      Procedure owner) throws IOException, FHIRFormatError {
    Procedure.ProcedurePerformerComponent res = new Procedure.ProcedurePerformerComponent();
    parseBackboneProperties(json, res);
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    return res;
  }

  protected Procedure.ProcedureFocalDeviceComponent parseProcedureProcedureFocalDeviceComponent(JsonObject json,
      Procedure owner) throws IOException, FHIRFormatError {
    Procedure.ProcedureFocalDeviceComponent res = new Procedure.ProcedureFocalDeviceComponent();
    parseBackboneProperties(json, res);
    if (json.has("action"))
      res.setAction(parseCodeableConcept(json.getAsJsonObject("action")));
    if (json.has("manipulated"))
      res.setManipulated(parseReference(json.getAsJsonObject("manipulated")));
    return res;
  }

  protected ProcedureRequest parseProcedureRequest(JsonObject json) throws IOException, FHIRFormatError {
    ProcedureRequest res = new ProcedureRequest();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("bodySite")) {
      JsonArray array = json.getAsJsonArray("bodySite");
      for (int i = 0; i < array.size(); i++) {
        res.getBodySite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    Type reason = parseType("reason", json);
    if (reason != null)
      res.setReason(reason);
    Type scheduled = parseType("scheduled", json);
    if (scheduled != null)
      res.setScheduled(scheduled);
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("performer"))
      res.setPerformer(parseReference(json.getAsJsonObject("performer")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(),
          ProcedureRequest.ProcedureRequestStatus.NULL, new ProcedureRequest.ProcedureRequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("notes")) {
      JsonArray array = json.getAsJsonArray("notes");
      for (int i = 0; i < array.size(); i++) {
        res.getNotes().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    }
    ;
    Type asNeeded = parseType("asNeeded", json);
    if (asNeeded != null)
      res.setAsNeeded(asNeeded);
    if (json.has("orderedOn"))
      res.setOrderedOnElement(parseDateTime(json.get("orderedOn").getAsString()));
    if (json.has("_orderedOn"))
      parseElementProperties(json.getAsJsonObject("_orderedOn"), res.getOrderedOnElement());
    if (json.has("orderer"))
      res.setOrderer(parseReference(json.getAsJsonObject("orderer")));
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(),
          ProcedureRequest.ProcedureRequestPriority.NULL, new ProcedureRequest.ProcedureRequestPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    return res;
  }

  protected ProcessRequest parseProcessRequest(JsonObject json) throws IOException, FHIRFormatError {
    ProcessRequest res = new ProcessRequest();
    parseDomainResourceProperties(json, res);
    if (json.has("action"))
      res.setActionElement(parseEnumeration(json.get("action").getAsString(), ProcessRequest.ActionList.NULL,
          new ProcessRequest.ActionListEnumFactory()));
    if (json.has("_action"))
      parseElementProperties(json.getAsJsonObject("_action"), res.getActionElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("ruleset"))
      res.setRuleset(parseCoding(json.getAsJsonObject("ruleset")));
    if (json.has("originalRuleset"))
      res.setOriginalRuleset(parseCoding(json.getAsJsonObject("originalRuleset")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    Type target = parseType("target", json);
    if (target != null)
      res.setTarget(target);
    Type provider = parseType("provider", json);
    if (provider != null)
      res.setProvider(provider);
    Type organization = parseType("organization", json);
    if (organization != null)
      res.setOrganization(organization);
    Type request = parseType("request", json);
    if (request != null)
      res.setRequest(request);
    Type response = parseType("response", json);
    if (response != null)
      res.setResponse(response);
    if (json.has("nullify"))
      res.setNullifyElement(parseBoolean(json.get("nullify").getAsBoolean()));
    if (json.has("_nullify"))
      parseElementProperties(json.getAsJsonObject("_nullify"), res.getNullifyElement());
    if (json.has("reference"))
      res.setReferenceElement(parseString(json.get("reference").getAsString()));
    if (json.has("_reference"))
      parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseProcessRequestItemsComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("include")) {
      JsonArray array = json.getAsJsonArray("include");
      for (int i = 0; i < array.size(); i++) {
        res.getInclude().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_include")) {
      JsonArray array = json.getAsJsonArray("_include");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInclude().size())
          res.getInclude().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInclude().get(i));
      }
    }
    ;
    if (json.has("exclude")) {
      JsonArray array = json.getAsJsonArray("exclude");
      for (int i = 0; i < array.size(); i++) {
        res.getExclude().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_exclude")) {
      JsonArray array = json.getAsJsonArray("_exclude");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getExclude().size())
          res.getExclude().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getExclude().get(i));
      }
    }
    ;
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    return res;
  }

  protected ProcessRequest.ItemsComponent parseProcessRequestItemsComponent(JsonObject json, ProcessRequest owner)
      throws IOException, FHIRFormatError {
    ProcessRequest.ItemsComponent res = new ProcessRequest.ItemsComponent();
    parseBackboneProperties(json, res);
    if (json.has("sequenceLinkId"))
      res.setSequenceLinkIdElement(parseInteger(json.get("sequenceLinkId").getAsLong()));
    if (json.has("_sequenceLinkId"))
      parseElementProperties(json.getAsJsonObject("_sequenceLinkId"), res.getSequenceLinkIdElement());
    return res;
  }

  protected ProcessResponse parseProcessResponse(JsonObject json) throws IOException, FHIRFormatError {
    ProcessResponse res = new ProcessResponse();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    Type request = parseType("request", json);
    if (request != null)
      res.setRequest(request);
    if (json.has("outcome"))
      res.setOutcome(parseCoding(json.getAsJsonObject("outcome")));
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
    if (json.has("ruleset"))
      res.setRuleset(parseCoding(json.getAsJsonObject("ruleset")));
    if (json.has("originalRuleset"))
      res.setOriginalRuleset(parseCoding(json.getAsJsonObject("originalRuleset")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    Type organization = parseType("organization", json);
    if (organization != null)
      res.setOrganization(organization);
    Type requestProvider = parseType("requestProvider", json);
    if (requestProvider != null)
      res.setRequestProvider(requestProvider);
    Type requestOrganization = parseType("requestOrganization", json);
    if (requestOrganization != null)
      res.setRequestOrganization(requestOrganization);
    if (json.has("form"))
      res.setForm(parseCoding(json.getAsJsonObject("form")));
    if (json.has("notes")) {
      JsonArray array = json.getAsJsonArray("notes");
      for (int i = 0; i < array.size(); i++) {
        res.getNotes().add(parseProcessResponseProcessResponseNotesComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("error")) {
      JsonArray array = json.getAsJsonArray("error");
      for (int i = 0; i < array.size(); i++) {
        res.getError().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected ProcessResponse.ProcessResponseNotesComponent parseProcessResponseProcessResponseNotesComponent(
      JsonObject json, ProcessResponse owner) throws IOException, FHIRFormatError {
    ProcessResponse.ProcessResponseNotesComponent res = new ProcessResponse.ProcessResponseNotesComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    return res;
  }

  protected Protocol parseProtocol(JsonObject json) throws IOException, FHIRFormatError {
    Protocol res = new Protocol();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Protocol.ProtocolStatus.NULL,
          new Protocol.ProtocolStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Protocol.ProtocolType.NULL,
          new Protocol.ProtocolTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("group"))
      res.setGroup(parseReference(json.getAsJsonObject("group")));
    if (json.has("purpose"))
      res.setPurposeElement(parseString(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    if (json.has("step")) {
      JsonArray array = json.getAsJsonArray("step");
      for (int i = 0; i < array.size(); i++) {
        res.getStep().add(parseProtocolProtocolStepComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected Protocol.ProtocolStepComponent parseProtocolProtocolStepComponent(JsonObject json, Protocol owner)
      throws IOException, FHIRFormatError {
    Protocol.ProtocolStepComponent res = new Protocol.ProtocolStepComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("duration"))
      res.setDuration(parseDuration(json.getAsJsonObject("duration")));
    if (json.has("precondition"))
      res.setPrecondition(parseProtocolProtocolStepPreconditionComponent(json.getAsJsonObject("precondition"), owner));
    if (json.has("exit"))
      res.setExit(parseProtocolProtocolStepPreconditionComponent(json.getAsJsonObject("exit"), owner));
    if (json.has("firstActivity"))
      res.setFirstActivityElement(parseUri(json.get("firstActivity").getAsString()));
    if (json.has("_firstActivity"))
      parseElementProperties(json.getAsJsonObject("_firstActivity"), res.getFirstActivityElement());
    if (json.has("activity")) {
      JsonArray array = json.getAsJsonArray("activity");
      for (int i = 0; i < array.size(); i++) {
        res.getActivity().add(parseProtocolProtocolStepActivityComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("next")) {
      JsonArray array = json.getAsJsonArray("next");
      for (int i = 0; i < array.size(); i++) {
        res.getNext().add(parseProtocolProtocolStepNextComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected Protocol.ProtocolStepPreconditionComponent parseProtocolProtocolStepPreconditionComponent(JsonObject json,
      Protocol owner) throws IOException, FHIRFormatError {
    Protocol.ProtocolStepPreconditionComponent res = new Protocol.ProtocolStepPreconditionComponent();
    parseBackboneProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("condition"))
      res.setCondition(
          parseProtocolProtocolStepPreconditionConditionComponent(json.getAsJsonObject("condition"), owner));
    if (json.has("intersection")) {
      JsonArray array = json.getAsJsonArray("intersection");
      for (int i = 0; i < array.size(); i++) {
        res.getIntersection()
            .add(parseProtocolProtocolStepPreconditionComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("union")) {
      JsonArray array = json.getAsJsonArray("union");
      for (int i = 0; i < array.size(); i++) {
        res.getUnion().add(parseProtocolProtocolStepPreconditionComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("exclude")) {
      JsonArray array = json.getAsJsonArray("exclude");
      for (int i = 0; i < array.size(); i++) {
        res.getExclude().add(parseProtocolProtocolStepPreconditionComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected Protocol.ProtocolStepPreconditionConditionComponent parseProtocolProtocolStepPreconditionConditionComponent(
      JsonObject json, Protocol owner) throws IOException, FHIRFormatError {
    Protocol.ProtocolStepPreconditionConditionComponent res = new Protocol.ProtocolStepPreconditionConditionComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    return res;
  }

  protected Protocol.ProtocolStepActivityComponent parseProtocolProtocolStepActivityComponent(JsonObject json,
      Protocol owner) throws IOException, FHIRFormatError {
    Protocol.ProtocolStepActivityComponent res = new Protocol.ProtocolStepActivityComponent();
    parseBackboneProperties(json, res);
    if (json.has("alternative")) {
      JsonArray array = json.getAsJsonArray("alternative");
      for (int i = 0; i < array.size(); i++) {
        res.getAlternative().add(parseUri(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_alternative")) {
      JsonArray array = json.getAsJsonArray("_alternative");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAlternative().size())
          res.getAlternative().add(parseUri(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAlternative().get(i));
      }
    }
    ;
    if (json.has("component")) {
      JsonArray array = json.getAsJsonArray("component");
      for (int i = 0; i < array.size(); i++) {
        res.getComponent()
            .add(parseProtocolProtocolStepActivityComponentComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("following")) {
      JsonArray array = json.getAsJsonArray("following");
      for (int i = 0; i < array.size(); i++) {
        res.getFollowing().add(parseUri(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_following")) {
      JsonArray array = json.getAsJsonArray("_following");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getFollowing().size())
          res.getFollowing().add(parseUri(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getFollowing().get(i));
      }
    }
    ;
    if (json.has("wait"))
      res.setWait(parseDuration(json.getAsJsonObject("wait")));
    if (json.has("detail"))
      res.setDetail(parseProtocolProtocolStepActivityDetailComponent(json.getAsJsonObject("detail"), owner));
    return res;
  }

  protected Protocol.ProtocolStepActivityComponentComponent parseProtocolProtocolStepActivityComponentComponent(
      JsonObject json, Protocol owner) throws IOException, FHIRFormatError {
    Protocol.ProtocolStepActivityComponentComponent res = new Protocol.ProtocolStepActivityComponentComponent();
    parseBackboneProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parseInteger(json.get("sequence").getAsLong()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("activity"))
      res.setActivityElement(parseUri(json.get("activity").getAsString()));
    if (json.has("_activity"))
      parseElementProperties(json.getAsJsonObject("_activity"), res.getActivityElement());
    return res;
  }

  protected Protocol.ProtocolStepActivityDetailComponent parseProtocolProtocolStepActivityDetailComponent(
      JsonObject json, Protocol owner) throws IOException, FHIRFormatError {
    Protocol.ProtocolStepActivityDetailComponent res = new Protocol.ProtocolStepActivityDetailComponent();
    parseBackboneProperties(json, res);
    if (json.has("category"))
      res.setCategoryElement(parseEnumeration(json.get("category").getAsString(),
          Protocol.ActivityDefinitionCategory.NULL, new Protocol.ActivityDefinitionCategoryEnumFactory()));
    if (json.has("_category"))
      parseElementProperties(json.getAsJsonObject("_category"), res.getCategoryElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    Type timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("product"))
      res.setProduct(parseReference(json.getAsJsonObject("product")));
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    return res;
  }

  protected Protocol.ProtocolStepNextComponent parseProtocolProtocolStepNextComponent(JsonObject json, Protocol owner)
      throws IOException, FHIRFormatError {
    Protocol.ProtocolStepNextComponent res = new Protocol.ProtocolStepNextComponent();
    parseBackboneProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("reference"))
      res.setReferenceElement(parseUri(json.get("reference").getAsString()));
    if (json.has("_reference"))
      parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
    if (json.has("condition"))
      res.setCondition(parseProtocolProtocolStepPreconditionComponent(json.getAsJsonObject("condition"), owner));
    return res;
  }

  protected Provenance parseProvenance(JsonObject json) throws IOException, FHIRFormatError {
    Provenance res = new Provenance();
    parseDomainResourceProperties(json, res);
    if (json.has("target")) {
      JsonArray array = json.getAsJsonArray("target");
      for (int i = 0; i < array.size(); i++) {
        res.getTarget().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("recorded"))
      res.setRecordedElement(parseInstant(json.get("recorded").getAsString()));
    if (json.has("_recorded"))
      parseElementProperties(json.getAsJsonObject("_recorded"), res.getRecordedElement());
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("activity"))
      res.setActivity(parseCoding(json.getAsJsonObject("activity")));
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("policy")) {
      JsonArray array = json.getAsJsonArray("policy");
      for (int i = 0; i < array.size(); i++) {
        res.getPolicy().add(parseUri(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_policy")) {
      JsonArray array = json.getAsJsonArray("_policy");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPolicy().size())
          res.getPolicy().add(parseUri(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPolicy().get(i));
      }
    }
    ;
    if (json.has("agent")) {
      JsonArray array = json.getAsJsonArray("agent");
      for (int i = 0; i < array.size(); i++) {
        res.getAgent().add(parseProvenanceProvenanceAgentComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("entity")) {
      JsonArray array = json.getAsJsonArray("entity");
      for (int i = 0; i < array.size(); i++) {
        res.getEntity().add(parseProvenanceProvenanceEntityComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("signature")) {
      JsonArray array = json.getAsJsonArray("signature");
      for (int i = 0; i < array.size(); i++) {
        res.getSignature().add(parseSignature(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected Provenance.ProvenanceAgentComponent parseProvenanceProvenanceAgentComponent(JsonObject json,
      Provenance owner) throws IOException, FHIRFormatError {
    Provenance.ProvenanceAgentComponent res = new Provenance.ProvenanceAgentComponent();
    parseBackboneProperties(json, res);
    if (json.has("role"))
      res.setRole(parseCoding(json.getAsJsonObject("role")));
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
    if (json.has("userId"))
      res.setUserId(parseIdentifier(json.getAsJsonObject("userId")));
    if (json.has("relatedAgent")) {
      JsonArray array = json.getAsJsonArray("relatedAgent");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedAgent()
            .add(parseProvenanceProvenanceAgentRelatedAgentComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected Provenance.ProvenanceAgentRelatedAgentComponent parseProvenanceProvenanceAgentRelatedAgentComponent(
      JsonObject json, Provenance owner) throws IOException, FHIRFormatError {
    Provenance.ProvenanceAgentRelatedAgentComponent res = new Provenance.ProvenanceAgentRelatedAgentComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("target"))
      res.setTargetElement(parseUri(json.get("target").getAsString()));
    if (json.has("_target"))
      parseElementProperties(json.getAsJsonObject("_target"), res.getTargetElement());
    return res;
  }

  protected Provenance.ProvenanceEntityComponent parseProvenanceProvenanceEntityComponent(JsonObject json,
      Provenance owner) throws IOException, FHIRFormatError {
    Provenance.ProvenanceEntityComponent res = new Provenance.ProvenanceEntityComponent();
    parseBackboneProperties(json, res);
    if (json.has("role"))
      res.setRoleElement(parseEnumeration(json.get("role").getAsString(), Provenance.ProvenanceEntityRole.NULL,
          new Provenance.ProvenanceEntityRoleEnumFactory()));
    if (json.has("_role"))
      parseElementProperties(json.getAsJsonObject("_role"), res.getRoleElement());
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("reference"))
      res.setReferenceElement(parseUri(json.get("reference").getAsString()));
    if (json.has("_reference"))
      parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    if (json.has("agent"))
      res.setAgent(parseProvenanceProvenanceAgentComponent(json.getAsJsonObject("agent"), owner));
    return res;
  }

  protected Questionnaire parseQuestionnaire(JsonObject json) throws IOException, FHIRFormatError {
    Questionnaire res = new Questionnaire();
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Questionnaire.QuestionnaireStatus.NULL,
          new Questionnaire.QuestionnaireStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("concept")) {
      JsonArray array = json.getAsJsonArray("concept");
      for (int i = 0; i < array.size(); i++) {
        res.getConcept().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("subjectType")) {
      JsonArray array = json.getAsJsonArray("subjectType");
      for (int i = 0; i < array.size(); i++) {
        res.getSubjectType().add(parseCode(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_subjectType")) {
      JsonArray array = json.getAsJsonArray("_subjectType");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSubjectType().size())
          res.getSubjectType().add(parseCode(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSubjectType().get(i));
      }
    }
    ;
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseQuestionnaireQuestionnaireItemComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected Questionnaire.QuestionnaireItemComponent parseQuestionnaireQuestionnaireItemComponent(JsonObject json,
      Questionnaire owner) throws IOException, FHIRFormatError {
    Questionnaire.QuestionnaireItemComponent res = new Questionnaire.QuestionnaireItemComponent();
    parseBackboneProperties(json, res);
    if (json.has("linkId"))
      res.setLinkIdElement(parseString(json.get("linkId").getAsString()));
    if (json.has("_linkId"))
      parseElementProperties(json.getAsJsonObject("_linkId"), res.getLinkIdElement());
    if (json.has("concept")) {
      JsonArray array = json.getAsJsonArray("concept");
      for (int i = 0; i < array.size(); i++) {
        res.getConcept().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("prefix"))
      res.setPrefixElement(parseString(json.get("prefix").getAsString()));
    if (json.has("_prefix"))
      parseElementProperties(json.getAsJsonObject("_prefix"), res.getPrefixElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Questionnaire.QuestionnaireItemType.NULL,
          new Questionnaire.QuestionnaireItemTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("enableWhen")) {
      JsonArray array = json.getAsJsonArray("enableWhen");
      for (int i = 0; i < array.size(); i++) {
        res.getEnableWhen()
            .add(parseQuestionnaireQuestionnaireItemEnableWhenComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("required"))
      res.setRequiredElement(parseBoolean(json.get("required").getAsBoolean()));
    if (json.has("_required"))
      parseElementProperties(json.getAsJsonObject("_required"), res.getRequiredElement());
    if (json.has("repeats"))
      res.setRepeatsElement(parseBoolean(json.get("repeats").getAsBoolean()));
    if (json.has("_repeats"))
      parseElementProperties(json.getAsJsonObject("_repeats"), res.getRepeatsElement());
    if (json.has("readOnly"))
      res.setReadOnlyElement(parseBoolean(json.get("readOnly").getAsBoolean()));
    if (json.has("_readOnly"))
      parseElementProperties(json.getAsJsonObject("_readOnly"), res.getReadOnlyElement());
    if (json.has("maxLength"))
      res.setMaxLengthElement(parseInteger(json.get("maxLength").getAsLong()));
    if (json.has("_maxLength"))
      parseElementProperties(json.getAsJsonObject("_maxLength"), res.getMaxLengthElement());
    if (json.has("options"))
      res.setOptions(parseReference(json.getAsJsonObject("options")));
    if (json.has("option")) {
      JsonArray array = json.getAsJsonArray("option");
      for (int i = 0; i < array.size(); i++) {
        res.getOption().add(parseQuestionnaireQuestionnaireItemOptionComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    Type initial = parseType("initial", json);
    if (initial != null)
      res.setInitial(initial);
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseQuestionnaireQuestionnaireItemComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected Questionnaire.QuestionnaireItemEnableWhenComponent parseQuestionnaireQuestionnaireItemEnableWhenComponent(
      JsonObject json, Questionnaire owner) throws IOException, FHIRFormatError {
    Questionnaire.QuestionnaireItemEnableWhenComponent res = new Questionnaire.QuestionnaireItemEnableWhenComponent();
    parseBackboneProperties(json, res);
    if (json.has("question"))
      res.setQuestionElement(parseString(json.get("question").getAsString()));
    if (json.has("_question"))
      parseElementProperties(json.getAsJsonObject("_question"), res.getQuestionElement());
    if (json.has("answered"))
      res.setAnsweredElement(parseBoolean(json.get("answered").getAsBoolean()));
    if (json.has("_answered"))
      parseElementProperties(json.getAsJsonObject("_answered"), res.getAnsweredElement());
    Type answer = parseType("answer", json);
    if (answer != null)
      res.setAnswer(answer);
    return res;
  }

  protected Questionnaire.QuestionnaireItemOptionComponent parseQuestionnaireQuestionnaireItemOptionComponent(
      JsonObject json, Questionnaire owner) throws IOException, FHIRFormatError {
    Questionnaire.QuestionnaireItemOptionComponent res = new Questionnaire.QuestionnaireItemOptionComponent();
    parseBackboneProperties(json, res);
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    return res;
  }

  protected QuestionnaireResponse parseQuestionnaireResponse(JsonObject json) throws IOException, FHIRFormatError {
    QuestionnaireResponse res = new QuestionnaireResponse();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("questionnaire"))
      res.setQuestionnaire(parseReference(json.getAsJsonObject("questionnaire")));
    if (json.has("status"))
      res.setStatusElement(
          parseEnumeration(json.get("status").getAsString(), QuestionnaireResponse.QuestionnaireResponseStatus.NULL,
              new QuestionnaireResponse.QuestionnaireResponseStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    if (json.has("authored"))
      res.setAuthoredElement(parseDateTime(json.get("authored").getAsString()));
    if (json.has("_authored"))
      parseElementProperties(json.getAsJsonObject("_authored"), res.getAuthoredElement());
    if (json.has("source"))
      res.setSource(parseReference(json.getAsJsonObject("source")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem()
            .add(parseQuestionnaireResponseQuestionnaireResponseItemComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected QuestionnaireResponse.QuestionnaireResponseItemComponent parseQuestionnaireResponseQuestionnaireResponseItemComponent(
      JsonObject json, QuestionnaireResponse owner) throws IOException, FHIRFormatError {
    QuestionnaireResponse.QuestionnaireResponseItemComponent res = new QuestionnaireResponse.QuestionnaireResponseItemComponent();
    parseBackboneProperties(json, res);
    if (json.has("linkId"))
      res.setLinkIdElement(parseString(json.get("linkId").getAsString()));
    if (json.has("_linkId"))
      parseElementProperties(json.getAsJsonObject("_linkId"), res.getLinkIdElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("answer")) {
      JsonArray array = json.getAsJsonArray("answer");
      for (int i = 0; i < array.size(); i++) {
        res.getAnswer().add(
            parseQuestionnaireResponseQuestionnaireResponseItemAnswerComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem()
            .add(parseQuestionnaireResponseQuestionnaireResponseItemComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent parseQuestionnaireResponseQuestionnaireResponseItemAnswerComponent(
      JsonObject json, QuestionnaireResponse owner) throws IOException, FHIRFormatError {
    QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent res = new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent();
    parseBackboneProperties(json, res);
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem()
            .add(parseQuestionnaireResponseQuestionnaireResponseItemComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ReferralRequest parseReferralRequest(JsonObject json) throws IOException, FHIRFormatError {
    ReferralRequest res = new ReferralRequest();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("parent"))
      res.setParent(parseIdentifier(json.getAsJsonObject("parent")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ReferralRequest.ReferralStatus.NULL,
          new ReferralRequest.ReferralStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category"))
      res.setCategoryElement(parseEnumeration(json.get("category").getAsString(), ReferralRequest.ReferralCategory.NULL,
          new ReferralRequest.ReferralCategoryEnumFactory()));
    if (json.has("_category"))
      parseElementProperties(json.getAsJsonObject("_category"), res.getCategoryElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(json.getAsJsonObject("priority")));
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("fulfillmentTime"))
      res.setFulfillmentTime(parsePeriod(json.getAsJsonObject("fulfillmentTime")));
    if (json.has("authored"))
      res.setAuthoredElement(parseDateTime(json.get("authored").getAsString()));
    if (json.has("_authored"))
      parseElementProperties(json.getAsJsonObject("_authored"), res.getAuthoredElement());
    if (json.has("requester"))
      res.setRequester(parseReference(json.getAsJsonObject("requester")));
    if (json.has("specialty"))
      res.setSpecialty(parseCodeableConcept(json.getAsJsonObject("specialty")));
    if (json.has("recipient")) {
      JsonArray array = json.getAsJsonArray("recipient");
      for (int i = 0; i < array.size(); i++) {
        res.getRecipient().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(json.getAsJsonObject("reason")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("serviceRequested")) {
      JsonArray array = json.getAsJsonArray("serviceRequested");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceRequested().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("supportingInformation")) {
      JsonArray array = json.getAsJsonArray("supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected RelatedPerson parseRelatedPerson(JsonObject json) throws IOException, FHIRFormatError {
    RelatedPerson res = new RelatedPerson();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("relationship"))
      res.setRelationship(parseCodeableConcept(json.getAsJsonObject("relationship")));
    if (json.has("name"))
      res.setName(parseHumanName(json.getAsJsonObject("name")));
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("gender"))
      res.setGenderElement(parseEnumeration(json.get("gender").getAsString(), Enumerations.AdministrativeGender.NULL,
          new Enumerations.AdministrativeGenderEnumFactory()));
    if (json.has("_gender"))
      parseElementProperties(json.getAsJsonObject("_gender"), res.getGenderElement());
    if (json.has("birthDate"))
      res.setBirthDateElement(parseDate(json.get("birthDate").getAsString()));
    if (json.has("_birthDate"))
      parseElementProperties(json.getAsJsonObject("_birthDate"), res.getBirthDateElement());
    if (json.has("address")) {
      JsonArray array = json.getAsJsonArray("address");
      for (int i = 0; i < array.size(); i++) {
        res.getAddress().add(parseAddress(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("photo")) {
      JsonArray array = json.getAsJsonArray("photo");
      for (int i = 0; i < array.size(); i++) {
        res.getPhoto().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    return res;
  }

  protected RiskAssessment parseRiskAssessment(JsonObject json) throws IOException, FHIRFormatError {
    RiskAssessment res = new RiskAssessment();
    parseDomainResourceProperties(json, res);
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("condition"))
      res.setCondition(parseReference(json.getAsJsonObject("condition")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("performer"))
      res.setPerformer(parseReference(json.getAsJsonObject("performer")));
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(json.getAsJsonObject("method")));
    if (json.has("basis")) {
      JsonArray array = json.getAsJsonArray("basis");
      for (int i = 0; i < array.size(); i++) {
        res.getBasis().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("prediction")) {
      JsonArray array = json.getAsJsonArray("prediction");
      for (int i = 0; i < array.size(); i++) {
        res.getPrediction()
            .add(parseRiskAssessmentRiskAssessmentPredictionComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("mitigation"))
      res.setMitigationElement(parseString(json.get("mitigation").getAsString()));
    if (json.has("_mitigation"))
      parseElementProperties(json.getAsJsonObject("_mitigation"), res.getMitigationElement());
    return res;
  }

  protected RiskAssessment.RiskAssessmentPredictionComponent parseRiskAssessmentRiskAssessmentPredictionComponent(
      JsonObject json, RiskAssessment owner) throws IOException, FHIRFormatError {
    RiskAssessment.RiskAssessmentPredictionComponent res = new RiskAssessment.RiskAssessmentPredictionComponent();
    parseBackboneProperties(json, res);
    if (json.has("outcome"))
      res.setOutcome(parseCodeableConcept(json.getAsJsonObject("outcome")));
    Type probability = parseType("probability", json);
    if (probability != null)
      res.setProbability(probability);
    if (json.has("relativeRisk"))
      res.setRelativeRiskElement(parseDecimal(json.get("relativeRisk").getAsBigDecimal()));
    if (json.has("_relativeRisk"))
      parseElementProperties(json.getAsJsonObject("_relativeRisk"), res.getRelativeRiskElement());
    Type when = parseType("when", json);
    if (when != null)
      res.setWhen(when);
    if (json.has("rationale"))
      res.setRationaleElement(parseString(json.get("rationale").getAsString()));
    if (json.has("_rationale"))
      parseElementProperties(json.getAsJsonObject("_rationale"), res.getRationaleElement());
    return res;
  }

  protected Schedule parseSchedule(JsonObject json) throws IOException, FHIRFormatError {
    Schedule res = new Schedule();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("serviceCategory"))
      res.setServiceCategory(parseCodeableConcept(json.getAsJsonObject("serviceCategory")));
    if (json.has("serviceType")) {
      JsonArray array = json.getAsJsonArray("serviceType");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("specialty")) {
      JsonArray array = json.getAsJsonArray("specialty");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialty().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
    if (json.has("planningHorizon"))
      res.setPlanningHorizon(parsePeriod(json.getAsJsonObject("planningHorizon")));
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    return res;
  }

  protected SearchParameter parseSearchParameter(JsonObject json) throws IOException, FHIRFormatError {
    SearchParameter res = new SearchParameter();
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(),
          Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseSearchParameterSearchParameterContactComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("requirements"))
      res.setRequirementsElement(parseString(json.get("requirements").getAsString()));
    if (json.has("_requirements"))
      parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("base"))
      res.setBaseElement(parseCode(json.get("base").getAsString()));
    if (json.has("_base"))
      parseElementProperties(json.getAsJsonObject("_base"), res.getBaseElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.SearchParamType.NULL,
          new Enumerations.SearchParamTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
    if (json.has("xpath"))
      res.setXpathElement(parseString(json.get("xpath").getAsString()));
    if (json.has("_xpath"))
      parseElementProperties(json.getAsJsonObject("_xpath"), res.getXpathElement());
    if (json.has("xpathUsage"))
      res.setXpathUsageElement(parseEnumeration(json.get("xpathUsage").getAsString(),
          SearchParameter.XPathUsageType.NULL, new SearchParameter.XPathUsageTypeEnumFactory()));
    if (json.has("_xpathUsage"))
      parseElementProperties(json.getAsJsonObject("_xpathUsage"), res.getXpathUsageElement());
    if (json.has("target")) {
      JsonArray array = json.getAsJsonArray("target");
      for (int i = 0; i < array.size(); i++) {
        res.getTarget().add(parseCode(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_target")) {
      JsonArray array = json.getAsJsonArray("_target");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getTarget().size())
          res.getTarget().add(parseCode(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getTarget().get(i));
      }
    }
    ;
    return res;
  }

  protected SearchParameter.SearchParameterContactComponent parseSearchParameterSearchParameterContactComponent(
      JsonObject json, SearchParameter owner) throws IOException, FHIRFormatError {
    SearchParameter.SearchParameterContactComponent res = new SearchParameter.SearchParameterContactComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected Sequence parseSequence(JsonObject json) throws IOException, FHIRFormatError {
    Sequence res = new Sequence();
    parseDomainResourceProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Sequence.SequenceType.NULL,
          new Sequence.SequenceTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("specimen"))
      res.setSpecimen(parseReference(json.getAsJsonObject("specimen")));
    if (json.has("device"))
      res.setDevice(parseReference(json.getAsJsonObject("device")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("species"))
      res.setSpecies(parseCodeableConcept(json.getAsJsonObject("species")));
    if (json.has("referenceSeq")) {
      JsonArray array = json.getAsJsonArray("referenceSeq");
      for (int i = 0; i < array.size(); i++) {
        res.getReferenceSeq().add(parseSequenceSequenceReferenceSeqComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("variation"))
      res.setVariation(parseSequenceSequenceVariationComponent(json.getAsJsonObject("variation"), res));
    if (json.has("quality")) {
      JsonArray array = json.getAsJsonArray("quality");
      for (int i = 0; i < array.size(); i++) {
        res.getQuality().add(parseSequenceSequenceQualityComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("allelicState"))
      res.setAllelicState(parseCodeableConcept(json.getAsJsonObject("allelicState")));
    if (json.has("allelicFrequency"))
      res.setAllelicFrequencyElement(parseDecimal(json.get("allelicFrequency").getAsBigDecimal()));
    if (json.has("_allelicFrequency"))
      parseElementProperties(json.getAsJsonObject("_allelicFrequency"), res.getAllelicFrequencyElement());
    if (json.has("copyNumberEvent"))
      res.setCopyNumberEvent(parseCodeableConcept(json.getAsJsonObject("copyNumberEvent")));
    if (json.has("readCoverage"))
      res.setReadCoverageElement(parseInteger(json.get("readCoverage").getAsLong()));
    if (json.has("_readCoverage"))
      parseElementProperties(json.getAsJsonObject("_readCoverage"), res.getReadCoverageElement());
    if (json.has("repository")) {
      JsonArray array = json.getAsJsonArray("repository");
      for (int i = 0; i < array.size(); i++) {
        res.getRepository().add(parseSequenceSequenceRepositoryComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("pointer")) {
      JsonArray array = json.getAsJsonArray("pointer");
      for (int i = 0; i < array.size(); i++) {
        res.getPointer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("observedSeq"))
      res.setObservedSeqElement(parseString(json.get("observedSeq").getAsString()));
    if (json.has("_observedSeq"))
      parseElementProperties(json.getAsJsonObject("_observedSeq"), res.getObservedSeqElement());
    if (json.has("observation"))
      res.setObservation(parseReference(json.getAsJsonObject("observation")));
    if (json.has("structureVariation"))
      res.setStructureVariation(
          parseSequenceSequenceStructureVariationComponent(json.getAsJsonObject("structureVariation"), res));
    return res;
  }

  protected Sequence.SequenceReferenceSeqComponent parseSequenceSequenceReferenceSeqComponent(JsonObject json,
      Sequence owner) throws IOException, FHIRFormatError {
    Sequence.SequenceReferenceSeqComponent res = new Sequence.SequenceReferenceSeqComponent();
    parseBackboneProperties(json, res);
    if (json.has("chromosome"))
      res.setChromosome(parseCodeableConcept(json.getAsJsonObject("chromosome")));
    if (json.has("genomeBuild"))
      res.setGenomeBuildElement(parseString(json.get("genomeBuild").getAsString()));
    if (json.has("_genomeBuild"))
      parseElementProperties(json.getAsJsonObject("_genomeBuild"), res.getGenomeBuildElement());
    if (json.has("referenceSeqId"))
      res.setReferenceSeqId(parseCodeableConcept(json.getAsJsonObject("referenceSeqId")));
    if (json.has("referenceSeqPointer"))
      res.setReferenceSeqPointer(parseReference(json.getAsJsonObject("referenceSeqPointer")));
    if (json.has("referenceSeqString"))
      res.setReferenceSeqStringElement(parseString(json.get("referenceSeqString").getAsString()));
    if (json.has("_referenceSeqString"))
      parseElementProperties(json.getAsJsonObject("_referenceSeqString"), res.getReferenceSeqStringElement());
    if (json.has("windowStart"))
      res.setWindowStartElement(parseInteger(json.get("windowStart").getAsLong()));
    if (json.has("_windowStart"))
      parseElementProperties(json.getAsJsonObject("_windowStart"), res.getWindowStartElement());
    if (json.has("windowEnd"))
      res.setWindowEndElement(parseInteger(json.get("windowEnd").getAsLong()));
    if (json.has("_windowEnd"))
      parseElementProperties(json.getAsJsonObject("_windowEnd"), res.getWindowEndElement());
    return res;
  }

  protected Sequence.SequenceVariationComponent parseSequenceSequenceVariationComponent(JsonObject json, Sequence owner)
      throws IOException, FHIRFormatError {
    Sequence.SequenceVariationComponent res = new Sequence.SequenceVariationComponent();
    parseBackboneProperties(json, res);
    if (json.has("start"))
      res.setStartElement(parseInteger(json.get("start").getAsLong()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInteger(json.get("end").getAsLong()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
    if (json.has("observedAllele"))
      res.setObservedAlleleElement(parseString(json.get("observedAllele").getAsString()));
    if (json.has("_observedAllele"))
      parseElementProperties(json.getAsJsonObject("_observedAllele"), res.getObservedAlleleElement());
    if (json.has("referenceAllele"))
      res.setReferenceAlleleElement(parseString(json.get("referenceAllele").getAsString()));
    if (json.has("_referenceAllele"))
      parseElementProperties(json.getAsJsonObject("_referenceAllele"), res.getReferenceAlleleElement());
    if (json.has("cigar"))
      res.setCigarElement(parseString(json.get("cigar").getAsString()));
    if (json.has("_cigar"))
      parseElementProperties(json.getAsJsonObject("_cigar"), res.getCigarElement());
    return res;
  }

  protected Sequence.SequenceQualityComponent parseSequenceSequenceQualityComponent(JsonObject json, Sequence owner)
      throws IOException, FHIRFormatError {
    Sequence.SequenceQualityComponent res = new Sequence.SequenceQualityComponent();
    parseBackboneProperties(json, res);
    if (json.has("start"))
      res.setStartElement(parseInteger(json.get("start").getAsLong()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInteger(json.get("end").getAsLong()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
    if (json.has("score"))
      res.setScore(parseQuantity(json.getAsJsonObject("score")));
    if (json.has("method"))
      res.setMethodElement(parseString(json.get("method").getAsString()));
    if (json.has("_method"))
      parseElementProperties(json.getAsJsonObject("_method"), res.getMethodElement());
    return res;
  }

  protected Sequence.SequenceRepositoryComponent parseSequenceSequenceRepositoryComponent(JsonObject json,
      Sequence owner) throws IOException, FHIRFormatError {
    Sequence.SequenceRepositoryComponent res = new Sequence.SequenceRepositoryComponent();
    parseBackboneProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("variantId"))
      res.setVariantIdElement(parseString(json.get("variantId").getAsString()));
    if (json.has("_variantId"))
      parseElementProperties(json.getAsJsonObject("_variantId"), res.getVariantIdElement());
    if (json.has("readId"))
      res.setReadIdElement(parseString(json.get("readId").getAsString()));
    if (json.has("_readId"))
      parseElementProperties(json.getAsJsonObject("_readId"), res.getReadIdElement());
    return res;
  }

  protected Sequence.SequenceStructureVariationComponent parseSequenceSequenceStructureVariationComponent(
      JsonObject json, Sequence owner) throws IOException, FHIRFormatError {
    Sequence.SequenceStructureVariationComponent res = new Sequence.SequenceStructureVariationComponent();
    parseBackboneProperties(json, res);
    if (json.has("precisionOfBoundaries"))
      res.setPrecisionOfBoundariesElement(parseString(json.get("precisionOfBoundaries").getAsString()));
    if (json.has("_precisionOfBoundaries"))
      parseElementProperties(json.getAsJsonObject("_precisionOfBoundaries"), res.getPrecisionOfBoundariesElement());
    if (json.has("reportedaCGHRatio"))
      res.setReportedaCGHRatioElement(parseDecimal(json.get("reportedaCGHRatio").getAsBigDecimal()));
    if (json.has("_reportedaCGHRatio"))
      parseElementProperties(json.getAsJsonObject("_reportedaCGHRatio"), res.getReportedaCGHRatioElement());
    if (json.has("length"))
      res.setLengthElement(parseInteger(json.get("length").getAsLong()));
    if (json.has("_length"))
      parseElementProperties(json.getAsJsonObject("_length"), res.getLengthElement());
    if (json.has("outer"))
      res.setOuter(parseSequenceSequenceStructureVariationOuterComponent(json.getAsJsonObject("outer"), owner));
    if (json.has("inner"))
      res.setInner(parseSequenceSequenceStructureVariationInnerComponent(json.getAsJsonObject("inner"), owner));
    return res;
  }

  protected Sequence.SequenceStructureVariationOuterComponent parseSequenceSequenceStructureVariationOuterComponent(
      JsonObject json, Sequence owner) throws IOException, FHIRFormatError {
    Sequence.SequenceStructureVariationOuterComponent res = new Sequence.SequenceStructureVariationOuterComponent();
    parseBackboneProperties(json, res);
    if (json.has("start"))
      res.setStartElement(parseInteger(json.get("start").getAsLong()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInteger(json.get("end").getAsLong()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
    return res;
  }

  protected Sequence.SequenceStructureVariationInnerComponent parseSequenceSequenceStructureVariationInnerComponent(
      JsonObject json, Sequence owner) throws IOException, FHIRFormatError {
    Sequence.SequenceStructureVariationInnerComponent res = new Sequence.SequenceStructureVariationInnerComponent();
    parseBackboneProperties(json, res);
    if (json.has("start"))
      res.setStartElement(parseInteger(json.get("start").getAsLong()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInteger(json.get("end").getAsLong()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
    return res;
  }

  protected Slot parseSlot(JsonObject json) throws IOException, FHIRFormatError {
    Slot res = new Slot();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("serviceCategory"))
      res.setServiceCategory(parseCodeableConcept(json.getAsJsonObject("serviceCategory")));
    if (json.has("serviceType")) {
      JsonArray array = json.getAsJsonArray("serviceType");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("specialty")) {
      JsonArray array = json.getAsJsonArray("specialty");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialty().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("appointmentType"))
      res.setAppointmentType(parseCodeableConcept(json.getAsJsonObject("appointmentType")));
    if (json.has("schedule"))
      res.setSchedule(parseReference(json.getAsJsonObject("schedule")));
    if (json.has("status"))
      res.setStatusElement(
          parseEnumeration(json.get("status").getAsString(), Slot.SlotStatus.NULL, new Slot.SlotStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("start"))
      res.setStartElement(parseInstant(json.get("start").getAsString()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInstant(json.get("end").getAsString()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
    if (json.has("overbooked"))
      res.setOverbookedElement(parseBoolean(json.get("overbooked").getAsBoolean()));
    if (json.has("_overbooked"))
      parseElementProperties(json.getAsJsonObject("_overbooked"), res.getOverbookedElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    return res;
  }

  protected Specimen parseSpecimen(JsonObject json) throws IOException, FHIRFormatError {
    Specimen res = new Specimen();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("accessionIdentifier"))
      res.setAccessionIdentifier(parseIdentifier(json.getAsJsonObject("accessionIdentifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Specimen.SpecimenStatus.NULL,
          new Specimen.SpecimenStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("receivedTime"))
      res.setReceivedTimeElement(parseDateTime(json.get("receivedTime").getAsString()));
    if (json.has("_receivedTime"))
      parseElementProperties(json.getAsJsonObject("_receivedTime"), res.getReceivedTimeElement());
    if (json.has("parent")) {
      JsonArray array = json.getAsJsonArray("parent");
      for (int i = 0; i < array.size(); i++) {
        res.getParent().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("collection"))
      res.setCollection(parseSpecimenSpecimenCollectionComponent(json.getAsJsonObject("collection"), res));
    if (json.has("treatment")) {
      JsonArray array = json.getAsJsonArray("treatment");
      for (int i = 0; i < array.size(); i++) {
        res.getTreatment().add(parseSpecimenSpecimenTreatmentComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("container")) {
      JsonArray array = json.getAsJsonArray("container");
      for (int i = 0; i < array.size(); i++) {
        res.getContainer().add(parseSpecimenSpecimenContainerComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected Specimen.SpecimenCollectionComponent parseSpecimenSpecimenCollectionComponent(JsonObject json,
      Specimen owner) throws IOException, FHIRFormatError {
    Specimen.SpecimenCollectionComponent res = new Specimen.SpecimenCollectionComponent();
    parseBackboneProperties(json, res);
    if (json.has("collector"))
      res.setCollector(parseReference(json.getAsJsonObject("collector")));
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    Type collected = parseType("collected", json);
    if (collected != null)
      res.setCollected(collected);
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(json.getAsJsonObject("method")));
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(json.getAsJsonObject("bodySite")));
    return res;
  }

  protected Specimen.SpecimenTreatmentComponent parseSpecimenSpecimenTreatmentComponent(JsonObject json, Specimen owner)
      throws IOException, FHIRFormatError {
    Specimen.SpecimenTreatmentComponent res = new Specimen.SpecimenTreatmentComponent();
    parseBackboneProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("procedure"))
      res.setProcedure(parseCodeableConcept(json.getAsJsonObject("procedure")));
    if (json.has("additive")) {
      JsonArray array = json.getAsJsonArray("additive");
      for (int i = 0; i < array.size(); i++) {
        res.getAdditive().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected Specimen.SpecimenContainerComponent parseSpecimenSpecimenContainerComponent(JsonObject json, Specimen owner)
      throws IOException, FHIRFormatError {
    Specimen.SpecimenContainerComponent res = new Specimen.SpecimenContainerComponent();
    parseBackboneProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("capacity"))
      res.setCapacity(parseSimpleQuantity(json.getAsJsonObject("capacity")));
    if (json.has("specimenQuantity"))
      res.setSpecimenQuantity(parseSimpleQuantity(json.getAsJsonObject("specimenQuantity")));
    Type additive = parseType("additive", json);
    if (additive != null)
      res.setAdditive(additive);
    return res;
  }

  protected StructureDefinition parseStructureDefinition(JsonObject json) throws IOException, FHIRFormatError {
    StructureDefinition res = new StructureDefinition();
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(),
          Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact()
            .add(parseStructureDefinitionStructureDefinitionContactComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("requirements"))
      res.setRequirementsElement(parseString(json.get("requirements").getAsString()));
    if (json.has("_requirements"))
      parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseString(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("fhirVersion"))
      res.setFhirVersionElement(parseId(json.get("fhirVersion").getAsString()));
    if (json.has("_fhirVersion"))
      parseElementProperties(json.getAsJsonObject("_fhirVersion"), res.getFhirVersionElement());
    if (json.has("mapping")) {
      JsonArray array = json.getAsJsonArray("mapping");
      for (int i = 0; i < array.size(); i++) {
        res.getMapping()
            .add(parseStructureDefinitionStructureDefinitionMappingComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("kind"))
      res.setKindElement(
          parseEnumeration(json.get("kind").getAsString(), StructureDefinition.StructureDefinitionKind.NULL,
              new StructureDefinition.StructureDefinitionKindEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
    if (json.has("abstract"))
      res.setAbstractElement(parseBoolean(json.get("abstract").getAsBoolean()));
    if (json.has("_abstract"))
      parseElementProperties(json.getAsJsonObject("_abstract"), res.getAbstractElement());
    if (json.has("contextType"))
      res.setContextTypeElement(parseEnumeration(json.get("contextType").getAsString(),
          StructureDefinition.ExtensionContext.NULL, new StructureDefinition.ExtensionContextEnumFactory()));
    if (json.has("_contextType"))
      parseElementProperties(json.getAsJsonObject("_contextType"), res.getContextTypeElement());
    if (json.has("context")) {
      JsonArray array = json.getAsJsonArray("context");
      for (int i = 0; i < array.size(); i++) {
        res.getContext().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_context")) {
      JsonArray array = json.getAsJsonArray("_context");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getContext().size())
          res.getContext().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getContext().get(i));
      }
    }
    ;
    if (json.has("baseType"))
      res.setBaseTypeElement(parseCode(json.get("baseType").getAsString()));
    if (json.has("_baseType"))
      parseElementProperties(json.getAsJsonObject("_baseType"), res.getBaseTypeElement());
    if (json.has("baseDefinition"))
      res.setBaseDefinitionElement(parseUri(json.get("baseDefinition").getAsString()));
    if (json.has("_baseDefinition"))
      parseElementProperties(json.getAsJsonObject("_baseDefinition"), res.getBaseDefinitionElement());
    if (json.has("derivation"))
      res.setDerivationElement(parseEnumeration(json.get("derivation").getAsString(),
          StructureDefinition.TypeDerivationRule.NULL, new StructureDefinition.TypeDerivationRuleEnumFactory()));
    if (json.has("_derivation"))
      parseElementProperties(json.getAsJsonObject("_derivation"), res.getDerivationElement());
    if (json.has("snapshot"))
      res.setSnapshot(
          parseStructureDefinitionStructureDefinitionSnapshotComponent(json.getAsJsonObject("snapshot"), res));
    if (json.has("differential"))
      res.setDifferential(
          parseStructureDefinitionStructureDefinitionDifferentialComponent(json.getAsJsonObject("differential"), res));
    return res;
  }

  protected StructureDefinition.StructureDefinitionContactComponent parseStructureDefinitionStructureDefinitionContactComponent(
      JsonObject json, StructureDefinition owner) throws IOException, FHIRFormatError {
    StructureDefinition.StructureDefinitionContactComponent res = new StructureDefinition.StructureDefinitionContactComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected StructureDefinition.StructureDefinitionMappingComponent parseStructureDefinitionStructureDefinitionMappingComponent(
      JsonObject json, StructureDefinition owner) throws IOException, FHIRFormatError {
    StructureDefinition.StructureDefinitionMappingComponent res = new StructureDefinition.StructureDefinitionMappingComponent();
    parseBackboneProperties(json, res);
    if (json.has("identity"))
      res.setIdentityElement(parseId(json.get("identity").getAsString()));
    if (json.has("_identity"))
      parseElementProperties(json.getAsJsonObject("_identity"), res.getIdentityElement());
    if (json.has("uri"))
      res.setUriElement(parseUri(json.get("uri").getAsString()));
    if (json.has("_uri"))
      parseElementProperties(json.getAsJsonObject("_uri"), res.getUriElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("comments"))
      res.setCommentsElement(parseString(json.get("comments").getAsString()));
    if (json.has("_comments"))
      parseElementProperties(json.getAsJsonObject("_comments"), res.getCommentsElement());
    return res;
  }

  protected StructureDefinition.StructureDefinitionSnapshotComponent parseStructureDefinitionStructureDefinitionSnapshotComponent(
      JsonObject json, StructureDefinition owner) throws IOException, FHIRFormatError {
    StructureDefinition.StructureDefinitionSnapshotComponent res = new StructureDefinition.StructureDefinitionSnapshotComponent();
    parseBackboneProperties(json, res);
    if (json.has("element")) {
      JsonArray array = json.getAsJsonArray("element");
      for (int i = 0; i < array.size(); i++) {
        res.getElement().add(parseElementDefinition(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected StructureDefinition.StructureDefinitionDifferentialComponent parseStructureDefinitionStructureDefinitionDifferentialComponent(
      JsonObject json, StructureDefinition owner) throws IOException, FHIRFormatError {
    StructureDefinition.StructureDefinitionDifferentialComponent res = new StructureDefinition.StructureDefinitionDifferentialComponent();
    parseBackboneProperties(json, res);
    if (json.has("element")) {
      JsonArray array = json.getAsJsonArray("element");
      for (int i = 0; i < array.size(); i++) {
        res.getElement().add(parseElementDefinition(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected StructureMap parseStructureMap(JsonObject json) throws IOException, FHIRFormatError {
    StructureMap res = new StructureMap();
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(),
          Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseStructureMapStructureMapContactComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("requirements"))
      res.setRequirementsElement(parseString(json.get("requirements").getAsString()));
    if (json.has("_requirements"))
      parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseString(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("structure")) {
      JsonArray array = json.getAsJsonArray("structure");
      for (int i = 0; i < array.size(); i++) {
        res.getStructure().add(parseStructureMapStructureMapStructureComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("import")) {
      JsonArray array = json.getAsJsonArray("import");
      for (int i = 0; i < array.size(); i++) {
        res.getImport().add(parseUri(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_import")) {
      JsonArray array = json.getAsJsonArray("_import");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getImport().size())
          res.getImport().add(parseUri(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getImport().get(i));
      }
    }
    ;
    if (json.has("group")) {
      JsonArray array = json.getAsJsonArray("group");
      for (int i = 0; i < array.size(); i++) {
        res.getGroup().add(parseStructureMapStructureMapGroupComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected StructureMap.StructureMapContactComponent parseStructureMapStructureMapContactComponent(JsonObject json,
      StructureMap owner) throws IOException, FHIRFormatError {
    StructureMap.StructureMapContactComponent res = new StructureMap.StructureMapContactComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected StructureMap.StructureMapStructureComponent parseStructureMapStructureMapStructureComponent(JsonObject json,
      StructureMap owner) throws IOException, FHIRFormatError {
    StructureMap.StructureMapStructureComponent res = new StructureMap.StructureMapStructureComponent();
    parseBackboneProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), StructureMap.StructureMapModelMode.NULL,
          new StructureMap.StructureMapModelModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    return res;
  }

  protected StructureMap.StructureMapGroupComponent parseStructureMapStructureMapGroupComponent(JsonObject json,
      StructureMap owner) throws IOException, FHIRFormatError {
    StructureMap.StructureMapGroupComponent res = new StructureMap.StructureMapGroupComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseId(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("extends"))
      res.setExtendsElement(parseId(json.get("extends").getAsString()));
    if (json.has("_extends"))
      parseElementProperties(json.getAsJsonObject("_extends"), res.getExtendsElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("input")) {
      JsonArray array = json.getAsJsonArray("input");
      for (int i = 0; i < array.size(); i++) {
        res.getInput().add(parseStructureMapStructureMapGroupInputComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("rule")) {
      JsonArray array = json.getAsJsonArray("rule");
      for (int i = 0; i < array.size(); i++) {
        res.getRule().add(parseStructureMapStructureMapGroupRuleComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected StructureMap.StructureMapGroupInputComponent parseStructureMapStructureMapGroupInputComponent(
      JsonObject json, StructureMap owner) throws IOException, FHIRFormatError {
    StructureMap.StructureMapGroupInputComponent res = new StructureMap.StructureMapGroupInputComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseId(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("type"))
      res.setTypeElement(parseString(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), StructureMap.StructureMapInputMode.NULL,
          new StructureMap.StructureMapInputModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    return res;
  }

  protected StructureMap.StructureMapGroupRuleComponent parseStructureMapStructureMapGroupRuleComponent(JsonObject json,
      StructureMap owner) throws IOException, FHIRFormatError {
    StructureMap.StructureMapGroupRuleComponent res = new StructureMap.StructureMapGroupRuleComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseId(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("source")) {
      JsonArray array = json.getAsJsonArray("source");
      for (int i = 0; i < array.size(); i++) {
        res.getSource()
            .add(parseStructureMapStructureMapGroupRuleSourceComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("target")) {
      JsonArray array = json.getAsJsonArray("target");
      for (int i = 0; i < array.size(); i++) {
        res.getTarget()
            .add(parseStructureMapStructureMapGroupRuleTargetComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("rule")) {
      JsonArray array = json.getAsJsonArray("rule");
      for (int i = 0; i < array.size(); i++) {
        res.getRule().add(parseStructureMapStructureMapGroupRuleComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("dependent")) {
      JsonArray array = json.getAsJsonArray("dependent");
      for (int i = 0; i < array.size(); i++) {
        res.getDependent()
            .add(parseStructureMapStructureMapGroupRuleDependentComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    return res;
  }

  protected StructureMap.StructureMapGroupRuleSourceComponent parseStructureMapStructureMapGroupRuleSourceComponent(
      JsonObject json, StructureMap owner) throws IOException, FHIRFormatError {
    StructureMap.StructureMapGroupRuleSourceComponent res = new StructureMap.StructureMapGroupRuleSourceComponent();
    parseBackboneProperties(json, res);
    if (json.has("required"))
      res.setRequiredElement(parseBoolean(json.get("required").getAsBoolean()));
    if (json.has("_required"))
      parseElementProperties(json.getAsJsonObject("_required"), res.getRequiredElement());
    if (json.has("context"))
      res.setContextElement(parseId(json.get("context").getAsString()));
    if (json.has("_context"))
      parseElementProperties(json.getAsJsonObject("_context"), res.getContextElement());
    if (json.has("contextType"))
      res.setContextTypeElement(parseEnumeration(json.get("contextType").getAsString(),
          StructureMap.StructureMapContextType.NULL, new StructureMap.StructureMapContextTypeEnumFactory()));
    if (json.has("_contextType"))
      parseElementProperties(json.getAsJsonObject("_contextType"), res.getContextTypeElement());
    if (json.has("element"))
      res.setElementElement(parseString(json.get("element").getAsString()));
    if (json.has("_element"))
      parseElementProperties(json.getAsJsonObject("_element"), res.getElementElement());
    if (json.has("listMode"))
      res.setListModeElement(parseEnumeration(json.get("listMode").getAsString(),
          StructureMap.StructureMapListMode.NULL, new StructureMap.StructureMapListModeEnumFactory()));
    if (json.has("_listMode"))
      parseElementProperties(json.getAsJsonObject("_listMode"), res.getListModeElement());
    if (json.has("variable"))
      res.setVariableElement(parseId(json.get("variable").getAsString()));
    if (json.has("_variable"))
      parseElementProperties(json.getAsJsonObject("_variable"), res.getVariableElement());
    if (json.has("condition"))
      res.setConditionElement(parseString(json.get("condition").getAsString()));
    if (json.has("_condition"))
      parseElementProperties(json.getAsJsonObject("_condition"), res.getConditionElement());
    if (json.has("check"))
      res.setCheckElement(parseString(json.get("check").getAsString()));
    if (json.has("_check"))
      parseElementProperties(json.getAsJsonObject("_check"), res.getCheckElement());
    return res;
  }

  protected StructureMap.StructureMapGroupRuleTargetComponent parseStructureMapStructureMapGroupRuleTargetComponent(
      JsonObject json, StructureMap owner) throws IOException, FHIRFormatError {
    StructureMap.StructureMapGroupRuleTargetComponent res = new StructureMap.StructureMapGroupRuleTargetComponent();
    parseBackboneProperties(json, res);
    if (json.has("context"))
      res.setContextElement(parseId(json.get("context").getAsString()));
    if (json.has("_context"))
      parseElementProperties(json.getAsJsonObject("_context"), res.getContextElement());
    if (json.has("contextType"))
      res.setContextTypeElement(parseEnumeration(json.get("contextType").getAsString(),
          StructureMap.StructureMapContextType.NULL, new StructureMap.StructureMapContextTypeEnumFactory()));
    if (json.has("_contextType"))
      parseElementProperties(json.getAsJsonObject("_contextType"), res.getContextTypeElement());
    if (json.has("element"))
      res.setElementElement(parseString(json.get("element").getAsString()));
    if (json.has("_element"))
      parseElementProperties(json.getAsJsonObject("_element"), res.getElementElement());
    if (json.has("variable"))
      res.setVariableElement(parseId(json.get("variable").getAsString()));
    if (json.has("_variable"))
      parseElementProperties(json.getAsJsonObject("_variable"), res.getVariableElement());
    if (json.has("listMode")) {
      JsonArray array = json.getAsJsonArray("listMode");
      for (int i = 0; i < array.size(); i++) {
        res.getListMode().add(parseEnumeration(array.get(i).getAsString(), StructureMap.StructureMapListMode.NULL,
            new StructureMap.StructureMapListModeEnumFactory()));
      }
    }
    ;
    if (json.has("_listMode")) {
      JsonArray array = json.getAsJsonArray("_listMode");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getListMode().size())
          res.getListMode().add(parseEnumeration(null, StructureMap.StructureMapListMode.NULL,
              new StructureMap.StructureMapListModeEnumFactory()));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getListMode().get(i));
      }
    }
    ;
    if (json.has("listRuleId"))
      res.setListRuleIdElement(parseId(json.get("listRuleId").getAsString()));
    if (json.has("_listRuleId"))
      parseElementProperties(json.getAsJsonObject("_listRuleId"), res.getListRuleIdElement());
    if (json.has("transform"))
      res.setTransformElement(parseEnumeration(json.get("transform").getAsString(),
          StructureMap.StructureMapTransform.NULL, new StructureMap.StructureMapTransformEnumFactory()));
    if (json.has("_transform"))
      parseElementProperties(json.getAsJsonObject("_transform"), res.getTransformElement());
    if (json.has("parameter")) {
      JsonArray array = json.getAsJsonArray("parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter()
            .add(parseStructureMapStructureMapGroupRuleTargetParameterComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected StructureMap.StructureMapGroupRuleTargetParameterComponent parseStructureMapStructureMapGroupRuleTargetParameterComponent(
      JsonObject json, StructureMap owner) throws IOException, FHIRFormatError {
    StructureMap.StructureMapGroupRuleTargetParameterComponent res = new StructureMap.StructureMapGroupRuleTargetParameterComponent();
    parseBackboneProperties(json, res);
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    return res;
  }

  protected StructureMap.StructureMapGroupRuleDependentComponent parseStructureMapStructureMapGroupRuleDependentComponent(
      JsonObject json, StructureMap owner) throws IOException, FHIRFormatError {
    StructureMap.StructureMapGroupRuleDependentComponent res = new StructureMap.StructureMapGroupRuleDependentComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseId(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("variable")) {
      JsonArray array = json.getAsJsonArray("variable");
      for (int i = 0; i < array.size(); i++) {
        res.getVariable().add(parseString(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_variable")) {
      JsonArray array = json.getAsJsonArray("_variable");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getVariable().size())
          res.getVariable().add(parseString(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getVariable().get(i));
      }
    }
    ;
    return res;
  }

  protected Subscription parseSubscription(JsonObject json) throws IOException, FHIRFormatError {
    Subscription res = new Subscription();
    parseDomainResourceProperties(json, res);
    if (json.has("criteria"))
      res.setCriteriaElement(parseString(json.get("criteria").getAsString()));
    if (json.has("_criteria"))
      parseElementProperties(json.getAsJsonObject("_criteria"), res.getCriteriaElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("reason"))
      res.setReasonElement(parseString(json.get("reason").getAsString()));
    if (json.has("_reason"))
      parseElementProperties(json.getAsJsonObject("_reason"), res.getReasonElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Subscription.SubscriptionStatus.NULL,
          new Subscription.SubscriptionStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("error"))
      res.setErrorElement(parseString(json.get("error").getAsString()));
    if (json.has("_error"))
      parseElementProperties(json.getAsJsonObject("_error"), res.getErrorElement());
    if (json.has("channel"))
      res.setChannel(parseSubscriptionSubscriptionChannelComponent(json.getAsJsonObject("channel"), res));
    if (json.has("end"))
      res.setEndElement(parseInstant(json.get("end").getAsString()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
    if (json.has("tag")) {
      JsonArray array = json.getAsJsonArray("tag");
      for (int i = 0; i < array.size(); i++) {
        res.getTag().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected Subscription.SubscriptionChannelComponent parseSubscriptionSubscriptionChannelComponent(JsonObject json,
      Subscription owner) throws IOException, FHIRFormatError {
    Subscription.SubscriptionChannelComponent res = new Subscription.SubscriptionChannelComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Subscription.SubscriptionChannelType.NULL,
          new Subscription.SubscriptionChannelTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("endpoint"))
      res.setEndpointElement(parseUri(json.get("endpoint").getAsString()));
    if (json.has("_endpoint"))
      parseElementProperties(json.getAsJsonObject("_endpoint"), res.getEndpointElement());
    if (json.has("payload"))
      res.setPayloadElement(parseString(json.get("payload").getAsString()));
    if (json.has("_payload"))
      parseElementProperties(json.getAsJsonObject("_payload"), res.getPayloadElement());
    if (json.has("header"))
      res.setHeaderElement(parseString(json.get("header").getAsString()));
    if (json.has("_header"))
      parseElementProperties(json.getAsJsonObject("_header"), res.getHeaderElement());
    return res;
  }

  protected Substance parseSubstance(JsonObject json) throws IOException, FHIRFormatError {
    Substance res = new Substance();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("instance")) {
      JsonArray array = json.getAsJsonArray("instance");
      for (int i = 0; i < array.size(); i++) {
        res.getInstance().add(parseSubstanceSubstanceInstanceComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("ingredient")) {
      JsonArray array = json.getAsJsonArray("ingredient");
      for (int i = 0; i < array.size(); i++) {
        res.getIngredient().add(parseSubstanceSubstanceIngredientComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected Substance.SubstanceInstanceComponent parseSubstanceSubstanceInstanceComponent(JsonObject json,
      Substance owner) throws IOException, FHIRFormatError {
    Substance.SubstanceInstanceComponent res = new Substance.SubstanceInstanceComponent();
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("expiry"))
      res.setExpiryElement(parseDateTime(json.get("expiry").getAsString()));
    if (json.has("_expiry"))
      parseElementProperties(json.getAsJsonObject("_expiry"), res.getExpiryElement());
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    return res;
  }

  protected Substance.SubstanceIngredientComponent parseSubstanceSubstanceIngredientComponent(JsonObject json,
      Substance owner) throws IOException, FHIRFormatError {
    Substance.SubstanceIngredientComponent res = new Substance.SubstanceIngredientComponent();
    parseBackboneProperties(json, res);
    if (json.has("quantity"))
      res.setQuantity(parseRatio(json.getAsJsonObject("quantity")));
    if (json.has("substance"))
      res.setSubstance(parseReference(json.getAsJsonObject("substance")));
    return res;
  }

  protected SupplyDelivery parseSupplyDelivery(JsonObject json) throws IOException, FHIRFormatError {
    SupplyDelivery res = new SupplyDelivery();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), SupplyDelivery.SupplyDeliveryStatus.NULL,
          new SupplyDelivery.SupplyDeliveryStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("quantity"))
      res.setQuantity(parseSimpleQuantity(json.getAsJsonObject("quantity")));
    if (json.has("suppliedItem"))
      res.setSuppliedItem(parseReference(json.getAsJsonObject("suppliedItem")));
    if (json.has("supplier"))
      res.setSupplier(parseReference(json.getAsJsonObject("supplier")));
    if (json.has("whenPrepared"))
      res.setWhenPrepared(parsePeriod(json.getAsJsonObject("whenPrepared")));
    if (json.has("time"))
      res.setTimeElement(parseDateTime(json.get("time").getAsString()));
    if (json.has("_time"))
      parseElementProperties(json.getAsJsonObject("_time"), res.getTimeElement());
    if (json.has("destination"))
      res.setDestination(parseReference(json.getAsJsonObject("destination")));
    if (json.has("receiver")) {
      JsonArray array = json.getAsJsonArray("receiver");
      for (int i = 0; i < array.size(); i++) {
        res.getReceiver().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected SupplyRequest parseSupplyRequest(JsonObject json) throws IOException, FHIRFormatError {
    SupplyRequest res = new SupplyRequest();
    parseDomainResourceProperties(json, res);
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("source"))
      res.setSource(parseReference(json.getAsJsonObject("source")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), SupplyRequest.SupplyRequestStatus.NULL,
          new SupplyRequest.SupplyRequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("kind"))
      res.setKind(parseCodeableConcept(json.getAsJsonObject("kind")));
    if (json.has("orderedItem"))
      res.setOrderedItem(parseReference(json.getAsJsonObject("orderedItem")));
    if (json.has("supplier")) {
      JsonArray array = json.getAsJsonArray("supplier");
      for (int i = 0; i < array.size(); i++) {
        res.getSupplier().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    Type reason = parseType("reason", json);
    if (reason != null)
      res.setReason(reason);
    if (json.has("when"))
      res.setWhen(parseSupplyRequestSupplyRequestWhenComponent(json.getAsJsonObject("when"), res));
    return res;
  }

  protected SupplyRequest.SupplyRequestWhenComponent parseSupplyRequestSupplyRequestWhenComponent(JsonObject json,
      SupplyRequest owner) throws IOException, FHIRFormatError {
    SupplyRequest.SupplyRequestWhenComponent res = new SupplyRequest.SupplyRequestWhenComponent();
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("schedule"))
      res.setSchedule(parseTiming(json.getAsJsonObject("schedule")));
    return res;
  }

  protected Task parseTask(JsonObject json) throws IOException, FHIRFormatError {
    Task res = new Task();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("performerType")) {
      JsonArray array = json.getAsJsonArray("performerType");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformerType().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), Task.TaskPriority.NULL,
          new Task.TaskPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    if (json.has("status"))
      res.setStatusElement(
          parseEnumeration(json.get("status").getAsString(), Task.TaskStatus.NULL, new Task.TaskStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("failureReason"))
      res.setFailureReason(parseCodeableConcept(json.getAsJsonObject("failureReason")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("for"))
      res.setFor(parseReference(json.getAsJsonObject("for")));
    if (json.has("definition"))
      res.setDefinitionElement(parseUri(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("lastModified"))
      res.setLastModifiedElement(parseDateTime(json.get("lastModified").getAsString()));
    if (json.has("_lastModified"))
      parseElementProperties(json.getAsJsonObject("_lastModified"), res.getLastModifiedElement());
    if (json.has("creator"))
      res.setCreator(parseReference(json.getAsJsonObject("creator")));
    if (json.has("owner"))
      res.setOwner(parseReference(json.getAsJsonObject("owner")));
    if (json.has("parent"))
      res.setParent(parseReference(json.getAsJsonObject("parent")));
    if (json.has("input")) {
      JsonArray array = json.getAsJsonArray("input");
      for (int i = 0; i < array.size(); i++) {
        res.getInput().add(parseTaskParameterComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("output")) {
      JsonArray array = json.getAsJsonArray("output");
      for (int i = 0; i < array.size(); i++) {
        res.getOutput().add(parseTaskTaskOutputComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected Task.ParameterComponent parseTaskParameterComponent(JsonObject json, Task owner)
      throws IOException, FHIRFormatError {
    Task.ParameterComponent res = new Task.ParameterComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    return res;
  }

  protected Task.TaskOutputComponent parseTaskTaskOutputComponent(JsonObject json, Task owner)
      throws IOException, FHIRFormatError {
    Task.TaskOutputComponent res = new Task.TaskOutputComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    return res;
  }

  protected TestScript parseTestScript(JsonObject json) throws IOException, FHIRFormatError {
    TestScript res = new TestScript();
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(),
          Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseTestScriptTestScriptContactComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("requirements"))
      res.setRequirementsElement(parseString(json.get("requirements").getAsString()));
    if (json.has("_requirements"))
      parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseString(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("origin")) {
      JsonArray array = json.getAsJsonArray("origin");
      for (int i = 0; i < array.size(); i++) {
        res.getOrigin().add(parseTestScriptTestScriptOriginComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("destination")) {
      JsonArray array = json.getAsJsonArray("destination");
      for (int i = 0; i < array.size(); i++) {
        res.getDestination().add(parseTestScriptTestScriptDestinationComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("metadata"))
      res.setMetadata(parseTestScriptTestScriptMetadataComponent(json.getAsJsonObject("metadata"), res));
    if (json.has("fixture")) {
      JsonArray array = json.getAsJsonArray("fixture");
      for (int i = 0; i < array.size(); i++) {
        res.getFixture().add(parseTestScriptTestScriptFixtureComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("profile")) {
      JsonArray array = json.getAsJsonArray("profile");
      for (int i = 0; i < array.size(); i++) {
        res.getProfile().add(parseReference(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("variable")) {
      JsonArray array = json.getAsJsonArray("variable");
      for (int i = 0; i < array.size(); i++) {
        res.getVariable().add(parseTestScriptTestScriptVariableComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("rule")) {
      JsonArray array = json.getAsJsonArray("rule");
      for (int i = 0; i < array.size(); i++) {
        res.getRule().add(parseTestScriptTestScriptRuleComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("ruleset")) {
      JsonArray array = json.getAsJsonArray("ruleset");
      for (int i = 0; i < array.size(); i++) {
        res.getRuleset().add(parseTestScriptTestScriptRulesetComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("setup"))
      res.setSetup(parseTestScriptTestScriptSetupComponent(json.getAsJsonObject("setup"), res));
    if (json.has("test")) {
      JsonArray array = json.getAsJsonArray("test");
      for (int i = 0; i < array.size(); i++) {
        res.getTest().add(parseTestScriptTestScriptTestComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("teardown"))
      res.setTeardown(parseTestScriptTestScriptTeardownComponent(json.getAsJsonObject("teardown"), res));
    return res;
  }

  protected TestScript.TestScriptContactComponent parseTestScriptTestScriptContactComponent(JsonObject json,
      TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptContactComponent res = new TestScript.TestScriptContactComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected TestScript.TestScriptOriginComponent parseTestScriptTestScriptOriginComponent(JsonObject json,
      TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptOriginComponent res = new TestScript.TestScriptOriginComponent();
    parseBackboneProperties(json, res);
    if (json.has("index"))
      res.setIndexElement(parseInteger(json.get("index").getAsLong()));
    if (json.has("_index"))
      parseElementProperties(json.getAsJsonObject("_index"), res.getIndexElement());
    if (json.has("profile"))
      res.setProfile(parseCoding(json.getAsJsonObject("profile")));
    return res;
  }

  protected TestScript.TestScriptDestinationComponent parseTestScriptTestScriptDestinationComponent(JsonObject json,
      TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptDestinationComponent res = new TestScript.TestScriptDestinationComponent();
    parseBackboneProperties(json, res);
    if (json.has("index"))
      res.setIndexElement(parseInteger(json.get("index").getAsLong()));
    if (json.has("_index"))
      parseElementProperties(json.getAsJsonObject("_index"), res.getIndexElement());
    if (json.has("profile"))
      res.setProfile(parseCoding(json.getAsJsonObject("profile")));
    return res;
  }

  protected TestScript.TestScriptMetadataComponent parseTestScriptTestScriptMetadataComponent(JsonObject json,
      TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptMetadataComponent res = new TestScript.TestScriptMetadataComponent();
    parseBackboneProperties(json, res);
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseTestScriptTestScriptMetadataLinkComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("capability")) {
      JsonArray array = json.getAsJsonArray("capability");
      for (int i = 0; i < array.size(); i++) {
        res.getCapability()
            .add(parseTestScriptTestScriptMetadataCapabilityComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected TestScript.TestScriptMetadataLinkComponent parseTestScriptTestScriptMetadataLinkComponent(JsonObject json,
      TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptMetadataLinkComponent res = new TestScript.TestScriptMetadataLinkComponent();
    parseBackboneProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    return res;
  }

  protected TestScript.TestScriptMetadataCapabilityComponent parseTestScriptTestScriptMetadataCapabilityComponent(
      JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptMetadataCapabilityComponent res = new TestScript.TestScriptMetadataCapabilityComponent();
    parseBackboneProperties(json, res);
    if (json.has("required"))
      res.setRequiredElement(parseBoolean(json.get("required").getAsBoolean()));
    if (json.has("_required"))
      parseElementProperties(json.getAsJsonObject("_required"), res.getRequiredElement());
    if (json.has("validated"))
      res.setValidatedElement(parseBoolean(json.get("validated").getAsBoolean()));
    if (json.has("_validated"))
      parseElementProperties(json.getAsJsonObject("_validated"), res.getValidatedElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("origin")) {
      JsonArray array = json.getAsJsonArray("origin");
      for (int i = 0; i < array.size(); i++) {
        res.getOrigin().add(parseInteger(array.get(i).getAsLong()));
      }
    }
    ;
    if (json.has("_origin")) {
      JsonArray array = json.getAsJsonArray("_origin");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getOrigin().size())
          res.getOrigin().add(parseInteger(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getOrigin().get(i));
      }
    }
    ;
    if (json.has("destination"))
      res.setDestinationElement(parseInteger(json.get("destination").getAsLong()));
    if (json.has("_destination"))
      parseElementProperties(json.getAsJsonObject("_destination"), res.getDestinationElement());
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseUri(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_link")) {
      JsonArray array = json.getAsJsonArray("_link");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLink().size())
          res.getLink().add(parseUri(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLink().get(i));
      }
    }
    ;
    if (json.has("conformance"))
      res.setConformance(parseReference(json.getAsJsonObject("conformance")));
    return res;
  }

  protected TestScript.TestScriptFixtureComponent parseTestScriptTestScriptFixtureComponent(JsonObject json,
      TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptFixtureComponent res = new TestScript.TestScriptFixtureComponent();
    parseBackboneProperties(json, res);
    if (json.has("autocreate"))
      res.setAutocreateElement(parseBoolean(json.get("autocreate").getAsBoolean()));
    if (json.has("_autocreate"))
      parseElementProperties(json.getAsJsonObject("_autocreate"), res.getAutocreateElement());
    if (json.has("autodelete"))
      res.setAutodeleteElement(parseBoolean(json.get("autodelete").getAsBoolean()));
    if (json.has("_autodelete"))
      parseElementProperties(json.getAsJsonObject("_autodelete"), res.getAutodeleteElement());
    if (json.has("resource"))
      res.setResource(parseReference(json.getAsJsonObject("resource")));
    return res;
  }

  protected TestScript.TestScriptVariableComponent parseTestScriptTestScriptVariableComponent(JsonObject json,
      TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptVariableComponent res = new TestScript.TestScriptVariableComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("defaultValue"))
      res.setDefaultValueElement(parseString(json.get("defaultValue").getAsString()));
    if (json.has("_defaultValue"))
      parseElementProperties(json.getAsJsonObject("_defaultValue"), res.getDefaultValueElement());
    if (json.has("headerField"))
      res.setHeaderFieldElement(parseString(json.get("headerField").getAsString()));
    if (json.has("_headerField"))
      parseElementProperties(json.getAsJsonObject("_headerField"), res.getHeaderFieldElement());
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("sourceId"))
      res.setSourceIdElement(parseId(json.get("sourceId").getAsString()));
    if (json.has("_sourceId"))
      parseElementProperties(json.getAsJsonObject("_sourceId"), res.getSourceIdElement());
    return res;
  }

  protected TestScript.TestScriptRuleComponent parseTestScriptTestScriptRuleComponent(JsonObject json, TestScript owner)
      throws IOException, FHIRFormatError {
    TestScript.TestScriptRuleComponent res = new TestScript.TestScriptRuleComponent();
    parseBackboneProperties(json, res);
    if (json.has("resource"))
      res.setResource(parseReference(json.getAsJsonObject("resource")));
    if (json.has("param")) {
      JsonArray array = json.getAsJsonArray("param");
      for (int i = 0; i < array.size(); i++) {
        res.getParam().add(parseTestScriptTestScriptRuleParamComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected TestScript.TestScriptRuleParamComponent parseTestScriptTestScriptRuleParamComponent(JsonObject json,
      TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptRuleParamComponent res = new TestScript.TestScriptRuleParamComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    return res;
  }

  protected TestScript.TestScriptRulesetComponent parseTestScriptTestScriptRulesetComponent(JsonObject json,
      TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptRulesetComponent res = new TestScript.TestScriptRulesetComponent();
    parseBackboneProperties(json, res);
    if (json.has("resource"))
      res.setResource(parseReference(json.getAsJsonObject("resource")));
    if (json.has("rule")) {
      JsonArray array = json.getAsJsonArray("rule");
      for (int i = 0; i < array.size(); i++) {
        res.getRule().add(parseTestScriptTestScriptRulesetRuleComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected TestScript.TestScriptRulesetRuleComponent parseTestScriptTestScriptRulesetRuleComponent(JsonObject json,
      TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptRulesetRuleComponent res = new TestScript.TestScriptRulesetRuleComponent();
    parseBackboneProperties(json, res);
    if (json.has("ruleId"))
      res.setRuleIdElement(parseId(json.get("ruleId").getAsString()));
    if (json.has("_ruleId"))
      parseElementProperties(json.getAsJsonObject("_ruleId"), res.getRuleIdElement());
    if (json.has("param")) {
      JsonArray array = json.getAsJsonArray("param");
      for (int i = 0; i < array.size(); i++) {
        res.getParam().add(parseTestScriptTestScriptRulesetRuleParamComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected TestScript.TestScriptRulesetRuleParamComponent parseTestScriptTestScriptRulesetRuleParamComponent(
      JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptRulesetRuleParamComponent res = new TestScript.TestScriptRulesetRuleParamComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    return res;
  }

  protected TestScript.TestScriptSetupComponent parseTestScriptTestScriptSetupComponent(JsonObject json,
      TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptSetupComponent res = new TestScript.TestScriptSetupComponent();
    parseBackboneProperties(json, res);
    if (json.has("metadata"))
      res.setMetadata(parseTestScriptTestScriptMetadataComponent(json.getAsJsonObject("metadata"), owner));
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseTestScriptSetupActionComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected TestScript.SetupActionComponent parseTestScriptSetupActionComponent(JsonObject json, TestScript owner)
      throws IOException, FHIRFormatError {
    TestScript.SetupActionComponent res = new TestScript.SetupActionComponent();
    parseBackboneProperties(json, res);
    if (json.has("operation"))
      res.setOperation(parseTestScriptSetupActionOperationComponent(json.getAsJsonObject("operation"), owner));
    if (json.has("assert"))
      res.setAssert(parseTestScriptSetupActionAssertComponent(json.getAsJsonObject("assert"), owner));
    return res;
  }

  protected TestScript.SetupActionOperationComponent parseTestScriptSetupActionOperationComponent(JsonObject json,
      TestScript owner) throws IOException, FHIRFormatError {
    TestScript.SetupActionOperationComponent res = new TestScript.SetupActionOperationComponent();
    parseBackboneProperties(json, res);
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("resource"))
      res.setResourceElement(parseCode(json.get("resource").getAsString()));
    if (json.has("_resource"))
      parseElementProperties(json.getAsJsonObject("_resource"), res.getResourceElement());
    if (json.has("label"))
      res.setLabelElement(parseString(json.get("label").getAsString()));
    if (json.has("_label"))
      parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("accept"))
      res.setAcceptElement(parseEnumeration(json.get("accept").getAsString(), TestScript.ContentType.NULL,
          new TestScript.ContentTypeEnumFactory()));
    if (json.has("_accept"))
      parseElementProperties(json.getAsJsonObject("_accept"), res.getAcceptElement());
    if (json.has("contentType"))
      res.setContentTypeElement(parseEnumeration(json.get("contentType").getAsString(), TestScript.ContentType.NULL,
          new TestScript.ContentTypeEnumFactory()));
    if (json.has("_contentType"))
      parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
    if (json.has("destination"))
      res.setDestinationElement(parseInteger(json.get("destination").getAsLong()));
    if (json.has("_destination"))
      parseElementProperties(json.getAsJsonObject("_destination"), res.getDestinationElement());
    if (json.has("encodeRequestUrl"))
      res.setEncodeRequestUrlElement(parseBoolean(json.get("encodeRequestUrl").getAsBoolean()));
    if (json.has("_encodeRequestUrl"))
      parseElementProperties(json.getAsJsonObject("_encodeRequestUrl"), res.getEncodeRequestUrlElement());
    if (json.has("origin"))
      res.setOriginElement(parseInteger(json.get("origin").getAsLong()));
    if (json.has("_origin"))
      parseElementProperties(json.getAsJsonObject("_origin"), res.getOriginElement());
    if (json.has("params"))
      res.setParamsElement(parseString(json.get("params").getAsString()));
    if (json.has("_params"))
      parseElementProperties(json.getAsJsonObject("_params"), res.getParamsElement());
    if (json.has("requestHeader")) {
      JsonArray array = json.getAsJsonArray("requestHeader");
      for (int i = 0; i < array.size(); i++) {
        res.getRequestHeader()
            .add(parseTestScriptSetupActionOperationRequestHeaderComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("responseId"))
      res.setResponseIdElement(parseId(json.get("responseId").getAsString()));
    if (json.has("_responseId"))
      parseElementProperties(json.getAsJsonObject("_responseId"), res.getResponseIdElement());
    if (json.has("sourceId"))
      res.setSourceIdElement(parseId(json.get("sourceId").getAsString()));
    if (json.has("_sourceId"))
      parseElementProperties(json.getAsJsonObject("_sourceId"), res.getSourceIdElement());
    if (json.has("targetId"))
      res.setTargetIdElement(parseId(json.get("targetId").getAsString()));
    if (json.has("_targetId"))
      parseElementProperties(json.getAsJsonObject("_targetId"), res.getTargetIdElement());
    if (json.has("url"))
      res.setUrlElement(parseString(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    return res;
  }

  protected TestScript.SetupActionOperationRequestHeaderComponent parseTestScriptSetupActionOperationRequestHeaderComponent(
      JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.SetupActionOperationRequestHeaderComponent res = new TestScript.SetupActionOperationRequestHeaderComponent();
    parseBackboneProperties(json, res);
    if (json.has("field"))
      res.setFieldElement(parseString(json.get("field").getAsString()));
    if (json.has("_field"))
      parseElementProperties(json.getAsJsonObject("_field"), res.getFieldElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    return res;
  }

  protected TestScript.SetupActionAssertComponent parseTestScriptSetupActionAssertComponent(JsonObject json,
      TestScript owner) throws IOException, FHIRFormatError {
    TestScript.SetupActionAssertComponent res = new TestScript.SetupActionAssertComponent();
    parseBackboneProperties(json, res);
    if (json.has("label"))
      res.setLabelElement(parseString(json.get("label").getAsString()));
    if (json.has("_label"))
      parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("direction"))
      res.setDirectionElement(parseEnumeration(json.get("direction").getAsString(),
          TestScript.AssertionDirectionType.NULL, new TestScript.AssertionDirectionTypeEnumFactory()));
    if (json.has("_direction"))
      parseElementProperties(json.getAsJsonObject("_direction"), res.getDirectionElement());
    if (json.has("compareToSourceId"))
      res.setCompareToSourceIdElement(parseString(json.get("compareToSourceId").getAsString()));
    if (json.has("_compareToSourceId"))
      parseElementProperties(json.getAsJsonObject("_compareToSourceId"), res.getCompareToSourceIdElement());
    if (json.has("compareToSourcePath"))
      res.setCompareToSourcePathElement(parseString(json.get("compareToSourcePath").getAsString()));
    if (json.has("_compareToSourcePath"))
      parseElementProperties(json.getAsJsonObject("_compareToSourcePath"), res.getCompareToSourcePathElement());
    if (json.has("contentType"))
      res.setContentTypeElement(parseEnumeration(json.get("contentType").getAsString(), TestScript.ContentType.NULL,
          new TestScript.ContentTypeEnumFactory()));
    if (json.has("_contentType"))
      parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
    if (json.has("headerField"))
      res.setHeaderFieldElement(parseString(json.get("headerField").getAsString()));
    if (json.has("_headerField"))
      parseElementProperties(json.getAsJsonObject("_headerField"), res.getHeaderFieldElement());
    if (json.has("minimumId"))
      res.setMinimumIdElement(parseString(json.get("minimumId").getAsString()));
    if (json.has("_minimumId"))
      parseElementProperties(json.getAsJsonObject("_minimumId"), res.getMinimumIdElement());
    if (json.has("navigationLinks"))
      res.setNavigationLinksElement(parseBoolean(json.get("navigationLinks").getAsBoolean()));
    if (json.has("_navigationLinks"))
      parseElementProperties(json.getAsJsonObject("_navigationLinks"), res.getNavigationLinksElement());
    if (json.has("operator"))
      res.setOperatorElement(parseEnumeration(json.get("operator").getAsString(), TestScript.AssertionOperatorType.NULL,
          new TestScript.AssertionOperatorTypeEnumFactory()));
    if (json.has("_operator"))
      parseElementProperties(json.getAsJsonObject("_operator"), res.getOperatorElement());
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("resource"))
      res.setResourceElement(parseCode(json.get("resource").getAsString()));
    if (json.has("_resource"))
      parseElementProperties(json.getAsJsonObject("_resource"), res.getResourceElement());
    if (json.has("response"))
      res.setResponseElement(parseEnumeration(json.get("response").getAsString(),
          TestScript.AssertionResponseTypes.NULL, new TestScript.AssertionResponseTypesEnumFactory()));
    if (json.has("_response"))
      parseElementProperties(json.getAsJsonObject("_response"), res.getResponseElement());
    if (json.has("responseCode"))
      res.setResponseCodeElement(parseString(json.get("responseCode").getAsString()));
    if (json.has("_responseCode"))
      parseElementProperties(json.getAsJsonObject("_responseCode"), res.getResponseCodeElement());
    if (json.has("rule"))
      res.setRule(parseTestScriptSetupActionAssertRuleComponent(json.getAsJsonObject("rule"), owner));
    if (json.has("ruleset"))
      res.setRuleset(parseTestScriptSetupActionAssertRulesetComponent(json.getAsJsonObject("ruleset"), owner));
    if (json.has("sourceId"))
      res.setSourceIdElement(parseId(json.get("sourceId").getAsString()));
    if (json.has("_sourceId"))
      parseElementProperties(json.getAsJsonObject("_sourceId"), res.getSourceIdElement());
    if (json.has("validateProfileId"))
      res.setValidateProfileIdElement(parseId(json.get("validateProfileId").getAsString()));
    if (json.has("_validateProfileId"))
      parseElementProperties(json.getAsJsonObject("_validateProfileId"), res.getValidateProfileIdElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("warningOnly"))
      res.setWarningOnlyElement(parseBoolean(json.get("warningOnly").getAsBoolean()));
    if (json.has("_warningOnly"))
      parseElementProperties(json.getAsJsonObject("_warningOnly"), res.getWarningOnlyElement());
    return res;
  }

  protected TestScript.SetupActionAssertRuleComponent parseTestScriptSetupActionAssertRuleComponent(JsonObject json,
      TestScript owner) throws IOException, FHIRFormatError {
    TestScript.SetupActionAssertRuleComponent res = new TestScript.SetupActionAssertRuleComponent();
    parseBackboneProperties(json, res);
    if (json.has("ruleId"))
      res.setRuleIdElement(parseId(json.get("ruleId").getAsString()));
    if (json.has("_ruleId"))
      parseElementProperties(json.getAsJsonObject("_ruleId"), res.getRuleIdElement());
    if (json.has("param")) {
      JsonArray array = json.getAsJsonArray("param");
      for (int i = 0; i < array.size(); i++) {
        res.getParam().add(parseTestScriptSetupActionAssertRuleParamComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected TestScript.SetupActionAssertRuleParamComponent parseTestScriptSetupActionAssertRuleParamComponent(
      JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.SetupActionAssertRuleParamComponent res = new TestScript.SetupActionAssertRuleParamComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    return res;
  }

  protected TestScript.SetupActionAssertRulesetComponent parseTestScriptSetupActionAssertRulesetComponent(
      JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.SetupActionAssertRulesetComponent res = new TestScript.SetupActionAssertRulesetComponent();
    parseBackboneProperties(json, res);
    if (json.has("rulesetId"))
      res.setRulesetIdElement(parseId(json.get("rulesetId").getAsString()));
    if (json.has("_rulesetId"))
      parseElementProperties(json.getAsJsonObject("_rulesetId"), res.getRulesetIdElement());
    if (json.has("rule")) {
      JsonArray array = json.getAsJsonArray("rule");
      for (int i = 0; i < array.size(); i++) {
        res.getRule().add(parseTestScriptSetupActionAssertRulesetRuleComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected TestScript.SetupActionAssertRulesetRuleComponent parseTestScriptSetupActionAssertRulesetRuleComponent(
      JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.SetupActionAssertRulesetRuleComponent res = new TestScript.SetupActionAssertRulesetRuleComponent();
    parseBackboneProperties(json, res);
    if (json.has("ruleId"))
      res.setRuleIdElement(parseId(json.get("ruleId").getAsString()));
    if (json.has("_ruleId"))
      parseElementProperties(json.getAsJsonObject("_ruleId"), res.getRuleIdElement());
    if (json.has("param")) {
      JsonArray array = json.getAsJsonArray("param");
      for (int i = 0; i < array.size(); i++) {
        res.getParam()
            .add(parseTestScriptSetupActionAssertRulesetRuleParamComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected TestScript.SetupActionAssertRulesetRuleParamComponent parseTestScriptSetupActionAssertRulesetRuleParamComponent(
      JsonObject json, TestScript owner) throws IOException, FHIRFormatError {
    TestScript.SetupActionAssertRulesetRuleParamComponent res = new TestScript.SetupActionAssertRulesetRuleParamComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    return res;
  }

  protected TestScript.TestScriptTestComponent parseTestScriptTestScriptTestComponent(JsonObject json, TestScript owner)
      throws IOException, FHIRFormatError {
    TestScript.TestScriptTestComponent res = new TestScript.TestScriptTestComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("metadata"))
      res.setMetadata(parseTestScriptTestScriptMetadataComponent(json.getAsJsonObject("metadata"), owner));
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseTestScriptTestActionComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected TestScript.TestActionComponent parseTestScriptTestActionComponent(JsonObject json, TestScript owner)
      throws IOException, FHIRFormatError {
    TestScript.TestActionComponent res = new TestScript.TestActionComponent();
    parseBackboneProperties(json, res);
    if (json.has("operation"))
      res.setOperation(parseTestScriptSetupActionOperationComponent(json.getAsJsonObject("operation"), owner));
    if (json.has("assert"))
      res.setAssert(parseTestScriptSetupActionAssertComponent(json.getAsJsonObject("assert"), owner));
    return res;
  }

  protected TestScript.TestScriptTeardownComponent parseTestScriptTestScriptTeardownComponent(JsonObject json,
      TestScript owner) throws IOException, FHIRFormatError {
    TestScript.TestScriptTeardownComponent res = new TestScript.TestScriptTeardownComponent();
    parseBackboneProperties(json, res);
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseTestScriptTeardownActionComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected TestScript.TeardownActionComponent parseTestScriptTeardownActionComponent(JsonObject json, TestScript owner)
      throws IOException, FHIRFormatError {
    TestScript.TeardownActionComponent res = new TestScript.TeardownActionComponent();
    parseBackboneProperties(json, res);
    if (json.has("operation"))
      res.setOperation(parseTestScriptSetupActionOperationComponent(json.getAsJsonObject("operation"), owner));
    return res;
  }

  protected ValueSet parseValueSet(JsonObject json) throws IOException, FHIRFormatError {
    ValueSet res = new ValueSet();
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(),
          Enumerations.ConformanceResourceStatus.NULL, new Enumerations.ConformanceResourceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseValueSetValueSetContactComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("lockedDate"))
      res.setLockedDateElement(parseDate(json.get("lockedDate").getAsString()));
    if (json.has("_lockedDate"))
      parseElementProperties(json.getAsJsonObject("_lockedDate"), res.getLockedDateElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("immutable"))
      res.setImmutableElement(parseBoolean(json.get("immutable").getAsBoolean()));
    if (json.has("_immutable"))
      parseElementProperties(json.getAsJsonObject("_immutable"), res.getImmutableElement());
    if (json.has("requirements"))
      res.setRequirementsElement(parseString(json.get("requirements").getAsString()));
    if (json.has("_requirements"))
      parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseString(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("extensible"))
      res.setExtensibleElement(parseBoolean(json.get("extensible").getAsBoolean()));
    if (json.has("_extensible"))
      parseElementProperties(json.getAsJsonObject("_extensible"), res.getExtensibleElement());
    if (json.has("compose"))
      res.setCompose(parseValueSetValueSetComposeComponent(json.getAsJsonObject("compose"), res));
    if (json.has("expansion"))
      res.setExpansion(parseValueSetValueSetExpansionComponent(json.getAsJsonObject("expansion"), res));
    return res;
  }

  protected ValueSet.ValueSetContactComponent parseValueSetValueSetContactComponent(JsonObject json, ValueSet owner)
      throws IOException, FHIRFormatError {
    ValueSet.ValueSetContactComponent res = new ValueSet.ValueSetContactComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    }
    ;
    return res;
  }

  protected ValueSet.ValueSetComposeComponent parseValueSetValueSetComposeComponent(JsonObject json, ValueSet owner)
      throws IOException, FHIRFormatError {
    ValueSet.ValueSetComposeComponent res = new ValueSet.ValueSetComposeComponent();
    parseBackboneProperties(json, res);
    if (json.has("import")) {
      JsonArray array = json.getAsJsonArray("import");
      for (int i = 0; i < array.size(); i++) {
        res.getImport().add(parseUri(array.get(i).getAsString()));
      }
    }
    ;
    if (json.has("_import")) {
      JsonArray array = json.getAsJsonArray("_import");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getImport().size())
          res.getImport().add(parseUri(null));
        if (array.get(i) instanceof JsonObject)
          parseElementProperties(array.get(i).getAsJsonObject(), res.getImport().get(i));
      }
    }
    ;
    if (json.has("include")) {
      JsonArray array = json.getAsJsonArray("include");
      for (int i = 0; i < array.size(); i++) {
        res.getInclude().add(parseValueSetConceptSetComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("exclude")) {
      JsonArray array = json.getAsJsonArray("exclude");
      for (int i = 0; i < array.size(); i++) {
        res.getExclude().add(parseValueSetConceptSetComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ValueSet.ConceptSetComponent parseValueSetConceptSetComponent(JsonObject json, ValueSet owner)
      throws IOException, FHIRFormatError {
    ValueSet.ConceptSetComponent res = new ValueSet.ConceptSetComponent();
    parseBackboneProperties(json, res);
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("concept")) {
      JsonArray array = json.getAsJsonArray("concept");
      for (int i = 0; i < array.size(); i++) {
        res.getConcept().add(parseValueSetConceptReferenceComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("filter")) {
      JsonArray array = json.getAsJsonArray("filter");
      for (int i = 0; i < array.size(); i++) {
        res.getFilter().add(parseValueSetConceptSetFilterComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ValueSet.ConceptReferenceComponent parseValueSetConceptReferenceComponent(JsonObject json, ValueSet owner)
      throws IOException, FHIRFormatError {
    ValueSet.ConceptReferenceComponent res = new ValueSet.ConceptReferenceComponent();
    parseBackboneProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    if (json.has("designation")) {
      JsonArray array = json.getAsJsonArray("designation");
      for (int i = 0; i < array.size(); i++) {
        res.getDesignation()
            .add(parseValueSetConceptReferenceDesignationComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ValueSet.ConceptReferenceDesignationComponent parseValueSetConceptReferenceDesignationComponent(
      JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
    ValueSet.ConceptReferenceDesignationComponent res = new ValueSet.ConceptReferenceDesignationComponent();
    parseBackboneProperties(json, res);
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("use"))
      res.setUse(parseCoding(json.getAsJsonObject("use")));
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    return res;
  }

  protected ValueSet.ConceptSetFilterComponent parseValueSetConceptSetFilterComponent(JsonObject json, ValueSet owner)
      throws IOException, FHIRFormatError {
    ValueSet.ConceptSetFilterComponent res = new ValueSet.ConceptSetFilterComponent();
    parseBackboneProperties(json, res);
    if (json.has("property"))
      res.setPropertyElement(parseCode(json.get("property").getAsString()));
    if (json.has("_property"))
      parseElementProperties(json.getAsJsonObject("_property"), res.getPropertyElement());
    if (json.has("op"))
      res.setOpElement(parseEnumeration(json.get("op").getAsString(), ValueSet.FilterOperator.NULL,
          new ValueSet.FilterOperatorEnumFactory()));
    if (json.has("_op"))
      parseElementProperties(json.getAsJsonObject("_op"), res.getOpElement());
    if (json.has("value"))
      res.setValueElement(parseCode(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    return res;
  }

  protected ValueSet.ValueSetExpansionComponent parseValueSetValueSetExpansionComponent(JsonObject json, ValueSet owner)
      throws IOException, FHIRFormatError {
    ValueSet.ValueSetExpansionComponent res = new ValueSet.ValueSetExpansionComponent();
    parseBackboneProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifierElement(parseUri(json.get("identifier").getAsString()));
    if (json.has("_identifier"))
      parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
    if (json.has("timestamp"))
      res.setTimestampElement(parseDateTime(json.get("timestamp").getAsString()));
    if (json.has("_timestamp"))
      parseElementProperties(json.getAsJsonObject("_timestamp"), res.getTimestampElement());
    if (json.has("total"))
      res.setTotalElement(parseInteger(json.get("total").getAsLong()));
    if (json.has("_total"))
      parseElementProperties(json.getAsJsonObject("_total"), res.getTotalElement());
    if (json.has("offset"))
      res.setOffsetElement(parseInteger(json.get("offset").getAsLong()));
    if (json.has("_offset"))
      parseElementProperties(json.getAsJsonObject("_offset"), res.getOffsetElement());
    if (json.has("parameter")) {
      JsonArray array = json.getAsJsonArray("parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter().add(parseValueSetValueSetExpansionParameterComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    if (json.has("contains")) {
      JsonArray array = json.getAsJsonArray("contains");
      for (int i = 0; i < array.size(); i++) {
        res.getContains().add(parseValueSetValueSetExpansionContainsComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected ValueSet.ValueSetExpansionParameterComponent parseValueSetValueSetExpansionParameterComponent(
      JsonObject json, ValueSet owner) throws IOException, FHIRFormatError {
    ValueSet.ValueSetExpansionParameterComponent res = new ValueSet.ValueSetExpansionParameterComponent();
    parseBackboneProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    Type value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    return res;
  }

  protected ValueSet.ValueSetExpansionContainsComponent parseValueSetValueSetExpansionContainsComponent(JsonObject json,
      ValueSet owner) throws IOException, FHIRFormatError {
    ValueSet.ValueSetExpansionContainsComponent res = new ValueSet.ValueSetExpansionContainsComponent();
    parseBackboneProperties(json, res);
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("abstract"))
      res.setAbstractElement(parseBoolean(json.get("abstract").getAsBoolean()));
    if (json.has("_abstract"))
      parseElementProperties(json.getAsJsonObject("_abstract"), res.getAbstractElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    if (json.has("contains")) {
      JsonArray array = json.getAsJsonArray("contains");
      for (int i = 0; i < array.size(); i++) {
        res.getContains().add(parseValueSetValueSetExpansionContainsComponent(array.get(i).getAsJsonObject(), owner));
      }
    }
    ;
    return res;
  }

  protected VisionPrescription parseVisionPrescription(JsonObject json) throws IOException, FHIRFormatError {
    VisionPrescription res = new VisionPrescription();
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    }
    ;
    if (json.has("dateWritten"))
      res.setDateWrittenElement(parseDateTime(json.get("dateWritten").getAsString()));
    if (json.has("_dateWritten"))
      parseElementProperties(json.getAsJsonObject("_dateWritten"), res.getDateWrittenElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("prescriber"))
      res.setPrescriber(parseReference(json.getAsJsonObject("prescriber")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    Type reason = parseType("reason", json);
    if (reason != null)
      res.setReason(reason);
    if (json.has("dispense")) {
      JsonArray array = json.getAsJsonArray("dispense");
      for (int i = 0; i < array.size(); i++) {
        res.getDispense()
            .add(parseVisionPrescriptionVisionPrescriptionDispenseComponent(array.get(i).getAsJsonObject(), res));
      }
    }
    ;
    return res;
  }

  protected VisionPrescription.VisionPrescriptionDispenseComponent parseVisionPrescriptionVisionPrescriptionDispenseComponent(
      JsonObject json, VisionPrescription owner) throws IOException, FHIRFormatError {
    VisionPrescription.VisionPrescriptionDispenseComponent res = new VisionPrescription.VisionPrescriptionDispenseComponent();
    parseBackboneProperties(json, res);
    if (json.has("product"))
      res.setProduct(parseCoding(json.getAsJsonObject("product")));
    if (json.has("eye"))
      res.setEyeElement(parseEnumeration(json.get("eye").getAsString(), VisionPrescription.VisionEyes.NULL,
          new VisionPrescription.VisionEyesEnumFactory()));
    if (json.has("_eye"))
      parseElementProperties(json.getAsJsonObject("_eye"), res.getEyeElement());
    if (json.has("sphere"))
      res.setSphereElement(parseDecimal(json.get("sphere").getAsBigDecimal()));
    if (json.has("_sphere"))
      parseElementProperties(json.getAsJsonObject("_sphere"), res.getSphereElement());
    if (json.has("cylinder"))
      res.setCylinderElement(parseDecimal(json.get("cylinder").getAsBigDecimal()));
    if (json.has("_cylinder"))
      parseElementProperties(json.getAsJsonObject("_cylinder"), res.getCylinderElement());
    if (json.has("axis"))
      res.setAxisElement(parseInteger(json.get("axis").getAsLong()));
    if (json.has("_axis"))
      parseElementProperties(json.getAsJsonObject("_axis"), res.getAxisElement());
    if (json.has("prism"))
      res.setPrismElement(parseDecimal(json.get("prism").getAsBigDecimal()));
    if (json.has("_prism"))
      parseElementProperties(json.getAsJsonObject("_prism"), res.getPrismElement());
    if (json.has("base"))
      res.setBaseElement(parseEnumeration(json.get("base").getAsString(), VisionPrescription.VisionBase.NULL,
          new VisionPrescription.VisionBaseEnumFactory()));
    if (json.has("_base"))
      parseElementProperties(json.getAsJsonObject("_base"), res.getBaseElement());
    if (json.has("add"))
      res.setAddElement(parseDecimal(json.get("add").getAsBigDecimal()));
    if (json.has("_add"))
      parseElementProperties(json.getAsJsonObject("_add"), res.getAddElement());
    if (json.has("power"))
      res.setPowerElement(parseDecimal(json.get("power").getAsBigDecimal()));
    if (json.has("_power"))
      parseElementProperties(json.getAsJsonObject("_power"), res.getPowerElement());
    if (json.has("backCurve"))
      res.setBackCurveElement(parseDecimal(json.get("backCurve").getAsBigDecimal()));
    if (json.has("_backCurve"))
      parseElementProperties(json.getAsJsonObject("_backCurve"), res.getBackCurveElement());
    if (json.has("diameter"))
      res.setDiameterElement(parseDecimal(json.get("diameter").getAsBigDecimal()));
    if (json.has("_diameter"))
      parseElementProperties(json.getAsJsonObject("_diameter"), res.getDiameterElement());
    if (json.has("duration"))
      res.setDuration(parseSimpleQuantity(json.getAsJsonObject("duration")));
    if (json.has("color"))
      res.setColorElement(parseString(json.get("color").getAsString()));
    if (json.has("_color"))
      parseElementProperties(json.getAsJsonObject("_color"), res.getColorElement());
    if (json.has("brand"))
      res.setBrandElement(parseString(json.get("brand").getAsString()));
    if (json.has("_brand"))
      parseElementProperties(json.getAsJsonObject("_brand"), res.getBrandElement());
    if (json.has("notes"))
      res.setNotesElement(parseString(json.get("notes").getAsString()));
    if (json.has("_notes"))
      parseElementProperties(json.getAsJsonObject("_notes"), res.getNotesElement());
    return res;
  }

  @Override
  protected Resource parseResource(JsonObject json) throws IOException, FHIRFormatError {
    if (!json.has("resourceType")) {
      throw new FHIRFormatError("Unable to find resource type - maybe not a FHIR resource?");
    }
    String t = json.get("resourceType").getAsString();
    if (Utilities.noString(t))
      throw new FHIRFormatError("Unable to find resource type - maybe not a FHIR resource?");
    if (t.equals("Parameters"))
      return parseParameters(json);
    else if (t.equals("Account"))
      return parseAccount(json);
    else if (t.equals("AllergyIntolerance"))
      return parseAllergyIntolerance(json);
    else if (t.equals("Appointment"))
      return parseAppointment(json);
    else if (t.equals("AppointmentResponse"))
      return parseAppointmentResponse(json);
    else if (t.equals("AuditEvent"))
      return parseAuditEvent(json);
    else if (t.equals("Basic"))
      return parseBasic(json);
    else if (t.equals("Binary"))
      return parseBinary(json);
    else if (t.equals("BodySite"))
      return parseBodySite(json);
    else if (t.equals("Bundle"))
      return parseBundle(json);
    else if (t.equals("CarePlan"))
      return parseCarePlan(json);
    else if (t.equals("CareTeam"))
      return parseCareTeam(json);
    else if (t.equals("Claim"))
      return parseClaim(json);
    else if (t.equals("ClaimResponse"))
      return parseClaimResponse(json);
    else if (t.equals("ClinicalImpression"))
      return parseClinicalImpression(json);
    else if (t.equals("CodeSystem"))
      return parseCodeSystem(json);
    else if (t.equals("Communication"))
      return parseCommunication(json);
    else if (t.equals("CommunicationRequest"))
      return parseCommunicationRequest(json);
    else if (t.equals("CompartmentDefinition"))
      return parseCompartmentDefinition(json);
    else if (t.equals("Composition"))
      return parseComposition(json);
    else if (t.equals("ConceptMap"))
      return parseConceptMap(json);
    else if (t.equals("Condition"))
      return parseCondition(json);
    else if (t.equals("Conformance"))
      return parseConformance(json);
    else if (t.equals("Contract"))
      return parseContract(json);
    else if (t.equals("Coverage"))
      return parseCoverage(json);
    else if (t.equals("DataElement"))
      return parseDataElement(json);
    else if (t.equals("DecisionSupportRule"))
      return parseDecisionSupportRule(json);
    else if (t.equals("DecisionSupportServiceModule"))
      return parseDecisionSupportServiceModule(json);
    else if (t.equals("DetectedIssue"))
      return parseDetectedIssue(json);
    else if (t.equals("Device"))
      return parseDevice(json);
    else if (t.equals("DeviceComponent"))
      return parseDeviceComponent(json);
    else if (t.equals("DeviceMetric"))
      return parseDeviceMetric(json);
    else if (t.equals("DeviceUseRequest"))
      return parseDeviceUseRequest(json);
    else if (t.equals("DeviceUseStatement"))
      return parseDeviceUseStatement(json);
    else if (t.equals("DiagnosticOrder"))
      return parseDiagnosticOrder(json);
    else if (t.equals("DiagnosticReport"))
      return parseDiagnosticReport(json);
    else if (t.equals("DocumentManifest"))
      return parseDocumentManifest(json);
    else if (t.equals("DocumentReference"))
      return parseDocumentReference(json);
    else if (t.equals("EligibilityRequest"))
      return parseEligibilityRequest(json);
    else if (t.equals("EligibilityResponse"))
      return parseEligibilityResponse(json);
    else if (t.equals("Encounter"))
      return parseEncounter(json);
    else if (t.equals("EnrollmentRequest"))
      return parseEnrollmentRequest(json);
    else if (t.equals("EnrollmentResponse"))
      return parseEnrollmentResponse(json);
    else if (t.equals("EpisodeOfCare"))
      return parseEpisodeOfCare(json);
    else if (t.equals("ExpansionProfile"))
      return parseExpansionProfile(json);
    else if (t.equals("ExplanationOfBenefit"))
      return parseExplanationOfBenefit(json);
    else if (t.equals("FamilyMemberHistory"))
      return parseFamilyMemberHistory(json);
    else if (t.equals("Flag"))
      return parseFlag(json);
    else if (t.equals("Goal"))
      return parseGoal(json);
    else if (t.equals("Group"))
      return parseGroup(json);
    else if (t.equals("GuidanceResponse"))
      return parseGuidanceResponse(json);
    else if (t.equals("HealthcareService"))
      return parseHealthcareService(json);
    else if (t.equals("ImagingExcerpt"))
      return parseImagingExcerpt(json);
    else if (t.equals("ImagingObjectSelection"))
      return parseImagingObjectSelection(json);
    else if (t.equals("ImagingStudy"))
      return parseImagingStudy(json);
    else if (t.equals("Immunization"))
      return parseImmunization(json);
    else if (t.equals("ImmunizationRecommendation"))
      return parseImmunizationRecommendation(json);
    else if (t.equals("ImplementationGuide"))
      return parseImplementationGuide(json);
    else if (t.equals("Library"))
      return parseLibrary(json);
    else if (t.equals("Linkage"))
      return parseLinkage(json);
    else if (t.equals("List"))
      return parseListResource(json);
    else if (t.equals("Location"))
      return parseLocation(json);
    else if (t.equals("Measure"))
      return parseMeasure(json);
    else if (t.equals("MeasureReport"))
      return parseMeasureReport(json);
    else if (t.equals("Media"))
      return parseMedia(json);
    else if (t.equals("Medication"))
      return parseMedication(json);
    else if (t.equals("MedicationAdministration"))
      return parseMedicationAdministration(json);
    else if (t.equals("MedicationDispense"))
      return parseMedicationDispense(json);
    else if (t.equals("MedicationOrder"))
      return parseMedicationOrder(json);
    else if (t.equals("MedicationStatement"))
      return parseMedicationStatement(json);
    else if (t.equals("MessageHeader"))
      return parseMessageHeader(json);
    else if (t.equals("ModuleDefinition"))
      return parseModuleDefinition(json);
    else if (t.equals("NamingSystem"))
      return parseNamingSystem(json);
    else if (t.equals("NutritionOrder"))
      return parseNutritionOrder(json);
    else if (t.equals("Observation"))
      return parseObservation(json);
    else if (t.equals("OperationDefinition"))
      return parseOperationDefinition(json);
    else if (t.equals("OperationOutcome"))
      return parseOperationOutcome(json);
    else if (t.equals("Order"))
      return parseOrder(json);
    else if (t.equals("OrderResponse"))
      return parseOrderResponse(json);
    else if (t.equals("OrderSet"))
      return parseOrderSet(json);
    else if (t.equals("Organization"))
      return parseOrganization(json);
    else if (t.equals("Patient"))
      return parsePatient(json);
    else if (t.equals("PaymentNotice"))
      return parsePaymentNotice(json);
    else if (t.equals("PaymentReconciliation"))
      return parsePaymentReconciliation(json);
    else if (t.equals("Person"))
      return parsePerson(json);
    else if (t.equals("Practitioner"))
      return parsePractitioner(json);
    else if (t.equals("PractitionerRole"))
      return parsePractitionerRole(json);
    else if (t.equals("Procedure"))
      return parseProcedure(json);
    else if (t.equals("ProcedureRequest"))
      return parseProcedureRequest(json);
    else if (t.equals("ProcessRequest"))
      return parseProcessRequest(json);
    else if (t.equals("ProcessResponse"))
      return parseProcessResponse(json);
    else if (t.equals("Protocol"))
      return parseProtocol(json);
    else if (t.equals("Provenance"))
      return parseProvenance(json);
    else if (t.equals("Questionnaire"))
      return parseQuestionnaire(json);
    else if (t.equals("QuestionnaireResponse"))
      return parseQuestionnaireResponse(json);
    else if (t.equals("ReferralRequest"))
      return parseReferralRequest(json);
    else if (t.equals("RelatedPerson"))
      return parseRelatedPerson(json);
    else if (t.equals("RiskAssessment"))
      return parseRiskAssessment(json);
    else if (t.equals("Schedule"))
      return parseSchedule(json);
    else if (t.equals("SearchParameter"))
      return parseSearchParameter(json);
    else if (t.equals("Sequence"))
      return parseSequence(json);
    else if (t.equals("Slot"))
      return parseSlot(json);
    else if (t.equals("Specimen"))
      return parseSpecimen(json);
    else if (t.equals("StructureDefinition"))
      return parseStructureDefinition(json);
    else if (t.equals("StructureMap"))
      return parseStructureMap(json);
    else if (t.equals("Subscription"))
      return parseSubscription(json);
    else if (t.equals("Substance"))
      return parseSubstance(json);
    else if (t.equals("SupplyDelivery"))
      return parseSupplyDelivery(json);
    else if (t.equals("SupplyRequest"))
      return parseSupplyRequest(json);
    else if (t.equals("Task"))
      return parseTask(json);
    else if (t.equals("TestScript"))
      return parseTestScript(json);
    else if (t.equals("ValueSet"))
      return parseValueSet(json);
    else if (t.equals("VisionPrescription"))
      return parseVisionPrescription(json);
    else if (t.equals("Binary"))
      return parseBinary(json);
    throw new FHIRFormatError("Unknown.Unrecognised resource type '" + t + "' (in property 'resourceType')");
  }

  protected Type parseType(String prefix, JsonObject json) throws IOException, FHIRFormatError {
    if (json.has(prefix + "Period"))
      return parsePeriod(json.getAsJsonObject(prefix + "Period"));
    else if (json.has(prefix + "Coding"))
      return parseCoding(json.getAsJsonObject(prefix + "Coding"));
    else if (json.has(prefix + "Range"))
      return parseRange(json.getAsJsonObject(prefix + "Range"));
    else if (json.has(prefix + "Quantity"))
      return parseQuantity(json.getAsJsonObject(prefix + "Quantity"));
    else if (json.has(prefix + "Attachment"))
      return parseAttachment(json.getAsJsonObject(prefix + "Attachment"));
    else if (json.has(prefix + "Ratio"))
      return parseRatio(json.getAsJsonObject(prefix + "Ratio"));
    else if (json.has(prefix + "Annotation"))
      return parseAnnotation(json.getAsJsonObject(prefix + "Annotation"));
    else if (json.has(prefix + "SampledData"))
      return parseSampledData(json.getAsJsonObject(prefix + "SampledData"));
    else if (json.has(prefix + "Reference"))
      return parseReference(json.getAsJsonObject(prefix + "Reference"));
    else if (json.has(prefix + "CodeableConcept"))
      return parseCodeableConcept(json.getAsJsonObject(prefix + "CodeableConcept"));
    else if (json.has(prefix + "Identifier"))
      return parseIdentifier(json.getAsJsonObject(prefix + "Identifier"));
    else if (json.has(prefix + "Signature"))
      return parseSignature(json.getAsJsonObject(prefix + "Signature"));
    else if (json.has(prefix + "Age"))
      return parseAge(json.getAsJsonObject(prefix + "Age"));
    else if (json.has(prefix + "Count"))
      return parseCount(json.getAsJsonObject(prefix + "Count"));
    else if (json.has(prefix + "Money"))
      return parseMoney(json.getAsJsonObject(prefix + "Money"));
    else if (json.has(prefix + "Distance"))
      return parseDistance(json.getAsJsonObject(prefix + "Distance"));
    else if (json.has(prefix + "Duration"))
      return parseDuration(json.getAsJsonObject(prefix + "Duration"));
    else if (json.has(prefix + "SimpleQuantity"))
      return parseSimpleQuantity(json.getAsJsonObject(prefix + "SimpleQuantity"));
    else if (json.has(prefix + "TriggerDefinition"))
      return parseTriggerDefinition(json.getAsJsonObject(prefix + "TriggerDefinition"));
    else if (json.has(prefix + "ElementDefinition"))
      return parseElementDefinition(json.getAsJsonObject(prefix + "ElementDefinition"));
    else if (json.has(prefix + "Timing"))
      return parseTiming(json.getAsJsonObject(prefix + "Timing"));
    else if (json.has(prefix + "ModuleMetadata"))
      return parseModuleMetadata(json.getAsJsonObject(prefix + "ModuleMetadata"));
    else if (json.has(prefix + "ActionDefinition"))
      return parseActionDefinition(json.getAsJsonObject(prefix + "ActionDefinition"));
    else if (json.has(prefix + "Address"))
      return parseAddress(json.getAsJsonObject(prefix + "Address"));
    else if (json.has(prefix + "HumanName"))
      return parseHumanName(json.getAsJsonObject(prefix + "HumanName"));
    else if (json.has(prefix + "DataRequirement"))
      return parseDataRequirement(json.getAsJsonObject(prefix + "DataRequirement"));
    else if (json.has(prefix + "Meta"))
      return parseMeta(json.getAsJsonObject(prefix + "Meta"));
    else if (json.has(prefix + "ParameterDefinition"))
      return parseParameterDefinition(json.getAsJsonObject(prefix + "ParameterDefinition"));
    else if (json.has(prefix + "ContactPoint"))
      return parseContactPoint(json.getAsJsonObject(prefix + "ContactPoint"));
    else if (json.has(prefix + "Markdown") || json.has("_" + prefix + "Markdown")) {
      Type t = json.has(prefix + "Markdown") ? parseMarkdown(json.get(prefix + "Markdown").getAsString())
          : new MarkdownType();
      if (json.has("_" + prefix + "Markdown"))
        parseElementProperties(json.getAsJsonObject("_" + prefix + "Markdown"), t);
      return t;
    } else if (json.has(prefix + "Integer") || json.has("_" + prefix + "Integer")) {
      Type t = json.has(prefix + "Integer") ? parseInteger(json.get(prefix + "Integer").getAsLong())
          : new IntegerType();
      if (json.has("_" + prefix + "Integer"))
        parseElementProperties(json.getAsJsonObject("_" + prefix + "Integer"), t);
      return t;
    } else if (json.has(prefix + "DateTime") || json.has("_" + prefix + "DateTime")) {
      Type t = json.has(prefix + "DateTime") ? parseDateTime(json.get(prefix + "DateTime").getAsString())
          : new DateTimeType();
      if (json.has("_" + prefix + "DateTime"))
        parseElementProperties(json.getAsJsonObject("_" + prefix + "DateTime"), t);
      return t;
    } else if (json.has(prefix + "UnsignedInt") || json.has("_" + prefix + "UnsignedInt")) {
      Type t = json.has(prefix + "UnsignedInt") ? parseUnsignedInt(json.get(prefix + "UnsignedInt").getAsString())
          : new UnsignedIntType();
      if (json.has("_" + prefix + "UnsignedInt"))
        parseElementProperties(json.getAsJsonObject("_" + prefix + "UnsignedInt"), t);
      return t;
    } else if (json.has(prefix + "Code") || json.has("_" + prefix + "Code")) {
      Type t = json.has(prefix + "Code") ? parseCode(json.get(prefix + "Code").getAsString()) : new CodeType();
      if (json.has("_" + prefix + "Code"))
        parseElementProperties(json.getAsJsonObject("_" + prefix + "Code"), t);
      return t;
    } else if (json.has(prefix + "Date") || json.has("_" + prefix + "Date")) {
      Type t = json.has(prefix + "Date") ? parseDate(json.get(prefix + "Date").getAsString()) : new DateType();
      if (json.has("_" + prefix + "Date"))
        parseElementProperties(json.getAsJsonObject("_" + prefix + "Date"), t);
      return t;
    } else if (json.has(prefix + "Decimal") || json.has("_" + prefix + "Decimal")) {
      Type t = json.has(prefix + "Decimal") ? parseDecimal(json.get(prefix + "Decimal").getAsBigDecimal())
          : new DecimalType();
      if (json.has("_" + prefix + "Decimal"))
        parseElementProperties(json.getAsJsonObject("_" + prefix + "Decimal"), t);
      return t;
    } else if (json.has(prefix + "Uri") || json.has("_" + prefix + "Uri")) {
      Type t = json.has(prefix + "Uri") ? parseUri(json.get(prefix + "Uri").getAsString()) : new UriType();
      if (json.has("_" + prefix + "Uri"))
        parseElementProperties(json.getAsJsonObject("_" + prefix + "Uri"), t);
      return t;
    } else if (json.has(prefix + "Id") || json.has("_" + prefix + "Id")) {
      Type t = json.has(prefix + "Id") ? parseId(json.get(prefix + "Id").getAsString()) : new IdType();
      if (json.has("_" + prefix + "Id"))
        parseElementProperties(json.getAsJsonObject("_" + prefix + "Id"), t);
      return t;
    } else if (json.has(prefix + "Base64Binary") || json.has("_" + prefix + "Base64Binary")) {
      Type t = json.has(prefix + "Base64Binary") ? parseBase64Binary(json.get(prefix + "Base64Binary").getAsString())
          : new Base64BinaryType();
      if (json.has("_" + prefix + "Base64Binary"))
        parseElementProperties(json.getAsJsonObject("_" + prefix + "Base64Binary"), t);
      return t;
    } else if (json.has(prefix + "Time") || json.has("_" + prefix + "Time")) {
      Type t = json.has(prefix + "Time") ? parseTime(json.get(prefix + "Time").getAsString()) : new TimeType();
      if (json.has("_" + prefix + "Time"))
        parseElementProperties(json.getAsJsonObject("_" + prefix + "Time"), t);
      return t;
    } else if (json.has(prefix + "Oid") || json.has("_" + prefix + "Oid")) {
      Type t = json.has(prefix + "Oid") ? parseOid(json.get(prefix + "Oid").getAsString()) : new OidType();
      if (json.has("_" + prefix + "Oid"))
        parseElementProperties(json.getAsJsonObject("_" + prefix + "Oid"), t);
      return t;
    } else if (json.has(prefix + "PositiveInt") || json.has("_" + prefix + "PositiveInt")) {
      Type t = json.has(prefix + "PositiveInt") ? parsePositiveInt(json.get(prefix + "PositiveInt").getAsString())
          : new PositiveIntType();
      if (json.has("_" + prefix + "PositiveInt"))
        parseElementProperties(json.getAsJsonObject("_" + prefix + "PositiveInt"), t);
      return t;
    } else if (json.has(prefix + "String") || json.has("_" + prefix + "String")) {
      Type t = json.has(prefix + "String") ? parseString(json.get(prefix + "String").getAsString()) : new StringType();
      if (json.has("_" + prefix + "String"))
        parseElementProperties(json.getAsJsonObject("_" + prefix + "String"), t);
      return t;
    } else if (json.has(prefix + "Boolean") || json.has("_" + prefix + "Boolean")) {
      Type t = json.has(prefix + "Boolean") ? parseBoolean(json.get(prefix + "Boolean").getAsBoolean())
          : new BooleanType();
      if (json.has("_" + prefix + "Boolean"))
        parseElementProperties(json.getAsJsonObject("_" + prefix + "Boolean"), t);
      return t;
    } else if (json.has(prefix + "Uuid") || json.has("_" + prefix + "Uuid")) {
      Type t = json.has(prefix + "Uuid") ? parseUuid(json.get(prefix + "Uuid").getAsString()) : new UuidType();
      if (json.has("_" + prefix + "Uuid"))
        parseElementProperties(json.getAsJsonObject("_" + prefix + "Uuid"), t);
      return t;
    } else if (json.has(prefix + "Instant") || json.has("_" + prefix + "Instant")) {
      Type t = json.has(prefix + "Instant") ? parseInstant(json.get(prefix + "Instant").getAsString())
          : new InstantType();
      if (json.has("_" + prefix + "Instant"))
        parseElementProperties(json.getAsJsonObject("_" + prefix + "Instant"), t);
      return t;
    }
    return null;
  }

  protected Type parseType(JsonObject json, String type) throws IOException, FHIRFormatError {
    if (type.equals("Period"))
      return parsePeriod(json);
    else if (type.equals("Coding"))
      return parseCoding(json);
    else if (type.equals("Range"))
      return parseRange(json);
    else if (type.equals("Quantity"))
      return parseQuantity(json);
    else if (type.equals("Attachment"))
      return parseAttachment(json);
    else if (type.equals("Ratio"))
      return parseRatio(json);
    else if (type.equals("Annotation"))
      return parseAnnotation(json);
    else if (type.equals("SampledData"))
      return parseSampledData(json);
    else if (type.equals("Reference"))
      return parseReference(json);
    else if (type.equals("CodeableConcept"))
      return parseCodeableConcept(json);
    else if (type.equals("Identifier"))
      return parseIdentifier(json);
    else if (type.equals("Signature"))
      return parseSignature(json);
    else if (type.equals("Age"))
      return parseAge(json);
    else if (type.equals("Count"))
      return parseCount(json);
    else if (type.equals("Money"))
      return parseMoney(json);
    else if (type.equals("Distance"))
      return parseDistance(json);
    else if (type.equals("Duration"))
      return parseDuration(json);
    else if (type.equals("SimpleQuantity"))
      return parseSimpleQuantity(json);
    else if (type.equals("TriggerDefinition"))
      return parseTriggerDefinition(json);
    else if (type.equals("ElementDefinition"))
      return parseElementDefinition(json);
    else if (type.equals("Timing"))
      return parseTiming(json);
    else if (type.equals("ModuleMetadata"))
      return parseModuleMetadata(json);
    else if (type.equals("ActionDefinition"))
      return parseActionDefinition(json);
    else if (type.equals("Address"))
      return parseAddress(json);
    else if (type.equals("HumanName"))
      return parseHumanName(json);
    else if (type.equals("DataRequirement"))
      return parseDataRequirement(json);
    else if (type.equals("Meta"))
      return parseMeta(json);
    else if (type.equals("ParameterDefinition"))
      return parseParameterDefinition(json);
    else if (type.equals("ContactPoint"))
      return parseContactPoint(json);
    throw new FHIRFormatError("Unknown Type " + type);
  }

  protected boolean hasTypeName(JsonObject json, String prefix) {
    if (json.has(prefix + "Period"))
      return true;
    if (json.has(prefix + "Coding"))
      return true;
    if (json.has(prefix + "Range"))
      return true;
    if (json.has(prefix + "Quantity"))
      return true;
    if (json.has(prefix + "Attachment"))
      return true;
    if (json.has(prefix + "Ratio"))
      return true;
    if (json.has(prefix + "Annotation"))
      return true;
    if (json.has(prefix + "SampledData"))
      return true;
    if (json.has(prefix + "Reference"))
      return true;
    if (json.has(prefix + "CodeableConcept"))
      return true;
    if (json.has(prefix + "Identifier"))
      return true;
    if (json.has(prefix + "Signature"))
      return true;
    if (json.has(prefix + "Age"))
      return true;
    if (json.has(prefix + "Count"))
      return true;
    if (json.has(prefix + "Money"))
      return true;
    if (json.has(prefix + "Distance"))
      return true;
    if (json.has(prefix + "Duration"))
      return true;
    if (json.has(prefix + "SimpleQuantity"))
      return true;
    if (json.has(prefix + "TriggerDefinition"))
      return true;
    if (json.has(prefix + "ElementDefinition"))
      return true;
    if (json.has(prefix + "Timing"))
      return true;
    if (json.has(prefix + "ModuleMetadata"))
      return true;
    if (json.has(prefix + "ActionDefinition"))
      return true;
    if (json.has(prefix + "Address"))
      return true;
    if (json.has(prefix + "HumanName"))
      return true;
    if (json.has(prefix + "DataRequirement"))
      return true;
    if (json.has(prefix + "Meta"))
      return true;
    if (json.has(prefix + "ParameterDefinition"))
      return true;
    if (json.has(prefix + "ContactPoint"))
      return true;
    if (json.has(prefix + "Parameters"))
      return true;
    if (json.has(prefix + "Account"))
      return true;
    if (json.has(prefix + "AllergyIntolerance"))
      return true;
    if (json.has(prefix + "Appointment"))
      return true;
    if (json.has(prefix + "AppointmentResponse"))
      return true;
    if (json.has(prefix + "AuditEvent"))
      return true;
    if (json.has(prefix + "Basic"))
      return true;
    if (json.has(prefix + "Binary"))
      return true;
    if (json.has(prefix + "BodySite"))
      return true;
    if (json.has(prefix + "Bundle"))
      return true;
    if (json.has(prefix + "CarePlan"))
      return true;
    if (json.has(prefix + "CareTeam"))
      return true;
    if (json.has(prefix + "Claim"))
      return true;
    if (json.has(prefix + "ClaimResponse"))
      return true;
    if (json.has(prefix + "ClinicalImpression"))
      return true;
    if (json.has(prefix + "CodeSystem"))
      return true;
    if (json.has(prefix + "Communication"))
      return true;
    if (json.has(prefix + "CommunicationRequest"))
      return true;
    if (json.has(prefix + "CompartmentDefinition"))
      return true;
    if (json.has(prefix + "Composition"))
      return true;
    if (json.has(prefix + "ConceptMap"))
      return true;
    if (json.has(prefix + "Condition"))
      return true;
    if (json.has(prefix + "Conformance"))
      return true;
    if (json.has(prefix + "Contract"))
      return true;
    if (json.has(prefix + "Coverage"))
      return true;
    if (json.has(prefix + "DataElement"))
      return true;
    if (json.has(prefix + "DecisionSupportRule"))
      return true;
    if (json.has(prefix + "DecisionSupportServiceModule"))
      return true;
    if (json.has(prefix + "DetectedIssue"))
      return true;
    if (json.has(prefix + "Device"))
      return true;
    if (json.has(prefix + "DeviceComponent"))
      return true;
    if (json.has(prefix + "DeviceMetric"))
      return true;
    if (json.has(prefix + "DeviceUseRequest"))
      return true;
    if (json.has(prefix + "DeviceUseStatement"))
      return true;
    if (json.has(prefix + "DiagnosticOrder"))
      return true;
    if (json.has(prefix + "DiagnosticReport"))
      return true;
    if (json.has(prefix + "DocumentManifest"))
      return true;
    if (json.has(prefix + "DocumentReference"))
      return true;
    if (json.has(prefix + "EligibilityRequest"))
      return true;
    if (json.has(prefix + "EligibilityResponse"))
      return true;
    if (json.has(prefix + "Encounter"))
      return true;
    if (json.has(prefix + "EnrollmentRequest"))
      return true;
    if (json.has(prefix + "EnrollmentResponse"))
      return true;
    if (json.has(prefix + "EpisodeOfCare"))
      return true;
    if (json.has(prefix + "ExpansionProfile"))
      return true;
    if (json.has(prefix + "ExplanationOfBenefit"))
      return true;
    if (json.has(prefix + "FamilyMemberHistory"))
      return true;
    if (json.has(prefix + "Flag"))
      return true;
    if (json.has(prefix + "Goal"))
      return true;
    if (json.has(prefix + "Group"))
      return true;
    if (json.has(prefix + "GuidanceResponse"))
      return true;
    if (json.has(prefix + "HealthcareService"))
      return true;
    if (json.has(prefix + "ImagingExcerpt"))
      return true;
    if (json.has(prefix + "ImagingObjectSelection"))
      return true;
    if (json.has(prefix + "ImagingStudy"))
      return true;
    if (json.has(prefix + "Immunization"))
      return true;
    if (json.has(prefix + "ImmunizationRecommendation"))
      return true;
    if (json.has(prefix + "ImplementationGuide"))
      return true;
    if (json.has(prefix + "Library"))
      return true;
    if (json.has(prefix + "Linkage"))
      return true;
    if (json.has(prefix + "List"))
      return true;
    if (json.has(prefix + "Location"))
      return true;
    if (json.has(prefix + "Measure"))
      return true;
    if (json.has(prefix + "MeasureReport"))
      return true;
    if (json.has(prefix + "Media"))
      return true;
    if (json.has(prefix + "Medication"))
      return true;
    if (json.has(prefix + "MedicationAdministration"))
      return true;
    if (json.has(prefix + "MedicationDispense"))
      return true;
    if (json.has(prefix + "MedicationOrder"))
      return true;
    if (json.has(prefix + "MedicationStatement"))
      return true;
    if (json.has(prefix + "MessageHeader"))
      return true;
    if (json.has(prefix + "ModuleDefinition"))
      return true;
    if (json.has(prefix + "NamingSystem"))
      return true;
    if (json.has(prefix + "NutritionOrder"))
      return true;
    if (json.has(prefix + "Observation"))
      return true;
    if (json.has(prefix + "OperationDefinition"))
      return true;
    if (json.has(prefix + "OperationOutcome"))
      return true;
    if (json.has(prefix + "Order"))
      return true;
    if (json.has(prefix + "OrderResponse"))
      return true;
    if (json.has(prefix + "OrderSet"))
      return true;
    if (json.has(prefix + "Organization"))
      return true;
    if (json.has(prefix + "Patient"))
      return true;
    if (json.has(prefix + "PaymentNotice"))
      return true;
    if (json.has(prefix + "PaymentReconciliation"))
      return true;
    if (json.has(prefix + "Person"))
      return true;
    if (json.has(prefix + "Practitioner"))
      return true;
    if (json.has(prefix + "PractitionerRole"))
      return true;
    if (json.has(prefix + "Procedure"))
      return true;
    if (json.has(prefix + "ProcedureRequest"))
      return true;
    if (json.has(prefix + "ProcessRequest"))
      return true;
    if (json.has(prefix + "ProcessResponse"))
      return true;
    if (json.has(prefix + "Protocol"))
      return true;
    if (json.has(prefix + "Provenance"))
      return true;
    if (json.has(prefix + "Questionnaire"))
      return true;
    if (json.has(prefix + "QuestionnaireResponse"))
      return true;
    if (json.has(prefix + "ReferralRequest"))
      return true;
    if (json.has(prefix + "RelatedPerson"))
      return true;
    if (json.has(prefix + "RiskAssessment"))
      return true;
    if (json.has(prefix + "Schedule"))
      return true;
    if (json.has(prefix + "SearchParameter"))
      return true;
    if (json.has(prefix + "Sequence"))
      return true;
    if (json.has(prefix + "Slot"))
      return true;
    if (json.has(prefix + "Specimen"))
      return true;
    if (json.has(prefix + "StructureDefinition"))
      return true;
    if (json.has(prefix + "StructureMap"))
      return true;
    if (json.has(prefix + "Subscription"))
      return true;
    if (json.has(prefix + "Substance"))
      return true;
    if (json.has(prefix + "SupplyDelivery"))
      return true;
    if (json.has(prefix + "SupplyRequest"))
      return true;
    if (json.has(prefix + "Task"))
      return true;
    if (json.has(prefix + "TestScript"))
      return true;
    if (json.has(prefix + "ValueSet"))
      return true;
    if (json.has(prefix + "VisionPrescription"))
      return true;
    if (json.has(prefix + "Markdown") || json.has("_" + prefix + "Markdown"))
      return true;
    if (json.has(prefix + "Integer") || json.has("_" + prefix + "Integer"))
      return true;
    if (json.has(prefix + "DateTime") || json.has("_" + prefix + "DateTime"))
      return true;
    if (json.has(prefix + "UnsignedInt") || json.has("_" + prefix + "UnsignedInt"))
      return true;
    if (json.has(prefix + "Code") || json.has("_" + prefix + "Code"))
      return true;
    if (json.has(prefix + "Date") || json.has("_" + prefix + "Date"))
      return true;
    if (json.has(prefix + "Decimal") || json.has("_" + prefix + "Decimal"))
      return true;
    if (json.has(prefix + "Uri") || json.has("_" + prefix + "Uri"))
      return true;
    if (json.has(prefix + "Id") || json.has("_" + prefix + "Id"))
      return true;
    if (json.has(prefix + "Base64Binary") || json.has("_" + prefix + "Base64Binary"))
      return true;
    if (json.has(prefix + "Time") || json.has("_" + prefix + "Time"))
      return true;
    if (json.has(prefix + "Oid") || json.has("_" + prefix + "Oid"))
      return true;
    if (json.has(prefix + "PositiveInt") || json.has("_" + prefix + "PositiveInt"))
      return true;
    if (json.has(prefix + "String") || json.has("_" + prefix + "String"))
      return true;
    if (json.has(prefix + "Boolean") || json.has("_" + prefix + "Boolean"))
      return true;
    if (json.has(prefix + "Uuid") || json.has("_" + prefix + "Uuid"))
      return true;
    if (json.has(prefix + "Instant") || json.has("_" + prefix + "Instant"))
      return true;
    return false;
  }

  protected void composeElement(Element element) throws IOException {
    if (element.hasId())
      prop("id", element.getId());
    if (makeComments(element)) {
      openArray("fhir_comments");
      for (String s : element.getFormatCommentsPre())
        prop(null, s);
      for (String s : element.getFormatCommentsPost())
        prop(null, s);
      closeArray();
    }
    if (element.hasExtension()) {
      openArray("extension");
      for (Extension e : element.getExtension())
        composeExtension(null, e);
      closeArray();
    }
  }

  protected void composeBackbone(BackboneElement element) throws IOException {
    composeElement(element);
    if (element.hasModifierExtension()) {
      openArray("modifierExtension");
      for (Extension e : element.getModifierExtension())
        composeExtension(null, e);
      closeArray();
    }
  }

  protected <E extends Enum<E>> void composeEnumerationCore(String name, Enumeration<E> value, EnumFactory e,
      boolean inArray) throws IOException {
    if (value != null && value.getValue() != null) {
      prop(name, e.toCode(value.getValue()));
    } else if (inArray)
      writeNull(name);
  }

  protected <E extends Enum<E>> void composeEnumerationExtras(String name, Enumeration<E> value, EnumFactory e,
      boolean inArray) throws IOException {
    if (value != null
        && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || makeComments(value))) {
      open(inArray ? null : "_" + name);
      composeElement(value);
      close();
    } else if (inArray)
      writeNull(name);
  }

  protected void composeMarkdownCore(String name, MarkdownType value, boolean inArray) throws IOException {
    if (value != null && value.hasValue()) {
      prop(name, toString(value.getValue()));
    } else if (inArray)
      writeNull(name);
  }

  protected void composeMarkdownExtras(String name, MarkdownType value, boolean inArray) throws IOException {
    if (value != null
        && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || makeComments(value))) {
      open(inArray ? null : "_" + name);
      composeElement(value);
      close();
    } else if (inArray)
      writeNull(name);
  }

  protected void composeIntegerCore(String name, IntegerType value, boolean inArray) throws IOException {
    if (value != null && value.hasValue()) {
      prop(name, Integer.valueOf(value.getValue()));
    } else if (inArray)
      writeNull(name);
  }

  protected void composeIntegerExtras(String name, IntegerType value, boolean inArray) throws IOException {
    if (value != null
        && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || makeComments(value))) {
      open(inArray ? null : "_" + name);
      composeElement(value);
      close();
    } else if (inArray)
      writeNull(name);
  }

  protected void composeDateTimeCore(String name, DateTimeType value, boolean inArray) throws IOException {
    if (value != null && value.hasValue()) {
      prop(name, value.asStringValue());
    } else if (inArray)
      writeNull(name);
  }

  protected void composeDateTimeExtras(String name, DateTimeType value, boolean inArray) throws IOException {
    if (value != null
        && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || makeComments(value))) {
      open(inArray ? null : "_" + name);
      composeElement(value);
      close();
    } else if (inArray)
      writeNull(name);
  }

  protected void composeUnsignedIntCore(String name, UnsignedIntType value, boolean inArray) throws IOException {
    if (value != null && value.hasValue()) {
      prop(name, Integer.valueOf(value.getValue()));
    } else if (inArray)
      writeNull(name);
  }

  protected void composeUnsignedIntExtras(String name, UnsignedIntType value, boolean inArray) throws IOException {
    if (value != null
        && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || makeComments(value))) {
      open(inArray ? null : "_" + name);
      composeElement(value);
      close();
    } else if (inArray)
      writeNull(name);
  }

  protected void composeCodeCore(String name, CodeType value, boolean inArray) throws IOException {
    if (value != null && value.hasValue()) {
      prop(name, toString(value.getValue()));
    } else if (inArray)
      writeNull(name);
  }

  protected void composeCodeExtras(String name, CodeType value, boolean inArray) throws IOException {
    if (value != null
        && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || makeComments(value))) {
      open(inArray ? null : "_" + name);
      composeElement(value);
      close();
    } else if (inArray)
      writeNull(name);
  }

  protected void composeDateCore(String name, DateType value, boolean inArray) throws IOException {
    if (value != null && value.hasValue()) {
      prop(name, value.asStringValue());
    } else if (inArray)
      writeNull(name);
  }

  protected void composeDateExtras(String name, DateType value, boolean inArray) throws IOException {
    if (value != null
        && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || makeComments(value))) {
      open(inArray ? null : "_" + name);
      composeElement(value);
      close();
    } else if (inArray)
      writeNull(name);
  }

  protected void composeDecimalCore(String name, DecimalType value, boolean inArray) throws IOException {
    if (value != null && value.hasValue()) {
      prop(name, value.getValue());
    } else if (inArray)
      writeNull(name);
  }

  protected void composeDecimalExtras(String name, DecimalType value, boolean inArray) throws IOException {
    if (value != null
        && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || makeComments(value))) {
      open(inArray ? null : "_" + name);
      composeElement(value);
      close();
    } else if (inArray)
      writeNull(name);
  }

  protected void composeUriCore(String name, UriType value, boolean inArray) throws IOException {
    if (value != null && value.hasValue()) {
      prop(name, toString(value.getValue()));
    } else if (inArray)
      writeNull(name);
  }

  protected void composeUriExtras(String name, UriType value, boolean inArray) throws IOException {
    if (value != null
        && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || makeComments(value))) {
      open(inArray ? null : "_" + name);
      composeElement(value);
      close();
    } else if (inArray)
      writeNull(name);
  }

  protected void composeIdCore(String name, IdType value, boolean inArray) throws IOException {
    if (value != null && value.hasValue()) {
      prop(name, toString(value.getValue()));
    } else if (inArray)
      writeNull(name);
  }

  protected void composeIdExtras(String name, IdType value, boolean inArray) throws IOException {
    if (value != null
        && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || makeComments(value))) {
      open(inArray ? null : "_" + name);
      composeElement(value);
      close();
    } else if (inArray)
      writeNull(name);
  }

  protected void composeBase64BinaryCore(String name, Base64BinaryType value, boolean inArray) throws IOException {
    if (value != null && value.hasValue()) {
      prop(name, toString(value.getValue()));
    } else if (inArray)
      writeNull(name);
  }

  protected void composeBase64BinaryExtras(String name, Base64BinaryType value, boolean inArray) throws IOException {
    if (value != null
        && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || makeComments(value))) {
      open(inArray ? null : "_" + name);
      composeElement(value);
      close();
    } else if (inArray)
      writeNull(name);
  }

  protected void composeTimeCore(String name, TimeType value, boolean inArray) throws IOException {
    if (value != null && value.hasValue()) {
      prop(name, value.asStringValue());
    } else if (inArray)
      writeNull(name);
  }

  protected void composeTimeExtras(String name, TimeType value, boolean inArray) throws IOException {
    if (value != null
        && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || makeComments(value))) {
      open(inArray ? null : "_" + name);
      composeElement(value);
      close();
    } else if (inArray)
      writeNull(name);
  }

  protected void composeOidCore(String name, OidType value, boolean inArray) throws IOException {
    if (value != null && value.hasValue()) {
      prop(name, toString(value.getValue()));
    } else if (inArray)
      writeNull(name);
  }

  protected void composeOidExtras(String name, OidType value, boolean inArray) throws IOException {
    if (value != null
        && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || makeComments(value))) {
      open(inArray ? null : "_" + name);
      composeElement(value);
      close();
    } else if (inArray)
      writeNull(name);
  }

  protected void composePositiveIntCore(String name, PositiveIntType value, boolean inArray) throws IOException {
    if (value != null && value.hasValue()) {
      prop(name, Integer.valueOf(value.getValue()));
    } else if (inArray)
      writeNull(name);
  }

  protected void composePositiveIntExtras(String name, PositiveIntType value, boolean inArray) throws IOException {
    if (value != null
        && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || makeComments(value))) {
      open(inArray ? null : "_" + name);
      composeElement(value);
      close();
    } else if (inArray)
      writeNull(name);
  }

  protected void composeStringCore(String name, StringType value, boolean inArray) throws IOException {
    if (value != null && value.hasValue()) {
      prop(name, toString(value.getValue()));
    } else if (inArray)
      writeNull(name);
  }

  protected void composeStringExtras(String name, StringType value, boolean inArray) throws IOException {
    if (value != null
        && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || makeComments(value))) {
      open(inArray ? null : "_" + name);
      composeElement(value);
      close();
    } else if (inArray)
      writeNull(name);
  }

  protected void composeBooleanCore(String name, BooleanType value, boolean inArray) throws IOException {
    if (value != null && value.hasValue()) {
      prop(name, value.getValue());
    } else if (inArray)
      writeNull(name);
  }

  protected void composeBooleanExtras(String name, BooleanType value, boolean inArray) throws IOException {
    if (value != null
        && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || makeComments(value))) {
      open(inArray ? null : "_" + name);
      composeElement(value);
      close();
    } else if (inArray)
      writeNull(name);
  }

  protected void composeUuidCore(String name, UuidType value, boolean inArray) throws IOException {
    if (value != null && value.hasValue()) {
      prop(name, toString(value.getValue()));
    } else if (inArray)
      writeNull(name);
  }

  protected void composeUuidExtras(String name, UuidType value, boolean inArray) throws IOException {
    if (value != null
        && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || makeComments(value))) {
      open(inArray ? null : "_" + name);
      composeElement(value);
      close();
    } else if (inArray)
      writeNull(name);
  }

  protected void composeInstantCore(String name, InstantType value, boolean inArray) throws IOException {
    if (value != null && value.hasValue()) {
      prop(name, value.asStringValue());
    } else if (inArray)
      writeNull(name);
  }

  protected void composeInstantExtras(String name, InstantType value, boolean inArray) throws IOException {
    if (value != null
        && (!Utilities.noString(value.getId()) || ExtensionHelper.hasExtensions(value) || makeComments(value))) {
      open(inArray ? null : "_" + name);
      composeElement(value);
      close();
    } else if (inArray)
      writeNull(name);
  }

  protected void composeExtension(String name, Extension element) throws IOException {
    if (element != null) {
      open(name);
      composeExtensionInner(element);
      close();
    }
  }

  protected void composeExtensionInner(Extension element) throws IOException {
    composeElement(element);
    if (element.hasUrlElement()) {
      composeUriCore("url", element.getUrlElement(), false);
      composeUriExtras("url", element.getUrlElement(), false);
    }
    if (element.hasValue()) {
      composeType("value", element.getValue());
    }
  }

  protected void composeNarrative(String name, Narrative element) throws IOException {
    if (element != null) {
      open(name);
      composeNarrativeInner(element);
      close();
    }
  }

  protected void composeNarrativeInner(Narrative element) throws IOException {
    composeElement(element);
    if (element.hasStatusElement()) {
      composeEnumerationCore("status", element.getStatusElement(), new Narrative.NarrativeStatusEnumFactory(), false);
      composeEnumerationExtras("status", element.getStatusElement(), new Narrative.NarrativeStatusEnumFactory(), false);
    }
    if (element.hasDiv()) {
      XhtmlNode node = element.getDiv();
      if (node.getNsDecl() == null) {
        node.attribute("xmlns", XHTML_NS);
      }
      composeXhtml("div", node);
    }
  }

  protected void composePeriod(String name, Period element) throws IOException {
    if (element != null) {
      open(name);
      composePeriodInner(element);
      close();
    }
  }

  protected void composePeriodInner(Period element) throws IOException {
    composeElement(element);
    if (element.hasStartElement()) {
      composeDateTimeCore("start", element.getStartElement(), false);
      composeDateTimeExtras("start", element.getStartElement(), false);
    }
    if (element.hasEndElement()) {
      composeDateTimeCore("end", element.getEndElement(), false);
      composeDateTimeExtras("end", element.getEndElement(), false);
    }
  }

  protected void composeCoding(String name, Coding element) throws IOException {
    if (element != null) {
      open(name);
      composeCodingInner(element);
      close();
    }
  }

  protected void composeCodingInner(Coding element) throws IOException {
    composeElement(element);
    if (element.hasSystemElement()) {
      composeUriCore("system", element.getSystemElement(), false);
      composeUriExtras("system", element.getSystemElement(), false);
    }
    if (element.hasVersionElement()) {
      composeStringCore("version", element.getVersionElement(), false);
      composeStringExtras("version", element.getVersionElement(), false);
    }
    if (element.hasCodeElement()) {
      composeCodeCore("code", element.getCodeElement(), false);
      composeCodeExtras("code", element.getCodeElement(), false);
    }
    if (element.hasDisplayElement()) {
      composeStringCore("display", element.getDisplayElement(), false);
      composeStringExtras("display", element.getDisplayElement(), false);
    }
    if (element.hasUserSelectedElement()) {
      composeBooleanCore("userSelected", element.getUserSelectedElement(), false);
      composeBooleanExtras("userSelected", element.getUserSelectedElement(), false);
    }
  }

  protected void composeRange(String name, Range element) throws IOException {
    if (element != null) {
      open(name);
      composeRangeInner(element);
      close();
    }
  }

  protected void composeRangeInner(Range element) throws IOException {
    composeElement(element);
    if (element.hasLow()) {
      composeSimpleQuantity("low", element.getLow());
    }
    if (element.hasHigh()) {
      composeSimpleQuantity("high", element.getHigh());
    }
  }

  protected void composeQuantity(String name, Quantity element) throws IOException {
    if (element != null) {
      open(name);
      composeQuantityInner(element);
      close();
    }
  }

  protected void composeQuantityInner(Quantity element) throws IOException {
    composeElement(element);
    if (element.hasValueElement()) {
      composeDecimalCore("value", element.getValueElement(), false);
      composeDecimalExtras("value", element.getValueElement(), false);
    }
    if (element.hasComparatorElement()) {
      composeEnumerationCore("comparator", element.getComparatorElement(), new Quantity.QuantityComparatorEnumFactory(),
          false);
      composeEnumerationExtras("comparator", element.getComparatorElement(),
          new Quantity.QuantityComparatorEnumFactory(), false);
    }
    if (element.hasUnitElement()) {
      composeStringCore("unit", element.getUnitElement(), false);
      composeStringExtras("unit", element.getUnitElement(), false);
    }
    if (element.hasSystemElement()) {
      composeUriCore("system", element.getSystemElement(), false);
      composeUriExtras("system", element.getSystemElement(), false);
    }
    if (element.hasCodeElement()) {
      composeCodeCore("code", element.getCodeElement(), false);
      composeCodeExtras("code", element.getCodeElement(), false);
    }
  }

  protected void composeAttachment(String name, Attachment element) throws IOException {
    if (element != null) {
      open(name);
      composeAttachmentInner(element);
      close();
    }
  }

  protected void composeAttachmentInner(Attachment element) throws IOException {
    composeElement(element);
    if (element.hasContentTypeElement()) {
      composeCodeCore("contentType", element.getContentTypeElement(), false);
      composeCodeExtras("contentType", element.getContentTypeElement(), false);
    }
    if (element.hasLanguageElement()) {
      composeCodeCore("language", element.getLanguageElement(), false);
      composeCodeExtras("language", element.getLanguageElement(), false);
    }
    if (element.hasDataElement()) {
      composeBase64BinaryCore("data", element.getDataElement(), false);
      composeBase64BinaryExtras("data", element.getDataElement(), false);
    }
    if (element.hasUrlElement()) {
      composeUriCore("url", element.getUrlElement(), false);
      composeUriExtras("url", element.getUrlElement(), false);
    }
    if (element.hasSizeElement()) {
      composeUnsignedIntCore("size", element.getSizeElement(), false);
      composeUnsignedIntExtras("size", element.getSizeElement(), false);
    }
    if (element.hasHashElement()) {
      composeBase64BinaryCore("hash", element.getHashElement(), false);
      composeBase64BinaryExtras("hash", element.getHashElement(), false);
    }
    if (element.hasTitleElement()) {
      composeStringCore("title", element.getTitleElement(), false);
      composeStringExtras("title", element.getTitleElement(), false);
    }
    if (element.hasCreationElement()) {
      composeDateTimeCore("creation", element.getCreationElement(), false);
      composeDateTimeExtras("creation", element.getCreationElement(), false);
    }
  }

  protected void composeRatio(String name, Ratio element) throws IOException {
    if (element != null) {
      open(name);
      composeRatioInner(element);
      close();
    }
  }

  protected void composeRatioInner(Ratio element) throws IOException {
    composeElement(element);
    if (element.hasNumerator()) {
      composeQuantity("numerator", element.getNumerator());
    }
    if (element.hasDenominator()) {
      composeQuantity("denominator", element.getDenominator());
    }
  }

  protected void composeAnnotation(String name, Annotation element) throws IOException {
    if (element != null) {
      open(name);
      composeAnnotationInner(element);
      close();
    }
  }

  protected void composeAnnotationInner(Annotation element) throws IOException {
    composeElement(element);
    if (element.hasAuthor()) {
      composeType("author", element.getAuthor());
    }
    if (element.hasTimeElement()) {
      composeDateTimeCore("time", element.getTimeElement(), false);
      composeDateTimeExtras("time", element.getTimeElement(), false);
    }
    if (element.hasTextElement()) {
      composeStringCore("text", element.getTextElement(), false);
      composeStringExtras("text", element.getTextElement(), false);
    }
  }

  protected void composeSampledData(String name, SampledData element) throws IOException {
    if (element != null) {
      open(name);
      composeSampledDataInner(element);
      close();
    }
  }

  protected void composeSampledDataInner(SampledData element) throws IOException {
    composeElement(element);
    if (element.hasOrigin()) {
      composeSimpleQuantity("origin", element.getOrigin());
    }
    if (element.hasPeriodElement()) {
      composeDecimalCore("period", element.getPeriodElement(), false);
      composeDecimalExtras("period", element.getPeriodElement(), false);
    }
    if (element.hasFactorElement()) {
      composeDecimalCore("factor", element.getFactorElement(), false);
      composeDecimalExtras("factor", element.getFactorElement(), false);
    }
    if (element.hasLowerLimitElement()) {
      composeDecimalCore("lowerLimit", element.getLowerLimitElement(), false);
      composeDecimalExtras("lowerLimit", element.getLowerLimitElement(), false);
    }
    if (element.hasUpperLimitElement()) {
      composeDecimalCore("upperLimit", element.getUpperLimitElement(), false);
      composeDecimalExtras("upperLimit", element.getUpperLimitElement(), false);
    }
    if (element.hasDimensionsElement()) {
      composePositiveIntCore("dimensions", element.getDimensionsElement(), false);
      composePositiveIntExtras("dimensions", element.getDimensionsElement(), false);
    }
    if (element.hasDataElement()) {
      composeStringCore("data", element.getDataElement(), false);
      composeStringExtras("data", element.getDataElement(), false);
    }
  }

  protected void composeReference(String name, Reference element) throws IOException {
    if (element != null) {
      open(name);
      composeReferenceInner(element);
      close();
    }
  }

  protected void composeReferenceInner(Reference element) throws IOException {
    composeElement(element);
    if (element.hasReferenceElement()) {
      composeStringCore("reference", element.getReferenceElement(), false);
      composeStringExtras("reference", element.getReferenceElement(), false);
    }
    if (element.hasDisplayElement()) {
      composeStringCore("display", element.getDisplayElement(), false);
      composeStringExtras("display", element.getDisplayElement(), false);
    }
  }

  protected void composeCodeableConcept(String name, CodeableConcept element) throws IOException {
    if (element != null) {
      open(name);
      composeCodeableConceptInner(element);
      close();
    }
  }

  protected void composeCodeableConceptInner(CodeableConcept element) throws IOException {
    composeElement(element);
    if (element.hasCoding()) {
      openArray("coding");
      for (Coding e : element.getCoding())
        composeCoding(null, e);
      closeArray();
    }
    ;
    if (element.hasTextElement()) {
      composeStringCore("text", element.getTextElement(), false);
      composeStringExtras("text", element.getTextElement(), false);
    }
  }

  protected void composeIdentifier(String name, Identifier element) throws IOException {
    if (element != null) {
      open(name);
      composeIdentifierInner(element);
      close();
    }
  }

  protected void composeIdentifierInner(Identifier element) throws IOException {
    composeElement(element);
    if (element.hasUseElement()) {
      composeEnumerationCore("use", element.getUseElement(), new Identifier.IdentifierUseEnumFactory(), false);
      composeEnumerationExtras("use", element.getUseElement(), new Identifier.IdentifierUseEnumFactory(), false);
    }
    if (element.hasType()) {
      composeCodeableConcept("type", element.getType());
    }
    if (element.hasSystemElement()) {
      composeUriCore("system", element.getSystemElement(), false);
      composeUriExtras("system", element.getSystemElement(), false);
    }
    if (element.hasValueElement()) {
      composeStringCore("value", element.getValueElement(), false);
      composeStringExtras("value", element.getValueElement(), false);
    }
    if (element.hasPeriod()) {
      composePeriod("period", element.getPeriod());
    }
    if (element.hasAssigner()) {
      composeReference("assigner", element.getAssigner());
    }
  }

  protected void composeSignature(String name, Signature element) throws IOException {
    if (element != null) {
      open(name);
      composeSignatureInner(element);
      close();
    }
  }

  protected void composeSignatureInner(Signature element) throws IOException {
    composeElement(element);
    if (element.hasType()) {
      openArray("type");
      for (Coding e : element.getType())
        composeCoding(null, e);
      closeArray();
    }
    ;
    if (element.hasWhenElement()) {
      composeInstantCore("when", element.getWhenElement(), false);
      composeInstantExtras("when", element.getWhenElement(), false);
    }
    if (element.hasWho()) {
      composeType("who", element.getWho());
    }
    if (element.hasContentTypeElement()) {
      composeCodeCore("contentType", element.getContentTypeElement(), false);
      composeCodeExtras("contentType", element.getContentTypeElement(), false);
    }
    if (element.hasBlobElement()) {
      composeBase64BinaryCore("blob", element.getBlobElement(), false);
      composeBase64BinaryExtras("blob", element.getBlobElement(), false);
    }
  }

  protected void composeAge(String name, Age element) throws IOException {
    if (element != null) {
      open(name);
      composeAgeInner(element);
      close();
    }
  }

  protected void composeAgeInner(Age element) throws IOException {
    composeElement(element);
    if (element.hasValueElement()) {
      composeDecimalCore("value", element.getValueElement(), false);
      composeDecimalExtras("value", element.getValueElement(), false);
    }
    if (element.hasComparatorElement()) {
      composeEnumerationCore("comparator", element.getComparatorElement(), new Age.QuantityComparatorEnumFactory(),
          false);
      composeEnumerationExtras("comparator", element.getComparatorElement(), new Age.QuantityComparatorEnumFactory(),
          false);
    }
    if (element.hasUnitElement()) {
      composeStringCore("unit", element.getUnitElement(), false);
      composeStringExtras("unit", element.getUnitElement(), false);
    }
    if (element.hasSystemElement()) {
      composeUriCore("system", element.getSystemElement(), false);
      composeUriExtras("system", element.getSystemElement(), false);
    }
    if (element.hasCodeElement()) {
      composeCodeCore("code", element.getCodeElement(), false);
      composeCodeExtras("code", element.getCodeElement(), false);
    }
  }

  protected void composeCount(String name, Count element) throws IOException {
    if (element != null) {
      open(name);
      composeCountInner(element);
      close();
    }
  }

  protected void composeCountInner(Count element) throws IOException {
    composeElement(element);
    if (element.hasValueElement()) {
      composeDecimalCore("value", element.getValueElement(), false);
      composeDecimalExtras("value", element.getValueElement(), false);
    }
    if (element.hasComparatorElement()) {
      composeEnumerationCore("comparator", element.getComparatorElement(), new Count.QuantityComparatorEnumFactory(),
          false);
      composeEnumerationExtras("comparator", element.getComparatorElement(), new Count.QuantityComparatorEnumFactory(),
          false);
    }
    if (element.hasUnitElement()) {
      composeStringCore("unit", element.getUnitElement(), false);
      composeStringExtras("unit", element.getUnitElement(), false);
    }
    if (element.hasSystemElement()) {
      composeUriCore("system", element.getSystemElement(), false);
      composeUriExtras("system", element.getSystemElement(), false);
    }
    if (element.hasCodeElement()) {
      composeCodeCore("code", element.getCodeElement(), false);
      composeCodeExtras("code", element.getCodeElement(), false);
    }
  }

  protected void composeMoney(String name, Money element) throws IOException {
    if (element != null) {
      open(name);
      composeMoneyInner(element);
      close();
    }
  }

  protected void composeMoneyInner(Money element) throws IOException {
    composeElement(element);
    if (element.hasValueElement()) {
      composeDecimalCore("value", element.getValueElement(), false);
      composeDecimalExtras("value", element.getValueElement(), false);
    }
    if (element.hasComparatorElement()) {
      composeEnumerationCore("comparator", element.getComparatorElement(), new Money.QuantityComparatorEnumFactory(),
          false);
      composeEnumerationExtras("comparator", element.getComparatorElement(), new Money.QuantityComparatorEnumFactory(),
          false);
    }
    if (element.hasUnitElement()) {
      composeStringCore("unit", element.getUnitElement(), false);
      composeStringExtras("unit", element.getUnitElement(), false);
    }
    if (element.hasSystemElement()) {
      composeUriCore("system", element.getSystemElement(), false);
      composeUriExtras("system", element.getSystemElement(), false);
    }
    if (element.hasCodeElement()) {
      composeCodeCore("code", element.getCodeElement(), false);
      composeCodeExtras("code", element.getCodeElement(), false);
    }
  }

  protected void composeDistance(String name, Distance element) throws IOException {
    if (element != null) {
      open(name);
      composeDistanceInner(element);
      close();
    }
  }

  protected void composeDistanceInner(Distance element) throws IOException {
    composeElement(element);
    if (element.hasValueElement()) {
      composeDecimalCore("value", element.getValueElement(), false);
      composeDecimalExtras("value", element.getValueElement(), false);
    }
    if (element.hasComparatorElement()) {
      composeEnumerationCore("comparator", element.getComparatorElement(), new Distance.QuantityComparatorEnumFactory(),
          false);
      composeEnumerationExtras("comparator", element.getComparatorElement(),
          new Distance.QuantityComparatorEnumFactory(), false);
    }
    if (element.hasUnitElement()) {
      composeStringCore("unit", element.getUnitElement(), false);
      composeStringExtras("unit", element.getUnitElement(), false);
    }
    if (element.hasSystemElement()) {
      composeUriCore("system", element.getSystemElement(), false);
      composeUriExtras("system", element.getSystemElement(), false);
    }
    if (element.hasCodeElement()) {
      composeCodeCore("code", element.getCodeElement(), false);
      composeCodeExtras("code", element.getCodeElement(), false);
    }
  }

  protected void composeDuration(String name, Duration element) throws IOException {
    if (element != null) {
      open(name);
      composeDurationInner(element);
      close();
    }
  }

  protected void composeDurationInner(Duration element) throws IOException {
    composeElement(element);
    if (element.hasValueElement()) {
      composeDecimalCore("value", element.getValueElement(), false);
      composeDecimalExtras("value", element.getValueElement(), false);
    }
    if (element.hasComparatorElement()) {
      composeEnumerationCore("comparator", element.getComparatorElement(), new Duration.QuantityComparatorEnumFactory(),
          false);
      composeEnumerationExtras("comparator", element.getComparatorElement(),
          new Duration.QuantityComparatorEnumFactory(), false);
    }
    if (element.hasUnitElement()) {
      composeStringCore("unit", element.getUnitElement(), false);
      composeStringExtras("unit", element.getUnitElement(), false);
    }
    if (element.hasSystemElement()) {
      composeUriCore("system", element.getSystemElement(), false);
      composeUriExtras("system", element.getSystemElement(), false);
    }
    if (element.hasCodeElement()) {
      composeCodeCore("code", element.getCodeElement(), false);
      composeCodeExtras("code", element.getCodeElement(), false);
    }
  }

  protected void composeSimpleQuantity(String name, SimpleQuantity element) throws IOException {
    if (element != null) {
      open(name);
      composeSimpleQuantityInner(element);
      close();
    }
  }

  protected void composeSimpleQuantityInner(SimpleQuantity element) throws IOException {
    composeElement(element);
    if (element.hasValueElement()) {
      composeDecimalCore("value", element.getValueElement(), false);
      composeDecimalExtras("value", element.getValueElement(), false);
    }
    if (element.hasComparatorElement()) {
      composeEnumerationCore("comparator", element.getComparatorElement(),
          new SimpleQuantity.QuantityComparatorEnumFactory(), false);
      composeEnumerationExtras("comparator", element.getComparatorElement(),
          new SimpleQuantity.QuantityComparatorEnumFactory(), false);
    }
    if (element.hasUnitElement()) {
      composeStringCore("unit", element.getUnitElement(), false);
      composeStringExtras("unit", element.getUnitElement(), false);
    }
    if (element.hasSystemElement()) {
      composeUriCore("system", element.getSystemElement(), false);
      composeUriExtras("system", element.getSystemElement(), false);
    }
    if (element.hasCodeElement()) {
      composeCodeCore("code", element.getCodeElement(), false);
      composeCodeExtras("code", element.getCodeElement(), false);
    }
  }

  protected void composeTriggerDefinition(String name, TriggerDefinition element) throws IOException {
    if (element != null) {
      open(name);
      composeTriggerDefinitionInner(element);
      close();
    }
  }

  protected void composeTriggerDefinitionInner(TriggerDefinition element) throws IOException {
    composeElement(element);
    if (element.hasTypeElement()) {
      composeEnumerationCore("type", element.getTypeElement(), new TriggerDefinition.TriggerTypeEnumFactory(), false);
      composeEnumerationExtras("type", element.getTypeElement(), new TriggerDefinition.TriggerTypeEnumFactory(), false);
    }
    if (element.hasEventNameElement()) {
      composeStringCore("eventName", element.getEventNameElement(), false);
      composeStringExtras("eventName", element.getEventNameElement(), false);
    }
    if (element.hasEventTiming()) {
      composeType("eventTiming", element.getEventTiming());
    }
    if (element.hasEventData()) {
      composeDataRequirement("eventData", element.getEventData());
    }
  }

  protected void composeElementDefinition(String name, ElementDefinition element) throws IOException {
    if (element != null) {
      open(name);
      composeElementDefinitionInner(element);
      close();
    }
  }

  protected void composeElementDefinitionInner(ElementDefinition element) throws IOException {
    composeElement(element);
    if (element.hasPathElement()) {
      composeStringCore("path", element.getPathElement(), false);
      composeStringExtras("path", element.getPathElement(), false);
    }
    if (element.hasRepresentation()) {
      openArray("representation");
      for (Enumeration<ElementDefinition.PropertyRepresentation> e : element.getRepresentation())
        composeEnumerationCore(null, e, new ElementDefinition.PropertyRepresentationEnumFactory(), true);
      closeArray();
      if (anyHasExtras(element.getRepresentation())) {
        openArray("_representation");
        for (Enumeration<ElementDefinition.PropertyRepresentation> e : element.getRepresentation())
          composeEnumerationExtras(null, e, new ElementDefinition.PropertyRepresentationEnumFactory(), true);
        closeArray();
      }
    }
    ;
    if (element.hasNameElement()) {
      composeStringCore("name", element.getNameElement(), false);
      composeStringExtras("name", element.getNameElement(), false);
    }
    if (element.hasLabelElement()) {
      composeStringCore("label", element.getLabelElement(), false);
      composeStringExtras("label", element.getLabelElement(), false);
    }
    if (element.hasCode()) {
      openArray("code");
      for (Coding e : element.getCode())
        composeCoding(null, e);
      closeArray();
    }
    ;
    if (element.hasSlicing()) {
      composeElementDefinitionElementDefinitionSlicingComponent("slicing", element.getSlicing());
    }
    if (element.hasShortElement()) {
      composeStringCore("short", element.getShortElement(), false);
      composeStringExtras("short", element.getShortElement(), false);
    }
    if (element.hasDefinitionElement()) {
      composeMarkdownCore("definition", element.getDefinitionElement(), false);
      composeMarkdownExtras("definition", element.getDefinitionElement(), false);
    }
    if (element.hasCommentsElement()) {
      composeMarkdownCore("comments", element.getCommentsElement(), false);
      composeMarkdownExtras("comments", element.getCommentsElement(), false);
    }
    if (element.hasRequirementsElement()) {
      composeMarkdownCore("requirements", element.getRequirementsElement(), false);
      composeMarkdownExtras("requirements", element.getRequirementsElement(), false);
    }
    if (element.hasAlias()) {
      openArray("alias");
      for (StringType e : element.getAlias())
        composeStringCore(null, e, true);
      closeArray();
      if (anyHasExtras(element.getAlias())) {
        openArray("_alias");
        for (StringType e : element.getAlias())
          composeStringExtras(null, e, true);
        closeArray();
      }
    }
    ;
    if (element.hasMinElement()) {
      composeIntegerCore("min", element.getMinElement(), false);
      composeIntegerExtras("min", element.getMinElement(), false);
    }
    if (element.hasMaxElement()) {
      composeStringCore("max", element.getMaxElement(), false);
      composeStringExtras("max", element.getMaxElement(), false);
    }
    if (element.hasBase()) {
      composeElementDefinitionElementDefinitionBaseComponent("base", element.getBase());
    }
    if (element.hasContentReferenceElement()) {
      composeUriCore("contentReference", element.getContentReferenceElement(), false);
      composeUriExtras("contentReference", element.getContentReferenceElement(), false);
    }
    if (element.hasType()) {
      openArray("type");
      for (ElementDefinition.TypeRefComponent e : element.getType())
        composeElementDefinitionTypeRefComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasDefaultValue()) {
      composeType("defaultValue", element.getDefaultValue());
    }
    if (element.hasMeaningWhenMissingElement()) {
      composeMarkdownCore("meaningWhenMissing", element.getMeaningWhenMissingElement(), false);
      composeMarkdownExtras("meaningWhenMissing", element.getMeaningWhenMissingElement(), false);
    }
    if (element.hasFixed()) {
      composeType("fixed", element.getFixed());
    }
    if (element.hasPattern()) {
      composeType("pattern", element.getPattern());
    }
    if (element.hasExample()) {
      composeType("example", element.getExample());
    }
    if (element.hasMinValue()) {
      composeType("minValue", element.getMinValue());
    }
    if (element.hasMaxValue()) {
      composeType("maxValue", element.getMaxValue());
    }
    if (element.hasMaxLengthElement()) {
      composeIntegerCore("maxLength", element.getMaxLengthElement(), false);
      composeIntegerExtras("maxLength", element.getMaxLengthElement(), false);
    }
    if (element.hasCondition()) {
      openArray("condition");
      for (IdType e : element.getCondition())
        composeIdCore(null, e, true);
      closeArray();
      if (anyHasExtras(element.getCondition())) {
        openArray("_condition");
        for (IdType e : element.getCondition())
          composeIdExtras(null, e, true);
        closeArray();
      }
    }
    ;
    if (element.hasConstraint()) {
      openArray("constraint");
      for (ElementDefinition.ElementDefinitionConstraintComponent e : element.getConstraint())
        composeElementDefinitionElementDefinitionConstraintComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasMustSupportElement()) {
      composeBooleanCore("mustSupport", element.getMustSupportElement(), false);
      composeBooleanExtras("mustSupport", element.getMustSupportElement(), false);
    }
    if (element.hasIsModifierElement()) {
      composeBooleanCore("isModifier", element.getIsModifierElement(), false);
      composeBooleanExtras("isModifier", element.getIsModifierElement(), false);
    }
    if (element.hasIsSummaryElement()) {
      composeBooleanCore("isSummary", element.getIsSummaryElement(), false);
      composeBooleanExtras("isSummary", element.getIsSummaryElement(), false);
    }
    if (element.hasBinding()) {
      composeElementDefinitionElementDefinitionBindingComponent("binding", element.getBinding());
    }
    if (element.hasMapping()) {
      openArray("mapping");
      for (ElementDefinition.ElementDefinitionMappingComponent e : element.getMapping())
        composeElementDefinitionElementDefinitionMappingComponent(null, e);
      closeArray();
    }
    ;
  }

  protected void composeElementDefinitionElementDefinitionSlicingComponent(String name,
      ElementDefinition.ElementDefinitionSlicingComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeElementDefinitionElementDefinitionSlicingComponentInner(element);
      close();
    }
  }

  protected void composeElementDefinitionElementDefinitionSlicingComponentInner(
      ElementDefinition.ElementDefinitionSlicingComponent element) throws IOException {
    composeElement(element);
    if (element.hasDiscriminator()) {
      openArray("discriminator");
      for (StringType e : element.getDiscriminator())
        composeStringCore(null, e, true);
      closeArray();
      if (anyHasExtras(element.getDiscriminator())) {
        openArray("_discriminator");
        for (StringType e : element.getDiscriminator())
          composeStringExtras(null, e, true);
        closeArray();
      }
    }
    ;
    if (element.hasDescriptionElement()) {
      composeStringCore("description", element.getDescriptionElement(), false);
      composeStringExtras("description", element.getDescriptionElement(), false);
    }
    if (element.hasOrderedElement()) {
      composeBooleanCore("ordered", element.getOrderedElement(), false);
      composeBooleanExtras("ordered", element.getOrderedElement(), false);
    }
    if (element.hasRulesElement()) {
      composeEnumerationCore("rules", element.getRulesElement(), new ElementDefinition.SlicingRulesEnumFactory(),
          false);
      composeEnumerationExtras("rules", element.getRulesElement(), new ElementDefinition.SlicingRulesEnumFactory(),
          false);
    }
  }

  protected void composeElementDefinitionElementDefinitionBaseComponent(String name,
      ElementDefinition.ElementDefinitionBaseComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeElementDefinitionElementDefinitionBaseComponentInner(element);
      close();
    }
  }

  protected void composeElementDefinitionElementDefinitionBaseComponentInner(
      ElementDefinition.ElementDefinitionBaseComponent element) throws IOException {
    composeElement(element);
    if (element.hasPathElement()) {
      composeStringCore("path", element.getPathElement(), false);
      composeStringExtras("path", element.getPathElement(), false);
    }
    if (element.hasMinElement()) {
      composeIntegerCore("min", element.getMinElement(), false);
      composeIntegerExtras("min", element.getMinElement(), false);
    }
    if (element.hasMaxElement()) {
      composeStringCore("max", element.getMaxElement(), false);
      composeStringExtras("max", element.getMaxElement(), false);
    }
  }

  protected void composeElementDefinitionTypeRefComponent(String name, ElementDefinition.TypeRefComponent element)
      throws IOException {
    if (element != null) {
      open(name);
      composeElementDefinitionTypeRefComponentInner(element);
      close();
    }
  }

  protected void composeElementDefinitionTypeRefComponentInner(ElementDefinition.TypeRefComponent element)
      throws IOException {
    composeElement(element);
    if (element.hasCodeElement()) {
      composeCodeCore("code", element.getCodeElement(), false);
      composeCodeExtras("code", element.getCodeElement(), false);
    }
    if (element.hasProfile()) {
      openArray("profile");
      for (UriType e : element.getProfile())
        composeUriCore(null, e, true);
      closeArray();
      if (anyHasExtras(element.getProfile())) {
        openArray("_profile");
        for (UriType e : element.getProfile())
          composeUriExtras(null, e, true);
        closeArray();
      }
    }
    ;
    if (element.hasAggregation()) {
      openArray("aggregation");
      for (Enumeration<ElementDefinition.AggregationMode> e : element.getAggregation())
        composeEnumerationCore(null, e, new ElementDefinition.AggregationModeEnumFactory(), true);
      closeArray();
      if (anyHasExtras(element.getAggregation())) {
        openArray("_aggregation");
        for (Enumeration<ElementDefinition.AggregationMode> e : element.getAggregation())
          composeEnumerationExtras(null, e, new ElementDefinition.AggregationModeEnumFactory(), true);
        closeArray();
      }
    }
    ;
    if (element.hasVersioningElement()) {
      composeEnumerationCore("versioning", element.getVersioningElement(),
          new ElementDefinition.ReferenceVersionRulesEnumFactory(), false);
      composeEnumerationExtras("versioning", element.getVersioningElement(),
          new ElementDefinition.ReferenceVersionRulesEnumFactory(), false);
    }
  }

  protected void composeElementDefinitionElementDefinitionConstraintComponent(String name,
      ElementDefinition.ElementDefinitionConstraintComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeElementDefinitionElementDefinitionConstraintComponentInner(element);
      close();
    }
  }

  protected void composeElementDefinitionElementDefinitionConstraintComponentInner(
      ElementDefinition.ElementDefinitionConstraintComponent element) throws IOException {
    composeElement(element);
    if (element.hasKeyElement()) {
      composeIdCore("key", element.getKeyElement(), false);
      composeIdExtras("key", element.getKeyElement(), false);
    }
    if (element.hasRequirementsElement()) {
      composeStringCore("requirements", element.getRequirementsElement(), false);
      composeStringExtras("requirements", element.getRequirementsElement(), false);
    }
    if (element.hasSeverityElement()) {
      composeEnumerationCore("severity", element.getSeverityElement(),
          new ElementDefinition.ConstraintSeverityEnumFactory(), false);
      composeEnumerationExtras("severity", element.getSeverityElement(),
          new ElementDefinition.ConstraintSeverityEnumFactory(), false);
    }
    if (element.hasHumanElement()) {
      composeStringCore("human", element.getHumanElement(), false);
      composeStringExtras("human", element.getHumanElement(), false);
    }
    if (element.hasExpressionElement()) {
      composeStringCore("expression", element.getExpressionElement(), false);
      composeStringExtras("expression", element.getExpressionElement(), false);
    }
    if (element.hasXpathElement()) {
      composeStringCore("xpath", element.getXpathElement(), false);
      composeStringExtras("xpath", element.getXpathElement(), false);
    }
  }

  protected void composeElementDefinitionElementDefinitionBindingComponent(String name,
      ElementDefinition.ElementDefinitionBindingComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeElementDefinitionElementDefinitionBindingComponentInner(element);
      close();
    }
  }

  protected void composeElementDefinitionElementDefinitionBindingComponentInner(
      ElementDefinition.ElementDefinitionBindingComponent element) throws IOException {
    composeElement(element);
    if (element.hasStrengthElement()) {
      composeEnumerationCore("strength", element.getStrengthElement(), new Enumerations.BindingStrengthEnumFactory(),
          false);
      composeEnumerationExtras("strength", element.getStrengthElement(), new Enumerations.BindingStrengthEnumFactory(),
          false);
    }
    if (element.hasDescriptionElement()) {
      composeStringCore("description", element.getDescriptionElement(), false);
      composeStringExtras("description", element.getDescriptionElement(), false);
    }
    if (element.hasValueSet()) {
      composeType("valueSet", element.getValueSet());
    }
  }

  protected void composeElementDefinitionElementDefinitionMappingComponent(String name,
      ElementDefinition.ElementDefinitionMappingComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeElementDefinitionElementDefinitionMappingComponentInner(element);
      close();
    }
  }

  protected void composeElementDefinitionElementDefinitionMappingComponentInner(
      ElementDefinition.ElementDefinitionMappingComponent element) throws IOException {
    composeElement(element);
    if (element.hasIdentityElement()) {
      composeIdCore("identity", element.getIdentityElement(), false);
      composeIdExtras("identity", element.getIdentityElement(), false);
    }
    if (element.hasLanguageElement()) {
      composeCodeCore("language", element.getLanguageElement(), false);
      composeCodeExtras("language", element.getLanguageElement(), false);
    }
    if (element.hasMapElement()) {
      composeStringCore("map", element.getMapElement(), false);
      composeStringExtras("map", element.getMapElement(), false);
    }
  }

  protected void composeTiming(String name, Timing element) throws IOException {
    if (element != null) {
      open(name);
      composeTimingInner(element);
      close();
    }
  }

  protected void composeTimingInner(Timing element) throws IOException {
    composeElement(element);
    if (element.hasEvent()) {
      openArray("event");
      for (DateTimeType e : element.getEvent())
        composeDateTimeCore(null, e, true);
      closeArray();
      if (anyHasExtras(element.getEvent())) {
        openArray("_event");
        for (DateTimeType e : element.getEvent())
          composeDateTimeExtras(null, e, true);
        closeArray();
      }
    }
    ;
    if (element.hasRepeat()) {
      composeTimingTimingRepeatComponent("repeat", element.getRepeat());
    }
    if (element.hasCode()) {
      composeCodeableConcept("code", element.getCode());
    }
  }

  protected void composeTimingTimingRepeatComponent(String name, Timing.TimingRepeatComponent element)
      throws IOException {
    if (element != null) {
      open(name);
      composeTimingTimingRepeatComponentInner(element);
      close();
    }
  }

  protected void composeTimingTimingRepeatComponentInner(Timing.TimingRepeatComponent element) throws IOException {
    composeElement(element);
    if (element.hasBounds()) {
      composeType("bounds", element.getBounds());
    }
    if (element.hasCountElement()) {
      composeIntegerCore("count", element.getCountElement(), false);
      composeIntegerExtras("count", element.getCountElement(), false);
    }
    if (element.hasCountMaxElement()) {
      composeIntegerCore("countMax", element.getCountMaxElement(), false);
      composeIntegerExtras("countMax", element.getCountMaxElement(), false);
    }
    if (element.hasDurationElement()) {
      composeDecimalCore("duration", element.getDurationElement(), false);
      composeDecimalExtras("duration", element.getDurationElement(), false);
    }
    if (element.hasDurationMaxElement()) {
      composeDecimalCore("durationMax", element.getDurationMaxElement(), false);
      composeDecimalExtras("durationMax", element.getDurationMaxElement(), false);
    }
    if (element.hasDurationUnitElement()) {
      composeEnumerationCore("durationUnit", element.getDurationUnitElement(), new Timing.UnitsOfTimeEnumFactory(),
          false);
      composeEnumerationExtras("durationUnit", element.getDurationUnitElement(), new Timing.UnitsOfTimeEnumFactory(),
          false);
    }
    if (element.hasFrequencyElement()) {
      composeIntegerCore("frequency", element.getFrequencyElement(), false);
      composeIntegerExtras("frequency", element.getFrequencyElement(), false);
    }
    if (element.hasFrequencyMaxElement()) {
      composeIntegerCore("frequencyMax", element.getFrequencyMaxElement(), false);
      composeIntegerExtras("frequencyMax", element.getFrequencyMaxElement(), false);
    }
    if (element.hasPeriodElement()) {
      composeDecimalCore("period", element.getPeriodElement(), false);
      composeDecimalExtras("period", element.getPeriodElement(), false);
    }
    if (element.hasPeriodMaxElement()) {
      composeDecimalCore("periodMax", element.getPeriodMaxElement(), false);
      composeDecimalExtras("periodMax", element.getPeriodMaxElement(), false);
    }
    if (element.hasPeriodUnitElement()) {
      composeEnumerationCore("periodUnit", element.getPeriodUnitElement(), new Timing.UnitsOfTimeEnumFactory(), false);
      composeEnumerationExtras("periodUnit", element.getPeriodUnitElement(), new Timing.UnitsOfTimeEnumFactory(),
          false);
    }
    if (element.hasWhenElement()) {
      composeEnumerationCore("when", element.getWhenElement(), new Timing.EventTimingEnumFactory(), false);
      composeEnumerationExtras("when", element.getWhenElement(), new Timing.EventTimingEnumFactory(), false);
    }
    if (element.hasOffsetElement()) {
      composeUnsignedIntCore("offset", element.getOffsetElement(), false);
      composeUnsignedIntExtras("offset", element.getOffsetElement(), false);
    }
  }

  protected void composeModuleMetadata(String name, ModuleMetadata element) throws IOException {
    if (element != null) {
      open(name);
      composeModuleMetadataInner(element);
      close();
    }
  }

  protected void composeModuleMetadataInner(ModuleMetadata element) throws IOException {
    composeElement(element);
    if (element.hasUrlElement()) {
      composeUriCore("url", element.getUrlElement(), false);
      composeUriExtras("url", element.getUrlElement(), false);
    }
    if (element.hasIdentifier()) {
      openArray("identifier");
      for (Identifier e : element.getIdentifier())
        composeIdentifier(null, e);
      closeArray();
    }
    ;
    if (element.hasVersionElement()) {
      composeStringCore("version", element.getVersionElement(), false);
      composeStringExtras("version", element.getVersionElement(), false);
    }
    if (element.hasNameElement()) {
      composeStringCore("name", element.getNameElement(), false);
      composeStringExtras("name", element.getNameElement(), false);
    }
    if (element.hasTitleElement()) {
      composeStringCore("title", element.getTitleElement(), false);
      composeStringExtras("title", element.getTitleElement(), false);
    }
    if (element.hasTypeElement()) {
      composeEnumerationCore("type", element.getTypeElement(), new ModuleMetadata.ModuleMetadataTypeEnumFactory(),
          false);
      composeEnumerationExtras("type", element.getTypeElement(), new ModuleMetadata.ModuleMetadataTypeEnumFactory(),
          false);
    }
    if (element.hasStatusElement()) {
      composeEnumerationCore("status", element.getStatusElement(), new ModuleMetadata.ModuleMetadataStatusEnumFactory(),
          false);
      composeEnumerationExtras("status", element.getStatusElement(),
          new ModuleMetadata.ModuleMetadataStatusEnumFactory(), false);
    }
    if (element.hasExperimentalElement()) {
      composeBooleanCore("experimental", element.getExperimentalElement(), false);
      composeBooleanExtras("experimental", element.getExperimentalElement(), false);
    }
    if (element.hasDescriptionElement()) {
      composeStringCore("description", element.getDescriptionElement(), false);
      composeStringExtras("description", element.getDescriptionElement(), false);
    }
    if (element.hasPurposeElement()) {
      composeStringCore("purpose", element.getPurposeElement(), false);
      composeStringExtras("purpose", element.getPurposeElement(), false);
    }
    if (element.hasUsageElement()) {
      composeStringCore("usage", element.getUsageElement(), false);
      composeStringExtras("usage", element.getUsageElement(), false);
    }
    if (element.hasPublicationDateElement()) {
      composeDateCore("publicationDate", element.getPublicationDateElement(), false);
      composeDateExtras("publicationDate", element.getPublicationDateElement(), false);
    }
    if (element.hasLastReviewDateElement()) {
      composeDateCore("lastReviewDate", element.getLastReviewDateElement(), false);
      composeDateExtras("lastReviewDate", element.getLastReviewDateElement(), false);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod("effectivePeriod", element.getEffectivePeriod());
    }
    if (element.hasCoverage()) {
      openArray("coverage");
      for (ModuleMetadata.ModuleMetadataCoverageComponent e : element.getCoverage())
        composeModuleMetadataModuleMetadataCoverageComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasTopic()) {
      openArray("topic");
      for (CodeableConcept e : element.getTopic())
        composeCodeableConcept(null, e);
      closeArray();
    }
    ;
    if (element.hasContributor()) {
      openArray("contributor");
      for (ModuleMetadata.ModuleMetadataContributorComponent e : element.getContributor())
        composeModuleMetadataModuleMetadataContributorComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasPublisherElement()) {
      composeStringCore("publisher", element.getPublisherElement(), false);
      composeStringExtras("publisher", element.getPublisherElement(), false);
    }
    if (element.hasContact()) {
      openArray("contact");
      for (ModuleMetadata.ModuleMetadataContactComponent e : element.getContact())
        composeModuleMetadataModuleMetadataContactComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasCopyrightElement()) {
      composeStringCore("copyright", element.getCopyrightElement(), false);
      composeStringExtras("copyright", element.getCopyrightElement(), false);
    }
    if (element.hasRelatedResource()) {
      openArray("relatedResource");
      for (ModuleMetadata.ModuleMetadataRelatedResourceComponent e : element.getRelatedResource())
        composeModuleMetadataModuleMetadataRelatedResourceComponent(null, e);
      closeArray();
    }
    ;
  }

  protected void composeModuleMetadataModuleMetadataCoverageComponent(String name,
      ModuleMetadata.ModuleMetadataCoverageComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeModuleMetadataModuleMetadataCoverageComponentInner(element);
      close();
    }
  }

  protected void composeModuleMetadataModuleMetadataCoverageComponentInner(
      ModuleMetadata.ModuleMetadataCoverageComponent element) throws IOException {
    composeElement(element);
    if (element.hasFocus()) {
      composeCoding("focus", element.getFocus());
    }
    if (element.hasValue()) {
      composeCodeableConcept("value", element.getValue());
    }
  }

  protected void composeModuleMetadataModuleMetadataContributorComponent(String name,
      ModuleMetadata.ModuleMetadataContributorComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeModuleMetadataModuleMetadataContributorComponentInner(element);
      close();
    }
  }

  protected void composeModuleMetadataModuleMetadataContributorComponentInner(
      ModuleMetadata.ModuleMetadataContributorComponent element) throws IOException {
    composeElement(element);
    if (element.hasTypeElement()) {
      composeEnumerationCore("type", element.getTypeElement(),
          new ModuleMetadata.ModuleMetadataContributorTypeEnumFactory(), false);
      composeEnumerationExtras("type", element.getTypeElement(),
          new ModuleMetadata.ModuleMetadataContributorTypeEnumFactory(), false);
    }
    if (element.hasNameElement()) {
      composeStringCore("name", element.getNameElement(), false);
      composeStringExtras("name", element.getNameElement(), false);
    }
    if (element.hasContact()) {
      openArray("contact");
      for (ModuleMetadata.ModuleMetadataContributorContactComponent e : element.getContact())
        composeModuleMetadataModuleMetadataContributorContactComponent(null, e);
      closeArray();
    }
    ;
  }

  protected void composeModuleMetadataModuleMetadataContributorContactComponent(String name,
      ModuleMetadata.ModuleMetadataContributorContactComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeModuleMetadataModuleMetadataContributorContactComponentInner(element);
      close();
    }
  }

  protected void composeModuleMetadataModuleMetadataContributorContactComponentInner(
      ModuleMetadata.ModuleMetadataContributorContactComponent element) throws IOException {
    composeElement(element);
    if (element.hasNameElement()) {
      composeStringCore("name", element.getNameElement(), false);
      composeStringExtras("name", element.getNameElement(), false);
    }
    if (element.hasTelecom()) {
      openArray("telecom");
      for (ContactPoint e : element.getTelecom())
        composeContactPoint(null, e);
      closeArray();
    }
    ;
  }

  protected void composeModuleMetadataModuleMetadataContactComponent(String name,
      ModuleMetadata.ModuleMetadataContactComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeModuleMetadataModuleMetadataContactComponentInner(element);
      close();
    }
  }

  protected void composeModuleMetadataModuleMetadataContactComponentInner(
      ModuleMetadata.ModuleMetadataContactComponent element) throws IOException {
    composeElement(element);
    if (element.hasNameElement()) {
      composeStringCore("name", element.getNameElement(), false);
      composeStringExtras("name", element.getNameElement(), false);
    }
    if (element.hasTelecom()) {
      openArray("telecom");
      for (ContactPoint e : element.getTelecom())
        composeContactPoint(null, e);
      closeArray();
    }
    ;
  }

  protected void composeModuleMetadataModuleMetadataRelatedResourceComponent(String name,
      ModuleMetadata.ModuleMetadataRelatedResourceComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeModuleMetadataModuleMetadataRelatedResourceComponentInner(element);
      close();
    }
  }

  protected void composeModuleMetadataModuleMetadataRelatedResourceComponentInner(
      ModuleMetadata.ModuleMetadataRelatedResourceComponent element) throws IOException {
    composeElement(element);
    if (element.hasTypeElement()) {
      composeEnumerationCore("type", element.getTypeElement(),
          new ModuleMetadata.ModuleMetadataResourceTypeEnumFactory(), false);
      composeEnumerationExtras("type", element.getTypeElement(),
          new ModuleMetadata.ModuleMetadataResourceTypeEnumFactory(), false);
    }
    if (element.hasDocument()) {
      composeAttachment("document", element.getDocument());
    }
    if (element.hasResource()) {
      composeReference("resource", element.getResource());
    }
  }

  protected void composeActionDefinition(String name, ActionDefinition element) throws IOException {
    if (element != null) {
      open(name);
      composeActionDefinitionInner(element);
      close();
    }
  }

  protected void composeActionDefinitionInner(ActionDefinition element) throws IOException {
    composeElement(element);
    if (element.hasActionIdentifier()) {
      composeIdentifier("actionIdentifier", element.getActionIdentifier());
    }
    if (element.hasLabelElement()) {
      composeStringCore("label", element.getLabelElement(), false);
      composeStringExtras("label", element.getLabelElement(), false);
    }
    if (element.hasTitleElement()) {
      composeStringCore("title", element.getTitleElement(), false);
      composeStringExtras("title", element.getTitleElement(), false);
    }
    if (element.hasDescriptionElement()) {
      composeStringCore("description", element.getDescriptionElement(), false);
      composeStringExtras("description", element.getDescriptionElement(), false);
    }
    if (element.hasTextEquivalentElement()) {
      composeStringCore("textEquivalent", element.getTextEquivalentElement(), false);
      composeStringExtras("textEquivalent", element.getTextEquivalentElement(), false);
    }
    if (element.hasConcept()) {
      openArray("concept");
      for (CodeableConcept e : element.getConcept())
        composeCodeableConcept(null, e);
      closeArray();
    }
    ;
    if (element.hasSupportingEvidence()) {
      openArray("supportingEvidence");
      for (Attachment e : element.getSupportingEvidence())
        composeAttachment(null, e);
      closeArray();
    }
    ;
    if (element.hasDocumentation()) {
      openArray("documentation");
      for (Attachment e : element.getDocumentation())
        composeAttachment(null, e);
      closeArray();
    }
    ;
    if (element.hasRelatedAction()) {
      composeActionDefinitionActionDefinitionRelatedActionComponent("relatedAction", element.getRelatedAction());
    }
    if (element.hasParticipantType()) {
      openArray("participantType");
      for (Enumeration<ActionDefinition.ParticipantType> e : element.getParticipantType())
        composeEnumerationCore(null, e, new ActionDefinition.ParticipantTypeEnumFactory(), true);
      closeArray();
      if (anyHasExtras(element.getParticipantType())) {
        openArray("_participantType");
        for (Enumeration<ActionDefinition.ParticipantType> e : element.getParticipantType())
          composeEnumerationExtras(null, e, new ActionDefinition.ParticipantTypeEnumFactory(), true);
        closeArray();
      }
    }
    ;
    if (element.hasTypeElement()) {
      composeEnumerationCore("type", element.getTypeElement(), new ActionDefinition.ActionTypeEnumFactory(), false);
      composeEnumerationExtras("type", element.getTypeElement(), new ActionDefinition.ActionTypeEnumFactory(), false);
    }
    if (element.hasBehavior()) {
      openArray("behavior");
      for (ActionDefinition.ActionDefinitionBehaviorComponent e : element.getBehavior())
        composeActionDefinitionActionDefinitionBehaviorComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasResource()) {
      composeReference("resource", element.getResource());
    }
    if (element.hasCustomization()) {
      openArray("customization");
      for (ActionDefinition.ActionDefinitionCustomizationComponent e : element.getCustomization())
        composeActionDefinitionActionDefinitionCustomizationComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasAction()) {
      openArray("action");
      for (ActionDefinition e : element.getAction())
        composeActionDefinition(null, e);
      closeArray();
    }
    ;
  }

  protected void composeActionDefinitionActionDefinitionRelatedActionComponent(String name,
      ActionDefinition.ActionDefinitionRelatedActionComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeActionDefinitionActionDefinitionRelatedActionComponentInner(element);
      close();
    }
  }

  protected void composeActionDefinitionActionDefinitionRelatedActionComponentInner(
      ActionDefinition.ActionDefinitionRelatedActionComponent element) throws IOException {
    composeElement(element);
    if (element.hasActionIdentifier()) {
      composeIdentifier("actionIdentifier", element.getActionIdentifier());
    }
    if (element.hasRelationshipElement()) {
      composeEnumerationCore("relationship", element.getRelationshipElement(),
          new ActionDefinition.ActionRelationshipTypeEnumFactory(), false);
      composeEnumerationExtras("relationship", element.getRelationshipElement(),
          new ActionDefinition.ActionRelationshipTypeEnumFactory(), false);
    }
    if (element.hasOffset()) {
      composeType("offset", element.getOffset());
    }
    if (element.hasAnchorElement()) {
      composeEnumerationCore("anchor", element.getAnchorElement(),
          new ActionDefinition.ActionRelationshipAnchorEnumFactory(), false);
      composeEnumerationExtras("anchor", element.getAnchorElement(),
          new ActionDefinition.ActionRelationshipAnchorEnumFactory(), false);
    }
  }

  protected void composeActionDefinitionActionDefinitionBehaviorComponent(String name,
      ActionDefinition.ActionDefinitionBehaviorComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeActionDefinitionActionDefinitionBehaviorComponentInner(element);
      close();
    }
  }

  protected void composeActionDefinitionActionDefinitionBehaviorComponentInner(
      ActionDefinition.ActionDefinitionBehaviorComponent element) throws IOException {
    composeElement(element);
    if (element.hasType()) {
      composeCoding("type", element.getType());
    }
    if (element.hasValue()) {
      composeCoding("value", element.getValue());
    }
  }

  protected void composeActionDefinitionActionDefinitionCustomizationComponent(String name,
      ActionDefinition.ActionDefinitionCustomizationComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeActionDefinitionActionDefinitionCustomizationComponentInner(element);
      close();
    }
  }

  protected void composeActionDefinitionActionDefinitionCustomizationComponentInner(
      ActionDefinition.ActionDefinitionCustomizationComponent element) throws IOException {
    composeElement(element);
    if (element.hasPathElement()) {
      composeStringCore("path", element.getPathElement(), false);
      composeStringExtras("path", element.getPathElement(), false);
    }
    if (element.hasExpressionElement()) {
      composeStringCore("expression", element.getExpressionElement(), false);
      composeStringExtras("expression", element.getExpressionElement(), false);
    }
  }

  protected void composeAddress(String name, Address element) throws IOException {
    if (element != null) {
      open(name);
      composeAddressInner(element);
      close();
    }
  }

  protected void composeAddressInner(Address element) throws IOException {
    composeElement(element);
    if (element.hasUseElement()) {
      composeEnumerationCore("use", element.getUseElement(), new Address.AddressUseEnumFactory(), false);
      composeEnumerationExtras("use", element.getUseElement(), new Address.AddressUseEnumFactory(), false);
    }
    if (element.hasTypeElement()) {
      composeEnumerationCore("type", element.getTypeElement(), new Address.AddressTypeEnumFactory(), false);
      composeEnumerationExtras("type", element.getTypeElement(), new Address.AddressTypeEnumFactory(), false);
    }
    if (element.hasTextElement()) {
      composeStringCore("text", element.getTextElement(), false);
      composeStringExtras("text", element.getTextElement(), false);
    }
    if (element.hasLine()) {
      openArray("line");
      for (StringType e : element.getLine())
        composeStringCore(null, e, true);
      closeArray();
      if (anyHasExtras(element.getLine())) {
        openArray("_line");
        for (StringType e : element.getLine())
          composeStringExtras(null, e, true);
        closeArray();
      }
    }
    ;
    if (element.hasCityElement()) {
      composeStringCore("city", element.getCityElement(), false);
      composeStringExtras("city", element.getCityElement(), false);
    }
    if (element.hasDistrictElement()) {
      composeStringCore("district", element.getDistrictElement(), false);
      composeStringExtras("district", element.getDistrictElement(), false);
    }
    if (element.hasStateElement()) {
      composeStringCore("state", element.getStateElement(), false);
      composeStringExtras("state", element.getStateElement(), false);
    }
    if (element.hasPostalCodeElement()) {
      composeStringCore("postalCode", element.getPostalCodeElement(), false);
      composeStringExtras("postalCode", element.getPostalCodeElement(), false);
    }
    if (element.hasCountryElement()) {
      composeStringCore("country", element.getCountryElement(), false);
      composeStringExtras("country", element.getCountryElement(), false);
    }
    if (element.hasPeriod()) {
      composePeriod("period", element.getPeriod());
    }
  }

  protected void composeHumanName(String name, HumanName element) throws IOException {
    if (element != null) {
      open(name);
      composeHumanNameInner(element);
      close();
    }
  }

  protected void composeHumanNameInner(HumanName element) throws IOException {
    composeElement(element);
    if (element.hasUseElement()) {
      composeEnumerationCore("use", element.getUseElement(), new HumanName.NameUseEnumFactory(), false);
      composeEnumerationExtras("use", element.getUseElement(), new HumanName.NameUseEnumFactory(), false);
    }
    if (element.hasTextElement()) {
      composeStringCore("text", element.getTextElement(), false);
      composeStringExtras("text", element.getTextElement(), false);
    }
    if (element.hasFamily()) {
      openArray("family");
      for (StringType e : element.getFamily())
        composeStringCore(null, e, true);
      closeArray();
      if (anyHasExtras(element.getFamily())) {
        openArray("_family");
        for (StringType e : element.getFamily())
          composeStringExtras(null, e, true);
        closeArray();
      }
    }
    ;
    if (element.hasGiven()) {
      openArray("given");
      for (StringType e : element.getGiven())
        composeStringCore(null, e, true);
      closeArray();
      if (anyHasExtras(element.getGiven())) {
        openArray("_given");
        for (StringType e : element.getGiven())
          composeStringExtras(null, e, true);
        closeArray();
      }
    }
    ;
    if (element.hasPrefix()) {
      openArray("prefix");
      for (StringType e : element.getPrefix())
        composeStringCore(null, e, true);
      closeArray();
      if (anyHasExtras(element.getPrefix())) {
        openArray("_prefix");
        for (StringType e : element.getPrefix())
          composeStringExtras(null, e, true);
        closeArray();
      }
    }
    ;
    if (element.hasSuffix()) {
      openArray("suffix");
      for (StringType e : element.getSuffix())
        composeStringCore(null, e, true);
      closeArray();
      if (anyHasExtras(element.getSuffix())) {
        openArray("_suffix");
        for (StringType e : element.getSuffix())
          composeStringExtras(null, e, true);
        closeArray();
      }
    }
    ;
    if (element.hasPeriod()) {
      composePeriod("period", element.getPeriod());
    }
  }

  protected void composeDataRequirement(String name, DataRequirement element) throws IOException {
    if (element != null) {
      open(name);
      composeDataRequirementInner(element);
      close();
    }
  }

  protected void composeDataRequirementInner(DataRequirement element) throws IOException {
    composeElement(element);
    if (element.hasTypeElement()) {
      composeCodeCore("type", element.getTypeElement(), false);
      composeCodeExtras("type", element.getTypeElement(), false);
    }
    if (element.hasProfile()) {
      composeReference("profile", element.getProfile());
    }
    if (element.hasMustSupport()) {
      openArray("mustSupport");
      for (StringType e : element.getMustSupport())
        composeStringCore(null, e, true);
      closeArray();
      if (anyHasExtras(element.getMustSupport())) {
        openArray("_mustSupport");
        for (StringType e : element.getMustSupport())
          composeStringExtras(null, e, true);
        closeArray();
      }
    }
    ;
    if (element.hasCodeFilter()) {
      openArray("codeFilter");
      for (DataRequirement.DataRequirementCodeFilterComponent e : element.getCodeFilter())
        composeDataRequirementDataRequirementCodeFilterComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasDateFilter()) {
      openArray("dateFilter");
      for (DataRequirement.DataRequirementDateFilterComponent e : element.getDateFilter())
        composeDataRequirementDataRequirementDateFilterComponent(null, e);
      closeArray();
    }
    ;
  }

  protected void composeDataRequirementDataRequirementCodeFilterComponent(String name,
      DataRequirement.DataRequirementCodeFilterComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeDataRequirementDataRequirementCodeFilterComponentInner(element);
      close();
    }
  }

  protected void composeDataRequirementDataRequirementCodeFilterComponentInner(
      DataRequirement.DataRequirementCodeFilterComponent element) throws IOException {
    composeElement(element);
    if (element.hasPathElement()) {
      composeStringCore("path", element.getPathElement(), false);
      composeStringExtras("path", element.getPathElement(), false);
    }
    if (element.hasValueSet()) {
      composeType("valueSet", element.getValueSet());
    }
    if (element.hasValueCode()) {
      openArray("valueCode");
      for (CodeType e : element.getValueCode())
        composeCodeCore(null, e, true);
      closeArray();
      if (anyHasExtras(element.getValueCode())) {
        openArray("_valueCode");
        for (CodeType e : element.getValueCode())
          composeCodeExtras(null, e, true);
        closeArray();
      }
    }
    ;
    if (element.hasValueCoding()) {
      openArray("valueCoding");
      for (Coding e : element.getValueCoding())
        composeCoding(null, e);
      closeArray();
    }
    ;
    if (element.hasValueCodeableConcept()) {
      openArray("valueCodeableConcept");
      for (CodeableConcept e : element.getValueCodeableConcept())
        composeCodeableConcept(null, e);
      closeArray();
    }
    ;
  }

  protected void composeDataRequirementDataRequirementDateFilterComponent(String name,
      DataRequirement.DataRequirementDateFilterComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeDataRequirementDataRequirementDateFilterComponentInner(element);
      close();
    }
  }

  protected void composeDataRequirementDataRequirementDateFilterComponentInner(
      DataRequirement.DataRequirementDateFilterComponent element) throws IOException {
    composeElement(element);
    if (element.hasPathElement()) {
      composeStringCore("path", element.getPathElement(), false);
      composeStringExtras("path", element.getPathElement(), false);
    }
    if (element.hasValue()) {
      composeType("value", element.getValue());
    }
  }

  protected void composeMeta(String name, Meta element) throws IOException {
    if (element != null) {
      open(name);
      composeMetaInner(element);
      close();
    }
  }

  protected void composeMetaInner(Meta element) throws IOException {
    composeElement(element);
    if (element.hasVersionIdElement()) {
      composeIdCore("versionId", element.getVersionIdElement(), false);
      composeIdExtras("versionId", element.getVersionIdElement(), false);
    }
    if (element.hasLastUpdatedElement()) {
      composeInstantCore("lastUpdated", element.getLastUpdatedElement(), false);
      composeInstantExtras("lastUpdated", element.getLastUpdatedElement(), false);
    }
    if (element.hasProfile()) {
      openArray("profile");
      for (UriType e : element.getProfile())
        composeUriCore(null, e, true);
      closeArray();
      if (anyHasExtras(element.getProfile())) {
        openArray("_profile");
        for (UriType e : element.getProfile())
          composeUriExtras(null, e, true);
        closeArray();
      }
    }
    ;
    if (element.hasSecurity()) {
      openArray("security");
      for (Coding e : element.getSecurity())
        composeCoding(null, e);
      closeArray();
    }
    ;
    if (element.hasTag()) {
      openArray("tag");
      for (Coding e : element.getTag())
        composeCoding(null, e);
      closeArray();
    }
    ;
  }

  protected void composeParameterDefinition(String name, ParameterDefinition element) throws IOException {
    if (element != null) {
      open(name);
      composeParameterDefinitionInner(element);
      close();
    }
  }

  protected void composeParameterDefinitionInner(ParameterDefinition element) throws IOException {
    composeElement(element);
    if (element.hasNameElement()) {
      composeCodeCore("name", element.getNameElement(), false);
      composeCodeExtras("name", element.getNameElement(), false);
    }
    if (element.hasUseElement()) {
      composeCodeCore("use", element.getUseElement(), false);
      composeCodeExtras("use", element.getUseElement(), false);
    }
    if (element.hasMinElement()) {
      composeIntegerCore("min", element.getMinElement(), false);
      composeIntegerExtras("min", element.getMinElement(), false);
    }
    if (element.hasMaxElement()) {
      composeStringCore("max", element.getMaxElement(), false);
      composeStringExtras("max", element.getMaxElement(), false);
    }
    if (element.hasDocumentationElement()) {
      composeStringCore("documentation", element.getDocumentationElement(), false);
      composeStringExtras("documentation", element.getDocumentationElement(), false);
    }
    if (element.hasTypeElement()) {
      composeCodeCore("type", element.getTypeElement(), false);
      composeCodeExtras("type", element.getTypeElement(), false);
    }
    if (element.hasProfile()) {
      composeReference("profile", element.getProfile());
    }
  }

  protected void composeContactPoint(String name, ContactPoint element) throws IOException {
    if (element != null) {
      open(name);
      composeContactPointInner(element);
      close();
    }
  }

  protected void composeContactPointInner(ContactPoint element) throws IOException {
    composeElement(element);
    if (element.hasSystemElement()) {
      composeEnumerationCore("system", element.getSystemElement(), new ContactPoint.ContactPointSystemEnumFactory(),
          false);
      composeEnumerationExtras("system", element.getSystemElement(), new ContactPoint.ContactPointSystemEnumFactory(),
          false);
    }
    if (element.hasValueElement()) {
      composeStringCore("value", element.getValueElement(), false);
      composeStringExtras("value", element.getValueElement(), false);
    }
    if (element.hasUseElement()) {
      composeEnumerationCore("use", element.getUseElement(), new ContactPoint.ContactPointUseEnumFactory(), false);
      composeEnumerationExtras("use", element.getUseElement(), new ContactPoint.ContactPointUseEnumFactory(), false);
    }
    if (element.hasRankElement()) {
      composePositiveIntCore("rank", element.getRankElement(), false);
      composePositiveIntExtras("rank", element.getRankElement(), false);
    }
    if (element.hasPeriod()) {
      composePeriod("period", element.getPeriod());
    }
  }

  protected void composeParameters(String name, Parameters element) throws IOException {
    if (element != null) {
      prop("resourceType", name);
      composeParametersInner(element);
    }
  }

  protected void composeParametersInner(Parameters element) throws IOException {
    composeResourceElements(element);
    if (element.hasParameter()) {
      openArray("parameter");
      for (Parameters.ParametersParameterComponent e : element.getParameter())
        composeParametersParametersParameterComponent(null, e);
      closeArray();
    }
    ;
  }

  protected void composeParametersParametersParameterComponent(String name,
      Parameters.ParametersParameterComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeParametersParametersParameterComponentInner(element);
      close();
    }
  }

  protected void composeParametersParametersParameterComponentInner(Parameters.ParametersParameterComponent element)
      throws IOException {
    composeBackbone(element);
    if (element.hasNameElement()) {
      composeStringCore("name", element.getNameElement(), false);
      composeStringExtras("name", element.getNameElement(), false);
    }
    if (element.hasValue()) {
      composeType("value", element.getValue());
    }
    if (element.hasResource()) {
      open("resource");
      composeResource(element.getResource());
      close();
    }
    if (element.hasPart()) {
      openArray("part");
      for (Parameters.ParametersParameterComponent e : element.getPart())
        composeParametersParametersParameterComponent(null, e);
      closeArray();
    }
    ;
  }

  protected void composeResourceElements(Resource element) throws IOException {
    if (element.hasIdElement()) {
      composeIdCore("id", element.getIdElement(), false);
      composeIdExtras("id", element.getIdElement(), false);
    }
    if (element.hasMeta()) {
      composeMeta("meta", element.getMeta());
    }
    if (element.hasImplicitRulesElement()) {
      composeUriCore("implicitRules", element.getImplicitRulesElement(), false);
      composeUriExtras("implicitRules", element.getImplicitRulesElement(), false);
    }
    if (element.hasLanguageElement()) {
      composeCodeCore("language", element.getLanguageElement(), false);
      composeCodeExtras("language", element.getLanguageElement(), false);
    }
  }

  protected void composeDomainResourceElements(DomainResource element) throws IOException {
    composeResourceElements(element);
    if (element.hasText()) {
      composeNarrative("text", element.getText());
    }
    if (element.hasContained()) {
      openArray("contained");
      for (Resource e : element.getContained()) {
        open(null);
        composeResource(e);
        close();
      }
      closeArray();
    }
    ;
    if (element.hasExtension()) {
      openArray("extension");
      for (Extension e : element.getExtension())
        composeExtension(null, e);
      closeArray();
    }
    ;
    if (element.hasModifierExtension()) {
      openArray("modifierExtension");
      for (Extension e : element.getModifierExtension())
        composeExtension(null, e);
      closeArray();
    }
    ;
  }

  protected void composeAccount(String name, Account element) throws IOException {
    if (element != null) {
      prop("resourceType", name);
      composeAccountInner(element);
    }
  }

  protected void composeAccountInner(Account element) throws IOException {
    composeDomainResourceElements(element);
    if (element.hasIdentifier()) {
      openArray("identifier");
      for (Identifier e : element.getIdentifier())
        composeIdentifier(null, e);
      closeArray();
    }
    ;
    if (element.hasNameElement()) {
      composeStringCore("name", element.getNameElement(), false);
      composeStringExtras("name", element.getNameElement(), false);
    }
    if (element.hasType()) {
      composeCodeableConcept("type", element.getType());
    }
    if (element.hasStatusElement()) {
      composeEnumerationCore("status", element.getStatusElement(), new Account.AccountStatusEnumFactory(), false);
      composeEnumerationExtras("status", element.getStatusElement(), new Account.AccountStatusEnumFactory(), false);
    }
    if (element.hasActivePeriod()) {
      composePeriod("activePeriod", element.getActivePeriod());
    }
    if (element.hasCurrency()) {
      composeCoding("currency", element.getCurrency());
    }
    if (element.hasBalance()) {
      composeMoney("balance", element.getBalance());
    }
    if (element.hasCoveragePeriod()) {
      composePeriod("coveragePeriod", element.getCoveragePeriod());
    }
    if (element.hasSubject()) {
      composeReference("subject", element.getSubject());
    }
    if (element.hasOwner()) {
      composeReference("owner", element.getOwner());
    }
    if (element.hasDescriptionElement()) {
      composeStringCore("description", element.getDescriptionElement(), false);
      composeStringExtras("description", element.getDescriptionElement(), false);
    }
  }

  protected void composeAllergyIntolerance(String name, AllergyIntolerance element) throws IOException {
    if (element != null) {
      prop("resourceType", name);
      composeAllergyIntoleranceInner(element);
    }
  }

  protected void composeAllergyIntoleranceInner(AllergyIntolerance element) throws IOException {
    composeDomainResourceElements(element);
    if (element.hasIdentifier()) {
      openArray("identifier");
      for (Identifier e : element.getIdentifier())
        composeIdentifier(null, e);
      closeArray();
    }
    ;
    if (element.hasStatusElement()) {
      composeEnumerationCore("status", element.getStatusElement(),
          new AllergyIntolerance.AllergyIntoleranceStatusEnumFactory(), false);
      composeEnumerationExtras("status", element.getStatusElement(),
          new AllergyIntolerance.AllergyIntoleranceStatusEnumFactory(), false);
    }
    if (element.hasTypeElement()) {
      composeEnumerationCore("type", element.getTypeElement(),
          new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory(), false);
      composeEnumerationExtras("type", element.getTypeElement(),
          new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory(), false);
    }
    if (element.hasCategoryElement()) {
      composeEnumerationCore("category", element.getCategoryElement(),
          new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory(), false);
      composeEnumerationExtras("category", element.getCategoryElement(),
          new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory(), false);
    }
    if (element.hasCriticalityElement()) {
      composeEnumerationCore("criticality", element.getCriticalityElement(),
          new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory(), false);
      composeEnumerationExtras("criticality", element.getCriticalityElement(),
          new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory(), false);
    }
    if (element.hasSubstance()) {
      composeCodeableConcept("substance", element.getSubstance());
    }
    if (element.hasPatient()) {
      composeReference("patient", element.getPatient());
    }
    if (element.hasRecordedDateElement()) {
      composeDateTimeCore("recordedDate", element.getRecordedDateElement(), false);
      composeDateTimeExtras("recordedDate", element.getRecordedDateElement(), false);
    }
    if (element.hasRecorder()) {
      composeReference("recorder", element.getRecorder());
    }
    if (element.hasReporter()) {
      composeReference("reporter", element.getReporter());
    }
    if (element.hasOnsetElement()) {
      composeDateTimeCore("onset", element.getOnsetElement(), false);
      composeDateTimeExtras("onset", element.getOnsetElement(), false);
    }
    if (element.hasLastOccurenceElement()) {
      composeDateTimeCore("lastOccurence", element.getLastOccurenceElement(), false);
      composeDateTimeExtras("lastOccurence", element.getLastOccurenceElement(), false);
    }
    if (element.hasNote()) {
      openArray("note");
      for (Annotation e : element.getNote())
        composeAnnotation(null, e);
      closeArray();
    }
    ;
    if (element.hasReaction()) {
      openArray("reaction");
      for (AllergyIntolerance.AllergyIntoleranceReactionComponent e : element.getReaction())
        composeAllergyIntoleranceAllergyIntoleranceReactionComponent(null, e);
      closeArray();
    }
    ;
  }

  protected void composeAllergyIntoleranceAllergyIntoleranceReactionComponent(String name,
      AllergyIntolerance.AllergyIntoleranceReactionComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeAllergyIntoleranceAllergyIntoleranceReactionComponentInner(element);
      close();
    }
  }

  protected void composeAllergyIntoleranceAllergyIntoleranceReactionComponentInner(
      AllergyIntolerance.AllergyIntoleranceReactionComponent element) throws IOException {
    composeBackbone(element);
    if (element.hasSubstance()) {
      composeCodeableConcept("substance", element.getSubstance());
    }
    if (element.hasCertaintyElement()) {
      composeEnumerationCore("certainty", element.getCertaintyElement(),
          new AllergyIntolerance.AllergyIntoleranceCertaintyEnumFactory(), false);
      composeEnumerationExtras("certainty", element.getCertaintyElement(),
          new AllergyIntolerance.AllergyIntoleranceCertaintyEnumFactory(), false);
    }
    if (element.hasManifestation()) {
      openArray("manifestation");
      for (CodeableConcept e : element.getManifestation())
        composeCodeableConcept(null, e);
      closeArray();
    }
    ;
    if (element.hasDescriptionElement()) {
      composeStringCore("description", element.getDescriptionElement(), false);
      composeStringExtras("description", element.getDescriptionElement(), false);
    }
    if (element.hasOnsetElement()) {
      composeDateTimeCore("onset", element.getOnsetElement(), false);
      composeDateTimeExtras("onset", element.getOnsetElement(), false);
    }
    if (element.hasSeverityElement()) {
      composeEnumerationCore("severity", element.getSeverityElement(),
          new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory(), false);
      composeEnumerationExtras("severity", element.getSeverityElement(),
          new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory(), false);
    }
    if (element.hasExposureRoute()) {
      composeCodeableConcept("exposureRoute", element.getExposureRoute());
    }
    if (element.hasNote()) {
      openArray("note");
      for (Annotation e : element.getNote())
        composeAnnotation(null, e);
      closeArray();
    }
    ;
  }

  protected void composeAppointment(String name, Appointment element) throws IOException {
    if (element != null) {
      prop("resourceType", name);
      composeAppointmentInner(element);
    }
  }

  protected void composeAppointmentInner(Appointment element) throws IOException {
    composeDomainResourceElements(element);
    if (element.hasIdentifier()) {
      openArray("identifier");
      for (Identifier e : element.getIdentifier())
        composeIdentifier(null, e);
      closeArray();
    }
    ;
    if (element.hasStatusElement()) {
      composeEnumerationCore("status", element.getStatusElement(), new Appointment.AppointmentStatusEnumFactory(),
          false);
      composeEnumerationExtras("status", element.getStatusElement(), new Appointment.AppointmentStatusEnumFactory(),
          false);
    }
    if (element.hasServiceCategory()) {
      composeCodeableConcept("serviceCategory", element.getServiceCategory());
    }
    if (element.hasServiceType()) {
      openArray("serviceType");
      for (CodeableConcept e : element.getServiceType())
        composeCodeableConcept(null, e);
      closeArray();
    }
    ;
    if (element.hasSpecialty()) {
      openArray("specialty");
      for (CodeableConcept e : element.getSpecialty())
        composeCodeableConcept(null, e);
      closeArray();
    }
    ;
    if (element.hasAppointmentType()) {
      composeCodeableConcept("appointmentType", element.getAppointmentType());
    }
    if (element.hasReason()) {
      composeCodeableConcept("reason", element.getReason());
    }
    if (element.hasPriorityElement()) {
      composeUnsignedIntCore("priority", element.getPriorityElement(), false);
      composeUnsignedIntExtras("priority", element.getPriorityElement(), false);
    }
    if (element.hasDescriptionElement()) {
      composeStringCore("description", element.getDescriptionElement(), false);
      composeStringExtras("description", element.getDescriptionElement(), false);
    }
    if (element.hasStartElement()) {
      composeInstantCore("start", element.getStartElement(), false);
      composeInstantExtras("start", element.getStartElement(), false);
    }
    if (element.hasEndElement()) {
      composeInstantCore("end", element.getEndElement(), false);
      composeInstantExtras("end", element.getEndElement(), false);
    }
    if (element.hasMinutesDurationElement()) {
      composePositiveIntCore("minutesDuration", element.getMinutesDurationElement(), false);
      composePositiveIntExtras("minutesDuration", element.getMinutesDurationElement(), false);
    }
    if (element.hasSlot()) {
      openArray("slot");
      for (Reference e : element.getSlot())
        composeReference(null, e);
      closeArray();
    }
    ;
    if (element.hasCreatedElement()) {
      composeDateTimeCore("created", element.getCreatedElement(), false);
      composeDateTimeExtras("created", element.getCreatedElement(), false);
    }
    if (element.hasCommentElement()) {
      composeStringCore("comment", element.getCommentElement(), false);
      composeStringExtras("comment", element.getCommentElement(), false);
    }
    if (element.hasParticipant()) {
      openArray("participant");
      for (Appointment.AppointmentParticipantComponent e : element.getParticipant())
        composeAppointmentAppointmentParticipantComponent(null, e);
      closeArray();
    }
    ;
  }

  protected void composeAppointmentAppointmentParticipantComponent(String name,
      Appointment.AppointmentParticipantComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeAppointmentAppointmentParticipantComponentInner(element);
      close();
    }
  }

  protected void composeAppointmentAppointmentParticipantComponentInner(
      Appointment.AppointmentParticipantComponent element) throws IOException {
    composeBackbone(element);
    if (element.hasType()) {
      openArray("type");
      for (CodeableConcept e : element.getType())
        composeCodeableConcept(null, e);
      closeArray();
    }
    ;
    if (element.hasActor()) {
      composeReference("actor", element.getActor());
    }
    if (element.hasRequiredElement()) {
      composeEnumerationCore("required", element.getRequiredElement(), new Appointment.ParticipantRequiredEnumFactory(),
          false);
      composeEnumerationExtras("required", element.getRequiredElement(),
          new Appointment.ParticipantRequiredEnumFactory(), false);
    }
    if (element.hasStatusElement()) {
      composeEnumerationCore("status", element.getStatusElement(), new Appointment.ParticipationStatusEnumFactory(),
          false);
      composeEnumerationExtras("status", element.getStatusElement(), new Appointment.ParticipationStatusEnumFactory(),
          false);
    }
  }

  protected void composeAppointmentResponse(String name, AppointmentResponse element) throws IOException {
    if (element != null) {
      prop("resourceType", name);
      composeAppointmentResponseInner(element);
    }
  }

  protected void composeAppointmentResponseInner(AppointmentResponse element) throws IOException {
    composeDomainResourceElements(element);
    if (element.hasIdentifier()) {
      openArray("identifier");
      for (Identifier e : element.getIdentifier())
        composeIdentifier(null, e);
      closeArray();
    }
    ;
    if (element.hasAppointment()) {
      composeReference("appointment", element.getAppointment());
    }
    if (element.hasStartElement()) {
      composeInstantCore("start", element.getStartElement(), false);
      composeInstantExtras("start", element.getStartElement(), false);
    }
    if (element.hasEndElement()) {
      composeInstantCore("end", element.getEndElement(), false);
      composeInstantExtras("end", element.getEndElement(), false);
    }
    if (element.hasParticipantType()) {
      openArray("participantType");
      for (CodeableConcept e : element.getParticipantType())
        composeCodeableConcept(null, e);
      closeArray();
    }
    ;
    if (element.hasActor()) {
      composeReference("actor", element.getActor());
    }
    if (element.hasParticipantStatusElement()) {
      composeCodeCore("participantStatus", element.getParticipantStatusElement(), false);
      composeCodeExtras("participantStatus", element.getParticipantStatusElement(), false);
    }
    if (element.hasCommentElement()) {
      composeStringCore("comment", element.getCommentElement(), false);
      composeStringExtras("comment", element.getCommentElement(), false);
    }
  }

  protected void composeAuditEvent(String name, AuditEvent element) throws IOException {
    if (element != null) {
      prop("resourceType", name);
      composeAuditEventInner(element);
    }
  }

  protected void composeAuditEventInner(AuditEvent element) throws IOException {
    composeDomainResourceElements(element);
    if (element.hasType()) {
      composeCoding("type", element.getType());
    }
    if (element.hasSubtype()) {
      openArray("subtype");
      for (Coding e : element.getSubtype())
        composeCoding(null, e);
      closeArray();
    }
    ;
    if (element.hasActionElement()) {
      composeEnumerationCore("action", element.getActionElement(), new AuditEvent.AuditEventActionEnumFactory(), false);
      composeEnumerationExtras("action", element.getActionElement(), new AuditEvent.AuditEventActionEnumFactory(),
          false);
    }
    if (element.hasRecordedElement()) {
      composeInstantCore("recorded", element.getRecordedElement(), false);
      composeInstantExtras("recorded", element.getRecordedElement(), false);
    }
    if (element.hasOutcomeElement()) {
      composeEnumerationCore("outcome", element.getOutcomeElement(), new AuditEvent.AuditEventOutcomeEnumFactory(),
          false);
      composeEnumerationExtras("outcome", element.getOutcomeElement(), new AuditEvent.AuditEventOutcomeEnumFactory(),
          false);
    }
    if (element.hasOutcomeDescElement()) {
      composeStringCore("outcomeDesc", element.getOutcomeDescElement(), false);
      composeStringExtras("outcomeDesc", element.getOutcomeDescElement(), false);
    }
    if (element.hasPurposeOfEvent()) {
      openArray("purposeOfEvent");
      for (Coding e : element.getPurposeOfEvent())
        composeCoding(null, e);
      closeArray();
    }
    ;
    if (element.hasAgent()) {
      openArray("agent");
      for (AuditEvent.AuditEventAgentComponent e : element.getAgent())
        composeAuditEventAuditEventAgentComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasSource()) {
      composeAuditEventAuditEventSourceComponent("source", element.getSource());
    }
    if (element.hasEntity()) {
      openArray("entity");
      for (AuditEvent.AuditEventEntityComponent e : element.getEntity())
        composeAuditEventAuditEventEntityComponent(null, e);
      closeArray();
    }
    ;
  }

  protected void composeAuditEventAuditEventAgentComponent(String name, AuditEvent.AuditEventAgentComponent element)
      throws IOException {
    if (element != null) {
      open(name);
      composeAuditEventAuditEventAgentComponentInner(element);
      close();
    }
  }

  protected void composeAuditEventAuditEventAgentComponentInner(AuditEvent.AuditEventAgentComponent element)
      throws IOException {
    composeBackbone(element);
    if (element.hasRole()) {
      openArray("role");
      for (CodeableConcept e : element.getRole())
        composeCodeableConcept(null, e);
      closeArray();
    }
    ;
    if (element.hasReference()) {
      composeReference("reference", element.getReference());
    }
    if (element.hasUserId()) {
      composeIdentifier("userId", element.getUserId());
    }
    if (element.hasAltIdElement()) {
      composeStringCore("altId", element.getAltIdElement(), false);
      composeStringExtras("altId", element.getAltIdElement(), false);
    }
    if (element.hasNameElement()) {
      composeStringCore("name", element.getNameElement(), false);
      composeStringExtras("name", element.getNameElement(), false);
    }
    if (element.hasRequestorElement()) {
      composeBooleanCore("requestor", element.getRequestorElement(), false);
      composeBooleanExtras("requestor", element.getRequestorElement(), false);
    }
    if (element.hasLocation()) {
      composeReference("location", element.getLocation());
    }
    if (element.hasPolicy()) {
      openArray("policy");
      for (UriType e : element.getPolicy())
        composeUriCore(null, e, true);
      closeArray();
      if (anyHasExtras(element.getPolicy())) {
        openArray("_policy");
        for (UriType e : element.getPolicy())
          composeUriExtras(null, e, true);
        closeArray();
      }
    }
    ;
    if (element.hasMedia()) {
      composeCoding("media", element.getMedia());
    }
    if (element.hasNetwork()) {
      composeAuditEventAuditEventAgentNetworkComponent("network", element.getNetwork());
    }
    if (element.hasPurposeOfUse()) {
      openArray("purposeOfUse");
      for (Coding e : element.getPurposeOfUse())
        composeCoding(null, e);
      closeArray();
    }
    ;
  }

  protected void composeAuditEventAuditEventAgentNetworkComponent(String name,
      AuditEvent.AuditEventAgentNetworkComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeAuditEventAuditEventAgentNetworkComponentInner(element);
      close();
    }
  }

  protected void composeAuditEventAuditEventAgentNetworkComponentInner(
      AuditEvent.AuditEventAgentNetworkComponent element) throws IOException {
    composeBackbone(element);
    if (element.hasAddressElement()) {
      composeStringCore("address", element.getAddressElement(), false);
      composeStringExtras("address", element.getAddressElement(), false);
    }
    if (element.hasTypeElement()) {
      composeEnumerationCore("type", element.getTypeElement(),
          new AuditEvent.AuditEventParticipantNetworkTypeEnumFactory(), false);
      composeEnumerationExtras("type", element.getTypeElement(),
          new AuditEvent.AuditEventParticipantNetworkTypeEnumFactory(), false);
    }
  }

  protected void composeAuditEventAuditEventSourceComponent(String name, AuditEvent.AuditEventSourceComponent element)
      throws IOException {
    if (element != null) {
      open(name);
      composeAuditEventAuditEventSourceComponentInner(element);
      close();
    }
  }

  protected void composeAuditEventAuditEventSourceComponentInner(AuditEvent.AuditEventSourceComponent element)
      throws IOException {
    composeBackbone(element);
    if (element.hasSiteElement()) {
      composeStringCore("site", element.getSiteElement(), false);
      composeStringExtras("site", element.getSiteElement(), false);
    }
    if (element.hasIdentifier()) {
      composeIdentifier("identifier", element.getIdentifier());
    }
    if (element.hasType()) {
      openArray("type");
      for (Coding e : element.getType())
        composeCoding(null, e);
      closeArray();
    }
    ;
  }

  protected void composeAuditEventAuditEventEntityComponent(String name, AuditEvent.AuditEventEntityComponent element)
      throws IOException {
    if (element != null) {
      open(name);
      composeAuditEventAuditEventEntityComponentInner(element);
      close();
    }
  }

  protected void composeAuditEventAuditEventEntityComponentInner(AuditEvent.AuditEventEntityComponent element)
      throws IOException {
    composeBackbone(element);
    if (element.hasIdentifier()) {
      composeIdentifier("identifier", element.getIdentifier());
    }
    if (element.hasReference()) {
      composeReference("reference", element.getReference());
    }
    if (element.hasType()) {
      composeCoding("type", element.getType());
    }
    if (element.hasRole()) {
      composeCoding("role", element.getRole());
    }
    if (element.hasLifecycle()) {
      composeCoding("lifecycle", element.getLifecycle());
    }
    if (element.hasSecurityLabel()) {
      openArray("securityLabel");
      for (Coding e : element.getSecurityLabel())
        composeCoding(null, e);
      closeArray();
    }
    ;
    if (element.hasNameElement()) {
      composeStringCore("name", element.getNameElement(), false);
      composeStringExtras("name", element.getNameElement(), false);
    }
    if (element.hasDescriptionElement()) {
      composeStringCore("description", element.getDescriptionElement(), false);
      composeStringExtras("description", element.getDescriptionElement(), false);
    }
    if (element.hasQueryElement()) {
      composeBase64BinaryCore("query", element.getQueryElement(), false);
      composeBase64BinaryExtras("query", element.getQueryElement(), false);
    }
    if (element.hasDetail()) {
      openArray("detail");
      for (AuditEvent.AuditEventEntityDetailComponent e : element.getDetail())
        composeAuditEventAuditEventEntityDetailComponent(null, e);
      closeArray();
    }
    ;
  }

  protected void composeAuditEventAuditEventEntityDetailComponent(String name,
      AuditEvent.AuditEventEntityDetailComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeAuditEventAuditEventEntityDetailComponentInner(element);
      close();
    }
  }

  protected void composeAuditEventAuditEventEntityDetailComponentInner(
      AuditEvent.AuditEventEntityDetailComponent element) throws IOException {
    composeBackbone(element);
    if (element.hasTypeElement()) {
      composeStringCore("type", element.getTypeElement(), false);
      composeStringExtras("type", element.getTypeElement(), false);
    }
    if (element.hasValueElement()) {
      composeBase64BinaryCore("value", element.getValueElement(), false);
      composeBase64BinaryExtras("value", element.getValueElement(), false);
    }
  }

  protected void composeBasic(String name, Basic element) throws IOException {
    if (element != null) {
      prop("resourceType", name);
      composeBasicInner(element);
    }
  }

  protected void composeBasicInner(Basic element) throws IOException {
    composeDomainResourceElements(element);
    if (element.hasIdentifier()) {
      openArray("identifier");
      for (Identifier e : element.getIdentifier())
        composeIdentifier(null, e);
      closeArray();
    }
    ;
    if (element.hasCode()) {
      composeCodeableConcept("code", element.getCode());
    }
    if (element.hasSubject()) {
      composeReference("subject", element.getSubject());
    }
    if (element.hasCreatedElement()) {
      composeDateCore("created", element.getCreatedElement(), false);
      composeDateExtras("created", element.getCreatedElement(), false);
    }
    if (element.hasAuthor()) {
      composeReference("author", element.getAuthor());
    }
  }

  protected void composeBinary(String name, Binary element) throws IOException {
    if (element != null) {
      prop("resourceType", name);
      composeBinaryInner(element);
    }
  }

  protected void composeBinaryInner(Binary element) throws IOException {
    composeResourceElements(element);
    if (element.hasContentTypeElement()) {
      composeCodeCore("contentType", element.getContentTypeElement(), false);
      composeCodeExtras("contentType", element.getContentTypeElement(), false);
    }
    if (element.hasContentElement()) {
      composeBase64BinaryCore("content", element.getContentElement(), false);
      composeBase64BinaryExtras("content", element.getContentElement(), false);
    }
  }

  protected void composeBodySite(String name, BodySite element) throws IOException {
    if (element != null) {
      prop("resourceType", name);
      composeBodySiteInner(element);
    }
  }

  protected void composeBodySiteInner(BodySite element) throws IOException {
    composeDomainResourceElements(element);
    if (element.hasPatient()) {
      composeReference("patient", element.getPatient());
    }
    if (element.hasIdentifier()) {
      openArray("identifier");
      for (Identifier e : element.getIdentifier())
        composeIdentifier(null, e);
      closeArray();
    }
    ;
    if (element.hasCode()) {
      composeCodeableConcept("code", element.getCode());
    }
    if (element.hasModifier()) {
      openArray("modifier");
      for (CodeableConcept e : element.getModifier())
        composeCodeableConcept(null, e);
      closeArray();
    }
    ;
    if (element.hasDescriptionElement()) {
      composeStringCore("description", element.getDescriptionElement(), false);
      composeStringExtras("description", element.getDescriptionElement(), false);
    }
    if (element.hasImage()) {
      openArray("image");
      for (Attachment e : element.getImage())
        composeAttachment(null, e);
      closeArray();
    }
    ;
  }

  protected void composeBundle(String name, Bundle element) throws IOException {
    if (element != null) {
      prop("resourceType", name);
      composeBundleInner(element);
    }
  }

  protected void composeBundleInner(Bundle element) throws IOException {
    composeResourceElements(element);
    if (element.hasTypeElement()) {
      composeEnumerationCore("type", element.getTypeElement(), new Bundle.BundleTypeEnumFactory(), false);
      composeEnumerationExtras("type", element.getTypeElement(), new Bundle.BundleTypeEnumFactory(), false);
    }
    if (element.hasTotalElement()) {
      composeUnsignedIntCore("total", element.getTotalElement(), false);
      composeUnsignedIntExtras("total", element.getTotalElement(), false);
    }
    if (element.hasLink()) {
      openArray("link");
      for (Bundle.BundleLinkComponent e : element.getLink())
        composeBundleBundleLinkComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasEntry()) {
      openArray("entry");
      for (Bundle.BundleEntryComponent e : element.getEntry())
        composeBundleBundleEntryComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasSignature()) {
      composeSignature("signature", element.getSignature());
    }
  }

  protected void composeBundleBundleLinkComponent(String name, Bundle.BundleLinkComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeBundleBundleLinkComponentInner(element);
      close();
    }
  }

  protected void composeBundleBundleLinkComponentInner(Bundle.BundleLinkComponent element) throws IOException {
    composeBackbone(element);
    if (element.hasRelationElement()) {
      composeStringCore("relation", element.getRelationElement(), false);
      composeStringExtras("relation", element.getRelationElement(), false);
    }
    if (element.hasUrlElement()) {
      composeUriCore("url", element.getUrlElement(), false);
      composeUriExtras("url", element.getUrlElement(), false);
    }
  }

  protected void composeBundleBundleEntryComponent(String name, Bundle.BundleEntryComponent element)
      throws IOException {
    if (element != null) {
      open(name);
      composeBundleBundleEntryComponentInner(element);
      close();
    }
  }

  protected void composeBundleBundleEntryComponentInner(Bundle.BundleEntryComponent element) throws IOException {
    composeBackbone(element);
    if (element.hasLink()) {
      openArray("link");
      for (Bundle.BundleLinkComponent e : element.getLink())
        composeBundleBundleLinkComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasFullUrlElement()) {
      composeUriCore("fullUrl", element.getFullUrlElement(), false);
      composeUriExtras("fullUrl", element.getFullUrlElement(), false);
    }
    if (element.hasResource()) {
      open("resource");
      composeResource(element.getResource());
      close();
    }
    if (element.hasSearch()) {
      composeBundleBundleEntrySearchComponent("search", element.getSearch());
    }
    if (element.hasRequest()) {
      composeBundleBundleEntryRequestComponent("request", element.getRequest());
    }
    if (element.hasResponse()) {
      composeBundleBundleEntryResponseComponent("response", element.getResponse());
    }
  }

  protected void composeBundleBundleEntrySearchComponent(String name, Bundle.BundleEntrySearchComponent element)
      throws IOException {
    if (element != null) {
      open(name);
      composeBundleBundleEntrySearchComponentInner(element);
      close();
    }
  }

  protected void composeBundleBundleEntrySearchComponentInner(Bundle.BundleEntrySearchComponent element)
      throws IOException {
    composeBackbone(element);
    if (element.hasModeElement()) {
      composeEnumerationCore("mode", element.getModeElement(), new Bundle.SearchEntryModeEnumFactory(), false);
      composeEnumerationExtras("mode", element.getModeElement(), new Bundle.SearchEntryModeEnumFactory(), false);
    }
    if (element.hasScoreElement()) {
      composeDecimalCore("score", element.getScoreElement(), false);
      composeDecimalExtras("score", element.getScoreElement(), false);
    }
  }

  protected void composeBundleBundleEntryRequestComponent(String name, Bundle.BundleEntryRequestComponent element)
      throws IOException {
    if (element != null) {
      open(name);
      composeBundleBundleEntryRequestComponentInner(element);
      close();
    }
  }

  protected void composeBundleBundleEntryRequestComponentInner(Bundle.BundleEntryRequestComponent element)
      throws IOException {
    composeBackbone(element);
    if (element.hasMethodElement()) {
      composeEnumerationCore("method", element.getMethodElement(), new Bundle.HTTPVerbEnumFactory(), false);
      composeEnumerationExtras("method", element.getMethodElement(), new Bundle.HTTPVerbEnumFactory(), false);
    }
    if (element.hasUrlElement()) {
      composeUriCore("url", element.getUrlElement(), false);
      composeUriExtras("url", element.getUrlElement(), false);
    }
    if (element.hasIfNoneMatchElement()) {
      composeStringCore("ifNoneMatch", element.getIfNoneMatchElement(), false);
      composeStringExtras("ifNoneMatch", element.getIfNoneMatchElement(), false);
    }
    if (element.hasIfModifiedSinceElement()) {
      composeInstantCore("ifModifiedSince", element.getIfModifiedSinceElement(), false);
      composeInstantExtras("ifModifiedSince", element.getIfModifiedSinceElement(), false);
    }
    if (element.hasIfMatchElement()) {
      composeStringCore("ifMatch", element.getIfMatchElement(), false);
      composeStringExtras("ifMatch", element.getIfMatchElement(), false);
    }
    if (element.hasIfNoneExistElement()) {
      composeStringCore("ifNoneExist", element.getIfNoneExistElement(), false);
      composeStringExtras("ifNoneExist", element.getIfNoneExistElement(), false);
    }
  }

  protected void composeBundleBundleEntryResponseComponent(String name, Bundle.BundleEntryResponseComponent element)
      throws IOException {
    if (element != null) {
      open(name);
      composeBundleBundleEntryResponseComponentInner(element);
      close();
    }
  }

  protected void composeBundleBundleEntryResponseComponentInner(Bundle.BundleEntryResponseComponent element)
      throws IOException {
    composeBackbone(element);
    if (element.hasStatusElement()) {
      composeStringCore("status", element.getStatusElement(), false);
      composeStringExtras("status", element.getStatusElement(), false);
    }
    if (element.hasLocationElement()) {
      composeUriCore("location", element.getLocationElement(), false);
      composeUriExtras("location", element.getLocationElement(), false);
    }
    if (element.hasEtagElement()) {
      composeStringCore("etag", element.getEtagElement(), false);
      composeStringExtras("etag", element.getEtagElement(), false);
    }
    if (element.hasLastModifiedElement()) {
      composeInstantCore("lastModified", element.getLastModifiedElement(), false);
      composeInstantExtras("lastModified", element.getLastModifiedElement(), false);
    }
  }

  protected void composeCarePlan(String name, CarePlan element) throws IOException {
    if (element != null) {
      prop("resourceType", name);
      composeCarePlanInner(element);
    }
  }

  protected void composeCarePlanInner(CarePlan element) throws IOException {
    composeDomainResourceElements(element);
    if (element.hasIdentifier()) {
      openArray("identifier");
      for (Identifier e : element.getIdentifier())
        composeIdentifier(null, e);
      closeArray();
    }
    ;
    if (element.hasSubject()) {
      composeReference("subject", element.getSubject());
    }
    if (element.hasStatusElement()) {
      composeEnumerationCore("status", element.getStatusElement(), new CarePlan.CarePlanStatusEnumFactory(), false);
      composeEnumerationExtras("status", element.getStatusElement(), new CarePlan.CarePlanStatusEnumFactory(), false);
    }
    if (element.hasContext()) {
      composeReference("context", element.getContext());
    }
    if (element.hasPeriod()) {
      composePeriod("period", element.getPeriod());
    }
    if (element.hasAuthor()) {
      openArray("author");
      for (Reference e : element.getAuthor())
        composeReference(null, e);
      closeArray();
    }
    ;
    if (element.hasModifiedElement()) {
      composeDateTimeCore("modified", element.getModifiedElement(), false);
      composeDateTimeExtras("modified", element.getModifiedElement(), false);
    }
    if (element.hasCategory()) {
      openArray("category");
      for (CodeableConcept e : element.getCategory())
        composeCodeableConcept(null, e);
      closeArray();
    }
    ;
    if (element.hasDescriptionElement()) {
      composeStringCore("description", element.getDescriptionElement(), false);
      composeStringExtras("description", element.getDescriptionElement(), false);
    }
    if (element.hasAddresses()) {
      openArray("addresses");
      for (Reference e : element.getAddresses())
        composeReference(null, e);
      closeArray();
    }
    ;
    if (element.hasSupport()) {
      openArray("support");
      for (Reference e : element.getSupport())
        composeReference(null, e);
      closeArray();
    }
    ;
    if (element.hasRelatedPlan()) {
      openArray("relatedPlan");
      for (CarePlan.CarePlanRelatedPlanComponent e : element.getRelatedPlan())
        composeCarePlanCarePlanRelatedPlanComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasParticipant()) {
      openArray("participant");
      for (CarePlan.CarePlanParticipantComponent e : element.getParticipant())
        composeCarePlanCarePlanParticipantComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasGoal()) {
      openArray("goal");
      for (Reference e : element.getGoal())
        composeReference(null, e);
      closeArray();
    }
    ;
    if (element.hasActivity()) {
      openArray("activity");
      for (CarePlan.CarePlanActivityComponent e : element.getActivity())
        composeCarePlanCarePlanActivityComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasNote()) {
      composeAnnotation("note", element.getNote());
    }
  }

  protected void composeCarePlanCarePlanRelatedPlanComponent(String name, CarePlan.CarePlanRelatedPlanComponent element)
      throws IOException {
    if (element != null) {
      open(name);
      composeCarePlanCarePlanRelatedPlanComponentInner(element);
      close();
    }
  }

  protected void composeCarePlanCarePlanRelatedPlanComponentInner(CarePlan.CarePlanRelatedPlanComponent element)
      throws IOException {
    composeBackbone(element);
    if (element.hasCodeElement()) {
      composeEnumerationCore("code", element.getCodeElement(), new CarePlan.CarePlanRelationshipEnumFactory(), false);
      composeEnumerationExtras("code", element.getCodeElement(), new CarePlan.CarePlanRelationshipEnumFactory(), false);
    }
    if (element.hasPlan()) {
      composeReference("plan", element.getPlan());
    }
  }

  protected void composeCarePlanCarePlanParticipantComponent(String name, CarePlan.CarePlanParticipantComponent element)
      throws IOException {
    if (element != null) {
      open(name);
      composeCarePlanCarePlanParticipantComponentInner(element);
      close();
    }
  }

  protected void composeCarePlanCarePlanParticipantComponentInner(CarePlan.CarePlanParticipantComponent element)
      throws IOException {
    composeBackbone(element);
    if (element.hasRole()) {
      composeCodeableConcept("role", element.getRole());
    }
    if (element.hasMember()) {
      composeReference("member", element.getMember());
    }
  }

  protected void composeCarePlanCarePlanActivityComponent(String name, CarePlan.CarePlanActivityComponent element)
      throws IOException {
    if (element != null) {
      open(name);
      composeCarePlanCarePlanActivityComponentInner(element);
      close();
    }
  }

  protected void composeCarePlanCarePlanActivityComponentInner(CarePlan.CarePlanActivityComponent element)
      throws IOException {
    composeBackbone(element);
    if (element.hasActionResulting()) {
      openArray("actionResulting");
      for (Reference e : element.getActionResulting())
        composeReference(null, e);
      closeArray();
    }
    ;
    if (element.hasProgress()) {
      openArray("progress");
      for (Annotation e : element.getProgress())
        composeAnnotation(null, e);
      closeArray();
    }
    ;
    if (element.hasReference()) {
      composeReference("reference", element.getReference());
    }
    if (element.hasDetail()) {
      composeCarePlanCarePlanActivityDetailComponent("detail", element.getDetail());
    }
  }

  protected void composeCarePlanCarePlanActivityDetailComponent(String name,
      CarePlan.CarePlanActivityDetailComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeCarePlanCarePlanActivityDetailComponentInner(element);
      close();
    }
  }

  protected void composeCarePlanCarePlanActivityDetailComponentInner(CarePlan.CarePlanActivityDetailComponent element)
      throws IOException {
    composeBackbone(element);
    if (element.hasCategory()) {
      composeCodeableConcept("category", element.getCategory());
    }
    if (element.hasCode()) {
      composeCodeableConcept("code", element.getCode());
    }
    if (element.hasReasonCode()) {
      openArray("reasonCode");
      for (CodeableConcept e : element.getReasonCode())
        composeCodeableConcept(null, e);
      closeArray();
    }
    ;
    if (element.hasReasonReference()) {
      openArray("reasonReference");
      for (Reference e : element.getReasonReference())
        composeReference(null, e);
      closeArray();
    }
    ;
    if (element.hasGoal()) {
      openArray("goal");
      for (Reference e : element.getGoal())
        composeReference(null, e);
      closeArray();
    }
    ;
    if (element.hasStatusElement()) {
      composeEnumerationCore("status", element.getStatusElement(), new CarePlan.CarePlanActivityStatusEnumFactory(),
          false);
      composeEnumerationExtras("status", element.getStatusElement(), new CarePlan.CarePlanActivityStatusEnumFactory(),
          false);
    }
    if (element.hasStatusReason()) {
      composeCodeableConcept("statusReason", element.getStatusReason());
    }
    if (element.hasProhibitedElement()) {
      composeBooleanCore("prohibited", element.getProhibitedElement(), false);
      composeBooleanExtras("prohibited", element.getProhibitedElement(), false);
    }
    if (element.hasScheduled()) {
      composeType("scheduled", element.getScheduled());
    }
    if (element.hasLocation()) {
      composeReference("location", element.getLocation());
    }
    if (element.hasPerformer()) {
      openArray("performer");
      for (Reference e : element.getPerformer())
        composeReference(null, e);
      closeArray();
    }
    ;
    if (element.hasProduct()) {
      composeType("product", element.getProduct());
    }
    if (element.hasDailyAmount()) {
      composeSimpleQuantity("dailyAmount", element.getDailyAmount());
    }
    if (element.hasQuantity()) {
      composeSimpleQuantity("quantity", element.getQuantity());
    }
    if (element.hasDescriptionElement()) {
      composeStringCore("description", element.getDescriptionElement(), false);
      composeStringExtras("description", element.getDescriptionElement(), false);
    }
  }

  protected void composeCareTeam(String name, CareTeam element) throws IOException {
    if (element != null) {
      prop("resourceType", name);
      composeCareTeamInner(element);
    }
  }

  protected void composeCareTeamInner(CareTeam element) throws IOException {
    composeDomainResourceElements(element);
    if (element.hasIdentifier()) {
      openArray("identifier");
      for (Identifier e : element.getIdentifier())
        composeIdentifier(null, e);
      closeArray();
    }
    ;
    if (element.hasStatus()) {
      composeCodeableConcept("status", element.getStatus());
    }
    if (element.hasType()) {
      openArray("type");
      for (CodeableConcept e : element.getType())
        composeCodeableConcept(null, e);
      closeArray();
    }
    ;
    if (element.hasNameElement()) {
      composeStringCore("name", element.getNameElement(), false);
      composeStringExtras("name", element.getNameElement(), false);
    }
    if (element.hasSubject()) {
      composeReference("subject", element.getSubject());
    }
    if (element.hasPeriod()) {
      composePeriod("period", element.getPeriod());
    }
    if (element.hasParticipant()) {
      openArray("participant");
      for (CareTeam.CareTeamParticipantComponent e : element.getParticipant())
        composeCareTeamCareTeamParticipantComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasManagingOrganization()) {
      composeReference("managingOrganization", element.getManagingOrganization());
    }
  }

  protected void composeCareTeamCareTeamParticipantComponent(String name, CareTeam.CareTeamParticipantComponent element)
      throws IOException {
    if (element != null) {
      open(name);
      composeCareTeamCareTeamParticipantComponentInner(element);
      close();
    }
  }

  protected void composeCareTeamCareTeamParticipantComponentInner(CareTeam.CareTeamParticipantComponent element)
      throws IOException {
    composeBackbone(element);
    if (element.hasRole()) {
      composeCodeableConcept("role", element.getRole());
    }
    if (element.hasMember()) {
      composeReference("member", element.getMember());
    }
    if (element.hasPeriod()) {
      composePeriod("period", element.getPeriod());
    }
  }

  protected void composeClaim(String name, Claim element) throws IOException {
    if (element != null) {
      prop("resourceType", name);
      composeClaimInner(element);
    }
  }

  protected void composeClaimInner(Claim element) throws IOException {
    composeDomainResourceElements(element);
    if (element.hasTypeElement()) {
      composeEnumerationCore("type", element.getTypeElement(), new Claim.ClaimTypeEnumFactory(), false);
      composeEnumerationExtras("type", element.getTypeElement(), new Claim.ClaimTypeEnumFactory(), false);
    }
    if (element.hasSubType()) {
      openArray("subType");
      for (Coding e : element.getSubType())
        composeCoding(null, e);
      closeArray();
    }
    ;
    if (element.hasIdentifier()) {
      openArray("identifier");
      for (Identifier e : element.getIdentifier())
        composeIdentifier(null, e);
      closeArray();
    }
    ;
    if (element.hasRuleset()) {
      composeCoding("ruleset", element.getRuleset());
    }
    if (element.hasOriginalRuleset()) {
      composeCoding("originalRuleset", element.getOriginalRuleset());
    }
    if (element.hasCreatedElement()) {
      composeDateTimeCore("created", element.getCreatedElement(), false);
      composeDateTimeExtras("created", element.getCreatedElement(), false);
    }
    if (element.hasBillablePeriod()) {
      composePeriod("billablePeriod", element.getBillablePeriod());
    }
    if (element.hasTarget()) {
      composeType("target", element.getTarget());
    }
    if (element.hasProvider()) {
      composeType("provider", element.getProvider());
    }
    if (element.hasOrganization()) {
      composeType("organization", element.getOrganization());
    }
    if (element.hasUseElement()) {
      composeEnumerationCore("use", element.getUseElement(), new Claim.UseEnumFactory(), false);
      composeEnumerationExtras("use", element.getUseElement(), new Claim.UseEnumFactory(), false);
    }
    if (element.hasPriority()) {
      composeCoding("priority", element.getPriority());
    }
    if (element.hasFundsReserve()) {
      composeCoding("fundsReserve", element.getFundsReserve());
    }
    if (element.hasEnterer()) {
      composeType("enterer", element.getEnterer());
    }
    if (element.hasFacility()) {
      composeType("facility", element.getFacility());
    }
    if (element.hasRelated()) {
      openArray("related");
      for (Claim.RelatedClaimsComponent e : element.getRelated())
        composeClaimRelatedClaimsComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasPrescription()) {
      composeType("prescription", element.getPrescription());
    }
    if (element.hasOriginalPrescription()) {
      composeType("originalPrescription", element.getOriginalPrescription());
    }
    if (element.hasPayee()) {
      composeClaimPayeeComponent("payee", element.getPayee());
    }
    if (element.hasReferral()) {
      composeType("referral", element.getReferral());
    }
    if (element.hasOccurrenceCode()) {
      openArray("occurrenceCode");
      for (Coding e : element.getOccurrenceCode())
        composeCoding(null, e);
      closeArray();
    }
    ;
    if (element.hasOccurenceSpanCode()) {
      openArray("occurenceSpanCode");
      for (Coding e : element.getOccurenceSpanCode())
        composeCoding(null, e);
      closeArray();
    }
    ;
    if (element.hasValueCode()) {
      openArray("valueCode");
      for (Coding e : element.getValueCode())
        composeCoding(null, e);
      closeArray();
    }
    ;
    if (element.hasDiagnosis()) {
      openArray("diagnosis");
      for (Claim.DiagnosisComponent e : element.getDiagnosis())
        composeClaimDiagnosisComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasProcedure()) {
      openArray("procedure");
      for (Claim.ProcedureComponent e : element.getProcedure())
        composeClaimProcedureComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasSpecialCondition()) {
      openArray("specialCondition");
      for (Coding e : element.getSpecialCondition())
        composeCoding(null, e);
      closeArray();
    }
    ;
    if (element.hasPatient()) {
      composeType("patient", element.getPatient());
    }
    if (element.hasCoverage()) {
      openArray("coverage");
      for (Claim.CoverageComponent e : element.getCoverage())
        composeClaimCoverageComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasAccidentDateElement()) {
      composeDateCore("accidentDate", element.getAccidentDateElement(), false);
      composeDateExtras("accidentDate", element.getAccidentDateElement(), false);
    }
    if (element.hasAccidentType()) {
      composeCoding("accidentType", element.getAccidentType());
    }
    if (element.hasAccidentLocation()) {
      composeType("accidentLocation", element.getAccidentLocation());
    }
    if (element.hasInterventionException()) {
      openArray("interventionException");
      for (Coding e : element.getInterventionException())
        composeCoding(null, e);
      closeArray();
    }
    ;
    if (element.hasOnset()) {
      openArray("onset");
      for (Claim.OnsetComponent e : element.getOnset())
        composeClaimOnsetComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasEmploymentImpacted()) {
      composePeriod("employmentImpacted", element.getEmploymentImpacted());
    }
    if (element.hasHospitalization()) {
      composePeriod("hospitalization", element.getHospitalization());
    }
    if (element.hasItem()) {
      openArray("item");
      for (Claim.ItemsComponent e : element.getItem())
        composeClaimItemsComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasTotal()) {
      composeMoney("total", element.getTotal());
    }
    if (element.hasAdditionalMaterial()) {
      openArray("additionalMaterial");
      for (Coding e : element.getAdditionalMaterial())
        composeCoding(null, e);
      closeArray();
    }
    ;
    if (element.hasMissingTeeth()) {
      openArray("missingTeeth");
      for (Claim.MissingTeethComponent e : element.getMissingTeeth())
        composeClaimMissingTeethComponent(null, e);
      closeArray();
    }
    ;
  }

  protected void composeClaimRelatedClaimsComponent(String name, Claim.RelatedClaimsComponent element)
      throws IOException {
    if (element != null) {
      open(name);
      composeClaimRelatedClaimsComponentInner(element);
      close();
    }
  }

  protected void composeClaimRelatedClaimsComponentInner(Claim.RelatedClaimsComponent element) throws IOException {
    composeBackbone(element);
    if (element.hasClaim()) {
      composeType("claim", element.getClaim());
    }
    if (element.hasRelationship()) {
      composeCoding("relationship", element.getRelationship());
    }
    if (element.hasReference()) {
      composeIdentifier("reference", element.getReference());
    }
  }

  protected void composeClaimPayeeComponent(String name, Claim.PayeeComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeClaimPayeeComponentInner(element);
      close();
    }
  }

  protected void composeClaimPayeeComponentInner(Claim.PayeeComponent element) throws IOException {
    composeBackbone(element);
    if (element.hasType()) {
      composeCoding("type", element.getType());
    }
    if (element.hasParty()) {
      composeType("party", element.getParty());
    }
  }

  protected void composeClaimDiagnosisComponent(String name, Claim.DiagnosisComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeClaimDiagnosisComponentInner(element);
      close();
    }
  }

  protected void composeClaimDiagnosisComponentInner(Claim.DiagnosisComponent element) throws IOException {
    composeBackbone(element);
    if (element.hasSequenceElement()) {
      composePositiveIntCore("sequence", element.getSequenceElement(), false);
      composePositiveIntExtras("sequence", element.getSequenceElement(), false);
    }
    if (element.hasDiagnosis()) {
      composeCoding("diagnosis", element.getDiagnosis());
    }
  }

  protected void composeClaimProcedureComponent(String name, Claim.ProcedureComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeClaimProcedureComponentInner(element);
      close();
    }
  }

  protected void composeClaimProcedureComponentInner(Claim.ProcedureComponent element) throws IOException {
    composeBackbone(element);
    if (element.hasSequenceElement()) {
      composePositiveIntCore("sequence", element.getSequenceElement(), false);
      composePositiveIntExtras("sequence", element.getSequenceElement(), false);
    }
    if (element.hasDateElement()) {
      composeDateTimeCore("date", element.getDateElement(), false);
      composeDateTimeExtras("date", element.getDateElement(), false);
    }
    if (element.hasProcedure()) {
      composeType("procedure", element.getProcedure());
    }
  }

  protected void composeClaimCoverageComponent(String name, Claim.CoverageComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeClaimCoverageComponentInner(element);
      close();
    }
  }

  protected void composeClaimCoverageComponentInner(Claim.CoverageComponent element) throws IOException {
    composeBackbone(element);
    if (element.hasSequenceElement()) {
      composePositiveIntCore("sequence", element.getSequenceElement(), false);
      composePositiveIntExtras("sequence", element.getSequenceElement(), false);
    }
    if (element.hasFocalElement()) {
      composeBooleanCore("focal", element.getFocalElement(), false);
      composeBooleanExtras("focal", element.getFocalElement(), false);
    }
    if (element.hasCoverage()) {
      composeType("coverage", element.getCoverage());
    }
    if (element.hasBusinessArrangementElement()) {
      composeStringCore("businessArrangement", element.getBusinessArrangementElement(), false);
      composeStringExtras("businessArrangement", element.getBusinessArrangementElement(), false);
    }
    if (element.hasPreAuthRef()) {
      openArray("preAuthRef");
      for (StringType e : element.getPreAuthRef())
        composeStringCore(null, e, true);
      closeArray();
      if (anyHasExtras(element.getPreAuthRef())) {
        openArray("_preAuthRef");
        for (StringType e : element.getPreAuthRef())
          composeStringExtras(null, e, true);
        closeArray();
      }
    }
    ;
    if (element.hasClaimResponse()) {
      composeReference("claimResponse", element.getClaimResponse());
    }
    if (element.hasOriginalRuleset()) {
      composeCoding("originalRuleset", element.getOriginalRuleset());
    }
  }

  protected void composeClaimOnsetComponent(String name, Claim.OnsetComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeClaimOnsetComponentInner(element);
      close();
    }
  }

  protected void composeClaimOnsetComponentInner(Claim.OnsetComponent element) throws IOException {
    composeBackbone(element);
    if (element.hasTime()) {
      composeType("time", element.getTime());
    }
    if (element.hasType()) {
      composeCoding("type", element.getType());
    }
  }

  protected void composeClaimItemsComponent(String name, Claim.ItemsComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeClaimItemsComponentInner(element);
      close();
    }
  }

  protected void composeClaimItemsComponentInner(Claim.ItemsComponent element) throws IOException {
    composeBackbone(element);
    if (element.hasSequenceElement()) {
      composePositiveIntCore("sequence", element.getSequenceElement(), false);
      composePositiveIntExtras("sequence", element.getSequenceElement(), false);
    }
    if (element.hasType()) {
      composeCoding("type", element.getType());
    }
    if (element.hasProvider()) {
      composeType("provider", element.getProvider());
    }
    if (element.hasSupervisor()) {
      composeType("supervisor", element.getSupervisor());
    }
    if (element.hasProviderQualification()) {
      composeCoding("providerQualification", element.getProviderQualification());
    }
    if (element.hasDiagnosisLinkId()) {
      openArray("diagnosisLinkId");
      for (PositiveIntType e : element.getDiagnosisLinkId())
        composePositiveIntCore(null, e, true);
      closeArray();
      if (anyHasExtras(element.getDiagnosisLinkId())) {
        openArray("_diagnosisLinkId");
        for (PositiveIntType e : element.getDiagnosisLinkId())
          composePositiveIntExtras(null, e, true);
        closeArray();
      }
    }
    ;
    if (element.hasService()) {
      composeCoding("service", element.getService());
    }
    if (element.hasServiceModifier()) {
      openArray("serviceModifier");
      for (Coding e : element.getServiceModifier())
        composeCoding(null, e);
      closeArray();
    }
    ;
    if (element.hasModifier()) {
      openArray("modifier");
      for (Coding e : element.getModifier())
        composeCoding(null, e);
      closeArray();
    }
    ;
    if (element.hasProgramCode()) {
      openArray("programCode");
      for (Coding e : element.getProgramCode())
        composeCoding(null, e);
      closeArray();
    }
    ;
    if (element.hasServiced()) {
      composeType("serviced", element.getServiced());
    }
    if (element.hasPlace()) {
      composeCoding("place", element.getPlace());
    }
    if (element.hasQuantity()) {
      composeSimpleQuantity("quantity", element.getQuantity());
    }
    if (element.hasUnitPrice()) {
      composeMoney("unitPrice", element.getUnitPrice());
    }
    if (element.hasFactorElement()) {
      composeDecimalCore("factor", element.getFactorElement(), false);
      composeDecimalExtras("factor", element.getFactorElement(), false);
    }
    if (element.hasPointsElement()) {
      composeDecimalCore("points", element.getPointsElement(), false);
      composeDecimalExtras("points", element.getPointsElement(), false);
    }
    if (element.hasNet()) {
      composeMoney("net", element.getNet());
    }
    if (element.hasUdi()) {
      openArray("udi");
      for (Reference e : element.getUdi())
        composeReference(null, e);
      closeArray();
    }
    ;
    if (element.hasBodySite()) {
      composeCoding("bodySite", element.getBodySite());
    }
    if (element.hasSubSite()) {
      openArray("subSite");
      for (Coding e : element.getSubSite())
        composeCoding(null, e);
      closeArray();
    }
    ;
    if (element.hasDetail()) {
      openArray("detail");
      for (Claim.DetailComponent e : element.getDetail())
        composeClaimDetailComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasProsthesis()) {
      composeClaimProsthesisComponent("prosthesis", element.getProsthesis());
    }
  }

  protected void composeClaimDetailComponent(String name, Claim.DetailComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeClaimDetailComponentInner(element);
      close();
    }
  }

  protected void composeClaimDetailComponentInner(Claim.DetailComponent element) throws IOException {
    composeBackbone(element);
    if (element.hasSequenceElement()) {
      composePositiveIntCore("sequence", element.getSequenceElement(), false);
      composePositiveIntExtras("sequence", element.getSequenceElement(), false);
    }
    if (element.hasType()) {
      composeCoding("type", element.getType());
    }
    if (element.hasService()) {
      composeCoding("service", element.getService());
    }
    if (element.hasProgramCode()) {
      openArray("programCode");
      for (Coding e : element.getProgramCode())
        composeCoding(null, e);
      closeArray();
    }
    ;
    if (element.hasQuantity()) {
      composeSimpleQuantity("quantity", element.getQuantity());
    }
    if (element.hasUnitPrice()) {
      composeMoney("unitPrice", element.getUnitPrice());
    }
    if (element.hasFactorElement()) {
      composeDecimalCore("factor", element.getFactorElement(), false);
      composeDecimalExtras("factor", element.getFactorElement(), false);
    }
    if (element.hasPointsElement()) {
      composeDecimalCore("points", element.getPointsElement(), false);
      composeDecimalExtras("points", element.getPointsElement(), false);
    }
    if (element.hasNet()) {
      composeMoney("net", element.getNet());
    }
    if (element.hasUdi()) {
      openArray("udi");
      for (Reference e : element.getUdi())
        composeReference(null, e);
      closeArray();
    }
    ;
    if (element.hasSubDetail()) {
      openArray("subDetail");
      for (Claim.SubDetailComponent e : element.getSubDetail())
        composeClaimSubDetailComponent(null, e);
      closeArray();
    }
    ;
  }

  protected void composeClaimSubDetailComponent(String name, Claim.SubDetailComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeClaimSubDetailComponentInner(element);
      close();
    }
  }

  protected void composeClaimSubDetailComponentInner(Claim.SubDetailComponent element) throws IOException {
    composeBackbone(element);
    if (element.hasSequenceElement()) {
      composePositiveIntCore("sequence", element.getSequenceElement(), false);
      composePositiveIntExtras("sequence", element.getSequenceElement(), false);
    }
    if (element.hasType()) {
      composeCoding("type", element.getType());
    }
    if (element.hasService()) {
      composeCoding("service", element.getService());
    }
    if (element.hasProgramCode()) {
      openArray("programCode");
      for (Coding e : element.getProgramCode())
        composeCoding(null, e);
      closeArray();
    }
    ;
    if (element.hasQuantity()) {
      composeSimpleQuantity("quantity", element.getQuantity());
    }
    if (element.hasUnitPrice()) {
      composeMoney("unitPrice", element.getUnitPrice());
    }
    if (element.hasFactorElement()) {
      composeDecimalCore("factor", element.getFactorElement(), false);
      composeDecimalExtras("factor", element.getFactorElement(), false);
    }
    if (element.hasPointsElement()) {
      composeDecimalCore("points", element.getPointsElement(), false);
      composeDecimalExtras("points", element.getPointsElement(), false);
    }
    if (element.hasNet()) {
      composeMoney("net", element.getNet());
    }
    if (element.hasUdi()) {
      openArray("udi");
      for (Reference e : element.getUdi())
        composeReference(null, e);
      closeArray();
    }
    ;
  }

  protected void composeClaimProsthesisComponent(String name, Claim.ProsthesisComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeClaimProsthesisComponentInner(element);
      close();
    }
  }

  protected void composeClaimProsthesisComponentInner(Claim.ProsthesisComponent element) throws IOException {
    composeBackbone(element);
    if (element.hasInitialElement()) {
      composeBooleanCore("initial", element.getInitialElement(), false);
      composeBooleanExtras("initial", element.getInitialElement(), false);
    }
    if (element.hasPriorDateElement()) {
      composeDateCore("priorDate", element.getPriorDateElement(), false);
      composeDateExtras("priorDate", element.getPriorDateElement(), false);
    }
    if (element.hasPriorMaterial()) {
      composeCoding("priorMaterial", element.getPriorMaterial());
    }
  }

  protected void composeClaimMissingTeethComponent(String name, Claim.MissingTeethComponent element)
      throws IOException {
    if (element != null) {
      open(name);
      composeClaimMissingTeethComponentInner(element);
      close();
    }
  }

  protected void composeClaimMissingTeethComponentInner(Claim.MissingTeethComponent element) throws IOException {
    composeBackbone(element);
    if (element.hasTooth()) {
      composeCoding("tooth", element.getTooth());
    }
    if (element.hasReason()) {
      composeCoding("reason", element.getReason());
    }
    if (element.hasExtractionDateElement()) {
      composeDateCore("extractionDate", element.getExtractionDateElement(), false);
      composeDateExtras("extractionDate", element.getExtractionDateElement(), false);
    }
  }

  protected void composeClaimResponse(String name, ClaimResponse element) throws IOException {
    if (element != null) {
      prop("resourceType", name);
      composeClaimResponseInner(element);
    }
  }

  protected void composeClaimResponseInner(ClaimResponse element) throws IOException {
    composeDomainResourceElements(element);
    if (element.hasIdentifier()) {
      openArray("identifier");
      for (Identifier e : element.getIdentifier())
        composeIdentifier(null, e);
      closeArray();
    }
    ;
    if (element.hasRequest()) {
      composeType("request", element.getRequest());
    }
    if (element.hasRuleset()) {
      composeCoding("ruleset", element.getRuleset());
    }
    if (element.hasOriginalRuleset()) {
      composeCoding("originalRuleset", element.getOriginalRuleset());
    }
    if (element.hasCreatedElement()) {
      composeDateTimeCore("created", element.getCreatedElement(), false);
      composeDateTimeExtras("created", element.getCreatedElement(), false);
    }
    if (element.hasOrganization()) {
      composeType("organization", element.getOrganization());
    }
    if (element.hasRequestProvider()) {
      composeType("requestProvider", element.getRequestProvider());
    }
    if (element.hasRequestOrganization()) {
      composeType("requestOrganization", element.getRequestOrganization());
    }
    if (element.hasOutcomeElement()) {
      composeEnumerationCore("outcome", element.getOutcomeElement(), new Enumerations.RemittanceOutcomeEnumFactory(),
          false);
      composeEnumerationExtras("outcome", element.getOutcomeElement(), new Enumerations.RemittanceOutcomeEnumFactory(),
          false);
    }
    if (element.hasDispositionElement()) {
      composeStringCore("disposition", element.getDispositionElement(), false);
      composeStringExtras("disposition", element.getDispositionElement(), false);
    }
    if (element.hasPayeeType()) {
      composeCoding("payeeType", element.getPayeeType());
    }
    if (element.hasItem()) {
      openArray("item");
      for (ClaimResponse.ItemsComponent e : element.getItem())
        composeClaimResponseItemsComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasAddItem()) {
      openArray("addItem");
      for (ClaimResponse.AddedItemComponent e : element.getAddItem())
        composeClaimResponseAddedItemComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasError()) {
      openArray("error");
      for (ClaimResponse.ErrorsComponent e : element.getError())
        composeClaimResponseErrorsComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasTotalCost()) {
      composeMoney("totalCost", element.getTotalCost());
    }
    if (element.hasUnallocDeductable()) {
      composeMoney("unallocDeductable", element.getUnallocDeductable());
    }
    if (element.hasTotalBenefit()) {
      composeMoney("totalBenefit", element.getTotalBenefit());
    }
    if (element.hasPaymentAdjustment()) {
      composeMoney("paymentAdjustment", element.getPaymentAdjustment());
    }
    if (element.hasPaymentAdjustmentReason()) {
      composeCoding("paymentAdjustmentReason", element.getPaymentAdjustmentReason());
    }
    if (element.hasPaymentDateElement()) {
      composeDateCore("paymentDate", element.getPaymentDateElement(), false);
      composeDateExtras("paymentDate", element.getPaymentDateElement(), false);
    }
    if (element.hasPaymentAmount()) {
      composeMoney("paymentAmount", element.getPaymentAmount());
    }
    if (element.hasPaymentRef()) {
      composeIdentifier("paymentRef", element.getPaymentRef());
    }
    if (element.hasReserved()) {
      composeCoding("reserved", element.getReserved());
    }
    if (element.hasForm()) {
      composeCoding("form", element.getForm());
    }
    if (element.hasNote()) {
      openArray("note");
      for (ClaimResponse.NotesComponent e : element.getNote())
        composeClaimResponseNotesComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasCoverage()) {
      openArray("coverage");
      for (ClaimResponse.CoverageComponent e : element.getCoverage())
        composeClaimResponseCoverageComponent(null, e);
      closeArray();
    }
    ;
  }

  protected void composeClaimResponseItemsComponent(String name, ClaimResponse.ItemsComponent element)
      throws IOException {
    if (element != null) {
      open(name);
      composeClaimResponseItemsComponentInner(element);
      close();
    }
  }

  protected void composeClaimResponseItemsComponentInner(ClaimResponse.ItemsComponent element) throws IOException {
    composeBackbone(element);
    if (element.hasSequenceLinkIdElement()) {
      composePositiveIntCore("sequenceLinkId", element.getSequenceLinkIdElement(), false);
      composePositiveIntExtras("sequenceLinkId", element.getSequenceLinkIdElement(), false);
    }
    if (element.hasNoteNumber()) {
      openArray("noteNumber");
      for (PositiveIntType e : element.getNoteNumber())
        composePositiveIntCore(null, e, true);
      closeArray();
      if (anyHasExtras(element.getNoteNumber())) {
        openArray("_noteNumber");
        for (PositiveIntType e : element.getNoteNumber())
          composePositiveIntExtras(null, e, true);
        closeArray();
      }
    }
    ;
    if (element.hasAdjudication()) {
      openArray("adjudication");
      for (ClaimResponse.ItemAdjudicationComponent e : element.getAdjudication())
        composeClaimResponseItemAdjudicationComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasDetail()) {
      openArray("detail");
      for (ClaimResponse.ItemDetailComponent e : element.getDetail())
        composeClaimResponseItemDetailComponent(null, e);
      closeArray();
    }
    ;
  }

  protected void composeClaimResponseItemAdjudicationComponent(String name,
      ClaimResponse.ItemAdjudicationComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeClaimResponseItemAdjudicationComponentInner(element);
      close();
    }
  }

  protected void composeClaimResponseItemAdjudicationComponentInner(ClaimResponse.ItemAdjudicationComponent element)
      throws IOException {
    composeBackbone(element);
    if (element.hasCategory()) {
      composeCoding("category", element.getCategory());
    }
    if (element.hasReason()) {
      composeCoding("reason", element.getReason());
    }
    if (element.hasAmount()) {
      composeMoney("amount", element.getAmount());
    }
    if (element.hasValueElement()) {
      composeDecimalCore("value", element.getValueElement(), false);
      composeDecimalExtras("value", element.getValueElement(), false);
    }
  }

  protected void composeClaimResponseItemDetailComponent(String name, ClaimResponse.ItemDetailComponent element)
      throws IOException {
    if (element != null) {
      open(name);
      composeClaimResponseItemDetailComponentInner(element);
      close();
    }
  }

  protected void composeClaimResponseItemDetailComponentInner(ClaimResponse.ItemDetailComponent element)
      throws IOException {
    composeBackbone(element);
    if (element.hasSequenceLinkIdElement()) {
      composePositiveIntCore("sequenceLinkId", element.getSequenceLinkIdElement(), false);
      composePositiveIntExtras("sequenceLinkId", element.getSequenceLinkIdElement(), false);
    }
    if (element.hasAdjudication()) {
      openArray("adjudication");
      for (ClaimResponse.DetailAdjudicationComponent e : element.getAdjudication())
        composeClaimResponseDetailAdjudicationComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasSubDetail()) {
      openArray("subDetail");
      for (ClaimResponse.SubDetailComponent e : element.getSubDetail())
        composeClaimResponseSubDetailComponent(null, e);
      closeArray();
    }
    ;
  }

  protected void composeClaimResponseDetailAdjudicationComponent(String name,
      ClaimResponse.DetailAdjudicationComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeClaimResponseDetailAdjudicationComponentInner(element);
      close();
    }
  }

  protected void composeClaimResponseDetailAdjudicationComponentInner(ClaimResponse.DetailAdjudicationComponent element)
      throws IOException {
    composeBackbone(element);
    if (element.hasCategory()) {
      composeCoding("category", element.getCategory());
    }
    if (element.hasReason()) {
      composeCoding("reason", element.getReason());
    }
    if (element.hasAmount()) {
      composeMoney("amount", element.getAmount());
    }
    if (element.hasValueElement()) {
      composeDecimalCore("value", element.getValueElement(), false);
      composeDecimalExtras("value", element.getValueElement(), false);
    }
  }

  protected void composeClaimResponseSubDetailComponent(String name, ClaimResponse.SubDetailComponent element)
      throws IOException {
    if (element != null) {
      open(name);
      composeClaimResponseSubDetailComponentInner(element);
      close();
    }
  }

  protected void composeClaimResponseSubDetailComponentInner(ClaimResponse.SubDetailComponent element)
      throws IOException {
    composeBackbone(element);
    if (element.hasSequenceLinkIdElement()) {
      composePositiveIntCore("sequenceLinkId", element.getSequenceLinkIdElement(), false);
      composePositiveIntExtras("sequenceLinkId", element.getSequenceLinkIdElement(), false);
    }
    if (element.hasAdjudication()) {
      openArray("adjudication");
      for (ClaimResponse.SubdetailAdjudicationComponent e : element.getAdjudication())
        composeClaimResponseSubdetailAdjudicationComponent(null, e);
      closeArray();
    }
    ;
  }

  protected void composeClaimResponseSubdetailAdjudicationComponent(String name,
      ClaimResponse.SubdetailAdjudicationComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeClaimResponseSubdetailAdjudicationComponentInner(element);
      close();
    }
  }

  protected void composeClaimResponseSubdetailAdjudicationComponentInner(
      ClaimResponse.SubdetailAdjudicationComponent element) throws IOException {
    composeBackbone(element);
    if (element.hasCategory()) {
      composeCoding("category", element.getCategory());
    }
    if (element.hasReason()) {
      composeCoding("reason", element.getReason());
    }
    if (element.hasAmount()) {
      composeMoney("amount", element.getAmount());
    }
    if (element.hasValueElement()) {
      composeDecimalCore("value", element.getValueElement(), false);
      composeDecimalExtras("value", element.getValueElement(), false);
    }
  }

  protected void composeClaimResponseAddedItemComponent(String name, ClaimResponse.AddedItemComponent element)
      throws IOException {
    if (element != null) {
      open(name);
      composeClaimResponseAddedItemComponentInner(element);
      close();
    }
  }

  protected void composeClaimResponseAddedItemComponentInner(ClaimResponse.AddedItemComponent element)
      throws IOException {
    composeBackbone(element);
    if (element.hasSequenceLinkId()) {
      openArray("sequenceLinkId");
      for (PositiveIntType e : element.getSequenceLinkId())
        composePositiveIntCore(null, e, true);
      closeArray();
      if (anyHasExtras(element.getSequenceLinkId())) {
        openArray("_sequenceLinkId");
        for (PositiveIntType e : element.getSequenceLinkId())
          composePositiveIntExtras(null, e, true);
        closeArray();
      }
    }
    ;
    if (element.hasService()) {
      composeCoding("service", element.getService());
    }
    if (element.hasFee()) {
      composeMoney("fee", element.getFee());
    }
    if (element.hasNoteNumberLinkId()) {
      openArray("noteNumberLinkId");
      for (PositiveIntType e : element.getNoteNumberLinkId())
        composePositiveIntCore(null, e, true);
      closeArray();
      if (anyHasExtras(element.getNoteNumberLinkId())) {
        openArray("_noteNumberLinkId");
        for (PositiveIntType e : element.getNoteNumberLinkId())
          composePositiveIntExtras(null, e, true);
        closeArray();
      }
    }
    ;
    if (element.hasAdjudication()) {
      openArray("adjudication");
      for (ClaimResponse.AddedItemAdjudicationComponent e : element.getAdjudication())
        composeClaimResponseAddedItemAdjudicationComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasDetail()) {
      openArray("detail");
      for (ClaimResponse.AddedItemsDetailComponent e : element.getDetail())
        composeClaimResponseAddedItemsDetailComponent(null, e);
      closeArray();
    }
    ;
  }

  protected void composeClaimResponseAddedItemAdjudicationComponent(String name,
      ClaimResponse.AddedItemAdjudicationComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeClaimResponseAddedItemAdjudicationComponentInner(element);
      close();
    }
  }

  protected void composeClaimResponseAddedItemAdjudicationComponentInner(
      ClaimResponse.AddedItemAdjudicationComponent element) throws IOException {
    composeBackbone(element);
    if (element.hasCategory()) {
      composeCoding("category", element.getCategory());
    }
    if (element.hasReason()) {
      composeCoding("reason", element.getReason());
    }
    if (element.hasAmount()) {
      composeMoney("amount", element.getAmount());
    }
    if (element.hasValueElement()) {
      composeDecimalCore("value", element.getValueElement(), false);
      composeDecimalExtras("value", element.getValueElement(), false);
    }
  }

  protected void composeClaimResponseAddedItemsDetailComponent(String name,
      ClaimResponse.AddedItemsDetailComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeClaimResponseAddedItemsDetailComponentInner(element);
      close();
    }
  }

  protected void composeClaimResponseAddedItemsDetailComponentInner(ClaimResponse.AddedItemsDetailComponent element)
      throws IOException {
    composeBackbone(element);
    if (element.hasService()) {
      composeCoding("service", element.getService());
    }
    if (element.hasFee()) {
      composeMoney("fee", element.getFee());
    }
    if (element.hasAdjudication()) {
      openArray("adjudication");
      for (ClaimResponse.AddedItemDetailAdjudicationComponent e : element.getAdjudication())
        composeClaimResponseAddedItemDetailAdjudicationComponent(null, e);
      closeArray();
    }
    ;
  }

  protected void composeClaimResponseAddedItemDetailAdjudicationComponent(String name,
      ClaimResponse.AddedItemDetailAdjudicationComponent element) throws IOException {
    if (element != null) {
      open(name);
      composeClaimResponseAddedItemDetailAdjudicationComponentInner(element);
      close();
    }
  }

  protected void composeClaimResponseAddedItemDetailAdjudicationComponentInner(
      ClaimResponse.AddedItemDetailAdjudicationComponent element) throws IOException {
    composeBackbone(element);
    if (element.hasCategory()) {
      composeCoding("category", element.getCategory());
    }
    if (element.hasReason()) {
      composeCoding("reason", element.getReason());
    }
    if (element.hasAmount()) {
      composeMoney("amount", element.getAmount());
    }
    if (element.hasValueElement()) {
      composeDecimalCore("value", element.getValueElement(), false);
      composeDecimalExtras("value", element.getValueElement(), false);
    }
  }

  protected void composeClaimResponseErrorsComponent(String name, ClaimResponse.ErrorsComponent element)
      throws IOException {
    if (element != null) {
      open(name);
      composeClaimResponseErrorsComponentInner(element);
      close();
    }
  }

  protected void composeClaimResponseErrorsComponentInner(ClaimResponse.ErrorsComponent element) throws IOException {
    composeBackbone(element);
    if (element.hasSequenceLinkIdElement()) {
      composePositiveIntCore("sequenceLinkId", element.getSequenceLinkIdElement(), false);
      composePositiveIntExtras("sequenceLinkId", element.getSequenceLinkIdElement(), false);
    }
    if (element.hasDetailSequenceLinkIdElement()) {
      composePositiveIntCore("detailSequenceLinkId", element.getDetailSequenceLinkIdElement(), false);
      composePositiveIntExtras("detailSequenceLinkId", element.getDetailSequenceLinkIdElement(), false);
    }
    if (element.hasSubdetailSequenceLinkIdElement()) {
      composePositiveIntCore("subdetailSequenceLinkId", element.getSubdetailSequenceLinkIdElement(), false);
      composePositiveIntExtras("subdetailSequenceLinkId", element.getSubdetailSequenceLinkIdElement(), false);
    }
    if (element.hasCode()) {
      composeCoding("code", element.getCode());
    }
  }

  protected void composeClaimResponseNotesComponent(String name, ClaimResponse.NotesComponent element)
      throws IOException {
    if (element != null) {
      open(name);
      composeClaimResponseNotesComponentInner(element);
      close();
    }
  }

  protected void composeClaimResponseNotesComponentInner(ClaimResponse.NotesComponent element) throws IOException {
    composeBackbone(element);
    if (element.hasNumberElement()) {
      composePositiveIntCore("number", element.getNumberElement(), false);
      composePositiveIntExtras("number", element.getNumberElement(), false);
    }
    if (element.hasType()) {
      composeCoding("type", element.getType());
    }
    if (element.hasTextElement()) {
      composeStringCore("text", element.getTextElement(), false);
      composeStringExtras("text", element.getTextElement(), false);
    }
  }

  protected void composeClaimResponseCoverageComponent(String name, ClaimResponse.CoverageComponent element)
      throws IOException {
    if (element != null) {
      open(name);
      composeClaimResponseCoverageComponentInner(element);
      close();
    }
  }

  protected void composeClaimResponseCoverageComponentInner(ClaimResponse.CoverageComponent element)
      throws IOException {
    composeBackbone(element);
    if (element.hasSequenceElement()) {
      composePositiveIntCore("sequence", element.getSequenceElement(), false);
      composePositiveIntExtras("sequence", element.getSequenceElement(), false);
    }
    if (element.hasFocalElement()) {
      composeBooleanCore("focal", element.getFocalElement(), false);
      composeBooleanExtras("focal", element.getFocalElement(), false);
    }
    if (element.hasCoverage()) {
      composeType("coverage", element.getCoverage());
    }
    if (element.hasBusinessArrangementElement()) {
      composeStringCore("businessArrangement", element.getBusinessArrangementElement(), false);
      composeStringExtras("businessArrangement", element.getBusinessArrangementElement(), false);
    }
    if (element.hasPreAuthRef()) {
      openArray("preAuthRef");
      for (StringType e : element.getPreAuthRef())
        composeStringCore(null, e, true);
      closeArray();
      if (anyHasExtras(element.getPreAuthRef())) {
        openArray("_preAuthRef");
        for (StringType e : element.getPreAuthRef())
          composeStringExtras(null, e, true);
        closeArray();
      }
    }
    ;
    if (element.hasClaimResponse()) {
      composeReference("claimResponse", element.getClaimResponse());
    }
  }

  protected void composeClinicalImpression(String name, ClinicalImpression element) throws IOException {
    if (element != null) {
      prop("resourceType", name);
      composeClinicalImpressionInner(element);
    }
  }

  protected void composeClinicalImpressionInner(ClinicalImpression element) throws IOException {
    composeDomainResourceElements(element);
    if (element.hasPatient()) {
      composeReference("patient", element.getPatient());
    }
    if (element.hasAssessor()) {
      composeReference("assessor", element.getAssessor());
    }
    if (element.hasStatusElement()) {
      composeEnumerationCore("status", element.getStatusElement(),
          new ClinicalImpression.ClinicalImpressionStatusEnumFactory(), false);
      composeEnumerationExtras("status", element.getStatusElement(),
          new ClinicalImpression.ClinicalImpressionStatusEnumFactory(), false);
    }
    if (element.hasDateElement()) {
      composeDateTimeCore("date", element.getDateElement(), false);
      composeDateTimeExtras("date", element.getDateElement(), false);
    }
    if (element.hasDescriptionElement()) {
      composeStringCore("description", element.getDescriptionElement(), false);
      composeStringExtras("description", element.getDescriptionElement(), false);
    }
    if (element.hasPrevious()) {
      composeReference("previous", element.getPrevious());
    }
    if (element.hasProblem()) {
      openArray("problem");
      for (Reference e : element.getProblem())
        composeReference(null, e);
      closeArray();
    }
    ;
    if (element.hasTrigger()) {
      composeType("trigger", element.getTrigger());
    }
    if (element.hasInvestigations()) {
      openArray("investigations");
      for (ClinicalImpression.ClinicalImpressionInvestigationsComponent e : element.getInvestigations())
        composeClinicalImpressionClinicalImpressionInvestigationsComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasProtocolElement()) {
      composeUriCore("protocol", element.getProtocolElement(), false);
      composeUriExtras("protocol", element.getProtocolElement(), false);
    }
    if (element.hasSummaryElement()) {
      composeStringCore("summary", element.getSummaryElement(), false);
      composeStringExtras("summary", element.getSummaryElement(), false);
    }
    if (element.hasFinding()) {
      openArray("finding");
      for (ClinicalImpression.ClinicalImpressionFindingComponent e : element.getFinding())
        composeClinicalImpressionClinicalImpressionFindingComponent(null, e);
      closeArray();
    }
    ;
    if (element.hasResolved()) {
      openArray("resolved");
      for (CodeableConcept e : element.getResolved())
        composeCodeableConcept(null, e