package org.hl7.fhir.dstu2016may.model.codesystems;




/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, 
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this 
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, 
     this list of conditions and the following disclaimer in the documentation 
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
  
*/

// Generated on Sun, May 8, 2016 03:05+1000 for FHIR v1.4.0


import org.hl7.fhir.exceptions.FHIRException;

public enum V3AmericanIndianAlaskaNativeLanguages {

        /**
         * Algic
         */
        _ALGIC, 
        /**
         * Algonquian
         */
        _ALGONQUIAN, 
        /**
         * Arapahoan
         */
        _ARAPAHOAN, 
        /**
         * ArapahoGrosVentre
         */
        _ARAPAHOGROSVENTRE, 
        /**
         * Arapaho
         */
        XARP, 
        /**
         * Gros Ventre
         */
        XATS, 
        /**
         * CreeMontagnais
         */
        _CREEMONTAGNAIS, 
        /**
         * Cree
         */
        _CREE, 
        /**
         * Western Cree
         */
        XCRP, 
        /**
         * EasternAlgonquin
         */
        _EASTERNALGONQUIN, 
        /**
         * Abenakian
         */
        _ABENAKIAN, 
        /**
         * Eastern Abenaki
         */
        XAAQ, 
        /**
         * Western Abenaki
         */
        XABE, 
        /**
         * Maliseet-Passamaquoddy
         */
        XMAC, 
        /**
         * Delawaran
         */
        _DELAWARAN, 
        /**
         * Unami Delaware
         */
        XDEL, 
        /**
         * Micmac
         */
        XMIC, 
        /**
         * Ojibwayan
         */
        _OJIBWAYAN, 
        /**
         * Southern Ojibwa
         */
        XOJB, 
        /**
         * Potawatami
         */
        XPOT, 
        /**
         * SaukFoxKickapoo
         */
        _SAUKFOXKICKAPOO, 
        /**
         * Kickapoo
         */
        XKIC, 
        /**
         * Mesquakie
         */
        XSAC, 
        /**
         * Shawnee
         */
        XSJW, 
        /**
         * Blackfoot
         */
        XBLC, 
        /**
         * Cheyenne
         */
        XCHY, 
        /**
         * Menominee
         */
        XMEZ, 
        /**
         * Ritwan
         */
        _RITWAN, 
        /**
         * Yurok
         */
        XYUR, 
        /**
         * Caddoan
         */
        _CADDOAN, 
        /**
         * NorthernCaddoan
         */
        _NORTHERNCADDOAN, 
        /**
         * Arikara
         */
        XARI, 
        /**
         * Pawnee
         */
        XPAW, 
        /**
         * Wichita
         */
        XWIC, 
        /**
         * SouthernCaddoan
         */
        _SOUTHERNCADDOAN, 
        /**
         * Caddo
         */
        XCAD, 
        /**
         * Chimakuan
         */
        _CHIMAKUAN, 
        /**
         * Quileute
         */
        XQUI, 
        /**
         * EskimoAleut
         */
        _ESKIMOALEUT, 
        /**
         * Aleut
         */
        _ALEUT, 
        /**
         * Aleut
         */
        XALW, 
        /**
         * Eskimoan
         */
        _ESKIMOAN, 
        /**
         * InuitInupiaq
         */
        _INUITINUPIAQ, 
        /**
         * North Alaskan Inuktitut
         */
        XESI, 
        /**
         * Northwest Alaska Inuktitut
         */
        XESK, 
        /**
         * SirenikskiYupik
         */
        _SIRENIKSKIYUPIK, 
        /**
         * Pacific Yupik Gulf
         */
        XEMS, 
        /**
         * Central Siberian Yupik
         */
        XESS, 
        /**
         * Central Alaskan Yupik
         */
        XESU, 
        /**
         * Hokan
         */
        _HOKAN, 
        /**
         * CochimiYuman
         */
        _COCHIMIYUMAN, 
        /**
         * Yuman
         */
        _YUMAN, 
        /**
         * DeltaCalifornia
         */
        _DELTACALIFORNIA, 
        /**
         * Diegueno
         */
        _DIEGUENO, 
        /**
         * Kumeyaay
         */
        XDIH, 
        /**
         * Cocopa
         */
        XCOC, 
        /**
         * Pai
         */
        _PAI, 
        /**
         * Havasupai
         */
        XYUF, 
        /**
         * River
         */
        _RIVER, 
        /**
         * Mohave
         */
        XMOV, 
        /**
         * Maricopa
         */
        XMRC, 
        /**
         * Quechan
         */
        XYUM, 
        /**
         * Palaihnihan
         */
        _PALAIHNIHAN, 
        /**
         * Achumawi
         */
        XACH, 
        /**
         * Atsugewi
         */
        XATW, 
        /**
         * Pomoan
         */
        _POMOAN, 
        /**
         * Kashaya
         */
        XKJU, 
        /**
         * Northeastern Pomo
         */
        XPEF, 
        /**
         * Southeastern Pomo
         */
        XPEO, 
        /**
         * Southern Pomo
         */
        XPEQ, 
        /**
         * Central Pomo
         */
        XPOO, 
        /**
         * Shasta
         */
        _SHASTA, 
        /**
         * Shasta
         */
        XSHT, 
        /**
         * Karok
         */
        XKYH, 
        /**
         * Washoe
         */
        XWAS, 
        /**
         * Iroquoian
         */
        _IROQUOIAN, 
        /**
         * NorthernIroquoian
         */
        _NORTHERNIROQUOIAN, 
        /**
         * Cayuga
         */
        XCAY, 
        /**
         * Mohawk
         */
        XMOH, 
        /**
         * Oneida
         */
        XONE, 
        /**
         * Onondaga
         */
        XONO, 
        /**
         * Seneca
         */
        XSEE, 
        /**
         * Tuscarora
         */
        XTUS, 
        /**
         * Cherokee
         */
        XCER, 
        /**
         * Keresan
         */
        _KERESAN, 
        /**
         * Rio Grande Keresan
         */
        XKEE, 
        /**
         * Acoma-Laguna
         */
        XKJQ, 
        /**
         * KiowaTanoan
         */
        _KIOWATANOAN, 
        /**
         * Tiwa
         */
        _TIWA, 
        /**
         * Northern Tiwa
         */
        XTAO, 
        /**
         * Southern Tiwa
         */
        XTIX, 
        /**
         * Kiowa
         */
        XKIO, 
        /**
         * Tewa
         */
        XTEW, 
        /**
         * Jemez
         */
        XTOW, 
        /**
         * Muskogean
         */
        _MUSKOGEAN, 
        /**
         * CentralMuskogean
         */
        _CENTRALMUSKOGEAN, 
        /**
         * Alabama
         */
        XAKZ, 
        /**
         * Koasati
         */
        XCKU, 
        /**
         * Mikasuki
         */
        XMIK, 
        /**
         * WesternMuskogean
         */
        _WESTERNMUSKOGEAN, 
        /**
         * Choctaw
         */
        XCCT, 
        /**
         * Chickasaw
         */
        XCIC, 
        /**
         * Creek
         */
        XCRK, 
        /**
         * Nadene
         */
        _NADENE, 
        /**
         * AthapaskanEyak
         */
        _ATHAPASKANEYAK, 
        /**
         * Athapaskan
         */
        _ATHAPASKAN, 
        /**
         * Apachean
         */
        _APACHEAN, 
        /**
         * EasternApachean
         */
        _EASTERNAPACHEAN, 
        /**
         * Jicarilla
         */
        XAPJ, 
        /**
         * Lipan
         */
        XAPL, 
        /**
         * WesternApachean
         */
        _WESTERNAPACHEAN, 
        /**
         * Mescalero-Chiricahua
         */
        XAPM, 
        /**
         * Western Apache
         */
        XAPW, 
        /**
         * Dine
         */
        XNAV, 
        /**
         * Kiowa Apache
         */
        XAPK, 
        /**
         * CentralAlaskaYukon
         */
        _CENTRALALASKAYUKON, 
        /**
         * KoyukonIngalik
         */
        _KOYUKONINGALIK, 
        /**
         * Holikachuk
         */
        XHOI, 
        /**
         * Degexit'an
         */
        XING, 
        /**
         * Koyukon
         */
        XKOY, 
        /**
         * KutchinHan
         */
        _KUTCHINHAN, 
        /**
         * Han
         */
        XHAA, 
        /**
         * Kutchin
         */
        XKUC, 
        /**
         * TananaTutchone
         */
        _TANANATUTCHONE, 
        /**
         * Tanana
         */
        _TANANA, 
        /**
         * Lower Tanana
         */
        XTAA, 
        /**
         * Upper Tanana
         */
        XTAU, 
        /**
         * Tanacross
         */
        XTCB, 
        /**
         * Upper Kuskokwim
         */
        XKUU, 
        /**
         * PacificCoastAthapaskan
         */
        _PACIFICCOASTATHAPASKAN, 
        /**
         * CaliforniaAthapaskan
         */
        _CALIFORNIAATHAPASKAN, 
        /**
         * Hupa
         */
        XHUP, 
        /**
         * Cahto
         */
        XKTW, 
        /**
         * OregonAthapaskan
         */
        _OREGONATHAPASKAN, 
        /**
         * Tolowa
         */
        XTOL, 
        /**
         * Tututni
         */
        XTUU, 
        /**
         * SouthernAlaska
         */
        _SOUTHERNALASKA, 
        /**
         * Ahtna
         */
        XAHT, 
        /**
         * Tanaina
         */
        XTFN, 
        /**
         * Eyak
         */
        XEYA, 
        /**
         * Tlingit
         */
        XTLI, 
        /**
         * Penutian
         */
        _PENUTIAN, 
        /**
         * Chinookan
         */
        _CHINOOKAN, 
        /**
         * UpperChinook
         */
        _UPPERCHINOOK, 
        /**
         * Kiksht
         */
        XWAC, 
        /**
         * Coosan
         */
        _COOSAN, 
        /**
         * Hanis
         */
        XCOS, 
        /**
         * Maiduan
         */
        _MAIDUAN, 
        /**
         * Northwest Maidu
         */
        XMAI, 
        /**
         * Northeast Maidu
         */
        XNMU, 
        /**
         * Nisenan
         */
        XNSZ, 
        /**
         * PlateauPenutian
         */
        _PLATEAUPENUTIAN, 
        /**
         * Sahaptian
         */
        _SAHAPTIAN, 
        /**
         * Umatilla
         */
        XUMA, 
        /**
         * Walla Walla
         */
        XWAA, 
        /**
         * Tenino
         */
        XWAR, 
        /**
         * Yakima
         */
        XYAK, 
        /**
         * Klamath-Modoc
         */
        XKLA, 
        /**
         * Nez Perce
         */
        XNEZ, 
        /**
         * Takelman
         */
        _TAKELMAN, 
        /**
         * Kalapuyan
         */
        _KALAPUYAN, 
        /**
         * Central Kalapuyan
         */
        XKAL, 
        /**
         * Tsimshianic
         */
        _TSIMSHIANIC, 
        /**
         * Coast Tsimshain
         */
        XTSI, 
        /**
         * Utian
         */
        _UTIAN, 
        /**
         * Miwokan
         */
        _MIWOKAN, 
        /**
         * EasternMiwok
         */
        _EASTERNMIWOK, 
        /**
         * Central Sierra Miwok
         */
        XCSM, 
        /**
         * Northern Sierra Miwok
         */
        XNSQ, 
        /**
         * Plains Miwok
         */
        XPMW, 
        /**
         * Southern Sierra Miwok
         */
        XSKD, 
        /**
         * WesternMiwok
         */
        _WESTERNMIWOK, 
        /**
         * Coast Miwok
         */
        XCSI, 
        /**
         * Lake Miwok
         */
        XLMW, 
        /**
         * Wintuan
         */
        _WINTUAN, 
        /**
         * Wintu-Nomlaki
         */
        XWIT, 
        /**
         * Yokutsan
         */
        _YOKUTSAN, 
        /**
         * Kings River
         */
        XENH, 
        /**
         * Gashowu
         */
        XGSH, 
        /**
         * Poso Creek
         */
        XPYL, 
        /**
         * Tule-Kaweah
         */
        XTKH, 
        /**
         * Pidgin
         */
        _PIDGIN, 
        /**
         * Chinook Wawa
         */
        XCHH, 
        /**
         * Salishan
         */
        _SALISHAN, 
        /**
         * CentralSalish
         */
        _CENTRALSALISH, 
        /**
         * Clallam
         */
        XCLM, 
        /**
         * Lushootseed
         */
        XLUT, 
        /**
         * Northern Straits
         */
        XSTR, 
        /**
         * InteriorSalish
         */
        _INTERIORSALISH, 
        /**
         * Columbian
         */
        XCOL, 
        /**
         * Coeur D'alene
         */
        XCRD, 
        /**
         * Kalispel
         */
        XFLA, 
        /**
         * Okanagan
         */
        XOKA, 
        /**
         * Tsamosan
         */
        _TSAMOSAN, 
        /**
         * Lower Chehalis
         */
        XCEA, 
        /**
         * Upper Chehalis
         */
        XCJH, 
        /**
         * Cowlitz
         */
        XCOW, 
        /**
         * Quinault
         */
        XQUN, 
        /**
         * SiouanCatawba
         */
        _SIOUANCATAWBA, 
        /**
         * Siouan
         */
        _SIOUAN, 
        /**
         * MississippiValley
         */
        _MISSISSIPPIVALLEY, 
        /**
         * ChiwereWinnebago
         */
        _CHIWEREWINNEBAGO, 
        /**
         * Chiwere
         */
        XIOW, 
        /**
         * Hocak
         */
        XWIN, 
        /**
         * Dakotan
         */
        _DAKOTAN, 
        /**
         * Assiniboine
         */
        XASB, 
        /**
         * Dakota
         */
        XDHG, 
        /**
         * Lakota
         */
        XLKT, 
        /**
         * Nakota
         */
        XNKT, 
        /**
         * Dhegiha
         */
        _DHEGIHA, 
        /**
         * Kansa
         */
        XKAA, 
        /**
         * Omaha-Ponca
         */
        XOMA, 
        /**
         * Osage
         */
        XOSA, 
        /**
         * Quapaw
         */
        XQUA, 
        /**
         * MissouriRiver
         */
        _MISSOURIRIVER, 
        /**
         * Crow
         */
        XCRO, 
        /**
         * Hidatsa
         */
        XHID, 
        /**
         * Mandan
         */
        XMHQ, 
        /**
         * UtoAztecan
         */
        _UTOAZTECAN, 
        /**
         * Numic
         */
        _NUMIC, 
        /**
         * CentralNumic
         */
        _CENTRALNUMIC, 
        /**
         * Comanche
         */
        XCOM, 
        /**
         * Panamint
         */
        XPAR, 
        /**
         * Shoshone
         */
        XSHH, 
        /**
         * SouthernNumic
         */
        _SOUTHERNNUMIC, 
        /**
         * Kawaiisu
         */
        XKAW, 
        /**
         * Ute-Southern Paiute
         */
        XUTE, 
        /**
         * WesternNumic
         */
        _WESTERNNUMIC, 
        /**
         * Mono
         */
        XMON, 
        /**
         * Northern Paiute-Bannock
         */
        XPAO, 
        /**
         * Takic
         */
        _TAKIC, 
        /**
         * Cupan
         */
        _CUPAN, 
        /**
         * Cahuilla
         */
        XCHL, 
        /**
         * Cupeno
         */
        XCUP, 
        /**
         * Luiseno
         */
        XLUI, 
        /**
         * SerranoGabrielino
         */
        _SERRANOGABRIELINO, 
        /**
         * Serrano
         */
        XSER, 
        /**
         * Taracahitan
         */
        _TARACAHITAN, 
        /**
         * Cahitan
         */
        _CAHITAN, 
        /**
         * Yaqui
         */
        XYAQ, 
        /**
         * Tepiman
         */
        _TEPIMAN, 
        /**
         * Papago-Pima
         */
        XPAP, 
        /**
         * Hopi
         */
        XHOP, 
        /**
         * Tubatululabal
         */
        XTUB, 
        /**
         * Wakashan
         */
        _WAKASHAN, 
        /**
         * Nootkan
         */
        _NOOTKAN, 
        /**
         * Makah
         */
        XMYH, 
        /**
         * Yukian
         */
        _YUKIAN, 
        /**
         * Wappo
         */
        XWAO, 
        /**
         * Yuki
         */
        XYUK, 
        /**
         * Haida
         */
        XHAI, 
        /**
         * Kootenai
         */
        XKUN, 
        /**
         * Plains Indian Sign Language
         */
        XPSD, 
        /**
         * Yuchi
         */
        XYUC, 
        /**
         * Zuni
         */
        XZUN, 
        /**
         * added to help the parsers
         */
        NULL;
        public static V3AmericanIndianAlaskaNativeLanguages fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString))
                return null;
        if ("_Algic".equals(codeString))
          return _ALGIC;
        if ("_Algonquian".equals(codeString))
          return _ALGONQUIAN;
        if ("_Arapahoan".equals(codeString))
          return _ARAPAHOAN;
        if ("_ArapahoGrosVentre".equals(codeString))
          return _ARAPAHOGROSVENTRE;
        if ("x-ARP".equals(codeString))
          return XARP;
        if ("x-ATS".equals(codeString))
          return XATS;
        if ("_CreeMontagnais".equals(codeString))
          return _CREEMONTAGNAIS;
        if ("_Cree".equals(codeString))
          return _CREE;
        if ("x-CRP".equals(codeString))
          return XCRP;
        if ("_EasternAlgonquin".equals(codeString))
          return _EASTERNALGONQUIN;
        if ("_Abenakian".equals(codeString))
          return _ABENAKIAN;
        if ("x-AAQ".equals(codeString))
          return XAAQ;
        if ("x-ABE".equals(codeString))
          return XABE;
        if ("x-MAC".equals(codeString))
          return XMAC;
        if ("_Delawaran".equals(codeString))
          return _DELAWARAN;
        if ("x-DEL".equals(codeString))
          return XDEL;
        if ("x-MIC".equals(codeString))
          return XMIC;
        if ("_Ojibwayan".equals(codeString))
          return _OJIBWAYAN;
        if ("x-OJB".equals(codeString))
          return XOJB;
        if ("x-POT".equals(codeString))
          return XPOT;
        if ("_SaukFoxKickapoo".equals(codeString))
          return _SAUKFOXKICKAPOO;
        if ("x-KIC".equals(codeString))
          return XKIC;
        if ("x-SAC".equals(codeString))
          return XSAC;
        if ("x-SJW".equals(codeString))
          return XSJW;
        if ("x-BLC".equals(codeString))
          return XBLC;
        if ("x-CHY".equals(codeString))
          return XCHY;
        if ("x-MEZ".equals(codeString))
          return XMEZ;
        if ("_Ritwan".equals(codeString))
          return _RITWAN;
        if ("x-YUR".equals(codeString))
          return XYUR;
        if ("_Caddoan".equals(codeString))
          return _CADDOAN;
        if ("_NorthernCaddoan".equals(codeString))
          return _NORTHERNCADDOAN;
        if ("x-ARI".equals(codeString))
          return XARI;
        if ("x-PAW".equals(codeString))
          return XPAW;
        if ("x-WIC".equals(codeString))
          return XWIC;
        if ("_SouthernCaddoan".equals(codeString))
          return _SOUTHERNCADDOAN;
        if ("x-CAD".equals(codeString))
          return XCAD;
        if ("_Chimakuan".equals(codeString))
          return _CHIMAKUAN;
        if ("x-QUI".equals(codeString))
          return XQUI;
        if ("_EskimoAleut".equals(codeString))
          return _ESKIMOALEUT;
        if ("_Aleut".equals(codeString))
          return _ALEUT;
        if ("x-ALW".equals(codeString))
          return XALW;
        if ("_Eskimoan".equals(codeString))
          return _ESKIMOAN;
        if ("_InuitInupiaq".equals(codeString))
          return _INUITINUPIAQ;
        if ("x-ESI".equals(codeString))
          return XESI;
        if ("x-ESK".equals(codeString))
          return XESK;
        if ("_SirenikskiYupik".equals(codeString))
          return _SIRENIKSKIYUPIK;
        if ("x-EMS".equals(codeString))
          return XEMS;
        if ("x-ESS".equals(codeString))
          return XESS;
        if ("x-ESU".equals(codeString))
          return XESU;
        if ("_Hokan".equals(codeString))
          return _HOKAN;
        if ("_CochimiYuman".equals(codeString))
          return _COCHIMIYUMAN;
        if ("_Yuman".equals(codeString))
          return _YUMAN;
        if ("_DeltaCalifornia".equals(codeString))
          return _DELTACALIFORNIA;
        if ("_Diegueno".equals(codeString))
          return _DIEGUENO;
        if ("x-DIH".equals(codeString))
          return XDIH;
        if ("x-COC".equals(codeString))
          return XCOC;
        if ("_Pai".equals(codeString))
          return _PAI;
        if ("x-YUF".equals(codeString))
          return XYUF;
        if ("_River".equals(codeString))
          return _RIVER;
        if ("x-MOV".equals(codeString))
          return XMOV;
        if ("x-MRC".equals(codeString))
          return XMRC;
        if ("x-YUM".equals(codeString))
          return XYUM;
        if ("_Palaihnihan".equals(codeString))
          return _PALAIHNIHAN;
        if ("x-ACH".equals(codeString))
          return XACH;
        if ("x-ATW".equals(codeString))
          return XATW;
        if ("_Pomoan".equals(codeString))
          return _POMOAN;
        if ("x-KJU".equals(codeString))
          return XKJU;
        if ("x-PEF".equals(codeString))
          return XPEF;
        if ("x-PEO".equals(codeString))
          return XPEO;
        if ("x-PEQ".equals(codeString))
          return XPEQ;
        if ("x-POO".equals(codeString))
          return XPOO;
        if ("_Shasta".equals(codeString))
          return _SHASTA;
        if ("x-SHT".equals(codeString))
          return XSHT;
        if ("x-KYH".equals(codeString))
          return XKYH;
        if ("x-WAS".equals(codeString))
          return XWAS;
        if ("_Iroquoian".equals(codeString))
          return _IROQUOIAN;
        if ("_NorthernIroquoian".equals(codeString))
          return _NORTHERNIROQUOIAN;
        if ("x-CAY".equals(codeString))
          return XCAY;
        if ("x-MOH".equals(codeString))
          return XMOH;
        if ("x-ONE".equals(codeString))
          return XONE;
        if ("x-ONO".equals(codeString))
          return XONO;
        if ("x-SEE".equals(codeString))
          return XSEE;
        if ("x-TUS".equals(codeString))
          return XTUS;
        if ("x-CER".equals(codeString))
          return XCER;
        if ("_Keresan".equals(codeString))
          return _KERESAN;
        if ("x-KEE".equals(codeString))
          return XKEE;
        if ("x-KJQ".equals(codeString))
          return XKJQ;
        if ("_KiowaTanoan".equals(codeString))
          return _KIOWATANOAN;
        if ("_Tiwa".equals(codeString))
          return _TIWA;
        if ("x-TAO".equals(codeString))
          return XTAO;
        if ("x-TIX".equals(codeString))
          return XTIX;
        if ("x-KIO".equals(codeString))
          return XKIO;
        if ("x-TEW".equals(codeString))
          return XTEW;
        if ("x-TOW".equals(codeString))
          return XTOW;
        if ("_Muskogean".equals(codeString))
          return _MUSKOGEAN;
        if ("_CentralMuskogean".equals(codeString))
          return _CENTRALMUSKOGEAN;
        if ("x-AKZ".equals(codeString))
          return XAKZ;
        if ("x-CKU".equals(codeString))
          return XCKU;
        if ("x-MIK".equals(codeString))
          return XMIK;
        if ("_WesternMuskogean".equals(codeString))
          return _WESTERNMUSKOGEAN;
        if ("x-CCT".equals(codeString))
          return XCCT;
        if ("x-CIC".equals(codeString))
          return XCIC;
        if ("x-CRK".equals(codeString))
          return XCRK;
        if ("_Nadene".equals(codeString))
          return _NADENE;
        if ("_AthapaskanEyak".equals(codeString))
          return _ATHAPASKANEYAK;
        if ("_Athapaskan".equals(codeString))
          return _ATHAPASKAN;
        if ("_Apachean".equals(codeString))
          return _APACHEAN;
        if ("_EasternApachean".equals(codeString))
          return _EASTERNAPACHEAN;
        if ("x-APJ".equals(codeString))
          return XAPJ;
        if ("x-APL".equals(codeString))
          return XAPL;
        if ("_WesternApachean".equals(codeString))
          return _WESTERNAPACHEAN;
        if ("x-APM".equals(codeString))
          return XAPM;
        if ("x-APW".equals(codeString))
          return XAPW;
        if ("x-NAV".equals(codeString))
          return XNAV;
        if ("x-APK".equals(codeString))
          return XAPK;
        if ("_CentralAlaskaYukon".equals(codeString))
          return _CENTRALALASKAYUKON;
        if ("_KoyukonIngalik".equals(codeString))
          return _KOYUKONINGALIK;
        if ("x-HOI".equals(codeString))
          return XHOI;
        if ("x-ING".equals(codeString))
          return XING;
        if ("x-KOY".equals(codeString))
          return XKOY;
        if ("_KutchinHan".equals(codeString))
          return _KUTCHINHAN;
        if ("x-HAA".equals(codeString))
          return XHAA;
        if ("x-KUC".equals(codeString))
          return XKUC;
        if ("_TananaTutchone".equals(codeString))
          return _TANANATUTCHONE;
        if ("_Tanana".equals(codeString))
          return _TANANA;
        if ("x-TAA".equals(codeString))
          return XTAA;
        if ("x-TAU".equals(codeString))
          return XTAU;
        if ("x-TCB".equals(codeString))
          return XTCB;
        if ("x-KUU".equals(codeString))
          return XKUU;
        if ("_PacificCoastAthapaskan".equals(codeString))
          return _PACIFICCOASTATHAPASKAN;
        if ("_CaliforniaAthapaskan".equals(codeString))
          return _CALIFORNIAATHAPASKAN;
        if ("x-HUP".equals(codeString))
          return XHUP;
        if ("x-KTW".equals(codeString))
          return XKTW;
        if ("_OregonAthapaskan".equals(codeString))
          return _OREGONATHAPASKAN;
        if ("x-TOL".equals(codeString))
          return XTOL;
        if ("x-TUU".equals(codeString))
          return XTUU;
        if ("_SouthernAlaska".equals(codeString))
          return _SOUTHERNALASKA;
        if ("x-AHT".equals(codeString))
          return XAHT;
        if ("x-TFN".equals(codeString))
          return XTFN;
        if ("x-EYA".equals(codeString))
          return XEYA;
        if ("x-TLI".equals(codeString))
          return XTLI;
        if ("_Penutian".equals(codeString))
          return _PENUTIAN;
        if ("_Chinookan".equals(codeString))
          return _CHINOOKAN;
        if ("_UpperChinook".equals(codeString))
          return _UPPERCHINOOK;
        if ("x-WAC".equals(codeString))
          return XWAC;
        if ("_Coosan".equals(codeString))
          return _COOSAN;
        if ("x-COS".equals(codeString))
          return XCOS;
        if ("_Maiduan".equals(codeString))
          return _MAIDUAN;
        if ("x-MAI".equals(codeString))
          return XMAI;
        if ("x-NMU".equals(codeString))
          return XNMU;
        if ("x-NSZ".equals(codeString))
          return XNSZ;
        if ("_PlateauPenutian".equals(codeString))
          return _PLATEAUPENUTIAN;
        if ("_Sahaptian".equals(codeString))
          return _SAHAPTIAN;
        if ("x-UMA".equals(codeString))
          return XUMA;
        if ("x-WAA".equals(codeString))
          return XWAA;
        if ("x-WAR".equals(codeString))
          return XWAR;
        if ("x-YAK".equals(codeString))
          return XYAK;
        if ("x-KLA".equals(codeString))
          return XKLA;
        if ("x-NEZ".equals(codeString))
          return XNEZ;
        if ("_Takelman".equals(codeString))
          return _TAKELMAN;
        if ("_Kalapuyan".equals(codeString))
          return _KALAPUYAN;
        if ("x-KAL".equals(codeString))
          return XKAL;
        if ("_Tsimshianic".equals(codeString))
          return _TSIMSHIANIC;
        if ("x-TSI".equals(codeString))
          return XTSI;
        if ("_Utian".equals(codeString))
          return _UTIAN;
        if ("_Miwokan".equals(codeString))
          return _MIWOKAN;
        if ("_EasternMiwok".equals(codeString))
          return _EASTERNMIWOK;
        if ("x-CSM".equals(codeString))
          return XCSM;
        if ("x-NSQ".equals(codeString))
          return XNSQ;
        if ("x-PMW".equals(codeString))
          return XPMW;
        if ("x-SKD".equals(codeString))
          return XSKD;
        if ("_WesternMiwok".equals(codeString))
          return _WESTERNMIWOK;
        if ("x-CSI".equals(codeString))
          return XCSI;
        if ("x-LMW".equals(codeString))
          return XLMW;
        if ("_Wintuan".equals(codeString))
          return _WINTUAN;
        if ("x-WIT".equals(codeString))
          return XWIT;
        if ("_Yokutsan".equals(codeString))
          return _YOKUTSAN;
        if ("x-ENH".equals(codeString))
          return XENH;
        if ("x-GSH".equals(codeString))
          return XGSH;
        if ("x-PYL".equals(codeString))
          return XPYL;
        if ("x-TKH".equals(codeString))
          return XTKH;
        if ("_Pidgin".equals(codeString))
          return _PIDGIN;
        if ("x-CHH".equals(codeString))
          return XCHH;
        if ("_Salishan".equals(codeString))
          return _SALISHAN;
        if ("_CentralSalish".equals(codeString))
          return _CENTRALSALISH;
        if ("x-CLM".equals(codeString))
          return XCLM;
        if ("x-LUT".equals(codeString))
          return XLUT;
        if ("x-STR".equals(codeString))
          return XSTR;
        if ("_InteriorSalish".equals(codeString))
          return _INTERIORSALISH;
        if ("x-COL".equals(codeString))
          return XCOL;
        if ("x-CRD".equals(codeString))
          return XCRD;
        if ("x-FLA".equals(codeString))
          return XFLA;
        if ("x-OKA".equals(codeString))
          return XOKA;
        if ("_Tsamosan".equals(codeString))
          return _TSAMOSAN;
        if ("x-CEA".equals(codeString))
          return XCEA;
        if ("x-CJH".equals(codeString))
          return XCJH;
        if ("x-COW".equals(codeString))
          return XCOW;
        if ("x-QUN".equals(codeString))
          return XQUN;
        if ("_SiouanCatawba".equals(codeString))
          return _SIOUANCATAWBA;
        if ("_Siouan".equals(codeString))
          return _SIOUAN;
        if ("_MississippiValley".equals(codeString))
          return _MISSISSIPPIVALLEY;
        if ("_ChiwereWinnebago".equals(codeString))
          return _CHIWEREWINNEBAGO;
        if ("x-IOW".equals(codeString))
          return XIOW;
        if ("x-WIN".equals(codeString))
          return XWIN;
        if ("_Dakotan".equals(codeString))
          return _DAKOTAN;
        if ("x-ASB".equals(codeString))
          return XASB;
        if ("x-DHG".equals(codeString))
          return XDHG;
        if ("x-LKT".equals(codeString))
          return XLKT;
        if ("x-NKT".equals(codeString))
          return XNKT;
        if ("_Dhegiha".equals(codeString))
          return _DHEGIHA;
        if ("x-KAA".equals(codeString))
          return XKAA;
        if ("x-OMA".equals(codeString))
          return XOMA;
        if ("x-OSA".equals(codeString))
          return XOSA;
        if ("x-QUA".equals(codeString))
          return XQUA;
        if ("_MissouriRiver".equals(codeString))
          return _MISSOURIRIVER;
        if ("x-CRO".equals(codeString))
          return XCRO;
        if ("x-HID".equals(codeString))
          return XHID;
        if ("x-MHQ".equals(codeString))
          return XMHQ;
        if ("_UtoAztecan".equals(codeString))
          return _UTOAZTECAN;
        if ("_Numic".equals(codeString))
          return _NUMIC;
        if ("_CentralNumic".equals(codeString))
          return _CENTRALNUMIC;
        if ("x-COM".equals(codeString))
          return XCOM;
        if ("x-PAR".equals(codeString))
          return XPAR;
        if ("x-SHH".equals(codeString))
          return XSHH;
        if ("_SouthernNumic".equals(codeString))
          return _SOUTHERNNUMIC;
        if ("x-KAW".equals(codeString))
          return XKAW;
        if ("x-UTE".equals(codeString))
          return XUTE;
        if ("_WesternNumic".equals(codeString))
          return _WESTERNNUMIC;
        if ("x-MON".equals(codeString))
          return XMON;
        if ("x-PAO".equals(codeString))
          return XPAO;
        if ("_Takic".equals(codeString))
          return _TAKIC;
        if ("_Cupan".equals(codeString))
          return _CUPAN;
        if ("x-CHL".equals(codeString))
          return XCHL;
        if ("x-CUP".equals(codeString))
          return XCUP;
        if ("x-LUI".equals(codeString))
          return XLUI;
        if ("_SerranoGabrielino".equals(codeString))
          return _SERRANOGABRIELINO;
        if ("x-SER".equals(codeString))
          return XSER;
        if ("_Taracahitan".equals(codeString))
          return _TARACAHITAN;
        if ("_Cahitan".equals(codeString))
          return _CAHITAN;
        if ("x-YAQ".equals(codeString))
          return XYAQ;
        if ("_Tepiman".equals(codeString))
          return _TEPIMAN;
        if ("x-PAP".equals(codeString))
          return XPAP;
        if ("x-HOP".equals(codeString))
          return XHOP;
        if ("x-TUB".equals(codeString))
          return XTUB;
        if ("_Wakashan".equals(codeString))
          return _WAKASHAN;
        if ("_Nootkan".equals(codeString))
          return _NOOTKAN;
        if ("x-MYH".equals(codeString))
          return XMYH;
        if ("_Yukian".equals(codeString))
          return _YUKIAN;
        if ("x-WAO".equals(codeString))
          return XWAO;
        if ("x-YUK".equals(codeString))
          return XYUK;
        if ("x-HAI".equals(codeString))
          return XHAI;
        if ("x-KUN".equals(codeString))
          return XKUN;
        if ("x-PSD".equals(codeString))
          return XPSD;
        if ("x-YUC".equals(codeString))
          return XYUC;
        if ("x-ZUN".equals(codeString))
          return XZUN;
        throw new FHIRException("Unknown V3AmericanIndianAlaskaNativeLanguages code '"+codeString+"'");
        }
        public String toCode() {
          switch (this) {
            case _ALGIC: return "_Algic";
            case _ALGONQUIAN: return "_Algonquian";
            case _ARAPAHOAN: return "_Arapahoan";
            case _ARAPAHOGROSVENTRE: return "_ArapahoGrosVentre";
            case XARP: return "x-ARP";
            case XATS: return "x-ATS";
            case _CREEMONTAGNAIS: return "_CreeMontagnais";
            case _CREE: return "_Cree";
            case XCRP: return "x-CRP";
            case _EASTERNALGONQUIN: return "_EasternAlgonquin";
            case _ABENAKIAN: return "_Abenakian";
            case XAAQ: return "x-AAQ";
            case XABE: return "x-ABE";
            case XMAC: return "x-MAC";
            case _DELAWARAN: return "_Delawaran";
            case XDEL: return "x-DEL";
            case XMIC: return "x-MIC";
            case _OJIBWAYAN: return "_Ojibwayan";
            case XOJB: return "x-OJB";
            case XPOT: return "x-POT";
            case _SAUKFOXKICKAPOO: return "_SaukFoxKickapoo";
            case XKIC: return "x-KIC";
            case XSAC: return "x-SAC";
            case XSJW: return "x-SJW";
            case XBLC: return "x-BLC";
            case XCHY: return "x-CHY";
            case XMEZ: return "x-MEZ";
            case _RITWAN: return "_Ritwan";
            case XYUR: return "x-YUR";
            case _CADDOAN: return "_Caddoan";
            case _NORTHERNCADDOAN: return "_NorthernCaddoan";
            case XARI: return "x-ARI";
            case XPAW: return "x-PAW";
            case XWIC: return "x-WIC";
            case _SOUTHERNCADDOAN: return "_SouthernCaddoan";
            case XCAD: return "x-CAD";
            case _CHIMAKUAN: return "_Chimakuan";
            case XQUI: return "x-QUI";
            case _ESKIMOALEUT: return "_EskimoAleut";
            case _ALEUT: return "_Aleut";
            case XALW: return "x-ALW";
            case _ESKIMOAN: return "_Eskimoan";
            case _INUITINUPIAQ: return "_InuitInupiaq";
            case XESI: return "x-ESI";
            case XESK: return "x-ESK";
            case _SIRENIKSKIYUPIK: return "_SirenikskiYupik";
            case XEMS: return "x-EMS";
            case XESS: return "x-ESS";
            case XESU: return "x-ESU";
            case _HOKAN: return "_Hokan";
            case _COCHIMIYUMAN: return "_CochimiYuman";
            case _YUMAN: return "_Yuman";
            case _DELTACALIFORNIA: return "_DeltaCalifornia";
            case _DIEGUENO: return "_Diegueno";
            case XDIH: return "x-DIH";
            case XCOC: return "x-COC";
            case _PAI: return "_Pai";
            case XYUF: return "x-YUF";
            case _RIVER: return "_River";
            case XMOV: return "x-MOV";
            case XMRC: return "x-MRC";
            case XYUM: return "x-YUM";
            case _PALAIHNIHAN: return "_Palaihnihan";
            case XACH: return "x-ACH";
            case XATW: return "x-ATW";
            case _POMOAN: return "_Pomoan";
            case XKJU: return "x-KJU";
            case XPEF: return "x-PEF";
            case XPEO: return "x-PEO";
            case XPEQ: return "x-PEQ";
            case XPOO: return "x-POO";
            case _SHASTA: return "_Shasta";
            case XSHT: return "x-SHT";
            case XKYH: return "x-KYH";
            case XWAS: return "x-WAS";
            case _IROQUOIAN: return "_Iroquoian";
            case _NORTHERNIROQUOIAN: return "_NorthernIroquoian";
            case XCAY: return "x-CAY";
            case XMOH: return "x-MOH";
            case XONE: return "x-ONE";
            case XONO: return "x-ONO";
            case XSEE: return "x-SEE";
            case XTUS: return "x-TUS";
            case XCER: return "x-CER";
            case _KERESAN: return "_Keresan";
            case XKEE: return "x-KEE";
            case XKJQ: return "x-KJQ";
            case _KIOWATANOAN: return "_KiowaTanoan";
            case _TIWA: return "_Tiwa";
            case XTAO: return "x-TAO";
            case XTIX: return "x-TIX";
            case XKIO: return "x-KIO";
            case XTEW: return "x-TEW";
            case XTOW: return "x-TOW";
            case _MUSKOGEAN: return "_Muskogean";
            case _CENTRALMUSKOGEAN: return "_CentralMuskogean";
            case XAKZ: return "x-AKZ";
            case XCKU: return "x-CKU";
            case XMIK: return "x-MIK";
            case _WESTERNMUSKOGEAN: return "_WesternMuskogean";
            case XCCT: return "x-CCT";
            case XCIC: return "x-CIC";
            case XCRK: return "x-CRK";
            case _NADENE: return "_Nadene";
            case _ATHAPASKANEYAK: return "_AthapaskanEyak";
            case _ATHAPASKAN: return "_Athapaskan";
            case _APACHEAN: return "_Apachean";
            case _EASTERNAPACHEAN: return "_EasternApachean";
            case XAPJ: return "x-APJ";
            case XAPL: return "x-APL";
            case _WESTERNAPACHEAN: return "_WesternApachean";
            case XAPM: return "x-APM";
            case XAPW: return "x-APW";
            case XNAV: return "x-NAV";
            case XAPK: return "x-APK";
            case _CENTRALALASKAYUKON: return "_CentralAlaskaYukon";
            case _KOYUKONINGALIK: return "_KoyukonIngalik";
            case XHOI: return "x-HOI";
            case XING: return "x-ING";
            case XKOY: return "x-KOY";
            case _KUTCHINHAN: return "_KutchinHan";
            case XHAA: return "x-HAA";
            case XKUC: return "x-KUC";
            case _TANANATUTCHONE: return "_TananaTutchone";
            case _TANANA: return "_Tanana";
            case XTAA: return "x-TAA";
            case XTAU: return "x-TAU";
            case XTCB: return "x-TCB";
            case XKUU: return "x-KUU";
            case _PACIFICCOASTATHAPASKAN: return "_PacificCoastAthapaskan";
            case _CALIFORNIAATHAPASKAN: return "_CaliforniaAthapaskan";
            case XHUP: return "x-HUP";
            case XKTW: return "x-KTW";
            case _OREGONATHAPASKAN: return "_OregonAthapaskan";
            case XTOL: return "x-TOL";
            case XTUU: return "x-TUU";
            case _SOUTHERNALASKA: return "_SouthernAlaska";
            case XAHT: return "x-AHT";
            case XTFN: return "x-TFN";
            case XEYA: return "x-EYA";
            case XTLI: return "x-TLI";
            case _PENUTIAN: return "_Penutian";
            case _CHINOOKAN: return "_Chinookan";
            case _UPPERCHINOOK: return "_UpperChinook";
            case XWAC: return "x-WAC";
            case _COOSAN: return "_Coosan";
            case XCOS: return "x-COS";
            case _MAIDUAN: return "_Maiduan";
            case XMAI: return "x-MAI";
            case XNMU: return "x-NMU";
            case XNSZ: return "x-NSZ";
            case _PLATEAUPENUTIAN: return "_PlateauPenutian";
            case _SAHAPTIAN: return "_Sahaptian";
            case XUMA: return "x-UMA";
            case XWAA: return "x-WAA";
            case XWAR: return "x-WAR";
            case XYAK: return "x-YAK";
            case XKLA: return "x-KLA";
            case XNEZ: return "x-NEZ";
            case _TAKELMAN: return "_Takelman";
            case _KALAPUYAN: return "_Kalapuyan";
            case XKAL: return "x-KAL";
            case _TSIMSHIANIC: return "_Tsimshianic";
            case XTSI: return "x-TSI";
            case _UTIAN: return "_Utian";
            case _MIWOKAN: return "_Miwokan";
            case _EASTERNMIWOK: return "_EasternMiwok";
            case XCSM: return "x-CSM";
            case XNSQ: return "x-NSQ";
            case XPMW: return "x-PMW";
            case XSKD: return "x-SKD";
            case _WESTERNMIWOK: return "_WesternMiwok";
            case XCSI: return "x-CSI";
            case XLMW: return "x-LMW";
            case _WINTUAN: return "_Wintuan";
            case XWIT: return "x-WIT";
            case _YOKUTSAN: return "_Yokutsan";
            case XENH: return "x-ENH";
            case XGSH: return "x-GSH";
            case XPYL: return "x-PYL";
            case XTKH: return "x-TKH";
            case _PIDGIN: return "_Pidgin";
            case XCHH: return "x-CHH";
            case _SALISHAN: return "_Salishan";
            case _CENTRALSALISH: return "_CentralSalish";
            case XCLM: return "x-CLM";
            case XLUT: return "x-LUT";
            case XSTR: return "x-STR";
            case _INTERIORSALISH: return "_InteriorSalish";
            case XCOL: return "x-COL";
            case XCRD: return "x-CRD";
            case XFLA: return "x-FLA";
            case XOKA: return "x-OKA";
            case _TSAMOSAN: return "_Tsamosan";
            case XCEA: return "x-CEA";
            case XCJH: return "x-CJH";
            case XCOW: return "x-COW";
            case XQUN: return "x-QUN";
            case _SIOUANCATAWBA: return "_SiouanCatawba";
            case _SIOUAN: return "_Siouan";
            case _MISSISSIPPIVALLEY: return "_MississippiValley";
            case _CHIWEREWINNEBAGO: return "_ChiwereWinnebago";
            case XIOW: return "x-IOW";
            case XWIN: return "x-WIN";
            case _DAKOTAN: return "_Dakotan";
            case XASB: return "x-ASB";
            case XDHG: return "x-DHG";
            case XLKT: return "x-LKT";
            case XNKT: return "x-NKT";
            case _DHEGIHA: return "_Dhegiha";
            case XKAA: return "x-KAA";
            case XOMA: return "x-OMA";
            case XOSA: return "x-OSA";
            case XQUA: return "x-QUA";
            case _MISSOURIRIVER: return "_MissouriRiver";
            case XCRO: return "x-CRO";
            case XHID: return "x-HID";
            case XMHQ: return "x-MHQ";
            case _UTOAZTECAN: return "_UtoAztecan";
            case _NUMIC: return "_Numic";
            case _CENTRALNUMIC: return "_CentralNumic";
            case XCOM: return "x-COM";
            case XPAR: return "x-PAR";
            case XSHH: return "x-SHH";
            case _SOUTHERNNUMIC: return "_SouthernNumic";
            case XKAW: return "x-KAW";
            case XUTE: return "x-UTE";
            case _WESTERNNUMIC: return "_WesternNumic";
            case XMON: return "x-MON";
            case XPAO: return "x-PAO";
            case _TAKIC: return "_Takic";
            case _CUPAN: return "_Cupan";
            case XCHL: return "x-CHL";
            case XCUP: return "x-CUP";
            case XLUI: return "x-LUI";
            case _SERRANOGABRIELINO: return "_SerranoGabrielino";
            case XSER: return "x-SER";
            case _TARACAHITAN: return "_Taracahitan";
            case _CAHITAN: return "_Cahitan";
            case XYAQ: return "x-YAQ";
            case _TEPIMAN: return "_Tepiman";
            case XPAP: return "x-PAP";
            case XHOP: return "x-HOP";
            case XTUB: return "x-TUB";
            case _WAKASHAN: return "_Wakashan";
            case _NOOTKAN: return "_Nootkan";
            case XMYH: return "x-MYH";
            case _YUKIAN: return "_Yukian";
            case XWAO: return "x-WAO";
            case XYUK: return "x-YUK";
            case XHAI: return "x-HAI";
            case XKUN: return "x-KUN";
            case XPSD: return "x-PSD";
            case XYUC: return "x-YUC";
            case XZUN: return "x-ZUN";
            case NULL: return null;
            default: return "?";
          }
        }
        public String getSystem() {
          return "http://hl7.org/fhir/v3/AmericanIndianAlaskaNativeLanguages";
        }
        public String getDefinition() {
          switch (this) {
            case _ALGIC: return "Algic";
            case _ALGONQUIAN: return "Algonquian";
            case _ARAPAHOAN: return "Arapahoan";
            case _ARAPAHOGROSVENTRE: return "ArapahoGrosVentre";
            case XARP: return "Arapaho";
            case XATS: return "Gros Ventre";
            case _CREEMONTAGNAIS: return "CreeMontagnais";
            case _CREE: return "Cree";
            case XCRP: return "Western Cree";
            case _EASTERNALGONQUIN: return "EasternAlgonquin";
            case _ABENAKIAN: return "Abenakian";
            case XAAQ: return "Eastern Abenaki";
            case XABE: return "Western Abenaki";
            case XMAC: return "Maliseet-Passamaquoddy";
            case _DELAWARAN: return "Delawaran";
            case XDEL: return "Unami Delaware";
            case XMIC: return "Micmac";
            case _OJIBWAYAN: return "Ojibwayan";
            case XOJB: return "Southern Ojibwa";
            case XPOT: return "Potawatami";
            case _SAUKFOXKICKAPOO: return "SaukFoxKickapoo";
            case XKIC: return "Kickapoo";
            case XSAC: return "Mesquakie";
            case XSJW: return "Shawnee";
            case XBLC: return "Blackfoot";
            case XCHY: return "Cheyenne";
            case XMEZ: return "Menominee";
            case _RITWAN: return "Ritwan";
            case XYUR: return "Yurok";
            case _CADDOAN: return "Caddoan";
            case _NORTHERNCADDOAN: return "NorthernCaddoan";
            case XARI: return "Arikara";
            case XPAW: return "Pawnee";
            case XWIC: return "Wichita";
            case _SOUTHERNCADDOAN: return "SouthernCaddoan";
            case XCAD: return "Caddo";
            case _CHIMAKUAN: return "Chimakuan";
            case XQUI: return "Quileute";
            case _ESKIMOALEUT: return "EskimoAleut";
            case _ALEUT: return "Aleut";
            case XALW: return "Aleut";
            case _ESKIMOAN: return "Eskimoan";
            case _INUITINUPIAQ: return "InuitInupiaq";
            case XESI: return "North Alaskan Inuktitut";
            case XESK: return "Northwest Alaska Inuktitut";
            case _SIRENIKSKIYUPIK: return "SirenikskiYupik";
            case XEMS: return "Pacific Yupik Gulf";
            case XESS: return "Central Siberian Yupik";
            case XESU: return "Central Alaskan Yupik";
            case _HOKAN: return "Hokan";
            case _COCHIMIYUMAN: return "CochimiYuman";
            case _YUMAN: return "Yuman";
            case _DELTACALIFORNIA: return "DeltaCalifornia";
            case _DIEGUENO: return "Diegueno";
            case XDIH: return "Kumeyaay";
            case XCOC: return "Cocopa";
            case _PAI: return "Pai";
            case XYUF: return "Havasupai";
            case _RIVER: return "River";
            case XMOV: return "Mohave";
            case XMRC: return "Maricopa";
            case XYUM: return "Quechan";
            case _PALAIHNIHAN: return "Palaihnihan";
            case XACH: return "Achumawi";
            case XATW: return "Atsugewi";
            case _POMOAN: return "Pomoan";
            case XKJU: return "Kashaya";
            case XPEF: return "Northeastern Pomo";
            case XPEO: return "Southeastern Pomo";
            case XPEQ: return "Southern Pomo";
            case XPOO: return "Central Pomo";
            case _SHASTA: return "Shasta";
            case XSHT: return "Shasta";
            case XKYH: return "Karok";
            case XWAS: return "Washoe";
            case _IROQUOIAN: return "Iroquoian";
            case _NORTHERNIROQUOIAN: return "NorthernIroquoian";
            case XCAY: return "Cayuga";
            case XMOH: return "Mohawk";
            case XONE: return "Oneida";
            case XONO: return "Onondaga";
            case XSEE: return "Seneca";
            case XTUS: return "Tuscarora";
            case XCER: return "Cherokee";
            case _KERESAN: return "Keresan";
            case XKEE: return "Rio Grande Keresan";
            case XKJQ: return "Acoma-Laguna";
            case _KIOWATANOAN: return "KiowaTanoan";
            case _TIWA: return "Tiwa";
            case XTAO: return "Northern Tiwa";
            case XTIX: return "Southern Tiwa";
            case XKIO: return "Kiowa";
            case XTEW: return "Tewa";
            case XTOW: return "Jemez";
            case _MUSKOGEAN: return "Muskogean";
            case _CENTRALMUSKOGEAN: return "CentralMuskogean";
            case XAKZ: return "Alabama";
            case XCKU: return "Koasati";
            case XMIK: return "Mikasuki";
            case _WESTERNMUSKOGEAN: return "WesternMuskogean";
            case XCCT: return "Choctaw";
            case XCIC: return "Chickasaw";
            case XCRK: return "Creek";
            case _NADENE: return "Nadene";
            case _ATHAPASKANEYAK: return "AthapaskanEyak";
            case _ATHAPASKAN: return "Athapaskan";
            case _APACHEAN: return "Apachean";
            case _EASTERNAPACHEAN: return "EasternApachean";
            case XAPJ: return "Jicarilla";
            case XAPL: return "Lipan";
            case _WESTERNAPACHEAN: return "WesternApachean";
            case XAPM: return "Mescalero-Chiricahua";
            case XAPW: return "Western Apache";
            case XNAV: return "Dine";
            case XAPK: return "Kiowa Apache";
            case _CENTRALALASKAYUKON: return "CentralAlaskaYukon";
            case _KOYUKONINGALIK: return "KoyukonIngalik";
            case XHOI: return "Holikachuk";
            case XING: return "Degexit'an";
            case XKOY: return "Koyukon";
            case _KUTCHINHAN: return "KutchinHan";
            case XHAA: return "Han";
            case XKUC: return "Kutchin";
            case _TANANATUTCHONE: return "TananaTutchone";
            case _TANANA: return "Tanana";
            case XTAA: return "Lower Tanana";
            case XTAU: return "Upper Tanana";
            case XTCB: return "Tanacross";
            case XKUU: return "Upper Kuskokwim";
            case _PACIFICCOASTATHAPASKAN: return "PacificCoastAthapaskan";
            case _CALIFORNIAATHAPASKAN: return "CaliforniaAthapaskan";
            case XHUP: return "Hupa";
            case XKTW: return "Cahto";
            case _OREGONATHAPASKAN: return "OregonAthapaskan";
            case XTOL: return "Tolowa";
            case XTUU: return "Tututni";
            case _SOUTHERNALASKA: return "SouthernAlaska";
            case XAHT: return "Ahtna";
            case XTFN: return "Tanaina";
            case XEYA: return "Eyak";
            case XTLI: return "Tlingit";
            case _PENUTIAN: return "Penutian";
            case _CHINOOKAN: return "Chinookan";
            case _UPPERCHINOOK: return "UpperChinook";
            case XWAC: return "Kiksht";
            case _COOSAN: return "Coosan";
            case XCOS: return "Hanis";
            case _MAIDUAN: return "Maiduan";
            case XMAI: return "Northwest Maidu";
            case XNMU: return "Northeast Maidu";
            case XNSZ: return "Nisenan";
            case _PLATEAUPENUTIAN: return "PlateauPenutian";
            case _SAHAPTIAN: return "Sahaptian";
            case XUMA: return "Umatilla";
            case XWAA: return "Walla Walla";
            case XWAR: return "Tenino";
            case XYAK: return "Yakima";
            case XKLA: return "Klamath-Modoc";
            case XNEZ: return "Nez Perce";
            case _TAKELMAN: return "Takelman";
            case _KALAPUYAN: return "Kalapuyan";
            case XKAL: return "Central Kalapuyan";
            case _TSIMSHIANIC: return "Tsimshianic";
            case XTSI: return "Coast Tsimshain";
            case _UTIAN: return "Utian";
            case _MIWOKAN: return "Miwokan";
            case _EASTERNMIWOK: return "EasternMiwok";
            case XCSM: return "Central Sierra Miwok";
            case XNSQ: return "Northern Sierra Miwok";
            case XPMW: return "Plains Miwok";
            case XSKD: return "Southern Sierra Miwok";
            case _WESTERNMIWOK: return "WesternMiwok";
            case XCSI: return "Coast Miwok";
            case XLMW: return "Lake Miwok";
            case _WINTUAN: return "Wintuan";
            case XWIT: return "Wintu-Nomlaki";
            case _YOKUTSAN: return "Yokutsan";
            case XENH: return "Kings River";
            case XGSH: return "Gashowu";
            case XPYL: return "Poso Creek";
            case XTKH: return "Tule-Kaweah";
            case _PIDGIN: return "Pidgin";
            case XCHH: return "Chinook Wawa";
            case _SALISHAN: return "Salishan";
            case _CENTRALSALISH: return "CentralSalish";
            case XCLM: return "Clallam";
            case XLUT: return "Lushootseed";
            case XSTR: return "Northern Straits";
            case _INTERIORSALISH: return "InteriorSalish";
            case XCOL: return "Columbian";
            case XCRD: return "Coeur D'alene";
            case XFLA: return "Kalispel";
            case XOKA: return "Okanagan";
            case _TSAMOSAN: return "Tsamosan";
            case XCEA: return "Lower Chehalis";
            case XCJH: return "Upper Chehalis";
            case XCOW: return "Cowlitz";
            case XQUN: return "Quinault";
            case _SIOUANCATAWBA: return "SiouanCatawba";
            case _SIOUAN: return "Siouan";
            case _MISSISSIPPIVALLEY: return "MississippiValley";
            case _CHIWEREWINNEBAGO: return "ChiwereWinnebago";
            case XIOW: return "Chiwere";
            case XWIN: return "Hocak";
            case _DAKOTAN: return "Dakotan";
            case XASB: return "Assiniboine";
            case XDHG: return "Dakota";
            case XLKT: return "Lakota";
            case XNKT: return "Nakota";
            case _DHEGIHA: return "Dhegiha";
            case XKAA: return "Kansa";
            case XOMA: return "Omaha-Ponca";
            case XOSA: return "Osage";
            case XQUA: return "Quapaw";
            case _MISSOURIRIVER: return "MissouriRiver";
            case XCRO: return "Crow";
            case XHID: return "Hidatsa";
            case XMHQ: return "Mandan";
            case _UTOAZTECAN: return "UtoAztecan";
            case _NUMIC: return "Numic";
            case _CENTRALNUMIC: return "CentralNumic";
            case XCOM: return "Comanche";
            case XPAR: return "Panamint";
            case XSHH: return "Shoshone";
            case _SOUTHERNNUMIC: return "SouthernNumic";
            case XKAW: return "Kawaiisu";
            case XUTE: return "Ute-Southern Paiute";
            case _WESTERNNUMIC: return "WesternNumic";
            case XMON: return "Mono";
            case XPAO: return "Northern Paiute-Bannock";
            case _TAKIC: return "Takic";
            case _CUPAN: return "Cupan";
            case XCHL: return "Cahuilla";
            case XCUP: return "Cupeno";
            case XLUI: return "Luiseno";
            case _SERRANOGABRIELINO: return "SerranoGabrielino";
            case XSER: return "Serrano";
            case _TARACAHITAN: return "Taracahitan";
            case _CAHITAN: return "Cahitan";
            case XYAQ: return "Yaqui";
            case _TEPIMAN: return "Tepiman";
            case XPAP: return "Papago-Pima";
            case XHOP: return "Hopi";
            case XTUB: return "Tubatululabal";
            case _WAKASHAN: return "Wakashan";
            case _NOOTKAN: return "Nootkan";
            case XMYH: return "Makah";
            case _YUKIAN: return "Yukian";
            case XWAO: return "Wappo";
            case XYUK: return "Yuki";
            case XHAI: return "Haida";
            case XKUN: return "Kootenai";
            case XPSD: return "Plains Indian Sign Language";
            case XYUC: return "Yuchi";
            case XZUN: return "Zuni";
            case NULL: return null;
            default: return "?";
          }
        }
        public String getDisplay() {
          switch (this) {
            case _ALGIC: return "Algic";
            case _ALGONQUIAN: return "Algonquian";
            case _ARAPAHOAN: return "Arapahoan";
            case _ARAPAHOGROSVENTRE: return "ArapahoGrosVentre";
            case XARP: return "Arapaho";
            case XATS: return "Gros Ventre";
            case _CREEMONTAGNAIS: return "CreeMontagnais";
            case _CREE: return "Cree";
            case XCRP: return "Western Cree";
            case _EASTERNALGONQUIN: return "EasternAlgonquin";
            case _ABENAKIAN: return "Abenakian";
            case XAAQ: return "Eastern Abenaki";
            case XABE: return "Western Abenaki";
            case XMAC: return "Maliseet-Passamaquoddy";
            case _DELAWARAN: return "Delawaran";
            case XDEL: return "Unami Delaware";
            case XMIC: return "Micmac";
            case _OJIBWAYAN: return "Ojibwayan";
            case XOJB: return "Southern Ojibwa";
            case XPOT: return "Potawatami";
            case _SAUKFOXKICKAPOO: return "SaukFoxKickapoo";
            case XKIC: return "Kickapoo";
            case XSAC: return "Mesquakie";
            case XSJW: return "Shawnee";
            case XBLC: return "Blackfoot";
            case XCHY: return "Cheyenne";
            case XMEZ: return "Menominee";
            case _RITWAN: return "Ritwan";
            case XYUR: return "Yurok";
            case _CADDOAN: return "Caddoan";
            case _NORTHERNCADDOAN: return "NorthernCaddoan";
            case XARI: return "Arikara";
            case XPAW: return "Pawnee";
            case XWIC: return "Wichita";
            case _SOUTHERNCADDOAN: return "SouthernCaddoan";
            case XCAD: return "Caddo";
            case _CHIMAKUAN: return "Chimakuan";
            case XQUI: return "Quileute";
            case _ESKIMOALEUT: return "EskimoAleut";
            case _ALEUT: return "Aleut";
            case XALW: return "Aleut";
            case _ESKIMOAN: return "Eskimoan";
            case _INUITINUPIAQ: return "InuitInupiaq";
            case XESI: return "North Alaskan Inuktitut";
            case XESK: return "Northwest Alaska Inuktitut";
            case _SIRENIKSKIYUPIK: return "SirenikskiYupik";
            case XEMS: return "Pacific Yupik Gulf";
            case XESS: return "Central Siberian Yupik";
            case XESU: return "Central Alaskan Yupik";
            case _HOKAN: return "Hokan";
            case _COCHIMIYUMAN: return "CochimiYuman";
            case _YUMAN: return "Yuman";
            case _DELTACALIFORNIA: return "DeltaCalifornia";
            case _DIEGUENO: return "Diegueno";
            case XDIH: return "Kumeyaay";
            case XCOC: return "Cocopa";
            case _PAI: return "Pai";
            case XYUF: return "Havasupai";
            case _RIVER: return "River";
            case XMOV: return "Mohave";
            case XMRC: return "Maricopa";
            case XYUM: return "Quechan";
            case _PALAIHNIHAN: return "Palaihnihan";
            case XACH: return "Achumawi";
            case XATW: return "Atsugewi";
            case _POMOAN: return "Pomoan";
            case XKJU: return "Kashaya";
            case XPEF: return "Northeastern Pomo";
            case XPEO: return "Southeastern Pomo";
            case XPEQ: return "Southern Pomo";
            case XPOO: return "Central Pomo";
            case _SHASTA: return "Shasta";
            case XSHT: return "Shasta";
            case XKYH: return "Karok";
            case XWAS: return "Washoe";
            case _IROQUOIAN: return "Iroquoian";
            case _NORTHERNIROQUOIAN: return "NorthernIroquoian";
            case XCAY: return "Cayuga";
            case XMOH: return "Mohawk";
            case XONE: return "Oneida";
            case XONO: return "Onondaga";
            case XSEE: return "Seneca";
            case XTUS: return "Tuscarora";
            case XCER: return "Cherokee";
            case _KERESAN: return "Keresan";
            case XKEE: return "Rio Grande Keresan";
            case XKJQ: return "Acoma-Laguna";
            case _KIOWATANOAN: return "KiowaTanoan";
            case _TIWA: return "Tiwa";
            case XTAO: return "Northern Tiwa";
            case XTIX: return "Southern Tiwa";
            case XKIO: return "Kiowa";
            case XTEW: return "Tewa";
            case XTOW: return "Jemez";
            case _MUSKOGEAN: return "Muskogean";
            case _CENTRALMUSKOGEAN: return "CentralMuskogean";
            case XAKZ: return "Alabama";
            case XCKU: return "Koasati";
            case XMIK: return "Mikasuki";
            case _WESTERNMUSKOGEAN: return "WesternMuskogean";
            case XCCT: return "Choctaw";
            case XCIC: return "Chickasaw";
            case XCRK: return "Creek";
            case _NADENE: return "Nadene";
            case _ATHAPASKANEYAK: return "AthapaskanEyak";
            case _ATHAPASKAN: return "Athapaskan";
            case _APACHEAN: return "Apachean";
            case _EASTERNAPACHEAN: return "EasternApachean";
            case XAPJ: return "Jicarilla";
            case XAPL: return "Lipan";
            case _WESTERNAPACHEAN: return "WesternApachean";
            case XAPM: return "Mescalero-Chiricahua";
            case XAPW: return "Western Apache";
            case XNAV: return "Dine";
            case XAPK: return "Kiowa Apache";
            case _CENTRALALASKAYUKON: return "CentralAlaskaYukon";
            case _KOYUKONINGALIK: return "KoyukonIngalik";
            case XHOI: return "Holikachuk";
            case XING: return "Degexit'an";
            case XKOY: return "Koyukon";
            case _KUTCHINHAN: return "KutchinHan";
            case XHAA: return "Han";
            case XKUC: return "Kutchin";
            case _TANANATUTCHONE: return "TananaTutchone";
            case _TANANA: return "Tanana";
            case XTAA: return "Lower Tanana";
            case XTAU: return "Upper Tanana";
            case XTCB: return "Tanacross";
            case XKUU: return "Upper Kuskokwim";
            case _PACIFICCOASTATHAPASKAN: return "PacificCoastAthapaskan";
            case _CALIFORNIAATHAPASKAN: return "CaliforniaAthapaskan";
            case XHUP: return "Hupa";
            case XKTW: return "Cahto";
            case _OREGONATHAPASKAN: return "OregonAthapaskan";
            case XTOL: return "Tolowa";
            case XTUU: return "Tututni";
            case _SOUTHERNALASKA: return "SouthernAlaska";
            case XAHT: return "Ahtna";
            case XTFN: return "Tanaina";
            case XEYA: return "Eyak";
            case XTLI: return "Tlingit";
            case _PENUTIAN: return "Penutian";
            case _CHINOOKAN: return "Chinookan";
            case _UPPERCHINOOK: return "UpperChinook";
            case XWAC: return "Kiksht";
            case _COOSAN: return "Coosan";
            case XCOS: return "Hanis";
            case _MAIDUAN: return "Maiduan";
            case XMAI: return "Northwest Maidu";
            case XNMU: return "Northeast Maidu";
            case XNSZ: return "Nisenan";
            case _PLATEAUPENUTIAN: return "PlateauPenutian";
            case _SAHAPTIAN: return "Sahaptian";
            case XUMA: return "Umatilla";
            case XWAA: return "Walla Walla";
            case XWAR: return "Tenino";
            case XYAK: return "Yakima";
            case XKLA: return "Klamath-Modoc";
            case XNEZ: return "Nez Perce";
            case _TAKELMAN: return "Takelman";
            case _KALAPUYAN: return "Kalapuyan";
            case XKAL: return "Central Kalapuyan";
            case _TSIMSHIANIC: return "Tsimshianic";
            case XTSI: return "Coast Tsimshain";
            case _UTIAN: return "Utian";
            case _MIWOKAN: return "Miwokan";
            case _EASTERNMIWOK: return "EasternMiwok";
            case XCSM: return "Central Sierra Miwok";
            case XNSQ: return "Northern Sierra Miwok";
            case XPMW: return "Plains Miwok";
            case XSKD: return "Southern Sierra Miwok";
            case _WESTERNMIWOK: return "WesternMiwok";
            case XCSI: return "Coast Miwok";
            case XLMW: return "Lake Miwok";
            case _WINTUAN: return "Wintuan";
            case XWIT: return "Wintu-Nomlaki";
            case _YOKUTSAN: return "Yokutsan";
            case XENH: return "Kings River";
            case XGSH: return "Gashowu";
            case XPYL: return "Poso Creek";
            case XTKH: return "Tule-Kaweah";
            case _PIDGIN: return "Pidgin";
            case XCHH: return "Chinook Wawa";
            case _SALISHAN: return "Salishan";
            case _CENTRALSALISH: return "CentralSalish";
            case XCLM: return "Clallam";
            case XLUT: return "Lushootseed";
            case XSTR: return "Northern Straits";
            case _INTERIORSALISH: return "InteriorSalish";
            case XCOL: return "Columbian";
            case XCRD: return "Coeur D'alene";
            case XFLA: return "Kalispel";
            case XOKA: return "Okanagan";
            case _TSAMOSAN: return "Tsamosan";
            case XCEA: return "Lower Chehalis";
            case XCJH: return "Upper Chehalis";
            case XCOW: return "Cowlitz";
            case XQUN: return "Quinault";
            case _SIOUANCATAWBA: return "SiouanCatawba";
            case _SIOUAN: return "Siouan";
            case _MISSISSIPPIVALLEY: return "MississippiValley";
            case _CHIWEREWINNEBAGO: return "ChiwereWinnebago";
            case XIOW: return "Chiwere";
            case XWIN: return "Hocak";
            case _DAKOTAN: return "Dakotan";
            case XASB: return "Assiniboine";
            case XDHG: return "Dakota";
            case XLKT: return "Lakota";
            case XNKT: return "Nakota";
            case _DHEGIHA: return "Dhegiha";
            case XKAA: return "Kansa";
            case XOMA: return "Omaha-Ponca";
            case XOSA: return "Osage";
            case XQUA: return "Quapaw";
            case _MISSOURIRIVER: return "MissouriRiver";
            case XCRO: return "Crow";
            case XHID: return "Hidatsa";
            case XMHQ: return "Mandan";
            case _UTOAZTECAN: return "UtoAztecan";
            case _NUMIC: return "Numic";
            case _CENTRALNUMIC: return "CentralNumic";
            case XCOM: return "Comanche";
            case XPAR: return "Panamint";
            case XSHH: return "Shoshone";
            case _SOUTHERNNUMIC: return "SouthernNumic";
            case XKAW: return "Kawaiisu";
            case XUTE: return "Ute-Southern Paiute";
            case _WESTERNNUMIC: return "WesternNumic";
            case XMON: return "Mono";
            case XPAO: return "Northern Paiute-Bannock";
            case _TAKIC: return "Takic";
            case _CUPAN: return "Cupan";
            case XCHL: return "Cahuilla";
            case XCUP: return "Cupeno";
            case XLUI: return "Luiseno";
            case _SERRANOGABRIELINO: return "SerranoGabrielino";
            case XSER: return "Serrano";
            case _TARACAHITAN: return "Taracahitan";
            case _CAHITAN: return "Cahitan";
            case XYAQ: return "Yaqui";
            case _TEPIMAN: return "Tepiman";
            case XPAP: return "Papago-Pima";
            case XHOP: return "Hopi";
            case XTUB: return "Tubatululabal";
            case _WAKASHAN: return "Wakashan";
            case _NOOTKAN: return "Nootkan";
            case XMYH: return "Makah";
            case _YUKIAN: return "Yukian";
            case XWAO: return "Wappo";
            case XYUK: return "Yuki";
            case XHAI: return "Haida";
            case XKUN: return "Kootenai";
            case XPSD: return "Plains Indian Sign Language";
            case XYUC: return "Yuchi";
            case XZUN: return "Zuni";
            case NULL: return null;
            default: return "?";
          }
    }


}