/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.dstu2016may.formats.IParser;
import org.hl7.fhir.dstu2016may.model.Address;
import org.hl7.fhir.dstu2016may.model.Annotation;
import org.hl7.fhir.dstu2016may.model.Attachment;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.Base64BinaryType;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.Bundle;
import org.hl7.fhir.dstu2016may.model.CodeSystem;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.CompartmentDefinition;
import org.hl7.fhir.dstu2016may.model.Composition;
import org.hl7.fhir.dstu2016may.model.ConceptMap;
import org.hl7.fhir.dstu2016may.model.Conformance;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DateType;
import org.hl7.fhir.dstu2016may.model.DecimalType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.ElementDefinition;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Extension;
import org.hl7.fhir.dstu2016may.model.ExtensionHelper;
import org.hl7.fhir.dstu2016may.model.HumanName;
import org.hl7.fhir.dstu2016may.model.IdType;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.InstantType;
import org.hl7.fhir.dstu2016may.model.IntegerType;
import org.hl7.fhir.dstu2016may.model.Meta;
import org.hl7.fhir.dstu2016may.model.Narrative;
import org.hl7.fhir.dstu2016may.model.OperationDefinition;
import org.hl7.fhir.dstu2016may.model.OperationOutcome;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Quantity;
import org.hl7.fhir.dstu2016may.model.Range;
import org.hl7.fhir.dstu2016may.model.Ratio;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.SampledData;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.StructureDefinition;
import org.hl7.fhir.dstu2016may.model.Timing;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.dstu2016may.terminologies.CodeSystemUtilities;
import org.hl7.fhir.dstu2016may.terminologies.ValueSetExpander;
import org.hl7.fhir.dstu2016may.utils.EOperationOutcome;
import org.hl7.fhir.dstu2016may.utils.INarrativeGenerator;
import org.hl7.fhir.dstu2016may.utils.IWorkerContext;
import org.hl7.fhir.dstu2016may.utils.ProfileUtilities;
import org.hl7.fhir.dstu2016may.utils.ResourceUtilities;
import org.hl7.fhir.dstu2016may.utils.ToolingExtensions;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.MarkDownProcessor;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlDocument;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.hl7.fhir.utilities.xml.XmlGenerator;
import org.w3c.dom.Element;

public class NarrativeGenerator
implements INarrativeGenerator {
    private String prefix;
    private IWorkerContext context;
    private String basePath;
    private String tooCostlyNote;

    public NarrativeGenerator(String prefix, String basePath, IWorkerContext context) {
        this.prefix = prefix;
        this.context = context;
        this.basePath = basePath;
    }

    public String getTooCostlyNote() {
        return this.tooCostlyNote;
    }

    public NarrativeGenerator setTooCostlyNote(String tooCostlyNote) {
        this.tooCostlyNote = tooCostlyNote;
        return this;
    }

    public void generate(DomainResource r) throws EOperationOutcome, FHIRException, IOException {
        if (r instanceof ConceptMap) {
            this.generate((ConceptMap)r);
        } else if (r instanceof ValueSet) {
            this.generate((ValueSet)r, true);
        } else if (r instanceof CodeSystem) {
            this.generate((CodeSystem)r, true);
        } else if (r instanceof OperationOutcome) {
            this.generate((OperationOutcome)r);
        } else if (r instanceof Conformance) {
            this.generate((Conformance)r);
        } else if (r instanceof CompartmentDefinition) {
            this.generate((CompartmentDefinition)r);
        } else if (r instanceof OperationDefinition) {
            this.generate((OperationDefinition)r);
        } else {
            StructureDefinition p = null;
            if (r.hasMeta()) {
                for (UriType pu : r.getMeta().getProfile()) {
                    if (p != null) continue;
                    p = this.context.fetchResource(StructureDefinition.class, (String)pu.getValue());
                }
            }
            if (p == null) {
                p = this.context.fetchResource(StructureDefinition.class, r.getResourceType().toString());
            }
            if (p == null) {
                p = this.context.fetchTypeDefinition(r.getResourceType().toString().toLowerCase());
            }
            if (p != null) {
                this.generateByProfile(r, p, true);
            }
        }
    }

    public String generate(Element doc) throws IOException {
        String rt = "http://hl7.org/fhir/StructureDefinition/" + doc.getNodeName();
        StructureDefinition p = this.context.fetchResource(StructureDefinition.class, rt);
        return this.generateByProfile(doc, p, true);
    }

    private void generateByProfile(DomainResource r, StructureDefinition profile, boolean showCodeDetails) {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.addTag("p").addTag("b").addText("Generated Narrative" + (showCodeDetails ? " with Details" : ""));
        try {
            this.generateByProfile(r, profile, r, profile.getSnapshot().getElement(), profile.getSnapshot().getElement().get(0), this.getChildrenForPath(profile.getSnapshot().getElement(), r.getResourceType().toString()), x, r.getResourceType().toString(), showCodeDetails);
        }
        catch (Exception e) {
            e.printStackTrace();
            x.addTag("p").addTag("b").setAttribute("style", "color: maroon").addText("Exception generating Narrative: " + e.getMessage());
        }
        this.inject(r, x, Narrative.NarrativeStatus.GENERATED);
    }

    private String generateByProfile(Element er, StructureDefinition profile, boolean showCodeDetails) throws IOException {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.addTag("p").addTag("b").addText("Generated Narrative" + (showCodeDetails ? " with Details" : ""));
        try {
            this.generateByProfile(er, profile, er, profile.getSnapshot().getElement(), profile.getSnapshot().getElement().get(0), this.getChildrenForPath(profile.getSnapshot().getElement(), er.getLocalName()), x, er.getLocalName(), showCodeDetails);
        }
        catch (Exception e) {
            e.printStackTrace();
            x.addTag("p").addTag("b").setAttribute("style", "color: maroon").addText("Exception generating Narrative: " + e.getMessage());
        }
        this.inject(er, x, Narrative.NarrativeStatus.GENERATED);
        return new XhtmlComposer(true, false).compose(x);
    }

    private void generateByProfile(Element eres, StructureDefinition profile, Element ee, List<ElementDefinition> allElements, ElementDefinition defn, List<ElementDefinition> children, XhtmlNode x, String path, boolean showCodeDetails) throws FHIRException, UnsupportedEncodingException, IOException {
        ResurceWrapperElement resw = new ResurceWrapperElement(eres, profile);
        BaseWrapperElement base = new BaseWrapperElement(ee, null, profile, profile.getSnapshot().getElement().get(0));
        this.generateByProfile(resw, profile, base, allElements, defn, children, x, path, showCodeDetails);
    }

    private void generateByProfile(Resource res, StructureDefinition profile, Base e, List<ElementDefinition> allElements, ElementDefinition defn, List<ElementDefinition> children, XhtmlNode x, String path, boolean showCodeDetails) throws FHIRException, UnsupportedEncodingException, IOException {
        this.generateByProfile(new ResourceWrapperDirect(res), profile, new BaseWrapperDirect(e), allElements, defn, children, x, path, showCodeDetails);
    }

    private void generateByProfile(ResourceWrapper res, StructureDefinition profile, BaseWrapper e, List<ElementDefinition> allElements, ElementDefinition defn, List<ElementDefinition> children, XhtmlNode x, String path, boolean showCodeDetails) throws FHIRException, UnsupportedEncodingException, IOException {
        if (children.isEmpty()) {
            this.renderLeaf(res, e, defn, x, false, showCodeDetails, this.readDisplayHints(defn));
        } else {
            for (PropertyWrapper p : this.splitExtensions(profile, e.children())) {
                ElementDefinition child;
                if (!p.hasValues() || (child = this.getElementDefinition(children, path + "." + p.getName(), p)) == null) continue;
                Map<String, String> displayHints = this.readDisplayHints(child);
                if (this.exemptFromRendering(child)) continue;
                List<ElementDefinition> grandChildren = this.getChildrenForPath(allElements, path + "." + p.getName());
                this.filterGrandChildren(grandChildren, path + "." + p.getName(), p);
                if (p.getValues().size() <= 0 || child == null) continue;
                if (this.isPrimitive(child)) {
                    XhtmlNode para = x.addTag("p");
                    String name = p.getName();
                    if (name.endsWith("[x]")) {
                        name = name.substring(0, name.length() - 3);
                    }
                    if (!showCodeDetails && this.isDefaultValue(displayHints, p.getValues())) continue;
                    para.addTag("b").addText(name);
                    para.addText(": ");
                    if (this.renderAsList(child) && p.getValues().size() > 1) {
                        XhtmlNode list = x.addTag("ul");
                        for (BaseWrapper v : p.getValues()) {
                            this.renderLeaf(res, v, child, list.addTag("li"), false, showCodeDetails, displayHints);
                        }
                        continue;
                    }
                    boolean first = true;
                    for (BaseWrapper v : p.getValues()) {
                        if (first) {
                            first = false;
                        } else {
                            para.addText(", ");
                        }
                        this.renderLeaf(res, v, child, para, false, showCodeDetails, displayHints);
                    }
                    continue;
                }
                if (this.canDoTable(path, p, grandChildren)) {
                    x.addTag("h3").addText(Utilities.capitalize((String)Utilities.camelCase((String)Utilities.pluralizeMe((String)p.getName()))));
                    XhtmlNode tbl = x.addTag("table").setAttribute("class", "grid");
                    XhtmlNode tr = tbl.addTag("tr");
                    tr.addTag("td").addText("-");
                    this.addColumnHeadings(tr, grandChildren);
                    for (BaseWrapper v : p.getValues()) {
                        if (v == null) continue;
                        tr = tbl.addTag("tr");
                        tr.addTag("td").addText("*");
                        this.addColumnValues(res, tr, grandChildren, v, showCodeDetails, displayHints);
                    }
                    continue;
                }
                for (BaseWrapper v : p.getValues()) {
                    if (v == null) continue;
                    XhtmlNode bq = x.addTag("blockquote");
                    bq.addTag("p").addTag("b").addText(p.getName());
                    this.generateByProfile(res, profile, v, allElements, child, grandChildren, bq, path + "." + p.getName(), showCodeDetails);
                }
            }
        }
    }

    private void filterGrandChildren(List<ElementDefinition> grandChildren, String string, PropertyWrapper prop) {
        ArrayList<ElementDefinition> toRemove = new ArrayList<ElementDefinition>();
        toRemove.addAll(grandChildren);
        for (BaseWrapper b : prop.getValues()) {
            ArrayList<ElementDefinition> list = new ArrayList<ElementDefinition>();
            for (ElementDefinition ed : toRemove) {
                PropertyWrapper p = b.getChildByName(this.tail(ed.getPath()));
                if (p == null || !p.hasValues()) continue;
                list.add(ed);
            }
            toRemove.removeAll(list);
        }
        grandChildren.removeAll(toRemove);
    }

    private List<PropertyWrapper> splitExtensions(StructureDefinition profile, List<PropertyWrapper> children) throws UnsupportedEncodingException, IOException, FHIRException {
        ArrayList<PropertyWrapper> results = new ArrayList<PropertyWrapper>();
        HashMap map = new HashMap();
        for (PropertyWrapper p : children) {
            if (p.getName().equals("extension") || p.getName().equals("modifierExtension")) {
                if (!p.hasValues()) continue;
                for (BaseWrapper v : p.getValues()) {
                    Extension ex = (Extension)v.getBase();
                    String url = ex.getUrl();
                    StructureDefinition ed = this.context.fetchResource(StructureDefinition.class, url);
                    if (p.getName().equals("modifierExtension") && ed == null) {
                        throw new DefinitionException("Unknown modifier extension " + url);
                    }
                    PropertyWrapper pe = (PropertyWrapper)map.get(p.getName() + "[" + url + "]");
                    if (pe == null) {
                        if (ed == null) {
                            if (url.startsWith("http://hl7.org/fhir")) {
                                throw new DefinitionException("unknown extension " + url);
                            }
                            System.out.println("unknown extension " + url);
                            pe = new PropertyWrapperDirect(new Property(p.getName() + "[" + url + "]", p.getTypeCode(), p.getDefinition(), p.getMinCardinality(), p.getMaxCardinality(), ex));
                        } else {
                            ElementDefinition def = ed.getSnapshot().getElement().get(0);
                            pe = new PropertyWrapperDirect(new Property(p.getName() + "[" + url + "]", "Extension", def.getDefinition(), def.getMin(), def.getMax().equals("*") ? Integer.MAX_VALUE : Integer.parseInt(def.getMax()), ex));
                            ((PropertyWrapperDirect)pe).wrapped.setStructure(ed);
                        }
                        results.add(pe);
                        continue;
                    }
                    pe.getValues().add(v);
                }
                continue;
            }
            results.add(p);
        }
        return results;
    }

    private boolean isDefaultValue(Map<String, String> displayHints, List<BaseWrapper> list) throws UnsupportedEncodingException, IOException, FHIRException {
        if (list.size() != 1) {
            return false;
        }
        if (list.get(0).getBase() instanceof PrimitiveType) {
            return this.isDefault(displayHints, (PrimitiveType)list.get(0).getBase());
        }
        return false;
    }

    private boolean isDefault(Map<String, String> displayHints, PrimitiveType primitiveType) {
        String v = primitiveType.asStringValue();
        return !Utilities.noString((String)v) && displayHints.containsKey("default") && v.equals(displayHints.get("default"));
    }

    private boolean exemptFromRendering(ElementDefinition child) {
        if (child == null) {
            return false;
        }
        if ("Composition.subject".equals(child.getPath())) {
            return true;
        }
        return "Composition.section".equals(child.getPath());
    }

    private boolean renderAsList(ElementDefinition child) {
        String t;
        return child.getType().size() == 1 && ((t = child.getType().get(0).getCode()).equals("Address") || t.equals("Reference"));
    }

    private void addColumnHeadings(XhtmlNode tr, List<ElementDefinition> grandChildren) {
        for (ElementDefinition e : grandChildren) {
            tr.addTag("td").addTag("b").addText(Utilities.capitalize((String)this.tail(e.getPath())));
        }
    }

    private void addColumnValues(ResourceWrapper res, XhtmlNode tr, List<ElementDefinition> grandChildren, BaseWrapper v, boolean showCodeDetails, Map<String, String> displayHints) throws FHIRException, UnsupportedEncodingException, IOException {
        for (ElementDefinition e : grandChildren) {
            PropertyWrapper p = v.getChildByName(e.getPath().substring(e.getPath().lastIndexOf(".") + 1));
            if (p == null || p.getValues().size() == 0 || p.getValues().get(0) == null) {
                tr.addTag("td").addText(" ");
                continue;
            }
            this.renderLeaf(res, p.getValues().get(0), e, tr.addTag("td"), false, showCodeDetails, displayHints);
        }
    }

    private String tail(String path) {
        return path.substring(path.lastIndexOf(".") + 1);
    }

    private boolean canDoTable(String path, PropertyWrapper p, List<ElementDefinition> grandChildren) {
        for (ElementDefinition e : grandChildren) {
            List<PropertyWrapper> values = this.getValues(path, p, e);
            if (values.size() <= 1 && this.isPrimitive(e) && this.canCollapse(e)) continue;
            return false;
        }
        return true;
    }

    private List<PropertyWrapper> getValues(String path, PropertyWrapper p, ElementDefinition e) {
        ArrayList<PropertyWrapper> res = new ArrayList<PropertyWrapper>();
        for (BaseWrapper v : p.getValues()) {
            for (PropertyWrapper g : v.children()) {
                if (!(path + "." + p.getName() + "." + g.getName()).equals(e.getPath())) continue;
                res.add(p);
            }
        }
        return res;
    }

    private boolean canCollapse(ElementDefinition e) {
        return !e.getType().isEmpty();
    }

    private boolean isPrimitive(ElementDefinition e) {
        if (e.getType().isEmpty()) {
            return false;
        }
        return e.getType().size() != 1 || !this.isBase(e.getType().get(0).getCode());
    }

    private boolean isBase(String code) {
        return code.equals("Element") || code.equals("BackboneElement");
    }

    private ElementDefinition getElementDefinition(List<ElementDefinition> elements, String path, PropertyWrapper p) {
        for (ElementDefinition element : elements) {
            if (!element.getPath().equals(path)) continue;
            return element;
        }
        if (path.endsWith("\"]") && p.getStructure() != null) {
            return p.getStructure().getSnapshot().getElement().get(0);
        }
        return null;
    }

    private void renderLeaf(ResourceWrapper res, BaseWrapper ew, ElementDefinition defn, XhtmlNode x, boolean title, boolean showCodeDetails, Map<String, String> displayHints) throws FHIRException, UnsupportedEncodingException, IOException {
        if (ew == null) {
            return;
        }
        Base e = ew.getBase();
        if (e instanceof StringType) {
            x.addText((String)((StringType)e).getValue());
        } else if (e instanceof CodeType) {
            x.addText((String)((CodeType)e).getValue());
        } else if (e instanceof IdType) {
            x.addText(((IdType)e).getValue());
        } else if (e instanceof Extension) {
            x.addText("Extensions: Todo");
        } else if (e instanceof InstantType) {
            x.addText(((InstantType)e).toHumanDisplay());
        } else if (e instanceof DateTimeType) {
            x.addText(((DateTimeType)e).toHumanDisplay());
        } else if (e instanceof Base64BinaryType) {
            x.addText(new Base64().encodeAsString((byte[])((Base64BinaryType)e).getValue()));
        } else if (e instanceof DateType) {
            x.addText(((DateType)e).toHumanDisplay());
        } else if (e instanceof Enumeration) {
            Object ev = ((Enumeration)e).getValue();
            x.addText(ev == null ? "" : ev.toString());
        } else if (e instanceof BooleanType) {
            x.addText(((Boolean)((BooleanType)e).getValue()).toString());
        } else if (e instanceof CodeableConcept) {
            this.renderCodeableConcept((CodeableConcept)e, x, showCodeDetails);
        } else if (e instanceof Coding) {
            this.renderCoding((Coding)e, x, showCodeDetails);
        } else if (e instanceof Annotation) {
            this.renderAnnotation((Annotation)e, x);
        } else if (e instanceof Identifier) {
            this.renderIdentifier((Identifier)e, x);
        } else if (e instanceof IntegerType) {
            x.addText(Integer.toString((Integer)((IntegerType)e).getValue()));
        } else if (e instanceof DecimalType) {
            x.addText(((BigDecimal)((DecimalType)e).getValue()).toString());
        } else if (e instanceof HumanName) {
            this.renderHumanName((HumanName)e, x);
        } else if (e instanceof SampledData) {
            this.renderSampledData((SampledData)e, x);
        } else if (e instanceof Address) {
            this.renderAddress((Address)e, x);
        } else if (e instanceof ContactPoint) {
            this.renderContactPoint((ContactPoint)e, x);
        } else if (e instanceof UriType) {
            this.renderUri((UriType)e, x);
        } else if (e instanceof Timing) {
            this.renderTiming((Timing)e, x);
        } else if (e instanceof Range) {
            this.renderRange((Range)e, x);
        } else if (e instanceof Quantity) {
            this.renderQuantity((Quantity)e, x, showCodeDetails);
        } else if (e instanceof Ratio) {
            this.renderQuantity(((Ratio)e).getNumerator(), x, showCodeDetails);
            x.addText("/");
            this.renderQuantity(((Ratio)e).getDenominator(), x, showCodeDetails);
        } else if (e instanceof Period) {
            Period p = (Period)e;
            x.addText(!p.hasStart() ? "??" : p.getStartElement().toHumanDisplay());
            x.addText(" --> ");
            x.addText(!p.hasEnd() ? "(ongoing)" : p.getEndElement().toHumanDisplay());
        } else if (e instanceof Reference) {
            Reference r = (Reference)e;
            XhtmlNode c = x;
            ResourceWithReference tr = null;
            if (r.hasReferenceElement()) {
                tr = this.resolveReference(res, r.getReference());
                if (!r.getReference().startsWith("#")) {
                    c = tr != null && tr.getReference() != null ? x.addTag("a").attribute("href", tr.getReference()) : x.addTag("a").attribute("href", r.getReference());
                }
            }
            if (r.hasDisplayElement()) {
                c.addText(r.getDisplay());
                if (tr != null) {
                    c.addText(". Generated Summary: ");
                    this.generateResourceSummary(c, tr.getResource(), true, r.getReference().startsWith("#"));
                }
            } else if (tr != null) {
                this.generateResourceSummary(c, tr.getResource(), r.getReference().startsWith("#"), r.getReference().startsWith("#"));
            } else {
                c.addText(r.getReference());
            }
        } else {
            if (e instanceof Resource) {
                return;
            }
            if (e instanceof ElementDefinition) {
                x.addText("todo-bundle");
            } else if (!(e == null || e instanceof Attachment || e instanceof Narrative || e instanceof Meta)) {
                throw new NotImplementedException("type " + e.getClass().getName() + " not handled yet");
            }
        }
    }

    private boolean displayLeaf(ResourceWrapper res, BaseWrapper ew, ElementDefinition defn, XhtmlNode x, String name, boolean showCodeDetails) throws FHIRException, UnsupportedEncodingException, IOException {
        if (ew == null) {
            return false;
        }
        Base e = ew.getBase();
        Map<String, String> displayHints = this.readDisplayHints(defn);
        if (name.endsWith("[x]")) {
            name = name.substring(0, name.length() - 3);
        }
        if (!showCodeDetails && e instanceof PrimitiveType && this.isDefault(displayHints, (PrimitiveType)e)) {
            return false;
        }
        if (e instanceof StringType) {
            x.addText(name + ": " + (String)((StringType)e).getValue());
            return true;
        }
        if (e instanceof CodeType) {
            x.addText(name + ": " + (String)((CodeType)e).getValue());
            return true;
        }
        if (e instanceof IdType) {
            x.addText(name + ": " + ((IdType)e).getValue());
            return true;
        }
        if (e instanceof DateTimeType) {
            x.addText(name + ": " + ((DateTimeType)e).toHumanDisplay());
            return true;
        }
        if (e instanceof InstantType) {
            x.addText(name + ": " + ((InstantType)e).toHumanDisplay());
            return true;
        }
        if (e instanceof Extension) {
            x.addText("Extensions: todo");
            return true;
        }
        if (e instanceof DateType) {
            x.addText(name + ": " + ((DateType)e).toHumanDisplay());
            return true;
        }
        if (e instanceof Enumeration) {
            x.addText(((Enum)((Enumeration)e).getValue()).toString());
            return true;
        }
        if (e instanceof BooleanType) {
            if (((Boolean)((BooleanType)e).getValue()).booleanValue()) {
                x.addText(name);
                return true;
            }
        } else {
            if (e instanceof CodeableConcept) {
                this.renderCodeableConcept((CodeableConcept)e, x, showCodeDetails);
                return true;
            }
            if (e instanceof Coding) {
                this.renderCoding((Coding)e, x, showCodeDetails);
                return true;
            }
            if (e instanceof Annotation) {
                this.renderAnnotation((Annotation)e, x, showCodeDetails);
                return true;
            }
            if (e instanceof IntegerType) {
                x.addText(Integer.toString((Integer)((IntegerType)e).getValue()));
                return true;
            }
            if (e instanceof DecimalType) {
                x.addText(((BigDecimal)((DecimalType)e).getValue()).toString());
                return true;
            }
            if (e instanceof Identifier) {
                this.renderIdentifier((Identifier)e, x);
                return true;
            }
            if (e instanceof HumanName) {
                this.renderHumanName((HumanName)e, x);
                return true;
            }
            if (e instanceof SampledData) {
                this.renderSampledData((SampledData)e, x);
                return true;
            }
            if (e instanceof Address) {
                this.renderAddress((Address)e, x);
                return true;
            }
            if (e instanceof ContactPoint) {
                this.renderContactPoint((ContactPoint)e, x);
                return true;
            }
            if (e instanceof Timing) {
                this.renderTiming((Timing)e, x);
                return true;
            }
            if (e instanceof Quantity) {
                this.renderQuantity((Quantity)e, x, showCodeDetails);
                return true;
            }
            if (e instanceof Ratio) {
                this.renderQuantity(((Ratio)e).getNumerator(), x, showCodeDetails);
                x.addText("/");
                this.renderQuantity(((Ratio)e).getDenominator(), x, showCodeDetails);
                return true;
            }
            if (e instanceof Period) {
                Period p = (Period)e;
                x.addText(name + ": ");
                x.addText(!p.hasStart() ? "??" : p.getStartElement().toHumanDisplay());
                x.addText(" --> ");
                x.addText(!p.hasEnd() ? "(ongoing)" : p.getEndElement().toHumanDisplay());
                return true;
            }
            if (e instanceof Reference) {
                Reference r = (Reference)e;
                if (r.hasDisplayElement()) {
                    x.addText(r.getDisplay());
                } else if (r.hasReferenceElement()) {
                    ResourceWithReference tr = this.resolveReference(res, r.getReference());
                    x.addText(tr == null ? r.getReference() : "????");
                } else {
                    x.addText("??");
                }
                return true;
            }
            if (e instanceof Narrative) {
                return false;
            }
            if (e instanceof Resource) {
                return false;
            }
            if (!(e instanceof Attachment)) {
                throw new NotImplementedException("type " + e.getClass().getName() + " not handled yet");
            }
        }
        return false;
    }

    private Map<String, String> readDisplayHints(ElementDefinition defn) throws DefinitionException {
        String displayHint;
        HashMap<String, String> hints = new HashMap<String, String>();
        if (defn != null && !Utilities.noString((String)(displayHint = ToolingExtensions.getDisplayHint(defn)))) {
            String[] list;
            for (String item : list = displayHint.split(";")) {
                String[] parts = item.split(":");
                if (parts.length != 2) {
                    throw new DefinitionException("error reading display hint: '" + displayHint + "'");
                }
                hints.put(parts[0].trim(), parts[1].trim());
            }
        }
        return hints;
    }

    public static String displayPeriod(Period p) {
        String s = !p.hasStart() ? "??" : p.getStartElement().toHumanDisplay();
        s = s + " --> ";
        return s + (!p.hasEnd() ? "(ongoing)" : p.getEndElement().toHumanDisplay());
    }

    private void generateResourceSummary(XhtmlNode x, ResourceWrapper res, boolean textAlready, boolean showCodeDetails) throws FHIRException, UnsupportedEncodingException, IOException {
        String path;
        StructureDefinition profile;
        if (!textAlready) {
            XhtmlNode div = res.getNarrative();
            if (div != null) {
                if (div.allChildrenAreText()) {
                    x.getChildNodes().addAll(div.getChildNodes());
                }
                if (div.getChildNodes().size() == 1 && ((XhtmlNode)div.getChildNodes().get(0)).allChildrenAreText()) {
                    x.getChildNodes().addAll(((XhtmlNode)div.getChildNodes().get(0)).getChildNodes());
                }
            }
            x.addText("Generated Summary: ");
        }
        if ((profile = this.context.fetchResource(StructureDefinition.class, path = res.getName())) == null) {
            x.addText("unknown resource " + path);
        } else {
            boolean firstElement = true;
            boolean last = false;
            for (PropertyWrapper p : res.children()) {
                ElementDefinition child = this.getElementDefinition(profile.getSnapshot().getElement(), path + "." + p.getName(), p);
                if (p.getValues().size() <= 0 || p.getValues().get(0) == null || child == null || !this.isPrimitive(child) || !this.includeInSummary(child)) continue;
                if (firstElement) {
                    firstElement = false;
                } else if (last) {
                    x.addText("; ");
                }
                boolean first = true;
                last = false;
                for (BaseWrapper v : p.getValues()) {
                    if (first) {
                        first = false;
                    } else if (last) {
                        x.addText(", ");
                    }
                    last = this.displayLeaf(res, v, child, x, p.getName(), showCodeDetails) || last;
                }
            }
        }
    }

    private boolean includeInSummary(ElementDefinition child) {
        String t;
        if (child.getIsModifier()) {
            return true;
        }
        if (child.getMustSupport()) {
            return true;
        }
        return child.getType().size() != 1 || !(t = child.getType().get(0).getCode()).equals("Address") && !t.equals("Contact") && !t.equals("Reference") && !t.equals("Uri");
    }

    private ResourceWithReference resolveReference(ResourceWrapper res, String url) {
        if (url == null) {
            return null;
        }
        if (url.startsWith("#")) {
            for (ResourceWrapper r : res.getContained()) {
                if (!r.getId().equals(url.substring(1))) continue;
                return new ResourceWithReference(null, r);
            }
            return null;
        }
        Object ae = this.context.fetchResource(null, url);
        if (ae == null) {
            return null;
        }
        return new ResourceWithReference(url, new ResourceWrapperDirect((Resource)ae));
    }

    private void renderCodeableConcept(CodeableConcept cc, XhtmlNode x, boolean showCodeDetails) {
        String s = cc.getText();
        if (Utilities.noString((String)s)) {
            for (Coding c : cc.getCoding()) {
                if (!c.hasDisplayElement()) continue;
                s = c.getDisplay();
                break;
            }
        }
        if (Utilities.noString((String)s)) {
            for (Coding c : cc.getCoding()) {
                if (c.hasCodeElement() && c.hasSystemElement() && !Utilities.noString((String)(s = this.lookupCode(c.getSystem(), c.getCode())))) break;
            }
        }
        if (Utilities.noString((String)s)) {
            s = cc.getCoding().isEmpty() ? "" : cc.getCoding().get(0).getCode();
        }
        if (showCodeDetails) {
            x.addText(s + " ");
            XhtmlNode sp = x.addTag("span");
            sp.setAttribute("style", "background: LightGoldenRodYellow ");
            sp.addText("(Details ");
            boolean first = true;
            for (Coding c : cc.getCoding()) {
                if (first) {
                    sp.addText(": ");
                    first = false;
                } else {
                    sp.addText("; ");
                }
                sp.addText("{" + this.describeSystem(c.getSystem()) + " code '" + c.getCode() + "' = '" + this.lookupCode(c.getSystem(), c.getCode()) + (c.hasDisplay() ? "', given as '" + c.getDisplay() + "'}" : ""));
            }
            sp.addText(")");
        } else {
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (Coding c : cc.getCoding()) {
                if (!c.hasCodeElement() || !c.hasSystemElement()) continue;
                b.append("{" + c.getSystem() + " " + c.getCode() + "}");
            }
            x.addTag("span").setAttribute("title", "Codes: " + b.toString()).addText(s);
        }
    }

    private void renderAnnotation(Annotation a, XhtmlNode x, boolean showCodeDetails) throws FHIRException {
        StringBuilder s = new StringBuilder();
        if (a.hasAuthor()) {
            s.append("Author: ");
            if (a.hasAuthorReference()) {
                s.append(a.getAuthorReference().getReference());
            } else if (a.hasAuthorStringType()) {
                s.append((String)a.getAuthorStringType().getValue());
            }
        }
        if (a.hasTimeElement()) {
            if (s.length() > 0) {
                s.append("; ");
            }
            s.append("Made: ").append(a.getTimeElement().toHumanDisplay());
        }
        if (a.hasText()) {
            if (s.length() > 0) {
                s.append("; ");
            }
            s.append("Annotation: ").append(a.getText());
        }
        x.addText(s.toString());
    }

    private void renderCoding(Coding c, XhtmlNode x, boolean showCodeDetails) {
        String s = "";
        if (c.hasDisplayElement()) {
            s = c.getDisplay();
        }
        if (Utilities.noString((String)s)) {
            s = this.lookupCode(c.getSystem(), c.getCode());
        }
        if (Utilities.noString((String)s)) {
            s = c.getCode();
        }
        if (showCodeDetails) {
            x.addText(s + " (Details: " + this.describeSystem(c.getSystem()) + " code " + c.getCode() + " = '" + this.lookupCode(c.getSystem(), c.getCode()) + "', stated as '" + c.getDisplay() + "')");
        } else {
            x.addTag("span").setAttribute("title", "{" + c.getSystem() + " " + c.getCode() + "}").addText(s);
        }
    }

    private String describeSystem(String system) {
        if (system == null) {
            return "[not stated]";
        }
        if (system.equals("http://loinc.org")) {
            return "LOINC";
        }
        if (system.startsWith("http://snomed.info")) {
            return "SNOMED CT";
        }
        if (system.equals("http://www.nlm.nih.gov/research/umls/rxnorm")) {
            return "RxNorm";
        }
        if (system.equals("http://hl7.org/fhir/sid/icd-9")) {
            return "ICD-9";
        }
        return system;
    }

    private String lookupCode(String system, String code) {
        IWorkerContext.ValidationResult t = this.context.validateCode(system, code, null);
        if (t != null && t.getDisplay() != null) {
            return t.getDisplay();
        }
        return code;
    }

    private CodeSystem.ConceptDefinitionComponent findCode(String code, List<CodeSystem.ConceptDefinitionComponent> list) {
        for (CodeSystem.ConceptDefinitionComponent t : list) {
            if (code.equals(t.getCode())) {
                return t;
            }
            CodeSystem.ConceptDefinitionComponent c = this.findCode(code, t.getConcept());
            if (c == null) continue;
            return c;
        }
        return null;
    }

    private String displayCodeableConcept(CodeableConcept cc) {
        String s = cc.getText();
        if (Utilities.noString((String)s)) {
            for (Coding c : cc.getCoding()) {
                if (!c.hasDisplayElement()) continue;
                s = c.getDisplay();
                break;
            }
        }
        if (Utilities.noString((String)s)) {
            for (Coding c : cc.getCoding()) {
                if (c.hasCode() && c.hasSystem() && !Utilities.noString((String)(s = this.lookupCode(c.getSystem(), c.getCode())))) break;
            }
        }
        if (Utilities.noString((String)s)) {
            s = cc.getCoding().isEmpty() ? "" : cc.getCoding().get(0).getCode();
        }
        return s;
    }

    private void renderIdentifier(Identifier ii, XhtmlNode x) {
        x.addText(this.displayIdentifier(ii));
    }

    private void renderTiming(Timing s, XhtmlNode x) throws FHIRException {
        x.addText(this.displayTiming(s));
    }

    private void renderQuantity(Quantity q, XhtmlNode x, boolean showCodeDetails) {
        if (q.hasComparator()) {
            x.addText(q.getComparator().toCode());
        }
        x.addText(q.getValue().toString());
        if (q.hasUnit()) {
            x.addText(" " + q.getUnit());
        } else if (q.hasCode()) {
            x.addText(" " + q.getCode());
        }
        if (showCodeDetails && q.hasCode()) {
            XhtmlNode sp = x.addTag("span");
            sp.setAttribute("style", "background: LightGoldenRodYellow ");
            sp.addText(" (Details: " + this.describeSystem(q.getSystem()) + " code " + q.getCode() + " = '" + this.lookupCode(q.getSystem(), q.getCode()) + "')");
        }
    }

    private void renderRange(Range q, XhtmlNode x) {
        if (q.hasLow()) {
            x.addText(q.getLow().getValue().toString());
        } else {
            x.addText("?");
        }
        x.addText("-");
        if (q.hasHigh()) {
            x.addText(q.getHigh().getValue().toString());
        } else {
            x.addText("?");
        }
        if (q.getLow().hasUnit()) {
            x.addText(" " + q.getLow().getUnit());
        }
    }

    private void renderHumanName(HumanName name, XhtmlNode x) {
        x.addText(NarrativeGenerator.displayHumanName(name));
    }

    private void renderAnnotation(Annotation annot, XhtmlNode x) {
        x.addText(annot.getText());
    }

    private void renderAddress(Address address, XhtmlNode x) {
        x.addText(this.displayAddress(address));
    }

    private void renderContactPoint(ContactPoint contact, XhtmlNode x) {
        x.addText(NarrativeGenerator.displayContactPoint(contact));
    }

    private void renderUri(UriType uri, XhtmlNode x) {
        x.addTag("a").setAttribute("href", (String)uri.getValue()).addText((String)uri.getValue());
    }

    private void renderSampledData(SampledData sampledData, XhtmlNode x) {
        x.addText(this.displaySampledData(sampledData));
    }

    private String displaySampledData(SampledData s) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (s.hasOrigin()) {
            b.append("Origin: " + this.displayQuantity(s.getOrigin()));
        }
        if (s.hasPeriod()) {
            b.append("Period: " + s.getPeriod().toString());
        }
        if (s.hasFactor()) {
            b.append("Factor: " + s.getFactor().toString());
        }
        if (s.hasLowerLimit()) {
            b.append("Lower: " + s.getLowerLimit().toString());
        }
        if (s.hasUpperLimit()) {
            b.append("Upper: " + s.getUpperLimit().toString());
        }
        if (s.hasDimensions()) {
            b.append("Dimensions: " + s.getDimensions());
        }
        if (s.hasData()) {
            b.append("Data: " + s.getData());
        }
        return b.toString();
    }

    private String displayQuantity(Quantity q) {
        StringBuilder s = new StringBuilder();
        s.append("(system = '").append(this.describeSystem(q.getSystem())).append("' code ").append(q.getCode()).append(" = '").append(this.lookupCode(q.getSystem(), q.getCode())).append("')");
        return s.toString();
    }

    private String displayTiming(Timing s) throws FHIRException {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (s.hasCode()) {
            b.append("Code: " + this.displayCodeableConcept(s.getCode()));
        }
        if (s.getEvent().size() > 0) {
            CommaSeparatedStringBuilder c = new CommaSeparatedStringBuilder();
            for (DateTimeType p : s.getEvent()) {
                c.append(p.toHumanDisplay());
            }
            b.append("Events: " + c.toString());
        }
        if (s.hasRepeat()) {
            String st;
            Timing.TimingRepeatComponent rep = s.getRepeat();
            if (rep.hasBoundsPeriod() && rep.getBoundsPeriod().hasStart()) {
                b.append("Starting " + rep.getBoundsPeriod().getStartElement().toHumanDisplay());
            }
            if (rep.hasCount()) {
                b.append("Count " + Integer.toString(rep.getCount()) + " times");
            }
            if (rep.hasDuration()) {
                b.append("Duration " + rep.getDuration().toPlainString() + this.displayTimeUnits(rep.getPeriodUnit()));
            }
            if (rep.hasWhen()) {
                st = "";
                if (rep.hasPeriod()) {
                    st = rep.getPeriod().toPlainString();
                    if (rep.hasPeriodMax()) {
                        st = st + "-" + rep.getPeriodMax().toPlainString();
                    }
                    st = st + this.displayTimeUnits(rep.getPeriodUnit());
                }
                b.append("Do " + st + this.displayEventCode(rep.getWhen()));
            } else {
                st = "";
                if (!rep.hasFrequency() || !rep.hasFrequencyMax() && rep.getFrequency() == 1) {
                    st = "Once";
                } else {
                    st = Integer.toString(rep.getFrequency());
                    if (rep.hasFrequencyMax()) {
                        st = st + "-" + Integer.toString(rep.getFrequency());
                    }
                }
                if (rep.hasPeriod()) {
                    st = st + " per " + rep.getPeriod().toPlainString();
                    if (rep.hasPeriodMax()) {
                        st = st + "-" + rep.getPeriodMax().toPlainString();
                    }
                    st = st + " " + this.displayTimeUnits(rep.getPeriodUnit());
                }
                b.append("Do " + st);
            }
            if (rep.hasBoundsPeriod() && rep.getBoundsPeriod().hasEnd()) {
                b.append("Until " + rep.getBoundsPeriod().getEndElement().toHumanDisplay());
            }
        }
        return b.toString();
    }

    private Object displayEventCode(Timing.EventTiming when) {
        switch (when) {
            case C: {
                return "at meals";
            }
            case CD: {
                return "at lunch";
            }
            case CM: {
                return "at breakfast";
            }
            case CV: {
                return "at dinner";
            }
            case AC: {
                return "before meals";
            }
            case ACD: {
                return "before lunch";
            }
            case ACM: {
                return "before breakfast";
            }
            case ACV: {
                return "before dinner";
            }
            case HS: {
                return "before sleeping";
            }
            case PC: {
                return "after meals";
            }
            case PCD: {
                return "after lunch";
            }
            case PCM: {
                return "after breakfast";
            }
            case PCV: {
                return "after dinner";
            }
            case WAKE: {
                return "after waking";
            }
        }
        return "??";
    }

    private String displayTimeUnits(Timing.UnitsOfTime units) {
        if (units == null) {
            return "??";
        }
        switch (units) {
            case A: {
                return "years";
            }
            case D: {
                return "days";
            }
            case H: {
                return "hours";
            }
            case MIN: {
                return "minutes";
            }
            case MO: {
                return "months";
            }
            case S: {
                return "seconds";
            }
            case WK: {
                return "weeks";
            }
        }
        return "??";
    }

    public static String displayHumanName(HumanName name) {
        StringBuilder s = new StringBuilder();
        if (name.hasText()) {
            s.append(name.getText());
        } else {
            for (StringType p : name.getGiven()) {
                s.append((String)p.getValue());
                s.append(" ");
            }
            for (StringType p : name.getFamily()) {
                s.append((String)p.getValue());
                s.append(" ");
            }
        }
        if (name.hasUse() && name.getUse() != HumanName.NameUse.USUAL) {
            s.append("(" + name.getUse().toString() + ")");
        }
        return s.toString();
    }

    private String displayAddress(Address address) {
        StringBuilder s = new StringBuilder();
        if (address.hasText()) {
            s.append(address.getText());
        } else {
            for (StringType p : address.getLine()) {
                s.append((String)p.getValue());
                s.append(" ");
            }
            if (address.hasCity()) {
                s.append(address.getCity());
                s.append(" ");
            }
            if (address.hasState()) {
                s.append(address.getState());
                s.append(" ");
            }
            if (address.hasPostalCode()) {
                s.append(address.getPostalCode());
                s.append(" ");
            }
            if (address.hasCountry()) {
                s.append(address.getCountry());
                s.append(" ");
            }
        }
        if (address.hasUse()) {
            s.append("(" + address.getUse().toString() + ")");
        }
        return s.toString();
    }

    public static String displayContactPoint(ContactPoint contact) {
        StringBuilder s = new StringBuilder();
        s.append(NarrativeGenerator.describeSystem(contact.getSystem()));
        if (Utilities.noString((String)contact.getValue())) {
            s.append("-unknown-");
        } else {
            s.append(contact.getValue());
        }
        if (contact.hasUse()) {
            s.append("(" + contact.getUse().toString() + ")");
        }
        return s.toString();
    }

    private static String describeSystem(ContactPoint.ContactPointSystem system) {
        if (system == null) {
            return "";
        }
        switch (system) {
            case PHONE: {
                return "ph: ";
            }
            case FAX: {
                return "fax: ";
            }
        }
        return "";
    }

    private String displayIdentifier(Identifier ii) {
        String s;
        String string = s = Utilities.noString((String)ii.getValue()) ? "??" : ii.getValue();
        if (ii.hasType()) {
            if (ii.getType().hasText()) {
                s = ii.getType().getText() + " = " + s;
            } else if (ii.getType().hasCoding() && ii.getType().getCoding().get(0).hasDisplay()) {
                s = ii.getType().getCoding().get(0).getDisplay() + " = " + s;
            } else if (ii.getType().hasCoding() && ii.getType().getCoding().get(0).hasCode()) {
                s = this.lookupCode(ii.getType().getCoding().get(0).getSystem(), ii.getType().getCoding().get(0).getCode()) + " = " + s;
            }
        }
        if (ii.hasUse()) {
            s = s + " (" + ii.getUse().toString() + ")";
        }
        return s;
    }

    private List<ElementDefinition> getChildrenForPath(List<ElementDefinition> elements, String path) throws DefinitionException {
        for (ElementDefinition e : elements) {
            if (!e.getPath().equals(path) || !e.hasContentReference()) continue;
            String ref = e.getContentReference();
            ElementDefinition t = null;
            for (ElementDefinition e1 : elements) {
                if (!ref.equals("#" + e1.getId())) continue;
                t = e1;
            }
            if (t == null) {
                throw new DefinitionException("Unable to resolve content reference " + ref + " trying to resolve " + path);
            }
            path = t.getPath();
            break;
        }
        ArrayList<ElementDefinition> results = new ArrayList<ElementDefinition>();
        for (ElementDefinition e : elements) {
            if (!e.getPath().startsWith(path + ".") || e.getPath().substring(path.length() + 1).contains(".")) continue;
            results.add(e);
        }
        return results;
    }

    public void generate(ConceptMap cm) {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.addTag("h2").addText(cm.getName() + " (" + cm.getUrl() + ")");
        XhtmlNode p = x.addTag("p");
        p.addText("Mapping from ");
        this.AddVsRef(((Reference)cm.getSource()).getReference(), p);
        p.addText(" to ");
        this.AddVsRef(((Reference)cm.getTarget()).getReference(), p);
        p = x.addTag("p");
        if (cm.getExperimental()) {
            p.addText(Utilities.capitalize((String)cm.getStatus().toString()) + " (not intended for production usage). ");
        } else {
            p.addText(Utilities.capitalize((String)cm.getStatus().toString()) + ". ");
        }
        p.addText("Published on " + cm.getDateElement().toHumanDisplay() + " by " + cm.getPublisher());
        if (!cm.getContact().isEmpty()) {
            p.addText(" (");
            boolean firsti = true;
            for (ConceptMap.ConceptMapContactComponent ci : cm.getContact()) {
                if (firsti) {
                    firsti = false;
                } else {
                    p.addText(", ");
                }
                if (ci.hasName()) {
                    p.addText(ci.getName() + ": ");
                }
                boolean first = true;
                for (ContactPoint c : ci.getTelecom()) {
                    if (first) {
                        first = false;
                    } else {
                        p.addText(", ");
                    }
                    this.addTelecom(p, c);
                }
                p.addText("; ");
            }
            p.addText(")");
        }
        p.addText(". ");
        p.addText(cm.getCopyright());
        if (!Utilities.noString((String)cm.getDescription())) {
            x.addTag("p").addText(cm.getDescription());
        }
        x.addTag("br");
        if (!cm.getElement().isEmpty()) {
            ConceptMap.TargetElementComponent ccm;
            String display;
            XhtmlNode tr;
            XhtmlNode tbl;
            ConceptMap.SourceElementComponent cc = cm.getElement().get(0);
            String src = cc.getSystem();
            boolean comments = false;
            boolean ok = cc.getTarget().size() == 1;
            HashMap sources = new HashMap();
            sources.put("code", new HashSet());
            HashMap targets = new HashMap();
            targets.put("code", new HashSet());
            if (ok) {
                String dst = cc.getTarget().get(0).getSystem();
                for (ConceptMap.SourceElementComponent ccl : cm.getElement()) {
                    boolean bl = ok = ok && src.equals(ccl.getSystem()) && ccl.getTarget().size() == 1 && dst.equals(ccl.getTarget().get(0).getSystem()) && ccl.getTarget().get(0).getDependsOn().isEmpty() && ccl.getTarget().get(0).getProduct().isEmpty();
                    if (ccl.hasSystem()) {
                        ((HashSet)sources.get("code")).add(ccl.getSystem());
                    }
                    for (ConceptMap.TargetElementComponent ccm2 : ccl.getTarget()) {
                        comments = comments || !Utilities.noString((String)ccm2.getComments());
                        for (ConceptMap.OtherElementComponent d : ccm2.getDependsOn()) {
                            if (!sources.containsKey(d.getElement())) {
                                sources.put(d.getElement(), new HashSet());
                            }
                            ((HashSet)sources.get(d.getElement())).add(d.getSystem());
                        }
                        if (ccm2.hasSystem()) {
                            ((HashSet)targets.get("code")).add(ccm2.getSystem());
                        }
                        for (ConceptMap.OtherElementComponent d : ccm2.getProduct()) {
                            if (!targets.containsKey(d.getElement())) {
                                targets.put(d.getElement(), new HashSet());
                            }
                            ((HashSet)targets.get(d.getElement())).add(d.getSystem());
                        }
                    }
                }
            }
            if (ok) {
                tbl = x.addTag("table").setAttribute("class", "grid");
                tr = tbl.addTag("tr");
                tr.addTag("td").addTag("b").addText("Source Code");
                tr.addTag("td").addTag("b").addText("Equivalence");
                tr.addTag("td").addTag("b").addText("Destination Code");
                if (comments) {
                    tr.addTag("td").addTag("b").addText("Comments");
                }
                for (ConceptMap.SourceElementComponent ccl : cm.getElement()) {
                    tr = tbl.addTag("tr");
                    XhtmlNode td = tr.addTag("td");
                    td.addText(ccl.getCode());
                    display = this.getDisplayForConcept(ccl.getSystem(), ccl.getCode());
                    if (display != null) {
                        td.addText(" (" + display + ")");
                    }
                    ccm = ccl.getTarget().get(0);
                    tr.addTag("td").addText(!ccm.hasEquivalence() ? "" : ccm.getEquivalence().toCode());
                    td = tr.addTag("td");
                    td.addText(ccm.getCode());
                    display = this.getDisplayForConcept(ccm.getSystem(), ccm.getCode());
                    if (display != null) {
                        td.addText(" (" + display + ")");
                    }
                    if (!comments) continue;
                    tr.addTag("td").addText(ccm.getComments());
                }
            } else {
                tbl = x.addTag("table").setAttribute("class", "grid");
                tr = tbl.addTag("tr");
                tr.addTag("td").setAttribute("colspan", Integer.toString(sources.size())).addTag("b").addText("Source Concept");
                tr.addTag("td").addTag("b").addText("Equivalence");
                tr.addTag("td").setAttribute("colspan", Integer.toString(targets.size())).addTag("b").addText("Destination Concept");
                if (comments) {
                    tr.addTag("td").addTag("b").addText("Comments");
                }
                tr = tbl.addTag("tr");
                if (((HashSet)sources.get("code")).size() == 1) {
                    tr.addTag("td").addTag("b").addText("Code " + ((HashSet)sources.get("code")).toString() + "");
                } else {
                    tr.addTag("td").addTag("b").addText("Code");
                }
                for (String s : sources.keySet()) {
                    if (s.equals("code")) continue;
                    if (((HashSet)sources.get(s)).size() == 1) {
                        tr.addTag("td").addTag("b").addText(this.getDescForConcept(s) + " " + ((HashSet)sources.get(s)).toString());
                        continue;
                    }
                    tr.addTag("td").addTag("b").addText(this.getDescForConcept(s));
                }
                tr.addTag("td");
                if (((HashSet)targets.get("code")).size() == 1) {
                    tr.addTag("td").addTag("b").addText("Code " + ((HashSet)targets.get("code")).toString());
                } else {
                    tr.addTag("td").addTag("b").addText("Code");
                }
                for (String s : targets.keySet()) {
                    if (s.equals("code")) continue;
                    if (((HashSet)targets.get(s)).size() == 1) {
                        tr.addTag("td").addTag("b").addText(this.getDescForConcept(s) + " " + ((HashSet)targets.get(s)).toString() + "");
                        continue;
                    }
                    tr.addTag("td").addTag("b").addText(this.getDescForConcept(s));
                }
                if (comments) {
                    tr.addTag("td");
                }
                for (ConceptMap.SourceElementComponent ccl : cm.getElement()) {
                    tr = tbl.addTag("tr");
                    XhtmlNode td = tr.addTag("td");
                    if (((HashSet)sources.get("code")).size() == 1) {
                        td.addText(ccl.getCode());
                    } else {
                        td.addText(ccl.getSystem() + " / " + ccl.getCode());
                    }
                    display = this.getDisplayForConcept(ccl.getSystem(), ccl.getCode());
                    if (display != null) {
                        td.addText(" (" + display + ")");
                    }
                    ccm = ccl.getTarget().get(0);
                    for (String s : sources.keySet()) {
                        if (s.equals("code")) continue;
                        td = tr.addTag("td");
                        td.addText(this.getCode(ccm.getDependsOn(), s, ((HashSet)sources.get(s)).size() != 1));
                        display = this.getDisplay(ccm.getDependsOn(), s);
                        if (display == null) continue;
                        td.addText(" (" + display + ")");
                    }
                    tr.addTag("td").addText(ccm.getEquivalence().toString());
                    td = tr.addTag("td");
                    if (((HashSet)targets.get("code")).size() == 1) {
                        td.addText(ccm.getCode());
                    } else {
                        td.addText(ccm.getSystem() + " / " + ccm.getCode());
                    }
                    display = this.getDisplayForConcept(ccm.getSystem(), ccm.getCode());
                    if (display != null) {
                        td.addText(" (" + display + ")");
                    }
                    for (String s : targets.keySet()) {
                        if (s.equals("code")) continue;
                        td = tr.addTag("td");
                        td.addText(this.getCode(ccm.getProduct(), s, ((HashSet)targets.get(s)).size() != 1));
                        display = this.getDisplay(ccm.getProduct(), s);
                        if (display == null) continue;
                        td.addText(" (" + display + ")");
                    }
                    if (!comments) continue;
                    tr.addTag("td").addText(ccm.getComments());
                }
            }
        }
        this.inject(cm, x, Narrative.NarrativeStatus.GENERATED);
    }

    private void inject(DomainResource r, XhtmlNode x, Narrative.NarrativeStatus status) {
        if (!r.hasText() || !r.getText().hasDiv() || r.getText().getDiv().getChildNodes().isEmpty()) {
            r.setText(new Narrative());
            r.getText().setDiv(x);
            r.getText().setStatus(status);
        } else {
            XhtmlNode n = r.getText().getDiv();
            n.addTag("hr");
            n.getChildNodes().addAll(x.getChildNodes());
        }
    }

    public Element getNarrative(Element er) {
        Element txt = XMLUtil.getNamedChild((Element)er, (String)"text");
        if (txt == null) {
            return null;
        }
        return XMLUtil.getNamedChild((Element)txt, (String)"div");
    }

    private void inject(Element er, XhtmlNode x, Narrative.NarrativeStatus status) {
        Element st;
        Element txt = XMLUtil.getNamedChild((Element)er, (String)"text");
        if (txt == null) {
            txt = er.getOwnerDocument().createElementNS("http://hl7.org/fhir", "text");
            Element n = XMLUtil.getFirstChild((Element)er);
            while (n != null && (n.getNodeName().equals("id") || n.getNodeName().equals("meta") || n.getNodeName().equals("implicitRules") || n.getNodeName().equals("language"))) {
                n = XMLUtil.getNextSibling((Element)n);
            }
            if (n == null) {
                er.appendChild(txt);
            } else {
                er.insertBefore(txt, n);
            }
        }
        if ((st = XMLUtil.getNamedChild((Element)txt, (String)"status")) == null) {
            st = er.getOwnerDocument().createElementNS("http://hl7.org/fhir", "status");
            Element n = XMLUtil.getFirstChild((Element)txt);
            if (n == null) {
                txt.appendChild(st);
            } else {
                txt.insertBefore(st, n);
            }
        }
        st.setAttribute("value", status.toCode());
        Element div = XMLUtil.getNamedChild((Element)txt, (String)"div");
        if (div == null) {
            div = er.getOwnerDocument().createElementNS("http://www.w3.org/1999/xhtml", "div");
            div.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
            txt.appendChild(div);
        }
        if (div.hasChildNodes()) {
            div.appendChild(er.getOwnerDocument().createElementNS("http://www.w3.org/1999/xhtml", "hr"));
        }
        new XhtmlComposer(true, false).compose(div, x);
    }

    private String getDisplay(List<ConceptMap.OtherElementComponent> list, String s) {
        for (ConceptMap.OtherElementComponent c : list) {
            if (!s.equals(c.getElement())) continue;
            return this.getDisplayForConcept(c.getSystem(), c.getCode());
        }
        return null;
    }

    private String getDisplayForConcept(String system, String code) {
        if (code == null) {
            return null;
        }
        IWorkerContext.ValidationResult cl = this.context.validateCode(system, code, null);
        return cl == null ? null : cl.getDisplay();
    }

    private String getDescForConcept(String s) {
        if (s.startsWith("http://hl7.org/fhir/v2/element/")) {
            return "v2 " + s.substring("http://hl7.org/fhir/v2/element/".length());
        }
        return s;
    }

    private String getCode(List<ConceptMap.OtherElementComponent> list, String s, boolean withSystem) {
        for (ConceptMap.OtherElementComponent c : list) {
            if (!s.equals(c.getElement())) continue;
            if (withSystem) {
                return c.getSystem() + " / " + c.getCode();
            }
            return c.getCode();
        }
        return null;
    }

    private void addTelecom(XhtmlNode p, ContactPoint c) {
        if (c.getSystem() == ContactPoint.ContactPointSystem.PHONE) {
            p.addText("Phone: " + c.getValue());
        } else if (c.getSystem() == ContactPoint.ContactPointSystem.FAX) {
            p.addText("Fax: " + c.getValue());
        } else if (c.getSystem() == ContactPoint.ContactPointSystem.EMAIL) {
            p.addTag("a").setAttribute("href", "mailto:" + c.getValue()).addText(c.getValue());
        } else if (c.getSystem() == ContactPoint.ContactPointSystem.OTHER) {
            if (c.getValue().length() > 30) {
                p.addTag("a").setAttribute("href", c.getValue()).addText(c.getValue().substring(0, 30) + "...");
            } else {
                p.addTag("a").setAttribute("href", c.getValue()).addText(c.getValue());
            }
        }
    }

    public void generate(CodeSystem cs, boolean header) {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        boolean hasExtensions = false;
        hasExtensions = this.generateDefinition(x, cs, header);
        this.inject(cs, x, hasExtensions ? Narrative.NarrativeStatus.EXTENSIONS : Narrative.NarrativeStatus.GENERATED);
    }

    private boolean generateDefinition(XhtmlNode x, CodeSystem cs, boolean header) {
        boolean hasExtensions = false;
        HashMap<ConceptMap, String> mymaps = new HashMap<ConceptMap, String>();
        for (ConceptMap a : this.context.findMapsForSource(cs.getValueSet())) {
            String url = "";
            ValueSet vsr = this.context.fetchResource(ValueSet.class, ((Reference)a.getTarget()).getReference());
            if (vsr != null) {
                url = (String)vsr.getUserData("filename");
            }
            mymaps.put(a, url);
        }
        for (Resource r : cs.getContained()) {
            ConceptMap cm;
            if (!(r instanceof ConceptMap) || !((Reference)(cm = (ConceptMap)r).getSource()).getReference().equals(cs.getValueSet())) continue;
            String url = "";
            ValueSet vsr = this.context.fetchResource(ValueSet.class, ((Reference)cm.getTarget()).getReference());
            if (vsr != null) {
                url = (String)vsr.getUserData("filename");
            }
            mymaps.put(cm, url);
        }
        ArrayList<String> langs = new ArrayList<String>();
        if (header) {
            XhtmlNode h = x.addTag("h2");
            h.addText(cs.getName());
            XhtmlNode p = x.addTag("p");
            this.smartAddText(p, cs.getDescription());
            if (cs.hasCopyright()) {
                this.generateCopyright(x, cs);
            }
        }
        XhtmlNode p = x.addTag("p");
        p.addText("This code system " + cs.getUrl() + " defines the following codes:");
        XhtmlNode t = x.addTag("table").setAttribute("class", "codes");
        boolean commentS = false;
        boolean deprecated = false;
        boolean display = false;
        boolean hierarchy = false;
        for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
            commentS = commentS || this.conceptsHaveComments(c);
            deprecated = deprecated || this.conceptsHaveDeprecated(cs, c);
            display = display || this.conceptsHaveDisplay(c);
            hierarchy = hierarchy || c.hasConcept();
            this.scanLangs(c, langs);
        }
        this.addMapHeaders(this.addTableHeaderRowStandard(t, hierarchy, display, true, commentS, deprecated), mymaps);
        for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
            hasExtensions = this.addDefineRowToTable(t, c, 0, hierarchy, display, commentS, deprecated, mymaps, cs.getUrl(), cs) || hasExtensions;
        }
        if (langs.size() > 0) {
            Collections.sort(langs);
            x.addTag("p").addTag("b").addText("Additional Language Displays");
            t = x.addTag("table").setAttribute("class", "codes");
            XhtmlNode tr = t.addTag("tr");
            tr.addTag("td").addTag("b").addText("Code");
            for (String lang : langs) {
                tr.addTag("td").addTag("b").addText(lang);
            }
            for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
                this.addLanguageRow(c, t, langs);
            }
        }
        return hasExtensions;
    }

    private int countConcepts(List<CodeSystem.ConceptDefinitionComponent> list) {
        int count = list.size();
        for (CodeSystem.ConceptDefinitionComponent c : list) {
            if (!c.hasConcept()) continue;
            count += this.countConcepts(c.getConcept());
        }
        return count;
    }

    private void generateCopyright(XhtmlNode x, CodeSystem cs) {
        XhtmlNode p = x.addTag("p");
        p.addTag("b").addText("Copyright Statement:");
        this.smartAddText(p, " " + cs.getCopyright());
    }

    public void generate(ValueSet vs, boolean header) {
        this.generate(vs, null, header);
    }

    public void generate(ValueSet vs, ValueSet src, boolean header) {
        boolean hasExtensions;
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        if (vs.hasExpansion()) {
            this.generateExpansion(x, vs, src, header);
        }
        this.inject(vs, x, (hasExtensions = this.generateComposition(x, vs, header)) ? Narrative.NarrativeStatus.EXTENSIONS : Narrative.NarrativeStatus.GENERATED);
    }

    private Integer countMembership(ValueSet vs) {
        int count = 0;
        if (vs.hasExpansion()) {
            count += this.conceptCount(vs.getExpansion().getContains());
        } else if (vs.hasCompose()) {
            if (vs.getCompose().hasExclude()) {
                try {
                    ValueSetExpander.ValueSetExpansionOutcome vse = this.context.expandVS(vs, true);
                    count = 0;
                    return count += this.conceptCount(vse.getValueset().getExpansion().getContains());
                }
                catch (Exception e) {
                    return null;
                }
            }
            for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
                if (inc.hasFilter()) {
                    return null;
                }
                if (!inc.hasConcept()) {
                    return null;
                }
                count += inc.getConcept().size();
            }
        }
        return count;
    }

    private int conceptCount(List<ValueSet.ValueSetExpansionContainsComponent> list) {
        int count = 0;
        for (ValueSet.ValueSetExpansionContainsComponent c : list) {
            if (!c.getAbstract()) {
                ++count;
            }
            count += this.conceptCount(c.getContains());
        }
        return count;
    }

    private boolean generateExpansion(XhtmlNode x, ValueSet vs, ValueSet src, boolean header) {
        boolean hasExtensions = false;
        HashMap<ConceptMap, String> mymaps = new HashMap<ConceptMap, String>();
        for (ConceptMap a : this.context.findMapsForSource(vs.getUrl())) {
            String url = "";
            ValueSet vsr = this.context.fetchResource(ValueSet.class, ((Reference)a.getTarget()).getReference());
            if (vsr != null) {
                url = (String)vsr.getUserData("filename");
            }
            mymaps.put(a, url);
        }
        if (header) {
            XhtmlNode h = x.addTag("h3");
            h.addText("Value Set Contents");
            if (this.IsNotFixedExpansion(vs)) {
                x.addTag("p").addText(vs.getDescription());
            }
            if (vs.hasCopyright()) {
                this.generateCopyright(x, vs);
            }
        }
        if (ToolingExtensions.hasExtension(vs.getExpansion(), "http://hl7.org/fhir/StructureDefinition/valueset-toocostly")) {
            x.addTag("p").setAttribute("style", "border: maroon 1px solid; background-color: #FFCCCC; font-weight: bold; padding: 8px").addText(this.tooCostlyNote);
        } else {
            Integer count = this.countMembership(vs);
            if (count == null) {
                x.addTag("p").addText("This value set does not contain a fixed number of concepts");
            } else {
                x.addTag("p").addText("This value set contains " + count.toString() + " concepts");
            }
        }
        CodeSystem allCS = null;
        boolean doSystem = this.checkDoSystem(vs, src);
        boolean doDefinition = this.checkDoDefinition(vs.getExpansion().getContains());
        if (doSystem && this.allFromOneSystem(vs)) {
            doSystem = false;
            XhtmlNode p = x.addTag("p");
            p.addText("All codes from system ");
            allCS = this.context.fetchCodeSystem(vs.getExpansion().getContains().get(0).getSystem());
            String ref = null;
            if (allCS != null) {
                ref = this.getCsRef(allCS);
            }
            if (ref == null) {
                p.addTag("code").addText(vs.getExpansion().getContains().get(0).getSystem());
            } else {
                p.addTag("a").setAttribute("href", ref).addTag("code").addText(vs.getExpansion().getContains().get(0).getSystem());
            }
        }
        XhtmlNode t = x.addTag("table").setAttribute("class", "codes");
        XhtmlNode tr = t.addTag("tr");
        tr.addTag("td").addTag("b").addText("Code");
        if (doSystem) {
            tr.addTag("td").addTag("b").addText("System");
        }
        tr.addTag("td").addTag("b").addText("Display");
        if (doDefinition) {
            tr.addTag("td").addTag("b").addText("Definition");
        }
        this.addMapHeaders(tr, mymaps);
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            this.addExpansionRowToTable(t, c, 0, doSystem, doDefinition, mymaps, allCS);
        }
        return hasExtensions;
    }

    private boolean checkDoDefinition(List<ValueSet.ValueSetExpansionContainsComponent> contains) {
        for (ValueSet.ValueSetExpansionContainsComponent c : contains) {
            CodeSystem cs = this.context.fetchCodeSystem(c.getSystem());
            if (cs != null) {
                return true;
            }
            if (!this.checkDoDefinition(c.getContains())) continue;
            return true;
        }
        return false;
    }

    private boolean allFromOneSystem(ValueSet vs) {
        if (vs.getExpansion().getContains().isEmpty()) {
            return false;
        }
        String system = vs.getExpansion().getContains().get(0).getSystem();
        for (ValueSet.ValueSetExpansionContainsComponent cc : vs.getExpansion().getContains()) {
            if (this.checkSystemMatches(system, cc)) continue;
            return false;
        }
        return true;
    }

    private boolean checkSystemMatches(String system, ValueSet.ValueSetExpansionContainsComponent cc) {
        if (!system.equals(cc.getSystem())) {
            return false;
        }
        for (ValueSet.ValueSetExpansionContainsComponent cc1 : cc.getContains()) {
            if (this.checkSystemMatches(system, cc1)) continue;
            return false;
        }
        return true;
    }

    private boolean checkDoSystem(ValueSet vs, ValueSet src) {
        if (src != null) {
            vs = src;
        }
        return vs.hasCompose();
    }

    private boolean IsNotFixedExpansion(ValueSet vs) {
        if (vs.hasCompose()) {
            return false;
        }
        if (vs.getCompose().hasImport()) {
            return true;
        }
        for (ValueSet.ConceptSetComponent cc : vs.getCompose().getInclude()) {
            if (cc.hasVersion()) continue;
            return true;
        }
        return false;
    }

    private void addLanguageRow(CodeSystem.ConceptDefinitionComponent c, XhtmlNode t, List<String> langs) {
        XhtmlNode tr = t.addTag("tr");
        tr.addTag("td").addText(c.getCode());
        for (String lang : langs) {
            CodeSystem.ConceptDefinitionDesignationComponent d = null;
            for (CodeSystem.ConceptDefinitionDesignationComponent designation : c.getDesignation()) {
                if (!lang.equals(designation.getLanguage())) continue;
                d = designation;
            }
            tr.addTag("td").addText(d == null ? "" : d.getValue());
        }
    }

    private void scanLangs(CodeSystem.ConceptDefinitionComponent c, List<String> langs) {
        for (CodeSystem.ConceptDefinitionDesignationComponent designation : c.getDesignation()) {
            String lang = designation.getLanguage();
            if (langs == null || langs.contains(lang)) continue;
            langs.add(lang);
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            this.scanLangs(g, langs);
        }
    }

    private void addMapHeaders(XhtmlNode tr, Map<ConceptMap, String> mymaps) {
        for (ConceptMap m : mymaps.keySet()) {
            XhtmlNode td = tr.addTag("td");
            XhtmlNode b = td.addTag("b");
            XhtmlNode a = b.addTag("a");
            a.setAttribute("href", this.prefix + mymaps.get(m));
            a.addText(m.hasDescription() ? m.getDescription() : m.getName());
        }
    }

    private void smartAddText(XhtmlNode p, String text) {
        if (text == null) {
            return;
        }
        String[] lines = text.split("\\r\\n");
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                p.addTag("br");
            }
            p.addText(lines[i]);
        }
    }

    private boolean conceptsHaveComments(CodeSystem.ConceptDefinitionComponent c) {
        if (ToolingExtensions.hasComment(c)) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.conceptsHaveComments(g)) continue;
            return true;
        }
        return false;
    }

    private boolean conceptsHaveDisplay(CodeSystem.ConceptDefinitionComponent c) {
        if (c.hasDisplay()) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.conceptsHaveDisplay(g)) continue;
            return true;
        }
        return false;
    }

    private boolean conceptsHaveDeprecated(CodeSystem cs, CodeSystem.ConceptDefinitionComponent c) {
        if (CodeSystemUtilities.isDeprecated(cs, c)) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.conceptsHaveDeprecated(cs, g)) continue;
            return true;
        }
        return false;
    }

    private void generateCopyright(XhtmlNode x, ValueSet vs) {
        XhtmlNode p = x.addTag("p");
        p.addTag("b").addText("Copyright Statement:");
        this.smartAddText(p, " " + vs.getCopyright());
    }

    private XhtmlNode addTableHeaderRowStandard(XhtmlNode t, boolean hasHierarchy, boolean hasDisplay, boolean definitions, boolean comments, boolean deprecated) {
        XhtmlNode tr = t.addTag("tr");
        if (hasHierarchy) {
            tr.addTag("td").addTag("b").addText("Lvl");
        }
        tr.addTag("td").addTag("b").addText("Code");
        if (hasDisplay) {
            tr.addTag("td").addTag("b").addText("Display");
        }
        if (definitions) {
            tr.addTag("td").addTag("b").addText("Definition");
        }
        if (deprecated) {
            tr.addTag("td").addTag("b").addText("Deprecated");
        }
        if (comments) {
            tr.addTag("td").addTag("b").addText("Comments");
        }
        return tr;
    }

    private void addExpansionRowToTable(XhtmlNode t, ValueSet.ValueSetExpansionContainsComponent c, int i, boolean doSystem, boolean doDefinition, Map<ConceptMap, String> mymaps, CodeSystem allCS) {
        XhtmlNode tr = t.addTag("tr");
        XhtmlNode td = tr.addTag("td");
        String tgt = this.makeAnchor(c.getSystem(), c.getCode());
        td.addTag("a").setAttribute("name", tgt).addText(" ");
        String s = Utilities.padLeft((String)"", (char)'.', (int)(i * 2));
        td.addText(s);
        CodeSystem e = this.context.fetchCodeSystem(c.getSystem());
        if (e == null) {
            td.addText(c.getCode());
        } else {
            XhtmlNode a = td.addTag("a");
            a.addText(c.getCode());
            a.setAttribute("href", this.prefix + this.getCsRef(e) + "#" + Utilities.nmtokenize((String)c.getCode()));
        }
        if (doSystem) {
            td = tr.addTag("td");
            td.addText(c.getSystem());
        }
        td = tr.addTag("td");
        if (c.hasDisplayElement()) {
            td.addText(c.getDisplay());
        }
        if (doDefinition) {
            CodeSystem cs = allCS;
            if (cs == null) {
                cs = this.context.fetchCodeSystem(c.getSystem());
            }
            td = tr.addTag("td");
            if (cs != null) {
                td.addText(CodeSystemUtilities.getCodeDefinition(cs, c.getCode()));
            }
        }
        for (ConceptMap m : mymaps.keySet()) {
            td = tr.addTag("td");
            List<ConceptMap.TargetElementComponent> mappings = this.findMappingsForCode(c.getCode(), m);
            boolean first = true;
            for (ConceptMap.TargetElementComponent mapping : mappings) {
                if (!first) {
                    td.addTag("br");
                }
                first = false;
                XhtmlNode span = td.addTag("span");
                span.setAttribute("title", mapping.getEquivalence().toString());
                span.addText(this.getCharForEquivalence(mapping));
                XhtmlNode a = td.addTag("a");
                a.setAttribute("href", this.prefix + mymaps.get(m) + "#" + mapping.getCode());
                a.addText(mapping.getCode());
                if (Utilities.noString((String)mapping.getComments())) continue;
                td.addTag("i").addText("(" + mapping.getComments() + ")");
            }
        }
        for (ValueSet.ValueSetExpansionContainsComponent cc : c.getContains()) {
            this.addExpansionRowToTable(t, cc, i + 1, doSystem, doDefinition, mymaps, allCS);
        }
    }

    private boolean addDefineRowToTable(XhtmlNode t, CodeSystem.ConceptDefinitionComponent c, int i, boolean hasHierarchy, boolean hasDisplay, boolean comment, boolean deprecated, Map<ConceptMap, String> maps, String system, CodeSystem cs) {
        XhtmlNode a;
        boolean hasExtensions = false;
        XhtmlNode tr = t.addTag("tr");
        XhtmlNode td = tr.addTag("td");
        if (hasHierarchy) {
            td.addText(Integer.toString(i + 1));
            td = tr.addTag("td");
            String s = Utilities.padLeft((String)"", (char)'\u00a0', (int)(i * 2));
            td.addText(s);
        }
        td.addText(c.getCode());
        if (c.hasCodeElement()) {
            a = td.addTag("a");
            a.setAttribute("name", Utilities.nmtokenize((String)c.getCode()));
            a.addText(" ");
        }
        if (hasDisplay) {
            td = tr.addTag("td");
            if (c.hasDisplayElement()) {
                td.addText(c.getDisplay());
            }
        }
        td = tr.addTag("td");
        if (c != null) {
            this.smartAddText(td, c.getDefinition());
        }
        if (deprecated) {
            td = tr.addTag("td");
            Boolean b = CodeSystemUtilities.isDeprecated(cs, c);
            if (b != null && b.booleanValue()) {
                this.smartAddText(td, "Deprecated");
                hasExtensions = true;
                if (ToolingExtensions.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-replacedby")) {
                    Coding coding = (Coding)ToolingExtensions.getExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-replacedby").getValue();
                    td.addText(" (replaced by ");
                    String url = this.getCodingReference(coding, system);
                    if (url != null) {
                        td.addTag("a").setAttribute("href", url).addText(coding.getCode());
                        td.addText(": " + coding.getDisplay() + ")");
                    } else {
                        td.addText(coding.getCode() + " '" + coding.getDisplay() + "' in " + coding.getSystem() + ")");
                    }
                }
            }
        }
        if (comment) {
            td = tr.addTag("td");
            String s = ToolingExtensions.getComment(c);
            if (s != null) {
                this.smartAddText(td, s);
                hasExtensions = true;
            }
        }
        for (ConceptMap conceptMap : maps.keySet()) {
            td = tr.addTag("td");
            List<ConceptMap.TargetElementComponent> mappings = this.findMappingsForCode(c.getCode(), conceptMap);
            boolean first = true;
            for (ConceptMap.TargetElementComponent mapping : mappings) {
                if (!first) {
                    td.addTag("br");
                }
                first = false;
                XhtmlNode span = td.addTag("span");
                span.setAttribute("title", mapping.hasEquivalence() ? mapping.getEquivalence().toCode() : "");
                span.addText(this.getCharForEquivalence(mapping));
                a = td.addTag("a");
                a.setAttribute("href", this.prefix + maps.get(conceptMap) + "#" + this.makeAnchor(mapping.getSystem(), mapping.getCode()));
                a.addText(mapping.getCode());
                if (Utilities.noString((String)mapping.getComments())) continue;
                td.addTag("i").addText("(" + mapping.getComments() + ")");
            }
        }
        for (CodeType codeType : ToolingExtensions.getSubsumes(c)) {
            hasExtensions = true;
            tr = t.addTag("tr");
            td = tr.addTag("td");
            String s = Utilities.padLeft((String)"", (char)'.', (int)(i * 2));
            td.addText(s);
            a = td.addTag("a");
            a.setAttribute("href", "#" + Utilities.nmtokenize((String)((String)codeType.getValue())));
            a.addText(c.getCode());
        }
        for (CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent : c.getConcept()) {
            hasExtensions = this.addDefineRowToTable(t, conceptDefinitionComponent, i + 1, hasHierarchy, hasDisplay, comment, deprecated, maps, system, cs) || hasExtensions;
        }
        return hasExtensions;
    }

    private String makeAnchor(String codeSystem, String code) {
        String s = codeSystem + '-' + code;
        StringBuilder b = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (Character.isAlphabetic(c) || Character.isDigit(c) || c == '.') {
                b.append(c);
                continue;
            }
            b.append('-');
        }
        return b.toString();
    }

    private String getCodingReference(Coding cc, String system) {
        if (cc.getSystem().equals(system)) {
            return "#" + cc.getCode();
        }
        if (cc.getSystem().equals("http://snomed.info/sct")) {
            return "http://snomed.info/sct/" + cc.getCode();
        }
        if (cc.getSystem().equals("http://loinc.org")) {
            return "http://s.details.loinc.org/LOINC/" + cc.getCode() + ".html";
        }
        return null;
    }

    private String getCharForEquivalence(ConceptMap.TargetElementComponent mapping) {
        if (!mapping.hasEquivalence()) {
            return "";
        }
        switch (mapping.getEquivalence()) {
            case EQUAL: {
                return "=";
            }
            case EQUIVALENT: {
                return "~";
            }
            case WIDER: {
                return "<";
            }
            case NARROWER: {
                return ">";
            }
            case INEXACT: {
                return "><";
            }
            case UNMATCHED: {
                return "-";
            }
            case DISJOINT: {
                return "!=";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    private List<ConceptMap.TargetElementComponent> findMappingsForCode(String code, ConceptMap map) {
        ArrayList<ConceptMap.TargetElementComponent> mappings = new ArrayList<ConceptMap.TargetElementComponent>();
        for (ConceptMap.SourceElementComponent c : map.getElement()) {
            if (!c.getCode().equals(code)) continue;
            mappings.addAll(c.getTarget());
        }
        return mappings;
    }

    private boolean generateComposition(XhtmlNode x, ValueSet vs, boolean header) {
        boolean hasExtensions = false;
        if (header) {
            XhtmlNode h = x.addTag("h2");
            h.addText(vs.getName());
            XhtmlNode p = x.addTag("p");
            this.smartAddText(p, vs.getDescription());
            if (vs.hasCopyrightElement()) {
                this.generateCopyright(x, vs);
            }
        }
        XhtmlNode p = x.addTag("p");
        p.addText("This value set includes codes from the following code systems:");
        XhtmlNode ul = x.addTag("ul");
        for (UriType imp : vs.getCompose().getImport()) {
            XhtmlNode li = ul.addTag("li");
            li.addText("Import all the codes that are contained in ");
            this.AddVsRef((String)imp.getValue(), li);
        }
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
            hasExtensions = this.genInclude(ul, inc, "Include") || hasExtensions;
        }
        for (ValueSet.ConceptSetComponent exc : vs.getCompose().getExclude()) {
            hasExtensions = this.genInclude(ul, exc, "Exclude") || hasExtensions;
        }
        return hasExtensions;
    }

    private void AddVsRef(String value, XhtmlNode li) {
        ValueSet vs = this.context.fetchResource(ValueSet.class, value);
        if (vs != null) {
            String ref = (String)vs.getUserData("path");
            ref = this.adjustForPath(ref);
            XhtmlNode a = li.addTag("a");
            a.setAttribute("href", ref == null ? "??" : ref.replace("\\", "/"));
            a.addText(value);
        } else {
            CodeSystem cs = this.context.fetchCodeSystem(value);
            if (cs != null) {
                String ref = (String)cs.getUserData("path");
                ref = this.adjustForPath(ref);
                XhtmlNode a = li.addTag("a");
                a.setAttribute("href", ref == null ? "??" : ref.replace("\\", "/"));
                a.addText(value);
            } else if (value.equals("http://snomed.info/sct") || value.equals("http://snomed.info/id")) {
                XhtmlNode a = li.addTag("a");
                a.setAttribute("href", value);
                a.addText("SNOMED-CT");
            } else {
                if (value.startsWith("http://hl7.org") && !Utilities.existsInList((String)value, (String[])new String[]{"http://hl7.org/fhir/sid/icd-10-us"})) {
                    throw new Error("Unable to resolve value set " + value);
                }
                li.addText(value);
            }
        }
    }

    private String adjustForPath(String ref) {
        if (this.prefix == null) {
            return ref;
        }
        return this.prefix + ref;
    }

    private boolean genInclude(XhtmlNode ul, ValueSet.ConceptSetComponent inc, String type) {
        boolean hasExtensions = false;
        XhtmlNode li = ul.addTag("li");
        CodeSystem e = this.context.fetchCodeSystem(inc.getSystem());
        if (inc.getConcept().size() == 0 && inc.getFilter().size() == 0) {
            li.addText(type + " all codes defined in ");
            this.addCsRef(inc, li, e);
        } else {
            if (inc.getConcept().size() > 0) {
                li.addText(type + " these codes as defined in ");
                this.addCsRef(inc, li, e);
                XhtmlNode t = li.addTag("table");
                boolean hasComments = false;
                boolean hasDefinition = false;
                for (ValueSet.ConceptReferenceComponent c : inc.getConcept()) {
                    hasComments = hasComments || ExtensionHelper.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-comments");
                    hasDefinition = hasDefinition || ExtensionHelper.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-definition");
                }
                if (hasComments || hasDefinition) {
                    hasExtensions = true;
                }
                this.addTableHeaderRowStandard(t, false, true, hasDefinition, hasComments, false);
                for (ValueSet.ConceptReferenceComponent c : inc.getConcept()) {
                    XhtmlNode tr = t.addTag("tr");
                    tr.addTag("td").addText(c.getCode());
                    CodeSystem.ConceptDefinitionComponent cc = this.getConceptForCode(e, c.getCode(), inc.getSystem());
                    XhtmlNode td = tr.addTag("td");
                    if (!Utilities.noString((String)c.getDisplay())) {
                        td.addText(c.getDisplay());
                    } else if (cc != null && !Utilities.noString((String)cc.getDisplay())) {
                        td.addText(cc.getDisplay());
                    }
                    td = tr.addTag("td");
                    if (ExtensionHelper.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-definition")) {
                        this.smartAddText(td, ToolingExtensions.readStringExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-definition"));
                    } else if (cc != null && !Utilities.noString((String)cc.getDefinition())) {
                        this.smartAddText(td, cc.getDefinition());
                    }
                    if (!ExtensionHelper.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-comments")) continue;
                    this.smartAddText(tr.addTag("td"), "Note: " + ToolingExtensions.readStringExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-comments"));
                }
            }
            boolean first = true;
            for (ValueSet.ConceptSetFilterComponent f : inc.getFilter()) {
                String disp;
                if (first) {
                    li.addText(type + " codes from ");
                    first = false;
                } else {
                    li.addText(" and ");
                }
                this.addCsRef(inc, li, e);
                li.addText(" where " + f.getProperty() + " " + this.describe(f.getOp()) + " ");
                if (e != null && this.codeExistsInValueSet(e, f.getValue())) {
                    XhtmlNode a = li.addTag("a");
                    a.addText(f.getValue());
                    a.setAttribute("href", this.prefix + this.getCsRef(e) + "#" + Utilities.nmtokenize((String)f.getValue()));
                } else {
                    li.addText(f.getValue());
                }
                if ((disp = ToolingExtensions.getDisplayHint(f)) == null) continue;
                li.addText(" (" + disp + ")");
            }
        }
        return hasExtensions;
    }

    private String describe(ValueSet.FilterOperator opSimple) {
        switch (opSimple) {
            case EQUAL: {
                return " = ";
            }
            case ISA: {
                return " is-a ";
            }
            case ISNOTA: {
                return " is-not-a ";
            }
            case REGEX: {
                return " matches (by regex) ";
            }
            case NULL: {
                return " ?? ";
            }
            case IN: {
                return " in ";
            }
            case NOTIN: {
                return " not in ";
            }
        }
        return null;
    }

    private CodeSystem.ConceptDefinitionComponent getConceptForCode(CodeSystem e, String code, String system) {
        if (e == null) {
            return this.context.validateCode(system, code, null).asConceptDefinition();
        }
        for (CodeSystem.ConceptDefinitionComponent c : e.getConcept()) {
            CodeSystem.ConceptDefinitionComponent v = this.getConceptForCode(c, code);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private CodeSystem.ConceptDefinitionComponent getConceptForCode(CodeSystem.ConceptDefinitionComponent c, String code) {
        if (code.equals(c.getCode())) {
            return c;
        }
        for (CodeSystem.ConceptDefinitionComponent cc : c.getConcept()) {
            CodeSystem.ConceptDefinitionComponent v = this.getConceptForCode(cc, code);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private <T extends Resource> void addCsRef(ValueSet.ConceptSetComponent inc, XhtmlNode li, T cs) {
        String ref = null;
        if (cs != null && Utilities.noString((String)(ref = (String)cs.getUserData("filename")))) {
            ref = (String)cs.getUserData("path");
        }
        if (cs != null && ref != null) {
            if (!Utilities.noString((String)this.prefix) && ref.startsWith("http://hl7.org/fhir/")) {
                ref = ref.substring(20) + "/index.html";
            } else if (!ref.endsWith(".html")) {
                ref = ref + ".html";
            }
            XhtmlNode a = li.addTag("a");
            a.setAttribute("href", this.prefix + ref.replace("\\", "/"));
            a.addText(inc.getSystem().toString());
        } else {
            li.addText(inc.getSystem().toString());
        }
    }

    private String getCsRef(String system) {
        CodeSystem cs = this.context.fetchCodeSystem(system);
        return this.getCsRef(cs);
    }

    private <T extends Resource> String getCsRef(T cs) {
        String ref = (String)cs.getUserData("filename");
        if (ref == null) {
            return "v2/0136/index.html";
        }
        if (!ref.endsWith(".html")) {
            ref = ref + ".html";
        }
        return ref.replace("\\", "/");
    }

    private boolean codeExistsInValueSet(CodeSystem cs, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
            if (!this.inConcept(code, c)) continue;
            return true;
        }
        return false;
    }

    private boolean inConcept(String code, CodeSystem.ConceptDefinitionComponent c) {
        if (c.hasCodeElement() && c.getCode().equals(code)) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.inConcept(code, g)) continue;
            return true;
        }
        return false;
    }

    public void generate(OperationOutcome op) throws DefinitionException {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        boolean hasSource = false;
        boolean success = true;
        for (OperationOutcome.OperationOutcomeIssueComponent i : op.getIssue()) {
            success = success && i.getSeverity() == OperationOutcome.IssueSeverity.INFORMATION;
            hasSource = hasSource || ExtensionHelper.hasExtension(i, "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-source");
        }
        if (success) {
            x.addTag("p").addText("All OK");
        }
        if (op.getIssue().size() > 0) {
            XhtmlNode tbl = x.addTag("table");
            tbl.setAttribute("class", "grid");
            XhtmlNode tr = tbl.addTag("tr");
            tr.addTag("td").addTag("b").addText("Severity");
            tr.addTag("td").addTag("b").addText("Location");
            tr.addTag("td").addTag("b").addText("Code");
            tr.addTag("td").addTag("b").addText("Details");
            tr.addTag("td").addTag("b").addText("Diagnostics");
            if (hasSource) {
                tr.addTag("td").addTag("b").addText("Source");
            }
            for (OperationOutcome.OperationOutcomeIssueComponent i : op.getIssue()) {
                tr = tbl.addTag("tr");
                tr.addTag("td").addText(i.getSeverity().toString());
                XhtmlNode td = tr.addTag("td");
                boolean d = false;
                for (StringType s : i.getLocation()) {
                    if (d) {
                        td.addText(", ");
                    } else {
                        d = true;
                    }
                    td.addText((String)s.getValue());
                }
                tr.addTag("td").addText(i.getCode().getDisplay());
                tr.addTag("td").addText(this.gen(i.getDetails()));
                this.smartAddText(tr.addTag("td"), i.getDiagnostics());
                if (!hasSource) continue;
                Extension ext = ExtensionHelper.getExtension(i, "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-source");
                tr.addTag("td").addText(ext == null ? "" : this.gen(ext));
            }
        }
        this.inject(op, x, hasSource ? Narrative.NarrativeStatus.EXTENSIONS : Narrative.NarrativeStatus.GENERATED);
    }

    private String gen(Extension extension) throws DefinitionException {
        if (extension.getValue() instanceof CodeType) {
            return (String)((CodeType)extension.getValue()).getValue();
        }
        if (extension.getValue() instanceof Coding) {
            return this.gen((Coding)extension.getValue());
        }
        throw new DefinitionException("Unhandled type " + extension.getValue().getClass().getName());
    }

    private String gen(CodeableConcept code) {
        if (code == null) {
            return null;
        }
        if (code.hasText()) {
            return code.getText();
        }
        if (code.hasCoding()) {
            return this.gen(code.getCoding().get(0));
        }
        return null;
    }

    private String gen(Coding code) {
        if (code == null) {
            return null;
        }
        if (code.hasDisplayElement()) {
            return code.getDisplay();
        }
        if (code.hasCodeElement()) {
            return code.getCode();
        }
        return null;
    }

    public void generate(OperationDefinition opd) throws EOperationOutcome, FHIRException, IOException {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.addTag("h2").addText(opd.getName());
        x.addTag("p").addText(Utilities.capitalize((String)opd.getKind().toString()) + ": " + opd.getName());
        this.addMarkdown(x, opd.getDescription());
        if (opd.getSystem()) {
            x.addTag("p").addText("URL: [base]/$" + opd.getCode());
        }
        for (CodeType c : opd.getType()) {
            x.addTag("p").addText("URL: [base]/" + (String)c.getValue() + "/$" + opd.getCode());
            if (!opd.getInstance()) continue;
            x.addTag("p").addText("URL: [base]/" + (String)c.getValue() + "/[id]/$" + opd.getCode());
        }
        x.addTag("p").addText("Parameters");
        XhtmlNode tbl = x.addTag("table").setAttribute("class", "grid");
        XhtmlNode tr = tbl.addTag("tr");
        tr.addTag("td").addTag("b").addText("Use");
        tr.addTag("td").addTag("b").addText("Name");
        tr.addTag("td").addTag("b").addText("Cardinality");
        tr.addTag("td").addTag("b").addText("Type");
        tr.addTag("td").addTag("b").addText("Binding");
        tr.addTag("td").addTag("b").addText("Documentation");
        for (OperationDefinition.OperationDefinitionParameterComponent p : opd.getParameter()) {
            this.genOpParam(tbl, "", p);
        }
        this.addMarkdown(x, opd.getComment());
        this.inject(opd, x, Narrative.NarrativeStatus.GENERATED);
    }

    private void genOpParam(XhtmlNode tbl, String path, OperationDefinition.OperationDefinitionParameterComponent p) throws EOperationOutcome, FHIRException, IOException {
        XhtmlNode tr = tbl.addTag("tr");
        tr.addTag("td").addText(p.getUse().toString());
        tr.addTag("td").addText(path + p.getName());
        tr.addTag("td").addText(Integer.toString(p.getMin()) + ".." + p.getMax());
        tr.addTag("td").addText(p.hasType() ? p.getType() : "");
        XhtmlNode td = tr.addTag("td");
        if (p.hasBinding() && p.getBinding().hasValueSet()) {
            if (p.getBinding().getValueSet() instanceof Reference) {
                this.AddVsRef(p.getBinding().getValueSetReference().getReference(), td);
            } else {
                td.addTag("a").setAttribute("href", (String)p.getBinding().getValueSetUriType().getValue()).addText("External Reference");
            }
            td.addText(" (" + p.getBinding().getStrength().getDisplay() + ")");
        }
        this.addMarkdown(tr.addTag("td"), p.getDocumentation());
        if (!p.hasType()) {
            for (OperationDefinition.OperationDefinitionParameterComponent pp : p.getPart()) {
                this.genOpParam(tbl, path + p.getName() + ".", pp);
            }
        }
    }

    private void addMarkdown(XhtmlNode x, String text) throws FHIRFormatError, IOException, DefinitionException {
        if (text != null) {
            XhtmlDocument m;
            while (text.contains("[[[")) {
                String left = text.substring(0, text.indexOf("[[["));
                String link = text.substring(text.indexOf("[[[") + 3, text.indexOf("]]]"));
                String right = text.substring(text.indexOf("]]]") + 3);
                String url = link;
                String[] parts = link.split("\\#");
                StructureDefinition p = this.context.fetchResource(StructureDefinition.class, parts[0]);
                if (p == null) {
                    p = this.context.fetchTypeDefinition(parts[0]);
                }
                if (p == null) {
                    p = this.context.fetchResource(StructureDefinition.class, link);
                }
                if (p != null) {
                    url = p.getUserString("path");
                    if (url == null) {
                        url = p.getUserString("filename");
                    }
                } else {
                    throw new DefinitionException("Unable to resolve markdown link " + link);
                }
                text = left + "[" + link + "](" + url + ")" + right;
            }
            String s = new MarkDownProcessor(MarkDownProcessor.Dialect.DARING_FIREBALL).process(Utilities.escapeXml((String)text), "NarrativeGenerator");
            XhtmlParser p = new XhtmlParser();
            try {
                m = p.parse("<div>" + s + "</div>", "div");
            }
            catch (FHIRFormatError e) {
                throw new FHIRFormatError(e.getMessage(), (Throwable)e);
            }
            x.getChildNodes().addAll(m.getChildNodes());
        }
    }

    public void generate(CompartmentDefinition cpd) {
        StringBuilder in = new StringBuilder();
        StringBuilder out = new StringBuilder();
        for (CompartmentDefinition.CompartmentDefinitionResourceComponent cc : cpd.getResource()) {
            CommaSeparatedStringBuilder rules = new CommaSeparatedStringBuilder();
            if (!cc.hasParam()) {
                out.append(" <li><a href=\"").append(cc.getCode().toLowerCase()).append(".html\">").append(cc.getCode()).append("</a></li>\r\n");
                continue;
            }
            if (rules.equals("{def}")) continue;
            for (StringType p : cc.getParam()) {
                rules.append(p.asStringValue());
            }
            in.append(" <tr><td><a href=\"").append(cc.getCode().toLowerCase()).append(".html\">").append(cc.getCode()).append("</a></td><td>").append(rules.toString()).append("</td></tr>\r\n");
        }
        try {
            XhtmlNode x = new XhtmlParser().parseFragment("<div><p>\r\nThe following resources may be in this compartment:\r\n</p>\r\n<table class=\"grid\">\r\n <tr><td><b>Resource</b></td><td><b>Inclusion Criteria</b></td></tr>\r\n" + in.toString() + "</table>\r\n<p>\r\nA resource is in this compartment if the nominated search parameter (or chain) refers to the patient resource that defines the compartment.\r\n</p>\r\n<p>\r\n\r\n</p>\r\n<p>\r\nThe following resources are never in this compartment:\r\n</p>\r\n<ul>\r\n" + out.toString() + "</ul></div>\r\n");
            this.inject(cpd, x, Narrative.NarrativeStatus.GENERATED);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void generate(Conformance conf) {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.addTag("h2").addText(conf.getName());
        this.smartAddText(x.addTag("p"), conf.getDescription());
        Conformance.ConformanceRestComponent rest = conf.getRest().get(0);
        XhtmlNode t = x.addTag("table");
        this.addTableRow(t, "Mode", rest.getMode().toString());
        this.addTableRow(t, "Description", rest.getDocumentation());
        this.addTableRow(t, "Transaction", this.showOp(rest, Conformance.SystemRestfulInteraction.TRANSACTION));
        this.addTableRow(t, "System History", this.showOp(rest, Conformance.SystemRestfulInteraction.HISTORYSYSTEM));
        this.addTableRow(t, "System Search", this.showOp(rest, Conformance.SystemRestfulInteraction.SEARCHSYSTEM));
        t = x.addTag("table");
        XhtmlNode tr = t.addTag("tr");
        tr.addTag("th").addTag("b").addText("Resource Type");
        tr.addTag("th").addTag("b").addText("Profile");
        tr.addTag("th").addTag("b").addText("Read");
        tr.addTag("th").addTag("b").addText("V-Read");
        tr.addTag("th").addTag("b").addText("Search");
        tr.addTag("th").addTag("b").addText("Update");
        tr.addTag("th").addTag("b").addText("Updates");
        tr.addTag("th").addTag("b").addText("Create");
        tr.addTag("th").addTag("b").addText("Delete");
        tr.addTag("th").addTag("b").addText("History");
        for (Conformance.ConformanceRestResourceComponent r : rest.getResource()) {
            tr = t.addTag("tr");
            tr.addTag("td").addText(r.getType());
            if (r.hasProfile()) {
                XhtmlNode a = tr.addTag("td").addTag("a");
                a.addText(r.getProfile().getReference());
                a.setAttribute("href", this.prefix + r.getProfile().getReference());
            }
            tr.addTag("td").addText(this.showOp(r, Conformance.TypeRestfulInteraction.READ));
            tr.addTag("td").addText(this.showOp(r, Conformance.TypeRestfulInteraction.VREAD));
            tr.addTag("td").addText(this.showOp(r, Conformance.TypeRestfulInteraction.SEARCHTYPE));
            tr.addTag("td").addText(this.showOp(r, Conformance.TypeRestfulInteraction.UPDATE));
            tr.addTag("td").addText(this.showOp(r, Conformance.TypeRestfulInteraction.HISTORYINSTANCE));
            tr.addTag("td").addText(this.showOp(r, Conformance.TypeRestfulInteraction.CREATE));
            tr.addTag("td").addText(this.showOp(r, Conformance.TypeRestfulInteraction.DELETE));
            tr.addTag("td").addText(this.showOp(r, Conformance.TypeRestfulInteraction.HISTORYTYPE));
        }
        this.inject(conf, x, Narrative.NarrativeStatus.GENERATED);
    }

    private String showOp(Conformance.ConformanceRestResourceComponent r, Conformance.TypeRestfulInteraction on) {
        for (Conformance.ResourceInteractionComponent op : r.getInteraction()) {
            if (op.getCode() != on) continue;
            return "y";
        }
        return "";
    }

    private String showOp(Conformance.ConformanceRestComponent r, Conformance.SystemRestfulInteraction on) {
        for (Conformance.SystemInteractionComponent op : r.getInteraction()) {
            if (op.getCode() != on) continue;
            return "y";
        }
        return "";
    }

    private void addTableRow(XhtmlNode t, String name, String value) {
        XhtmlNode tr = t.addTag("tr");
        tr.addTag("td").addText(name);
        tr.addTag("td").addText(value);
    }

    public XhtmlNode generateDocumentNarrative(Bundle feed) {
        XhtmlNode root = new XhtmlNode(NodeType.Element, "div");
        Composition comp = (Composition)feed.getEntry().get(0).getResource();
        root.getChildNodes().add(comp.getText().getDiv());
        Resource subject = ResourceUtilities.getById(feed, null, comp.getSubject().getReference());
        if (subject != null && subject instanceof DomainResource) {
            root.addTag("hr");
            root.getChildNodes().add(((DomainResource)subject).getText().getDiv());
        }
        List<Composition.SectionComponent> sections = comp.getSection();
        this.renderSections(feed, root, sections, 1);
        return root;
    }

    private void renderSections(Bundle feed, XhtmlNode node, List<Composition.SectionComponent> sections, int level) {
        for (Composition.SectionComponent section : sections) {
            node.addTag("hr");
            if (!section.hasTitleElement()) continue;
            node.addTag("h" + Integer.toString(level)).addText(section.getTitle());
        }
    }

    public class ResourceWithReference {
        private String reference;
        private ResourceWrapper resource;

        public ResourceWithReference(String reference, ResourceWrapper resource) {
            this.reference = reference;
            this.resource = resource;
        }

        public String getReference() {
            return this.reference;
        }

        public ResourceWrapper getResource() {
            return this.resource;
        }
    }

    private class ResourceWrapperDirect
    implements ResourceWrapper {
        private Resource wrapped;

        private ResourceWrapperDirect(Resource wrapped) {
            if (wrapped == null) {
                throw new Error("wrapped == null");
            }
            this.wrapped = wrapped;
        }

        @Override
        public List<ResourceWrapper> getContained() {
            ArrayList<ResourceWrapper> list = new ArrayList<ResourceWrapper>();
            if (this.wrapped instanceof DomainResource) {
                DomainResource dr = (DomainResource)this.wrapped;
                for (Resource c : dr.getContained()) {
                    list.add(new ResourceWrapperDirect(c));
                }
            }
            return list;
        }

        @Override
        public String getId() {
            return this.wrapped.getId();
        }

        @Override
        public XhtmlNode getNarrative() {
            DomainResource dr;
            if (this.wrapped instanceof DomainResource && (dr = (DomainResource)this.wrapped).hasText() && dr.getText().hasDiv()) {
                return dr.getText().getDiv();
            }
            return null;
        }

        @Override
        public String getName() {
            return this.wrapped.getResourceType().toString();
        }

        @Override
        public List<PropertyWrapper> children() {
            ArrayList<PropertyWrapper> list = new ArrayList<PropertyWrapper>();
            for (Property c : this.wrapped.children()) {
                list.add(new PropertyWrapperDirect(c));
            }
            return list;
        }
    }

    private class BaseWrapperDirect
    implements BaseWrapper {
        private Base wrapped;
        private List<PropertyWrapper> list;

        private BaseWrapperDirect(Base wrapped) {
            if (wrapped == null) {
                throw new Error("wrapped == null");
            }
            this.wrapped = wrapped;
        }

        @Override
        public Base getBase() {
            return this.wrapped;
        }

        @Override
        public List<PropertyWrapper> children() {
            if (this.list == null) {
                this.list = new ArrayList<PropertyWrapper>();
                for (Property p : this.wrapped.children()) {
                    this.list.add(new PropertyWrapperDirect(p));
                }
            }
            return this.list;
        }

        @Override
        public PropertyWrapper getChildByName(String name) {
            Property p = this.wrapped.getChildByName(name);
            if (p == null) {
                return null;
            }
            return new PropertyWrapperDirect(p);
        }
    }

    private class PropertyWrapperDirect
    implements PropertyWrapper {
        private Property wrapped;
        private List<BaseWrapper> list;

        private PropertyWrapperDirect(Property wrapped) {
            if (wrapped == null) {
                throw new Error("wrapped == null");
            }
            this.wrapped = wrapped;
        }

        @Override
        public String getName() {
            return this.wrapped.getName();
        }

        @Override
        public boolean hasValues() {
            return this.wrapped.hasValues();
        }

        @Override
        public List<BaseWrapper> getValues() {
            if (this.list == null) {
                this.list = new ArrayList<BaseWrapper>();
                for (Base b : this.wrapped.getValues()) {
                    this.list.add(b == null ? null : new BaseWrapperDirect(b));
                }
            }
            return this.list;
        }

        @Override
        public String getTypeCode() {
            return this.wrapped.getTypeCode();
        }

        @Override
        public String getDefinition() {
            return this.wrapped.getDefinition();
        }

        @Override
        public int getMinCardinality() {
            return this.wrapped.getMinCardinality();
        }

        @Override
        public int getMaxCardinality() {
            return this.wrapped.getMinCardinality();
        }

        @Override
        public StructureDefinition getStructure() {
            return this.wrapped.getStructure();
        }
    }

    private class ResurceWrapperElement
    implements ResourceWrapper {
        private Element wrapped;
        private StructureDefinition definition;
        private List<ResourceWrapper> list;
        private List<PropertyWrapper> list2;

        public ResurceWrapperElement(Element wrapped, StructureDefinition definition) {
            this.wrapped = wrapped;
            this.definition = definition;
        }

        @Override
        public List<ResourceWrapper> getContained() {
            if (this.list == null) {
                ArrayList children = new ArrayList();
                XMLUtil.getNamedChildren((Element)this.wrapped, (String)"contained", children);
                this.list = new ArrayList<ResourceWrapper>();
                for (Element e : children) {
                    Element c = XMLUtil.getFirstChild((Element)e);
                    this.list.add(new ResurceWrapperElement(c, NarrativeGenerator.this.context.fetchTypeDefinition(c.getNodeName())));
                }
            }
            return this.list;
        }

        @Override
        public String getId() {
            return XMLUtil.getNamedChildValue((Element)this.wrapped, (String)"id");
        }

        @Override
        public XhtmlNode getNarrative() throws FHIRFormatError, IOException, FHIRException {
            Element txt = XMLUtil.getNamedChild((Element)this.wrapped, (String)"text");
            if (txt == null) {
                return null;
            }
            Element div = XMLUtil.getNamedChild((Element)txt, (String)"div");
            if (div == null) {
                return null;
            }
            try {
                return new XhtmlParser().parse(new XmlGenerator().generate(div), "div");
            }
            catch (FHIRFormatError e) {
                throw new FHIRFormatError(e.getMessage(), (Throwable)e);
            }
            catch (FHIRException e) {
                throw new FHIRException(e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public String getName() {
            return this.wrapped.getNodeName();
        }

        @Override
        public List<PropertyWrapper> children() {
            if (this.list2 == null) {
                List<ElementDefinition> children = ProfileUtilities.getChildList(this.definition, this.definition.getSnapshot().getElement().get(0));
                this.list2 = new ArrayList<PropertyWrapper>();
                for (ElementDefinition child : children) {
                    ArrayList<Element> elements = new ArrayList<Element>();
                    XMLUtil.getNamedChildrenWithWildcard((Element)this.wrapped, (String)NarrativeGenerator.this.tail(child.getPath()), elements);
                    this.list2.add(new PropertyWrapperElement(this.definition, child, elements));
                }
            }
            return this.list2;
        }
    }

    private class PropertyWrapperElement
    implements PropertyWrapper {
        private StructureDefinition structure;
        private ElementDefinition definition;
        private List<Element> values;
        private List<BaseWrapper> list;

        public PropertyWrapperElement(StructureDefinition structure, ElementDefinition definition, List<Element> values) {
            this.structure = structure;
            this.definition = definition;
            this.values = values;
        }

        @Override
        public String getName() {
            return NarrativeGenerator.this.tail(this.definition.getPath());
        }

        @Override
        public boolean hasValues() {
            return this.values.size() > 0;
        }

        @Override
        public List<BaseWrapper> getValues() {
            if (this.list == null) {
                this.list = new ArrayList<BaseWrapper>();
                for (Element e : this.values) {
                    this.list.add(new BaseWrapperElement(e, this.determineType(e), this.structure, this.definition));
                }
            }
            return this.list;
        }

        private String determineType(Element e) {
            if (this.definition.getType().isEmpty()) {
                return null;
            }
            if (this.definition.getType().size() == 1) {
                if (this.definition.getType().get(0).getCode().equals("Element") || this.definition.getType().get(0).getCode().equals("BackboneElement")) {
                    return null;
                }
                return this.definition.getType().get(0).getCode();
            }
            String t = e.getNodeName().substring(NarrativeGenerator.this.tail(this.definition.getPath()).length() - 3);
            boolean allReference = true;
            for (ElementDefinition.TypeRefComponent tr : this.definition.getType()) {
                if (tr.getCode().equals("Reference")) continue;
                allReference = false;
            }
            if (allReference) {
                return "Reference";
            }
            if (ProfileUtilities.isPrimitive(t)) {
                return Utilities.uncapitalize((String)t);
            }
            return t;
        }

        @Override
        public String getTypeCode() {
            throw new Error("todo");
        }

        @Override
        public String getDefinition() {
            throw new Error("todo");
        }

        @Override
        public int getMinCardinality() {
            throw new Error("todo");
        }

        @Override
        public int getMaxCardinality() {
            throw new Error("todo");
        }

        @Override
        public StructureDefinition getStructure() {
            return this.structure;
        }
    }

    private class BaseWrapperElement
    implements BaseWrapper {
        private Element element;
        private String type;
        private StructureDefinition structure;
        private ElementDefinition definition;
        private List<ElementDefinition> children;
        private List<PropertyWrapper> list;

        public BaseWrapperElement(Element element, String type, StructureDefinition structure, ElementDefinition definition) {
            this.element = element;
            this.type = type;
            this.structure = structure;
            this.definition = definition;
        }

        @Override
        public Base getBase() throws UnsupportedEncodingException, IOException, FHIRException {
            String xml;
            if (this.type == null || this.type.equals("Resource") || this.type.equals("BackboneElement") || this.type.equals("Element")) {
                return null;
            }
            try {
                xml = new XmlGenerator().generate(this.element);
            }
            catch (FHIRException e) {
                throw new FHIRException(e.getMessage(), (Throwable)e);
            }
            return NarrativeGenerator.this.context.newXmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).parseType(xml, this.type);
        }

        @Override
        public List<PropertyWrapper> children() {
            if (this.list == null) {
                this.children = ProfileUtilities.getChildList(this.structure, this.definition);
                this.list = new ArrayList<PropertyWrapper>();
                for (ElementDefinition child : this.children) {
                    ArrayList<Element> elements = new ArrayList<Element>();
                    XMLUtil.getNamedChildrenWithWildcard((Element)this.element, (String)NarrativeGenerator.this.tail(child.getPath()), elements);
                    this.list.add(new PropertyWrapperElement(this.structure, child, elements));
                }
            }
            return this.list;
        }

        @Override
        public PropertyWrapper getChildByName(String name) {
            for (PropertyWrapper p : this.children()) {
                if (!p.getName().equals(name)) continue;
                return p;
            }
            return null;
        }
    }

    private static interface BaseWrapper {
        public Base getBase() throws UnsupportedEncodingException, IOException, FHIRException;

        public List<PropertyWrapper> children();

        public PropertyWrapper getChildByName(String var1);
    }

    private static interface ResourceWrapper {
        public List<ResourceWrapper> getContained();

        public String getId();

        public XhtmlNode getNarrative() throws FHIRFormatError, IOException, FHIRException;

        public String getName();

        public List<PropertyWrapper> children();
    }

    private static interface PropertyWrapper {
        public String getName();

        public boolean hasValues();

        public List<BaseWrapper> getValues();

        public String getTypeCode();

        public String getDefinition();

        public int getMinCardinality();

        public int getMaxCardinality();

        public StructureDefinition getStructure();
    }
}

