/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.utils;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.hl7.fhir.dstu2016may.formats.IParser;
import org.hl7.fhir.dstu2016may.formats.ParserType;
import org.hl7.fhir.dstu2016may.model.CodeSystem;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.ConceptMap;
import org.hl7.fhir.dstu2016may.model.OperationOutcome;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.StructureDefinition;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.dstu2016may.terminologies.ValueSetExpander;
import org.hl7.fhir.dstu2016may.utils.INarrativeGenerator;

public interface IWorkerContext {
    public IParser getParser(ParserType var1);

    public IParser getParser(String var1);

    public IParser newJsonParser();

    public IParser newXmlParser();

    public INarrativeGenerator getNarrativeGenerator(String var1, String var2);

    public <T extends Resource> T fetchResource(Class<T> var1, String var2);

    public <T extends Resource> boolean hasResource(Class<T> var1, String var2);

    public List<String> getResourceNames();

    public List<StructureDefinition> allStructures();

    public CodeSystem fetchCodeSystem(String var1);

    public boolean supportsSystem(String var1);

    public List<ConceptMap> findMapsForSource(String var1);

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet var1, boolean var2);

    public ValueSet.ValueSetExpansionComponent expandVS(ValueSet.ConceptSetComponent var1);

    public Locale getLocale();

    public void setLocale(Locale var1);

    public String formatMessage(String var1, Object ... var2);

    public void setValidationMessageLanguage(Locale var1);

    public ValidationResult validateCode(String var1, String var2, String var3);

    public ValidationResult validateCode(String var1, String var2, String var3, ValueSet var4);

    public ValidationResult validateCode(Coding var1, ValueSet var2);

    public ValidationResult validateCode(CodeableConcept var1, ValueSet var2);

    public ValidationResult validateCode(String var1, String var2, String var3, ValueSet.ConceptSetComponent var4);

    public String getAbbreviation(String var1);

    public Set<String> typeTails();

    public String oid2Uri(String var1);

    public StructureDefinition fetchTypeDefinition(String var1);

    public static class ValidationResult {
        private CodeSystem.ConceptDefinitionComponent definition;
        private OperationOutcome.IssueSeverity severity;
        private String message;

        public ValidationResult(OperationOutcome.IssueSeverity severity, String message) {
            this.severity = severity;
            this.message = message;
        }

        public ValidationResult(CodeSystem.ConceptDefinitionComponent definition) {
            this.definition = definition;
        }

        public ValidationResult(OperationOutcome.IssueSeverity severity, String message, CodeSystem.ConceptDefinitionComponent definition) {
            this.severity = severity;
            this.message = message;
            this.definition = definition;
        }

        public boolean isOk() {
            return this.definition != null;
        }

        public String getDisplay() {
            return this.definition == null ? null : this.definition.getDisplay();
        }

        public CodeSystem.ConceptDefinitionComponent asConceptDefinition() {
            return this.definition;
        }

        public OperationOutcome.IssueSeverity getSeverity() {
            return this.severity;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

