/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3TimingEvent {
    AC,
    ACD,
    ACM,
    ACV,
    C,
    CD,
    CM,
    CV,
    HS,
    IC,
    ICD,
    ICM,
    ICV,
    PC,
    PCD,
    PCM,
    PCV,
    WAKE,
    NULL;


    public static V3TimingEvent fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("AC".equals(codeString)) {
            return AC;
        }
        if ("ACD".equals(codeString)) {
            return ACD;
        }
        if ("ACM".equals(codeString)) {
            return ACM;
        }
        if ("ACV".equals(codeString)) {
            return ACV;
        }
        if ("C".equals(codeString)) {
            return C;
        }
        if ("CD".equals(codeString)) {
            return CD;
        }
        if ("CM".equals(codeString)) {
            return CM;
        }
        if ("CV".equals(codeString)) {
            return CV;
        }
        if ("HS".equals(codeString)) {
            return HS;
        }
        if ("IC".equals(codeString)) {
            return IC;
        }
        if ("ICD".equals(codeString)) {
            return ICD;
        }
        if ("ICM".equals(codeString)) {
            return ICM;
        }
        if ("ICV".equals(codeString)) {
            return ICV;
        }
        if ("PC".equals(codeString)) {
            return PC;
        }
        if ("PCD".equals(codeString)) {
            return PCD;
        }
        if ("PCM".equals(codeString)) {
            return PCM;
        }
        if ("PCV".equals(codeString)) {
            return PCV;
        }
        if ("WAKE".equals(codeString)) {
            return WAKE;
        }
        throw new FHIRException("Unknown V3TimingEvent code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case AC: {
                return "AC";
            }
            case ACD: {
                return "ACD";
            }
            case ACM: {
                return "ACM";
            }
            case ACV: {
                return "ACV";
            }
            case C: {
                return "C";
            }
            case CD: {
                return "CD";
            }
            case CM: {
                return "CM";
            }
            case CV: {
                return "CV";
            }
            case HS: {
                return "HS";
            }
            case IC: {
                return "IC";
            }
            case ICD: {
                return "ICD";
            }
            case ICM: {
                return "ICM";
            }
            case ICV: {
                return "ICV";
            }
            case PC: {
                return "PC";
            }
            case PCD: {
                return "PCD";
            }
            case PCM: {
                return "PCM";
            }
            case PCV: {
                return "PCV";
            }
            case WAKE: {
                return "WAKE";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/v3/TimingEvent";
    }

    public String getDefinition() {
        switch (this) {
            case AC: {
                return "before meal (from lat. ante cibus)";
            }
            case ACD: {
                return "before lunch (from lat. ante cibus diurnus)";
            }
            case ACM: {
                return "before breakfast (from lat. ante cibus matutinus)";
            }
            case ACV: {
                return "before dinner (from lat. ante cibus vespertinus)";
            }
            case C: {
                return "Description: meal (from lat. ante cibus)";
            }
            case CD: {
                return "Description: lunch (from lat. cibus diurnus)";
            }
            case CM: {
                return "Description: breakfast (from lat. cibus matutinus)";
            }
            case CV: {
                return "Description: dinner (from lat. cibus vespertinus)";
            }
            case HS: {
                return "Description: Prior to beginning a regular period of extended sleep (this would exclude naps).  Note that this might occur at different times of day depending on a person's regular sleep schedule.";
            }
            case IC: {
                return "between meals (from lat. inter cibus)";
            }
            case ICD: {
                return "between lunch and dinner";
            }
            case ICM: {
                return "between breakfast and lunch";
            }
            case ICV: {
                return "between dinner and the hour of sleep";
            }
            case PC: {
                return "after meal (from lat. post cibus)";
            }
            case PCD: {
                return "after lunch (from lat. post cibus diurnus)";
            }
            case PCM: {
                return "after breakfast (from lat. post cibus matutinus)";
            }
            case PCV: {
                return "after dinner (from lat. post cibus vespertinus)";
            }
            case WAKE: {
                return "Description: Upon waking up from a regular period of sleep, in order to start regular activities (this would exclude waking up from a nap or temporarily waking up during a period of sleep)\r\n\n                        \n                           Usage Notes: e.g.\r\n\n                        Take pulse rate on waking in management of thyrotoxicosis.\r\n\n                        Take BP on waking in management of hypertension\r\n\n                        Take basal body temperature on waking in establishing date of ovulation";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case AC: {
                return "AC";
            }
            case ACD: {
                return "ACD";
            }
            case ACM: {
                return "ACM";
            }
            case ACV: {
                return "ACV";
            }
            case C: {
                return "C";
            }
            case CD: {
                return "CD";
            }
            case CM: {
                return "CM";
            }
            case CV: {
                return "CV";
            }
            case HS: {
                return "HS";
            }
            case IC: {
                return "IC";
            }
            case ICD: {
                return "ICD";
            }
            case ICM: {
                return "ICM";
            }
            case ICV: {
                return "ICV";
            }
            case PC: {
                return "PC";
            }
            case PCD: {
                return "PCD";
            }
            case PCM: {
                return "PCM";
            }
            case PCV: {
                return "PCV";
            }
            case WAKE: {
                return "WAKE";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

