/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.UslabDoEvent;

public class UslabDoEventEnumFactory
implements EnumFactory<UslabDoEvent> {
    @Override
    public UslabDoEvent fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("new-request".equals(codeString)) {
            return UslabDoEvent.NEWREQUEST;
        }
        if ("add-on-request".equals(codeString)) {
            return UslabDoEvent.ADDONREQUEST;
        }
        if ("orderer-cancel".equals(codeString)) {
            return UslabDoEvent.ORDERERCANCEL;
        }
        if ("lab-cancel".equals(codeString)) {
            return UslabDoEvent.LABCANCEL;
        }
        throw new IllegalArgumentException("Unknown UslabDoEvent code '" + codeString + "'");
    }

    @Override
    public String toCode(UslabDoEvent code) {
        if (code == UslabDoEvent.NEWREQUEST) {
            return "new-request";
        }
        if (code == UslabDoEvent.ADDONREQUEST) {
            return "add-on-request";
        }
        if (code == UslabDoEvent.ORDERERCANCEL) {
            return "orderer-cancel";
        }
        if (code == UslabDoEvent.LABCANCEL) {
            return "lab-cancel";
        }
        return "?";
    }

    @Override
    public String toSystem(UslabDoEvent code) {
        return code.getSystem();
    }
}

