/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum PrecheckBehavior {
    YES,
    NO,
    NULL;


    public static PrecheckBehavior fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("yes".equals(codeString)) {
            return YES;
        }
        if ("no".equals(codeString)) {
            return NO;
        }
        throw new FHIRException("Unknown PrecheckBehavior code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case YES: {
                return "yes";
            }
            case NO: {
                return "no";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/precheck-behavior";
    }

    public String getDefinition() {
        switch (this) {
            case YES: {
                return "An item with this behavior is one of the most frequent items that is, or should be, included by an end user, for the particular context in which the item occurs. The system displaying the item to the end user should consider \"pre-checking\" such an item as a convenience for the user";
            }
            case NO: {
                return "An item with this behavior is one of the less frequent items included by the end user, for the particular context in which the item occurs. The system displaying the items to the end user would typically not \"pre-check\" such an item";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case YES: {
                return "Yes";
            }
            case NO: {
                return "No";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

