/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MeasureType {
    PROCESS,
    OUTCOME,
    NULL;


    public static MeasureType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("process".equals(codeString)) {
            return PROCESS;
        }
        if ("outcome".equals(codeString)) {
            return OUTCOME;
        }
        throw new FHIRException("Unknown MeasureType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PROCESS: {
                return "process";
            }
            case OUTCOME: {
                return "outcome";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/measure-type";
    }

    public String getDefinition() {
        switch (this) {
            case PROCESS: {
                return "The measure is a process measure";
            }
            case OUTCOME: {
                return "The measure is an outcome measure";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PROCESS: {
                return "Process";
            }
            case OUTCOME: {
                return "Outcome";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

